package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.entity.collection.request.GroupPolicyDefinitionCollectionRequest;
import odata.msgraph.client.beta.enums.GroupPolicyType;


/**
 * <i>“The entity represents an ADMX (Administrative Template) XML file. The ADMX file
 * contains a collection of group policy definitions and their locations by
 * category path. The group policy definition file also contains the languages
 * supported as determined by the language dependent ADML (Administrative Template)
 * language files.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "description", 
    "displayName", 
    "fileName", 
    "languageCodes", 
    "lastModifiedDateTime", 
    "policyType", 
    "revision", 
    "targetNamespace", 
    "targetPrefix"})
@JsonInclude(Include.NON_NULL)
public class GroupPolicyDefinitionFile extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.groupPolicyDefinitionFile";
    }

    @JsonProperty("description")
    protected String description;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("fileName")
    protected String fileName;

    @JsonProperty("languageCodes")
    protected List<String> languageCodes;

    @JsonProperty("languageCodes@nextLink")
    protected String languageCodesNextLink;

    @JsonProperty("lastModifiedDateTime")
    protected OffsetDateTime lastModifiedDateTime;

    @JsonProperty("policyType")
    protected GroupPolicyType policyType;

    @JsonProperty("revision")
    protected String revision;

    @JsonProperty("targetNamespace")
    protected String targetNamespace;

    @JsonProperty("targetPrefix")
    protected String targetPrefix;

    protected GroupPolicyDefinitionFile() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderGroupPolicyDefinitionFile() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String description;
        private String displayName;
        private String fileName;
        private List<String> languageCodes;
        private String languageCodesNextLink;
        private OffsetDateTime lastModifiedDateTime;
        private GroupPolicyType policyType;
        private String revision;
        private String targetNamespace;
        private String targetPrefix;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“The localized description of the policy settings in the ADMX file. The default
         * value is empty.”</i>
         * 
         * @param description
         *            value of {@code description} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        /**
         * <i>“The localized friendly name of the ADMX file.”</i>
         * 
         * @param displayName
         *            value of {@code displayName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        /**
         * <i>“The file name of the ADMX file without the path. For example: edge.admx”</i>
         * 
         * @param fileName
         *            value of {@code fileName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder fileName(String fileName) {
            this.fileName = fileName;
            this.changedFields = changedFields.add("fileName");
            return this;
        }

        /**
         * <i>“The supported language codes for the ADMX file.”</i>
         * 
         * @param languageCodes
         *            value of {@code languageCodes} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder languageCodes(List<String> languageCodes) {
            this.languageCodes = languageCodes;
            this.changedFields = changedFields.add("languageCodes");
            return this;
        }

        /**
         * <i>“The supported language codes for the ADMX file.”</i>
         * 
         * @param languageCodes
         *            value of {@code languageCodes} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder languageCodes(String... languageCodes) {
            return languageCodes(Arrays.asList(languageCodes));
        }

        /**
         * <i>“The supported language codes for the ADMX file.”</i>
         * 
         * @param languageCodesNextLink
         *            value of {@code languageCodes@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder languageCodesNextLink(String languageCodesNextLink) {
            this.languageCodesNextLink = languageCodesNextLink;
            this.changedFields = changedFields.add("languageCodes");
            return this;
        }

        /**
         * <i>“The date and time the entity was last modified.”</i>
         * 
         * @param lastModifiedDateTime
         *            value of {@code lastModifiedDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        /**
         * <i>“Specifies the type of group policy.”</i>
         * 
         * @param policyType
         *            value of {@code policyType} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder policyType(GroupPolicyType policyType) {
            this.policyType = policyType;
            this.changedFields = changedFields.add("policyType");
            return this;
        }

        /**
         * <i>“The revision version associated with the file.”</i>
         * 
         * @param revision
         *            value of {@code revision} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder revision(String revision) {
            this.revision = revision;
            this.changedFields = changedFields.add("revision");
            return this;
        }

        /**
         * <i>“Specifies the URI used to identify the namespace within the ADMX file.”</i>
         * 
         * @param targetNamespace
         *            value of {@code targetNamespace} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder targetNamespace(String targetNamespace) {
            this.targetNamespace = targetNamespace;
            this.changedFields = changedFields.add("targetNamespace");
            return this;
        }

        /**
         * <i>“Specifies the logical name that refers to the namespace within the ADMX file.”</i>
         * 
         * @param targetPrefix
         *            value of {@code targetPrefix} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder targetPrefix(String targetPrefix) {
            this.targetPrefix = targetPrefix;
            this.changedFields = changedFields.add("targetPrefix");
            return this;
        }

        public GroupPolicyDefinitionFile build() {
            GroupPolicyDefinitionFile _x = new GroupPolicyDefinitionFile();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.groupPolicyDefinitionFile";
            _x.id = id;
            _x.description = description;
            _x.displayName = displayName;
            _x.fileName = fileName;
            _x.languageCodes = languageCodes;
            _x.languageCodesNextLink = languageCodesNextLink;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.policyType = policyType;
            _x.revision = revision;
            _x.targetNamespace = targetNamespace;
            _x.targetPrefix = targetPrefix;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“The localized description of the policy settings in the ADMX file. The default
     * value is empty.”</i>
     * 
     * @return property description
     */
    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code description}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The localized description of the policy settings in the ADMX file. The default
     * value is empty.”</i>
     * 
     * @param description
     *            new value of {@code description} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code description} field changed
     */
    public GroupPolicyDefinitionFile withDescription(String description) {
        GroupPolicyDefinitionFile _x = _copy();
        _x.changedFields = changedFields.add("description");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.groupPolicyDefinitionFile");
        _x.description = description;
        return _x;
    }

    /**
     * <i>“The localized friendly name of the ADMX file.”</i>
     * 
     * @return property displayName
     */
    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code displayName}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The localized friendly name of the ADMX file.”</i>
     * 
     * @param displayName
     *            new value of {@code displayName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code displayName} field changed
     */
    public GroupPolicyDefinitionFile withDisplayName(String displayName) {
        GroupPolicyDefinitionFile _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.groupPolicyDefinitionFile");
        _x.displayName = displayName;
        return _x;
    }

    /**
     * <i>“The file name of the ADMX file without the path. For example: edge.admx”</i>
     * 
     * @return property fileName
     */
    @Property(name="fileName")
    @JsonIgnore
    public Optional<String> getFileName() {
        return Optional.ofNullable(fileName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code fileName} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The file name of the ADMX file without the path. For example: edge.admx”</i>
     * 
     * @param fileName
     *            new value of {@code fileName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code fileName} field changed
     */
    public GroupPolicyDefinitionFile withFileName(String fileName) {
        GroupPolicyDefinitionFile _x = _copy();
        _x.changedFields = changedFields.add("fileName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.groupPolicyDefinitionFile");
        _x.fileName = fileName;
        return _x;
    }

    /**
     * <i>“The supported language codes for the ADMX file.”</i>
     * 
     * @return property languageCodes
     */
    @Property(name="languageCodes")
    @JsonIgnore
    public CollectionPage<String> getLanguageCodes() {
        return new CollectionPage<String>(contextPath, String.class, this.languageCodes, Optional.ofNullable(languageCodesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code languageCodes}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The supported language codes for the ADMX file.”</i>
     * 
     * @param languageCodes
     *            new value of {@code languageCodes} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code languageCodes} field changed
     */
    public GroupPolicyDefinitionFile withLanguageCodes(List<String> languageCodes) {
        GroupPolicyDefinitionFile _x = _copy();
        _x.changedFields = changedFields.add("languageCodes");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.groupPolicyDefinitionFile");
        _x.languageCodes = languageCodes;
        return _x;
    }

    /**
     * <i>“The supported language codes for the ADMX file.”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property languageCodes
     */
    @Property(name="languageCodes")
    @JsonIgnore
    public CollectionPage<String> getLanguageCodes(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.languageCodes, Optional.ofNullable(languageCodesNextLink), Collections.emptyList(), options);
    }

    /**
     * <i>“The date and time the entity was last modified.”</i>
     * 
     * @return property lastModifiedDateTime
     */
    @Property(name="lastModifiedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastModifiedDateTime() {
        return Optional.ofNullable(lastModifiedDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * lastModifiedDateTime} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The date and time the entity was last modified.”</i>
     * 
     * @param lastModifiedDateTime
     *            new value of {@code lastModifiedDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code lastModifiedDateTime} field changed
     */
    public GroupPolicyDefinitionFile withLastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
        GroupPolicyDefinitionFile _x = _copy();
        _x.changedFields = changedFields.add("lastModifiedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.groupPolicyDefinitionFile");
        _x.lastModifiedDateTime = lastModifiedDateTime;
        return _x;
    }

    /**
     * <i>“Specifies the type of group policy.”</i>
     * 
     * @return property policyType
     */
    @Property(name="policyType")
    @JsonIgnore
    public Optional<GroupPolicyType> getPolicyType() {
        return Optional.ofNullable(policyType);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code policyType} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Specifies the type of group policy.”</i>
     * 
     * @param policyType
     *            new value of {@code policyType} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code policyType} field changed
     */
    public GroupPolicyDefinitionFile withPolicyType(GroupPolicyType policyType) {
        GroupPolicyDefinitionFile _x = _copy();
        _x.changedFields = changedFields.add("policyType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.groupPolicyDefinitionFile");
        _x.policyType = policyType;
        return _x;
    }

    /**
     * <i>“The revision version associated with the file.”</i>
     * 
     * @return property revision
     */
    @Property(name="revision")
    @JsonIgnore
    public Optional<String> getRevision() {
        return Optional.ofNullable(revision);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code revision} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The revision version associated with the file.”</i>
     * 
     * @param revision
     *            new value of {@code revision} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code revision} field changed
     */
    public GroupPolicyDefinitionFile withRevision(String revision) {
        GroupPolicyDefinitionFile _x = _copy();
        _x.changedFields = changedFields.add("revision");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.groupPolicyDefinitionFile");
        _x.revision = revision;
        return _x;
    }

    /**
     * <i>“Specifies the URI used to identify the namespace within the ADMX file.”</i>
     * 
     * @return property targetNamespace
     */
    @Property(name="targetNamespace")
    @JsonIgnore
    public Optional<String> getTargetNamespace() {
        return Optional.ofNullable(targetNamespace);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code targetNamespace}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Specifies the URI used to identify the namespace within the ADMX file.”</i>
     * 
     * @param targetNamespace
     *            new value of {@code targetNamespace} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code targetNamespace} field changed
     */
    public GroupPolicyDefinitionFile withTargetNamespace(String targetNamespace) {
        GroupPolicyDefinitionFile _x = _copy();
        _x.changedFields = changedFields.add("targetNamespace");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.groupPolicyDefinitionFile");
        _x.targetNamespace = targetNamespace;
        return _x;
    }

    /**
     * <i>“Specifies the logical name that refers to the namespace within the ADMX file.”</i>
     * 
     * @return property targetPrefix
     */
    @Property(name="targetPrefix")
    @JsonIgnore
    public Optional<String> getTargetPrefix() {
        return Optional.ofNullable(targetPrefix);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code targetPrefix}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Specifies the logical name that refers to the namespace within the ADMX file.”</i>
     * 
     * @param targetPrefix
     *            new value of {@code targetPrefix} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code targetPrefix} field changed
     */
    public GroupPolicyDefinitionFile withTargetPrefix(String targetPrefix) {
        GroupPolicyDefinitionFile _x = _copy();
        _x.changedFields = changedFields.add("targetPrefix");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.groupPolicyDefinitionFile");
        _x.targetPrefix = targetPrefix;
        return _x;
    }

    public GroupPolicyDefinitionFile withUnmappedField(String name, Object value) {
        GroupPolicyDefinitionFile _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    /**
     * <i>“The group policy definitions associated with the file.”</i>
     * 
     * @return navigational property definitions
     */
    @NavigationProperty(name="definitions")
    @JsonIgnore
    public GroupPolicyDefinitionCollectionRequest getDefinitions() {
        return new GroupPolicyDefinitionCollectionRequest(
                        contextPath.addSegment("definitions"), RequestHelper.getValue(unmappedFields, "definitions"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public GroupPolicyDefinitionFile patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        GroupPolicyDefinitionFile _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public GroupPolicyDefinitionFile put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        GroupPolicyDefinitionFile _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private GroupPolicyDefinitionFile _copy() {
        GroupPolicyDefinitionFile _x = new GroupPolicyDefinitionFile();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.description = description;
        _x.displayName = displayName;
        _x.fileName = fileName;
        _x.languageCodes = languageCodes;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.policyType = policyType;
        _x.revision = revision;
        _x.targetNamespace = targetNamespace;
        _x.targetPrefix = targetPrefix;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("GroupPolicyDefinitionFile[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("fileName=");
        b.append(this.fileName);
        b.append(", ");
        b.append("languageCodes=");
        b.append(this.languageCodes);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("policyType=");
        b.append(this.policyType);
        b.append(", ");
        b.append("revision=");
        b.append(this.revision);
        b.append(", ");
        b.append("targetNamespace=");
        b.append(this.targetNamespace);
        b.append(", ");
        b.append("targetPrefix=");
        b.append(this.targetPrefix);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
