package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.UUID;

import odata.msgraph.client.beta.entity.collection.request.GroupPolicyPresentationCollectionRequest;
import odata.msgraph.client.beta.entity.request.GroupPolicyCategoryRequest;
import odata.msgraph.client.beta.entity.request.GroupPolicyDefinitionFileRequest;
import odata.msgraph.client.beta.entity.request.GroupPolicyDefinitionRequest;
import odata.msgraph.client.beta.enums.GroupPolicyDefinitionClassType;
import odata.msgraph.client.beta.enums.GroupPolicyType;


/**
 * <i>“The entity describes all of the information about a single group policy.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "categoryPath", 
    "classType", 
    "displayName", 
    "explainText", 
    "groupPolicyCategoryId", 
    "hasRelatedDefinitions", 
    "lastModifiedDateTime", 
    "minDeviceCspVersion", 
    "minUserCspVersion", 
    "policyType", 
    "supportedOn", 
    "version", 
    "nextVersionDefinition", 
    "presentations", 
    "previousVersionDefinition"})
@JsonInclude(Include.NON_NULL)
public class GroupPolicyDefinition extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.groupPolicyDefinition";
    }

    @JsonProperty("categoryPath")
    protected String categoryPath;

    @JsonProperty("classType")
    protected GroupPolicyDefinitionClassType classType;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("explainText")
    protected String explainText;

    @JsonProperty("groupPolicyCategoryId")
    protected UUID groupPolicyCategoryId;

    @JsonProperty("hasRelatedDefinitions")
    protected Boolean hasRelatedDefinitions;

    @JsonProperty("lastModifiedDateTime")
    protected OffsetDateTime lastModifiedDateTime;

    @JsonProperty("minDeviceCspVersion")
    protected String minDeviceCspVersion;

    @JsonProperty("minUserCspVersion")
    protected String minUserCspVersion;

    @JsonProperty("policyType")
    protected GroupPolicyType policyType;

    @JsonProperty("supportedOn")
    protected String supportedOn;

    @JsonProperty("version")
    protected String version;

    @JsonProperty("nextVersionDefinition")
    protected GroupPolicyDefinition nextVersionDefinition;

    @JsonProperty("presentations")
    protected List<GroupPolicyPresentation> presentations;

    @JsonProperty("previousVersionDefinition")
    protected GroupPolicyDefinition previousVersionDefinition;

    protected GroupPolicyDefinition() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderGroupPolicyDefinition() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String categoryPath;
        private GroupPolicyDefinitionClassType classType;
        private String displayName;
        private String explainText;
        private UUID groupPolicyCategoryId;
        private Boolean hasRelatedDefinitions;
        private OffsetDateTime lastModifiedDateTime;
        private String minDeviceCspVersion;
        private String minUserCspVersion;
        private GroupPolicyType policyType;
        private String supportedOn;
        private String version;
        private GroupPolicyDefinition nextVersionDefinition;
        private List<GroupPolicyPresentation> presentations;
        private GroupPolicyDefinition previousVersionDefinition;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“The localized full category path for the policy.”</i>
         * 
         * @param categoryPath
         *            value of {@code categoryPath} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder categoryPath(String categoryPath) {
            this.categoryPath = categoryPath;
            this.changedFields = changedFields.add("categoryPath");
            return this;
        }

        /**
         * <i>“Identifies the type of groups the policy can be applied to.”</i>
         * 
         * @param classType
         *            value of {@code classType} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder classType(GroupPolicyDefinitionClassType classType) {
            this.classType = classType;
            this.changedFields = changedFields.add("classType");
            return this;
        }

        /**
         * <i>“The localized policy name.”</i>
         * 
         * @param displayName
         *            value of {@code displayName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        /**
         * <i>“The localized explanation or help text associated with the policy. The default
         * value is empty.”</i>
         * 
         * @param explainText
         *            value of {@code explainText} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder explainText(String explainText) {
            this.explainText = explainText;
            this.changedFields = changedFields.add("explainText");
            return this;
        }

        /**
         * <i>“The category id of the parent category”</i>
         * 
         * @param groupPolicyCategoryId
         *            value of {@code groupPolicyCategoryId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder groupPolicyCategoryId(UUID groupPolicyCategoryId) {
            this.groupPolicyCategoryId = groupPolicyCategoryId;
            this.changedFields = changedFields.add("groupPolicyCategoryId");
            return this;
        }

        /**
         * <i>“Signifies whether or not there are related definitions to this definition”</i>
         * 
         * @param hasRelatedDefinitions
         *            value of {@code hasRelatedDefinitions} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder hasRelatedDefinitions(Boolean hasRelatedDefinitions) {
            this.hasRelatedDefinitions = hasRelatedDefinitions;
            this.changedFields = changedFields.add("hasRelatedDefinitions");
            return this;
        }

        /**
         * <i>“The date and time the entity was last modified.”</i>
         * 
         * @param lastModifiedDateTime
         *            value of {@code lastModifiedDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        /**
         * <i>“Minimum required CSP version for device configuration in this definition”</i>
         * 
         * @param minDeviceCspVersion
         *            value of {@code minDeviceCspVersion} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder minDeviceCspVersion(String minDeviceCspVersion) {
            this.minDeviceCspVersion = minDeviceCspVersion;
            this.changedFields = changedFields.add("minDeviceCspVersion");
            return this;
        }

        /**
         * <i>“Minimum required CSP version for user configuration in this definition”</i>
         * 
         * @param minUserCspVersion
         *            value of {@code minUserCspVersion} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder minUserCspVersion(String minUserCspVersion) {
            this.minUserCspVersion = minUserCspVersion;
            this.changedFields = changedFields.add("minUserCspVersion");
            return this;
        }

        /**
         * <i>“Specifies the type of group policy.”</i>
         * 
         * @param policyType
         *            value of {@code policyType} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder policyType(GroupPolicyType policyType) {
            this.policyType = policyType;
            this.changedFields = changedFields.add("policyType");
            return this;
        }

        /**
         * <i>“Localized string used to specify what operating system or application version is
         * affected by the policy.”</i>
         * 
         * @param supportedOn
         *            value of {@code supportedOn} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder supportedOn(String supportedOn) {
            this.supportedOn = supportedOn;
            this.changedFields = changedFields.add("supportedOn");
            return this;
        }

        /**
         * <i>“Setting definition version”</i>
         * 
         * @param version
         *            value of {@code version} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder version(String version) {
            this.version = version;
            this.changedFields = changedFields.add("version");
            return this;
        }

        /**
         * <i>“Definition of the next version of this definition”</i>
         * 
         * @param nextVersionDefinition
         *            value of {@code nextVersionDefinition} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder nextVersionDefinition(GroupPolicyDefinition nextVersionDefinition) {
            this.nextVersionDefinition = nextVersionDefinition;
            this.changedFields = changedFields.add("nextVersionDefinition");
            return this;
        }

        /**
         * <i>“The group policy presentations associated with the definition.”</i>
         * 
         * @param presentations
         *            value of {@code presentations} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder presentations(List<GroupPolicyPresentation> presentations) {
            this.presentations = presentations;
            this.changedFields = changedFields.add("presentations");
            return this;
        }

        /**
         * <i>“The group policy presentations associated with the definition.”</i>
         * 
         * @param presentations
         *            value of {@code presentations} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder presentations(GroupPolicyPresentation... presentations) {
            return presentations(Arrays.asList(presentations));
        }

        /**
         * <i>“Definition of the previous version of this definition”</i>
         * 
         * @param previousVersionDefinition
         *            value of {@code previousVersionDefinition} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder previousVersionDefinition(GroupPolicyDefinition previousVersionDefinition) {
            this.previousVersionDefinition = previousVersionDefinition;
            this.changedFields = changedFields.add("previousVersionDefinition");
            return this;
        }

        public GroupPolicyDefinition build() {
            GroupPolicyDefinition _x = new GroupPolicyDefinition();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.groupPolicyDefinition";
            _x.id = id;
            _x.categoryPath = categoryPath;
            _x.classType = classType;
            _x.displayName = displayName;
            _x.explainText = explainText;
            _x.groupPolicyCategoryId = groupPolicyCategoryId;
            _x.hasRelatedDefinitions = hasRelatedDefinitions;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.minDeviceCspVersion = minDeviceCspVersion;
            _x.minUserCspVersion = minUserCspVersion;
            _x.policyType = policyType;
            _x.supportedOn = supportedOn;
            _x.version = version;
            _x.nextVersionDefinition = nextVersionDefinition;
            _x.presentations = presentations;
            _x.previousVersionDefinition = previousVersionDefinition;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“The localized full category path for the policy.”</i>
     * 
     * @return property categoryPath
     */
    @Property(name="categoryPath")
    @JsonIgnore
    public Optional<String> getCategoryPath() {
        return Optional.ofNullable(categoryPath);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code categoryPath}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The localized full category path for the policy.”</i>
     * 
     * @param categoryPath
     *            new value of {@code categoryPath} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code categoryPath} field changed
     */
    public GroupPolicyDefinition withCategoryPath(String categoryPath) {
        GroupPolicyDefinition _x = _copy();
        _x.changedFields = changedFields.add("categoryPath");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.groupPolicyDefinition");
        _x.categoryPath = categoryPath;
        return _x;
    }

    /**
     * <i>“Identifies the type of groups the policy can be applied to.”</i>
     * 
     * @return property classType
     */
    @Property(name="classType")
    @JsonIgnore
    public Optional<GroupPolicyDefinitionClassType> getClassType() {
        return Optional.ofNullable(classType);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code classType} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Identifies the type of groups the policy can be applied to.”</i>
     * 
     * @param classType
     *            new value of {@code classType} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code classType} field changed
     */
    public GroupPolicyDefinition withClassType(GroupPolicyDefinitionClassType classType) {
        GroupPolicyDefinition _x = _copy();
        _x.changedFields = changedFields.add("classType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.groupPolicyDefinition");
        _x.classType = classType;
        return _x;
    }

    /**
     * <i>“The localized policy name.”</i>
     * 
     * @return property displayName
     */
    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code displayName}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The localized policy name.”</i>
     * 
     * @param displayName
     *            new value of {@code displayName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code displayName} field changed
     */
    public GroupPolicyDefinition withDisplayName(String displayName) {
        GroupPolicyDefinition _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.groupPolicyDefinition");
        _x.displayName = displayName;
        return _x;
    }

    /**
     * <i>“The localized explanation or help text associated with the policy. The default
     * value is empty.”</i>
     * 
     * @return property explainText
     */
    @Property(name="explainText")
    @JsonIgnore
    public Optional<String> getExplainText() {
        return Optional.ofNullable(explainText);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code explainText}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The localized explanation or help text associated with the policy. The default
     * value is empty.”</i>
     * 
     * @param explainText
     *            new value of {@code explainText} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code explainText} field changed
     */
    public GroupPolicyDefinition withExplainText(String explainText) {
        GroupPolicyDefinition _x = _copy();
        _x.changedFields = changedFields.add("explainText");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.groupPolicyDefinition");
        _x.explainText = explainText;
        return _x;
    }

    /**
     * <i>“The category id of the parent category”</i>
     * 
     * @return property groupPolicyCategoryId
     */
    @Property(name="groupPolicyCategoryId")
    @JsonIgnore
    public Optional<UUID> getGroupPolicyCategoryId() {
        return Optional.ofNullable(groupPolicyCategoryId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * groupPolicyCategoryId} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The category id of the parent category”</i>
     * 
     * @param groupPolicyCategoryId
     *            new value of {@code groupPolicyCategoryId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code groupPolicyCategoryId} field changed
     */
    public GroupPolicyDefinition withGroupPolicyCategoryId(UUID groupPolicyCategoryId) {
        GroupPolicyDefinition _x = _copy();
        _x.changedFields = changedFields.add("groupPolicyCategoryId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.groupPolicyDefinition");
        _x.groupPolicyCategoryId = groupPolicyCategoryId;
        return _x;
    }

    /**
     * <i>“Signifies whether or not there are related definitions to this definition”</i>
     * 
     * @return property hasRelatedDefinitions
     */
    @Property(name="hasRelatedDefinitions")
    @JsonIgnore
    public Optional<Boolean> getHasRelatedDefinitions() {
        return Optional.ofNullable(hasRelatedDefinitions);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * hasRelatedDefinitions} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Signifies whether or not there are related definitions to this definition”</i>
     * 
     * @param hasRelatedDefinitions
     *            new value of {@code hasRelatedDefinitions} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code hasRelatedDefinitions} field changed
     */
    public GroupPolicyDefinition withHasRelatedDefinitions(Boolean hasRelatedDefinitions) {
        GroupPolicyDefinition _x = _copy();
        _x.changedFields = changedFields.add("hasRelatedDefinitions");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.groupPolicyDefinition");
        _x.hasRelatedDefinitions = hasRelatedDefinitions;
        return _x;
    }

    /**
     * <i>“The date and time the entity was last modified.”</i>
     * 
     * @return property lastModifiedDateTime
     */
    @Property(name="lastModifiedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastModifiedDateTime() {
        return Optional.ofNullable(lastModifiedDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * lastModifiedDateTime} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The date and time the entity was last modified.”</i>
     * 
     * @param lastModifiedDateTime
     *            new value of {@code lastModifiedDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code lastModifiedDateTime} field changed
     */
    public GroupPolicyDefinition withLastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
        GroupPolicyDefinition _x = _copy();
        _x.changedFields = changedFields.add("lastModifiedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.groupPolicyDefinition");
        _x.lastModifiedDateTime = lastModifiedDateTime;
        return _x;
    }

    /**
     * <i>“Minimum required CSP version for device configuration in this definition”</i>
     * 
     * @return property minDeviceCspVersion
     */
    @Property(name="minDeviceCspVersion")
    @JsonIgnore
    public Optional<String> getMinDeviceCspVersion() {
        return Optional.ofNullable(minDeviceCspVersion);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * minDeviceCspVersion} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Minimum required CSP version for device configuration in this definition”</i>
     * 
     * @param minDeviceCspVersion
     *            new value of {@code minDeviceCspVersion} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code minDeviceCspVersion} field changed
     */
    public GroupPolicyDefinition withMinDeviceCspVersion(String minDeviceCspVersion) {
        GroupPolicyDefinition _x = _copy();
        _x.changedFields = changedFields.add("minDeviceCspVersion");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.groupPolicyDefinition");
        _x.minDeviceCspVersion = minDeviceCspVersion;
        return _x;
    }

    /**
     * <i>“Minimum required CSP version for user configuration in this definition”</i>
     * 
     * @return property minUserCspVersion
     */
    @Property(name="minUserCspVersion")
    @JsonIgnore
    public Optional<String> getMinUserCspVersion() {
        return Optional.ofNullable(minUserCspVersion);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code minUserCspVersion
     * } field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Minimum required CSP version for user configuration in this definition”</i>
     * 
     * @param minUserCspVersion
     *            new value of {@code minUserCspVersion} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code minUserCspVersion} field changed
     */
    public GroupPolicyDefinition withMinUserCspVersion(String minUserCspVersion) {
        GroupPolicyDefinition _x = _copy();
        _x.changedFields = changedFields.add("minUserCspVersion");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.groupPolicyDefinition");
        _x.minUserCspVersion = minUserCspVersion;
        return _x;
    }

    /**
     * <i>“Specifies the type of group policy.”</i>
     * 
     * @return property policyType
     */
    @Property(name="policyType")
    @JsonIgnore
    public Optional<GroupPolicyType> getPolicyType() {
        return Optional.ofNullable(policyType);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code policyType} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Specifies the type of group policy.”</i>
     * 
     * @param policyType
     *            new value of {@code policyType} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code policyType} field changed
     */
    public GroupPolicyDefinition withPolicyType(GroupPolicyType policyType) {
        GroupPolicyDefinition _x = _copy();
        _x.changedFields = changedFields.add("policyType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.groupPolicyDefinition");
        _x.policyType = policyType;
        return _x;
    }

    /**
     * <i>“Localized string used to specify what operating system or application version is
     * affected by the policy.”</i>
     * 
     * @return property supportedOn
     */
    @Property(name="supportedOn")
    @JsonIgnore
    public Optional<String> getSupportedOn() {
        return Optional.ofNullable(supportedOn);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code supportedOn}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Localized string used to specify what operating system or application version is
     * affected by the policy.”</i>
     * 
     * @param supportedOn
     *            new value of {@code supportedOn} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code supportedOn} field changed
     */
    public GroupPolicyDefinition withSupportedOn(String supportedOn) {
        GroupPolicyDefinition _x = _copy();
        _x.changedFields = changedFields.add("supportedOn");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.groupPolicyDefinition");
        _x.supportedOn = supportedOn;
        return _x;
    }

    /**
     * <i>“Setting definition version”</i>
     * 
     * @return property version
     */
    @Property(name="version")
    @JsonIgnore
    public Optional<String> getVersion() {
        return Optional.ofNullable(version);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code version} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Setting definition version”</i>
     * 
     * @param version
     *            new value of {@code version} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code version} field changed
     */
    public GroupPolicyDefinition withVersion(String version) {
        GroupPolicyDefinition _x = _copy();
        _x.changedFields = changedFields.add("version");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.groupPolicyDefinition");
        _x.version = version;
        return _x;
    }

    public GroupPolicyDefinition withUnmappedField(String name, Object value) {
        GroupPolicyDefinition _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    /**
     * <i>“The group policy category associated with the definition.”</i>
     * 
     * @return navigational property category
     */
    @NavigationProperty(name="category")
    @JsonIgnore
    public GroupPolicyCategoryRequest getCategory() {
        return new GroupPolicyCategoryRequest(contextPath.addSegment("category"), RequestHelper.getValue(unmappedFields, "category"));
    }

    /**
     * <i>“The group policy file associated with the definition.”</i>
     * 
     * @return navigational property definitionFile
     */
    @NavigationProperty(name="definitionFile")
    @JsonIgnore
    public GroupPolicyDefinitionFileRequest getDefinitionFile() {
        return new GroupPolicyDefinitionFileRequest(contextPath.addSegment("definitionFile"), RequestHelper.getValue(unmappedFields, "definitionFile"));
    }

    /**
     * <i>“Definition of the next version of this definition”</i>
     * 
     * @return navigational property nextVersionDefinition
     */
    @NavigationProperty(name="nextVersionDefinition")
    @JsonIgnore
    public GroupPolicyDefinitionRequest getNextVersionDefinition() {
        return new GroupPolicyDefinitionRequest(contextPath.addSegment("nextVersionDefinition"), Optional.ofNullable(nextVersionDefinition));
    }

    /**
     * <i>“The group policy presentations associated with the definition.”</i>
     * 
     * @return navigational property presentations
     */
    @NavigationProperty(name="presentations")
    @JsonIgnore
    public GroupPolicyPresentationCollectionRequest getPresentations() {
        return new GroupPolicyPresentationCollectionRequest(
                        contextPath.addSegment("presentations"), Optional.ofNullable(presentations));
    }

    /**
     * <i>“Definition of the previous version of this definition”</i>
     * 
     * @return navigational property previousVersionDefinition
     */
    @NavigationProperty(name="previousVersionDefinition")
    @JsonIgnore
    public GroupPolicyDefinitionRequest getPreviousVersionDefinition() {
        return new GroupPolicyDefinitionRequest(contextPath.addSegment("previousVersionDefinition"), Optional.ofNullable(previousVersionDefinition));
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * nextVersionDefinition} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Definition of the next version of this definition”</i>
     * 
     * @param nextVersionDefinition
     *            new value of {@code nextVersionDefinition} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code nextVersionDefinition} field changed
     */
    public GroupPolicyDefinition withNextVersionDefinition(GroupPolicyDefinition nextVersionDefinition) {
        GroupPolicyDefinition _x = _copy();
        _x.changedFields = changedFields.add("nextVersionDefinition");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.groupPolicyDefinition");
        _x.nextVersionDefinition = nextVersionDefinition;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code presentations}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The group policy presentations associated with the definition.”</i>
     * 
     * @param presentations
     *            new value of {@code presentations} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code presentations} field changed
     */
    public GroupPolicyDefinition withPresentations(List<GroupPolicyPresentation> presentations) {
        GroupPolicyDefinition _x = _copy();
        _x.changedFields = changedFields.add("presentations");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.groupPolicyDefinition");
        _x.presentations = presentations;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * previousVersionDefinition} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Definition of the previous version of this definition”</i>
     * 
     * @param previousVersionDefinition
     *            new value of {@code previousVersionDefinition} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code previousVersionDefinition} field changed
     */
    public GroupPolicyDefinition withPreviousVersionDefinition(GroupPolicyDefinition previousVersionDefinition) {
        GroupPolicyDefinition _x = _copy();
        _x.changedFields = changedFields.add("previousVersionDefinition");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.groupPolicyDefinition");
        _x.previousVersionDefinition = previousVersionDefinition;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public GroupPolicyDefinition patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        GroupPolicyDefinition _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public GroupPolicyDefinition put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        GroupPolicyDefinition _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private GroupPolicyDefinition _copy() {
        GroupPolicyDefinition _x = new GroupPolicyDefinition();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.categoryPath = categoryPath;
        _x.classType = classType;
        _x.displayName = displayName;
        _x.explainText = explainText;
        _x.groupPolicyCategoryId = groupPolicyCategoryId;
        _x.hasRelatedDefinitions = hasRelatedDefinitions;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.minDeviceCspVersion = minDeviceCspVersion;
        _x.minUserCspVersion = minUserCspVersion;
        _x.policyType = policyType;
        _x.supportedOn = supportedOn;
        _x.version = version;
        _x.nextVersionDefinition = nextVersionDefinition;
        _x.presentations = presentations;
        _x.previousVersionDefinition = previousVersionDefinition;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("GroupPolicyDefinition[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("categoryPath=");
        b.append(this.categoryPath);
        b.append(", ");
        b.append("classType=");
        b.append(this.classType);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("explainText=");
        b.append(this.explainText);
        b.append(", ");
        b.append("groupPolicyCategoryId=");
        b.append(this.groupPolicyCategoryId);
        b.append(", ");
        b.append("hasRelatedDefinitions=");
        b.append(this.hasRelatedDefinitions);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("minDeviceCspVersion=");
        b.append(this.minDeviceCspVersion);
        b.append(", ");
        b.append("minUserCspVersion=");
        b.append(this.minUserCspVersion);
        b.append(", ");
        b.append("policyType=");
        b.append(this.policyType);
        b.append(", ");
        b.append("supportedOn=");
        b.append(this.supportedOn);
        b.append(", ");
        b.append("version=");
        b.append(this.version);
        b.append(", ");
        b.append("nextVersionDefinition=");
        b.append(this.nextVersionDefinition);
        b.append(", ");
        b.append("presentations=");
        b.append(this.presentations);
        b.append(", ");
        b.append("previousVersionDefinition=");
        b.append(this.previousVersionDefinition);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
