package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.entity.collection.request.GroupPolicyCategoryCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.GroupPolicyDefinitionCollectionRequest;
import odata.msgraph.client.beta.entity.request.GroupPolicyCategoryRequest;
import odata.msgraph.client.beta.entity.request.GroupPolicyDefinitionFileRequest;


/**
 * <i>“The category entity stores the category of a group policy definition”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "displayName", 
    "isRoot", 
    "lastModifiedDateTime"})
@JsonInclude(Include.NON_NULL)
public class GroupPolicyCategory extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.groupPolicyCategory";
    }

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("isRoot")
    protected Boolean isRoot;

    @JsonProperty("lastModifiedDateTime")
    protected OffsetDateTime lastModifiedDateTime;

    protected GroupPolicyCategory() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderGroupPolicyCategory() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String displayName;
        private Boolean isRoot;
        private OffsetDateTime lastModifiedDateTime;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“The string id of the category's display name”</i>
         * 
         * @param displayName
         *            value of {@code displayName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        /**
         * <i>“Defines if the category is a root category”</i>
         * 
         * @param isRoot
         *            value of {@code isRoot} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder isRoot(Boolean isRoot) {
            this.isRoot = isRoot;
            this.changedFields = changedFields.add("isRoot");
            return this;
        }

        /**
         * <i>“The date and time the entity was last modified.”</i>
         * 
         * @param lastModifiedDateTime
         *            value of {@code lastModifiedDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public GroupPolicyCategory build() {
            GroupPolicyCategory _x = new GroupPolicyCategory();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.groupPolicyCategory";
            _x.id = id;
            _x.displayName = displayName;
            _x.isRoot = isRoot;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“The string id of the category's display name”</i>
     * 
     * @return property displayName
     */
    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code displayName}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The string id of the category's display name”</i>
     * 
     * @param displayName
     *            new value of {@code displayName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code displayName} field changed
     */
    public GroupPolicyCategory withDisplayName(String displayName) {
        GroupPolicyCategory _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.groupPolicyCategory");
        _x.displayName = displayName;
        return _x;
    }

    /**
     * <i>“Defines if the category is a root category”</i>
     * 
     * @return property isRoot
     */
    @Property(name="isRoot")
    @JsonIgnore
    public Optional<Boolean> getIsRoot() {
        return Optional.ofNullable(isRoot);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code isRoot} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Defines if the category is a root category”</i>
     * 
     * @param isRoot
     *            new value of {@code isRoot} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code isRoot} field changed
     */
    public GroupPolicyCategory withIsRoot(Boolean isRoot) {
        GroupPolicyCategory _x = _copy();
        _x.changedFields = changedFields.add("isRoot");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.groupPolicyCategory");
        _x.isRoot = isRoot;
        return _x;
    }

    /**
     * <i>“The date and time the entity was last modified.”</i>
     * 
     * @return property lastModifiedDateTime
     */
    @Property(name="lastModifiedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastModifiedDateTime() {
        return Optional.ofNullable(lastModifiedDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * lastModifiedDateTime} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The date and time the entity was last modified.”</i>
     * 
     * @param lastModifiedDateTime
     *            new value of {@code lastModifiedDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code lastModifiedDateTime} field changed
     */
    public GroupPolicyCategory withLastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
        GroupPolicyCategory _x = _copy();
        _x.changedFields = changedFields.add("lastModifiedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.groupPolicyCategory");
        _x.lastModifiedDateTime = lastModifiedDateTime;
        return _x;
    }

    public GroupPolicyCategory withUnmappedField(String name, Object value) {
        GroupPolicyCategory _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    /**
     * <i>“The children categories”</i>
     * 
     * @return navigational property children
     */
    @NavigationProperty(name="children")
    @JsonIgnore
    public GroupPolicyCategoryCollectionRequest getChildren() {
        return new GroupPolicyCategoryCollectionRequest(
                        contextPath.addSegment("children"), RequestHelper.getValue(unmappedFields, "children"));
    }

    /**
     * <i>“The id of the definition file the category came from”</i>
     * 
     * @return navigational property definitionFile
     */
    @NavigationProperty(name="definitionFile")
    @JsonIgnore
    public GroupPolicyDefinitionFileRequest getDefinitionFile() {
        return new GroupPolicyDefinitionFileRequest(contextPath.addSegment("definitionFile"), RequestHelper.getValue(unmappedFields, "definitionFile"));
    }

    /**
     * <i>“The immediate GroupPolicyDefinition children of the category”</i>
     * 
     * @return navigational property definitions
     */
    @NavigationProperty(name="definitions")
    @JsonIgnore
    public GroupPolicyDefinitionCollectionRequest getDefinitions() {
        return new GroupPolicyDefinitionCollectionRequest(
                        contextPath.addSegment("definitions"), RequestHelper.getValue(unmappedFields, "definitions"));
    }

    /**
     * <i>“The parent category”</i>
     * 
     * @return navigational property parent
     */
    @NavigationProperty(name="parent")
    @JsonIgnore
    public GroupPolicyCategoryRequest getParent() {
        return new GroupPolicyCategoryRequest(contextPath.addSegment("parent"), RequestHelper.getValue(unmappedFields, "parent"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public GroupPolicyCategory patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        GroupPolicyCategory _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public GroupPolicyCategory put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        GroupPolicyCategory _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private GroupPolicyCategory _copy() {
        GroupPolicyCategory _x = new GroupPolicyCategory();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.displayName = displayName;
        _x.isRoot = isRoot;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("GroupPolicyCategory[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("isRoot=");
        b.append(this.isRoot);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
