package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.GovernanceRuleSetting;
import odata.msgraph.client.beta.entity.request.GovernanceResourceRequest;
import odata.msgraph.client.beta.entity.request.GovernanceRoleDefinitionRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "adminEligibleSettings", 
    "adminMemberSettings", 
    "isDefault", 
    "lastUpdatedBy", 
    "lastUpdatedDateTime", 
    "resourceId", 
    "roleDefinitionId", 
    "userEligibleSettings", 
    "userMemberSettings", 
    "resource", 
    "roleDefinition"})
@JsonInclude(Include.NON_NULL)
public class GovernanceRoleSetting extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.governanceRoleSetting";
    }

    @JsonProperty("adminEligibleSettings")
    protected List<GovernanceRuleSetting> adminEligibleSettings;

    @JsonProperty("adminEligibleSettings@nextLink")
    protected String adminEligibleSettingsNextLink;

    @JsonProperty("adminMemberSettings")
    protected List<GovernanceRuleSetting> adminMemberSettings;

    @JsonProperty("adminMemberSettings@nextLink")
    protected String adminMemberSettingsNextLink;

    @JsonProperty("isDefault")
    protected Boolean isDefault;

    @JsonProperty("lastUpdatedBy")
    protected String lastUpdatedBy;

    @JsonProperty("lastUpdatedDateTime")
    protected OffsetDateTime lastUpdatedDateTime;

    @JsonProperty("resourceId")
    protected String resourceId;

    @JsonProperty("roleDefinitionId")
    protected String roleDefinitionId;

    @JsonProperty("userEligibleSettings")
    protected List<GovernanceRuleSetting> userEligibleSettings;

    @JsonProperty("userEligibleSettings@nextLink")
    protected String userEligibleSettingsNextLink;

    @JsonProperty("userMemberSettings")
    protected List<GovernanceRuleSetting> userMemberSettings;

    @JsonProperty("userMemberSettings@nextLink")
    protected String userMemberSettingsNextLink;

    @JsonProperty("resource")
    protected GovernanceResource resource;

    @JsonProperty("roleDefinition")
    protected GovernanceRoleDefinition roleDefinition;

    protected GovernanceRoleSetting() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderGovernanceRoleSetting() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private List<GovernanceRuleSetting> adminEligibleSettings;
        private String adminEligibleSettingsNextLink;
        private List<GovernanceRuleSetting> adminMemberSettings;
        private String adminMemberSettingsNextLink;
        private Boolean isDefault;
        private String lastUpdatedBy;
        private OffsetDateTime lastUpdatedDateTime;
        private String resourceId;
        private String roleDefinitionId;
        private List<GovernanceRuleSetting> userEligibleSettings;
        private String userEligibleSettingsNextLink;
        private List<GovernanceRuleSetting> userMemberSettings;
        private String userMemberSettingsNextLink;
        private GovernanceResource resource;
        private GovernanceRoleDefinition roleDefinition;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder adminEligibleSettings(List<GovernanceRuleSetting> adminEligibleSettings) {
            this.adminEligibleSettings = adminEligibleSettings;
            this.changedFields = changedFields.add("adminEligibleSettings");
            return this;
        }

        public Builder adminEligibleSettings(GovernanceRuleSetting... adminEligibleSettings) {
            return adminEligibleSettings(Arrays.asList(adminEligibleSettings));
        }

        public Builder adminEligibleSettingsNextLink(String adminEligibleSettingsNextLink) {
            this.adminEligibleSettingsNextLink = adminEligibleSettingsNextLink;
            this.changedFields = changedFields.add("adminEligibleSettings");
            return this;
        }

        public Builder adminMemberSettings(List<GovernanceRuleSetting> adminMemberSettings) {
            this.adminMemberSettings = adminMemberSettings;
            this.changedFields = changedFields.add("adminMemberSettings");
            return this;
        }

        public Builder adminMemberSettings(GovernanceRuleSetting... adminMemberSettings) {
            return adminMemberSettings(Arrays.asList(adminMemberSettings));
        }

        public Builder adminMemberSettingsNextLink(String adminMemberSettingsNextLink) {
            this.adminMemberSettingsNextLink = adminMemberSettingsNextLink;
            this.changedFields = changedFields.add("adminMemberSettings");
            return this;
        }

        public Builder isDefault(Boolean isDefault) {
            this.isDefault = isDefault;
            this.changedFields = changedFields.add("isDefault");
            return this;
        }

        public Builder lastUpdatedBy(String lastUpdatedBy) {
            this.lastUpdatedBy = lastUpdatedBy;
            this.changedFields = changedFields.add("lastUpdatedBy");
            return this;
        }

        public Builder lastUpdatedDateTime(OffsetDateTime lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
            this.changedFields = changedFields.add("lastUpdatedDateTime");
            return this;
        }

        public Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            this.changedFields = changedFields.add("resourceId");
            return this;
        }

        public Builder roleDefinitionId(String roleDefinitionId) {
            this.roleDefinitionId = roleDefinitionId;
            this.changedFields = changedFields.add("roleDefinitionId");
            return this;
        }

        public Builder userEligibleSettings(List<GovernanceRuleSetting> userEligibleSettings) {
            this.userEligibleSettings = userEligibleSettings;
            this.changedFields = changedFields.add("userEligibleSettings");
            return this;
        }

        public Builder userEligibleSettings(GovernanceRuleSetting... userEligibleSettings) {
            return userEligibleSettings(Arrays.asList(userEligibleSettings));
        }

        public Builder userEligibleSettingsNextLink(String userEligibleSettingsNextLink) {
            this.userEligibleSettingsNextLink = userEligibleSettingsNextLink;
            this.changedFields = changedFields.add("userEligibleSettings");
            return this;
        }

        public Builder userMemberSettings(List<GovernanceRuleSetting> userMemberSettings) {
            this.userMemberSettings = userMemberSettings;
            this.changedFields = changedFields.add("userMemberSettings");
            return this;
        }

        public Builder userMemberSettings(GovernanceRuleSetting... userMemberSettings) {
            return userMemberSettings(Arrays.asList(userMemberSettings));
        }

        public Builder userMemberSettingsNextLink(String userMemberSettingsNextLink) {
            this.userMemberSettingsNextLink = userMemberSettingsNextLink;
            this.changedFields = changedFields.add("userMemberSettings");
            return this;
        }

        public Builder resource(GovernanceResource resource) {
            this.resource = resource;
            this.changedFields = changedFields.add("resource");
            return this;
        }

        public Builder roleDefinition(GovernanceRoleDefinition roleDefinition) {
            this.roleDefinition = roleDefinition;
            this.changedFields = changedFields.add("roleDefinition");
            return this;
        }

        public GovernanceRoleSetting build() {
            GovernanceRoleSetting _x = new GovernanceRoleSetting();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.governanceRoleSetting";
            _x.id = id;
            _x.adminEligibleSettings = adminEligibleSettings;
            _x.adminEligibleSettingsNextLink = adminEligibleSettingsNextLink;
            _x.adminMemberSettings = adminMemberSettings;
            _x.adminMemberSettingsNextLink = adminMemberSettingsNextLink;
            _x.isDefault = isDefault;
            _x.lastUpdatedBy = lastUpdatedBy;
            _x.lastUpdatedDateTime = lastUpdatedDateTime;
            _x.resourceId = resourceId;
            _x.roleDefinitionId = roleDefinitionId;
            _x.userEligibleSettings = userEligibleSettings;
            _x.userEligibleSettingsNextLink = userEligibleSettingsNextLink;
            _x.userMemberSettings = userMemberSettings;
            _x.userMemberSettingsNextLink = userMemberSettingsNextLink;
            _x.resource = resource;
            _x.roleDefinition = roleDefinition;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="adminEligibleSettings")
    @JsonIgnore
    public CollectionPage<GovernanceRuleSetting> getAdminEligibleSettings() {
        return new CollectionPage<GovernanceRuleSetting>(contextPath, GovernanceRuleSetting.class, this.adminEligibleSettings, Optional.ofNullable(adminEligibleSettingsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public GovernanceRoleSetting withAdminEligibleSettings(List<GovernanceRuleSetting> adminEligibleSettings) {
        GovernanceRoleSetting _x = _copy();
        _x.changedFields = changedFields.add("adminEligibleSettings");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.governanceRoleSetting");
        _x.adminEligibleSettings = adminEligibleSettings;
        return _x;
    }

    @Property(name="adminEligibleSettings")
    @JsonIgnore
    public CollectionPage<GovernanceRuleSetting> getAdminEligibleSettings(HttpRequestOptions options) {
        return new CollectionPage<GovernanceRuleSetting>(contextPath, GovernanceRuleSetting.class, this.adminEligibleSettings, Optional.ofNullable(adminEligibleSettingsNextLink), Collections.emptyList(), options);
    }

    @Property(name="adminMemberSettings")
    @JsonIgnore
    public CollectionPage<GovernanceRuleSetting> getAdminMemberSettings() {
        return new CollectionPage<GovernanceRuleSetting>(contextPath, GovernanceRuleSetting.class, this.adminMemberSettings, Optional.ofNullable(adminMemberSettingsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public GovernanceRoleSetting withAdminMemberSettings(List<GovernanceRuleSetting> adminMemberSettings) {
        GovernanceRoleSetting _x = _copy();
        _x.changedFields = changedFields.add("adminMemberSettings");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.governanceRoleSetting");
        _x.adminMemberSettings = adminMemberSettings;
        return _x;
    }

    @Property(name="adminMemberSettings")
    @JsonIgnore
    public CollectionPage<GovernanceRuleSetting> getAdminMemberSettings(HttpRequestOptions options) {
        return new CollectionPage<GovernanceRuleSetting>(contextPath, GovernanceRuleSetting.class, this.adminMemberSettings, Optional.ofNullable(adminMemberSettingsNextLink), Collections.emptyList(), options);
    }

    @Property(name="isDefault")
    @JsonIgnore
    public Optional<Boolean> getIsDefault() {
        return Optional.ofNullable(isDefault);
    }

    public GovernanceRoleSetting withIsDefault(Boolean isDefault) {
        GovernanceRoleSetting _x = _copy();
        _x.changedFields = changedFields.add("isDefault");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.governanceRoleSetting");
        _x.isDefault = isDefault;
        return _x;
    }

    @Property(name="lastUpdatedBy")
    @JsonIgnore
    public Optional<String> getLastUpdatedBy() {
        return Optional.ofNullable(lastUpdatedBy);
    }

    public GovernanceRoleSetting withLastUpdatedBy(String lastUpdatedBy) {
        GovernanceRoleSetting _x = _copy();
        _x.changedFields = changedFields.add("lastUpdatedBy");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.governanceRoleSetting");
        _x.lastUpdatedBy = lastUpdatedBy;
        return _x;
    }

    @Property(name="lastUpdatedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastUpdatedDateTime() {
        return Optional.ofNullable(lastUpdatedDateTime);
    }

    public GovernanceRoleSetting withLastUpdatedDateTime(OffsetDateTime lastUpdatedDateTime) {
        GovernanceRoleSetting _x = _copy();
        _x.changedFields = changedFields.add("lastUpdatedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.governanceRoleSetting");
        _x.lastUpdatedDateTime = lastUpdatedDateTime;
        return _x;
    }

    @Property(name="resourceId")
    @JsonIgnore
    public Optional<String> getResourceId() {
        return Optional.ofNullable(resourceId);
    }

    public GovernanceRoleSetting withResourceId(String resourceId) {
        GovernanceRoleSetting _x = _copy();
        _x.changedFields = changedFields.add("resourceId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.governanceRoleSetting");
        _x.resourceId = resourceId;
        return _x;
    }

    @Property(name="roleDefinitionId")
    @JsonIgnore
    public Optional<String> getRoleDefinitionId() {
        return Optional.ofNullable(roleDefinitionId);
    }

    public GovernanceRoleSetting withRoleDefinitionId(String roleDefinitionId) {
        GovernanceRoleSetting _x = _copy();
        _x.changedFields = changedFields.add("roleDefinitionId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.governanceRoleSetting");
        _x.roleDefinitionId = roleDefinitionId;
        return _x;
    }

    @Property(name="userEligibleSettings")
    @JsonIgnore
    public CollectionPage<GovernanceRuleSetting> getUserEligibleSettings() {
        return new CollectionPage<GovernanceRuleSetting>(contextPath, GovernanceRuleSetting.class, this.userEligibleSettings, Optional.ofNullable(userEligibleSettingsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public GovernanceRoleSetting withUserEligibleSettings(List<GovernanceRuleSetting> userEligibleSettings) {
        GovernanceRoleSetting _x = _copy();
        _x.changedFields = changedFields.add("userEligibleSettings");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.governanceRoleSetting");
        _x.userEligibleSettings = userEligibleSettings;
        return _x;
    }

    @Property(name="userEligibleSettings")
    @JsonIgnore
    public CollectionPage<GovernanceRuleSetting> getUserEligibleSettings(HttpRequestOptions options) {
        return new CollectionPage<GovernanceRuleSetting>(contextPath, GovernanceRuleSetting.class, this.userEligibleSettings, Optional.ofNullable(userEligibleSettingsNextLink), Collections.emptyList(), options);
    }

    @Property(name="userMemberSettings")
    @JsonIgnore
    public CollectionPage<GovernanceRuleSetting> getUserMemberSettings() {
        return new CollectionPage<GovernanceRuleSetting>(contextPath, GovernanceRuleSetting.class, this.userMemberSettings, Optional.ofNullable(userMemberSettingsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public GovernanceRoleSetting withUserMemberSettings(List<GovernanceRuleSetting> userMemberSettings) {
        GovernanceRoleSetting _x = _copy();
        _x.changedFields = changedFields.add("userMemberSettings");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.governanceRoleSetting");
        _x.userMemberSettings = userMemberSettings;
        return _x;
    }

    @Property(name="userMemberSettings")
    @JsonIgnore
    public CollectionPage<GovernanceRuleSetting> getUserMemberSettings(HttpRequestOptions options) {
        return new CollectionPage<GovernanceRuleSetting>(contextPath, GovernanceRuleSetting.class, this.userMemberSettings, Optional.ofNullable(userMemberSettingsNextLink), Collections.emptyList(), options);
    }

    public GovernanceRoleSetting withUnmappedField(String name, Object value) {
        GovernanceRoleSetting _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="resource")
    @JsonIgnore
    public GovernanceResourceRequest getResource() {
        return new GovernanceResourceRequest(contextPath.addSegment("resource"), Optional.ofNullable(resource));
    }

    @NavigationProperty(name="roleDefinition")
    @JsonIgnore
    public GovernanceRoleDefinitionRequest getRoleDefinition() {
        return new GovernanceRoleDefinitionRequest(contextPath.addSegment("roleDefinition"), Optional.ofNullable(roleDefinition));
    }

    public GovernanceRoleSetting withResource(GovernanceResource resource) {
        GovernanceRoleSetting _x = _copy();
        _x.changedFields = changedFields.add("resource");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.governanceRoleSetting");
        _x.resource = resource;
        return _x;
    }

    public GovernanceRoleSetting withRoleDefinition(GovernanceRoleDefinition roleDefinition) {
        GovernanceRoleSetting _x = _copy();
        _x.changedFields = changedFields.add("roleDefinition");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.governanceRoleSetting");
        _x.roleDefinition = roleDefinition;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public GovernanceRoleSetting patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        GovernanceRoleSetting _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public GovernanceRoleSetting put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        GovernanceRoleSetting _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private GovernanceRoleSetting _copy() {
        GovernanceRoleSetting _x = new GovernanceRoleSetting();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.adminEligibleSettings = adminEligibleSettings;
        _x.adminMemberSettings = adminMemberSettings;
        _x.isDefault = isDefault;
        _x.lastUpdatedBy = lastUpdatedBy;
        _x.lastUpdatedDateTime = lastUpdatedDateTime;
        _x.resourceId = resourceId;
        _x.roleDefinitionId = roleDefinitionId;
        _x.userEligibleSettings = userEligibleSettings;
        _x.userMemberSettings = userMemberSettings;
        _x.resource = resource;
        _x.roleDefinition = roleDefinition;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("GovernanceRoleSetting[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("adminEligibleSettings=");
        b.append(this.adminEligibleSettings);
        b.append(", ");
        b.append("adminMemberSettings=");
        b.append(this.adminMemberSettings);
        b.append(", ");
        b.append("isDefault=");
        b.append(this.isDefault);
        b.append(", ");
        b.append("lastUpdatedBy=");
        b.append(this.lastUpdatedBy);
        b.append(", ");
        b.append("lastUpdatedDateTime=");
        b.append(this.lastUpdatedDateTime);
        b.append(", ");
        b.append("resourceId=");
        b.append(this.resourceId);
        b.append(", ");
        b.append("roleDefinitionId=");
        b.append(this.roleDefinitionId);
        b.append(", ");
        b.append("userEligibleSettings=");
        b.append(this.userEligibleSettings);
        b.append(", ");
        b.append("userMemberSettings=");
        b.append(this.userMemberSettings);
        b.append(", ");
        b.append("resource=");
        b.append(this.resource);
        b.append(", ");
        b.append("roleDefinition=");
        b.append(this.roleDefinition);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
