package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import odata.msgraph.client.beta.entity.request.GovernanceResourceRequest;
import odata.msgraph.client.beta.entity.request.GovernanceRoleSettingRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "displayName", 
    "externalId", 
    "resourceId", 
    "templateId", 
    "resource", 
    "roleSetting"})
@JsonInclude(Include.NON_NULL)
public class GovernanceRoleDefinition extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.governanceRoleDefinition";
    }

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("externalId")
    protected String externalId;

    @JsonProperty("resourceId")
    protected String resourceId;

    @JsonProperty("templateId")
    protected String templateId;

    @JsonProperty("resource")
    protected GovernanceResource resource;

    @JsonProperty("roleSetting")
    protected GovernanceRoleSetting roleSetting;

    protected GovernanceRoleDefinition() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderGovernanceRoleDefinition() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String displayName;
        private String externalId;
        private String resourceId;
        private String templateId;
        private GovernanceResource resource;
        private GovernanceRoleSetting roleSetting;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder externalId(String externalId) {
            this.externalId = externalId;
            this.changedFields = changedFields.add("externalId");
            return this;
        }

        public Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            this.changedFields = changedFields.add("resourceId");
            return this;
        }

        public Builder templateId(String templateId) {
            this.templateId = templateId;
            this.changedFields = changedFields.add("templateId");
            return this;
        }

        public Builder resource(GovernanceResource resource) {
            this.resource = resource;
            this.changedFields = changedFields.add("resource");
            return this;
        }

        public Builder roleSetting(GovernanceRoleSetting roleSetting) {
            this.roleSetting = roleSetting;
            this.changedFields = changedFields.add("roleSetting");
            return this;
        }

        public GovernanceRoleDefinition build() {
            GovernanceRoleDefinition _x = new GovernanceRoleDefinition();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.governanceRoleDefinition";
            _x.id = id;
            _x.displayName = displayName;
            _x.externalId = externalId;
            _x.resourceId = resourceId;
            _x.templateId = templateId;
            _x.resource = resource;
            _x.roleSetting = roleSetting;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public GovernanceRoleDefinition withDisplayName(String displayName) {
        GovernanceRoleDefinition _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.governanceRoleDefinition");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="externalId")
    @JsonIgnore
    public Optional<String> getExternalId() {
        return Optional.ofNullable(externalId);
    }

    public GovernanceRoleDefinition withExternalId(String externalId) {
        GovernanceRoleDefinition _x = _copy();
        _x.changedFields = changedFields.add("externalId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.governanceRoleDefinition");
        _x.externalId = externalId;
        return _x;
    }

    @Property(name="resourceId")
    @JsonIgnore
    public Optional<String> getResourceId() {
        return Optional.ofNullable(resourceId);
    }

    public GovernanceRoleDefinition withResourceId(String resourceId) {
        GovernanceRoleDefinition _x = _copy();
        _x.changedFields = changedFields.add("resourceId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.governanceRoleDefinition");
        _x.resourceId = resourceId;
        return _x;
    }

    @Property(name="templateId")
    @JsonIgnore
    public Optional<String> getTemplateId() {
        return Optional.ofNullable(templateId);
    }

    public GovernanceRoleDefinition withTemplateId(String templateId) {
        GovernanceRoleDefinition _x = _copy();
        _x.changedFields = changedFields.add("templateId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.governanceRoleDefinition");
        _x.templateId = templateId;
        return _x;
    }

    public GovernanceRoleDefinition withUnmappedField(String name, Object value) {
        GovernanceRoleDefinition _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="resource")
    @JsonIgnore
    public GovernanceResourceRequest getResource() {
        return new GovernanceResourceRequest(contextPath.addSegment("resource"), Optional.ofNullable(resource));
    }

    @NavigationProperty(name="roleSetting")
    @JsonIgnore
    public GovernanceRoleSettingRequest getRoleSetting() {
        return new GovernanceRoleSettingRequest(contextPath.addSegment("roleSetting"), Optional.ofNullable(roleSetting));
    }

    public GovernanceRoleDefinition withResource(GovernanceResource resource) {
        GovernanceRoleDefinition _x = _copy();
        _x.changedFields = changedFields.add("resource");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.governanceRoleDefinition");
        _x.resource = resource;
        return _x;
    }

    public GovernanceRoleDefinition withRoleSetting(GovernanceRoleSetting roleSetting) {
        GovernanceRoleDefinition _x = _copy();
        _x.changedFields = changedFields.add("roleSetting");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.governanceRoleDefinition");
        _x.roleSetting = roleSetting;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public GovernanceRoleDefinition patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        GovernanceRoleDefinition _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public GovernanceRoleDefinition put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        GovernanceRoleDefinition _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private GovernanceRoleDefinition _copy() {
        GovernanceRoleDefinition _x = new GovernanceRoleDefinition();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.displayName = displayName;
        _x.externalId = externalId;
        _x.resourceId = resourceId;
        _x.templateId = templateId;
        _x.resource = resource;
        _x.roleSetting = roleSetting;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("GovernanceRoleDefinition[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("externalId=");
        b.append(this.externalId);
        b.append(", ");
        b.append("resourceId=");
        b.append(this.resourceId);
        b.append(", ");
        b.append("templateId=");
        b.append(this.templateId);
        b.append(", ");
        b.append("resource=");
        b.append(this.resource);
        b.append(", ");
        b.append("roleSetting=");
        b.append(this.roleSetting);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
