package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.entity.request.GovernanceResourceRequest;
import odata.msgraph.client.beta.entity.request.GovernanceRoleAssignmentRequest;
import odata.msgraph.client.beta.entity.request.GovernanceRoleDefinitionRequest;
import odata.msgraph.client.beta.entity.request.GovernanceSubjectRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "assignmentState", 
    "endDateTime", 
    "externalId", 
    "linkedEligibleRoleAssignmentId", 
    "memberType", 
    "resourceId", 
    "roleDefinitionId", 
    "startDateTime", 
    "status", 
    "subjectId", 
    "resource", 
    "roleDefinition", 
    "subject"})
@JsonInclude(Include.NON_NULL)
public class GovernanceRoleAssignment extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.governanceRoleAssignment";
    }

    @JsonProperty("assignmentState")
    protected String assignmentState;

    @JsonProperty("endDateTime")
    protected OffsetDateTime endDateTime;

    @JsonProperty("externalId")
    protected String externalId;

    @JsonProperty("linkedEligibleRoleAssignmentId")
    protected String linkedEligibleRoleAssignmentId;

    @JsonProperty("memberType")
    protected String memberType;

    @JsonProperty("resourceId")
    protected String resourceId;

    @JsonProperty("roleDefinitionId")
    protected String roleDefinitionId;

    @JsonProperty("startDateTime")
    protected OffsetDateTime startDateTime;

    @JsonProperty("status")
    protected String status;

    @JsonProperty("subjectId")
    protected String subjectId;

    @JsonProperty("resource")
    protected GovernanceResource resource;

    @JsonProperty("roleDefinition")
    protected GovernanceRoleDefinition roleDefinition;

    @JsonProperty("subject")
    protected GovernanceSubject subject;

    protected GovernanceRoleAssignment() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderGovernanceRoleAssignment() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String assignmentState;
        private OffsetDateTime endDateTime;
        private String externalId;
        private String linkedEligibleRoleAssignmentId;
        private String memberType;
        private String resourceId;
        private String roleDefinitionId;
        private OffsetDateTime startDateTime;
        private String status;
        private String subjectId;
        private GovernanceResource resource;
        private GovernanceRoleDefinition roleDefinition;
        private GovernanceSubject subject;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder assignmentState(String assignmentState) {
            this.assignmentState = assignmentState;
            this.changedFields = changedFields.add("assignmentState");
            return this;
        }

        public Builder endDateTime(OffsetDateTime endDateTime) {
            this.endDateTime = endDateTime;
            this.changedFields = changedFields.add("endDateTime");
            return this;
        }

        public Builder externalId(String externalId) {
            this.externalId = externalId;
            this.changedFields = changedFields.add("externalId");
            return this;
        }

        public Builder linkedEligibleRoleAssignmentId(String linkedEligibleRoleAssignmentId) {
            this.linkedEligibleRoleAssignmentId = linkedEligibleRoleAssignmentId;
            this.changedFields = changedFields.add("linkedEligibleRoleAssignmentId");
            return this;
        }

        public Builder memberType(String memberType) {
            this.memberType = memberType;
            this.changedFields = changedFields.add("memberType");
            return this;
        }

        public Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            this.changedFields = changedFields.add("resourceId");
            return this;
        }

        public Builder roleDefinitionId(String roleDefinitionId) {
            this.roleDefinitionId = roleDefinitionId;
            this.changedFields = changedFields.add("roleDefinitionId");
            return this;
        }

        public Builder startDateTime(OffsetDateTime startDateTime) {
            this.startDateTime = startDateTime;
            this.changedFields = changedFields.add("startDateTime");
            return this;
        }

        public Builder status(String status) {
            this.status = status;
            this.changedFields = changedFields.add("status");
            return this;
        }

        public Builder subjectId(String subjectId) {
            this.subjectId = subjectId;
            this.changedFields = changedFields.add("subjectId");
            return this;
        }

        public Builder resource(GovernanceResource resource) {
            this.resource = resource;
            this.changedFields = changedFields.add("resource");
            return this;
        }

        public Builder roleDefinition(GovernanceRoleDefinition roleDefinition) {
            this.roleDefinition = roleDefinition;
            this.changedFields = changedFields.add("roleDefinition");
            return this;
        }

        public Builder subject(GovernanceSubject subject) {
            this.subject = subject;
            this.changedFields = changedFields.add("subject");
            return this;
        }

        public GovernanceRoleAssignment build() {
            GovernanceRoleAssignment _x = new GovernanceRoleAssignment();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.governanceRoleAssignment";
            _x.id = id;
            _x.assignmentState = assignmentState;
            _x.endDateTime = endDateTime;
            _x.externalId = externalId;
            _x.linkedEligibleRoleAssignmentId = linkedEligibleRoleAssignmentId;
            _x.memberType = memberType;
            _x.resourceId = resourceId;
            _x.roleDefinitionId = roleDefinitionId;
            _x.startDateTime = startDateTime;
            _x.status = status;
            _x.subjectId = subjectId;
            _x.resource = resource;
            _x.roleDefinition = roleDefinition;
            _x.subject = subject;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="assignmentState")
    @JsonIgnore
    public Optional<String> getAssignmentState() {
        return Optional.ofNullable(assignmentState);
    }

    public GovernanceRoleAssignment withAssignmentState(String assignmentState) {
        GovernanceRoleAssignment _x = _copy();
        _x.changedFields = changedFields.add("assignmentState");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.governanceRoleAssignment");
        _x.assignmentState = assignmentState;
        return _x;
    }

    @Property(name="endDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getEndDateTime() {
        return Optional.ofNullable(endDateTime);
    }

    public GovernanceRoleAssignment withEndDateTime(OffsetDateTime endDateTime) {
        GovernanceRoleAssignment _x = _copy();
        _x.changedFields = changedFields.add("endDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.governanceRoleAssignment");
        _x.endDateTime = endDateTime;
        return _x;
    }

    @Property(name="externalId")
    @JsonIgnore
    public Optional<String> getExternalId() {
        return Optional.ofNullable(externalId);
    }

    public GovernanceRoleAssignment withExternalId(String externalId) {
        GovernanceRoleAssignment _x = _copy();
        _x.changedFields = changedFields.add("externalId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.governanceRoleAssignment");
        _x.externalId = externalId;
        return _x;
    }

    @Property(name="linkedEligibleRoleAssignmentId")
    @JsonIgnore
    public Optional<String> getLinkedEligibleRoleAssignmentId() {
        return Optional.ofNullable(linkedEligibleRoleAssignmentId);
    }

    public GovernanceRoleAssignment withLinkedEligibleRoleAssignmentId(String linkedEligibleRoleAssignmentId) {
        GovernanceRoleAssignment _x = _copy();
        _x.changedFields = changedFields.add("linkedEligibleRoleAssignmentId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.governanceRoleAssignment");
        _x.linkedEligibleRoleAssignmentId = linkedEligibleRoleAssignmentId;
        return _x;
    }

    @Property(name="memberType")
    @JsonIgnore
    public Optional<String> getMemberType() {
        return Optional.ofNullable(memberType);
    }

    public GovernanceRoleAssignment withMemberType(String memberType) {
        GovernanceRoleAssignment _x = _copy();
        _x.changedFields = changedFields.add("memberType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.governanceRoleAssignment");
        _x.memberType = memberType;
        return _x;
    }

    @Property(name="resourceId")
    @JsonIgnore
    public Optional<String> getResourceId() {
        return Optional.ofNullable(resourceId);
    }

    public GovernanceRoleAssignment withResourceId(String resourceId) {
        GovernanceRoleAssignment _x = _copy();
        _x.changedFields = changedFields.add("resourceId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.governanceRoleAssignment");
        _x.resourceId = resourceId;
        return _x;
    }

    @Property(name="roleDefinitionId")
    @JsonIgnore
    public Optional<String> getRoleDefinitionId() {
        return Optional.ofNullable(roleDefinitionId);
    }

    public GovernanceRoleAssignment withRoleDefinitionId(String roleDefinitionId) {
        GovernanceRoleAssignment _x = _copy();
        _x.changedFields = changedFields.add("roleDefinitionId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.governanceRoleAssignment");
        _x.roleDefinitionId = roleDefinitionId;
        return _x;
    }

    @Property(name="startDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getStartDateTime() {
        return Optional.ofNullable(startDateTime);
    }

    public GovernanceRoleAssignment withStartDateTime(OffsetDateTime startDateTime) {
        GovernanceRoleAssignment _x = _copy();
        _x.changedFields = changedFields.add("startDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.governanceRoleAssignment");
        _x.startDateTime = startDateTime;
        return _x;
    }

    @Property(name="status")
    @JsonIgnore
    public Optional<String> getStatus() {
        return Optional.ofNullable(status);
    }

    public GovernanceRoleAssignment withStatus(String status) {
        GovernanceRoleAssignment _x = _copy();
        _x.changedFields = changedFields.add("status");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.governanceRoleAssignment");
        _x.status = status;
        return _x;
    }

    @Property(name="subjectId")
    @JsonIgnore
    public Optional<String> getSubjectId() {
        return Optional.ofNullable(subjectId);
    }

    public GovernanceRoleAssignment withSubjectId(String subjectId) {
        GovernanceRoleAssignment _x = _copy();
        _x.changedFields = changedFields.add("subjectId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.governanceRoleAssignment");
        _x.subjectId = subjectId;
        return _x;
    }

    public GovernanceRoleAssignment withUnmappedField(String name, Object value) {
        GovernanceRoleAssignment _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="linkedEligibleRoleAssignment")
    @JsonIgnore
    public GovernanceRoleAssignmentRequest getLinkedEligibleRoleAssignment() {
        return new GovernanceRoleAssignmentRequest(contextPath.addSegment("linkedEligibleRoleAssignment"), RequestHelper.getValue(unmappedFields, "linkedEligibleRoleAssignment"));
    }

    @NavigationProperty(name="resource")
    @JsonIgnore
    public GovernanceResourceRequest getResource() {
        return new GovernanceResourceRequest(contextPath.addSegment("resource"), Optional.ofNullable(resource));
    }

    @NavigationProperty(name="roleDefinition")
    @JsonIgnore
    public GovernanceRoleDefinitionRequest getRoleDefinition() {
        return new GovernanceRoleDefinitionRequest(contextPath.addSegment("roleDefinition"), Optional.ofNullable(roleDefinition));
    }

    @NavigationProperty(name="subject")
    @JsonIgnore
    public GovernanceSubjectRequest getSubject() {
        return new GovernanceSubjectRequest(contextPath.addSegment("subject"), Optional.ofNullable(subject));
    }

    public GovernanceRoleAssignment withResource(GovernanceResource resource) {
        GovernanceRoleAssignment _x = _copy();
        _x.changedFields = changedFields.add("resource");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.governanceRoleAssignment");
        _x.resource = resource;
        return _x;
    }

    public GovernanceRoleAssignment withRoleDefinition(GovernanceRoleDefinition roleDefinition) {
        GovernanceRoleAssignment _x = _copy();
        _x.changedFields = changedFields.add("roleDefinition");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.governanceRoleAssignment");
        _x.roleDefinition = roleDefinition;
        return _x;
    }

    public GovernanceRoleAssignment withSubject(GovernanceSubject subject) {
        GovernanceRoleAssignment _x = _copy();
        _x.changedFields = changedFields.add("subject");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.governanceRoleAssignment");
        _x.subject = subject;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public GovernanceRoleAssignment patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        GovernanceRoleAssignment _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public GovernanceRoleAssignment put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        GovernanceRoleAssignment _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private GovernanceRoleAssignment _copy() {
        GovernanceRoleAssignment _x = new GovernanceRoleAssignment();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.assignmentState = assignmentState;
        _x.endDateTime = endDateTime;
        _x.externalId = externalId;
        _x.linkedEligibleRoleAssignmentId = linkedEligibleRoleAssignmentId;
        _x.memberType = memberType;
        _x.resourceId = resourceId;
        _x.roleDefinitionId = roleDefinitionId;
        _x.startDateTime = startDateTime;
        _x.status = status;
        _x.subjectId = subjectId;
        _x.resource = resource;
        _x.roleDefinition = roleDefinition;
        _x.subject = subject;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("GovernanceRoleAssignment[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("assignmentState=");
        b.append(this.assignmentState);
        b.append(", ");
        b.append("endDateTime=");
        b.append(this.endDateTime);
        b.append(", ");
        b.append("externalId=");
        b.append(this.externalId);
        b.append(", ");
        b.append("linkedEligibleRoleAssignmentId=");
        b.append(this.linkedEligibleRoleAssignmentId);
        b.append(", ");
        b.append("memberType=");
        b.append(this.memberType);
        b.append(", ");
        b.append("resourceId=");
        b.append(this.resourceId);
        b.append(", ");
        b.append("roleDefinitionId=");
        b.append(this.roleDefinitionId);
        b.append(", ");
        b.append("startDateTime=");
        b.append(this.startDateTime);
        b.append(", ");
        b.append("status=");
        b.append(this.status);
        b.append(", ");
        b.append("subjectId=");
        b.append(this.subjectId);
        b.append(", ");
        b.append("resource=");
        b.append(this.resource);
        b.append(", ");
        b.append("roleDefinition=");
        b.append(this.roleDefinition);
        b.append(", ");
        b.append("subject=");
        b.append(this.subject);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
