package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.entity.collection.request.GovernanceRoleAssignmentCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.GovernanceRoleAssignmentRequestCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.GovernanceRoleDefinitionCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.GovernanceRoleSettingCollectionRequest;
import odata.msgraph.client.beta.entity.request.GovernanceResourceRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "displayName", 
    "externalId", 
    "registeredDateTime", 
    "registeredRoot", 
    "status", 
    "type", 
    "parent", 
    "roleAssignmentRequests", 
    "roleAssignments", 
    "roleDefinitions", 
    "roleSettings"})
@JsonInclude(Include.NON_NULL)
public class GovernanceResource extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.governanceResource";
    }

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("externalId")
    protected String externalId;

    @JsonProperty("registeredDateTime")
    protected OffsetDateTime registeredDateTime;

    @JsonProperty("registeredRoot")
    protected String registeredRoot;

    @JsonProperty("status")
    protected String status;

    @JsonProperty("type")
    protected String type;

    @JsonProperty("parent")
    protected GovernanceResource parent;

    @JsonProperty("roleAssignmentRequests")
    protected List<GovernanceRoleAssignmentRequest> roleAssignmentRequests;

    @JsonProperty("roleAssignments")
    protected List<GovernanceRoleAssignment> roleAssignments;

    @JsonProperty("roleDefinitions")
    protected List<GovernanceRoleDefinition> roleDefinitions;

    @JsonProperty("roleSettings")
    protected List<GovernanceRoleSetting> roleSettings;

    protected GovernanceResource() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderGovernanceResource() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String displayName;
        private String externalId;
        private OffsetDateTime registeredDateTime;
        private String registeredRoot;
        private String status;
        private String type;
        private GovernanceResource parent;
        private List<GovernanceRoleAssignmentRequest> roleAssignmentRequests;
        private List<GovernanceRoleAssignment> roleAssignments;
        private List<GovernanceRoleDefinition> roleDefinitions;
        private List<GovernanceRoleSetting> roleSettings;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder externalId(String externalId) {
            this.externalId = externalId;
            this.changedFields = changedFields.add("externalId");
            return this;
        }

        public Builder registeredDateTime(OffsetDateTime registeredDateTime) {
            this.registeredDateTime = registeredDateTime;
            this.changedFields = changedFields.add("registeredDateTime");
            return this;
        }

        public Builder registeredRoot(String registeredRoot) {
            this.registeredRoot = registeredRoot;
            this.changedFields = changedFields.add("registeredRoot");
            return this;
        }

        public Builder status(String status) {
            this.status = status;
            this.changedFields = changedFields.add("status");
            return this;
        }

        public Builder type(String type) {
            this.type = type;
            this.changedFields = changedFields.add("type");
            return this;
        }

        public Builder parent(GovernanceResource parent) {
            this.parent = parent;
            this.changedFields = changedFields.add("parent");
            return this;
        }

        public Builder roleAssignmentRequests(List<GovernanceRoleAssignmentRequest> roleAssignmentRequests) {
            this.roleAssignmentRequests = roleAssignmentRequests;
            this.changedFields = changedFields.add("roleAssignmentRequests");
            return this;
        }

        public Builder roleAssignmentRequests(GovernanceRoleAssignmentRequest... roleAssignmentRequests) {
            return roleAssignmentRequests(Arrays.asList(roleAssignmentRequests));
        }

        public Builder roleAssignments(List<GovernanceRoleAssignment> roleAssignments) {
            this.roleAssignments = roleAssignments;
            this.changedFields = changedFields.add("roleAssignments");
            return this;
        }

        public Builder roleAssignments(GovernanceRoleAssignment... roleAssignments) {
            return roleAssignments(Arrays.asList(roleAssignments));
        }

        public Builder roleDefinitions(List<GovernanceRoleDefinition> roleDefinitions) {
            this.roleDefinitions = roleDefinitions;
            this.changedFields = changedFields.add("roleDefinitions");
            return this;
        }

        public Builder roleDefinitions(GovernanceRoleDefinition... roleDefinitions) {
            return roleDefinitions(Arrays.asList(roleDefinitions));
        }

        public Builder roleSettings(List<GovernanceRoleSetting> roleSettings) {
            this.roleSettings = roleSettings;
            this.changedFields = changedFields.add("roleSettings");
            return this;
        }

        public Builder roleSettings(GovernanceRoleSetting... roleSettings) {
            return roleSettings(Arrays.asList(roleSettings));
        }

        public GovernanceResource build() {
            GovernanceResource _x = new GovernanceResource();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.governanceResource";
            _x.id = id;
            _x.displayName = displayName;
            _x.externalId = externalId;
            _x.registeredDateTime = registeredDateTime;
            _x.registeredRoot = registeredRoot;
            _x.status = status;
            _x.type = type;
            _x.parent = parent;
            _x.roleAssignmentRequests = roleAssignmentRequests;
            _x.roleAssignments = roleAssignments;
            _x.roleDefinitions = roleDefinitions;
            _x.roleSettings = roleSettings;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public GovernanceResource withDisplayName(String displayName) {
        GovernanceResource _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.governanceResource");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="externalId")
    @JsonIgnore
    public Optional<String> getExternalId() {
        return Optional.ofNullable(externalId);
    }

    public GovernanceResource withExternalId(String externalId) {
        GovernanceResource _x = _copy();
        _x.changedFields = changedFields.add("externalId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.governanceResource");
        _x.externalId = externalId;
        return _x;
    }

    @Property(name="registeredDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getRegisteredDateTime() {
        return Optional.ofNullable(registeredDateTime);
    }

    public GovernanceResource withRegisteredDateTime(OffsetDateTime registeredDateTime) {
        GovernanceResource _x = _copy();
        _x.changedFields = changedFields.add("registeredDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.governanceResource");
        _x.registeredDateTime = registeredDateTime;
        return _x;
    }

    @Property(name="registeredRoot")
    @JsonIgnore
    public Optional<String> getRegisteredRoot() {
        return Optional.ofNullable(registeredRoot);
    }

    public GovernanceResource withRegisteredRoot(String registeredRoot) {
        GovernanceResource _x = _copy();
        _x.changedFields = changedFields.add("registeredRoot");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.governanceResource");
        _x.registeredRoot = registeredRoot;
        return _x;
    }

    @Property(name="status")
    @JsonIgnore
    public Optional<String> getStatus() {
        return Optional.ofNullable(status);
    }

    public GovernanceResource withStatus(String status) {
        GovernanceResource _x = _copy();
        _x.changedFields = changedFields.add("status");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.governanceResource");
        _x.status = status;
        return _x;
    }

    @Property(name="type")
    @JsonIgnore
    public Optional<String> getType() {
        return Optional.ofNullable(type);
    }

    public GovernanceResource withType(String type) {
        GovernanceResource _x = _copy();
        _x.changedFields = changedFields.add("type");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.governanceResource");
        _x.type = type;
        return _x;
    }

    public GovernanceResource withUnmappedField(String name, Object value) {
        GovernanceResource _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="parent")
    @JsonIgnore
    public GovernanceResourceRequest getParent() {
        return new GovernanceResourceRequest(contextPath.addSegment("parent"), Optional.ofNullable(parent));
    }

    @NavigationProperty(name="roleAssignmentRequests")
    @JsonIgnore
    public GovernanceRoleAssignmentRequestCollectionRequest getRoleAssignmentRequests() {
        return new GovernanceRoleAssignmentRequestCollectionRequest(
                        contextPath.addSegment("roleAssignmentRequests"), Optional.ofNullable(roleAssignmentRequests));
    }

    @NavigationProperty(name="roleAssignments")
    @JsonIgnore
    public GovernanceRoleAssignmentCollectionRequest getRoleAssignments() {
        return new GovernanceRoleAssignmentCollectionRequest(
                        contextPath.addSegment("roleAssignments"), Optional.ofNullable(roleAssignments));
    }

    @NavigationProperty(name="roleDefinitions")
    @JsonIgnore
    public GovernanceRoleDefinitionCollectionRequest getRoleDefinitions() {
        return new GovernanceRoleDefinitionCollectionRequest(
                        contextPath.addSegment("roleDefinitions"), Optional.ofNullable(roleDefinitions));
    }

    @NavigationProperty(name="roleSettings")
    @JsonIgnore
    public GovernanceRoleSettingCollectionRequest getRoleSettings() {
        return new GovernanceRoleSettingCollectionRequest(
                        contextPath.addSegment("roleSettings"), Optional.ofNullable(roleSettings));
    }

    public GovernanceResource withParent(GovernanceResource parent) {
        GovernanceResource _x = _copy();
        _x.changedFields = changedFields.add("parent");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.governanceResource");
        _x.parent = parent;
        return _x;
    }

    public GovernanceResource withRoleAssignmentRequests(List<GovernanceRoleAssignmentRequest> roleAssignmentRequests) {
        GovernanceResource _x = _copy();
        _x.changedFields = changedFields.add("roleAssignmentRequests");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.governanceResource");
        _x.roleAssignmentRequests = roleAssignmentRequests;
        return _x;
    }

    public GovernanceResource withRoleAssignments(List<GovernanceRoleAssignment> roleAssignments) {
        GovernanceResource _x = _copy();
        _x.changedFields = changedFields.add("roleAssignments");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.governanceResource");
        _x.roleAssignments = roleAssignments;
        return _x;
    }

    public GovernanceResource withRoleDefinitions(List<GovernanceRoleDefinition> roleDefinitions) {
        GovernanceResource _x = _copy();
        _x.changedFields = changedFields.add("roleDefinitions");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.governanceResource");
        _x.roleDefinitions = roleDefinitions;
        return _x;
    }

    public GovernanceResource withRoleSettings(List<GovernanceRoleSetting> roleSettings) {
        GovernanceResource _x = _copy();
        _x.changedFields = changedFields.add("roleSettings");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.governanceResource");
        _x.roleSettings = roleSettings;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public GovernanceResource patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        GovernanceResource _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public GovernanceResource put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        GovernanceResource _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private GovernanceResource _copy() {
        GovernanceResource _x = new GovernanceResource();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.displayName = displayName;
        _x.externalId = externalId;
        _x.registeredDateTime = registeredDateTime;
        _x.registeredRoot = registeredRoot;
        _x.status = status;
        _x.type = type;
        _x.parent = parent;
        _x.roleAssignmentRequests = roleAssignmentRequests;
        _x.roleAssignments = roleAssignments;
        _x.roleDefinitions = roleDefinitions;
        _x.roleSettings = roleSettings;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("GovernanceResource[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("externalId=");
        b.append(this.externalId);
        b.append(", ");
        b.append("registeredDateTime=");
        b.append(this.registeredDateTime);
        b.append(", ");
        b.append("registeredRoot=");
        b.append(this.registeredRoot);
        b.append(", ");
        b.append("status=");
        b.append(this.status);
        b.append(", ");
        b.append("type=");
        b.append(this.type);
        b.append(", ");
        b.append("parent=");
        b.append(this.parent);
        b.append(", ");
        b.append("roleAssignmentRequests=");
        b.append(this.roleAssignmentRequests);
        b.append(", ");
        b.append("roleAssignments=");
        b.append(this.roleAssignments);
        b.append(", ");
        b.append("roleDefinitions=");
        b.append(this.roleDefinitions);
        b.append(", ");
        b.append("roleSettings=");
        b.append(this.roleSettings);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
