package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import odata.msgraph.client.beta.complex.BusinessFlowSettings;
import odata.msgraph.client.beta.complex.GovernancePolicy;

@JsonPropertyOrder({
    "@odata.type", 
    "displayName", 
    "policy", 
    "settings"})
@JsonInclude(Include.NON_NULL)
public class GovernancePolicyTemplate extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.governancePolicyTemplate";
    }

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("policy")
    protected GovernancePolicy policy;

    @JsonProperty("settings")
    protected BusinessFlowSettings settings;

    protected GovernancePolicyTemplate() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderGovernancePolicyTemplate() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String displayName;
        private GovernancePolicy policy;
        private BusinessFlowSettings settings;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder policy(GovernancePolicy policy) {
            this.policy = policy;
            this.changedFields = changedFields.add("policy");
            return this;
        }

        public Builder settings(BusinessFlowSettings settings) {
            this.settings = settings;
            this.changedFields = changedFields.add("settings");
            return this;
        }

        public GovernancePolicyTemplate build() {
            GovernancePolicyTemplate _x = new GovernancePolicyTemplate();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.governancePolicyTemplate";
            _x.id = id;
            _x.displayName = displayName;
            _x.policy = policy;
            _x.settings = settings;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public GovernancePolicyTemplate withDisplayName(String displayName) {
        GovernancePolicyTemplate _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.governancePolicyTemplate");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="policy")
    @JsonIgnore
    public Optional<GovernancePolicy> getPolicy() {
        return Optional.ofNullable(policy);
    }

    public GovernancePolicyTemplate withPolicy(GovernancePolicy policy) {
        GovernancePolicyTemplate _x = _copy();
        _x.changedFields = changedFields.add("policy");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.governancePolicyTemplate");
        _x.policy = policy;
        return _x;
    }

    @Property(name="settings")
    @JsonIgnore
    public Optional<BusinessFlowSettings> getSettings() {
        return Optional.ofNullable(settings);
    }

    public GovernancePolicyTemplate withSettings(BusinessFlowSettings settings) {
        GovernancePolicyTemplate _x = _copy();
        _x.changedFields = changedFields.add("settings");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.governancePolicyTemplate");
        _x.settings = settings;
        return _x;
    }

    public GovernancePolicyTemplate withUnmappedField(String name, Object value) {
        GovernancePolicyTemplate _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public GovernancePolicyTemplate patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        GovernancePolicyTemplate _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public GovernancePolicyTemplate put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        GovernancePolicyTemplate _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private GovernancePolicyTemplate _copy() {
        GovernancePolicyTemplate _x = new GovernancePolicyTemplate();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.displayName = displayName;
        _x.policy = policy;
        _x.settings = settings;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("GovernancePolicyTemplate[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("policy=");
        b.append(this.policy);
        b.append(", ");
        b.append("settings=");
        b.append(this.settings);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
