package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.enums.AttestationLevel;

@JsonPropertyOrder({
    "@odata.type", 
    "aaGuid", 
    "attestationCertificates", 
    "attestationLevel", 
    "createdDateTime", 
    "creationDateTime", 
    "displayName", 
    "model"})
@JsonInclude(Include.NON_NULL)
public class Fido2AuthenticationMethod extends AuthenticationMethod implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.fido2AuthenticationMethod";
    }

    @JsonProperty("aaGuid")
    protected String aaGuid;

    @JsonProperty("attestationCertificates")
    protected List<String> attestationCertificates;

    @JsonProperty("attestationCertificates@nextLink")
    protected String attestationCertificatesNextLink;

    @JsonProperty("attestationLevel")
    protected AttestationLevel attestationLevel;

    @JsonProperty("createdDateTime")
    protected OffsetDateTime createdDateTime;

    @JsonProperty("creationDateTime")
    protected OffsetDateTime creationDateTime;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("model")
    protected String model;

    protected Fido2AuthenticationMethod() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderFido2AuthenticationMethod() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String aaGuid;
        private List<String> attestationCertificates;
        private String attestationCertificatesNextLink;
        private AttestationLevel attestationLevel;
        private OffsetDateTime createdDateTime;
        private OffsetDateTime creationDateTime;
        private String displayName;
        private String model;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder aaGuid(String aaGuid) {
            this.aaGuid = aaGuid;
            this.changedFields = changedFields.add("aaGuid");
            return this;
        }

        public Builder attestationCertificates(List<String> attestationCertificates) {
            this.attestationCertificates = attestationCertificates;
            this.changedFields = changedFields.add("attestationCertificates");
            return this;
        }

        public Builder attestationCertificates(String... attestationCertificates) {
            return attestationCertificates(Arrays.asList(attestationCertificates));
        }

        public Builder attestationCertificatesNextLink(String attestationCertificatesNextLink) {
            this.attestationCertificatesNextLink = attestationCertificatesNextLink;
            this.changedFields = changedFields.add("attestationCertificates");
            return this;
        }

        public Builder attestationLevel(AttestationLevel attestationLevel) {
            this.attestationLevel = attestationLevel;
            this.changedFields = changedFields.add("attestationLevel");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        /**
         * <p>
         * <b>Org.OData.Core.V1.Revisions</b>
         * 
         * @param creationDateTime
         *            value of {@code creationDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder creationDateTime(OffsetDateTime creationDateTime) {
            this.creationDateTime = creationDateTime;
            this.changedFields = changedFields.add("creationDateTime");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder model(String model) {
            this.model = model;
            this.changedFields = changedFields.add("model");
            return this;
        }

        public Fido2AuthenticationMethod build() {
            Fido2AuthenticationMethod _x = new Fido2AuthenticationMethod();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.fido2AuthenticationMethod";
            _x.id = id;
            _x.aaGuid = aaGuid;
            _x.attestationCertificates = attestationCertificates;
            _x.attestationCertificatesNextLink = attestationCertificatesNextLink;
            _x.attestationLevel = attestationLevel;
            _x.createdDateTime = createdDateTime;
            _x.creationDateTime = creationDateTime;
            _x.displayName = displayName;
            _x.model = model;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="aaGuid")
    @JsonIgnore
    public Optional<String> getAaGuid() {
        return Optional.ofNullable(aaGuid);
    }

    public Fido2AuthenticationMethod withAaGuid(String aaGuid) {
        Fido2AuthenticationMethod _x = _copy();
        _x.changedFields = changedFields.add("aaGuid");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.fido2AuthenticationMethod");
        _x.aaGuid = aaGuid;
        return _x;
    }

    @Property(name="attestationCertificates")
    @JsonIgnore
    public CollectionPage<String> getAttestationCertificates() {
        return new CollectionPage<String>(contextPath, String.class, this.attestationCertificates, Optional.ofNullable(attestationCertificatesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public Fido2AuthenticationMethod withAttestationCertificates(List<String> attestationCertificates) {
        Fido2AuthenticationMethod _x = _copy();
        _x.changedFields = changedFields.add("attestationCertificates");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.fido2AuthenticationMethod");
        _x.attestationCertificates = attestationCertificates;
        return _x;
    }

    @Property(name="attestationCertificates")
    @JsonIgnore
    public CollectionPage<String> getAttestationCertificates(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.attestationCertificates, Optional.ofNullable(attestationCertificatesNextLink), Collections.emptyList(), options);
    }

    @Property(name="attestationLevel")
    @JsonIgnore
    public Optional<AttestationLevel> getAttestationLevel() {
        return Optional.ofNullable(attestationLevel);
    }

    public Fido2AuthenticationMethod withAttestationLevel(AttestationLevel attestationLevel) {
        Fido2AuthenticationMethod _x = _copy();
        _x.changedFields = changedFields.add("attestationLevel");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.fido2AuthenticationMethod");
        _x.attestationLevel = attestationLevel;
        return _x;
    }

    @Property(name="createdDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedDateTime() {
        return Optional.ofNullable(createdDateTime);
    }

    public Fido2AuthenticationMethod withCreatedDateTime(OffsetDateTime createdDateTime) {
        Fido2AuthenticationMethod _x = _copy();
        _x.changedFields = changedFields.add("createdDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.fido2AuthenticationMethod");
        _x.createdDateTime = createdDateTime;
        return _x;
    }

    /**
     * <p>
     * <b>Org.OData.Core.V1.Revisions</b>
     * 
     * @return property creationDateTime
     */
    @Property(name="creationDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreationDateTime() {
        return Optional.ofNullable(creationDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code creationDateTime}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <b>Org.OData.Core.V1.Revisions</b>
     * 
     * @param creationDateTime
     *            new value of {@code creationDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code creationDateTime} field changed
     */
    public Fido2AuthenticationMethod withCreationDateTime(OffsetDateTime creationDateTime) {
        Fido2AuthenticationMethod _x = _copy();
        _x.changedFields = changedFields.add("creationDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.fido2AuthenticationMethod");
        _x.creationDateTime = creationDateTime;
        return _x;
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public Fido2AuthenticationMethod withDisplayName(String displayName) {
        Fido2AuthenticationMethod _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.fido2AuthenticationMethod");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="model")
    @JsonIgnore
    public Optional<String> getModel() {
        return Optional.ofNullable(model);
    }

    public Fido2AuthenticationMethod withModel(String model) {
        Fido2AuthenticationMethod _x = _copy();
        _x.changedFields = changedFields.add("model");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.fido2AuthenticationMethod");
        _x.model = model;
        return _x;
    }

    public Fido2AuthenticationMethod withUnmappedField(String name, Object value) {
        Fido2AuthenticationMethod _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Fido2AuthenticationMethod patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Fido2AuthenticationMethod _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Fido2AuthenticationMethod put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Fido2AuthenticationMethod _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Fido2AuthenticationMethod _copy() {
        Fido2AuthenticationMethod _x = new Fido2AuthenticationMethod();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.aaGuid = aaGuid;
        _x.attestationCertificates = attestationCertificates;
        _x.attestationLevel = attestationLevel;
        _x.createdDateTime = createdDateTime;
        _x.creationDateTime = creationDateTime;
        _x.displayName = displayName;
        _x.model = model;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Fido2AuthenticationMethod[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("aaGuid=");
        b.append(this.aaGuid);
        b.append(", ");
        b.append("attestationCertificates=");
        b.append(this.attestationCertificates);
        b.append(", ");
        b.append("attestationLevel=");
        b.append(this.attestationLevel);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("creationDateTime=");
        b.append(this.creationDateTime);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("model=");
        b.append(this.model);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
