package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "tenantId", 
    "userId"})
@JsonInclude(Include.NON_NULL)
public class ExternalMeetingRegistrant extends MeetingRegistrantBase implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.externalMeetingRegistrant";
    }

    @JsonProperty("tenantId")
    protected String tenantId;

    @JsonProperty("userId")
    protected String userId;

    protected ExternalMeetingRegistrant() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderExternalMeetingRegistrant() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String joinWebUrl;
        private String tenantId;
        private String userId;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder joinWebUrl(String joinWebUrl) {
            this.joinWebUrl = joinWebUrl;
            this.changedFields = changedFields.add("joinWebUrl");
            return this;
        }

        public Builder tenantId(String tenantId) {
            this.tenantId = tenantId;
            this.changedFields = changedFields.add("tenantId");
            return this;
        }

        public Builder userId(String userId) {
            this.userId = userId;
            this.changedFields = changedFields.add("userId");
            return this;
        }

        public ExternalMeetingRegistrant build() {
            ExternalMeetingRegistrant _x = new ExternalMeetingRegistrant();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.externalMeetingRegistrant";
            _x.id = id;
            _x.joinWebUrl = joinWebUrl;
            _x.tenantId = tenantId;
            _x.userId = userId;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="tenantId")
    @JsonIgnore
    public Optional<String> getTenantId() {
        return Optional.ofNullable(tenantId);
    }

    public ExternalMeetingRegistrant withTenantId(String tenantId) {
        ExternalMeetingRegistrant _x = _copy();
        _x.changedFields = changedFields.add("tenantId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.externalMeetingRegistrant");
        _x.tenantId = tenantId;
        return _x;
    }

    @Property(name="userId")
    @JsonIgnore
    public Optional<String> getUserId() {
        return Optional.ofNullable(userId);
    }

    public ExternalMeetingRegistrant withUserId(String userId) {
        ExternalMeetingRegistrant _x = _copy();
        _x.changedFields = changedFields.add("userId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.externalMeetingRegistrant");
        _x.userId = userId;
        return _x;
    }

    public ExternalMeetingRegistrant withUnmappedField(String name, Object value) {
        ExternalMeetingRegistrant _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ExternalMeetingRegistrant patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        ExternalMeetingRegistrant _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ExternalMeetingRegistrant put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        ExternalMeetingRegistrant _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private ExternalMeetingRegistrant _copy() {
        ExternalMeetingRegistrant _x = new ExternalMeetingRegistrant();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.joinWebUrl = joinWebUrl;
        _x.tenantId = tenantId;
        _x.userId = userId;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ExternalMeetingRegistrant[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("joinWebUrl=");
        b.append(this.joinWebUrl);
        b.append(", ");
        b.append("tenantId=");
        b.append(this.tenantId);
        b.append(", ");
        b.append("userId=");
        b.append(this.userId);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
