package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.complex.ClassificationError;
import odata.msgraph.client.beta.entity.request.ExactMatchUploadAgentRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "checksum", 
    "dataUploadURI", 
    "fields", 
    "fileName", 
    "rowsPerBlock", 
    "salt", 
    "uploadAgentId", 
    "uploadAgent"})
@JsonInclude(Include.NON_NULL)
public class ExactMatchSession extends ExactMatchSessionBase implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.exactMatchSession";
    }

    @JsonProperty("checksum")
    protected String checksum;

    @JsonProperty("dataUploadURI")
    protected String dataUploadURI;

    @JsonProperty("fields")
    protected List<String> fields;

    @JsonProperty("fields@nextLink")
    protected String fieldsNextLink;

    @JsonProperty("fileName")
    protected String fileName;

    @JsonProperty("rowsPerBlock")
    protected Integer rowsPerBlock;

    @JsonProperty("salt")
    protected String salt;

    @JsonProperty("uploadAgentId")
    protected String uploadAgentId;

    @JsonProperty("uploadAgent")
    protected ExactMatchUploadAgent uploadAgent;

    protected ExactMatchSession() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderExactMatchSession() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private OffsetDateTime completionDateTime;
        private OffsetDateTime creationDateTime;
        private ClassificationError error;
        private OffsetDateTime lastUpdatedDateTime;
        private OffsetDateTime startDateTime;
        private String dataStoreId;
        private OffsetDateTime processingCompletionDateTime;
        private Integer remainingBlockCount;
        private Integer remainingJobCount;
        private String state;
        private Integer totalBlockCount;
        private Integer totalJobCount;
        private OffsetDateTime uploadCompletionDateTime;
        private String checksum;
        private String dataUploadURI;
        private List<String> fields;
        private String fieldsNextLink;
        private String fileName;
        private Integer rowsPerBlock;
        private String salt;
        private String uploadAgentId;
        private ExactMatchUploadAgent uploadAgent;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder completionDateTime(OffsetDateTime completionDateTime) {
            this.completionDateTime = completionDateTime;
            this.changedFields = changedFields.add("completionDateTime");
            return this;
        }

        public Builder creationDateTime(OffsetDateTime creationDateTime) {
            this.creationDateTime = creationDateTime;
            this.changedFields = changedFields.add("creationDateTime");
            return this;
        }

        public Builder error(ClassificationError error) {
            this.error = error;
            this.changedFields = changedFields.add("error");
            return this;
        }

        public Builder lastUpdatedDateTime(OffsetDateTime lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
            this.changedFields = changedFields.add("lastUpdatedDateTime");
            return this;
        }

        public Builder startDateTime(OffsetDateTime startDateTime) {
            this.startDateTime = startDateTime;
            this.changedFields = changedFields.add("startDateTime");
            return this;
        }

        public Builder dataStoreId(String dataStoreId) {
            this.dataStoreId = dataStoreId;
            this.changedFields = changedFields.add("dataStoreId");
            return this;
        }

        public Builder processingCompletionDateTime(OffsetDateTime processingCompletionDateTime) {
            this.processingCompletionDateTime = processingCompletionDateTime;
            this.changedFields = changedFields.add("processingCompletionDateTime");
            return this;
        }

        public Builder remainingBlockCount(Integer remainingBlockCount) {
            this.remainingBlockCount = remainingBlockCount;
            this.changedFields = changedFields.add("remainingBlockCount");
            return this;
        }

        public Builder remainingJobCount(Integer remainingJobCount) {
            this.remainingJobCount = remainingJobCount;
            this.changedFields = changedFields.add("remainingJobCount");
            return this;
        }

        public Builder state(String state) {
            this.state = state;
            this.changedFields = changedFields.add("state");
            return this;
        }

        public Builder totalBlockCount(Integer totalBlockCount) {
            this.totalBlockCount = totalBlockCount;
            this.changedFields = changedFields.add("totalBlockCount");
            return this;
        }

        public Builder totalJobCount(Integer totalJobCount) {
            this.totalJobCount = totalJobCount;
            this.changedFields = changedFields.add("totalJobCount");
            return this;
        }

        public Builder uploadCompletionDateTime(OffsetDateTime uploadCompletionDateTime) {
            this.uploadCompletionDateTime = uploadCompletionDateTime;
            this.changedFields = changedFields.add("uploadCompletionDateTime");
            return this;
        }

        public Builder checksum(String checksum) {
            this.checksum = checksum;
            this.changedFields = changedFields.add("checksum");
            return this;
        }

        public Builder dataUploadURI(String dataUploadURI) {
            this.dataUploadURI = dataUploadURI;
            this.changedFields = changedFields.add("dataUploadURI");
            return this;
        }

        public Builder fields(List<String> fields) {
            this.fields = fields;
            this.changedFields = changedFields.add("fields");
            return this;
        }

        public Builder fields(String... fields) {
            return fields(Arrays.asList(fields));
        }

        public Builder fieldsNextLink(String fieldsNextLink) {
            this.fieldsNextLink = fieldsNextLink;
            this.changedFields = changedFields.add("fields");
            return this;
        }

        public Builder fileName(String fileName) {
            this.fileName = fileName;
            this.changedFields = changedFields.add("fileName");
            return this;
        }

        public Builder rowsPerBlock(Integer rowsPerBlock) {
            this.rowsPerBlock = rowsPerBlock;
            this.changedFields = changedFields.add("rowsPerBlock");
            return this;
        }

        public Builder salt(String salt) {
            this.salt = salt;
            this.changedFields = changedFields.add("salt");
            return this;
        }

        public Builder uploadAgentId(String uploadAgentId) {
            this.uploadAgentId = uploadAgentId;
            this.changedFields = changedFields.add("uploadAgentId");
            return this;
        }

        public Builder uploadAgent(ExactMatchUploadAgent uploadAgent) {
            this.uploadAgent = uploadAgent;
            this.changedFields = changedFields.add("uploadAgent");
            return this;
        }

        public ExactMatchSession build() {
            ExactMatchSession _x = new ExactMatchSession();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.exactMatchSession";
            _x.id = id;
            _x.completionDateTime = completionDateTime;
            _x.creationDateTime = creationDateTime;
            _x.error = error;
            _x.lastUpdatedDateTime = lastUpdatedDateTime;
            _x.startDateTime = startDateTime;
            _x.dataStoreId = dataStoreId;
            _x.processingCompletionDateTime = processingCompletionDateTime;
            _x.remainingBlockCount = remainingBlockCount;
            _x.remainingJobCount = remainingJobCount;
            _x.state = state;
            _x.totalBlockCount = totalBlockCount;
            _x.totalJobCount = totalJobCount;
            _x.uploadCompletionDateTime = uploadCompletionDateTime;
            _x.checksum = checksum;
            _x.dataUploadURI = dataUploadURI;
            _x.fields = fields;
            _x.fieldsNextLink = fieldsNextLink;
            _x.fileName = fileName;
            _x.rowsPerBlock = rowsPerBlock;
            _x.salt = salt;
            _x.uploadAgentId = uploadAgentId;
            _x.uploadAgent = uploadAgent;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="checksum")
    @JsonIgnore
    public Optional<String> getChecksum() {
        return Optional.ofNullable(checksum);
    }

    public ExactMatchSession withChecksum(String checksum) {
        ExactMatchSession _x = _copy();
        _x.changedFields = changedFields.add("checksum");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.exactMatchSession");
        _x.checksum = checksum;
        return _x;
    }

    @Property(name="dataUploadURI")
    @JsonIgnore
    public Optional<String> getDataUploadURI() {
        return Optional.ofNullable(dataUploadURI);
    }

    public ExactMatchSession withDataUploadURI(String dataUploadURI) {
        ExactMatchSession _x = _copy();
        _x.changedFields = changedFields.add("dataUploadURI");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.exactMatchSession");
        _x.dataUploadURI = dataUploadURI;
        return _x;
    }

    @Property(name="fields")
    @JsonIgnore
    public CollectionPage<String> getFields() {
        return new CollectionPage<String>(contextPath, String.class, this.fields, Optional.ofNullable(fieldsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public ExactMatchSession withFields(List<String> fields) {
        ExactMatchSession _x = _copy();
        _x.changedFields = changedFields.add("fields");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.exactMatchSession");
        _x.fields = fields;
        return _x;
    }

    @Property(name="fields")
    @JsonIgnore
    public CollectionPage<String> getFields(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.fields, Optional.ofNullable(fieldsNextLink), Collections.emptyList(), options);
    }

    @Property(name="fileName")
    @JsonIgnore
    public Optional<String> getFileName() {
        return Optional.ofNullable(fileName);
    }

    public ExactMatchSession withFileName(String fileName) {
        ExactMatchSession _x = _copy();
        _x.changedFields = changedFields.add("fileName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.exactMatchSession");
        _x.fileName = fileName;
        return _x;
    }

    @Property(name="rowsPerBlock")
    @JsonIgnore
    public Optional<Integer> getRowsPerBlock() {
        return Optional.ofNullable(rowsPerBlock);
    }

    public ExactMatchSession withRowsPerBlock(Integer rowsPerBlock) {
        ExactMatchSession _x = _copy();
        _x.changedFields = changedFields.add("rowsPerBlock");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.exactMatchSession");
        _x.rowsPerBlock = rowsPerBlock;
        return _x;
    }

    @Property(name="salt")
    @JsonIgnore
    public Optional<String> getSalt() {
        return Optional.ofNullable(salt);
    }

    public ExactMatchSession withSalt(String salt) {
        ExactMatchSession _x = _copy();
        _x.changedFields = changedFields.add("salt");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.exactMatchSession");
        _x.salt = salt;
        return _x;
    }

    @Property(name="uploadAgentId")
    @JsonIgnore
    public Optional<String> getUploadAgentId() {
        return Optional.ofNullable(uploadAgentId);
    }

    public ExactMatchSession withUploadAgentId(String uploadAgentId) {
        ExactMatchSession _x = _copy();
        _x.changedFields = changedFields.add("uploadAgentId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.exactMatchSession");
        _x.uploadAgentId = uploadAgentId;
        return _x;
    }

    public ExactMatchSession withUnmappedField(String name, Object value) {
        ExactMatchSession _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="uploadAgent")
    @JsonIgnore
    public ExactMatchUploadAgentRequest getUploadAgent() {
        return new ExactMatchUploadAgentRequest(contextPath.addSegment("uploadAgent"), Optional.ofNullable(uploadAgent));
    }

    public ExactMatchSession withUploadAgent(ExactMatchUploadAgent uploadAgent) {
        ExactMatchSession _x = _copy();
        _x.changedFields = changedFields.add("uploadAgent");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.exactMatchSession");
        _x.uploadAgent = uploadAgent;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ExactMatchSession patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        ExactMatchSession _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ExactMatchSession put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        ExactMatchSession _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private ExactMatchSession _copy() {
        ExactMatchSession _x = new ExactMatchSession();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.completionDateTime = completionDateTime;
        _x.creationDateTime = creationDateTime;
        _x.error = error;
        _x.lastUpdatedDateTime = lastUpdatedDateTime;
        _x.startDateTime = startDateTime;
        _x.dataStoreId = dataStoreId;
        _x.processingCompletionDateTime = processingCompletionDateTime;
        _x.remainingBlockCount = remainingBlockCount;
        _x.remainingJobCount = remainingJobCount;
        _x.state = state;
        _x.totalBlockCount = totalBlockCount;
        _x.totalJobCount = totalJobCount;
        _x.uploadCompletionDateTime = uploadCompletionDateTime;
        _x.checksum = checksum;
        _x.dataUploadURI = dataUploadURI;
        _x.fields = fields;
        _x.fileName = fileName;
        _x.rowsPerBlock = rowsPerBlock;
        _x.salt = salt;
        _x.uploadAgentId = uploadAgentId;
        _x.uploadAgent = uploadAgent;
        return _x;
    }

    @Action(name = "cancel")
    @JsonIgnore
    public ActionRequestNoReturn cancel() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.cancel"), _parameters);
    }

    @Action(name = "renew")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<ExactMatchSession> renew() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestReturningNonCollectionUnwrapped<ExactMatchSession>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.renew"), ExactMatchSession.class, _parameters);
    }

    @Action(name = "commit")
    @JsonIgnore
    public ActionRequestNoReturn commit() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.commit"), _parameters);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ExactMatchSession[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("completionDateTime=");
        b.append(this.completionDateTime);
        b.append(", ");
        b.append("creationDateTime=");
        b.append(this.creationDateTime);
        b.append(", ");
        b.append("error=");
        b.append(this.error);
        b.append(", ");
        b.append("lastUpdatedDateTime=");
        b.append(this.lastUpdatedDateTime);
        b.append(", ");
        b.append("startDateTime=");
        b.append(this.startDateTime);
        b.append(", ");
        b.append("dataStoreId=");
        b.append(this.dataStoreId);
        b.append(", ");
        b.append("processingCompletionDateTime=");
        b.append(this.processingCompletionDateTime);
        b.append(", ");
        b.append("remainingBlockCount=");
        b.append(this.remainingBlockCount);
        b.append(", ");
        b.append("remainingJobCount=");
        b.append(this.remainingJobCount);
        b.append(", ");
        b.append("state=");
        b.append(this.state);
        b.append(", ");
        b.append("totalBlockCount=");
        b.append(this.totalBlockCount);
        b.append(", ");
        b.append("totalJobCount=");
        b.append(this.totalJobCount);
        b.append(", ");
        b.append("uploadCompletionDateTime=");
        b.append(this.uploadCompletionDateTime);
        b.append(", ");
        b.append("checksum=");
        b.append(this.checksum);
        b.append(", ");
        b.append("dataUploadURI=");
        b.append(this.dataUploadURI);
        b.append(", ");
        b.append("fields=");
        b.append(this.fields);
        b.append(", ");
        b.append("fileName=");
        b.append(this.fileName);
        b.append(", ");
        b.append("rowsPerBlock=");
        b.append(this.rowsPerBlock);
        b.append(", ");
        b.append("salt=");
        b.append(this.salt);
        b.append(", ");
        b.append("uploadAgentId=");
        b.append(this.uploadAgentId);
        b.append(", ");
        b.append("uploadAgent=");
        b.append(this.uploadAgent);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
