package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.ClassificationError;
import odata.msgraph.client.beta.entity.collection.request.LookupResultRowCollectionRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "state", 
    "matchingRows"})
@JsonInclude(Include.NON_NULL)
public class ExactMatchLookupJob extends ExactMatchJobBase implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.exactMatchLookupJob";
    }

    @JsonProperty("state")
    protected String state;

    @JsonProperty("matchingRows")
    protected List<LookupResultRow> matchingRows;

    protected ExactMatchLookupJob() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderExactMatchLookupJob() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private OffsetDateTime completionDateTime;
        private OffsetDateTime creationDateTime;
        private ClassificationError error;
        private OffsetDateTime lastUpdatedDateTime;
        private OffsetDateTime startDateTime;
        private String state;
        private List<LookupResultRow> matchingRows;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder completionDateTime(OffsetDateTime completionDateTime) {
            this.completionDateTime = completionDateTime;
            this.changedFields = changedFields.add("completionDateTime");
            return this;
        }

        public Builder creationDateTime(OffsetDateTime creationDateTime) {
            this.creationDateTime = creationDateTime;
            this.changedFields = changedFields.add("creationDateTime");
            return this;
        }

        public Builder error(ClassificationError error) {
            this.error = error;
            this.changedFields = changedFields.add("error");
            return this;
        }

        public Builder lastUpdatedDateTime(OffsetDateTime lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
            this.changedFields = changedFields.add("lastUpdatedDateTime");
            return this;
        }

        public Builder startDateTime(OffsetDateTime startDateTime) {
            this.startDateTime = startDateTime;
            this.changedFields = changedFields.add("startDateTime");
            return this;
        }

        public Builder state(String state) {
            this.state = state;
            this.changedFields = changedFields.add("state");
            return this;
        }

        public Builder matchingRows(List<LookupResultRow> matchingRows) {
            this.matchingRows = matchingRows;
            this.changedFields = changedFields.add("matchingRows");
            return this;
        }

        public Builder matchingRows(LookupResultRow... matchingRows) {
            return matchingRows(Arrays.asList(matchingRows));
        }

        public ExactMatchLookupJob build() {
            ExactMatchLookupJob _x = new ExactMatchLookupJob();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.exactMatchLookupJob";
            _x.id = id;
            _x.completionDateTime = completionDateTime;
            _x.creationDateTime = creationDateTime;
            _x.error = error;
            _x.lastUpdatedDateTime = lastUpdatedDateTime;
            _x.startDateTime = startDateTime;
            _x.state = state;
            _x.matchingRows = matchingRows;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="state")
    @JsonIgnore
    public Optional<String> getState() {
        return Optional.ofNullable(state);
    }

    public ExactMatchLookupJob withState(String state) {
        ExactMatchLookupJob _x = _copy();
        _x.changedFields = changedFields.add("state");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.exactMatchLookupJob");
        _x.state = state;
        return _x;
    }

    public ExactMatchLookupJob withUnmappedField(String name, Object value) {
        ExactMatchLookupJob _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="matchingRows")
    @JsonIgnore
    public LookupResultRowCollectionRequest getMatchingRows() {
        return new LookupResultRowCollectionRequest(
                        contextPath.addSegment("matchingRows"), Optional.ofNullable(matchingRows));
    }

    public ExactMatchLookupJob withMatchingRows(List<LookupResultRow> matchingRows) {
        ExactMatchLookupJob _x = _copy();
        _x.changedFields = changedFields.add("matchingRows");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.exactMatchLookupJob");
        _x.matchingRows = matchingRows;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ExactMatchLookupJob patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        ExactMatchLookupJob _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ExactMatchLookupJob put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        ExactMatchLookupJob _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private ExactMatchLookupJob _copy() {
        ExactMatchLookupJob _x = new ExactMatchLookupJob();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.completionDateTime = completionDateTime;
        _x.creationDateTime = creationDateTime;
        _x.error = error;
        _x.lastUpdatedDateTime = lastUpdatedDateTime;
        _x.startDateTime = startDateTime;
        _x.state = state;
        _x.matchingRows = matchingRows;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ExactMatchLookupJob[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("completionDateTime=");
        b.append(this.completionDateTime);
        b.append(", ");
        b.append("creationDateTime=");
        b.append(this.creationDateTime);
        b.append(", ");
        b.append("error=");
        b.append(this.error);
        b.append(", ");
        b.append("lastUpdatedDateTime=");
        b.append(this.lastUpdatedDateTime);
        b.append(", ");
        b.append("startDateTime=");
        b.append(this.startDateTime);
        b.append(", ");
        b.append("state=");
        b.append(this.state);
        b.append(", ");
        b.append("matchingRows=");
        b.append(this.matchingRows);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
