package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.ExactDataMatchStoreColumn;

@JsonPropertyOrder({
    "@odata.type", 
    "columns", 
    "dataLastUpdatedDateTime", 
    "description", 
    "displayName"})
@JsonInclude(Include.NON_NULL)
public class ExactMatchDataStoreBase extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.exactMatchDataStoreBase";
    }

    @JsonProperty("columns")
    protected List<ExactDataMatchStoreColumn> columns;

    @JsonProperty("columns@nextLink")
    protected String columnsNextLink;

    @JsonProperty("dataLastUpdatedDateTime")
    protected OffsetDateTime dataLastUpdatedDateTime;

    @JsonProperty("description")
    protected String description;

    @JsonProperty("displayName")
    protected String displayName;

    protected ExactMatchDataStoreBase() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderExactMatchDataStoreBase() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private List<ExactDataMatchStoreColumn> columns;
        private String columnsNextLink;
        private OffsetDateTime dataLastUpdatedDateTime;
        private String description;
        private String displayName;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder columns(List<ExactDataMatchStoreColumn> columns) {
            this.columns = columns;
            this.changedFields = changedFields.add("columns");
            return this;
        }

        public Builder columns(ExactDataMatchStoreColumn... columns) {
            return columns(Arrays.asList(columns));
        }

        public Builder columnsNextLink(String columnsNextLink) {
            this.columnsNextLink = columnsNextLink;
            this.changedFields = changedFields.add("columns");
            return this;
        }

        public Builder dataLastUpdatedDateTime(OffsetDateTime dataLastUpdatedDateTime) {
            this.dataLastUpdatedDateTime = dataLastUpdatedDateTime;
            this.changedFields = changedFields.add("dataLastUpdatedDateTime");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public ExactMatchDataStoreBase build() {
            ExactMatchDataStoreBase _x = new ExactMatchDataStoreBase();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.exactMatchDataStoreBase";
            _x.id = id;
            _x.columns = columns;
            _x.columnsNextLink = columnsNextLink;
            _x.dataLastUpdatedDateTime = dataLastUpdatedDateTime;
            _x.description = description;
            _x.displayName = displayName;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="columns")
    @JsonIgnore
    public CollectionPage<ExactDataMatchStoreColumn> getColumns() {
        return new CollectionPage<ExactDataMatchStoreColumn>(contextPath, ExactDataMatchStoreColumn.class, this.columns, Optional.ofNullable(columnsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public ExactMatchDataStoreBase withColumns(List<ExactDataMatchStoreColumn> columns) {
        ExactMatchDataStoreBase _x = _copy();
        _x.changedFields = changedFields.add("columns");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.exactMatchDataStoreBase");
        _x.columns = columns;
        return _x;
    }

    @Property(name="columns")
    @JsonIgnore
    public CollectionPage<ExactDataMatchStoreColumn> getColumns(HttpRequestOptions options) {
        return new CollectionPage<ExactDataMatchStoreColumn>(contextPath, ExactDataMatchStoreColumn.class, this.columns, Optional.ofNullable(columnsNextLink), Collections.emptyList(), options);
    }

    @Property(name="dataLastUpdatedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getDataLastUpdatedDateTime() {
        return Optional.ofNullable(dataLastUpdatedDateTime);
    }

    public ExactMatchDataStoreBase withDataLastUpdatedDateTime(OffsetDateTime dataLastUpdatedDateTime) {
        ExactMatchDataStoreBase _x = _copy();
        _x.changedFields = changedFields.add("dataLastUpdatedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.exactMatchDataStoreBase");
        _x.dataLastUpdatedDateTime = dataLastUpdatedDateTime;
        return _x;
    }

    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    public ExactMatchDataStoreBase withDescription(String description) {
        ExactMatchDataStoreBase _x = _copy();
        _x.changedFields = changedFields.add("description");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.exactMatchDataStoreBase");
        _x.description = description;
        return _x;
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public ExactMatchDataStoreBase withDisplayName(String displayName) {
        ExactMatchDataStoreBase _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.exactMatchDataStoreBase");
        _x.displayName = displayName;
        return _x;
    }

    public ExactMatchDataStoreBase withUnmappedField(String name, Object value) {
        ExactMatchDataStoreBase _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ExactMatchDataStoreBase patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        ExactMatchDataStoreBase _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ExactMatchDataStoreBase put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        ExactMatchDataStoreBase _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private ExactMatchDataStoreBase _copy() {
        ExactMatchDataStoreBase _x = new ExactMatchDataStoreBase();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.columns = columns;
        _x.dataLastUpdatedDateTime = dataLastUpdatedDateTime;
        _x.description = description;
        _x.displayName = displayName;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ExactMatchDataStoreBase[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("columns=");
        b.append(this.columns);
        b.append(", ");
        b.append("dataLastUpdatedDateTime=");
        b.append(this.dataLastUpdatedDateTime);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
