package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "daysUntilExternalUserDeletedAfterBlocked", 
    "externalUserLifecycleAction"})
@JsonInclude(Include.NON_NULL)
public class EntitlementManagementSettings extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.entitlementManagementSettings";
    }

    @JsonProperty("daysUntilExternalUserDeletedAfterBlocked")
    protected Integer daysUntilExternalUserDeletedAfterBlocked;

    @JsonProperty("externalUserLifecycleAction")
    protected String externalUserLifecycleAction;

    protected EntitlementManagementSettings() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderEntitlementManagementSettings() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private Integer daysUntilExternalUserDeletedAfterBlocked;
        private String externalUserLifecycleAction;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder daysUntilExternalUserDeletedAfterBlocked(Integer daysUntilExternalUserDeletedAfterBlocked) {
            this.daysUntilExternalUserDeletedAfterBlocked = daysUntilExternalUserDeletedAfterBlocked;
            this.changedFields = changedFields.add("daysUntilExternalUserDeletedAfterBlocked");
            return this;
        }

        public Builder externalUserLifecycleAction(String externalUserLifecycleAction) {
            this.externalUserLifecycleAction = externalUserLifecycleAction;
            this.changedFields = changedFields.add("externalUserLifecycleAction");
            return this;
        }

        public EntitlementManagementSettings build() {
            EntitlementManagementSettings _x = new EntitlementManagementSettings();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.entitlementManagementSettings";
            _x.id = id;
            _x.daysUntilExternalUserDeletedAfterBlocked = daysUntilExternalUserDeletedAfterBlocked;
            _x.externalUserLifecycleAction = externalUserLifecycleAction;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="daysUntilExternalUserDeletedAfterBlocked")
    @JsonIgnore
    public Optional<Integer> getDaysUntilExternalUserDeletedAfterBlocked() {
        return Optional.ofNullable(daysUntilExternalUserDeletedAfterBlocked);
    }

    public EntitlementManagementSettings withDaysUntilExternalUserDeletedAfterBlocked(Integer daysUntilExternalUserDeletedAfterBlocked) {
        EntitlementManagementSettings _x = _copy();
        _x.changedFields = changedFields.add("daysUntilExternalUserDeletedAfterBlocked");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.entitlementManagementSettings");
        _x.daysUntilExternalUserDeletedAfterBlocked = daysUntilExternalUserDeletedAfterBlocked;
        return _x;
    }

    @Property(name="externalUserLifecycleAction")
    @JsonIgnore
    public Optional<String> getExternalUserLifecycleAction() {
        return Optional.ofNullable(externalUserLifecycleAction);
    }

    public EntitlementManagementSettings withExternalUserLifecycleAction(String externalUserLifecycleAction) {
        EntitlementManagementSettings _x = _copy();
        _x.changedFields = changedFields.add("externalUserLifecycleAction");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.entitlementManagementSettings");
        _x.externalUserLifecycleAction = externalUserLifecycleAction;
        return _x;
    }

    public EntitlementManagementSettings withUnmappedField(String name, Object value) {
        EntitlementManagementSettings _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public EntitlementManagementSettings patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        EntitlementManagementSettings _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public EntitlementManagementSettings put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        EntitlementManagementSettings _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private EntitlementManagementSettings _copy() {
        EntitlementManagementSettings _x = new EntitlementManagementSettings();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.daysUntilExternalUserDeletedAfterBlocked = daysUntilExternalUserDeletedAfterBlocked;
        _x.externalUserLifecycleAction = externalUserLifecycleAction;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("EntitlementManagementSettings[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("daysUntilExternalUserDeletedAfterBlocked=");
        b.append(this.daysUntilExternalUserDeletedAfterBlocked);
        b.append(", ");
        b.append("externalUserLifecycleAction=");
        b.append(this.externalUserLifecycleAction);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
