package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.entity.collection.request.AccessPackageAssignmentCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.AccessPackageAssignmentPolicyCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.AccessPackageAssignmentRequestCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.AccessPackageAssignmentResourceRoleCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.AccessPackageCatalogCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.AccessPackageCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.AccessPackageResourceCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.AccessPackageResourceEnvironmentCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.AccessPackageResourceRequestCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.AccessPackageResourceRoleScopeCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ApprovalCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ConnectedOrganizationCollectionRequest;
import odata.msgraph.client.beta.entity.request.EntitlementManagementSettingsRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "accessPackageAssignmentApprovals", 
    "accessPackageAssignmentPolicies", 
    "accessPackageAssignmentRequests", 
    "accessPackageAssignmentResourceRoles", 
    "accessPackageAssignments", 
    "accessPackageCatalogs", 
    "accessPackageResourceEnvironments", 
    "accessPackageResourceRequests", 
    "accessPackageResourceRoleScopes", 
    "accessPackageResources", 
    "accessPackages", 
    "connectedOrganizations", 
    "settings"})
@JsonInclude(Include.NON_NULL)
public class EntitlementManagement extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.entitlementManagement";
    }

    @JsonProperty("accessPackageAssignmentApprovals")
    protected List<Approval> accessPackageAssignmentApprovals;

    @JsonProperty("accessPackageAssignmentPolicies")
    protected List<AccessPackageAssignmentPolicy> accessPackageAssignmentPolicies;

    @JsonProperty("accessPackageAssignmentRequests")
    protected List<AccessPackageAssignmentRequest> accessPackageAssignmentRequests;

    @JsonProperty("accessPackageAssignmentResourceRoles")
    protected List<AccessPackageAssignmentResourceRole> accessPackageAssignmentResourceRoles;

    @JsonProperty("accessPackageAssignments")
    protected List<AccessPackageAssignment> accessPackageAssignments;

    @JsonProperty("accessPackageCatalogs")
    protected List<AccessPackageCatalog> accessPackageCatalogs;

    @JsonProperty("accessPackageResourceEnvironments")
    protected List<AccessPackageResourceEnvironment> accessPackageResourceEnvironments;

    @JsonProperty("accessPackageResourceRequests")
    protected List<AccessPackageResourceRequest> accessPackageResourceRequests;

    @JsonProperty("accessPackageResourceRoleScopes")
    protected List<AccessPackageResourceRoleScope> accessPackageResourceRoleScopes;

    @JsonProperty("accessPackageResources")
    protected List<AccessPackageResource> accessPackageResources;

    @JsonProperty("accessPackages")
    protected List<AccessPackage> accessPackages;

    @JsonProperty("connectedOrganizations")
    protected List<ConnectedOrganization> connectedOrganizations;

    @JsonProperty("settings")
    protected EntitlementManagementSettings settings;

    protected EntitlementManagement() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderEntitlementManagement() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private List<Approval> accessPackageAssignmentApprovals;
        private List<AccessPackageAssignmentPolicy> accessPackageAssignmentPolicies;
        private List<AccessPackageAssignmentRequest> accessPackageAssignmentRequests;
        private List<AccessPackageAssignmentResourceRole> accessPackageAssignmentResourceRoles;
        private List<AccessPackageAssignment> accessPackageAssignments;
        private List<AccessPackageCatalog> accessPackageCatalogs;
        private List<AccessPackageResourceEnvironment> accessPackageResourceEnvironments;
        private List<AccessPackageResourceRequest> accessPackageResourceRequests;
        private List<AccessPackageResourceRoleScope> accessPackageResourceRoleScopes;
        private List<AccessPackageResource> accessPackageResources;
        private List<AccessPackage> accessPackages;
        private List<ConnectedOrganization> connectedOrganizations;
        private EntitlementManagementSettings settings;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder accessPackageAssignmentApprovals(List<Approval> accessPackageAssignmentApprovals) {
            this.accessPackageAssignmentApprovals = accessPackageAssignmentApprovals;
            this.changedFields = changedFields.add("accessPackageAssignmentApprovals");
            return this;
        }

        public Builder accessPackageAssignmentApprovals(Approval... accessPackageAssignmentApprovals) {
            return accessPackageAssignmentApprovals(Arrays.asList(accessPackageAssignmentApprovals));
        }

        public Builder accessPackageAssignmentPolicies(List<AccessPackageAssignmentPolicy> accessPackageAssignmentPolicies) {
            this.accessPackageAssignmentPolicies = accessPackageAssignmentPolicies;
            this.changedFields = changedFields.add("accessPackageAssignmentPolicies");
            return this;
        }

        public Builder accessPackageAssignmentPolicies(AccessPackageAssignmentPolicy... accessPackageAssignmentPolicies) {
            return accessPackageAssignmentPolicies(Arrays.asList(accessPackageAssignmentPolicies));
        }

        public Builder accessPackageAssignmentRequests(List<AccessPackageAssignmentRequest> accessPackageAssignmentRequests) {
            this.accessPackageAssignmentRequests = accessPackageAssignmentRequests;
            this.changedFields = changedFields.add("accessPackageAssignmentRequests");
            return this;
        }

        public Builder accessPackageAssignmentRequests(AccessPackageAssignmentRequest... accessPackageAssignmentRequests) {
            return accessPackageAssignmentRequests(Arrays.asList(accessPackageAssignmentRequests));
        }

        public Builder accessPackageAssignmentResourceRoles(List<AccessPackageAssignmentResourceRole> accessPackageAssignmentResourceRoles) {
            this.accessPackageAssignmentResourceRoles = accessPackageAssignmentResourceRoles;
            this.changedFields = changedFields.add("accessPackageAssignmentResourceRoles");
            return this;
        }

        public Builder accessPackageAssignmentResourceRoles(AccessPackageAssignmentResourceRole... accessPackageAssignmentResourceRoles) {
            return accessPackageAssignmentResourceRoles(Arrays.asList(accessPackageAssignmentResourceRoles));
        }

        public Builder accessPackageAssignments(List<AccessPackageAssignment> accessPackageAssignments) {
            this.accessPackageAssignments = accessPackageAssignments;
            this.changedFields = changedFields.add("accessPackageAssignments");
            return this;
        }

        public Builder accessPackageAssignments(AccessPackageAssignment... accessPackageAssignments) {
            return accessPackageAssignments(Arrays.asList(accessPackageAssignments));
        }

        public Builder accessPackageCatalogs(List<AccessPackageCatalog> accessPackageCatalogs) {
            this.accessPackageCatalogs = accessPackageCatalogs;
            this.changedFields = changedFields.add("accessPackageCatalogs");
            return this;
        }

        public Builder accessPackageCatalogs(AccessPackageCatalog... accessPackageCatalogs) {
            return accessPackageCatalogs(Arrays.asList(accessPackageCatalogs));
        }

        public Builder accessPackageResourceEnvironments(List<AccessPackageResourceEnvironment> accessPackageResourceEnvironments) {
            this.accessPackageResourceEnvironments = accessPackageResourceEnvironments;
            this.changedFields = changedFields.add("accessPackageResourceEnvironments");
            return this;
        }

        public Builder accessPackageResourceEnvironments(AccessPackageResourceEnvironment... accessPackageResourceEnvironments) {
            return accessPackageResourceEnvironments(Arrays.asList(accessPackageResourceEnvironments));
        }

        public Builder accessPackageResourceRequests(List<AccessPackageResourceRequest> accessPackageResourceRequests) {
            this.accessPackageResourceRequests = accessPackageResourceRequests;
            this.changedFields = changedFields.add("accessPackageResourceRequests");
            return this;
        }

        public Builder accessPackageResourceRequests(AccessPackageResourceRequest... accessPackageResourceRequests) {
            return accessPackageResourceRequests(Arrays.asList(accessPackageResourceRequests));
        }

        public Builder accessPackageResourceRoleScopes(List<AccessPackageResourceRoleScope> accessPackageResourceRoleScopes) {
            this.accessPackageResourceRoleScopes = accessPackageResourceRoleScopes;
            this.changedFields = changedFields.add("accessPackageResourceRoleScopes");
            return this;
        }

        public Builder accessPackageResourceRoleScopes(AccessPackageResourceRoleScope... accessPackageResourceRoleScopes) {
            return accessPackageResourceRoleScopes(Arrays.asList(accessPackageResourceRoleScopes));
        }

        public Builder accessPackageResources(List<AccessPackageResource> accessPackageResources) {
            this.accessPackageResources = accessPackageResources;
            this.changedFields = changedFields.add("accessPackageResources");
            return this;
        }

        public Builder accessPackageResources(AccessPackageResource... accessPackageResources) {
            return accessPackageResources(Arrays.asList(accessPackageResources));
        }

        public Builder accessPackages(List<AccessPackage> accessPackages) {
            this.accessPackages = accessPackages;
            this.changedFields = changedFields.add("accessPackages");
            return this;
        }

        public Builder accessPackages(AccessPackage... accessPackages) {
            return accessPackages(Arrays.asList(accessPackages));
        }

        public Builder connectedOrganizations(List<ConnectedOrganization> connectedOrganizations) {
            this.connectedOrganizations = connectedOrganizations;
            this.changedFields = changedFields.add("connectedOrganizations");
            return this;
        }

        public Builder connectedOrganizations(ConnectedOrganization... connectedOrganizations) {
            return connectedOrganizations(Arrays.asList(connectedOrganizations));
        }

        public Builder settings(EntitlementManagementSettings settings) {
            this.settings = settings;
            this.changedFields = changedFields.add("settings");
            return this;
        }

        public EntitlementManagement build() {
            EntitlementManagement _x = new EntitlementManagement();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.entitlementManagement";
            _x.id = id;
            _x.accessPackageAssignmentApprovals = accessPackageAssignmentApprovals;
            _x.accessPackageAssignmentPolicies = accessPackageAssignmentPolicies;
            _x.accessPackageAssignmentRequests = accessPackageAssignmentRequests;
            _x.accessPackageAssignmentResourceRoles = accessPackageAssignmentResourceRoles;
            _x.accessPackageAssignments = accessPackageAssignments;
            _x.accessPackageCatalogs = accessPackageCatalogs;
            _x.accessPackageResourceEnvironments = accessPackageResourceEnvironments;
            _x.accessPackageResourceRequests = accessPackageResourceRequests;
            _x.accessPackageResourceRoleScopes = accessPackageResourceRoleScopes;
            _x.accessPackageResources = accessPackageResources;
            _x.accessPackages = accessPackages;
            _x.connectedOrganizations = connectedOrganizations;
            _x.settings = settings;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    public EntitlementManagement withUnmappedField(String name, Object value) {
        EntitlementManagement _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="accessPackageAssignmentApprovals")
    @JsonIgnore
    public ApprovalCollectionRequest getAccessPackageAssignmentApprovals() {
        return new ApprovalCollectionRequest(
                        contextPath.addSegment("accessPackageAssignmentApprovals"), Optional.ofNullable(accessPackageAssignmentApprovals));
    }

    @NavigationProperty(name="accessPackageAssignmentPolicies")
    @JsonIgnore
    public AccessPackageAssignmentPolicyCollectionRequest getAccessPackageAssignmentPolicies() {
        return new AccessPackageAssignmentPolicyCollectionRequest(
                        contextPath.addSegment("accessPackageAssignmentPolicies"), Optional.ofNullable(accessPackageAssignmentPolicies));
    }

    @NavigationProperty(name="accessPackageAssignmentRequests")
    @JsonIgnore
    public AccessPackageAssignmentRequestCollectionRequest getAccessPackageAssignmentRequests() {
        return new AccessPackageAssignmentRequestCollectionRequest(
                        contextPath.addSegment("accessPackageAssignmentRequests"), Optional.ofNullable(accessPackageAssignmentRequests));
    }

    @NavigationProperty(name="accessPackageAssignmentResourceRoles")
    @JsonIgnore
    public AccessPackageAssignmentResourceRoleCollectionRequest getAccessPackageAssignmentResourceRoles() {
        return new AccessPackageAssignmentResourceRoleCollectionRequest(
                        contextPath.addSegment("accessPackageAssignmentResourceRoles"), Optional.ofNullable(accessPackageAssignmentResourceRoles));
    }

    @NavigationProperty(name="accessPackageAssignments")
    @JsonIgnore
    public AccessPackageAssignmentCollectionRequest getAccessPackageAssignments() {
        return new AccessPackageAssignmentCollectionRequest(
                        contextPath.addSegment("accessPackageAssignments"), Optional.ofNullable(accessPackageAssignments));
    }

    @NavigationProperty(name="accessPackageCatalogs")
    @JsonIgnore
    public AccessPackageCatalogCollectionRequest getAccessPackageCatalogs() {
        return new AccessPackageCatalogCollectionRequest(
                        contextPath.addSegment("accessPackageCatalogs"), Optional.ofNullable(accessPackageCatalogs));
    }

    @NavigationProperty(name="accessPackageResourceEnvironments")
    @JsonIgnore
    public AccessPackageResourceEnvironmentCollectionRequest getAccessPackageResourceEnvironments() {
        return new AccessPackageResourceEnvironmentCollectionRequest(
                        contextPath.addSegment("accessPackageResourceEnvironments"), Optional.ofNullable(accessPackageResourceEnvironments));
    }

    @NavigationProperty(name="accessPackageResourceRequests")
    @JsonIgnore
    public AccessPackageResourceRequestCollectionRequest getAccessPackageResourceRequests() {
        return new AccessPackageResourceRequestCollectionRequest(
                        contextPath.addSegment("accessPackageResourceRequests"), Optional.ofNullable(accessPackageResourceRequests));
    }

    @NavigationProperty(name="accessPackageResourceRoleScopes")
    @JsonIgnore
    public AccessPackageResourceRoleScopeCollectionRequest getAccessPackageResourceRoleScopes() {
        return new AccessPackageResourceRoleScopeCollectionRequest(
                        contextPath.addSegment("accessPackageResourceRoleScopes"), Optional.ofNullable(accessPackageResourceRoleScopes));
    }

    @NavigationProperty(name="accessPackageResources")
    @JsonIgnore
    public AccessPackageResourceCollectionRequest getAccessPackageResources() {
        return new AccessPackageResourceCollectionRequest(
                        contextPath.addSegment("accessPackageResources"), Optional.ofNullable(accessPackageResources));
    }

    @NavigationProperty(name="accessPackages")
    @JsonIgnore
    public AccessPackageCollectionRequest getAccessPackages() {
        return new AccessPackageCollectionRequest(
                        contextPath.addSegment("accessPackages"), Optional.ofNullable(accessPackages));
    }

    @NavigationProperty(name="connectedOrganizations")
    @JsonIgnore
    public ConnectedOrganizationCollectionRequest getConnectedOrganizations() {
        return new ConnectedOrganizationCollectionRequest(
                        contextPath.addSegment("connectedOrganizations"), Optional.ofNullable(connectedOrganizations));
    }

    @NavigationProperty(name="settings")
    @JsonIgnore
    public EntitlementManagementSettingsRequest getSettings() {
        return new EntitlementManagementSettingsRequest(contextPath.addSegment("settings"), Optional.ofNullable(settings));
    }

    public EntitlementManagement withAccessPackageAssignmentApprovals(List<Approval> accessPackageAssignmentApprovals) {
        EntitlementManagement _x = _copy();
        _x.changedFields = changedFields.add("accessPackageAssignmentApprovals");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.entitlementManagement");
        _x.accessPackageAssignmentApprovals = accessPackageAssignmentApprovals;
        return _x;
    }

    public EntitlementManagement withAccessPackageAssignmentPolicies(List<AccessPackageAssignmentPolicy> accessPackageAssignmentPolicies) {
        EntitlementManagement _x = _copy();
        _x.changedFields = changedFields.add("accessPackageAssignmentPolicies");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.entitlementManagement");
        _x.accessPackageAssignmentPolicies = accessPackageAssignmentPolicies;
        return _x;
    }

    public EntitlementManagement withAccessPackageAssignmentRequests(List<AccessPackageAssignmentRequest> accessPackageAssignmentRequests) {
        EntitlementManagement _x = _copy();
        _x.changedFields = changedFields.add("accessPackageAssignmentRequests");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.entitlementManagement");
        _x.accessPackageAssignmentRequests = accessPackageAssignmentRequests;
        return _x;
    }

    public EntitlementManagement withAccessPackageAssignmentResourceRoles(List<AccessPackageAssignmentResourceRole> accessPackageAssignmentResourceRoles) {
        EntitlementManagement _x = _copy();
        _x.changedFields = changedFields.add("accessPackageAssignmentResourceRoles");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.entitlementManagement");
        _x.accessPackageAssignmentResourceRoles = accessPackageAssignmentResourceRoles;
        return _x;
    }

    public EntitlementManagement withAccessPackageAssignments(List<AccessPackageAssignment> accessPackageAssignments) {
        EntitlementManagement _x = _copy();
        _x.changedFields = changedFields.add("accessPackageAssignments");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.entitlementManagement");
        _x.accessPackageAssignments = accessPackageAssignments;
        return _x;
    }

    public EntitlementManagement withAccessPackageCatalogs(List<AccessPackageCatalog> accessPackageCatalogs) {
        EntitlementManagement _x = _copy();
        _x.changedFields = changedFields.add("accessPackageCatalogs");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.entitlementManagement");
        _x.accessPackageCatalogs = accessPackageCatalogs;
        return _x;
    }

    public EntitlementManagement withAccessPackageResourceEnvironments(List<AccessPackageResourceEnvironment> accessPackageResourceEnvironments) {
        EntitlementManagement _x = _copy();
        _x.changedFields = changedFields.add("accessPackageResourceEnvironments");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.entitlementManagement");
        _x.accessPackageResourceEnvironments = accessPackageResourceEnvironments;
        return _x;
    }

    public EntitlementManagement withAccessPackageResourceRequests(List<AccessPackageResourceRequest> accessPackageResourceRequests) {
        EntitlementManagement _x = _copy();
        _x.changedFields = changedFields.add("accessPackageResourceRequests");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.entitlementManagement");
        _x.accessPackageResourceRequests = accessPackageResourceRequests;
        return _x;
    }

    public EntitlementManagement withAccessPackageResourceRoleScopes(List<AccessPackageResourceRoleScope> accessPackageResourceRoleScopes) {
        EntitlementManagement _x = _copy();
        _x.changedFields = changedFields.add("accessPackageResourceRoleScopes");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.entitlementManagement");
        _x.accessPackageResourceRoleScopes = accessPackageResourceRoleScopes;
        return _x;
    }

    public EntitlementManagement withAccessPackageResources(List<AccessPackageResource> accessPackageResources) {
        EntitlementManagement _x = _copy();
        _x.changedFields = changedFields.add("accessPackageResources");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.entitlementManagement");
        _x.accessPackageResources = accessPackageResources;
        return _x;
    }

    public EntitlementManagement withAccessPackages(List<AccessPackage> accessPackages) {
        EntitlementManagement _x = _copy();
        _x.changedFields = changedFields.add("accessPackages");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.entitlementManagement");
        _x.accessPackages = accessPackages;
        return _x;
    }

    public EntitlementManagement withConnectedOrganizations(List<ConnectedOrganization> connectedOrganizations) {
        EntitlementManagement _x = _copy();
        _x.changedFields = changedFields.add("connectedOrganizations");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.entitlementManagement");
        _x.connectedOrganizations = connectedOrganizations;
        return _x;
    }

    public EntitlementManagement withSettings(EntitlementManagementSettings settings) {
        EntitlementManagement _x = _copy();
        _x.changedFields = changedFields.add("settings");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.entitlementManagement");
        _x.settings = settings;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public EntitlementManagement patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        EntitlementManagement _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public EntitlementManagement put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        EntitlementManagement _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private EntitlementManagement _copy() {
        EntitlementManagement _x = new EntitlementManagement();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.accessPackageAssignmentApprovals = accessPackageAssignmentApprovals;
        _x.accessPackageAssignmentPolicies = accessPackageAssignmentPolicies;
        _x.accessPackageAssignmentRequests = accessPackageAssignmentRequests;
        _x.accessPackageAssignmentResourceRoles = accessPackageAssignmentResourceRoles;
        _x.accessPackageAssignments = accessPackageAssignments;
        _x.accessPackageCatalogs = accessPackageCatalogs;
        _x.accessPackageResourceEnvironments = accessPackageResourceEnvironments;
        _x.accessPackageResourceRequests = accessPackageResourceRequests;
        _x.accessPackageResourceRoleScopes = accessPackageResourceRoleScopes;
        _x.accessPackageResources = accessPackageResources;
        _x.accessPackages = accessPackages;
        _x.connectedOrganizations = connectedOrganizations;
        _x.settings = settings;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("EntitlementManagement[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("accessPackageAssignmentApprovals=");
        b.append(this.accessPackageAssignmentApprovals);
        b.append(", ");
        b.append("accessPackageAssignmentPolicies=");
        b.append(this.accessPackageAssignmentPolicies);
        b.append(", ");
        b.append("accessPackageAssignmentRequests=");
        b.append(this.accessPackageAssignmentRequests);
        b.append(", ");
        b.append("accessPackageAssignmentResourceRoles=");
        b.append(this.accessPackageAssignmentResourceRoles);
        b.append(", ");
        b.append("accessPackageAssignments=");
        b.append(this.accessPackageAssignments);
        b.append(", ");
        b.append("accessPackageCatalogs=");
        b.append(this.accessPackageCatalogs);
        b.append(", ");
        b.append("accessPackageResourceEnvironments=");
        b.append(this.accessPackageResourceEnvironments);
        b.append(", ");
        b.append("accessPackageResourceRequests=");
        b.append(this.accessPackageResourceRequests);
        b.append(", ");
        b.append("accessPackageResourceRoleScopes=");
        b.append(this.accessPackageResourceRoleScopes);
        b.append(", ");
        b.append("accessPackageResources=");
        b.append(this.accessPackageResources);
        b.append(", ");
        b.append("accessPackages=");
        b.append(this.accessPackages);
        b.append(", ");
        b.append("connectedOrganizations=");
        b.append(this.connectedOrganizations);
        b.append(", ");
        b.append("settings=");
        b.append(this.settings);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
