package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.enums.ErrorCode;
import odata.msgraph.client.beta.enums.PolicySetStatus;


/**
 * <i>“A class containing the properties used for enrollment restriction PolicySetItem.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "limit", 
    "priority"})
@JsonInclude(Include.NON_NULL)
public class EnrollmentRestrictionsConfigurationPolicySetItem extends PolicySetItem implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.enrollmentRestrictionsConfigurationPolicySetItem";
    }

    @JsonProperty("limit")
    protected Integer limit;

    @JsonProperty("priority")
    protected Integer priority;

    protected EnrollmentRestrictionsConfigurationPolicySetItem() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderEnrollmentRestrictionsConfigurationPolicySetItem() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private OffsetDateTime createdDateTime;
        private String displayName;
        private ErrorCode errorCode;
        private List<String> guidedDeploymentTags;
        private String guidedDeploymentTagsNextLink;
        private String itemType;
        private OffsetDateTime lastModifiedDateTime;
        private String payloadId;
        private PolicySetStatus status;
        private Integer limit;
        private Integer priority;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder errorCode(ErrorCode errorCode) {
            this.errorCode = errorCode;
            this.changedFields = changedFields.add("errorCode");
            return this;
        }

        public Builder guidedDeploymentTags(List<String> guidedDeploymentTags) {
            this.guidedDeploymentTags = guidedDeploymentTags;
            this.changedFields = changedFields.add("guidedDeploymentTags");
            return this;
        }

        public Builder guidedDeploymentTags(String... guidedDeploymentTags) {
            return guidedDeploymentTags(Arrays.asList(guidedDeploymentTags));
        }

        public Builder guidedDeploymentTagsNextLink(String guidedDeploymentTagsNextLink) {
            this.guidedDeploymentTagsNextLink = guidedDeploymentTagsNextLink;
            this.changedFields = changedFields.add("guidedDeploymentTags");
            return this;
        }

        public Builder itemType(String itemType) {
            this.itemType = itemType;
            this.changedFields = changedFields.add("itemType");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder payloadId(String payloadId) {
            this.payloadId = payloadId;
            this.changedFields = changedFields.add("payloadId");
            return this;
        }

        public Builder status(PolicySetStatus status) {
            this.status = status;
            this.changedFields = changedFields.add("status");
            return this;
        }

        /**
         * <i>“Limit of the EnrollmentRestrictionsConfigurationPolicySetItem.”</i>
         * 
         * @param limit
         *            value of {@code limit} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder limit(Integer limit) {
            this.limit = limit;
            this.changedFields = changedFields.add("limit");
            return this;
        }

        /**
         * <i>“Priority of the EnrollmentRestrictionsConfigurationPolicySetItem.”</i>
         * 
         * @param priority
         *            value of {@code priority} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder priority(Integer priority) {
            this.priority = priority;
            this.changedFields = changedFields.add("priority");
            return this;
        }

        public EnrollmentRestrictionsConfigurationPolicySetItem build() {
            EnrollmentRestrictionsConfigurationPolicySetItem _x = new EnrollmentRestrictionsConfigurationPolicySetItem();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.enrollmentRestrictionsConfigurationPolicySetItem";
            _x.id = id;
            _x.createdDateTime = createdDateTime;
            _x.displayName = displayName;
            _x.errorCode = errorCode;
            _x.guidedDeploymentTags = guidedDeploymentTags;
            _x.guidedDeploymentTagsNextLink = guidedDeploymentTagsNextLink;
            _x.itemType = itemType;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.payloadId = payloadId;
            _x.status = status;
            _x.limit = limit;
            _x.priority = priority;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“Limit of the EnrollmentRestrictionsConfigurationPolicySetItem.”</i>
     * 
     * @return property limit
     */
    @Property(name="limit")
    @JsonIgnore
    public Optional<Integer> getLimit() {
        return Optional.ofNullable(limit);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code limit} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Limit of the EnrollmentRestrictionsConfigurationPolicySetItem.”</i>
     * 
     * @param limit
     *            new value of {@code limit} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code limit} field changed
     */
    public EnrollmentRestrictionsConfigurationPolicySetItem withLimit(Integer limit) {
        EnrollmentRestrictionsConfigurationPolicySetItem _x = _copy();
        _x.changedFields = changedFields.add("limit");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.enrollmentRestrictionsConfigurationPolicySetItem");
        _x.limit = limit;
        return _x;
    }

    /**
     * <i>“Priority of the EnrollmentRestrictionsConfigurationPolicySetItem.”</i>
     * 
     * @return property priority
     */
    @Property(name="priority")
    @JsonIgnore
    public Optional<Integer> getPriority() {
        return Optional.ofNullable(priority);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code priority} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Priority of the EnrollmentRestrictionsConfigurationPolicySetItem.”</i>
     * 
     * @param priority
     *            new value of {@code priority} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code priority} field changed
     */
    public EnrollmentRestrictionsConfigurationPolicySetItem withPriority(Integer priority) {
        EnrollmentRestrictionsConfigurationPolicySetItem _x = _copy();
        _x.changedFields = changedFields.add("priority");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.enrollmentRestrictionsConfigurationPolicySetItem");
        _x.priority = priority;
        return _x;
    }

    public EnrollmentRestrictionsConfigurationPolicySetItem withUnmappedField(String name, Object value) {
        EnrollmentRestrictionsConfigurationPolicySetItem _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public EnrollmentRestrictionsConfigurationPolicySetItem patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        EnrollmentRestrictionsConfigurationPolicySetItem _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public EnrollmentRestrictionsConfigurationPolicySetItem put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        EnrollmentRestrictionsConfigurationPolicySetItem _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private EnrollmentRestrictionsConfigurationPolicySetItem _copy() {
        EnrollmentRestrictionsConfigurationPolicySetItem _x = new EnrollmentRestrictionsConfigurationPolicySetItem();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.createdDateTime = createdDateTime;
        _x.displayName = displayName;
        _x.errorCode = errorCode;
        _x.guidedDeploymentTags = guidedDeploymentTags;
        _x.itemType = itemType;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.payloadId = payloadId;
        _x.status = status;
        _x.limit = limit;
        _x.priority = priority;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("EnrollmentRestrictionsConfigurationPolicySetItem[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("errorCode=");
        b.append(this.errorCode);
        b.append(", ");
        b.append("guidedDeploymentTags=");
        b.append(this.guidedDeploymentTags);
        b.append(", ");
        b.append("itemType=");
        b.append(this.itemType);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("payloadId=");
        b.append(this.payloadId);
        b.append(", ");
        b.append("status=");
        b.append(this.status);
        b.append(", ");
        b.append("limit=");
        b.append(this.limit);
        b.append(", ");
        b.append("priority=");
        b.append(this.priority);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
