package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.FunctionRequestReturningNonCollection;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.List;
import java.util.Map;
import java.util.Optional;


/**
 * <i>“The enrollmentProfile resource represents a collection of configurations which
 * must be provided pre-enrollment to enable enrolling certain devices whose
 * identities have been pre-staged. Pre-staged device identities are assigned to
 * this type of profile to apply the profile's configurations at enrollment of the
 * corresponding device.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "configurationEndpointUrl", 
    "description", 
    "displayName", 
    "enableAuthenticationViaCompanyPortal", 
    "requireCompanyPortalOnSetupAssistantEnrolledDevices", 
    "requiresUserAuthentication"})
@JsonInclude(Include.NON_NULL)
public class EnrollmentProfile extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.enrollmentProfile";
    }

    @JsonProperty("configurationEndpointUrl")
    protected String configurationEndpointUrl;

    @JsonProperty("description")
    protected String description;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("enableAuthenticationViaCompanyPortal")
    protected Boolean enableAuthenticationViaCompanyPortal;

    @JsonProperty("requireCompanyPortalOnSetupAssistantEnrolledDevices")
    protected Boolean requireCompanyPortalOnSetupAssistantEnrolledDevices;

    @JsonProperty("requiresUserAuthentication")
    protected Boolean requiresUserAuthentication;

    protected EnrollmentProfile() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderEnrollmentProfile() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String configurationEndpointUrl;
        private String description;
        private String displayName;
        private Boolean enableAuthenticationViaCompanyPortal;
        private Boolean requireCompanyPortalOnSetupAssistantEnrolledDevices;
        private Boolean requiresUserAuthentication;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“Configuration endpoint url to use for Enrollment”</i>
         * 
         * @param configurationEndpointUrl
         *            value of {@code configurationEndpointUrl} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder configurationEndpointUrl(String configurationEndpointUrl) {
            this.configurationEndpointUrl = configurationEndpointUrl;
            this.changedFields = changedFields.add("configurationEndpointUrl");
            return this;
        }

        /**
         * <i>“Description of the profile”</i>
         * 
         * @param description
         *            value of {@code description} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        /**
         * <i>“Name of the profile”</i>
         * 
         * @param displayName
         *            value of {@code displayName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        /**
         * <i>“Indicates to authenticate with Apple Setup Assistant instead of Company Portal.”</i>
         * 
         * @param enableAuthenticationViaCompanyPortal
         *            value of {@code enableAuthenticationViaCompanyPortal} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder enableAuthenticationViaCompanyPortal(Boolean enableAuthenticationViaCompanyPortal) {
            this.enableAuthenticationViaCompanyPortal = enableAuthenticationViaCompanyPortal;
            this.changedFields = changedFields.add("enableAuthenticationViaCompanyPortal");
            return this;
        }

        /**
         * <i>“Indicates that Company Portal is required on setup assistant enrolled devices”</i>
         * 
         * @param requireCompanyPortalOnSetupAssistantEnrolledDevices
         *            value of {@code requireCompanyPortalOnSetupAssistantEnrolledDevices} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder requireCompanyPortalOnSetupAssistantEnrolledDevices(Boolean requireCompanyPortalOnSetupAssistantEnrolledDevices) {
            this.requireCompanyPortalOnSetupAssistantEnrolledDevices = requireCompanyPortalOnSetupAssistantEnrolledDevices;
            this.changedFields = changedFields.add("requireCompanyPortalOnSetupAssistantEnrolledDevices");
            return this;
        }

        /**
         * <i>“Indicates if the profile requires user authentication”</i>
         * 
         * @param requiresUserAuthentication
         *            value of {@code requiresUserAuthentication} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder requiresUserAuthentication(Boolean requiresUserAuthentication) {
            this.requiresUserAuthentication = requiresUserAuthentication;
            this.changedFields = changedFields.add("requiresUserAuthentication");
            return this;
        }

        public EnrollmentProfile build() {
            EnrollmentProfile _x = new EnrollmentProfile();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.enrollmentProfile";
            _x.id = id;
            _x.configurationEndpointUrl = configurationEndpointUrl;
            _x.description = description;
            _x.displayName = displayName;
            _x.enableAuthenticationViaCompanyPortal = enableAuthenticationViaCompanyPortal;
            _x.requireCompanyPortalOnSetupAssistantEnrolledDevices = requireCompanyPortalOnSetupAssistantEnrolledDevices;
            _x.requiresUserAuthentication = requiresUserAuthentication;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“Configuration endpoint url to use for Enrollment”</i>
     * 
     * @return property configurationEndpointUrl
     */
    @Property(name="configurationEndpointUrl")
    @JsonIgnore
    public Optional<String> getConfigurationEndpointUrl() {
        return Optional.ofNullable(configurationEndpointUrl);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * configurationEndpointUrl} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Configuration endpoint url to use for Enrollment”</i>
     * 
     * @param configurationEndpointUrl
     *            new value of {@code configurationEndpointUrl} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code configurationEndpointUrl} field changed
     */
    public EnrollmentProfile withConfigurationEndpointUrl(String configurationEndpointUrl) {
        EnrollmentProfile _x = _copy();
        _x.changedFields = changedFields.add("configurationEndpointUrl");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.enrollmentProfile");
        _x.configurationEndpointUrl = configurationEndpointUrl;
        return _x;
    }

    /**
     * <i>“Description of the profile”</i>
     * 
     * @return property description
     */
    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code description}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Description of the profile”</i>
     * 
     * @param description
     *            new value of {@code description} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code description} field changed
     */
    public EnrollmentProfile withDescription(String description) {
        EnrollmentProfile _x = _copy();
        _x.changedFields = changedFields.add("description");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.enrollmentProfile");
        _x.description = description;
        return _x;
    }

    /**
     * <i>“Name of the profile”</i>
     * 
     * @return property displayName
     */
    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code displayName}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Name of the profile”</i>
     * 
     * @param displayName
     *            new value of {@code displayName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code displayName} field changed
     */
    public EnrollmentProfile withDisplayName(String displayName) {
        EnrollmentProfile _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.enrollmentProfile");
        _x.displayName = displayName;
        return _x;
    }

    /**
     * <i>“Indicates to authenticate with Apple Setup Assistant instead of Company Portal.”</i>
     * 
     * @return property enableAuthenticationViaCompanyPortal
     */
    @Property(name="enableAuthenticationViaCompanyPortal")
    @JsonIgnore
    public Optional<Boolean> getEnableAuthenticationViaCompanyPortal() {
        return Optional.ofNullable(enableAuthenticationViaCompanyPortal);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * enableAuthenticationViaCompanyPortal} field changed. Field description below.
     * The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Indicates to authenticate with Apple Setup Assistant instead of Company Portal.”</i>
     * 
     * @param enableAuthenticationViaCompanyPortal
     *            new value of {@code enableAuthenticationViaCompanyPortal} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code enableAuthenticationViaCompanyPortal} field changed
     */
    public EnrollmentProfile withEnableAuthenticationViaCompanyPortal(Boolean enableAuthenticationViaCompanyPortal) {
        EnrollmentProfile _x = _copy();
        _x.changedFields = changedFields.add("enableAuthenticationViaCompanyPortal");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.enrollmentProfile");
        _x.enableAuthenticationViaCompanyPortal = enableAuthenticationViaCompanyPortal;
        return _x;
    }

    /**
     * <i>“Indicates that Company Portal is required on setup assistant enrolled devices”</i>
     * 
     * @return property requireCompanyPortalOnSetupAssistantEnrolledDevices
     */
    @Property(name="requireCompanyPortalOnSetupAssistantEnrolledDevices")
    @JsonIgnore
    public Optional<Boolean> getRequireCompanyPortalOnSetupAssistantEnrolledDevices() {
        return Optional.ofNullable(requireCompanyPortalOnSetupAssistantEnrolledDevices);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * requireCompanyPortalOnSetupAssistantEnrolledDevices} field changed. Field
     * description below. The field name is also added to an internal map of changed
     * fields in the returned object so that when {@code this.patch()} is called (if
     * available)on the returned object only the changed fields are submitted.
     * <p>
     * <i>“Indicates that Company Portal is required on setup assistant enrolled devices”</i>
     * 
     * @param requireCompanyPortalOnSetupAssistantEnrolledDevices
     *            new value of {@code requireCompanyPortalOnSetupAssistantEnrolledDevices} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code requireCompanyPortalOnSetupAssistantEnrolledDevices} field changed
     */
    public EnrollmentProfile withRequireCompanyPortalOnSetupAssistantEnrolledDevices(Boolean requireCompanyPortalOnSetupAssistantEnrolledDevices) {
        EnrollmentProfile _x = _copy();
        _x.changedFields = changedFields.add("requireCompanyPortalOnSetupAssistantEnrolledDevices");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.enrollmentProfile");
        _x.requireCompanyPortalOnSetupAssistantEnrolledDevices = requireCompanyPortalOnSetupAssistantEnrolledDevices;
        return _x;
    }

    /**
     * <i>“Indicates if the profile requires user authentication”</i>
     * 
     * @return property requiresUserAuthentication
     */
    @Property(name="requiresUserAuthentication")
    @JsonIgnore
    public Optional<Boolean> getRequiresUserAuthentication() {
        return Optional.ofNullable(requiresUserAuthentication);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * requiresUserAuthentication} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates if the profile requires user authentication”</i>
     * 
     * @param requiresUserAuthentication
     *            new value of {@code requiresUserAuthentication} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code requiresUserAuthentication} field changed
     */
    public EnrollmentProfile withRequiresUserAuthentication(Boolean requiresUserAuthentication) {
        EnrollmentProfile _x = _copy();
        _x.changedFields = changedFields.add("requiresUserAuthentication");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.enrollmentProfile");
        _x.requiresUserAuthentication = requiresUserAuthentication;
        return _x;
    }

    public EnrollmentProfile withUnmappedField(String name, Object value) {
        EnrollmentProfile _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public EnrollmentProfile patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        EnrollmentProfile _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public EnrollmentProfile put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        EnrollmentProfile _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private EnrollmentProfile _copy() {
        EnrollmentProfile _x = new EnrollmentProfile();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.configurationEndpointUrl = configurationEndpointUrl;
        _x.description = description;
        _x.displayName = displayName;
        _x.enableAuthenticationViaCompanyPortal = enableAuthenticationViaCompanyPortal;
        _x.requireCompanyPortalOnSetupAssistantEnrolledDevices = requireCompanyPortalOnSetupAssistantEnrolledDevices;
        _x.requiresUserAuthentication = requiresUserAuthentication;
        return _x;
    }

    @Action(name = "setDefaultProfile")
    @JsonIgnore
    public ActionRequestNoReturn setDefaultProfile() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.setDefaultProfile"), _parameters);
    }

    @Action(name = "updateDeviceProfileAssignment")
    @JsonIgnore
    public ActionRequestNoReturn updateDeviceProfileAssignment(List<String> deviceIds) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("deviceIds", "Collection(Edm.String)", Checks.checkIsAscii(deviceIds))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.updateDeviceProfileAssignment"), _parameters);
    }

    @Function(name = "exportMobileConfig")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<String> exportMobileConfig() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollection<String>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.exportMobileConfig"), String.class, _parameters);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("EnrollmentProfile[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("configurationEndpointUrl=");
        b.append(this.configurationEndpointUrl);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("enableAuthenticationViaCompanyPortal=");
        b.append(this.enableAuthenticationViaCompanyPortal);
        b.append(", ");
        b.append("requireCompanyPortalOnSetupAssistantEnrolledDevices=");
        b.append(this.requireCompanyPortalOnSetupAssistantEnrolledDevices);
        b.append(", ");
        b.append("requiresUserAuthentication=");
        b.append(this.requiresUserAuthentication);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
