package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import odata.msgraph.client.beta.complex.DeviceAndAppManagementAssignmentTarget;
import odata.msgraph.client.beta.enums.DeviceAndAppManagementAssignmentSource;


/**
 * <i>“Enrollment Configuration Assignment”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "source", 
    "sourceId", 
    "target"})
@JsonInclude(Include.NON_NULL)
public class EnrollmentConfigurationAssignment extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.enrollmentConfigurationAssignment";
    }

    @JsonProperty("source")
    protected DeviceAndAppManagementAssignmentSource source;

    @JsonProperty("sourceId")
    protected String sourceId;

    @JsonProperty("target")
    protected DeviceAndAppManagementAssignmentTarget target;

    protected EnrollmentConfigurationAssignment() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderEnrollmentConfigurationAssignment() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private DeviceAndAppManagementAssignmentSource source;
        private String sourceId;
        private DeviceAndAppManagementAssignmentTarget target;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“Type of resource used for deployment to a group, direct or policySet”</i>
         * 
         * @param source
         *            value of {@code source} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder source(DeviceAndAppManagementAssignmentSource source) {
            this.source = source;
            this.changedFields = changedFields.add("source");
            return this;
        }

        /**
         * <i>“Identifier for resource used for deployment to a group”</i>
         * 
         * @param sourceId
         *            value of {@code sourceId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder sourceId(String sourceId) {
            this.sourceId = sourceId;
            this.changedFields = changedFields.add("sourceId");
            return this;
        }

        /**
         * <i>“Represents an assignment to managed devices in the tenant”</i>
         * 
         * @param target
         *            value of {@code target} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder target(DeviceAndAppManagementAssignmentTarget target) {
            this.target = target;
            this.changedFields = changedFields.add("target");
            return this;
        }

        public EnrollmentConfigurationAssignment build() {
            EnrollmentConfigurationAssignment _x = new EnrollmentConfigurationAssignment();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.enrollmentConfigurationAssignment";
            _x.id = id;
            _x.source = source;
            _x.sourceId = sourceId;
            _x.target = target;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“Type of resource used for deployment to a group, direct or policySet”</i>
     * 
     * @return property source
     */
    @Property(name="source")
    @JsonIgnore
    public Optional<DeviceAndAppManagementAssignmentSource> getSource() {
        return Optional.ofNullable(source);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code source} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Type of resource used for deployment to a group, direct or policySet”</i>
     * 
     * @param source
     *            new value of {@code source} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code source} field changed
     */
    public EnrollmentConfigurationAssignment withSource(DeviceAndAppManagementAssignmentSource source) {
        EnrollmentConfigurationAssignment _x = _copy();
        _x.changedFields = changedFields.add("source");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.enrollmentConfigurationAssignment");
        _x.source = source;
        return _x;
    }

    /**
     * <i>“Identifier for resource used for deployment to a group”</i>
     * 
     * @return property sourceId
     */
    @Property(name="sourceId")
    @JsonIgnore
    public Optional<String> getSourceId() {
        return Optional.ofNullable(sourceId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code sourceId} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Identifier for resource used for deployment to a group”</i>
     * 
     * @param sourceId
     *            new value of {@code sourceId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code sourceId} field changed
     */
    public EnrollmentConfigurationAssignment withSourceId(String sourceId) {
        EnrollmentConfigurationAssignment _x = _copy();
        _x.changedFields = changedFields.add("sourceId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.enrollmentConfigurationAssignment");
        _x.sourceId = sourceId;
        return _x;
    }

    /**
     * <i>“Represents an assignment to managed devices in the tenant”</i>
     * 
     * @return property target
     */
    @Property(name="target")
    @JsonIgnore
    public Optional<DeviceAndAppManagementAssignmentTarget> getTarget() {
        return Optional.ofNullable(target);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code target} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Represents an assignment to managed devices in the tenant”</i>
     * 
     * @param target
     *            new value of {@code target} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code target} field changed
     */
    public EnrollmentConfigurationAssignment withTarget(DeviceAndAppManagementAssignmentTarget target) {
        EnrollmentConfigurationAssignment _x = _copy();
        _x.changedFields = changedFields.add("target");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.enrollmentConfigurationAssignment");
        _x.target = target;
        return _x;
    }

    public EnrollmentConfigurationAssignment withUnmappedField(String name, Object value) {
        EnrollmentConfigurationAssignment _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public EnrollmentConfigurationAssignment patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        EnrollmentConfigurationAssignment _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public EnrollmentConfigurationAssignment put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        EnrollmentConfigurationAssignment _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private EnrollmentConfigurationAssignment _copy() {
        EnrollmentConfigurationAssignment _x = new EnrollmentConfigurationAssignment();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.source = source;
        _x.sourceId = sourceId;
        _x.target = target;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("EnrollmentConfigurationAssignment[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("source=");
        b.append(this.source);
        b.append(", ");
        b.append("sourceId=");
        b.append(this.sourceId);
        b.append(", ");
        b.append("target=");
        b.append(this.target);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
