package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.enums.EmbeddedSIMDeviceStateValue;


/**
 * <i>“Describes the embedded SIM activation code deployment state in relation to a
 * device.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "createdDateTime", 
    "deviceName", 
    "lastSyncDateTime", 
    "modifiedDateTime", 
    "state", 
    "stateDetails", 
    "universalIntegratedCircuitCardIdentifier", 
    "userName"})
@JsonInclude(Include.NON_NULL)
public class EmbeddedSIMDeviceState extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.embeddedSIMDeviceState";
    }

    @JsonProperty("createdDateTime")
    protected OffsetDateTime createdDateTime;

    @JsonProperty("deviceName")
    protected String deviceName;

    @JsonProperty("lastSyncDateTime")
    protected OffsetDateTime lastSyncDateTime;

    @JsonProperty("modifiedDateTime")
    protected OffsetDateTime modifiedDateTime;

    @JsonProperty("state")
    protected EmbeddedSIMDeviceStateValue state;

    @JsonProperty("stateDetails")
    protected String stateDetails;

    @JsonProperty("universalIntegratedCircuitCardIdentifier")
    protected String universalIntegratedCircuitCardIdentifier;

    @JsonProperty("userName")
    protected String userName;

    protected EmbeddedSIMDeviceState() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderEmbeddedSIMDeviceState() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private OffsetDateTime createdDateTime;
        private String deviceName;
        private OffsetDateTime lastSyncDateTime;
        private OffsetDateTime modifiedDateTime;
        private EmbeddedSIMDeviceStateValue state;
        private String stateDetails;
        private String universalIntegratedCircuitCardIdentifier;
        private String userName;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“The time the embedded SIM device status was created. Generated service side.”</i>
         * 
         * @param createdDateTime
         *            value of {@code createdDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        /**
         * <i>“Device name to which the subscription was provisioned e.g. DESKTOP-JOE”</i>
         * 
         * @param deviceName
         *            value of {@code deviceName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceName(String deviceName) {
            this.deviceName = deviceName;
            this.changedFields = changedFields.add("deviceName");
            return this;
        }

        /**
         * <i>“The time the embedded SIM device last checked in. Updated service side.”</i>
         * 
         * @param lastSyncDateTime
         *            value of {@code lastSyncDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder lastSyncDateTime(OffsetDateTime lastSyncDateTime) {
            this.lastSyncDateTime = lastSyncDateTime;
            this.changedFields = changedFields.add("lastSyncDateTime");
            return this;
        }

        /**
         * <i>“The time the embedded SIM device status was last modified. Updated service side.”</i>
         * 
         * @param modifiedDateTime
         *            value of {@code modifiedDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder modifiedDateTime(OffsetDateTime modifiedDateTime) {
            this.modifiedDateTime = modifiedDateTime;
            this.changedFields = changedFields.add("modifiedDateTime");
            return this;
        }

        /**
         * <i>“The state of the profile operation applied to the device.”</i>
         * 
         * @param state
         *            value of {@code state} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder state(EmbeddedSIMDeviceStateValue state) {
            this.state = state;
            this.changedFields = changedFields.add("state");
            return this;
        }

        /**
         * <i>“String description of the provisioning state.”</i>
         * 
         * @param stateDetails
         *            value of {@code stateDetails} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder stateDetails(String stateDetails) {
            this.stateDetails = stateDetails;
            this.changedFields = changedFields.add("stateDetails");
            return this;
        }

        /**
         * <i>“The Universal Integrated Circuit Card Identifier (UICCID) identifying the
         * hardware onto which a profile is to be deployed.”</i>
         * 
         * @param universalIntegratedCircuitCardIdentifier
         *            value of {@code universalIntegratedCircuitCardIdentifier} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder universalIntegratedCircuitCardIdentifier(String universalIntegratedCircuitCardIdentifier) {
            this.universalIntegratedCircuitCardIdentifier = universalIntegratedCircuitCardIdentifier;
            this.changedFields = changedFields.add("universalIntegratedCircuitCardIdentifier");
            return this;
        }

        /**
         * <i>“Username which the subscription was provisioned to e.g. joe&amp;#064;contoso.com”</i>
         * 
         * @param userName
         *            value of {@code userName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userName(String userName) {
            this.userName = userName;
            this.changedFields = changedFields.add("userName");
            return this;
        }

        public EmbeddedSIMDeviceState build() {
            EmbeddedSIMDeviceState _x = new EmbeddedSIMDeviceState();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.embeddedSIMDeviceState";
            _x.id = id;
            _x.createdDateTime = createdDateTime;
            _x.deviceName = deviceName;
            _x.lastSyncDateTime = lastSyncDateTime;
            _x.modifiedDateTime = modifiedDateTime;
            _x.state = state;
            _x.stateDetails = stateDetails;
            _x.universalIntegratedCircuitCardIdentifier = universalIntegratedCircuitCardIdentifier;
            _x.userName = userName;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“The time the embedded SIM device status was created. Generated service side.”</i>
     * 
     * @return property createdDateTime
     */
    @Property(name="createdDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedDateTime() {
        return Optional.ofNullable(createdDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code createdDateTime}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The time the embedded SIM device status was created. Generated service side.”</i>
     * 
     * @param createdDateTime
     *            new value of {@code createdDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code createdDateTime} field changed
     */
    public EmbeddedSIMDeviceState withCreatedDateTime(OffsetDateTime createdDateTime) {
        EmbeddedSIMDeviceState _x = _copy();
        _x.changedFields = changedFields.add("createdDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.embeddedSIMDeviceState");
        _x.createdDateTime = createdDateTime;
        return _x;
    }

    /**
     * <i>“Device name to which the subscription was provisioned e.g. DESKTOP-JOE”</i>
     * 
     * @return property deviceName
     */
    @Property(name="deviceName")
    @JsonIgnore
    public Optional<String> getDeviceName() {
        return Optional.ofNullable(deviceName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code deviceName} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Device name to which the subscription was provisioned e.g. DESKTOP-JOE”</i>
     * 
     * @param deviceName
     *            new value of {@code deviceName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceName} field changed
     */
    public EmbeddedSIMDeviceState withDeviceName(String deviceName) {
        EmbeddedSIMDeviceState _x = _copy();
        _x.changedFields = changedFields.add("deviceName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.embeddedSIMDeviceState");
        _x.deviceName = deviceName;
        return _x;
    }

    /**
     * <i>“The time the embedded SIM device last checked in. Updated service side.”</i>
     * 
     * @return property lastSyncDateTime
     */
    @Property(name="lastSyncDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastSyncDateTime() {
        return Optional.ofNullable(lastSyncDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code lastSyncDateTime}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The time the embedded SIM device last checked in. Updated service side.”</i>
     * 
     * @param lastSyncDateTime
     *            new value of {@code lastSyncDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code lastSyncDateTime} field changed
     */
    public EmbeddedSIMDeviceState withLastSyncDateTime(OffsetDateTime lastSyncDateTime) {
        EmbeddedSIMDeviceState _x = _copy();
        _x.changedFields = changedFields.add("lastSyncDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.embeddedSIMDeviceState");
        _x.lastSyncDateTime = lastSyncDateTime;
        return _x;
    }

    /**
     * <i>“The time the embedded SIM device status was last modified. Updated service side.”</i>
     * 
     * @return property modifiedDateTime
     */
    @Property(name="modifiedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getModifiedDateTime() {
        return Optional.ofNullable(modifiedDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code modifiedDateTime}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The time the embedded SIM device status was last modified. Updated service side.”</i>
     * 
     * @param modifiedDateTime
     *            new value of {@code modifiedDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code modifiedDateTime} field changed
     */
    public EmbeddedSIMDeviceState withModifiedDateTime(OffsetDateTime modifiedDateTime) {
        EmbeddedSIMDeviceState _x = _copy();
        _x.changedFields = changedFields.add("modifiedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.embeddedSIMDeviceState");
        _x.modifiedDateTime = modifiedDateTime;
        return _x;
    }

    /**
     * <i>“The state of the profile operation applied to the device.”</i>
     * 
     * @return property state
     */
    @Property(name="state")
    @JsonIgnore
    public Optional<EmbeddedSIMDeviceStateValue> getState() {
        return Optional.ofNullable(state);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code state} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The state of the profile operation applied to the device.”</i>
     * 
     * @param state
     *            new value of {@code state} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code state} field changed
     */
    public EmbeddedSIMDeviceState withState(EmbeddedSIMDeviceStateValue state) {
        EmbeddedSIMDeviceState _x = _copy();
        _x.changedFields = changedFields.add("state");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.embeddedSIMDeviceState");
        _x.state = state;
        return _x;
    }

    /**
     * <i>“String description of the provisioning state.”</i>
     * 
     * @return property stateDetails
     */
    @Property(name="stateDetails")
    @JsonIgnore
    public Optional<String> getStateDetails() {
        return Optional.ofNullable(stateDetails);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code stateDetails}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“String description of the provisioning state.”</i>
     * 
     * @param stateDetails
     *            new value of {@code stateDetails} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code stateDetails} field changed
     */
    public EmbeddedSIMDeviceState withStateDetails(String stateDetails) {
        EmbeddedSIMDeviceState _x = _copy();
        _x.changedFields = changedFields.add("stateDetails");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.embeddedSIMDeviceState");
        _x.stateDetails = stateDetails;
        return _x;
    }

    /**
     * <i>“The Universal Integrated Circuit Card Identifier (UICCID) identifying the
     * hardware onto which a profile is to be deployed.”</i>
     * 
     * @return property universalIntegratedCircuitCardIdentifier
     */
    @Property(name="universalIntegratedCircuitCardIdentifier")
    @JsonIgnore
    public Optional<String> getUniversalIntegratedCircuitCardIdentifier() {
        return Optional.ofNullable(universalIntegratedCircuitCardIdentifier);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * universalIntegratedCircuitCardIdentifier} field changed. Field description below
     * . The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“The Universal Integrated Circuit Card Identifier (UICCID) identifying the
     * hardware onto which a profile is to be deployed.”</i>
     * 
     * @param universalIntegratedCircuitCardIdentifier
     *            new value of {@code universalIntegratedCircuitCardIdentifier} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code universalIntegratedCircuitCardIdentifier} field changed
     */
    public EmbeddedSIMDeviceState withUniversalIntegratedCircuitCardIdentifier(String universalIntegratedCircuitCardIdentifier) {
        EmbeddedSIMDeviceState _x = _copy();
        _x.changedFields = changedFields.add("universalIntegratedCircuitCardIdentifier");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.embeddedSIMDeviceState");
        _x.universalIntegratedCircuitCardIdentifier = universalIntegratedCircuitCardIdentifier;
        return _x;
    }

    /**
     * <i>“Username which the subscription was provisioned to e.g. joe&amp;#064;contoso.com”</i>
     * 
     * @return property userName
     */
    @Property(name="userName")
    @JsonIgnore
    public Optional<String> getUserName() {
        return Optional.ofNullable(userName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code userName} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Username which the subscription was provisioned to e.g. joe&amp;#064;contoso.com”</i>
     * 
     * @param userName
     *            new value of {@code userName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code userName} field changed
     */
    public EmbeddedSIMDeviceState withUserName(String userName) {
        EmbeddedSIMDeviceState _x = _copy();
        _x.changedFields = changedFields.add("userName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.embeddedSIMDeviceState");
        _x.userName = userName;
        return _x;
    }

    public EmbeddedSIMDeviceState withUnmappedField(String name, Object value) {
        EmbeddedSIMDeviceState _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public EmbeddedSIMDeviceState patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        EmbeddedSIMDeviceState _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public EmbeddedSIMDeviceState put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        EmbeddedSIMDeviceState _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private EmbeddedSIMDeviceState _copy() {
        EmbeddedSIMDeviceState _x = new EmbeddedSIMDeviceState();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.createdDateTime = createdDateTime;
        _x.deviceName = deviceName;
        _x.lastSyncDateTime = lastSyncDateTime;
        _x.modifiedDateTime = modifiedDateTime;
        _x.state = state;
        _x.stateDetails = stateDetails;
        _x.universalIntegratedCircuitCardIdentifier = universalIntegratedCircuitCardIdentifier;
        _x.userName = userName;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("EmbeddedSIMDeviceState[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("deviceName=");
        b.append(this.deviceName);
        b.append(", ");
        b.append("lastSyncDateTime=");
        b.append(this.lastSyncDateTime);
        b.append(", ");
        b.append("modifiedDateTime=");
        b.append(this.modifiedDateTime);
        b.append(", ");
        b.append("state=");
        b.append(this.state);
        b.append(", ");
        b.append("stateDetails=");
        b.append(this.stateDetails);
        b.append(", ");
        b.append("universalIntegratedCircuitCardIdentifier=");
        b.append(this.universalIntegratedCircuitCardIdentifier);
        b.append(", ");
        b.append("userName=");
        b.append(this.userName);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
