package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.complex.EmbeddedSIMActivationCode;
import odata.msgraph.client.beta.entity.collection.request.EmbeddedSIMActivationCodePoolAssignmentCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.EmbeddedSIMDeviceStateCollectionRequest;


/**
 * <i>“A pool represents a group of embedded SIM activation codes.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "activationCodeCount", 
    "activationCodes", 
    "createdDateTime", 
    "displayName", 
    "modifiedDateTime", 
    "assignments", 
    "deviceStates"})
@JsonInclude(Include.NON_NULL)
public class EmbeddedSIMActivationCodePool extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.embeddedSIMActivationCodePool";
    }

    @JsonProperty("activationCodeCount")
    protected Integer activationCodeCount;

    @JsonProperty("activationCodes")
    protected List<EmbeddedSIMActivationCode> activationCodes;

    @JsonProperty("activationCodes@nextLink")
    protected String activationCodesNextLink;

    @JsonProperty("createdDateTime")
    protected OffsetDateTime createdDateTime;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("modifiedDateTime")
    protected OffsetDateTime modifiedDateTime;

    @JsonProperty("assignments")
    protected List<EmbeddedSIMActivationCodePoolAssignment> assignments;

    @JsonProperty("deviceStates")
    protected List<EmbeddedSIMDeviceState> deviceStates;

    protected EmbeddedSIMActivationCodePool() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderEmbeddedSIMActivationCodePool() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private Integer activationCodeCount;
        private List<EmbeddedSIMActivationCode> activationCodes;
        private String activationCodesNextLink;
        private OffsetDateTime createdDateTime;
        private String displayName;
        private OffsetDateTime modifiedDateTime;
        private List<EmbeddedSIMActivationCodePoolAssignment> assignments;
        private List<EmbeddedSIMDeviceState> deviceStates;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“The total count of activation codes which belong to this pool.”</i>
         * 
         * @param activationCodeCount
         *            value of {@code activationCodeCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder activationCodeCount(Integer activationCodeCount) {
            this.activationCodeCount = activationCodeCount;
            this.changedFields = changedFields.add("activationCodeCount");
            return this;
        }

        /**
         * <i>“The activation codes which belong to this pool. This navigation property is used
         * to post activation codes to Intune but cannot be used to read activation codes
         * from Intune.”</i>
         * 
         * @param activationCodes
         *            value of {@code activationCodes} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder activationCodes(List<EmbeddedSIMActivationCode> activationCodes) {
            this.activationCodes = activationCodes;
            this.changedFields = changedFields.add("activationCodes");
            return this;
        }

        /**
         * <i>“The activation codes which belong to this pool. This navigation property is used
         * to post activation codes to Intune but cannot be used to read activation codes
         * from Intune.”</i>
         * 
         * @param activationCodes
         *            value of {@code activationCodes} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder activationCodes(EmbeddedSIMActivationCode... activationCodes) {
            return activationCodes(Arrays.asList(activationCodes));
        }

        /**
         * <i>“The activation codes which belong to this pool. This navigation property is used
         * to post activation codes to Intune but cannot be used to read activation codes
         * from Intune.”</i>
         * 
         * @param activationCodesNextLink
         *            value of {@code activationCodes@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder activationCodesNextLink(String activationCodesNextLink) {
            this.activationCodesNextLink = activationCodesNextLink;
            this.changedFields = changedFields.add("activationCodes");
            return this;
        }

        /**
         * <i>“The time the embedded SIM activation code pool was created. Generated service
         * side.”</i>
         * 
         * @param createdDateTime
         *            value of {@code createdDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        /**
         * <i>“The admin defined name of the embedded SIM activation code pool.”</i>
         * 
         * @param displayName
         *            value of {@code displayName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        /**
         * <i>“The time the embedded SIM activation code pool was last modified. Updated
         * service side.”</i>
         * 
         * @param modifiedDateTime
         *            value of {@code modifiedDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder modifiedDateTime(OffsetDateTime modifiedDateTime) {
            this.modifiedDateTime = modifiedDateTime;
            this.changedFields = changedFields.add("modifiedDateTime");
            return this;
        }

        /**
         * <i>“Navigational property to a list of targets to which this pool is assigned.”</i>
         * 
         * @param assignments
         *            value of {@code assignments} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder assignments(List<EmbeddedSIMActivationCodePoolAssignment> assignments) {
            this.assignments = assignments;
            this.changedFields = changedFields.add("assignments");
            return this;
        }

        /**
         * <i>“Navigational property to a list of targets to which this pool is assigned.”</i>
         * 
         * @param assignments
         *            value of {@code assignments} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder assignments(EmbeddedSIMActivationCodePoolAssignment... assignments) {
            return assignments(Arrays.asList(assignments));
        }

        /**
         * <i>“Navigational property to a list of device states for this pool.”</i>
         * 
         * @param deviceStates
         *            value of {@code deviceStates} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceStates(List<EmbeddedSIMDeviceState> deviceStates) {
            this.deviceStates = deviceStates;
            this.changedFields = changedFields.add("deviceStates");
            return this;
        }

        /**
         * <i>“Navigational property to a list of device states for this pool.”</i>
         * 
         * @param deviceStates
         *            value of {@code deviceStates} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceStates(EmbeddedSIMDeviceState... deviceStates) {
            return deviceStates(Arrays.asList(deviceStates));
        }

        public EmbeddedSIMActivationCodePool build() {
            EmbeddedSIMActivationCodePool _x = new EmbeddedSIMActivationCodePool();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.embeddedSIMActivationCodePool";
            _x.id = id;
            _x.activationCodeCount = activationCodeCount;
            _x.activationCodes = activationCodes;
            _x.activationCodesNextLink = activationCodesNextLink;
            _x.createdDateTime = createdDateTime;
            _x.displayName = displayName;
            _x.modifiedDateTime = modifiedDateTime;
            _x.assignments = assignments;
            _x.deviceStates = deviceStates;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“The total count of activation codes which belong to this pool.”</i>
     * 
     * @return property activationCodeCount
     */
    @Property(name="activationCodeCount")
    @JsonIgnore
    public Optional<Integer> getActivationCodeCount() {
        return Optional.ofNullable(activationCodeCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * activationCodeCount} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The total count of activation codes which belong to this pool.”</i>
     * 
     * @param activationCodeCount
     *            new value of {@code activationCodeCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code activationCodeCount} field changed
     */
    public EmbeddedSIMActivationCodePool withActivationCodeCount(Integer activationCodeCount) {
        EmbeddedSIMActivationCodePool _x = _copy();
        _x.changedFields = changedFields.add("activationCodeCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.embeddedSIMActivationCodePool");
        _x.activationCodeCount = activationCodeCount;
        return _x;
    }

    /**
     * <i>“The activation codes which belong to this pool. This navigation property is used
     * to post activation codes to Intune but cannot be used to read activation codes
     * from Intune.”</i>
     * 
     * @return property activationCodes
     */
    @Property(name="activationCodes")
    @JsonIgnore
    public CollectionPage<EmbeddedSIMActivationCode> getActivationCodes() {
        return new CollectionPage<EmbeddedSIMActivationCode>(contextPath, EmbeddedSIMActivationCode.class, this.activationCodes, Optional.ofNullable(activationCodesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code activationCodes}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The activation codes which belong to this pool. This navigation property is used
     * to post activation codes to Intune but cannot be used to read activation codes
     * from Intune.”</i>
     * 
     * @param activationCodes
     *            new value of {@code activationCodes} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code activationCodes} field changed
     */
    public EmbeddedSIMActivationCodePool withActivationCodes(List<EmbeddedSIMActivationCode> activationCodes) {
        EmbeddedSIMActivationCodePool _x = _copy();
        _x.changedFields = changedFields.add("activationCodes");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.embeddedSIMActivationCodePool");
        _x.activationCodes = activationCodes;
        return _x;
    }

    /**
     * <i>“The activation codes which belong to this pool. This navigation property is used
     * to post activation codes to Intune but cannot be used to read activation codes
     * from Intune.”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property activationCodes
     */
    @Property(name="activationCodes")
    @JsonIgnore
    public CollectionPage<EmbeddedSIMActivationCode> getActivationCodes(HttpRequestOptions options) {
        return new CollectionPage<EmbeddedSIMActivationCode>(contextPath, EmbeddedSIMActivationCode.class, this.activationCodes, Optional.ofNullable(activationCodesNextLink), Collections.emptyList(), options);
    }

    /**
     * <i>“The time the embedded SIM activation code pool was created. Generated service
     * side.”</i>
     * 
     * @return property createdDateTime
     */
    @Property(name="createdDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedDateTime() {
        return Optional.ofNullable(createdDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code createdDateTime}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The time the embedded SIM activation code pool was created. Generated service
     * side.”</i>
     * 
     * @param createdDateTime
     *            new value of {@code createdDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code createdDateTime} field changed
     */
    public EmbeddedSIMActivationCodePool withCreatedDateTime(OffsetDateTime createdDateTime) {
        EmbeddedSIMActivationCodePool _x = _copy();
        _x.changedFields = changedFields.add("createdDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.embeddedSIMActivationCodePool");
        _x.createdDateTime = createdDateTime;
        return _x;
    }

    /**
     * <i>“The admin defined name of the embedded SIM activation code pool.”</i>
     * 
     * @return property displayName
     */
    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code displayName}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The admin defined name of the embedded SIM activation code pool.”</i>
     * 
     * @param displayName
     *            new value of {@code displayName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code displayName} field changed
     */
    public EmbeddedSIMActivationCodePool withDisplayName(String displayName) {
        EmbeddedSIMActivationCodePool _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.embeddedSIMActivationCodePool");
        _x.displayName = displayName;
        return _x;
    }

    /**
     * <i>“The time the embedded SIM activation code pool was last modified. Updated
     * service side.”</i>
     * 
     * @return property modifiedDateTime
     */
    @Property(name="modifiedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getModifiedDateTime() {
        return Optional.ofNullable(modifiedDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code modifiedDateTime}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The time the embedded SIM activation code pool was last modified. Updated
     * service side.”</i>
     * 
     * @param modifiedDateTime
     *            new value of {@code modifiedDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code modifiedDateTime} field changed
     */
    public EmbeddedSIMActivationCodePool withModifiedDateTime(OffsetDateTime modifiedDateTime) {
        EmbeddedSIMActivationCodePool _x = _copy();
        _x.changedFields = changedFields.add("modifiedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.embeddedSIMActivationCodePool");
        _x.modifiedDateTime = modifiedDateTime;
        return _x;
    }

    public EmbeddedSIMActivationCodePool withUnmappedField(String name, Object value) {
        EmbeddedSIMActivationCodePool _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    /**
     * <i>“Navigational property to a list of targets to which this pool is assigned.”</i>
     * 
     * @return navigational property assignments
     */
    @NavigationProperty(name="assignments")
    @JsonIgnore
    public EmbeddedSIMActivationCodePoolAssignmentCollectionRequest getAssignments() {
        return new EmbeddedSIMActivationCodePoolAssignmentCollectionRequest(
                        contextPath.addSegment("assignments"), Optional.ofNullable(assignments));
    }

    /**
     * <i>“Navigational property to a list of device states for this pool.”</i>
     * 
     * @return navigational property deviceStates
     */
    @NavigationProperty(name="deviceStates")
    @JsonIgnore
    public EmbeddedSIMDeviceStateCollectionRequest getDeviceStates() {
        return new EmbeddedSIMDeviceStateCollectionRequest(
                        contextPath.addSegment("deviceStates"), Optional.ofNullable(deviceStates));
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code assignments}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Navigational property to a list of targets to which this pool is assigned.”</i>
     * 
     * @param assignments
     *            new value of {@code assignments} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code assignments} field changed
     */
    public EmbeddedSIMActivationCodePool withAssignments(List<EmbeddedSIMActivationCodePoolAssignment> assignments) {
        EmbeddedSIMActivationCodePool _x = _copy();
        _x.changedFields = changedFields.add("assignments");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.embeddedSIMActivationCodePool");
        _x.assignments = assignments;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code deviceStates}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Navigational property to a list of device states for this pool.”</i>
     * 
     * @param deviceStates
     *            new value of {@code deviceStates} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceStates} field changed
     */
    public EmbeddedSIMActivationCodePool withDeviceStates(List<EmbeddedSIMDeviceState> deviceStates) {
        EmbeddedSIMActivationCodePool _x = _copy();
        _x.changedFields = changedFields.add("deviceStates");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.embeddedSIMActivationCodePool");
        _x.deviceStates = deviceStates;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public EmbeddedSIMActivationCodePool patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        EmbeddedSIMActivationCodePool _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public EmbeddedSIMActivationCodePool put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        EmbeddedSIMActivationCodePool _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private EmbeddedSIMActivationCodePool _copy() {
        EmbeddedSIMActivationCodePool _x = new EmbeddedSIMActivationCodePool();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.activationCodeCount = activationCodeCount;
        _x.activationCodes = activationCodes;
        _x.createdDateTime = createdDateTime;
        _x.displayName = displayName;
        _x.modifiedDateTime = modifiedDateTime;
        _x.assignments = assignments;
        _x.deviceStates = deviceStates;
        return _x;
    }

    @Action(name = "assign")
    @JsonIgnore
    public CollectionPageNonEntityRequest<EmbeddedSIMActivationCodePoolAssignment> assign(List<EmbeddedSIMActivationCodePoolAssignment> assignments) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("assignments", "Collection(microsoft.graph.embeddedSIMActivationCodePoolAssignment)", assignments)
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.assign"), EmbeddedSIMActivationCodePoolAssignment.class, _parameters);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("EmbeddedSIMActivationCodePool[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("activationCodeCount=");
        b.append(this.activationCodeCount);
        b.append(", ");
        b.append("activationCodes=");
        b.append(this.activationCodes);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("modifiedDateTime=");
        b.append(this.modifiedDateTime);
        b.append(", ");
        b.append("assignments=");
        b.append(this.assignments);
        b.append(", ");
        b.append("deviceStates=");
        b.append(this.deviceStates);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
