package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.entity.collection.request.AuthenticationMethodTargetCollectionRequest;
import odata.msgraph.client.beta.enums.AuthenticationMethodState;
import odata.msgraph.client.beta.enums.ExternalEmailOtpState;

@JsonPropertyOrder({
    "@odata.type", 
    "allowExternalIdToUseEmailOtp", 
    "includeTargets"})
@JsonInclude(Include.NON_NULL)
public class EmailAuthenticationMethodConfiguration extends AuthenticationMethodConfiguration implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.emailAuthenticationMethodConfiguration";
    }

    @JsonProperty("allowExternalIdToUseEmailOtp")
    protected ExternalEmailOtpState allowExternalIdToUseEmailOtp;

    @JsonProperty("includeTargets")
    protected List<AuthenticationMethodTarget> includeTargets;

    protected EmailAuthenticationMethodConfiguration() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderEmailAuthenticationMethodConfiguration() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private AuthenticationMethodState state;
        private ExternalEmailOtpState allowExternalIdToUseEmailOtp;
        private List<AuthenticationMethodTarget> includeTargets;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder state(AuthenticationMethodState state) {
            this.state = state;
            this.changedFields = changedFields.add("state");
            return this;
        }

        public Builder allowExternalIdToUseEmailOtp(ExternalEmailOtpState allowExternalIdToUseEmailOtp) {
            this.allowExternalIdToUseEmailOtp = allowExternalIdToUseEmailOtp;
            this.changedFields = changedFields.add("allowExternalIdToUseEmailOtp");
            return this;
        }

        public Builder includeTargets(List<AuthenticationMethodTarget> includeTargets) {
            this.includeTargets = includeTargets;
            this.changedFields = changedFields.add("includeTargets");
            return this;
        }

        public Builder includeTargets(AuthenticationMethodTarget... includeTargets) {
            return includeTargets(Arrays.asList(includeTargets));
        }

        public EmailAuthenticationMethodConfiguration build() {
            EmailAuthenticationMethodConfiguration _x = new EmailAuthenticationMethodConfiguration();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.emailAuthenticationMethodConfiguration";
            _x.id = id;
            _x.state = state;
            _x.allowExternalIdToUseEmailOtp = allowExternalIdToUseEmailOtp;
            _x.includeTargets = includeTargets;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="allowExternalIdToUseEmailOtp")
    @JsonIgnore
    public Optional<ExternalEmailOtpState> getAllowExternalIdToUseEmailOtp() {
        return Optional.ofNullable(allowExternalIdToUseEmailOtp);
    }

    public EmailAuthenticationMethodConfiguration withAllowExternalIdToUseEmailOtp(ExternalEmailOtpState allowExternalIdToUseEmailOtp) {
        EmailAuthenticationMethodConfiguration _x = _copy();
        _x.changedFields = changedFields.add("allowExternalIdToUseEmailOtp");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.emailAuthenticationMethodConfiguration");
        _x.allowExternalIdToUseEmailOtp = allowExternalIdToUseEmailOtp;
        return _x;
    }

    public EmailAuthenticationMethodConfiguration withUnmappedField(String name, Object value) {
        EmailAuthenticationMethodConfiguration _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="includeTargets")
    @JsonIgnore
    public AuthenticationMethodTargetCollectionRequest getIncludeTargets() {
        return new AuthenticationMethodTargetCollectionRequest(
                        contextPath.addSegment("includeTargets"), Optional.ofNullable(includeTargets));
    }

    public EmailAuthenticationMethodConfiguration withIncludeTargets(List<AuthenticationMethodTarget> includeTargets) {
        EmailAuthenticationMethodConfiguration _x = _copy();
        _x.changedFields = changedFields.add("includeTargets");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.emailAuthenticationMethodConfiguration");
        _x.includeTargets = includeTargets;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public EmailAuthenticationMethodConfiguration patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        EmailAuthenticationMethodConfiguration _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public EmailAuthenticationMethodConfiguration put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        EmailAuthenticationMethodConfiguration _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private EmailAuthenticationMethodConfiguration _copy() {
        EmailAuthenticationMethodConfiguration _x = new EmailAuthenticationMethodConfiguration();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.state = state;
        _x.allowExternalIdToUseEmailOtp = allowExternalIdToUseEmailOtp;
        _x.includeTargets = includeTargets;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("EmailAuthenticationMethodConfiguration[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("state=");
        b.append(this.state);
        b.append(", ");
        b.append("allowExternalIdToUseEmailOtp=");
        b.append(this.allowExternalIdToUseEmailOtp);
        b.append(", ");
        b.append("includeTargets=");
        b.append(this.includeTargets);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
