package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.complex.EducationalActivityDetail;
import odata.msgraph.client.beta.complex.IdentitySet;
import odata.msgraph.client.beta.complex.InferenceData;
import odata.msgraph.client.beta.complex.InstitutionData;
import odata.msgraph.client.beta.complex.PersonDataSources;
import odata.msgraph.client.beta.enums.AllowedAudiences;

@JsonPropertyOrder({
    "@odata.type", 
    "completionMonthYear", 
    "endMonthYear", 
    "institution", 
    "program", 
    "startMonthYear"})
@JsonInclude(Include.NON_NULL)
public class EducationalActivity extends ItemFacet implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.educationalActivity";
    }

    @JsonProperty("completionMonthYear")
    protected LocalDate completionMonthYear;

    @JsonProperty("endMonthYear")
    protected LocalDate endMonthYear;

    @JsonProperty("institution")
    protected InstitutionData institution;

    @JsonProperty("program")
    protected EducationalActivityDetail program;

    @JsonProperty("startMonthYear")
    protected LocalDate startMonthYear;

    protected EducationalActivity() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderEducationalActivity() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private AllowedAudiences allowedAudiences;
        private IdentitySet createdBy;
        private OffsetDateTime createdDateTime;
        private InferenceData inference;
        private Boolean isSearchable;
        private IdentitySet lastModifiedBy;
        private OffsetDateTime lastModifiedDateTime;
        private PersonDataSources source;
        private LocalDate completionMonthYear;
        private LocalDate endMonthYear;
        private InstitutionData institution;
        private EducationalActivityDetail program;
        private LocalDate startMonthYear;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder allowedAudiences(AllowedAudiences allowedAudiences) {
            this.allowedAudiences = allowedAudiences;
            this.changedFields = changedFields.add("allowedAudiences");
            return this;
        }

        public Builder createdBy(IdentitySet createdBy) {
            this.createdBy = createdBy;
            this.changedFields = changedFields.add("createdBy");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder inference(InferenceData inference) {
            this.inference = inference;
            this.changedFields = changedFields.add("inference");
            return this;
        }

        public Builder isSearchable(Boolean isSearchable) {
            this.isSearchable = isSearchable;
            this.changedFields = changedFields.add("isSearchable");
            return this;
        }

        public Builder lastModifiedBy(IdentitySet lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
            this.changedFields = changedFields.add("lastModifiedBy");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder source(PersonDataSources source) {
            this.source = source;
            this.changedFields = changedFields.add("source");
            return this;
        }

        public Builder completionMonthYear(LocalDate completionMonthYear) {
            this.completionMonthYear = completionMonthYear;
            this.changedFields = changedFields.add("completionMonthYear");
            return this;
        }

        public Builder endMonthYear(LocalDate endMonthYear) {
            this.endMonthYear = endMonthYear;
            this.changedFields = changedFields.add("endMonthYear");
            return this;
        }

        public Builder institution(InstitutionData institution) {
            this.institution = institution;
            this.changedFields = changedFields.add("institution");
            return this;
        }

        public Builder program(EducationalActivityDetail program) {
            this.program = program;
            this.changedFields = changedFields.add("program");
            return this;
        }

        public Builder startMonthYear(LocalDate startMonthYear) {
            this.startMonthYear = startMonthYear;
            this.changedFields = changedFields.add("startMonthYear");
            return this;
        }

        public EducationalActivity build() {
            EducationalActivity _x = new EducationalActivity();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.educationalActivity";
            _x.id = id;
            _x.allowedAudiences = allowedAudiences;
            _x.createdBy = createdBy;
            _x.createdDateTime = createdDateTime;
            _x.inference = inference;
            _x.isSearchable = isSearchable;
            _x.lastModifiedBy = lastModifiedBy;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.source = source;
            _x.completionMonthYear = completionMonthYear;
            _x.endMonthYear = endMonthYear;
            _x.institution = institution;
            _x.program = program;
            _x.startMonthYear = startMonthYear;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="completionMonthYear")
    @JsonIgnore
    public Optional<LocalDate> getCompletionMonthYear() {
        return Optional.ofNullable(completionMonthYear);
    }

    public EducationalActivity withCompletionMonthYear(LocalDate completionMonthYear) {
        EducationalActivity _x = _copy();
        _x.changedFields = changedFields.add("completionMonthYear");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationalActivity");
        _x.completionMonthYear = completionMonthYear;
        return _x;
    }

    @Property(name="endMonthYear")
    @JsonIgnore
    public Optional<LocalDate> getEndMonthYear() {
        return Optional.ofNullable(endMonthYear);
    }

    public EducationalActivity withEndMonthYear(LocalDate endMonthYear) {
        EducationalActivity _x = _copy();
        _x.changedFields = changedFields.add("endMonthYear");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationalActivity");
        _x.endMonthYear = endMonthYear;
        return _x;
    }

    @Property(name="institution")
    @JsonIgnore
    public Optional<InstitutionData> getInstitution() {
        return Optional.ofNullable(institution);
    }

    public EducationalActivity withInstitution(InstitutionData institution) {
        EducationalActivity _x = _copy();
        _x.changedFields = changedFields.add("institution");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationalActivity");
        _x.institution = institution;
        return _x;
    }

    @Property(name="program")
    @JsonIgnore
    public Optional<EducationalActivityDetail> getProgram() {
        return Optional.ofNullable(program);
    }

    public EducationalActivity withProgram(EducationalActivityDetail program) {
        EducationalActivity _x = _copy();
        _x.changedFields = changedFields.add("program");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationalActivity");
        _x.program = program;
        return _x;
    }

    @Property(name="startMonthYear")
    @JsonIgnore
    public Optional<LocalDate> getStartMonthYear() {
        return Optional.ofNullable(startMonthYear);
    }

    public EducationalActivity withStartMonthYear(LocalDate startMonthYear) {
        EducationalActivity _x = _copy();
        _x.changedFields = changedFields.add("startMonthYear");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationalActivity");
        _x.startMonthYear = startMonthYear;
        return _x;
    }

    public EducationalActivity withUnmappedField(String name, Object value) {
        EducationalActivity _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public EducationalActivity patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        EducationalActivity _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public EducationalActivity put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        EducationalActivity _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private EducationalActivity _copy() {
        EducationalActivity _x = new EducationalActivity();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.allowedAudiences = allowedAudiences;
        _x.createdBy = createdBy;
        _x.createdDateTime = createdDateTime;
        _x.inference = inference;
        _x.isSearchable = isSearchable;
        _x.lastModifiedBy = lastModifiedBy;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.source = source;
        _x.completionMonthYear = completionMonthYear;
        _x.endMonthYear = endMonthYear;
        _x.institution = institution;
        _x.program = program;
        _x.startMonthYear = startMonthYear;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("EducationalActivity[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("allowedAudiences=");
        b.append(this.allowedAudiences);
        b.append(", ");
        b.append("createdBy=");
        b.append(this.createdBy);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("inference=");
        b.append(this.inference);
        b.append(", ");
        b.append("isSearchable=");
        b.append(this.isSearchable);
        b.append(", ");
        b.append("lastModifiedBy=");
        b.append(this.lastModifiedBy);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("source=");
        b.append(this.source);
        b.append(", ");
        b.append("completionMonthYear=");
        b.append(this.completionMonthYear);
        b.append(", ");
        b.append("endMonthYear=");
        b.append(this.endMonthYear);
        b.append(", ");
        b.append("institution=");
        b.append(this.institution);
        b.append(", ");
        b.append("program=");
        b.append(this.program);
        b.append(", ");
        b.append("startMonthYear=");
        b.append(this.startMonthYear);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
