package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import odata.msgraph.client.beta.complex.EducationResource;

@JsonPropertyOrder({
    "@odata.type", 
    "assignmentResourceUrl", 
    "resource"})
@JsonInclude(Include.NON_NULL)
public class EducationSubmissionResource extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.educationSubmissionResource";
    }

    @JsonProperty("assignmentResourceUrl")
    protected String assignmentResourceUrl;

    @JsonProperty("resource")
    protected EducationResource resource;

    protected EducationSubmissionResource() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderEducationSubmissionResource() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String assignmentResourceUrl;
        private EducationResource resource;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder assignmentResourceUrl(String assignmentResourceUrl) {
            this.assignmentResourceUrl = assignmentResourceUrl;
            this.changedFields = changedFields.add("assignmentResourceUrl");
            return this;
        }

        public Builder resource(EducationResource resource) {
            this.resource = resource;
            this.changedFields = changedFields.add("resource");
            return this;
        }

        public EducationSubmissionResource build() {
            EducationSubmissionResource _x = new EducationSubmissionResource();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.educationSubmissionResource";
            _x.id = id;
            _x.assignmentResourceUrl = assignmentResourceUrl;
            _x.resource = resource;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="assignmentResourceUrl")
    @JsonIgnore
    public Optional<String> getAssignmentResourceUrl() {
        return Optional.ofNullable(assignmentResourceUrl);
    }

    public EducationSubmissionResource withAssignmentResourceUrl(String assignmentResourceUrl) {
        EducationSubmissionResource _x = _copy();
        _x.changedFields = changedFields.add("assignmentResourceUrl");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationSubmissionResource");
        _x.assignmentResourceUrl = assignmentResourceUrl;
        return _x;
    }

    @Property(name="resource")
    @JsonIgnore
    public Optional<EducationResource> getResource() {
        return Optional.ofNullable(resource);
    }

    public EducationSubmissionResource withResource(EducationResource resource) {
        EducationSubmissionResource _x = _copy();
        _x.changedFields = changedFields.add("resource");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationSubmissionResource");
        _x.resource = resource;
        return _x;
    }

    public EducationSubmissionResource withUnmappedField(String name, Object value) {
        EducationSubmissionResource _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public EducationSubmissionResource patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        EducationSubmissionResource _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public EducationSubmissionResource put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        EducationSubmissionResource _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private EducationSubmissionResource _copy() {
        EducationSubmissionResource _x = new EducationSubmissionResource();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.assignmentResourceUrl = assignmentResourceUrl;
        _x.resource = resource;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("EducationSubmissionResource[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("assignmentResourceUrl=");
        b.append(this.assignmentResourceUrl);
        b.append(", ");
        b.append("resource=");
        b.append(this.resource);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
