package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.EducationAssignmentGradeType;
import odata.msgraph.client.beta.complex.EducationItemBody;
import odata.msgraph.client.beta.complex.IdentitySet;
import odata.msgraph.client.beta.complex.RubricLevel;
import odata.msgraph.client.beta.complex.RubricQuality;

@JsonPropertyOrder({
    "@odata.type", 
    "createdBy", 
    "createdDateTime", 
    "description", 
    "displayName", 
    "grading", 
    "lastModifiedBy", 
    "lastModifiedDateTime", 
    "levels", 
    "qualities"})
@JsonInclude(Include.NON_NULL)
public class EducationRubric extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.educationRubric";
    }

    @JsonProperty("createdBy")
    protected IdentitySet createdBy;

    @JsonProperty("createdDateTime")
    protected OffsetDateTime createdDateTime;

    @JsonProperty("description")
    protected EducationItemBody description;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("grading")
    protected EducationAssignmentGradeType grading;

    @JsonProperty("lastModifiedBy")
    protected IdentitySet lastModifiedBy;

    @JsonProperty("lastModifiedDateTime")
    protected OffsetDateTime lastModifiedDateTime;

    @JsonProperty("levels")
    protected List<RubricLevel> levels;

    @JsonProperty("levels@nextLink")
    protected String levelsNextLink;

    @JsonProperty("qualities")
    protected List<RubricQuality> qualities;

    @JsonProperty("qualities@nextLink")
    protected String qualitiesNextLink;

    protected EducationRubric() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderEducationRubric() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private IdentitySet createdBy;
        private OffsetDateTime createdDateTime;
        private EducationItemBody description;
        private String displayName;
        private EducationAssignmentGradeType grading;
        private IdentitySet lastModifiedBy;
        private OffsetDateTime lastModifiedDateTime;
        private List<RubricLevel> levels;
        private String levelsNextLink;
        private List<RubricQuality> qualities;
        private String qualitiesNextLink;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <p>
         * <b>Org.OData.Core.V1.Computed</b>
         * <p>
         * true
         * 
         * @param createdBy
         *            value of {@code createdBy} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder createdBy(IdentitySet createdBy) {
            this.createdBy = createdBy;
            this.changedFields = changedFields.add("createdBy");
            return this;
        }

        /**
         * <p>
         * <b>Org.OData.Core.V1.Computed</b>
         * <p>
         * true
         * 
         * @param createdDateTime
         *            value of {@code createdDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder description(EducationItemBody description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder grading(EducationAssignmentGradeType grading) {
            this.grading = grading;
            this.changedFields = changedFields.add("grading");
            return this;
        }

        /**
         * <p>
         * <b>Org.OData.Core.V1.Computed</b>
         * <p>
         * true
         * 
         * @param lastModifiedBy
         *            value of {@code lastModifiedBy} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder lastModifiedBy(IdentitySet lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
            this.changedFields = changedFields.add("lastModifiedBy");
            return this;
        }

        /**
         * <p>
         * <b>Org.OData.Core.V1.Computed</b>
         * <p>
         * true
         * 
         * @param lastModifiedDateTime
         *            value of {@code lastModifiedDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder levels(List<RubricLevel> levels) {
            this.levels = levels;
            this.changedFields = changedFields.add("levels");
            return this;
        }

        public Builder levels(RubricLevel... levels) {
            return levels(Arrays.asList(levels));
        }

        public Builder levelsNextLink(String levelsNextLink) {
            this.levelsNextLink = levelsNextLink;
            this.changedFields = changedFields.add("levels");
            return this;
        }

        public Builder qualities(List<RubricQuality> qualities) {
            this.qualities = qualities;
            this.changedFields = changedFields.add("qualities");
            return this;
        }

        public Builder qualities(RubricQuality... qualities) {
            return qualities(Arrays.asList(qualities));
        }

        public Builder qualitiesNextLink(String qualitiesNextLink) {
            this.qualitiesNextLink = qualitiesNextLink;
            this.changedFields = changedFields.add("qualities");
            return this;
        }

        public EducationRubric build() {
            EducationRubric _x = new EducationRubric();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.educationRubric";
            _x.id = id;
            _x.createdBy = createdBy;
            _x.createdDateTime = createdDateTime;
            _x.description = description;
            _x.displayName = displayName;
            _x.grading = grading;
            _x.lastModifiedBy = lastModifiedBy;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.levels = levels;
            _x.levelsNextLink = levelsNextLink;
            _x.qualities = qualities;
            _x.qualitiesNextLink = qualitiesNextLink;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * 
     * @return property createdBy
     */
    @Property(name="createdBy")
    @JsonIgnore
    public Optional<IdentitySet> getCreatedBy() {
        return Optional.ofNullable(createdBy);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code createdBy} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * 
     * @param createdBy
     *            new value of {@code createdBy} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code createdBy} field changed
     */
    public EducationRubric withCreatedBy(IdentitySet createdBy) {
        EducationRubric _x = _copy();
        _x.changedFields = changedFields.add("createdBy");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationRubric");
        _x.createdBy = createdBy;
        return _x;
    }

    /**
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * 
     * @return property createdDateTime
     */
    @Property(name="createdDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedDateTime() {
        return Optional.ofNullable(createdDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code createdDateTime}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * 
     * @param createdDateTime
     *            new value of {@code createdDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code createdDateTime} field changed
     */
    public EducationRubric withCreatedDateTime(OffsetDateTime createdDateTime) {
        EducationRubric _x = _copy();
        _x.changedFields = changedFields.add("createdDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationRubric");
        _x.createdDateTime = createdDateTime;
        return _x;
    }

    @Property(name="description")
    @JsonIgnore
    public Optional<EducationItemBody> getDescription() {
        return Optional.ofNullable(description);
    }

    public EducationRubric withDescription(EducationItemBody description) {
        EducationRubric _x = _copy();
        _x.changedFields = changedFields.add("description");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationRubric");
        _x.description = description;
        return _x;
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public EducationRubric withDisplayName(String displayName) {
        EducationRubric _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationRubric");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="grading")
    @JsonIgnore
    public Optional<EducationAssignmentGradeType> getGrading() {
        return Optional.ofNullable(grading);
    }

    public EducationRubric withGrading(EducationAssignmentGradeType grading) {
        EducationRubric _x = _copy();
        _x.changedFields = changedFields.add("grading");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationRubric");
        _x.grading = grading;
        return _x;
    }

    /**
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * 
     * @return property lastModifiedBy
     */
    @Property(name="lastModifiedBy")
    @JsonIgnore
    public Optional<IdentitySet> getLastModifiedBy() {
        return Optional.ofNullable(lastModifiedBy);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code lastModifiedBy}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * 
     * @param lastModifiedBy
     *            new value of {@code lastModifiedBy} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code lastModifiedBy} field changed
     */
    public EducationRubric withLastModifiedBy(IdentitySet lastModifiedBy) {
        EducationRubric _x = _copy();
        _x.changedFields = changedFields.add("lastModifiedBy");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationRubric");
        _x.lastModifiedBy = lastModifiedBy;
        return _x;
    }

    /**
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * 
     * @return property lastModifiedDateTime
     */
    @Property(name="lastModifiedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastModifiedDateTime() {
        return Optional.ofNullable(lastModifiedDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * lastModifiedDateTime} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * 
     * @param lastModifiedDateTime
     *            new value of {@code lastModifiedDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code lastModifiedDateTime} field changed
     */
    public EducationRubric withLastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
        EducationRubric _x = _copy();
        _x.changedFields = changedFields.add("lastModifiedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationRubric");
        _x.lastModifiedDateTime = lastModifiedDateTime;
        return _x;
    }

    @Property(name="levels")
    @JsonIgnore
    public CollectionPage<RubricLevel> getLevels() {
        return new CollectionPage<RubricLevel>(contextPath, RubricLevel.class, this.levels, Optional.ofNullable(levelsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public EducationRubric withLevels(List<RubricLevel> levels) {
        EducationRubric _x = _copy();
        _x.changedFields = changedFields.add("levels");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationRubric");
        _x.levels = levels;
        return _x;
    }

    @Property(name="levels")
    @JsonIgnore
    public CollectionPage<RubricLevel> getLevels(HttpRequestOptions options) {
        return new CollectionPage<RubricLevel>(contextPath, RubricLevel.class, this.levels, Optional.ofNullable(levelsNextLink), Collections.emptyList(), options);
    }

    @Property(name="qualities")
    @JsonIgnore
    public CollectionPage<RubricQuality> getQualities() {
        return new CollectionPage<RubricQuality>(contextPath, RubricQuality.class, this.qualities, Optional.ofNullable(qualitiesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public EducationRubric withQualities(List<RubricQuality> qualities) {
        EducationRubric _x = _copy();
        _x.changedFields = changedFields.add("qualities");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationRubric");
        _x.qualities = qualities;
        return _x;
    }

    @Property(name="qualities")
    @JsonIgnore
    public CollectionPage<RubricQuality> getQualities(HttpRequestOptions options) {
        return new CollectionPage<RubricQuality>(contextPath, RubricQuality.class, this.qualities, Optional.ofNullable(qualitiesNextLink), Collections.emptyList(), options);
    }

    public EducationRubric withUnmappedField(String name, Object value) {
        EducationRubric _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public EducationRubric patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        EducationRubric _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public EducationRubric put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        EducationRubric _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private EducationRubric _copy() {
        EducationRubric _x = new EducationRubric();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.createdBy = createdBy;
        _x.createdDateTime = createdDateTime;
        _x.description = description;
        _x.displayName = displayName;
        _x.grading = grading;
        _x.lastModifiedBy = lastModifiedBy;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.levels = levels;
        _x.qualities = qualities;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("EducationRubric[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("createdBy=");
        b.append(this.createdBy);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("grading=");
        b.append(this.grading);
        b.append(", ");
        b.append("lastModifiedBy=");
        b.append(this.lastModifiedBy);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("levels=");
        b.append(this.levels);
        b.append(", ");
        b.append("qualities=");
        b.append(this.qualities);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
