package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import odata.msgraph.client.beta.enums.EducationExternalSource;

@JsonPropertyOrder({
    "@odata.type", 
    "description", 
    "displayName", 
    "externalSource", 
    "externalSourceDetail"})
@JsonInclude(Include.NON_NULL)
public class EducationOrganization extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.educationOrganization";
    }

    @JsonProperty("description")
    protected String description;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("externalSource")
    protected EducationExternalSource externalSource;

    @JsonProperty("externalSourceDetail")
    protected String externalSourceDetail;

    protected EducationOrganization() {
        super();
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    public EducationOrganization withDescription(String description) {
        EducationOrganization _x = _copy();
        _x.changedFields = changedFields.add("description");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationOrganization");
        _x.description = description;
        return _x;
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public EducationOrganization withDisplayName(String displayName) {
        EducationOrganization _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationOrganization");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="externalSource")
    @JsonIgnore
    public Optional<EducationExternalSource> getExternalSource() {
        return Optional.ofNullable(externalSource);
    }

    public EducationOrganization withExternalSource(EducationExternalSource externalSource) {
        EducationOrganization _x = _copy();
        _x.changedFields = changedFields.add("externalSource");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationOrganization");
        _x.externalSource = externalSource;
        return _x;
    }

    @Property(name="externalSourceDetail")
    @JsonIgnore
    public Optional<String> getExternalSourceDetail() {
        return Optional.ofNullable(externalSourceDetail);
    }

    public EducationOrganization withExternalSourceDetail(String externalSourceDetail) {
        EducationOrganization _x = _copy();
        _x.changedFields = changedFields.add("externalSourceDetail");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationOrganization");
        _x.externalSourceDetail = externalSourceDetail;
        return _x;
    }

    public EducationOrganization withUnmappedField(String name, Object value) {
        EducationOrganization _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public EducationOrganization patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        EducationOrganization _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public EducationOrganization put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        EducationOrganization _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private EducationOrganization _copy() {
        EducationOrganization _x = new EducationOrganization();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.description = description;
        _x.displayName = displayName;
        _x.externalSource = externalSource;
        _x.externalSourceDetail = externalSourceDetail;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("EducationOrganization[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("externalSource=");
        b.append(this.externalSource);
        b.append(", ");
        b.append("externalSourceDetail=");
        b.append(this.externalSourceDetail);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
