package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.EducationCourse;
import odata.msgraph.client.beta.complex.EducationTerm;
import odata.msgraph.client.beta.complex.IdentitySet;
import odata.msgraph.client.beta.entity.collection.request.EducationAssignmentCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.EducationCategoryCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.EducationSchoolCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.EducationUserCollectionRequest;
import odata.msgraph.client.beta.entity.request.EducationAssignmentDefaultsRequest;
import odata.msgraph.client.beta.entity.request.EducationAssignmentSettingsRequest;
import odata.msgraph.client.beta.entity.request.GroupRequest;
import odata.msgraph.client.beta.enums.EducationExternalSource;

@JsonPropertyOrder({
    "@odata.type", 
    "classCode", 
    "course", 
    "createdBy", 
    "description", 
    "displayName", 
    "externalId", 
    "externalName", 
    "externalSource", 
    "externalSourceDetail", 
    "grade", 
    "mailNickname", 
    "term", 
    "assignmentCategories", 
    "assignmentDefaults", 
    "assignments", 
    "assignmentSettings"})
@JsonInclude(Include.NON_NULL)
public class EducationClass extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.educationClass";
    }

    @JsonProperty("classCode")
    protected String classCode;

    @JsonProperty("course")
    protected EducationCourse course;

    @JsonProperty("createdBy")
    protected IdentitySet createdBy;

    @JsonProperty("description")
    protected String description;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("externalId")
    protected String externalId;

    @JsonProperty("externalName")
    protected String externalName;

    @JsonProperty("externalSource")
    protected EducationExternalSource externalSource;

    @JsonProperty("externalSourceDetail")
    protected String externalSourceDetail;

    @JsonProperty("grade")
    protected String grade;

    @JsonProperty("mailNickname")
    protected String mailNickname;

    @JsonProperty("term")
    protected EducationTerm term;

    @JsonProperty("assignmentCategories")
    protected List<EducationCategory> assignmentCategories;

    @JsonProperty("assignmentDefaults")
    protected EducationAssignmentDefaults assignmentDefaults;

    @JsonProperty("assignments")
    protected List<EducationAssignment> assignments;

    @JsonProperty("assignmentSettings")
    protected EducationAssignmentSettings assignmentSettings;

    protected EducationClass() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderEducationClass() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String classCode;
        private EducationCourse course;
        private IdentitySet createdBy;
        private String description;
        private String displayName;
        private String externalId;
        private String externalName;
        private EducationExternalSource externalSource;
        private String externalSourceDetail;
        private String grade;
        private String mailNickname;
        private EducationTerm term;
        private List<EducationCategory> assignmentCategories;
        private EducationAssignmentDefaults assignmentDefaults;
        private List<EducationAssignment> assignments;
        private EducationAssignmentSettings assignmentSettings;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder classCode(String classCode) {
            this.classCode = classCode;
            this.changedFields = changedFields.add("classCode");
            return this;
        }

        public Builder course(EducationCourse course) {
            this.course = course;
            this.changedFields = changedFields.add("course");
            return this;
        }

        public Builder createdBy(IdentitySet createdBy) {
            this.createdBy = createdBy;
            this.changedFields = changedFields.add("createdBy");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder externalId(String externalId) {
            this.externalId = externalId;
            this.changedFields = changedFields.add("externalId");
            return this;
        }

        public Builder externalName(String externalName) {
            this.externalName = externalName;
            this.changedFields = changedFields.add("externalName");
            return this;
        }

        public Builder externalSource(EducationExternalSource externalSource) {
            this.externalSource = externalSource;
            this.changedFields = changedFields.add("externalSource");
            return this;
        }

        public Builder externalSourceDetail(String externalSourceDetail) {
            this.externalSourceDetail = externalSourceDetail;
            this.changedFields = changedFields.add("externalSourceDetail");
            return this;
        }

        public Builder grade(String grade) {
            this.grade = grade;
            this.changedFields = changedFields.add("grade");
            return this;
        }

        public Builder mailNickname(String mailNickname) {
            this.mailNickname = mailNickname;
            this.changedFields = changedFields.add("mailNickname");
            return this;
        }

        public Builder term(EducationTerm term) {
            this.term = term;
            this.changedFields = changedFields.add("term");
            return this;
        }

        /**
         * <p>
         * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
         * <p>
         * Supported = true
         * 
         * @param assignmentCategories
         *            value of {@code assignmentCategories} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder assignmentCategories(List<EducationCategory> assignmentCategories) {
            this.assignmentCategories = assignmentCategories;
            this.changedFields = changedFields.add("assignmentCategories");
            return this;
        }

        /**
         * <p>
         * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
         * <p>
         * Supported = true
         * 
         * @param assignmentCategories
         *            value of {@code assignmentCategories} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder assignmentCategories(EducationCategory... assignmentCategories) {
            return assignmentCategories(Arrays.asList(assignmentCategories));
        }

        public Builder assignmentDefaults(EducationAssignmentDefaults assignmentDefaults) {
            this.assignmentDefaults = assignmentDefaults;
            this.changedFields = changedFields.add("assignmentDefaults");
            return this;
        }

        /**
         * <p>
         * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
         * <p>
         * Supported = true
         * 
         * @param assignments
         *            value of {@code assignments} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder assignments(List<EducationAssignment> assignments) {
            this.assignments = assignments;
            this.changedFields = changedFields.add("assignments");
            return this;
        }

        /**
         * <p>
         * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
         * <p>
         * Supported = true
         * 
         * @param assignments
         *            value of {@code assignments} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder assignments(EducationAssignment... assignments) {
            return assignments(Arrays.asList(assignments));
        }

        public Builder assignmentSettings(EducationAssignmentSettings assignmentSettings) {
            this.assignmentSettings = assignmentSettings;
            this.changedFields = changedFields.add("assignmentSettings");
            return this;
        }

        public EducationClass build() {
            EducationClass _x = new EducationClass();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.educationClass";
            _x.id = id;
            _x.classCode = classCode;
            _x.course = course;
            _x.createdBy = createdBy;
            _x.description = description;
            _x.displayName = displayName;
            _x.externalId = externalId;
            _x.externalName = externalName;
            _x.externalSource = externalSource;
            _x.externalSourceDetail = externalSourceDetail;
            _x.grade = grade;
            _x.mailNickname = mailNickname;
            _x.term = term;
            _x.assignmentCategories = assignmentCategories;
            _x.assignmentDefaults = assignmentDefaults;
            _x.assignments = assignments;
            _x.assignmentSettings = assignmentSettings;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="classCode")
    @JsonIgnore
    public Optional<String> getClassCode() {
        return Optional.ofNullable(classCode);
    }

    public EducationClass withClassCode(String classCode) {
        EducationClass _x = _copy();
        _x.changedFields = changedFields.add("classCode");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationClass");
        _x.classCode = classCode;
        return _x;
    }

    @Property(name="course")
    @JsonIgnore
    public Optional<EducationCourse> getCourse() {
        return Optional.ofNullable(course);
    }

    public EducationClass withCourse(EducationCourse course) {
        EducationClass _x = _copy();
        _x.changedFields = changedFields.add("course");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationClass");
        _x.course = course;
        return _x;
    }

    @Property(name="createdBy")
    @JsonIgnore
    public Optional<IdentitySet> getCreatedBy() {
        return Optional.ofNullable(createdBy);
    }

    public EducationClass withCreatedBy(IdentitySet createdBy) {
        EducationClass _x = _copy();
        _x.changedFields = changedFields.add("createdBy");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationClass");
        _x.createdBy = createdBy;
        return _x;
    }

    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    public EducationClass withDescription(String description) {
        EducationClass _x = _copy();
        _x.changedFields = changedFields.add("description");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationClass");
        _x.description = description;
        return _x;
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public EducationClass withDisplayName(String displayName) {
        EducationClass _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationClass");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="externalId")
    @JsonIgnore
    public Optional<String> getExternalId() {
        return Optional.ofNullable(externalId);
    }

    public EducationClass withExternalId(String externalId) {
        EducationClass _x = _copy();
        _x.changedFields = changedFields.add("externalId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationClass");
        _x.externalId = externalId;
        return _x;
    }

    @Property(name="externalName")
    @JsonIgnore
    public Optional<String> getExternalName() {
        return Optional.ofNullable(externalName);
    }

    public EducationClass withExternalName(String externalName) {
        EducationClass _x = _copy();
        _x.changedFields = changedFields.add("externalName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationClass");
        _x.externalName = externalName;
        return _x;
    }

    @Property(name="externalSource")
    @JsonIgnore
    public Optional<EducationExternalSource> getExternalSource() {
        return Optional.ofNullable(externalSource);
    }

    public EducationClass withExternalSource(EducationExternalSource externalSource) {
        EducationClass _x = _copy();
        _x.changedFields = changedFields.add("externalSource");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationClass");
        _x.externalSource = externalSource;
        return _x;
    }

    @Property(name="externalSourceDetail")
    @JsonIgnore
    public Optional<String> getExternalSourceDetail() {
        return Optional.ofNullable(externalSourceDetail);
    }

    public EducationClass withExternalSourceDetail(String externalSourceDetail) {
        EducationClass _x = _copy();
        _x.changedFields = changedFields.add("externalSourceDetail");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationClass");
        _x.externalSourceDetail = externalSourceDetail;
        return _x;
    }

    @Property(name="grade")
    @JsonIgnore
    public Optional<String> getGrade() {
        return Optional.ofNullable(grade);
    }

    public EducationClass withGrade(String grade) {
        EducationClass _x = _copy();
        _x.changedFields = changedFields.add("grade");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationClass");
        _x.grade = grade;
        return _x;
    }

    @Property(name="mailNickname")
    @JsonIgnore
    public Optional<String> getMailNickname() {
        return Optional.ofNullable(mailNickname);
    }

    public EducationClass withMailNickname(String mailNickname) {
        EducationClass _x = _copy();
        _x.changedFields = changedFields.add("mailNickname");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationClass");
        _x.mailNickname = mailNickname;
        return _x;
    }

    @Property(name="term")
    @JsonIgnore
    public Optional<EducationTerm> getTerm() {
        return Optional.ofNullable(term);
    }

    public EducationClass withTerm(EducationTerm term) {
        EducationClass _x = _copy();
        _x.changedFields = changedFields.add("term");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationClass");
        _x.term = term;
        return _x;
    }

    public EducationClass withUnmappedField(String name, Object value) {
        EducationClass _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    /**
     * <p>
     * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
     * <p>
     * Supported = true
     * 
     * @return navigational property assignmentCategories
     */
    @NavigationProperty(name="assignmentCategories")
    @JsonIgnore
    public EducationCategoryCollectionRequest getAssignmentCategories() {
        return new EducationCategoryCollectionRequest(
                        contextPath.addSegment("assignmentCategories"), Optional.ofNullable(assignmentCategories));
    }

    @NavigationProperty(name="assignmentDefaults")
    @JsonIgnore
    public EducationAssignmentDefaultsRequest getAssignmentDefaults() {
        return new EducationAssignmentDefaultsRequest(contextPath.addSegment("assignmentDefaults"), Optional.ofNullable(assignmentDefaults));
    }

    /**
     * <p>
     * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
     * <p>
     * Supported = true
     * 
     * @return navigational property assignments
     */
    @NavigationProperty(name="assignments")
    @JsonIgnore
    public EducationAssignmentCollectionRequest getAssignments() {
        return new EducationAssignmentCollectionRequest(
                        contextPath.addSegment("assignments"), Optional.ofNullable(assignments));
    }

    @NavigationProperty(name="assignmentSettings")
    @JsonIgnore
    public EducationAssignmentSettingsRequest getAssignmentSettings() {
        return new EducationAssignmentSettingsRequest(contextPath.addSegment("assignmentSettings"), Optional.ofNullable(assignmentSettings));
    }

    @NavigationProperty(name="group")
    @JsonIgnore
    public GroupRequest getGroup() {
        return new GroupRequest(contextPath.addSegment("group"), RequestHelper.getValue(unmappedFields, "group"));
    }

    @NavigationProperty(name="members")
    @JsonIgnore
    public EducationUserCollectionRequest getMembers() {
        return new EducationUserCollectionRequest(
                        contextPath.addSegment("members"), RequestHelper.getValue(unmappedFields, "members"));
    }

    @NavigationProperty(name="schools")
    @JsonIgnore
    public EducationSchoolCollectionRequest getSchools() {
        return new EducationSchoolCollectionRequest(
                        contextPath.addSegment("schools"), RequestHelper.getValue(unmappedFields, "schools"));
    }

    @NavigationProperty(name="teachers")
    @JsonIgnore
    public EducationUserCollectionRequest getTeachers() {
        return new EducationUserCollectionRequest(
                        contextPath.addSegment("teachers"), RequestHelper.getValue(unmappedFields, "teachers"));
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * assignmentCategories} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
     * <p>
     * Supported = true
     * 
     * @param assignmentCategories
     *            new value of {@code assignmentCategories} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code assignmentCategories} field changed
     */
    public EducationClass withAssignmentCategories(List<EducationCategory> assignmentCategories) {
        EducationClass _x = _copy();
        _x.changedFields = changedFields.add("assignmentCategories");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationClass");
        _x.assignmentCategories = assignmentCategories;
        return _x;
    }

    public EducationClass withAssignmentDefaults(EducationAssignmentDefaults assignmentDefaults) {
        EducationClass _x = _copy();
        _x.changedFields = changedFields.add("assignmentDefaults");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationClass");
        _x.assignmentDefaults = assignmentDefaults;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code assignments}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
     * <p>
     * Supported = true
     * 
     * @param assignments
     *            new value of {@code assignments} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code assignments} field changed
     */
    public EducationClass withAssignments(List<EducationAssignment> assignments) {
        EducationClass _x = _copy();
        _x.changedFields = changedFields.add("assignments");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationClass");
        _x.assignments = assignments;
        return _x;
    }

    public EducationClass withAssignmentSettings(EducationAssignmentSettings assignmentSettings) {
        EducationClass _x = _copy();
        _x.changedFields = changedFields.add("assignmentSettings");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationClass");
        _x.assignmentSettings = assignmentSettings;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public EducationClass patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        EducationClass _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public EducationClass put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        EducationClass _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private EducationClass _copy() {
        EducationClass _x = new EducationClass();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.classCode = classCode;
        _x.course = course;
        _x.createdBy = createdBy;
        _x.description = description;
        _x.displayName = displayName;
        _x.externalId = externalId;
        _x.externalName = externalName;
        _x.externalSource = externalSource;
        _x.externalSourceDetail = externalSourceDetail;
        _x.grade = grade;
        _x.mailNickname = mailNickname;
        _x.term = term;
        _x.assignmentCategories = assignmentCategories;
        _x.assignmentDefaults = assignmentDefaults;
        _x.assignments = assignments;
        _x.assignmentSettings = assignmentSettings;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("EducationClass[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("classCode=");
        b.append(this.classCode);
        b.append(", ");
        b.append("course=");
        b.append(this.course);
        b.append(", ");
        b.append("createdBy=");
        b.append(this.createdBy);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("externalId=");
        b.append(this.externalId);
        b.append(", ");
        b.append("externalName=");
        b.append(this.externalName);
        b.append(", ");
        b.append("externalSource=");
        b.append(this.externalSource);
        b.append(", ");
        b.append("externalSourceDetail=");
        b.append(this.externalSourceDetail);
        b.append(", ");
        b.append("grade=");
        b.append(this.grade);
        b.append(", ");
        b.append("mailNickname=");
        b.append(this.mailNickname);
        b.append(", ");
        b.append("term=");
        b.append(this.term);
        b.append(", ");
        b.append("assignmentCategories=");
        b.append(this.assignmentCategories);
        b.append(", ");
        b.append("assignmentDefaults=");
        b.append(this.assignmentDefaults);
        b.append(", ");
        b.append("assignments=");
        b.append(this.assignments);
        b.append(", ");
        b.append("assignmentSettings=");
        b.append(this.assignmentSettings);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
