package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.complex.EducationAssignmentGradeType;
import odata.msgraph.client.beta.complex.EducationAssignmentRecipient;
import odata.msgraph.client.beta.complex.EducationItemBody;
import odata.msgraph.client.beta.complex.IdentitySet;
import odata.msgraph.client.beta.entity.collection.request.EducationAssignmentResourceCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.EducationCategoryCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.EducationSubmissionCollectionRequest;
import odata.msgraph.client.beta.entity.request.EducationRubricRequest;
import odata.msgraph.client.beta.enums.EducationAddToCalendarOptions;
import odata.msgraph.client.beta.enums.EducationAddedStudentAction;
import odata.msgraph.client.beta.enums.EducationAssignmentStatus;

@JsonPropertyOrder({
    "@odata.type", 
    "addedStudentAction", 
    "addToCalendarAction", 
    "allowLateSubmissions", 
    "allowStudentsToAddResourcesToSubmission", 
    "assignDateTime", 
    "assignedDateTime", 
    "assignTo", 
    "classId", 
    "closeDateTime", 
    "createdBy", 
    "createdDateTime", 
    "displayName", 
    "dueDateTime", 
    "grading", 
    "instructions", 
    "lastModifiedBy", 
    "lastModifiedDateTime", 
    "notificationChannelUrl", 
    "resourcesFolderUrl", 
    "status", 
    "webUrl", 
    "categories", 
    "resources", 
    "rubric", 
    "submissions"})
@JsonInclude(Include.NON_NULL)
public class EducationAssignment extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.educationAssignment";
    }

    @JsonProperty("addedStudentAction")
    protected EducationAddedStudentAction addedStudentAction;

    @JsonProperty("addToCalendarAction")
    protected EducationAddToCalendarOptions addToCalendarAction;

    @JsonProperty("allowLateSubmissions")
    protected Boolean allowLateSubmissions;

    @JsonProperty("allowStudentsToAddResourcesToSubmission")
    protected Boolean allowStudentsToAddResourcesToSubmission;

    @JsonProperty("assignDateTime")
    protected OffsetDateTime assignDateTime;

    @JsonProperty("assignedDateTime")
    protected OffsetDateTime assignedDateTime;

    @JsonProperty("assignTo")
    protected EducationAssignmentRecipient assignTo;

    @JsonProperty("classId")
    protected String classId;

    @JsonProperty("closeDateTime")
    protected OffsetDateTime closeDateTime;

    @JsonProperty("createdBy")
    protected IdentitySet createdBy;

    @JsonProperty("createdDateTime")
    protected OffsetDateTime createdDateTime;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("dueDateTime")
    protected OffsetDateTime dueDateTime;

    @JsonProperty("grading")
    protected EducationAssignmentGradeType grading;

    @JsonProperty("instructions")
    protected EducationItemBody instructions;

    @JsonProperty("lastModifiedBy")
    protected IdentitySet lastModifiedBy;

    @JsonProperty("lastModifiedDateTime")
    protected OffsetDateTime lastModifiedDateTime;

    @JsonProperty("notificationChannelUrl")
    protected String notificationChannelUrl;

    @JsonProperty("resourcesFolderUrl")
    protected String resourcesFolderUrl;

    @JsonProperty("status")
    protected EducationAssignmentStatus status;

    @JsonProperty("webUrl")
    protected String webUrl;

    @JsonProperty("categories")
    protected List<EducationCategory> categories;

    @JsonProperty("resources")
    protected List<EducationAssignmentResource> resources;

    @JsonProperty("rubric")
    protected EducationRubric rubric;

    @JsonProperty("submissions")
    protected List<EducationSubmission> submissions;

    protected EducationAssignment() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderEducationAssignment() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private EducationAddedStudentAction addedStudentAction;
        private EducationAddToCalendarOptions addToCalendarAction;
        private Boolean allowLateSubmissions;
        private Boolean allowStudentsToAddResourcesToSubmission;
        private OffsetDateTime assignDateTime;
        private OffsetDateTime assignedDateTime;
        private EducationAssignmentRecipient assignTo;
        private String classId;
        private OffsetDateTime closeDateTime;
        private IdentitySet createdBy;
        private OffsetDateTime createdDateTime;
        private String displayName;
        private OffsetDateTime dueDateTime;
        private EducationAssignmentGradeType grading;
        private EducationItemBody instructions;
        private IdentitySet lastModifiedBy;
        private OffsetDateTime lastModifiedDateTime;
        private String notificationChannelUrl;
        private String resourcesFolderUrl;
        private EducationAssignmentStatus status;
        private String webUrl;
        private List<EducationCategory> categories;
        private List<EducationAssignmentResource> resources;
        private EducationRubric rubric;
        private List<EducationSubmission> submissions;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder addedStudentAction(EducationAddedStudentAction addedStudentAction) {
            this.addedStudentAction = addedStudentAction;
            this.changedFields = changedFields.add("addedStudentAction");
            return this;
        }

        public Builder addToCalendarAction(EducationAddToCalendarOptions addToCalendarAction) {
            this.addToCalendarAction = addToCalendarAction;
            this.changedFields = changedFields.add("addToCalendarAction");
            return this;
        }

        public Builder allowLateSubmissions(Boolean allowLateSubmissions) {
            this.allowLateSubmissions = allowLateSubmissions;
            this.changedFields = changedFields.add("allowLateSubmissions");
            return this;
        }

        public Builder allowStudentsToAddResourcesToSubmission(Boolean allowStudentsToAddResourcesToSubmission) {
            this.allowStudentsToAddResourcesToSubmission = allowStudentsToAddResourcesToSubmission;
            this.changedFields = changedFields.add("allowStudentsToAddResourcesToSubmission");
            return this;
        }

        /**
         * <p>
         * <b>Org.OData.Core.V1.Computed</b>
         * <p>
         * true
         * 
         * @param assignDateTime
         *            value of {@code assignDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder assignDateTime(OffsetDateTime assignDateTime) {
            this.assignDateTime = assignDateTime;
            this.changedFields = changedFields.add("assignDateTime");
            return this;
        }

        /**
         * <p>
         * <b>Org.OData.Core.V1.Computed</b>
         * <p>
         * true
         * 
         * @param assignedDateTime
         *            value of {@code assignedDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder assignedDateTime(OffsetDateTime assignedDateTime) {
            this.assignedDateTime = assignedDateTime;
            this.changedFields = changedFields.add("assignedDateTime");
            return this;
        }

        public Builder assignTo(EducationAssignmentRecipient assignTo) {
            this.assignTo = assignTo;
            this.changedFields = changedFields.add("assignTo");
            return this;
        }

        public Builder classId(String classId) {
            this.classId = classId;
            this.changedFields = changedFields.add("classId");
            return this;
        }

        public Builder closeDateTime(OffsetDateTime closeDateTime) {
            this.closeDateTime = closeDateTime;
            this.changedFields = changedFields.add("closeDateTime");
            return this;
        }

        /**
         * <p>
         * <b>Org.OData.Core.V1.Computed</b>
         * <p>
         * true
         * 
         * @param createdBy
         *            value of {@code createdBy} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder createdBy(IdentitySet createdBy) {
            this.createdBy = createdBy;
            this.changedFields = changedFields.add("createdBy");
            return this;
        }

        /**
         * <p>
         * <b>Org.OData.Core.V1.Computed</b>
         * <p>
         * true
         * 
         * @param createdDateTime
         *            value of {@code createdDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder dueDateTime(OffsetDateTime dueDateTime) {
            this.dueDateTime = dueDateTime;
            this.changedFields = changedFields.add("dueDateTime");
            return this;
        }

        public Builder grading(EducationAssignmentGradeType grading) {
            this.grading = grading;
            this.changedFields = changedFields.add("grading");
            return this;
        }

        public Builder instructions(EducationItemBody instructions) {
            this.instructions = instructions;
            this.changedFields = changedFields.add("instructions");
            return this;
        }

        /**
         * <p>
         * <b>Org.OData.Core.V1.Computed</b>
         * <p>
         * true
         * 
         * @param lastModifiedBy
         *            value of {@code lastModifiedBy} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder lastModifiedBy(IdentitySet lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
            this.changedFields = changedFields.add("lastModifiedBy");
            return this;
        }

        /**
         * <p>
         * <b>Org.OData.Core.V1.Computed</b>
         * <p>
         * true
         * 
         * @param lastModifiedDateTime
         *            value of {@code lastModifiedDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder notificationChannelUrl(String notificationChannelUrl) {
            this.notificationChannelUrl = notificationChannelUrl;
            this.changedFields = changedFields.add("notificationChannelUrl");
            return this;
        }

        /**
         * <p>
         * <b>Org.OData.Core.V1.Computed</b>
         * <p>
         * true
         * 
         * @param resourcesFolderUrl
         *            value of {@code resourcesFolderUrl} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder resourcesFolderUrl(String resourcesFolderUrl) {
            this.resourcesFolderUrl = resourcesFolderUrl;
            this.changedFields = changedFields.add("resourcesFolderUrl");
            return this;
        }

        /**
         * <p>
         * <b>Org.OData.Core.V1.Computed</b>
         * <p>
         * true
         * 
         * @param status
         *            value of {@code status} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder status(EducationAssignmentStatus status) {
            this.status = status;
            this.changedFields = changedFields.add("status");
            return this;
        }

        /**
         * <p>
         * <b>Org.OData.Core.V1.Computed</b>
         * <p>
         * true
         * 
         * @param webUrl
         *            value of {@code webUrl} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder webUrl(String webUrl) {
            this.webUrl = webUrl;
            this.changedFields = changedFields.add("webUrl");
            return this;
        }

        public Builder categories(List<EducationCategory> categories) {
            this.categories = categories;
            this.changedFields = changedFields.add("categories");
            return this;
        }

        public Builder categories(EducationCategory... categories) {
            return categories(Arrays.asList(categories));
        }

        public Builder resources(List<EducationAssignmentResource> resources) {
            this.resources = resources;
            this.changedFields = changedFields.add("resources");
            return this;
        }

        public Builder resources(EducationAssignmentResource... resources) {
            return resources(Arrays.asList(resources));
        }

        public Builder rubric(EducationRubric rubric) {
            this.rubric = rubric;
            this.changedFields = changedFields.add("rubric");
            return this;
        }

        public Builder submissions(List<EducationSubmission> submissions) {
            this.submissions = submissions;
            this.changedFields = changedFields.add("submissions");
            return this;
        }

        public Builder submissions(EducationSubmission... submissions) {
            return submissions(Arrays.asList(submissions));
        }

        public EducationAssignment build() {
            EducationAssignment _x = new EducationAssignment();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.educationAssignment";
            _x.id = id;
            _x.addedStudentAction = addedStudentAction;
            _x.addToCalendarAction = addToCalendarAction;
            _x.allowLateSubmissions = allowLateSubmissions;
            _x.allowStudentsToAddResourcesToSubmission = allowStudentsToAddResourcesToSubmission;
            _x.assignDateTime = assignDateTime;
            _x.assignedDateTime = assignedDateTime;
            _x.assignTo = assignTo;
            _x.classId = classId;
            _x.closeDateTime = closeDateTime;
            _x.createdBy = createdBy;
            _x.createdDateTime = createdDateTime;
            _x.displayName = displayName;
            _x.dueDateTime = dueDateTime;
            _x.grading = grading;
            _x.instructions = instructions;
            _x.lastModifiedBy = lastModifiedBy;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.notificationChannelUrl = notificationChannelUrl;
            _x.resourcesFolderUrl = resourcesFolderUrl;
            _x.status = status;
            _x.webUrl = webUrl;
            _x.categories = categories;
            _x.resources = resources;
            _x.rubric = rubric;
            _x.submissions = submissions;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="addedStudentAction")
    @JsonIgnore
    public Optional<EducationAddedStudentAction> getAddedStudentAction() {
        return Optional.ofNullable(addedStudentAction);
    }

    public EducationAssignment withAddedStudentAction(EducationAddedStudentAction addedStudentAction) {
        EducationAssignment _x = _copy();
        _x.changedFields = changedFields.add("addedStudentAction");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationAssignment");
        _x.addedStudentAction = addedStudentAction;
        return _x;
    }

    @Property(name="addToCalendarAction")
    @JsonIgnore
    public Optional<EducationAddToCalendarOptions> getAddToCalendarAction() {
        return Optional.ofNullable(addToCalendarAction);
    }

    public EducationAssignment withAddToCalendarAction(EducationAddToCalendarOptions addToCalendarAction) {
        EducationAssignment _x = _copy();
        _x.changedFields = changedFields.add("addToCalendarAction");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationAssignment");
        _x.addToCalendarAction = addToCalendarAction;
        return _x;
    }

    @Property(name="allowLateSubmissions")
    @JsonIgnore
    public Optional<Boolean> getAllowLateSubmissions() {
        return Optional.ofNullable(allowLateSubmissions);
    }

    public EducationAssignment withAllowLateSubmissions(Boolean allowLateSubmissions) {
        EducationAssignment _x = _copy();
        _x.changedFields = changedFields.add("allowLateSubmissions");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationAssignment");
        _x.allowLateSubmissions = allowLateSubmissions;
        return _x;
    }

    @Property(name="allowStudentsToAddResourcesToSubmission")
    @JsonIgnore
    public Optional<Boolean> getAllowStudentsToAddResourcesToSubmission() {
        return Optional.ofNullable(allowStudentsToAddResourcesToSubmission);
    }

    public EducationAssignment withAllowStudentsToAddResourcesToSubmission(Boolean allowStudentsToAddResourcesToSubmission) {
        EducationAssignment _x = _copy();
        _x.changedFields = changedFields.add("allowStudentsToAddResourcesToSubmission");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationAssignment");
        _x.allowStudentsToAddResourcesToSubmission = allowStudentsToAddResourcesToSubmission;
        return _x;
    }

    /**
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * 
     * @return property assignDateTime
     */
    @Property(name="assignDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getAssignDateTime() {
        return Optional.ofNullable(assignDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code assignDateTime}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * 
     * @param assignDateTime
     *            new value of {@code assignDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code assignDateTime} field changed
     */
    public EducationAssignment withAssignDateTime(OffsetDateTime assignDateTime) {
        EducationAssignment _x = _copy();
        _x.changedFields = changedFields.add("assignDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationAssignment");
        _x.assignDateTime = assignDateTime;
        return _x;
    }

    /**
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * 
     * @return property assignedDateTime
     */
    @Property(name="assignedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getAssignedDateTime() {
        return Optional.ofNullable(assignedDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code assignedDateTime}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * 
     * @param assignedDateTime
     *            new value of {@code assignedDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code assignedDateTime} field changed
     */
    public EducationAssignment withAssignedDateTime(OffsetDateTime assignedDateTime) {
        EducationAssignment _x = _copy();
        _x.changedFields = changedFields.add("assignedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationAssignment");
        _x.assignedDateTime = assignedDateTime;
        return _x;
    }

    @Property(name="assignTo")
    @JsonIgnore
    public Optional<EducationAssignmentRecipient> getAssignTo() {
        return Optional.ofNullable(assignTo);
    }

    public EducationAssignment withAssignTo(EducationAssignmentRecipient assignTo) {
        EducationAssignment _x = _copy();
        _x.changedFields = changedFields.add("assignTo");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationAssignment");
        _x.assignTo = assignTo;
        return _x;
    }

    @Property(name="classId")
    @JsonIgnore
    public Optional<String> getClassId() {
        return Optional.ofNullable(classId);
    }

    public EducationAssignment withClassId(String classId) {
        EducationAssignment _x = _copy();
        _x.changedFields = changedFields.add("classId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationAssignment");
        _x.classId = classId;
        return _x;
    }

    @Property(name="closeDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getCloseDateTime() {
        return Optional.ofNullable(closeDateTime);
    }

    public EducationAssignment withCloseDateTime(OffsetDateTime closeDateTime) {
        EducationAssignment _x = _copy();
        _x.changedFields = changedFields.add("closeDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationAssignment");
        _x.closeDateTime = closeDateTime;
        return _x;
    }

    /**
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * 
     * @return property createdBy
     */
    @Property(name="createdBy")
    @JsonIgnore
    public Optional<IdentitySet> getCreatedBy() {
        return Optional.ofNullable(createdBy);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code createdBy} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * 
     * @param createdBy
     *            new value of {@code createdBy} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code createdBy} field changed
     */
    public EducationAssignment withCreatedBy(IdentitySet createdBy) {
        EducationAssignment _x = _copy();
        _x.changedFields = changedFields.add("createdBy");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationAssignment");
        _x.createdBy = createdBy;
        return _x;
    }

    /**
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * 
     * @return property createdDateTime
     */
    @Property(name="createdDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedDateTime() {
        return Optional.ofNullable(createdDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code createdDateTime}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * 
     * @param createdDateTime
     *            new value of {@code createdDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code createdDateTime} field changed
     */
    public EducationAssignment withCreatedDateTime(OffsetDateTime createdDateTime) {
        EducationAssignment _x = _copy();
        _x.changedFields = changedFields.add("createdDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationAssignment");
        _x.createdDateTime = createdDateTime;
        return _x;
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public EducationAssignment withDisplayName(String displayName) {
        EducationAssignment _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationAssignment");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="dueDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getDueDateTime() {
        return Optional.ofNullable(dueDateTime);
    }

    public EducationAssignment withDueDateTime(OffsetDateTime dueDateTime) {
        EducationAssignment _x = _copy();
        _x.changedFields = changedFields.add("dueDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationAssignment");
        _x.dueDateTime = dueDateTime;
        return _x;
    }

    @Property(name="grading")
    @JsonIgnore
    public Optional<EducationAssignmentGradeType> getGrading() {
        return Optional.ofNullable(grading);
    }

    public EducationAssignment withGrading(EducationAssignmentGradeType grading) {
        EducationAssignment _x = _copy();
        _x.changedFields = changedFields.add("grading");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationAssignment");
        _x.grading = grading;
        return _x;
    }

    @Property(name="instructions")
    @JsonIgnore
    public Optional<EducationItemBody> getInstructions() {
        return Optional.ofNullable(instructions);
    }

    public EducationAssignment withInstructions(EducationItemBody instructions) {
        EducationAssignment _x = _copy();
        _x.changedFields = changedFields.add("instructions");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationAssignment");
        _x.instructions = instructions;
        return _x;
    }

    /**
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * 
     * @return property lastModifiedBy
     */
    @Property(name="lastModifiedBy")
    @JsonIgnore
    public Optional<IdentitySet> getLastModifiedBy() {
        return Optional.ofNullable(lastModifiedBy);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code lastModifiedBy}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * 
     * @param lastModifiedBy
     *            new value of {@code lastModifiedBy} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code lastModifiedBy} field changed
     */
    public EducationAssignment withLastModifiedBy(IdentitySet lastModifiedBy) {
        EducationAssignment _x = _copy();
        _x.changedFields = changedFields.add("lastModifiedBy");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationAssignment");
        _x.lastModifiedBy = lastModifiedBy;
        return _x;
    }

    /**
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * 
     * @return property lastModifiedDateTime
     */
    @Property(name="lastModifiedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastModifiedDateTime() {
        return Optional.ofNullable(lastModifiedDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * lastModifiedDateTime} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * 
     * @param lastModifiedDateTime
     *            new value of {@code lastModifiedDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code lastModifiedDateTime} field changed
     */
    public EducationAssignment withLastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
        EducationAssignment _x = _copy();
        _x.changedFields = changedFields.add("lastModifiedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationAssignment");
        _x.lastModifiedDateTime = lastModifiedDateTime;
        return _x;
    }

    @Property(name="notificationChannelUrl")
    @JsonIgnore
    public Optional<String> getNotificationChannelUrl() {
        return Optional.ofNullable(notificationChannelUrl);
    }

    public EducationAssignment withNotificationChannelUrl(String notificationChannelUrl) {
        EducationAssignment _x = _copy();
        _x.changedFields = changedFields.add("notificationChannelUrl");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationAssignment");
        _x.notificationChannelUrl = notificationChannelUrl;
        return _x;
    }

    /**
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * 
     * @return property resourcesFolderUrl
     */
    @Property(name="resourcesFolderUrl")
    @JsonIgnore
    public Optional<String> getResourcesFolderUrl() {
        return Optional.ofNullable(resourcesFolderUrl);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * resourcesFolderUrl} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * 
     * @param resourcesFolderUrl
     *            new value of {@code resourcesFolderUrl} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code resourcesFolderUrl} field changed
     */
    public EducationAssignment withResourcesFolderUrl(String resourcesFolderUrl) {
        EducationAssignment _x = _copy();
        _x.changedFields = changedFields.add("resourcesFolderUrl");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationAssignment");
        _x.resourcesFolderUrl = resourcesFolderUrl;
        return _x;
    }

    /**
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * 
     * @return property status
     */
    @Property(name="status")
    @JsonIgnore
    public Optional<EducationAssignmentStatus> getStatus() {
        return Optional.ofNullable(status);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code status} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * 
     * @param status
     *            new value of {@code status} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code status} field changed
     */
    public EducationAssignment withStatus(EducationAssignmentStatus status) {
        EducationAssignment _x = _copy();
        _x.changedFields = changedFields.add("status");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationAssignment");
        _x.status = status;
        return _x;
    }

    /**
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * 
     * @return property webUrl
     */
    @Property(name="webUrl")
    @JsonIgnore
    public Optional<String> getWebUrl() {
        return Optional.ofNullable(webUrl);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code webUrl} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * 
     * @param webUrl
     *            new value of {@code webUrl} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code webUrl} field changed
     */
    public EducationAssignment withWebUrl(String webUrl) {
        EducationAssignment _x = _copy();
        _x.changedFields = changedFields.add("webUrl");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationAssignment");
        _x.webUrl = webUrl;
        return _x;
    }

    public EducationAssignment withUnmappedField(String name, Object value) {
        EducationAssignment _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="categories")
    @JsonIgnore
    public EducationCategoryCollectionRequest getCategories() {
        return new EducationCategoryCollectionRequest(
                        contextPath.addSegment("categories"), Optional.ofNullable(categories));
    }

    @NavigationProperty(name="resources")
    @JsonIgnore
    public EducationAssignmentResourceCollectionRequest getResources() {
        return new EducationAssignmentResourceCollectionRequest(
                        contextPath.addSegment("resources"), Optional.ofNullable(resources));
    }

    @NavigationProperty(name="rubric")
    @JsonIgnore
    public EducationRubricRequest getRubric() {
        return new EducationRubricRequest(contextPath.addSegment("rubric"), Optional.ofNullable(rubric));
    }

    @NavigationProperty(name="submissions")
    @JsonIgnore
    public EducationSubmissionCollectionRequest getSubmissions() {
        return new EducationSubmissionCollectionRequest(
                        contextPath.addSegment("submissions"), Optional.ofNullable(submissions));
    }

    public EducationAssignment withCategories(List<EducationCategory> categories) {
        EducationAssignment _x = _copy();
        _x.changedFields = changedFields.add("categories");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationAssignment");
        _x.categories = categories;
        return _x;
    }

    public EducationAssignment withResources(List<EducationAssignmentResource> resources) {
        EducationAssignment _x = _copy();
        _x.changedFields = changedFields.add("resources");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationAssignment");
        _x.resources = resources;
        return _x;
    }

    public EducationAssignment withRubric(EducationRubric rubric) {
        EducationAssignment _x = _copy();
        _x.changedFields = changedFields.add("rubric");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationAssignment");
        _x.rubric = rubric;
        return _x;
    }

    public EducationAssignment withSubmissions(List<EducationSubmission> submissions) {
        EducationAssignment _x = _copy();
        _x.changedFields = changedFields.add("submissions");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationAssignment");
        _x.submissions = submissions;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public EducationAssignment patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        EducationAssignment _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public EducationAssignment put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        EducationAssignment _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private EducationAssignment _copy() {
        EducationAssignment _x = new EducationAssignment();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.addedStudentAction = addedStudentAction;
        _x.addToCalendarAction = addToCalendarAction;
        _x.allowLateSubmissions = allowLateSubmissions;
        _x.allowStudentsToAddResourcesToSubmission = allowStudentsToAddResourcesToSubmission;
        _x.assignDateTime = assignDateTime;
        _x.assignedDateTime = assignedDateTime;
        _x.assignTo = assignTo;
        _x.classId = classId;
        _x.closeDateTime = closeDateTime;
        _x.createdBy = createdBy;
        _x.createdDateTime = createdDateTime;
        _x.displayName = displayName;
        _x.dueDateTime = dueDateTime;
        _x.grading = grading;
        _x.instructions = instructions;
        _x.lastModifiedBy = lastModifiedBy;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.notificationChannelUrl = notificationChannelUrl;
        _x.resourcesFolderUrl = resourcesFolderUrl;
        _x.status = status;
        _x.webUrl = webUrl;
        _x.categories = categories;
        _x.resources = resources;
        _x.rubric = rubric;
        _x.submissions = submissions;
        return _x;
    }

    @Action(name = "publish")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<EducationAssignment> publish() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestReturningNonCollectionUnwrapped<EducationAssignment>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.publish"), EducationAssignment.class, _parameters);
    }

    @Action(name = "setUpResourcesFolder")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<EducationAssignment> setUpResourcesFolder() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestReturningNonCollectionUnwrapped<EducationAssignment>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.setUpResourcesFolder"), EducationAssignment.class, _parameters);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("EducationAssignment[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("addedStudentAction=");
        b.append(this.addedStudentAction);
        b.append(", ");
        b.append("addToCalendarAction=");
        b.append(this.addToCalendarAction);
        b.append(", ");
        b.append("allowLateSubmissions=");
        b.append(this.allowLateSubmissions);
        b.append(", ");
        b.append("allowStudentsToAddResourcesToSubmission=");
        b.append(this.allowStudentsToAddResourcesToSubmission);
        b.append(", ");
        b.append("assignDateTime=");
        b.append(this.assignDateTime);
        b.append(", ");
        b.append("assignedDateTime=");
        b.append(this.assignedDateTime);
        b.append(", ");
        b.append("assignTo=");
        b.append(this.assignTo);
        b.append(", ");
        b.append("classId=");
        b.append(this.classId);
        b.append(", ");
        b.append("closeDateTime=");
        b.append(this.closeDateTime);
        b.append(", ");
        b.append("createdBy=");
        b.append(this.createdBy);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("dueDateTime=");
        b.append(this.dueDateTime);
        b.append(", ");
        b.append("grading=");
        b.append(this.grading);
        b.append(", ");
        b.append("instructions=");
        b.append(this.instructions);
        b.append(", ");
        b.append("lastModifiedBy=");
        b.append(this.lastModifiedBy);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("notificationChannelUrl=");
        b.append(this.notificationChannelUrl);
        b.append(", ");
        b.append("resourcesFolderUrl=");
        b.append(this.resourcesFolderUrl);
        b.append(", ");
        b.append("status=");
        b.append(this.status);
        b.append(", ");
        b.append("webUrl=");
        b.append(this.webUrl);
        b.append(", ");
        b.append("categories=");
        b.append(this.categories);
        b.append(", ");
        b.append("resources=");
        b.append(this.resources);
        b.append(", ");
        b.append("rubric=");
        b.append(this.rubric);
        b.append(", ");
        b.append("submissions=");
        b.append(this.submissions);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
