package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.SettingTemplateValue;

@JsonPropertyOrder({
    "@odata.type", 
    "description", 
    "displayName", 
    "values"})
@JsonInclude(Include.NON_NULL)
public class DirectorySettingTemplate extends DirectoryObject implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.directorySettingTemplate";
    }

    @JsonProperty("description")
    protected String description;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("values")
    protected List<SettingTemplateValue> values;

    @JsonProperty("values@nextLink")
    protected String valuesNextLink;

    protected DirectorySettingTemplate() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderDirectorySettingTemplate() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private OffsetDateTime deletedDateTime;
        private String description;
        private String displayName;
        private List<SettingTemplateValue> values;
        private String valuesNextLink;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder deletedDateTime(OffsetDateTime deletedDateTime) {
            this.deletedDateTime = deletedDateTime;
            this.changedFields = changedFields.add("deletedDateTime");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder values(List<SettingTemplateValue> values) {
            this.values = values;
            this.changedFields = changedFields.add("values");
            return this;
        }

        public Builder values(SettingTemplateValue... values) {
            return values(Arrays.asList(values));
        }

        public Builder valuesNextLink(String valuesNextLink) {
            this.valuesNextLink = valuesNextLink;
            this.changedFields = changedFields.add("values");
            return this;
        }

        public DirectorySettingTemplate build() {
            DirectorySettingTemplate _x = new DirectorySettingTemplate();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.directorySettingTemplate";
            _x.id = id;
            _x.deletedDateTime = deletedDateTime;
            _x.description = description;
            _x.displayName = displayName;
            _x.values = values;
            _x.valuesNextLink = valuesNextLink;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    public DirectorySettingTemplate withDescription(String description) {
        DirectorySettingTemplate _x = _copy();
        _x.changedFields = changedFields.add("description");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.directorySettingTemplate");
        _x.description = description;
        return _x;
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public DirectorySettingTemplate withDisplayName(String displayName) {
        DirectorySettingTemplate _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.directorySettingTemplate");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="values")
    @JsonIgnore
    public CollectionPage<SettingTemplateValue> getValues() {
        return new CollectionPage<SettingTemplateValue>(contextPath, SettingTemplateValue.class, this.values, Optional.ofNullable(valuesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public DirectorySettingTemplate withValues(List<SettingTemplateValue> values) {
        DirectorySettingTemplate _x = _copy();
        _x.changedFields = changedFields.add("values");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.directorySettingTemplate");
        _x.values = values;
        return _x;
    }

    @Property(name="values")
    @JsonIgnore
    public CollectionPage<SettingTemplateValue> getValues(HttpRequestOptions options) {
        return new CollectionPage<SettingTemplateValue>(contextPath, SettingTemplateValue.class, this.values, Optional.ofNullable(valuesNextLink), Collections.emptyList(), options);
    }

    public DirectorySettingTemplate withUnmappedField(String name, Object value) {
        DirectorySettingTemplate _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DirectorySettingTemplate patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        DirectorySettingTemplate _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DirectorySettingTemplate put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        DirectorySettingTemplate _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private DirectorySettingTemplate _copy() {
        DirectorySettingTemplate _x = new DirectorySettingTemplate();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.deletedDateTime = deletedDateTime;
        _x.description = description;
        _x.displayName = displayName;
        _x.values = values;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DirectorySettingTemplate[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("deletedDateTime=");
        b.append(this.deletedDateTime);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("values=");
        b.append(this.values);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
