package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;
import java.util.UUID;

@JsonPropertyOrder({
    "@odata.type", 
    "description", 
    "displayName", 
    "externalPartnerTenantId", 
    "objectType"})
@JsonInclude(Include.NON_NULL)
public class DirectoryObjectPartnerReference extends DirectoryObject implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.directoryObjectPartnerReference";
    }

    @JsonProperty("description")
    protected String description;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("externalPartnerTenantId")
    protected UUID externalPartnerTenantId;

    @JsonProperty("objectType")
    protected String objectType;

    protected DirectoryObjectPartnerReference() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderDirectoryObjectPartnerReference() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private OffsetDateTime deletedDateTime;
        private String description;
        private String displayName;
        private UUID externalPartnerTenantId;
        private String objectType;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder deletedDateTime(OffsetDateTime deletedDateTime) {
            this.deletedDateTime = deletedDateTime;
            this.changedFields = changedFields.add("deletedDateTime");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder externalPartnerTenantId(UUID externalPartnerTenantId) {
            this.externalPartnerTenantId = externalPartnerTenantId;
            this.changedFields = changedFields.add("externalPartnerTenantId");
            return this;
        }

        public Builder objectType(String objectType) {
            this.objectType = objectType;
            this.changedFields = changedFields.add("objectType");
            return this;
        }

        public DirectoryObjectPartnerReference build() {
            DirectoryObjectPartnerReference _x = new DirectoryObjectPartnerReference();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.directoryObjectPartnerReference";
            _x.id = id;
            _x.deletedDateTime = deletedDateTime;
            _x.description = description;
            _x.displayName = displayName;
            _x.externalPartnerTenantId = externalPartnerTenantId;
            _x.objectType = objectType;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    public DirectoryObjectPartnerReference withDescription(String description) {
        DirectoryObjectPartnerReference _x = _copy();
        _x.changedFields = changedFields.add("description");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.directoryObjectPartnerReference");
        _x.description = description;
        return _x;
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public DirectoryObjectPartnerReference withDisplayName(String displayName) {
        DirectoryObjectPartnerReference _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.directoryObjectPartnerReference");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="externalPartnerTenantId")
    @JsonIgnore
    public Optional<UUID> getExternalPartnerTenantId() {
        return Optional.ofNullable(externalPartnerTenantId);
    }

    public DirectoryObjectPartnerReference withExternalPartnerTenantId(UUID externalPartnerTenantId) {
        DirectoryObjectPartnerReference _x = _copy();
        _x.changedFields = changedFields.add("externalPartnerTenantId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.directoryObjectPartnerReference");
        _x.externalPartnerTenantId = externalPartnerTenantId;
        return _x;
    }

    @Property(name="objectType")
    @JsonIgnore
    public Optional<String> getObjectType() {
        return Optional.ofNullable(objectType);
    }

    public DirectoryObjectPartnerReference withObjectType(String objectType) {
        DirectoryObjectPartnerReference _x = _copy();
        _x.changedFields = changedFields.add("objectType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.directoryObjectPartnerReference");
        _x.objectType = objectType;
        return _x;
    }

    public DirectoryObjectPartnerReference withUnmappedField(String name, Object value) {
        DirectoryObjectPartnerReference _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DirectoryObjectPartnerReference patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        DirectoryObjectPartnerReference _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DirectoryObjectPartnerReference put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        DirectoryObjectPartnerReference _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private DirectoryObjectPartnerReference _copy() {
        DirectoryObjectPartnerReference _x = new DirectoryObjectPartnerReference();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.deletedDateTime = deletedDateTime;
        _x.description = description;
        _x.displayName = displayName;
        _x.externalPartnerTenantId = externalPartnerTenantId;
        _x.objectType = objectType;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DirectoryObjectPartnerReference[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("deletedDateTime=");
        b.append(this.deletedDateTime);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("externalPartnerTenantId=");
        b.append(this.externalPartnerTenantId);
        b.append(", ");
        b.append("objectType=");
        b.append(this.objectType);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
