package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;


/**
 * <i>“This is the base class for Setup Configuration. Setup configurations are
 * platform specific and individual per-platform setup configurations inherit from
 * here.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "createdDateTime", 
    "description", 
    "displayName", 
    "lastModifiedDateTime", 
    "version"})
@JsonInclude(Include.NON_NULL)
public class DeviceSetupConfiguration extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.deviceSetupConfiguration";
    }

    @JsonProperty("createdDateTime")
    protected OffsetDateTime createdDateTime;

    @JsonProperty("description")
    protected String description;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("lastModifiedDateTime")
    protected OffsetDateTime lastModifiedDateTime;

    @JsonProperty("version")
    protected Integer version;

    protected DeviceSetupConfiguration() {
        super();
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“DateTime the object was created.”</i>
     * 
     * @return property createdDateTime
     */
    @Property(name="createdDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedDateTime() {
        return Optional.ofNullable(createdDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code createdDateTime}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“DateTime the object was created.”</i>
     * 
     * @param createdDateTime
     *            new value of {@code createdDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code createdDateTime} field changed
     */
    public DeviceSetupConfiguration withCreatedDateTime(OffsetDateTime createdDateTime) {
        DeviceSetupConfiguration _x = _copy();
        _x.changedFields = changedFields.add("createdDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceSetupConfiguration");
        _x.createdDateTime = createdDateTime;
        return _x;
    }

    /**
     * <i>“Admin provided description of the Device Configuration.”</i>
     * 
     * @return property description
     */
    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code description}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Admin provided description of the Device Configuration.”</i>
     * 
     * @param description
     *            new value of {@code description} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code description} field changed
     */
    public DeviceSetupConfiguration withDescription(String description) {
        DeviceSetupConfiguration _x = _copy();
        _x.changedFields = changedFields.add("description");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceSetupConfiguration");
        _x.description = description;
        return _x;
    }

    /**
     * <i>“Admin provided name of the device configuration.”</i>
     * 
     * @return property displayName
     */
    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code displayName}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Admin provided name of the device configuration.”</i>
     * 
     * @param displayName
     *            new value of {@code displayName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code displayName} field changed
     */
    public DeviceSetupConfiguration withDisplayName(String displayName) {
        DeviceSetupConfiguration _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceSetupConfiguration");
        _x.displayName = displayName;
        return _x;
    }

    /**
     * <i>“DateTime the object was last modified.”</i>
     * 
     * @return property lastModifiedDateTime
     */
    @Property(name="lastModifiedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastModifiedDateTime() {
        return Optional.ofNullable(lastModifiedDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * lastModifiedDateTime} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“DateTime the object was last modified.”</i>
     * 
     * @param lastModifiedDateTime
     *            new value of {@code lastModifiedDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code lastModifiedDateTime} field changed
     */
    public DeviceSetupConfiguration withLastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
        DeviceSetupConfiguration _x = _copy();
        _x.changedFields = changedFields.add("lastModifiedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceSetupConfiguration");
        _x.lastModifiedDateTime = lastModifiedDateTime;
        return _x;
    }

    /**
     * <i>“Version of the device configuration.”</i>
     * 
     * @return property version
     */
    @Property(name="version")
    @JsonIgnore
    public Optional<Integer> getVersion() {
        return Optional.ofNullable(version);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code version} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Version of the device configuration.”</i>
     * 
     * @param version
     *            new value of {@code version} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code version} field changed
     */
    public DeviceSetupConfiguration withVersion(Integer version) {
        DeviceSetupConfiguration _x = _copy();
        _x.changedFields = changedFields.add("version");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceSetupConfiguration");
        _x.version = version;
        return _x;
    }

    public DeviceSetupConfiguration withUnmappedField(String name, Object value) {
        DeviceSetupConfiguration _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DeviceSetupConfiguration patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        DeviceSetupConfiguration _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DeviceSetupConfiguration put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        DeviceSetupConfiguration _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private DeviceSetupConfiguration _copy() {
        DeviceSetupConfiguration _x = new DeviceSetupConfiguration();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.createdDateTime = createdDateTime;
        _x.description = description;
        _x.displayName = displayName;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.version = version;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DeviceSetupConfiguration[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("version=");
        b.append(this.version);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
