package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.DeviceManagementTroubleshootingErrorDetails;
import odata.msgraph.client.beta.complex.KeyValuePair;


/**
 * <i>“Event representing an general failure.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "additionalInformation", 
    "correlationId", 
    "eventDateTime", 
    "eventName", 
    "troubleshootingErrorDetails"})
@JsonInclude(Include.NON_NULL)
public class DeviceManagementTroubleshootingEvent extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.deviceManagementTroubleshootingEvent";
    }

    @JsonProperty("additionalInformation")
    protected List<KeyValuePair> additionalInformation;

    @JsonProperty("additionalInformation@nextLink")
    protected String additionalInformationNextLink;

    @JsonProperty("correlationId")
    protected String correlationId;

    @JsonProperty("eventDateTime")
    protected OffsetDateTime eventDateTime;

    @JsonProperty("eventName")
    protected String eventName;

    @JsonProperty("troubleshootingErrorDetails")
    protected DeviceManagementTroubleshootingErrorDetails troubleshootingErrorDetails;

    protected DeviceManagementTroubleshootingEvent() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderDeviceManagementTroubleshootingEvent() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private List<KeyValuePair> additionalInformation;
        private String additionalInformationNextLink;
        private String correlationId;
        private OffsetDateTime eventDateTime;
        private String eventName;
        private DeviceManagementTroubleshootingErrorDetails troubleshootingErrorDetails;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“A set of string key and string value pairs which provides additional information
         * on the Troubleshooting event”</i>
         * 
         * @param additionalInformation
         *            value of {@code additionalInformation} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder additionalInformation(List<KeyValuePair> additionalInformation) {
            this.additionalInformation = additionalInformation;
            this.changedFields = changedFields.add("additionalInformation");
            return this;
        }

        /**
         * <i>“A set of string key and string value pairs which provides additional information
         * on the Troubleshooting event”</i>
         * 
         * @param additionalInformation
         *            value of {@code additionalInformation} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder additionalInformation(KeyValuePair... additionalInformation) {
            return additionalInformation(Arrays.asList(additionalInformation));
        }

        /**
         * <i>“A set of string key and string value pairs which provides additional information
         * on the Troubleshooting event”</i>
         * 
         * @param additionalInformationNextLink
         *            value of {@code additionalInformation@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder additionalInformationNextLink(String additionalInformationNextLink) {
            this.additionalInformationNextLink = additionalInformationNextLink;
            this.changedFields = changedFields.add("additionalInformation");
            return this;
        }

        /**
         * <i>“Id used for tracing the failure in the service.”</i>
         * 
         * @param correlationId
         *            value of {@code correlationId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder correlationId(String correlationId) {
            this.correlationId = correlationId;
            this.changedFields = changedFields.add("correlationId");
            return this;
        }

        /**
         * <i>“Time when the event occurred .”</i>
         * 
         * @param eventDateTime
         *            value of {@code eventDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder eventDateTime(OffsetDateTime eventDateTime) {
            this.eventDateTime = eventDateTime;
            this.changedFields = changedFields.add("eventDateTime");
            return this;
        }

        /**
         * <i>“Event Name corresponding to the Troubleshooting Event. It is an Optional field”</i>
         * 
         * @param eventName
         *            value of {@code eventName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder eventName(String eventName) {
            this.eventName = eventName;
            this.changedFields = changedFields.add("eventName");
            return this;
        }

        /**
         * <i>“Object containing detailed information about the error and its remediation.”</i>
         * 
         * @param troubleshootingErrorDetails
         *            value of {@code troubleshootingErrorDetails} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder troubleshootingErrorDetails(DeviceManagementTroubleshootingErrorDetails troubleshootingErrorDetails) {
            this.troubleshootingErrorDetails = troubleshootingErrorDetails;
            this.changedFields = changedFields.add("troubleshootingErrorDetails");
            return this;
        }

        public DeviceManagementTroubleshootingEvent build() {
            DeviceManagementTroubleshootingEvent _x = new DeviceManagementTroubleshootingEvent();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.deviceManagementTroubleshootingEvent";
            _x.id = id;
            _x.additionalInformation = additionalInformation;
            _x.additionalInformationNextLink = additionalInformationNextLink;
            _x.correlationId = correlationId;
            _x.eventDateTime = eventDateTime;
            _x.eventName = eventName;
            _x.troubleshootingErrorDetails = troubleshootingErrorDetails;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“A set of string key and string value pairs which provides additional information
     * on the Troubleshooting event”</i>
     * 
     * @return property additionalInformation
     */
    @Property(name="additionalInformation")
    @JsonIgnore
    public CollectionPage<KeyValuePair> getAdditionalInformation() {
        return new CollectionPage<KeyValuePair>(contextPath, KeyValuePair.class, this.additionalInformation, Optional.ofNullable(additionalInformationNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * additionalInformation} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“A set of string key and string value pairs which provides additional information
     * on the Troubleshooting event”</i>
     * 
     * @param additionalInformation
     *            new value of {@code additionalInformation} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code additionalInformation} field changed
     */
    public DeviceManagementTroubleshootingEvent withAdditionalInformation(List<KeyValuePair> additionalInformation) {
        DeviceManagementTroubleshootingEvent _x = _copy();
        _x.changedFields = changedFields.add("additionalInformation");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementTroubleshootingEvent");
        _x.additionalInformation = additionalInformation;
        return _x;
    }

    /**
     * <i>“A set of string key and string value pairs which provides additional information
     * on the Troubleshooting event”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property additionalInformation
     */
    @Property(name="additionalInformation")
    @JsonIgnore
    public CollectionPage<KeyValuePair> getAdditionalInformation(HttpRequestOptions options) {
        return new CollectionPage<KeyValuePair>(contextPath, KeyValuePair.class, this.additionalInformation, Optional.ofNullable(additionalInformationNextLink), Collections.emptyList(), options);
    }

    /**
     * <i>“Id used for tracing the failure in the service.”</i>
     * 
     * @return property correlationId
     */
    @Property(name="correlationId")
    @JsonIgnore
    public Optional<String> getCorrelationId() {
        return Optional.ofNullable(correlationId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code correlationId}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Id used for tracing the failure in the service.”</i>
     * 
     * @param correlationId
     *            new value of {@code correlationId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code correlationId} field changed
     */
    public DeviceManagementTroubleshootingEvent withCorrelationId(String correlationId) {
        DeviceManagementTroubleshootingEvent _x = _copy();
        _x.changedFields = changedFields.add("correlationId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementTroubleshootingEvent");
        _x.correlationId = correlationId;
        return _x;
    }

    /**
     * <i>“Time when the event occurred .”</i>
     * 
     * @return property eventDateTime
     */
    @Property(name="eventDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getEventDateTime() {
        return Optional.ofNullable(eventDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code eventDateTime}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Time when the event occurred .”</i>
     * 
     * @param eventDateTime
     *            new value of {@code eventDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code eventDateTime} field changed
     */
    public DeviceManagementTroubleshootingEvent withEventDateTime(OffsetDateTime eventDateTime) {
        DeviceManagementTroubleshootingEvent _x = _copy();
        _x.changedFields = changedFields.add("eventDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementTroubleshootingEvent");
        _x.eventDateTime = eventDateTime;
        return _x;
    }

    /**
     * <i>“Event Name corresponding to the Troubleshooting Event. It is an Optional field”</i>
     * 
     * @return property eventName
     */
    @Property(name="eventName")
    @JsonIgnore
    public Optional<String> getEventName() {
        return Optional.ofNullable(eventName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code eventName} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Event Name corresponding to the Troubleshooting Event. It is an Optional field”</i>
     * 
     * @param eventName
     *            new value of {@code eventName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code eventName} field changed
     */
    public DeviceManagementTroubleshootingEvent withEventName(String eventName) {
        DeviceManagementTroubleshootingEvent _x = _copy();
        _x.changedFields = changedFields.add("eventName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementTroubleshootingEvent");
        _x.eventName = eventName;
        return _x;
    }

    /**
     * <i>“Object containing detailed information about the error and its remediation.”</i>
     * 
     * @return property troubleshootingErrorDetails
     */
    @Property(name="troubleshootingErrorDetails")
    @JsonIgnore
    public Optional<DeviceManagementTroubleshootingErrorDetails> getTroubleshootingErrorDetails() {
        return Optional.ofNullable(troubleshootingErrorDetails);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * troubleshootingErrorDetails} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Object containing detailed information about the error and its remediation.”</i>
     * 
     * @param troubleshootingErrorDetails
     *            new value of {@code troubleshootingErrorDetails} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code troubleshootingErrorDetails} field changed
     */
    public DeviceManagementTroubleshootingEvent withTroubleshootingErrorDetails(DeviceManagementTroubleshootingErrorDetails troubleshootingErrorDetails) {
        DeviceManagementTroubleshootingEvent _x = _copy();
        _x.changedFields = changedFields.add("troubleshootingErrorDetails");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementTroubleshootingEvent");
        _x.troubleshootingErrorDetails = troubleshootingErrorDetails;
        return _x;
    }

    public DeviceManagementTroubleshootingEvent withUnmappedField(String name, Object value) {
        DeviceManagementTroubleshootingEvent _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DeviceManagementTroubleshootingEvent patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        DeviceManagementTroubleshootingEvent _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DeviceManagementTroubleshootingEvent put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        DeviceManagementTroubleshootingEvent _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private DeviceManagementTroubleshootingEvent _copy() {
        DeviceManagementTroubleshootingEvent _x = new DeviceManagementTroubleshootingEvent();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.additionalInformation = additionalInformation;
        _x.correlationId = correlationId;
        _x.eventDateTime = eventDateTime;
        _x.eventName = eventName;
        _x.troubleshootingErrorDetails = troubleshootingErrorDetails;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DeviceManagementTroubleshootingEvent[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("additionalInformation=");
        b.append(this.additionalInformation);
        b.append(", ");
        b.append("correlationId=");
        b.append(this.correlationId);
        b.append(", ");
        b.append("eventDateTime=");
        b.append(this.eventDateTime);
        b.append(", ");
        b.append("eventName=");
        b.append(this.eventName);
        b.append(", ");
        b.append("troubleshootingErrorDetails=");
        b.append(this.troubleshootingErrorDetails);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
