package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.entity.collection.request.DeviceManagementSettingInstanceCollectionRequest;


/**
 * <i>“Entity representing a template setting category”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "recommendedSettings"})
@JsonInclude(Include.NON_NULL)
public class DeviceManagementTemplateSettingCategory extends DeviceManagementSettingCategory implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.deviceManagementTemplateSettingCategory";
    }

    @JsonProperty("recommendedSettings")
    protected List<DeviceManagementSettingInstance> recommendedSettings;

    protected DeviceManagementTemplateSettingCategory() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderDeviceManagementTemplateSettingCategory() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String displayName;
        private Boolean hasRequiredSetting;
        private List<DeviceManagementSettingDefinition> settingDefinitions;
        private List<DeviceManagementSettingInstance> recommendedSettings;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder hasRequiredSetting(Boolean hasRequiredSetting) {
            this.hasRequiredSetting = hasRequiredSetting;
            this.changedFields = changedFields.add("hasRequiredSetting");
            return this;
        }

        public Builder settingDefinitions(List<DeviceManagementSettingDefinition> settingDefinitions) {
            this.settingDefinitions = settingDefinitions;
            this.changedFields = changedFields.add("settingDefinitions");
            return this;
        }

        public Builder settingDefinitions(DeviceManagementSettingDefinition... settingDefinitions) {
            return settingDefinitions(Arrays.asList(settingDefinitions));
        }

        /**
         * <i>“The settings this category contains”</i>
         * 
         * @param recommendedSettings
         *            value of {@code recommendedSettings} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder recommendedSettings(List<DeviceManagementSettingInstance> recommendedSettings) {
            this.recommendedSettings = recommendedSettings;
            this.changedFields = changedFields.add("recommendedSettings");
            return this;
        }

        /**
         * <i>“The settings this category contains”</i>
         * 
         * @param recommendedSettings
         *            value of {@code recommendedSettings} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder recommendedSettings(DeviceManagementSettingInstance... recommendedSettings) {
            return recommendedSettings(Arrays.asList(recommendedSettings));
        }

        public DeviceManagementTemplateSettingCategory build() {
            DeviceManagementTemplateSettingCategory _x = new DeviceManagementTemplateSettingCategory();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.deviceManagementTemplateSettingCategory";
            _x.id = id;
            _x.displayName = displayName;
            _x.hasRequiredSetting = hasRequiredSetting;
            _x.settingDefinitions = settingDefinitions;
            _x.recommendedSettings = recommendedSettings;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    public DeviceManagementTemplateSettingCategory withUnmappedField(String name, Object value) {
        DeviceManagementTemplateSettingCategory _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    /**
     * <i>“The settings this category contains”</i>
     * 
     * @return navigational property recommendedSettings
     */
    @NavigationProperty(name="recommendedSettings")
    @JsonIgnore
    public DeviceManagementSettingInstanceCollectionRequest getRecommendedSettings() {
        return new DeviceManagementSettingInstanceCollectionRequest(
                        contextPath.addSegment("recommendedSettings"), Optional.ofNullable(recommendedSettings));
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * recommendedSettings} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The settings this category contains”</i>
     * 
     * @param recommendedSettings
     *            new value of {@code recommendedSettings} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code recommendedSettings} field changed
     */
    public DeviceManagementTemplateSettingCategory withRecommendedSettings(List<DeviceManagementSettingInstance> recommendedSettings) {
        DeviceManagementTemplateSettingCategory _x = _copy();
        _x.changedFields = changedFields.add("recommendedSettings");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementTemplateSettingCategory");
        _x.recommendedSettings = recommendedSettings;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DeviceManagementTemplateSettingCategory patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        DeviceManagementTemplateSettingCategory _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DeviceManagementTemplateSettingCategory put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        DeviceManagementTemplateSettingCategory _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private DeviceManagementTemplateSettingCategory _copy() {
        DeviceManagementTemplateSettingCategory _x = new DeviceManagementTemplateSettingCategory();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.displayName = displayName;
        _x.hasRequiredSetting = hasRequiredSetting;
        _x.settingDefinitions = settingDefinitions;
        _x.recommendedSettings = recommendedSettings;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DeviceManagementTemplateSettingCategory[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("hasRequiredSetting=");
        b.append(this.hasRequiredSetting);
        b.append(", ");
        b.append("settingDefinitions=");
        b.append(this.settingDefinitions);
        b.append(", ");
        b.append("recommendedSettings=");
        b.append(this.recommendedSettings);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
