package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.entity.collection.request.DeviceManagementSettingDefinitionCollectionRequest;


/**
 * <i>“Entity representing a setting category”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "displayName", 
    "hasRequiredSetting", 
    "settingDefinitions"})
@JsonInclude(Include.NON_NULL)
public class DeviceManagementSettingCategory extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.deviceManagementSettingCategory";
    }

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("hasRequiredSetting")
    protected Boolean hasRequiredSetting;

    @JsonProperty("settingDefinitions")
    protected List<DeviceManagementSettingDefinition> settingDefinitions;

    protected DeviceManagementSettingCategory() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderDeviceManagementSettingCategory() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String displayName;
        private Boolean hasRequiredSetting;
        private List<DeviceManagementSettingDefinition> settingDefinitions;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“The category name”</i>
         * 
         * @param displayName
         *            value of {@code displayName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        /**
         * <i>“The category contains top level required setting”</i>
         * 
         * @param hasRequiredSetting
         *            value of {@code hasRequiredSetting} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder hasRequiredSetting(Boolean hasRequiredSetting) {
            this.hasRequiredSetting = hasRequiredSetting;
            this.changedFields = changedFields.add("hasRequiredSetting");
            return this;
        }

        /**
         * <i>“The setting definitions this category contains”</i>
         * 
         * @param settingDefinitions
         *            value of {@code settingDefinitions} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder settingDefinitions(List<DeviceManagementSettingDefinition> settingDefinitions) {
            this.settingDefinitions = settingDefinitions;
            this.changedFields = changedFields.add("settingDefinitions");
            return this;
        }

        /**
         * <i>“The setting definitions this category contains”</i>
         * 
         * @param settingDefinitions
         *            value of {@code settingDefinitions} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder settingDefinitions(DeviceManagementSettingDefinition... settingDefinitions) {
            return settingDefinitions(Arrays.asList(settingDefinitions));
        }

        public DeviceManagementSettingCategory build() {
            DeviceManagementSettingCategory _x = new DeviceManagementSettingCategory();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.deviceManagementSettingCategory";
            _x.id = id;
            _x.displayName = displayName;
            _x.hasRequiredSetting = hasRequiredSetting;
            _x.settingDefinitions = settingDefinitions;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“The category name”</i>
     * 
     * @return property displayName
     */
    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code displayName}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The category name”</i>
     * 
     * @param displayName
     *            new value of {@code displayName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code displayName} field changed
     */
    public DeviceManagementSettingCategory withDisplayName(String displayName) {
        DeviceManagementSettingCategory _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementSettingCategory");
        _x.displayName = displayName;
        return _x;
    }

    /**
     * <i>“The category contains top level required setting”</i>
     * 
     * @return property hasRequiredSetting
     */
    @Property(name="hasRequiredSetting")
    @JsonIgnore
    public Optional<Boolean> getHasRequiredSetting() {
        return Optional.ofNullable(hasRequiredSetting);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * hasRequiredSetting} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The category contains top level required setting”</i>
     * 
     * @param hasRequiredSetting
     *            new value of {@code hasRequiredSetting} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code hasRequiredSetting} field changed
     */
    public DeviceManagementSettingCategory withHasRequiredSetting(Boolean hasRequiredSetting) {
        DeviceManagementSettingCategory _x = _copy();
        _x.changedFields = changedFields.add("hasRequiredSetting");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementSettingCategory");
        _x.hasRequiredSetting = hasRequiredSetting;
        return _x;
    }

    public DeviceManagementSettingCategory withUnmappedField(String name, Object value) {
        DeviceManagementSettingCategory _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    /**
     * <i>“The setting definitions this category contains”</i>
     * 
     * @return navigational property settingDefinitions
     */
    @NavigationProperty(name="settingDefinitions")
    @JsonIgnore
    public DeviceManagementSettingDefinitionCollectionRequest getSettingDefinitions() {
        return new DeviceManagementSettingDefinitionCollectionRequest(
                        contextPath.addSegment("settingDefinitions"), Optional.ofNullable(settingDefinitions));
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * settingDefinitions} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The setting definitions this category contains”</i>
     * 
     * @param settingDefinitions
     *            new value of {@code settingDefinitions} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code settingDefinitions} field changed
     */
    public DeviceManagementSettingCategory withSettingDefinitions(List<DeviceManagementSettingDefinition> settingDefinitions) {
        DeviceManagementSettingCategory _x = _copy();
        _x.changedFields = changedFields.add("settingDefinitions");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementSettingCategory");
        _x.settingDefinitions = settingDefinitions;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DeviceManagementSettingCategory patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        DeviceManagementSettingCategory _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DeviceManagementSettingCategory put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        DeviceManagementSettingCategory _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private DeviceManagementSettingCategory _copy() {
        DeviceManagementSettingCategory _x = new DeviceManagementSettingCategory();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.displayName = displayName;
        _x.hasRequiredSetting = hasRequiredSetting;
        _x.settingDefinitions = settingDefinitions;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DeviceManagementSettingCategory[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("hasRequiredSetting=");
        b.append(this.hasRequiredSetting);
        b.append(", ");
        b.append("settingDefinitions=");
        b.append(this.settingDefinitions);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
