package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.entity.collection.request.DeviceManagementScriptDeviceStateCollectionRequest;


/**
 * <i>“Contains properties for user run state of the device management script.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "errorDeviceCount", 
    "successDeviceCount", 
    "userPrincipalName", 
    "deviceRunStates"})
@JsonInclude(Include.NON_NULL)
public class DeviceManagementScriptUserState extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.deviceManagementScriptUserState";
    }

    @JsonProperty("errorDeviceCount")
    protected Integer errorDeviceCount;

    @JsonProperty("successDeviceCount")
    protected Integer successDeviceCount;

    @JsonProperty("userPrincipalName")
    protected String userPrincipalName;

    @JsonProperty("deviceRunStates")
    protected List<DeviceManagementScriptDeviceState> deviceRunStates;

    protected DeviceManagementScriptUserState() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderDeviceManagementScriptUserState() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private Integer errorDeviceCount;
        private Integer successDeviceCount;
        private String userPrincipalName;
        private List<DeviceManagementScriptDeviceState> deviceRunStates;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“Error device count for specific user.”</i>
         * 
         * @param errorDeviceCount
         *            value of {@code errorDeviceCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder errorDeviceCount(Integer errorDeviceCount) {
            this.errorDeviceCount = errorDeviceCount;
            this.changedFields = changedFields.add("errorDeviceCount");
            return this;
        }

        /**
         * <i>“Success device count for specific user.”</i>
         * 
         * @param successDeviceCount
         *            value of {@code successDeviceCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder successDeviceCount(Integer successDeviceCount) {
            this.successDeviceCount = successDeviceCount;
            this.changedFields = changedFields.add("successDeviceCount");
            return this;
        }

        /**
         * <i>“User principle name of specific user.”</i>
         * 
         * @param userPrincipalName
         *            value of {@code userPrincipalName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userPrincipalName(String userPrincipalName) {
            this.userPrincipalName = userPrincipalName;
            this.changedFields = changedFields.add("userPrincipalName");
            return this;
        }

        /**
         * <i>“List of run states for this script across all devices of specific user.”</i>
         * 
         * @param deviceRunStates
         *            value of {@code deviceRunStates} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceRunStates(List<DeviceManagementScriptDeviceState> deviceRunStates) {
            this.deviceRunStates = deviceRunStates;
            this.changedFields = changedFields.add("deviceRunStates");
            return this;
        }

        /**
         * <i>“List of run states for this script across all devices of specific user.”</i>
         * 
         * @param deviceRunStates
         *            value of {@code deviceRunStates} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceRunStates(DeviceManagementScriptDeviceState... deviceRunStates) {
            return deviceRunStates(Arrays.asList(deviceRunStates));
        }

        public DeviceManagementScriptUserState build() {
            DeviceManagementScriptUserState _x = new DeviceManagementScriptUserState();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.deviceManagementScriptUserState";
            _x.id = id;
            _x.errorDeviceCount = errorDeviceCount;
            _x.successDeviceCount = successDeviceCount;
            _x.userPrincipalName = userPrincipalName;
            _x.deviceRunStates = deviceRunStates;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“Error device count for specific user.”</i>
     * 
     * @return property errorDeviceCount
     */
    @Property(name="errorDeviceCount")
    @JsonIgnore
    public Optional<Integer> getErrorDeviceCount() {
        return Optional.ofNullable(errorDeviceCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code errorDeviceCount}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Error device count for specific user.”</i>
     * 
     * @param errorDeviceCount
     *            new value of {@code errorDeviceCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code errorDeviceCount} field changed
     */
    public DeviceManagementScriptUserState withErrorDeviceCount(Integer errorDeviceCount) {
        DeviceManagementScriptUserState _x = _copy();
        _x.changedFields = changedFields.add("errorDeviceCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementScriptUserState");
        _x.errorDeviceCount = errorDeviceCount;
        return _x;
    }

    /**
     * <i>“Success device count for specific user.”</i>
     * 
     * @return property successDeviceCount
     */
    @Property(name="successDeviceCount")
    @JsonIgnore
    public Optional<Integer> getSuccessDeviceCount() {
        return Optional.ofNullable(successDeviceCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * successDeviceCount} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Success device count for specific user.”</i>
     * 
     * @param successDeviceCount
     *            new value of {@code successDeviceCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code successDeviceCount} field changed
     */
    public DeviceManagementScriptUserState withSuccessDeviceCount(Integer successDeviceCount) {
        DeviceManagementScriptUserState _x = _copy();
        _x.changedFields = changedFields.add("successDeviceCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementScriptUserState");
        _x.successDeviceCount = successDeviceCount;
        return _x;
    }

    /**
     * <i>“User principle name of specific user.”</i>
     * 
     * @return property userPrincipalName
     */
    @Property(name="userPrincipalName")
    @JsonIgnore
    public Optional<String> getUserPrincipalName() {
        return Optional.ofNullable(userPrincipalName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code userPrincipalName
     * } field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“User principle name of specific user.”</i>
     * 
     * @param userPrincipalName
     *            new value of {@code userPrincipalName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code userPrincipalName} field changed
     */
    public DeviceManagementScriptUserState withUserPrincipalName(String userPrincipalName) {
        DeviceManagementScriptUserState _x = _copy();
        _x.changedFields = changedFields.add("userPrincipalName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementScriptUserState");
        _x.userPrincipalName = userPrincipalName;
        return _x;
    }

    public DeviceManagementScriptUserState withUnmappedField(String name, Object value) {
        DeviceManagementScriptUserState _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    /**
     * <i>“List of run states for this script across all devices of specific user.”</i>
     * 
     * @return navigational property deviceRunStates
     */
    @NavigationProperty(name="deviceRunStates")
    @JsonIgnore
    public DeviceManagementScriptDeviceStateCollectionRequest getDeviceRunStates() {
        return new DeviceManagementScriptDeviceStateCollectionRequest(
                        contextPath.addSegment("deviceRunStates"), Optional.ofNullable(deviceRunStates));
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code deviceRunStates}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“List of run states for this script across all devices of specific user.”</i>
     * 
     * @param deviceRunStates
     *            new value of {@code deviceRunStates} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceRunStates} field changed
     */
    public DeviceManagementScriptUserState withDeviceRunStates(List<DeviceManagementScriptDeviceState> deviceRunStates) {
        DeviceManagementScriptUserState _x = _copy();
        _x.changedFields = changedFields.add("deviceRunStates");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementScriptUserState");
        _x.deviceRunStates = deviceRunStates;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DeviceManagementScriptUserState patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        DeviceManagementScriptUserState _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DeviceManagementScriptUserState put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        DeviceManagementScriptUserState _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private DeviceManagementScriptUserState _copy() {
        DeviceManagementScriptUserState _x = new DeviceManagementScriptUserState();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.errorDeviceCount = errorDeviceCount;
        _x.successDeviceCount = successDeviceCount;
        _x.userPrincipalName = userPrincipalName;
        _x.deviceRunStates = deviceRunStates;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DeviceManagementScriptUserState[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("errorDeviceCount=");
        b.append(this.errorDeviceCount);
        b.append(", ");
        b.append("successDeviceCount=");
        b.append(this.successDeviceCount);
        b.append(", ");
        b.append("userPrincipalName=");
        b.append(this.userPrincipalName);
        b.append(", ");
        b.append("deviceRunStates=");
        b.append(this.deviceRunStates);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
