package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.complex.DeviceManagementConfigurationSettingInstance;
import odata.msgraph.client.beta.entity.collection.request.DeviceManagementConfigurationPolicyCollectionRequest;


/**
 * <i>“Graph model for a reusable setting”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "createdDateTime", 
    "description", 
    "displayName", 
    "lastModifiedDateTime", 
    "referencingConfigurationPolicyCount", 
    "settingDefinitionId", 
    "settingInstance", 
    "version", 
    "referencingConfigurationPolicies"})
@JsonInclude(Include.NON_NULL)
public class DeviceManagementReusablePolicySetting extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.deviceManagementReusablePolicySetting";
    }

    @JsonProperty("createdDateTime")
    protected OffsetDateTime createdDateTime;

    @JsonProperty("description")
    protected String description;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("lastModifiedDateTime")
    protected OffsetDateTime lastModifiedDateTime;

    @JsonProperty("referencingConfigurationPolicyCount")
    protected Integer referencingConfigurationPolicyCount;

    @JsonProperty("settingDefinitionId")
    protected String settingDefinitionId;

    @JsonProperty("settingInstance")
    protected DeviceManagementConfigurationSettingInstance settingInstance;

    @JsonProperty("version")
    protected Integer version;

    @JsonProperty("referencingConfigurationPolicies")
    protected List<DeviceManagementConfigurationPolicy> referencingConfigurationPolicies;

    protected DeviceManagementReusablePolicySetting() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderDeviceManagementReusablePolicySetting() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private OffsetDateTime createdDateTime;
        private String description;
        private String displayName;
        private OffsetDateTime lastModifiedDateTime;
        private Integer referencingConfigurationPolicyCount;
        private String settingDefinitionId;
        private DeviceManagementConfigurationSettingInstance settingInstance;
        private Integer version;
        private List<DeviceManagementConfigurationPolicy> referencingConfigurationPolicies;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“reusable setting creation date and time. This property is read-only.”</i>
         * <p>
         * <b>Org.OData.Core.V1.Computed</b>
         * <p>
         * true
         * <p>
         * <b>Org.OData.Core.V1.Permissions</b>
         * 
         * @param createdDateTime
         *            value of {@code createdDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        /**
         * <i>“reusable setting description supplied by user.”</i>
         * 
         * @param description
         *            value of {@code description} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        /**
         * <i>“reusable setting display name supplied by user.”</i>
         * 
         * @param displayName
         *            value of {@code displayName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        /**
         * <i>“date and time when reusable setting was last modified. This property is read-
         * only.”</i>
         * <p>
         * <b>Org.OData.Core.V1.Computed</b>
         * <p>
         * true
         * <p>
         * <b>Org.OData.Core.V1.Permissions</b>
         * 
         * @param lastModifiedDateTime
         *            value of {@code lastModifiedDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        /**
         * <i>“count of configuration policies referencing the current reusable setting. Valid
         * values 0 to 2147483647. This property is read-only.”</i>
         * <p>
         * <b>Org.OData.Core.V1.Computed</b>
         * <p>
         * true
         * <p>
         * <b>Org.OData.Core.V1.Permissions</b>
         * 
         * @param referencingConfigurationPolicyCount
         *            value of {@code referencingConfigurationPolicyCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder referencingConfigurationPolicyCount(Integer referencingConfigurationPolicyCount) {
            this.referencingConfigurationPolicyCount = referencingConfigurationPolicyCount;
            this.changedFields = changedFields.add("referencingConfigurationPolicyCount");
            return this;
        }

        /**
         * <i>“setting definition id associated with this reusable setting.”</i>
         * 
         * @param settingDefinitionId
         *            value of {@code settingDefinitionId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder settingDefinitionId(String settingDefinitionId) {
            this.settingDefinitionId = settingDefinitionId;
            this.changedFields = changedFields.add("settingDefinitionId");
            return this;
        }

        /**
         * <i>“reusable setting configuration instance”</i>
         * 
         * @param settingInstance
         *            value of {@code settingInstance} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder settingInstance(DeviceManagementConfigurationSettingInstance settingInstance) {
            this.settingInstance = settingInstance;
            this.changedFields = changedFields.add("settingInstance");
            return this;
        }

        /**
         * <i>“version number for reusable setting. Valid values 0 to 2147483647. This property
         * is read-only.”</i>
         * <p>
         * <b>Org.OData.Core.V1.Computed</b>
         * <p>
         * true
         * <p>
         * <b>Org.OData.Core.V1.Permissions</b>
         * 
         * @param version
         *            value of {@code version} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder version(Integer version) {
            this.version = version;
            this.changedFields = changedFields.add("version");
            return this;
        }

        /**
         * <i>“configuration policies referencing the current reusable setting. This property
         * is read-only.”</i>
         * <p>
         * <b>Org.OData.Core.V1.Computed</b>
         * <p>
         * true
         * <p>
         * <b>Org.OData.Core.V1.Permissions</b>
         * 
         * @param referencingConfigurationPolicies
         *            value of {@code referencingConfigurationPolicies} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder referencingConfigurationPolicies(List<DeviceManagementConfigurationPolicy> referencingConfigurationPolicies) {
            this.referencingConfigurationPolicies = referencingConfigurationPolicies;
            this.changedFields = changedFields.add("referencingConfigurationPolicies");
            return this;
        }

        /**
         * <i>“configuration policies referencing the current reusable setting. This property
         * is read-only.”</i>
         * <p>
         * <b>Org.OData.Core.V1.Computed</b>
         * <p>
         * true
         * <p>
         * <b>Org.OData.Core.V1.Permissions</b>
         * 
         * @param referencingConfigurationPolicies
         *            value of {@code referencingConfigurationPolicies} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder referencingConfigurationPolicies(DeviceManagementConfigurationPolicy... referencingConfigurationPolicies) {
            return referencingConfigurationPolicies(Arrays.asList(referencingConfigurationPolicies));
        }

        public DeviceManagementReusablePolicySetting build() {
            DeviceManagementReusablePolicySetting _x = new DeviceManagementReusablePolicySetting();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.deviceManagementReusablePolicySetting";
            _x.id = id;
            _x.createdDateTime = createdDateTime;
            _x.description = description;
            _x.displayName = displayName;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.referencingConfigurationPolicyCount = referencingConfigurationPolicyCount;
            _x.settingDefinitionId = settingDefinitionId;
            _x.settingInstance = settingInstance;
            _x.version = version;
            _x.referencingConfigurationPolicies = referencingConfigurationPolicies;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“reusable setting creation date and time. This property is read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @return property createdDateTime
     */
    @Property(name="createdDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedDateTime() {
        return Optional.ofNullable(createdDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code createdDateTime}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“reusable setting creation date and time. This property is read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @param createdDateTime
     *            new value of {@code createdDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code createdDateTime} field changed
     */
    public DeviceManagementReusablePolicySetting withCreatedDateTime(OffsetDateTime createdDateTime) {
        DeviceManagementReusablePolicySetting _x = _copy();
        _x.changedFields = changedFields.add("createdDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementReusablePolicySetting");
        _x.createdDateTime = createdDateTime;
        return _x;
    }

    /**
     * <i>“reusable setting description supplied by user.”</i>
     * 
     * @return property description
     */
    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code description}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“reusable setting description supplied by user.”</i>
     * 
     * @param description
     *            new value of {@code description} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code description} field changed
     */
    public DeviceManagementReusablePolicySetting withDescription(String description) {
        DeviceManagementReusablePolicySetting _x = _copy();
        _x.changedFields = changedFields.add("description");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementReusablePolicySetting");
        _x.description = description;
        return _x;
    }

    /**
     * <i>“reusable setting display name supplied by user.”</i>
     * 
     * @return property displayName
     */
    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code displayName}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“reusable setting display name supplied by user.”</i>
     * 
     * @param displayName
     *            new value of {@code displayName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code displayName} field changed
     */
    public DeviceManagementReusablePolicySetting withDisplayName(String displayName) {
        DeviceManagementReusablePolicySetting _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementReusablePolicySetting");
        _x.displayName = displayName;
        return _x;
    }

    /**
     * <i>“date and time when reusable setting was last modified. This property is read-
     * only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @return property lastModifiedDateTime
     */
    @Property(name="lastModifiedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastModifiedDateTime() {
        return Optional.ofNullable(lastModifiedDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * lastModifiedDateTime} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“date and time when reusable setting was last modified. This property is read-
     * only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @param lastModifiedDateTime
     *            new value of {@code lastModifiedDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code lastModifiedDateTime} field changed
     */
    public DeviceManagementReusablePolicySetting withLastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
        DeviceManagementReusablePolicySetting _x = _copy();
        _x.changedFields = changedFields.add("lastModifiedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementReusablePolicySetting");
        _x.lastModifiedDateTime = lastModifiedDateTime;
        return _x;
    }

    /**
     * <i>“count of configuration policies referencing the current reusable setting. Valid
     * values 0 to 2147483647. This property is read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @return property referencingConfigurationPolicyCount
     */
    @Property(name="referencingConfigurationPolicyCount")
    @JsonIgnore
    public Optional<Integer> getReferencingConfigurationPolicyCount() {
        return Optional.ofNullable(referencingConfigurationPolicyCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * referencingConfigurationPolicyCount} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“count of configuration policies referencing the current reusable setting. Valid
     * values 0 to 2147483647. This property is read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @param referencingConfigurationPolicyCount
     *            new value of {@code referencingConfigurationPolicyCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code referencingConfigurationPolicyCount} field changed
     */
    public DeviceManagementReusablePolicySetting withReferencingConfigurationPolicyCount(Integer referencingConfigurationPolicyCount) {
        DeviceManagementReusablePolicySetting _x = _copy();
        _x.changedFields = changedFields.add("referencingConfigurationPolicyCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementReusablePolicySetting");
        _x.referencingConfigurationPolicyCount = referencingConfigurationPolicyCount;
        return _x;
    }

    /**
     * <i>“setting definition id associated with this reusable setting.”</i>
     * 
     * @return property settingDefinitionId
     */
    @Property(name="settingDefinitionId")
    @JsonIgnore
    public Optional<String> getSettingDefinitionId() {
        return Optional.ofNullable(settingDefinitionId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * settingDefinitionId} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“setting definition id associated with this reusable setting.”</i>
     * 
     * @param settingDefinitionId
     *            new value of {@code settingDefinitionId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code settingDefinitionId} field changed
     */
    public DeviceManagementReusablePolicySetting withSettingDefinitionId(String settingDefinitionId) {
        DeviceManagementReusablePolicySetting _x = _copy();
        _x.changedFields = changedFields.add("settingDefinitionId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementReusablePolicySetting");
        _x.settingDefinitionId = settingDefinitionId;
        return _x;
    }

    /**
     * <i>“reusable setting configuration instance”</i>
     * 
     * @return property settingInstance
     */
    @Property(name="settingInstance")
    @JsonIgnore
    public Optional<DeviceManagementConfigurationSettingInstance> getSettingInstance() {
        return Optional.ofNullable(settingInstance);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code settingInstance}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“reusable setting configuration instance”</i>
     * 
     * @param settingInstance
     *            new value of {@code settingInstance} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code settingInstance} field changed
     */
    public DeviceManagementReusablePolicySetting withSettingInstance(DeviceManagementConfigurationSettingInstance settingInstance) {
        DeviceManagementReusablePolicySetting _x = _copy();
        _x.changedFields = changedFields.add("settingInstance");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementReusablePolicySetting");
        _x.settingInstance = settingInstance;
        return _x;
    }

    /**
     * <i>“version number for reusable setting. Valid values 0 to 2147483647. This property
     * is read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @return property version
     */
    @Property(name="version")
    @JsonIgnore
    public Optional<Integer> getVersion() {
        return Optional.ofNullable(version);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code version} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“version number for reusable setting. Valid values 0 to 2147483647. This property
     * is read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @param version
     *            new value of {@code version} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code version} field changed
     */
    public DeviceManagementReusablePolicySetting withVersion(Integer version) {
        DeviceManagementReusablePolicySetting _x = _copy();
        _x.changedFields = changedFields.add("version");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementReusablePolicySetting");
        _x.version = version;
        return _x;
    }

    public DeviceManagementReusablePolicySetting withUnmappedField(String name, Object value) {
        DeviceManagementReusablePolicySetting _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    /**
     * <i>“configuration policies referencing the current reusable setting. This property
     * is read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @return navigational property referencingConfigurationPolicies
     */
    @NavigationProperty(name="referencingConfigurationPolicies")
    @JsonIgnore
    public DeviceManagementConfigurationPolicyCollectionRequest getReferencingConfigurationPolicies() {
        return new DeviceManagementConfigurationPolicyCollectionRequest(
                        contextPath.addSegment("referencingConfigurationPolicies"), Optional.ofNullable(referencingConfigurationPolicies));
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * referencingConfigurationPolicies} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“configuration policies referencing the current reusable setting. This property
     * is read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @param referencingConfigurationPolicies
     *            new value of {@code referencingConfigurationPolicies} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code referencingConfigurationPolicies} field changed
     */
    public DeviceManagementReusablePolicySetting withReferencingConfigurationPolicies(List<DeviceManagementConfigurationPolicy> referencingConfigurationPolicies) {
        DeviceManagementReusablePolicySetting _x = _copy();
        _x.changedFields = changedFields.add("referencingConfigurationPolicies");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementReusablePolicySetting");
        _x.referencingConfigurationPolicies = referencingConfigurationPolicies;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DeviceManagementReusablePolicySetting patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        DeviceManagementReusablePolicySetting _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DeviceManagementReusablePolicySetting put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        DeviceManagementReusablePolicySetting _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private DeviceManagementReusablePolicySetting _copy() {
        DeviceManagementReusablePolicySetting _x = new DeviceManagementReusablePolicySetting();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.createdDateTime = createdDateTime;
        _x.description = description;
        _x.displayName = displayName;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.referencingConfigurationPolicyCount = referencingConfigurationPolicyCount;
        _x.settingDefinitionId = settingDefinitionId;
        _x.settingInstance = settingInstance;
        _x.version = version;
        _x.referencingConfigurationPolicies = referencingConfigurationPolicies;
        return _x;
    }

    @Action(name = "clone")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<DeviceManagementReusablePolicySetting> clone() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestReturningNonCollectionUnwrapped<DeviceManagementReusablePolicySetting>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.clone"), DeviceManagementReusablePolicySetting.class, _parameters);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DeviceManagementReusablePolicySetting[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("referencingConfigurationPolicyCount=");
        b.append(this.referencingConfigurationPolicyCount);
        b.append(", ");
        b.append("settingDefinitionId=");
        b.append(this.settingDefinitionId);
        b.append(", ");
        b.append("settingInstance=");
        b.append(this.settingInstance);
        b.append(", ");
        b.append("version=");
        b.append(this.version);
        b.append(", ");
        b.append("referencingConfigurationPolicies=");
        b.append(this.referencingConfigurationPolicies);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
