package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import odata.msgraph.client.beta.complex.DeviceAndAppManagementAssignmentTarget;
import odata.msgraph.client.beta.enums.DeviceManagementResourceAccessProfileIntent;


/**
 * <i>“Entity that describes tenant level settings for derived credentials”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "intent", 
    "sourceId", 
    "target"})
@JsonInclude(Include.NON_NULL)
public class DeviceManagementResourceAccessProfileAssignment extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.deviceManagementResourceAccessProfileAssignment";
    }

    @JsonProperty("intent")
    protected DeviceManagementResourceAccessProfileIntent intent;

    @JsonProperty("sourceId")
    protected String sourceId;

    @JsonProperty("target")
    protected DeviceAndAppManagementAssignmentTarget target;

    protected DeviceManagementResourceAccessProfileAssignment() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderDeviceManagementResourceAccessProfileAssignment() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private DeviceManagementResourceAccessProfileIntent intent;
        private String sourceId;
        private DeviceAndAppManagementAssignmentTarget target;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“The assignment intent for the resource access profile.”</i>
         * 
         * @param intent
         *            value of {@code intent} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder intent(DeviceManagementResourceAccessProfileIntent intent) {
            this.intent = intent;
            this.changedFields = changedFields.add("intent");
            return this;
        }

        /**
         * <i>“The identifier of the source of the assignment.”</i>
         * 
         * @param sourceId
         *            value of {@code sourceId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder sourceId(String sourceId) {
            this.sourceId = sourceId;
            this.changedFields = changedFields.add("sourceId");
            return this;
        }

        /**
         * <i>“The assignment target for the resource access profile.”</i>
         * 
         * @param target
         *            value of {@code target} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder target(DeviceAndAppManagementAssignmentTarget target) {
            this.target = target;
            this.changedFields = changedFields.add("target");
            return this;
        }

        public DeviceManagementResourceAccessProfileAssignment build() {
            DeviceManagementResourceAccessProfileAssignment _x = new DeviceManagementResourceAccessProfileAssignment();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.deviceManagementResourceAccessProfileAssignment";
            _x.id = id;
            _x.intent = intent;
            _x.sourceId = sourceId;
            _x.target = target;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“The assignment intent for the resource access profile.”</i>
     * 
     * @return property intent
     */
    @Property(name="intent")
    @JsonIgnore
    public Optional<DeviceManagementResourceAccessProfileIntent> getIntent() {
        return Optional.ofNullable(intent);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code intent} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The assignment intent for the resource access profile.”</i>
     * 
     * @param intent
     *            new value of {@code intent} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code intent} field changed
     */
    public DeviceManagementResourceAccessProfileAssignment withIntent(DeviceManagementResourceAccessProfileIntent intent) {
        DeviceManagementResourceAccessProfileAssignment _x = _copy();
        _x.changedFields = changedFields.add("intent");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementResourceAccessProfileAssignment");
        _x.intent = intent;
        return _x;
    }

    /**
     * <i>“The identifier of the source of the assignment.”</i>
     * 
     * @return property sourceId
     */
    @Property(name="sourceId")
    @JsonIgnore
    public Optional<String> getSourceId() {
        return Optional.ofNullable(sourceId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code sourceId} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The identifier of the source of the assignment.”</i>
     * 
     * @param sourceId
     *            new value of {@code sourceId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code sourceId} field changed
     */
    public DeviceManagementResourceAccessProfileAssignment withSourceId(String sourceId) {
        DeviceManagementResourceAccessProfileAssignment _x = _copy();
        _x.changedFields = changedFields.add("sourceId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementResourceAccessProfileAssignment");
        _x.sourceId = sourceId;
        return _x;
    }

    /**
     * <i>“The assignment target for the resource access profile.”</i>
     * 
     * @return property target
     */
    @Property(name="target")
    @JsonIgnore
    public Optional<DeviceAndAppManagementAssignmentTarget> getTarget() {
        return Optional.ofNullable(target);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code target} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The assignment target for the resource access profile.”</i>
     * 
     * @param target
     *            new value of {@code target} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code target} field changed
     */
    public DeviceManagementResourceAccessProfileAssignment withTarget(DeviceAndAppManagementAssignmentTarget target) {
        DeviceManagementResourceAccessProfileAssignment _x = _copy();
        _x.changedFields = changedFields.add("target");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementResourceAccessProfileAssignment");
        _x.target = target;
        return _x;
    }

    public DeviceManagementResourceAccessProfileAssignment withUnmappedField(String name, Object value) {
        DeviceManagementResourceAccessProfileAssignment _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DeviceManagementResourceAccessProfileAssignment patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        DeviceManagementResourceAccessProfileAssignment _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DeviceManagementResourceAccessProfileAssignment put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        DeviceManagementResourceAccessProfileAssignment _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private DeviceManagementResourceAccessProfileAssignment _copy() {
        DeviceManagementResourceAccessProfileAssignment _x = new DeviceManagementResourceAccessProfileAssignment();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.intent = intent;
        _x.sourceId = sourceId;
        _x.target = target;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DeviceManagementResourceAccessProfileAssignment[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("intent=");
        b.append(this.intent);
        b.append(", ");
        b.append("sourceId=");
        b.append(this.sourceId);
        b.append(", ");
        b.append("target=");
        b.append(this.target);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
