package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.FunctionRequestReturningStream;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.lang.UnsupportedOperationException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.entity.collection.request.DeviceManagementCachedReportConfigurationCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DeviceManagementExportJobCollectionRequest;


/**
 * <i>“Singleton entity that acts as a container for all reports functionality.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "cachedReportConfigurations", 
    "exportJobs"})
@JsonInclude(Include.NON_NULL)
public class DeviceManagementReports extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.deviceManagementReports";
    }

    @JsonProperty("cachedReportConfigurations")
    protected List<DeviceManagementCachedReportConfiguration> cachedReportConfigurations;

    @JsonProperty("exportJobs")
    protected List<DeviceManagementExportJob> exportJobs;

    protected DeviceManagementReports() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderDeviceManagementReports() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private List<DeviceManagementCachedReportConfiguration> cachedReportConfigurations;
        private List<DeviceManagementExportJob> exportJobs;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“Entity representing the configuration of a cached report”</i>
         * 
         * @param cachedReportConfigurations
         *            value of {@code cachedReportConfigurations} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder cachedReportConfigurations(List<DeviceManagementCachedReportConfiguration> cachedReportConfigurations) {
            this.cachedReportConfigurations = cachedReportConfigurations;
            this.changedFields = changedFields.add("cachedReportConfigurations");
            return this;
        }

        /**
         * <i>“Entity representing the configuration of a cached report”</i>
         * 
         * @param cachedReportConfigurations
         *            value of {@code cachedReportConfigurations} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder cachedReportConfigurations(DeviceManagementCachedReportConfiguration... cachedReportConfigurations) {
            return cachedReportConfigurations(Arrays.asList(cachedReportConfigurations));
        }

        /**
         * <i>“Entity representing a job to export a report”</i>
         * 
         * @param exportJobs
         *            value of {@code exportJobs} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder exportJobs(List<DeviceManagementExportJob> exportJobs) {
            this.exportJobs = exportJobs;
            this.changedFields = changedFields.add("exportJobs");
            return this;
        }

        /**
         * <i>“Entity representing a job to export a report”</i>
         * 
         * @param exportJobs
         *            value of {@code exportJobs} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder exportJobs(DeviceManagementExportJob... exportJobs) {
            return exportJobs(Arrays.asList(exportJobs));
        }

        public DeviceManagementReports build() {
            DeviceManagementReports _x = new DeviceManagementReports();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.deviceManagementReports";
            _x.id = id;
            _x.cachedReportConfigurations = cachedReportConfigurations;
            _x.exportJobs = exportJobs;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    public DeviceManagementReports withUnmappedField(String name, Object value) {
        DeviceManagementReports _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    /**
     * <i>“Entity representing the configuration of a cached report”</i>
     * 
     * @return navigational property cachedReportConfigurations
     */
    @NavigationProperty(name="cachedReportConfigurations")
    @JsonIgnore
    public DeviceManagementCachedReportConfigurationCollectionRequest getCachedReportConfigurations() {
        return new DeviceManagementCachedReportConfigurationCollectionRequest(
                        contextPath.addSegment("cachedReportConfigurations"), Optional.ofNullable(cachedReportConfigurations));
    }

    /**
     * <i>“Entity representing a job to export a report”</i>
     * 
     * @return navigational property exportJobs
     */
    @NavigationProperty(name="exportJobs")
    @JsonIgnore
    public DeviceManagementExportJobCollectionRequest getExportJobs() {
        return new DeviceManagementExportJobCollectionRequest(
                        contextPath.addSegment("exportJobs"), Optional.ofNullable(exportJobs));
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * cachedReportConfigurations} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Entity representing the configuration of a cached report”</i>
     * 
     * @param cachedReportConfigurations
     *            new value of {@code cachedReportConfigurations} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code cachedReportConfigurations} field changed
     */
    public DeviceManagementReports withCachedReportConfigurations(List<DeviceManagementCachedReportConfiguration> cachedReportConfigurations) {
        DeviceManagementReports _x = _copy();
        _x.changedFields = changedFields.add("cachedReportConfigurations");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementReports");
        _x.cachedReportConfigurations = cachedReportConfigurations;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code exportJobs} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Entity representing a job to export a report”</i>
     * 
     * @param exportJobs
     *            new value of {@code exportJobs} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code exportJobs} field changed
     */
    public DeviceManagementReports withExportJobs(List<DeviceManagementExportJob> exportJobs) {
        DeviceManagementReports _x = _copy();
        _x.changedFields = changedFields.add("exportJobs");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementReports");
        _x.exportJobs = exportJobs;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DeviceManagementReports patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        DeviceManagementReports _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DeviceManagementReports put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        DeviceManagementReports _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private DeviceManagementReports _copy() {
        DeviceManagementReports _x = new DeviceManagementReports();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.cachedReportConfigurations = cachedReportConfigurations;
        _x.exportJobs = exportJobs;
        return _x;
    }

    @Action(name = "getAppsInstallSummaryReport")
    @JsonIgnore
    public FunctionRequestReturningStream getAppsInstallSummaryReport(String name, List<String> select, String search, List<String> groupBy, List<String> orderBy, Integer skip, Integer top, String sessionId, String filter) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("name", "Edm.String", Checks.checkIsAscii(name))
            .put("select", "Collection(Edm.String)", Checks.checkIsAscii(select))
            .put("search", "Edm.String", Checks.checkIsAscii(search))
            .put("groupBy", "Collection(Edm.String)", Checks.checkIsAscii(groupBy))
            .put("orderBy", "Collection(Edm.String)", Checks.checkIsAscii(orderBy))
            .put("skip", "Edm.Int32", skip)
            .put("top", "Edm.Int32", top)
            .put("sessionId", "Edm.String", Checks.checkIsAscii(sessionId))
            .put("filter", "Edm.String", Checks.checkIsAscii(filter))
            .build();
        throw new UnsupportedOperationException("Actions that return a stream are not supported yet. If you want this raise an issue at the project home");
    }

    @Action(name = "getAppStatusOverviewReport")
    @JsonIgnore
    public FunctionRequestReturningStream getAppStatusOverviewReport(String name, List<String> select, String search, List<String> groupBy, List<String> orderBy, Integer skip, Integer top, String sessionId, String filter) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("name", "Edm.String", Checks.checkIsAscii(name))
            .put("select", "Collection(Edm.String)", Checks.checkIsAscii(select))
            .put("search", "Edm.String", Checks.checkIsAscii(search))
            .put("groupBy", "Collection(Edm.String)", Checks.checkIsAscii(groupBy))
            .put("orderBy", "Collection(Edm.String)", Checks.checkIsAscii(orderBy))
            .put("skip", "Edm.Int32", skip)
            .put("top", "Edm.Int32", top)
            .put("sessionId", "Edm.String", Checks.checkIsAscii(sessionId))
            .put("filter", "Edm.String", Checks.checkIsAscii(filter))
            .build();
        throw new UnsupportedOperationException("Actions that return a stream are not supported yet. If you want this raise an issue at the project home");
    }

    @Action(name = "getDeviceInstallStatusReport")
    @JsonIgnore
    public FunctionRequestReturningStream getDeviceInstallStatusReport(String name, List<String> select, String search, List<String> groupBy, List<String> orderBy, Integer skip, Integer top, String sessionId, String filter) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("name", "Edm.String", Checks.checkIsAscii(name))
            .put("select", "Collection(Edm.String)", Checks.checkIsAscii(select))
            .put("search", "Edm.String", Checks.checkIsAscii(search))
            .put("groupBy", "Collection(Edm.String)", Checks.checkIsAscii(groupBy))
            .put("orderBy", "Collection(Edm.String)", Checks.checkIsAscii(orderBy))
            .put("skip", "Edm.Int32", skip)
            .put("top", "Edm.Int32", top)
            .put("sessionId", "Edm.String", Checks.checkIsAscii(sessionId))
            .put("filter", "Edm.String", Checks.checkIsAscii(filter))
            .build();
        throw new UnsupportedOperationException("Actions that return a stream are not supported yet. If you want this raise an issue at the project home");
    }

    @Action(name = "getFailedMobileAppsReport")
    @JsonIgnore
    public FunctionRequestReturningStream getFailedMobileAppsReport(String name, List<String> select, String search, List<String> groupBy, List<String> orderBy, Integer skip, Integer top, String sessionId, String filter) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("name", "Edm.String", Checks.checkIsAscii(name))
            .put("select", "Collection(Edm.String)", Checks.checkIsAscii(select))
            .put("search", "Edm.String", Checks.checkIsAscii(search))
            .put("groupBy", "Collection(Edm.String)", Checks.checkIsAscii(groupBy))
            .put("orderBy", "Collection(Edm.String)", Checks.checkIsAscii(orderBy))
            .put("skip", "Edm.Int32", skip)
            .put("top", "Edm.Int32", top)
            .put("sessionId", "Edm.String", Checks.checkIsAscii(sessionId))
            .put("filter", "Edm.String", Checks.checkIsAscii(filter))
            .build();
        throw new UnsupportedOperationException("Actions that return a stream are not supported yet. If you want this raise an issue at the project home");
    }

    @Action(name = "getFailedMobileAppsSummaryReport")
    @JsonIgnore
    public FunctionRequestReturningStream getFailedMobileAppsSummaryReport(String name, List<String> select, String search, List<String> groupBy, List<String> orderBy, Integer skip, Integer top, String sessionId, String filter) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("name", "Edm.String", Checks.checkIsAscii(name))
            .put("select", "Collection(Edm.String)", Checks.checkIsAscii(select))
            .put("search", "Edm.String", Checks.checkIsAscii(search))
            .put("groupBy", "Collection(Edm.String)", Checks.checkIsAscii(groupBy))
            .put("orderBy", "Collection(Edm.String)", Checks.checkIsAscii(orderBy))
            .put("skip", "Edm.Int32", skip)
            .put("top", "Edm.Int32", top)
            .put("sessionId", "Edm.String", Checks.checkIsAscii(sessionId))
            .put("filter", "Edm.String", Checks.checkIsAscii(filter))
            .build();
        throw new UnsupportedOperationException("Actions that return a stream are not supported yet. If you want this raise an issue at the project home");
    }

    @Action(name = "getRelatedAppsStatusReport")
    @JsonIgnore
    public FunctionRequestReturningStream getRelatedAppsStatusReport(String name, List<String> select, String search, List<String> groupBy, List<String> orderBy, Integer skip, Integer top, String sessionId, String filter) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("name", "Edm.String", Checks.checkIsAscii(name))
            .put("select", "Collection(Edm.String)", Checks.checkIsAscii(select))
            .put("search", "Edm.String", Checks.checkIsAscii(search))
            .put("groupBy", "Collection(Edm.String)", Checks.checkIsAscii(groupBy))
            .put("orderBy", "Collection(Edm.String)", Checks.checkIsAscii(orderBy))
            .put("skip", "Edm.Int32", skip)
            .put("top", "Edm.Int32", top)
            .put("sessionId", "Edm.String", Checks.checkIsAscii(sessionId))
            .put("filter", "Edm.String", Checks.checkIsAscii(filter))
            .build();
        throw new UnsupportedOperationException("Actions that return a stream are not supported yet. If you want this raise an issue at the project home");
    }

    @Action(name = "getUserInstallStatusReport")
    @JsonIgnore
    public FunctionRequestReturningStream getUserInstallStatusReport(String name, List<String> select, String search, List<String> groupBy, List<String> orderBy, Integer skip, Integer top, String sessionId, String filter) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("name", "Edm.String", Checks.checkIsAscii(name))
            .put("select", "Collection(Edm.String)", Checks.checkIsAscii(select))
            .put("search", "Edm.String", Checks.checkIsAscii(search))
            .put("groupBy", "Collection(Edm.String)", Checks.checkIsAscii(groupBy))
            .put("orderBy", "Collection(Edm.String)", Checks.checkIsAscii(orderBy))
            .put("skip", "Edm.Int32", skip)
            .put("top", "Edm.Int32", top)
            .put("sessionId", "Edm.String", Checks.checkIsAscii(sessionId))
            .put("filter", "Edm.String", Checks.checkIsAscii(filter))
            .build();
        throw new UnsupportedOperationException("Actions that return a stream are not supported yet. If you want this raise an issue at the project home");
    }

    @Action(name = "getCompliancePoliciesReportForDevice")
    @JsonIgnore
    public FunctionRequestReturningStream getCompliancePoliciesReportForDevice(String name, List<String> select, String search, List<String> groupBy, List<String> orderBy, Integer skip, Integer top, String sessionId, String filter) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("name", "Edm.String", Checks.checkIsAscii(name))
            .put("select", "Collection(Edm.String)", Checks.checkIsAscii(select))
            .put("search", "Edm.String", Checks.checkIsAscii(search))
            .put("groupBy", "Collection(Edm.String)", Checks.checkIsAscii(groupBy))
            .put("orderBy", "Collection(Edm.String)", Checks.checkIsAscii(orderBy))
            .put("skip", "Edm.Int32", skip)
            .put("top", "Edm.Int32", top)
            .put("sessionId", "Edm.String", Checks.checkIsAscii(sessionId))
            .put("filter", "Edm.String", Checks.checkIsAscii(filter))
            .build();
        throw new UnsupportedOperationException("Actions that return a stream are not supported yet. If you want this raise an issue at the project home");
    }

    @Action(name = "getCompliancePolicyDevicesReport")
    @JsonIgnore
    public FunctionRequestReturningStream getCompliancePolicyDevicesReport(String name, List<String> select, String search, List<String> groupBy, List<String> orderBy, Integer skip, Integer top, String sessionId, String filter) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("name", "Edm.String", Checks.checkIsAscii(name))
            .put("select", "Collection(Edm.String)", Checks.checkIsAscii(select))
            .put("search", "Edm.String", Checks.checkIsAscii(search))
            .put("groupBy", "Collection(Edm.String)", Checks.checkIsAscii(groupBy))
            .put("orderBy", "Collection(Edm.String)", Checks.checkIsAscii(orderBy))
            .put("skip", "Edm.Int32", skip)
            .put("top", "Edm.Int32", top)
            .put("sessionId", "Edm.String", Checks.checkIsAscii(sessionId))
            .put("filter", "Edm.String", Checks.checkIsAscii(filter))
            .build();
        throw new UnsupportedOperationException("Actions that return a stream are not supported yet. If you want this raise an issue at the project home");
    }

    @Action(name = "getCompliancePolicyDeviceSummaryReport")
    @JsonIgnore
    public FunctionRequestReturningStream getCompliancePolicyDeviceSummaryReport(String name, List<String> select, String search, List<String> groupBy, List<String> orderBy, Integer skip, Integer top, String sessionId, String filter) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("name", "Edm.String", Checks.checkIsAscii(name))
            .put("select", "Collection(Edm.String)", Checks.checkIsAscii(select))
            .put("search", "Edm.String", Checks.checkIsAscii(search))
            .put("groupBy", "Collection(Edm.String)", Checks.checkIsAscii(groupBy))
            .put("orderBy", "Collection(Edm.String)", Checks.checkIsAscii(orderBy))
            .put("skip", "Edm.Int32", skip)
            .put("top", "Edm.Int32", top)
            .put("sessionId", "Edm.String", Checks.checkIsAscii(sessionId))
            .put("filter", "Edm.String", Checks.checkIsAscii(filter))
            .build();
        throw new UnsupportedOperationException("Actions that return a stream are not supported yet. If you want this raise an issue at the project home");
    }

    @Action(name = "getComplianceSettingDetailsReport")
    @JsonIgnore
    public FunctionRequestReturningStream getComplianceSettingDetailsReport(String name, List<String> select, String search, List<String> groupBy, List<String> orderBy, Integer skip, Integer top, String sessionId, String filter) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("name", "Edm.String", Checks.checkIsAscii(name))
            .put("select", "Collection(Edm.String)", Checks.checkIsAscii(select))
            .put("search", "Edm.String", Checks.checkIsAscii(search))
            .put("groupBy", "Collection(Edm.String)", Checks.checkIsAscii(groupBy))
            .put("orderBy", "Collection(Edm.String)", Checks.checkIsAscii(orderBy))
            .put("skip", "Edm.Int32", skip)
            .put("top", "Edm.Int32", top)
            .put("sessionId", "Edm.String", Checks.checkIsAscii(sessionId))
            .put("filter", "Edm.String", Checks.checkIsAscii(filter))
            .build();
        throw new UnsupportedOperationException("Actions that return a stream are not supported yet. If you want this raise an issue at the project home");
    }

    @Action(name = "getComplianceSettingsReport")
    @JsonIgnore
    public FunctionRequestReturningStream getComplianceSettingsReport(String name, List<String> select, String search, List<String> groupBy, List<String> orderBy, Integer skip, Integer top, String sessionId, String filter) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("name", "Edm.String", Checks.checkIsAscii(name))
            .put("select", "Collection(Edm.String)", Checks.checkIsAscii(select))
            .put("search", "Edm.String", Checks.checkIsAscii(search))
            .put("groupBy", "Collection(Edm.String)", Checks.checkIsAscii(groupBy))
            .put("orderBy", "Collection(Edm.String)", Checks.checkIsAscii(orderBy))
            .put("skip", "Edm.Int32", skip)
            .put("top", "Edm.Int32", top)
            .put("sessionId", "Edm.String", Checks.checkIsAscii(sessionId))
            .put("filter", "Edm.String", Checks.checkIsAscii(filter))
            .build();
        throw new UnsupportedOperationException("Actions that return a stream are not supported yet. If you want this raise an issue at the project home");
    }

    @Action(name = "getConfigurationPoliciesReportForDevice")
    @JsonIgnore
    public FunctionRequestReturningStream getConfigurationPoliciesReportForDevice(String name, List<String> select, String search, List<String> groupBy, List<String> orderBy, Integer skip, Integer top, String sessionId, String filter) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("name", "Edm.String", Checks.checkIsAscii(name))
            .put("select", "Collection(Edm.String)", Checks.checkIsAscii(select))
            .put("search", "Edm.String", Checks.checkIsAscii(search))
            .put("groupBy", "Collection(Edm.String)", Checks.checkIsAscii(groupBy))
            .put("orderBy", "Collection(Edm.String)", Checks.checkIsAscii(orderBy))
            .put("skip", "Edm.Int32", skip)
            .put("top", "Edm.Int32", top)
            .put("sessionId", "Edm.String", Checks.checkIsAscii(sessionId))
            .put("filter", "Edm.String", Checks.checkIsAscii(filter))
            .build();
        throw new UnsupportedOperationException("Actions that return a stream are not supported yet. If you want this raise an issue at the project home");
    }

    @Action(name = "getConfigurationPolicyDevicesReport")
    @JsonIgnore
    public FunctionRequestReturningStream getConfigurationPolicyDevicesReport(String name, List<String> select, String search, List<String> groupBy, List<String> orderBy, Integer skip, Integer top, String sessionId, String filter) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("name", "Edm.String", Checks.checkIsAscii(name))
            .put("select", "Collection(Edm.String)", Checks.checkIsAscii(select))
            .put("search", "Edm.String", Checks.checkIsAscii(search))
            .put("groupBy", "Collection(Edm.String)", Checks.checkIsAscii(groupBy))
            .put("orderBy", "Collection(Edm.String)", Checks.checkIsAscii(orderBy))
            .put("skip", "Edm.Int32", skip)
            .put("top", "Edm.Int32", top)
            .put("sessionId", "Edm.String", Checks.checkIsAscii(sessionId))
            .put("filter", "Edm.String", Checks.checkIsAscii(filter))
            .build();
        throw new UnsupportedOperationException("Actions that return a stream are not supported yet. If you want this raise an issue at the project home");
    }

    @Action(name = "getConfigurationPolicyDeviceSummaryReport")
    @JsonIgnore
    public FunctionRequestReturningStream getConfigurationPolicyDeviceSummaryReport(String name, List<String> select, String search, List<String> groupBy, List<String> orderBy, Integer skip, Integer top, String sessionId, String filter) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("name", "Edm.String", Checks.checkIsAscii(name))
            .put("select", "Collection(Edm.String)", Checks.checkIsAscii(select))
            .put("search", "Edm.String", Checks.checkIsAscii(search))
            .put("groupBy", "Collection(Edm.String)", Checks.checkIsAscii(groupBy))
            .put("orderBy", "Collection(Edm.String)", Checks.checkIsAscii(orderBy))
            .put("skip", "Edm.Int32", skip)
            .put("top", "Edm.Int32", top)
            .put("sessionId", "Edm.String", Checks.checkIsAscii(sessionId))
            .put("filter", "Edm.String", Checks.checkIsAscii(filter))
            .build();
        throw new UnsupportedOperationException("Actions that return a stream are not supported yet. If you want this raise an issue at the project home");
    }

    @Action(name = "getConfigurationPolicySettingsDeviceSummaryReport")
    @JsonIgnore
    public FunctionRequestReturningStream getConfigurationPolicySettingsDeviceSummaryReport(String name, List<String> select, String search, List<String> groupBy, List<String> orderBy, Integer skip, Integer top, String sessionId, String filter) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("name", "Edm.String", Checks.checkIsAscii(name))
            .put("select", "Collection(Edm.String)", Checks.checkIsAscii(select))
            .put("search", "Edm.String", Checks.checkIsAscii(search))
            .put("groupBy", "Collection(Edm.String)", Checks.checkIsAscii(groupBy))
            .put("orderBy", "Collection(Edm.String)", Checks.checkIsAscii(orderBy))
            .put("skip", "Edm.Int32", skip)
            .put("top", "Edm.Int32", top)
            .put("sessionId", "Edm.String", Checks.checkIsAscii(sessionId))
            .put("filter", "Edm.String", Checks.checkIsAscii(filter))
            .build();
        throw new UnsupportedOperationException("Actions that return a stream are not supported yet. If you want this raise an issue at the project home");
    }

    @Action(name = "getConfigurationSettingDetailsReport")
    @JsonIgnore
    public FunctionRequestReturningStream getConfigurationSettingDetailsReport(String name, List<String> select, String search, List<String> groupBy, List<String> orderBy, Integer skip, Integer top, String sessionId, String filter) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("name", "Edm.String", Checks.checkIsAscii(name))
            .put("select", "Collection(Edm.String)", Checks.checkIsAscii(select))
            .put("search", "Edm.String", Checks.checkIsAscii(search))
            .put("groupBy", "Collection(Edm.String)", Checks.checkIsAscii(groupBy))
            .put("orderBy", "Collection(Edm.String)", Checks.checkIsAscii(orderBy))
            .put("skip", "Edm.Int32", skip)
            .put("top", "Edm.Int32", top)
            .put("sessionId", "Edm.String", Checks.checkIsAscii(sessionId))
            .put("filter", "Edm.String", Checks.checkIsAscii(filter))
            .build();
        throw new UnsupportedOperationException("Actions that return a stream are not supported yet. If you want this raise an issue at the project home");
    }

    @Action(name = "getConfigurationSettingsReport")
    @JsonIgnore
    public FunctionRequestReturningStream getConfigurationSettingsReport(String name, List<String> select, String search, List<String> groupBy, List<String> orderBy, Integer skip, Integer top, String sessionId, String filter) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("name", "Edm.String", Checks.checkIsAscii(name))
            .put("select", "Collection(Edm.String)", Checks.checkIsAscii(select))
            .put("search", "Edm.String", Checks.checkIsAscii(search))
            .put("groupBy", "Collection(Edm.String)", Checks.checkIsAscii(groupBy))
            .put("orderBy", "Collection(Edm.String)", Checks.checkIsAscii(orderBy))
            .put("skip", "Edm.Int32", skip)
            .put("top", "Edm.Int32", top)
            .put("sessionId", "Edm.String", Checks.checkIsAscii(sessionId))
            .put("filter", "Edm.String", Checks.checkIsAscii(filter))
            .build();
        throw new UnsupportedOperationException("Actions that return a stream are not supported yet. If you want this raise an issue at the project home");
    }

    @Action(name = "getDeviceConfigurationPolicySettingsSummaryReport")
    @JsonIgnore
    public FunctionRequestReturningStream getDeviceConfigurationPolicySettingsSummaryReport(String name, List<String> select, String search, List<String> groupBy, List<String> orderBy, Integer skip, Integer top, String sessionId, String filter) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("name", "Edm.String", Checks.checkIsAscii(name))
            .put("select", "Collection(Edm.String)", Checks.checkIsAscii(select))
            .put("search", "Edm.String", Checks.checkIsAscii(search))
            .put("groupBy", "Collection(Edm.String)", Checks.checkIsAscii(groupBy))
            .put("orderBy", "Collection(Edm.String)", Checks.checkIsAscii(orderBy))
            .put("skip", "Edm.Int32", skip)
            .put("top", "Edm.Int32", top)
            .put("sessionId", "Edm.String", Checks.checkIsAscii(sessionId))
            .put("filter", "Edm.String", Checks.checkIsAscii(filter))
            .build();
        throw new UnsupportedOperationException("Actions that return a stream are not supported yet. If you want this raise an issue at the project home");
    }

    @Action(name = "getDeviceConfigurationPolicyStatusSummary")
    @JsonIgnore
    public FunctionRequestReturningStream getDeviceConfigurationPolicyStatusSummary(String name, List<String> select, String search, List<String> groupBy, List<String> orderBy, Integer skip, Integer top, String sessionId, String filter) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("name", "Edm.String", Checks.checkIsAscii(name))
            .put("select", "Collection(Edm.String)", Checks.checkIsAscii(select))
            .put("search", "Edm.String", Checks.checkIsAscii(search))
            .put("groupBy", "Collection(Edm.String)", Checks.checkIsAscii(groupBy))
            .put("orderBy", "Collection(Edm.String)", Checks.checkIsAscii(orderBy))
            .put("skip", "Edm.Int32", skip)
            .put("top", "Edm.Int32", top)
            .put("sessionId", "Edm.String", Checks.checkIsAscii(sessionId))
            .put("filter", "Edm.String", Checks.checkIsAscii(filter))
            .build();
        throw new UnsupportedOperationException("Actions that return a stream are not supported yet. If you want this raise an issue at the project home");
    }

    @Action(name = "getQuietTimePolicyUsersReport")
    @JsonIgnore
    public FunctionRequestReturningStream getQuietTimePolicyUsersReport(String name, List<String> select, String search, List<String> groupBy, List<String> orderBy, Integer skip, Integer top, String sessionId, String filter, String skipToken) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("name", "Edm.String", Checks.checkIsAscii(name))
            .put("select", "Collection(Edm.String)", Checks.checkIsAscii(select))
            .put("search", "Edm.String", Checks.checkIsAscii(search))
            .put("groupBy", "Collection(Edm.String)", Checks.checkIsAscii(groupBy))
            .put("orderBy", "Collection(Edm.String)", Checks.checkIsAscii(orderBy))
            .put("skip", "Edm.Int32", skip)
            .put("top", "Edm.Int32", top)
            .put("sessionId", "Edm.String", Checks.checkIsAscii(sessionId))
            .put("filter", "Edm.String", Checks.checkIsAscii(filter))
            .put("skipToken", "Edm.String", Checks.checkIsAscii(skipToken))
            .build();
        throw new UnsupportedOperationException("Actions that return a stream are not supported yet. If you want this raise an issue at the project home");
    }

    @Action(name = "getQuietTimePolicyUserSummaryReport")
    @JsonIgnore
    public FunctionRequestReturningStream getQuietTimePolicyUserSummaryReport(String name, List<String> select, String search, List<String> groupBy, List<String> orderBy, Integer skip, Integer top, String sessionId, String filter) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("name", "Edm.String", Checks.checkIsAscii(name))
            .put("select", "Collection(Edm.String)", Checks.checkIsAscii(select))
            .put("search", "Edm.String", Checks.checkIsAscii(search))
            .put("groupBy", "Collection(Edm.String)", Checks.checkIsAscii(groupBy))
            .put("orderBy", "Collection(Edm.String)", Checks.checkIsAscii(orderBy))
            .put("skip", "Edm.Int32", skip)
            .put("top", "Edm.Int32", top)
            .put("sessionId", "Edm.String", Checks.checkIsAscii(sessionId))
            .put("filter", "Edm.String", Checks.checkIsAscii(filter))
            .build();
        throw new UnsupportedOperationException("Actions that return a stream are not supported yet. If you want this raise an issue at the project home");
    }

    @Action(name = "getEnrollmentConfigurationPoliciesByDevice")
    @JsonIgnore
    public FunctionRequestReturningStream getEnrollmentConfigurationPoliciesByDevice(String name, List<String> select, String search, List<String> groupBy, List<String> orderBy, Integer skip, Integer top, String filter) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("name", "Edm.String", Checks.checkIsAscii(name))
            .put("select", "Collection(Edm.String)", Checks.checkIsAscii(select))
            .put("search", "Edm.String", Checks.checkIsAscii(search))
            .put("groupBy", "Collection(Edm.String)", Checks.checkIsAscii(groupBy))
            .put("orderBy", "Collection(Edm.String)", Checks.checkIsAscii(orderBy))
            .put("skip", "Edm.Int32", skip)
            .put("top", "Edm.Int32", top)
            .put("filter", "Edm.String", Checks.checkIsAscii(filter))
            .build();
        throw new UnsupportedOperationException("Actions that return a stream are not supported yet. If you want this raise an issue at the project home");
    }

    @Action(name = "getActiveMalwareReport")
    @JsonIgnore
    public FunctionRequestReturningStream getActiveMalwareReport(String name, List<String> select, String search, List<String> groupBy, List<String> orderBy, Integer skip, Integer top, String sessionId, String filter) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("name", "Edm.String", Checks.checkIsAscii(name))
            .put("select", "Collection(Edm.String)", Checks.checkIsAscii(select))
            .put("search", "Edm.String", Checks.checkIsAscii(search))
            .put("groupBy", "Collection(Edm.String)", Checks.checkIsAscii(groupBy))
            .put("orderBy", "Collection(Edm.String)", Checks.checkIsAscii(orderBy))
            .put("skip", "Edm.Int32", skip)
            .put("top", "Edm.Int32", top)
            .put("sessionId", "Edm.String", Checks.checkIsAscii(sessionId))
            .put("filter", "Edm.String", Checks.checkIsAscii(filter))
            .build();
        throw new UnsupportedOperationException("Actions that return a stream are not supported yet. If you want this raise an issue at the project home");
    }

    @Action(name = "getActiveMalwareSummaryReport")
    @JsonIgnore
    public FunctionRequestReturningStream getActiveMalwareSummaryReport(String name, List<String> select, String search, List<String> groupBy, List<String> orderBy, Integer skip, Integer top, String sessionId, String filter) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("name", "Edm.String", Checks.checkIsAscii(name))
            .put("select", "Collection(Edm.String)", Checks.checkIsAscii(select))
            .put("search", "Edm.String", Checks.checkIsAscii(search))
            .put("groupBy", "Collection(Edm.String)", Checks.checkIsAscii(groupBy))
            .put("orderBy", "Collection(Edm.String)", Checks.checkIsAscii(orderBy))
            .put("skip", "Edm.Int32", skip)
            .put("top", "Edm.Int32", top)
            .put("sessionId", "Edm.String", Checks.checkIsAscii(sessionId))
            .put("filter", "Edm.String", Checks.checkIsAscii(filter))
            .build();
        throw new UnsupportedOperationException("Actions that return a stream are not supported yet. If you want this raise an issue at the project home");
    }

    @Action(name = "getMalwareSummaryReport")
    @JsonIgnore
    public FunctionRequestReturningStream getMalwareSummaryReport(String name, List<String> select, String search, List<String> groupBy, List<String> orderBy, Integer skip, Integer top, String sessionId, String filter) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("name", "Edm.String", Checks.checkIsAscii(name))
            .put("select", "Collection(Edm.String)", Checks.checkIsAscii(select))
            .put("search", "Edm.String", Checks.checkIsAscii(search))
            .put("groupBy", "Collection(Edm.String)", Checks.checkIsAscii(groupBy))
            .put("orderBy", "Collection(Edm.String)", Checks.checkIsAscii(orderBy))
            .put("skip", "Edm.Int32", skip)
            .put("top", "Edm.Int32", top)
            .put("sessionId", "Edm.String", Checks.checkIsAscii(sessionId))
            .put("filter", "Edm.String", Checks.checkIsAscii(filter))
            .build();
        throw new UnsupportedOperationException("Actions that return a stream are not supported yet. If you want this raise an issue at the project home");
    }

    @Action(name = "getUnhealthyDefenderAgentsReport")
    @JsonIgnore
    public FunctionRequestReturningStream getUnhealthyDefenderAgentsReport(String name, List<String> select, String search, List<String> groupBy, List<String> orderBy, Integer skip, Integer top, String sessionId, String filter) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("name", "Edm.String", Checks.checkIsAscii(name))
            .put("select", "Collection(Edm.String)", Checks.checkIsAscii(select))
            .put("search", "Edm.String", Checks.checkIsAscii(search))
            .put("groupBy", "Collection(Edm.String)", Checks.checkIsAscii(groupBy))
            .put("orderBy", "Collection(Edm.String)", Checks.checkIsAscii(orderBy))
            .put("skip", "Edm.Int32", skip)
            .put("top", "Edm.Int32", top)
            .put("sessionId", "Edm.String", Checks.checkIsAscii(sessionId))
            .put("filter", "Edm.String", Checks.checkIsAscii(filter))
            .build();
        throw new UnsupportedOperationException("Actions that return a stream are not supported yet. If you want this raise an issue at the project home");
    }

    @Action(name = "getUnhealthyFirewallReport")
    @JsonIgnore
    public FunctionRequestReturningStream getUnhealthyFirewallReport(String name, List<String> select, String search, List<String> groupBy, List<String> orderBy, Integer skip, Integer top, String sessionId, String filter) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("name", "Edm.String", Checks.checkIsAscii(name))
            .put("select", "Collection(Edm.String)", Checks.checkIsAscii(select))
            .put("search", "Edm.String", Checks.checkIsAscii(search))
            .put("groupBy", "Collection(Edm.String)", Checks.checkIsAscii(groupBy))
            .put("orderBy", "Collection(Edm.String)", Checks.checkIsAscii(orderBy))
            .put("skip", "Edm.Int32", skip)
            .put("top", "Edm.Int32", top)
            .put("sessionId", "Edm.String", Checks.checkIsAscii(sessionId))
            .put("filter", "Edm.String", Checks.checkIsAscii(filter))
            .build();
        throw new UnsupportedOperationException("Actions that return a stream are not supported yet. If you want this raise an issue at the project home");
    }

    @Action(name = "getUnhealthyFirewallSummaryReport")
    @JsonIgnore
    public FunctionRequestReturningStream getUnhealthyFirewallSummaryReport(String name, List<String> select, String search, List<String> groupBy, List<String> orderBy, Integer skip, Integer top, String sessionId, String filter) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("name", "Edm.String", Checks.checkIsAscii(name))
            .put("select", "Collection(Edm.String)", Checks.checkIsAscii(select))
            .put("search", "Edm.String", Checks.checkIsAscii(search))
            .put("groupBy", "Collection(Edm.String)", Checks.checkIsAscii(groupBy))
            .put("orderBy", "Collection(Edm.String)", Checks.checkIsAscii(orderBy))
            .put("skip", "Edm.Int32", skip)
            .put("top", "Edm.Int32", top)
            .put("sessionId", "Edm.String", Checks.checkIsAscii(sessionId))
            .put("filter", "Edm.String", Checks.checkIsAscii(filter))
            .build();
        throw new UnsupportedOperationException("Actions that return a stream are not supported yet. If you want this raise an issue at the project home");
    }

    @Action(name = "getAllCertificatesReport")
    @JsonIgnore
    public FunctionRequestReturningStream getAllCertificatesReport(String name, List<String> select, String search, List<String> groupBy, List<String> orderBy, Integer skip, Integer top, String sessionId, String filter) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("name", "Edm.String", Checks.checkIsAscii(name))
            .put("select", "Collection(Edm.String)", Checks.checkIsAscii(select))
            .put("search", "Edm.String", Checks.checkIsAscii(search))
            .put("groupBy", "Collection(Edm.String)", Checks.checkIsAscii(groupBy))
            .put("orderBy", "Collection(Edm.String)", Checks.checkIsAscii(orderBy))
            .put("skip", "Edm.Int32", skip)
            .put("top", "Edm.Int32", top)
            .put("sessionId", "Edm.String", Checks.checkIsAscii(sessionId))
            .put("filter", "Edm.String", Checks.checkIsAscii(filter))
            .build();
        throw new UnsupportedOperationException("Actions that return a stream are not supported yet. If you want this raise an issue at the project home");
    }

    @Action(name = "getCertificatesReport")
    @JsonIgnore
    public FunctionRequestReturningStream getCertificatesReport(String name, List<String> select, String search, List<String> groupBy, List<String> orderBy, Integer skip, Integer top, String sessionId, String filter) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("name", "Edm.String", Checks.checkIsAscii(name))
            .put("select", "Collection(Edm.String)", Checks.checkIsAscii(select))
            .put("search", "Edm.String", Checks.checkIsAscii(search))
            .put("groupBy", "Collection(Edm.String)", Checks.checkIsAscii(groupBy))
            .put("orderBy", "Collection(Edm.String)", Checks.checkIsAscii(orderBy))
            .put("skip", "Edm.Int32", skip)
            .put("top", "Edm.Int32", top)
            .put("sessionId", "Edm.String", Checks.checkIsAscii(sessionId))
            .put("filter", "Edm.String", Checks.checkIsAscii(filter))
            .build();
        throw new UnsupportedOperationException("Actions that return a stream are not supported yet. If you want this raise an issue at the project home");
    }

    @Action(name = "getGroupPolicySettingsDeviceSettingsReport")
    @JsonIgnore
    public FunctionRequestReturningStream getGroupPolicySettingsDeviceSettingsReport(String name, List<String> select, String search, List<String> groupBy, List<String> orderBy, Integer skip, Integer top, String sessionId, String filter) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("name", "Edm.String", Checks.checkIsAscii(name))
            .put("select", "Collection(Edm.String)", Checks.checkIsAscii(select))
            .put("search", "Edm.String", Checks.checkIsAscii(search))
            .put("groupBy", "Collection(Edm.String)", Checks.checkIsAscii(groupBy))
            .put("orderBy", "Collection(Edm.String)", Checks.checkIsAscii(orderBy))
            .put("skip", "Edm.Int32", skip)
            .put("top", "Edm.Int32", top)
            .put("sessionId", "Edm.String", Checks.checkIsAscii(sessionId))
            .put("filter", "Edm.String", Checks.checkIsAscii(filter))
            .build();
        throw new UnsupportedOperationException("Actions that return a stream are not supported yet. If you want this raise an issue at the project home");
    }

    @Action(name = "getConfigManagerDevicePolicyStatusReport")
    @JsonIgnore
    public FunctionRequestReturningStream getConfigManagerDevicePolicyStatusReport(String name, List<String> select, String search, List<String> groupBy, List<String> orderBy, Integer skip, Integer top, String sessionId, String filter) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("name", "Edm.String", Checks.checkIsAscii(name))
            .put("select", "Collection(Edm.String)", Checks.checkIsAscii(select))
            .put("search", "Edm.String", Checks.checkIsAscii(search))
            .put("groupBy", "Collection(Edm.String)", Checks.checkIsAscii(groupBy))
            .put("orderBy", "Collection(Edm.String)", Checks.checkIsAscii(orderBy))
            .put("skip", "Edm.Int32", skip)
            .put("top", "Edm.Int32", top)
            .put("sessionId", "Edm.String", Checks.checkIsAscii(sessionId))
            .put("filter", "Edm.String", Checks.checkIsAscii(filter))
            .build();
        throw new UnsupportedOperationException("Actions that return a stream are not supported yet. If you want this raise an issue at the project home");
    }

    @Action(name = "getRemoteAssistanceSessionsReport")
    @JsonIgnore
    public FunctionRequestReturningStream getRemoteAssistanceSessionsReport(String name, List<String> select, String search, List<String> groupBy, List<String> orderBy, Integer skip, Integer top, String sessionId, String filter) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("name", "Edm.String", Checks.checkIsAscii(name))
            .put("select", "Collection(Edm.String)", Checks.checkIsAscii(select))
            .put("search", "Edm.String", Checks.checkIsAscii(search))
            .put("groupBy", "Collection(Edm.String)", Checks.checkIsAscii(groupBy))
            .put("orderBy", "Collection(Edm.String)", Checks.checkIsAscii(orderBy))
            .put("skip", "Edm.Int32", skip)
            .put("top", "Edm.Int32", top)
            .put("sessionId", "Edm.String", Checks.checkIsAscii(sessionId))
            .put("filter", "Edm.String", Checks.checkIsAscii(filter))
            .build();
        throw new UnsupportedOperationException("Actions that return a stream are not supported yet. If you want this raise an issue at the project home");
    }

    @Action(name = "getCachedReport")
    @JsonIgnore
    public FunctionRequestReturningStream getCachedReport(String id, List<String> select, String search, List<String> groupBy, List<String> orderBy, Integer skip, Integer top) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("id", "Edm.String", Checks.checkIsAscii(id))
            .put("select", "Collection(Edm.String)", Checks.checkIsAscii(select))
            .put("search", "Edm.String", Checks.checkIsAscii(search))
            .put("groupBy", "Collection(Edm.String)", Checks.checkIsAscii(groupBy))
            .put("orderBy", "Collection(Edm.String)", Checks.checkIsAscii(orderBy))
            .put("skip", "Edm.Int32", skip)
            .put("top", "Edm.Int32", top)
            .build();
        throw new UnsupportedOperationException("Actions that return a stream are not supported yet. If you want this raise an issue at the project home");
    }

    @Action(name = "getCompliancePolicyNonComplianceReport")
    @JsonIgnore
    public FunctionRequestReturningStream getCompliancePolicyNonComplianceReport(String name, List<String> select, String search, List<String> groupBy, List<String> orderBy, Integer skip, Integer top, String sessionId, String filter) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("name", "Edm.String", Checks.checkIsAscii(name))
            .put("select", "Collection(Edm.String)", Checks.checkIsAscii(select))
            .put("search", "Edm.String", Checks.checkIsAscii(search))
            .put("groupBy", "Collection(Edm.String)", Checks.checkIsAscii(groupBy))
            .put("orderBy", "Collection(Edm.String)", Checks.checkIsAscii(orderBy))
            .put("skip", "Edm.Int32", skip)
            .put("top", "Edm.Int32", top)
            .put("sessionId", "Edm.String", Checks.checkIsAscii(sessionId))
            .put("filter", "Edm.String", Checks.checkIsAscii(filter))
            .build();
        throw new UnsupportedOperationException("Actions that return a stream are not supported yet. If you want this raise an issue at the project home");
    }

    @Action(name = "getCompliancePolicyNonComplianceSummaryReport")
    @JsonIgnore
    public FunctionRequestReturningStream getCompliancePolicyNonComplianceSummaryReport(String name, List<String> select, String search, List<String> groupBy, List<String> orderBy, Integer skip, Integer top, String sessionId, String filter) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("name", "Edm.String", Checks.checkIsAscii(name))
            .put("select", "Collection(Edm.String)", Checks.checkIsAscii(select))
            .put("search", "Edm.String", Checks.checkIsAscii(search))
            .put("groupBy", "Collection(Edm.String)", Checks.checkIsAscii(groupBy))
            .put("orderBy", "Collection(Edm.String)", Checks.checkIsAscii(orderBy))
            .put("skip", "Edm.Int32", skip)
            .put("top", "Edm.Int32", top)
            .put("sessionId", "Edm.String", Checks.checkIsAscii(sessionId))
            .put("filter", "Edm.String", Checks.checkIsAscii(filter))
            .build();
        throw new UnsupportedOperationException("Actions that return a stream are not supported yet. If you want this raise an issue at the project home");
    }

    @Action(name = "getComplianceSettingNonComplianceReport")
    @JsonIgnore
    public FunctionRequestReturningStream getComplianceSettingNonComplianceReport(String name, List<String> select, String search, List<String> groupBy, List<String> orderBy, Integer skip, Integer top, String sessionId, String filter) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("name", "Edm.String", Checks.checkIsAscii(name))
            .put("select", "Collection(Edm.String)", Checks.checkIsAscii(select))
            .put("search", "Edm.String", Checks.checkIsAscii(search))
            .put("groupBy", "Collection(Edm.String)", Checks.checkIsAscii(groupBy))
            .put("orderBy", "Collection(Edm.String)", Checks.checkIsAscii(orderBy))
            .put("skip", "Edm.Int32", skip)
            .put("top", "Edm.Int32", top)
            .put("sessionId", "Edm.String", Checks.checkIsAscii(sessionId))
            .put("filter", "Edm.String", Checks.checkIsAscii(filter))
            .build();
        throw new UnsupportedOperationException("Actions that return a stream are not supported yet. If you want this raise an issue at the project home");
    }

    @Action(name = "getConfigurationPolicyNonComplianceReport")
    @JsonIgnore
    public FunctionRequestReturningStream getConfigurationPolicyNonComplianceReport(String name, List<String> select, String search, List<String> groupBy, List<String> orderBy, Integer skip, Integer top, String sessionId, String filter) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("name", "Edm.String", Checks.checkIsAscii(name))
            .put("select", "Collection(Edm.String)", Checks.checkIsAscii(select))
            .put("search", "Edm.String", Checks.checkIsAscii(search))
            .put("groupBy", "Collection(Edm.String)", Checks.checkIsAscii(groupBy))
            .put("orderBy", "Collection(Edm.String)", Checks.checkIsAscii(orderBy))
            .put("skip", "Edm.Int32", skip)
            .put("top", "Edm.Int32", top)
            .put("sessionId", "Edm.String", Checks.checkIsAscii(sessionId))
            .put("filter", "Edm.String", Checks.checkIsAscii(filter))
            .build();
        throw new UnsupportedOperationException("Actions that return a stream are not supported yet. If you want this raise an issue at the project home");
    }

    @Action(name = "getConfigurationPolicyNonComplianceSummaryReport")
    @JsonIgnore
    public FunctionRequestReturningStream getConfigurationPolicyNonComplianceSummaryReport(String name, List<String> select, String search, List<String> groupBy, List<String> orderBy, Integer skip, Integer top, String sessionId, String filter) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("name", "Edm.String", Checks.checkIsAscii(name))
            .put("select", "Collection(Edm.String)", Checks.checkIsAscii(select))
            .put("search", "Edm.String", Checks.checkIsAscii(search))
            .put("groupBy", "Collection(Edm.String)", Checks.checkIsAscii(groupBy))
            .put("orderBy", "Collection(Edm.String)", Checks.checkIsAscii(orderBy))
            .put("skip", "Edm.Int32", skip)
            .put("top", "Edm.Int32", top)
            .put("sessionId", "Edm.String", Checks.checkIsAscii(sessionId))
            .put("filter", "Edm.String", Checks.checkIsAscii(filter))
            .build();
        throw new UnsupportedOperationException("Actions that return a stream are not supported yet. If you want this raise an issue at the project home");
    }

    @Action(name = "getConfigurationSettingNonComplianceReport")
    @JsonIgnore
    public FunctionRequestReturningStream getConfigurationSettingNonComplianceReport(String name, List<String> select, String search, List<String> groupBy, List<String> orderBy, Integer skip, Integer top, String sessionId, String filter) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("name", "Edm.String", Checks.checkIsAscii(name))
            .put("select", "Collection(Edm.String)", Checks.checkIsAscii(select))
            .put("search", "Edm.String", Checks.checkIsAscii(search))
            .put("groupBy", "Collection(Edm.String)", Checks.checkIsAscii(groupBy))
            .put("orderBy", "Collection(Edm.String)", Checks.checkIsAscii(orderBy))
            .put("skip", "Edm.Int32", skip)
            .put("top", "Edm.Int32", top)
            .put("sessionId", "Edm.String", Checks.checkIsAscii(sessionId))
            .put("filter", "Edm.String", Checks.checkIsAscii(filter))
            .build();
        throw new UnsupportedOperationException("Actions that return a stream are not supported yet. If you want this raise an issue at the project home");
    }

    @Action(name = "getDeviceManagementIntentPerSettingContributingProfiles")
    @JsonIgnore
    public FunctionRequestReturningStream getDeviceManagementIntentPerSettingContributingProfiles(String name, List<String> select, String search, List<String> groupBy, List<String> orderBy, Integer skip, Integer top, String sessionId, String filter) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("name", "Edm.String", Checks.checkIsAscii(name))
            .put("select", "Collection(Edm.String)", Checks.checkIsAscii(select))
            .put("search", "Edm.String", Checks.checkIsAscii(search))
            .put("groupBy", "Collection(Edm.String)", Checks.checkIsAscii(groupBy))
            .put("orderBy", "Collection(Edm.String)", Checks.checkIsAscii(orderBy))
            .put("skip", "Edm.Int32", skip)
            .put("top", "Edm.Int32", top)
            .put("sessionId", "Edm.String", Checks.checkIsAscii(sessionId))
            .put("filter", "Edm.String", Checks.checkIsAscii(filter))
            .build();
        throw new UnsupportedOperationException("Actions that return a stream are not supported yet. If you want this raise an issue at the project home");
    }

    @Action(name = "getDeviceManagementIntentSettingsReport")
    @JsonIgnore
    public FunctionRequestReturningStream getDeviceManagementIntentSettingsReport(String name, List<String> select, String search, List<String> groupBy, List<String> orderBy, Integer skip, Integer top, String sessionId, String filter) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("name", "Edm.String", Checks.checkIsAscii(name))
            .put("select", "Collection(Edm.String)", Checks.checkIsAscii(select))
            .put("search", "Edm.String", Checks.checkIsAscii(search))
            .put("groupBy", "Collection(Edm.String)", Checks.checkIsAscii(groupBy))
            .put("orderBy", "Collection(Edm.String)", Checks.checkIsAscii(orderBy))
            .put("skip", "Edm.Int32", skip)
            .put("top", "Edm.Int32", top)
            .put("sessionId", "Edm.String", Checks.checkIsAscii(sessionId))
            .put("filter", "Edm.String", Checks.checkIsAscii(filter))
            .build();
        throw new UnsupportedOperationException("Actions that return a stream are not supported yet. If you want this raise an issue at the project home");
    }

    @Action(name = "getDeviceNonComplianceReport")
    @JsonIgnore
    public FunctionRequestReturningStream getDeviceNonComplianceReport(String name, List<String> select, String search, List<String> groupBy, List<String> orderBy, Integer skip, Integer top, String sessionId, String filter) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("name", "Edm.String", Checks.checkIsAscii(name))
            .put("select", "Collection(Edm.String)", Checks.checkIsAscii(select))
            .put("search", "Edm.String", Checks.checkIsAscii(search))
            .put("groupBy", "Collection(Edm.String)", Checks.checkIsAscii(groupBy))
            .put("orderBy", "Collection(Edm.String)", Checks.checkIsAscii(orderBy))
            .put("skip", "Edm.Int32", skip)
            .put("top", "Edm.Int32", top)
            .put("sessionId", "Edm.String", Checks.checkIsAscii(sessionId))
            .put("filter", "Edm.String", Checks.checkIsAscii(filter))
            .build();
        throw new UnsupportedOperationException("Actions that return a stream are not supported yet. If you want this raise an issue at the project home");
    }

    @Action(name = "getHistoricalReport")
    @JsonIgnore
    public FunctionRequestReturningStream getHistoricalReport(String name, List<String> select, String search, List<String> groupBy, List<String> orderBy, Integer skip, Integer top, String filter) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("name", "Edm.String", Checks.checkIsAscii(name))
            .put("select", "Collection(Edm.String)", Checks.checkIsAscii(select))
            .put("search", "Edm.String", Checks.checkIsAscii(search))
            .put("groupBy", "Collection(Edm.String)", Checks.checkIsAscii(groupBy))
            .put("orderBy", "Collection(Edm.String)", Checks.checkIsAscii(orderBy))
            .put("skip", "Edm.Int32", skip)
            .put("top", "Edm.Int32", top)
            .put("filter", "Edm.String", Checks.checkIsAscii(filter))
            .build();
        throw new UnsupportedOperationException("Actions that return a stream are not supported yet. If you want this raise an issue at the project home");
    }

    @Action(name = "getPolicyNonComplianceMetadata")
    @JsonIgnore
    public FunctionRequestReturningStream getPolicyNonComplianceMetadata(String name, List<String> select, String search, List<String> groupBy, List<String> orderBy, Integer skip, Integer top, String sessionId, String filter) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("name", "Edm.String", Checks.checkIsAscii(name))
            .put("select", "Collection(Edm.String)", Checks.checkIsAscii(select))
            .put("search", "Edm.String", Checks.checkIsAscii(search))
            .put("groupBy", "Collection(Edm.String)", Checks.checkIsAscii(groupBy))
            .put("orderBy", "Collection(Edm.String)", Checks.checkIsAscii(orderBy))
            .put("skip", "Edm.Int32", skip)
            .put("top", "Edm.Int32", top)
            .put("sessionId", "Edm.String", Checks.checkIsAscii(sessionId))
            .put("filter", "Edm.String", Checks.checkIsAscii(filter))
            .build();
        throw new UnsupportedOperationException("Actions that return a stream are not supported yet. If you want this raise an issue at the project home");
    }

    @Action(name = "getPolicyNonComplianceReport")
    @JsonIgnore
    public FunctionRequestReturningStream getPolicyNonComplianceReport(String name, List<String> select, String search, List<String> groupBy, List<String> orderBy, Integer skip, Integer top, String sessionId, String filter) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("name", "Edm.String", Checks.checkIsAscii(name))
            .put("select", "Collection(Edm.String)", Checks.checkIsAscii(select))
            .put("search", "Edm.String", Checks.checkIsAscii(search))
            .put("groupBy", "Collection(Edm.String)", Checks.checkIsAscii(groupBy))
            .put("orderBy", "Collection(Edm.String)", Checks.checkIsAscii(orderBy))
            .put("skip", "Edm.Int32", skip)
            .put("top", "Edm.Int32", top)
            .put("sessionId", "Edm.String", Checks.checkIsAscii(sessionId))
            .put("filter", "Edm.String", Checks.checkIsAscii(filter))
            .build();
        throw new UnsupportedOperationException("Actions that return a stream are not supported yet. If you want this raise an issue at the project home");
    }

    @Action(name = "getPolicyNonComplianceSummaryReport")
    @JsonIgnore
    public FunctionRequestReturningStream getPolicyNonComplianceSummaryReport(String name, List<String> select, String search, List<String> groupBy, List<String> orderBy, Integer skip, Integer top, String sessionId, String filter) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("name", "Edm.String", Checks.checkIsAscii(name))
            .put("select", "Collection(Edm.String)", Checks.checkIsAscii(select))
            .put("search", "Edm.String", Checks.checkIsAscii(search))
            .put("groupBy", "Collection(Edm.String)", Checks.checkIsAscii(groupBy))
            .put("orderBy", "Collection(Edm.String)", Checks.checkIsAscii(orderBy))
            .put("skip", "Edm.Int32", skip)
            .put("top", "Edm.Int32", top)
            .put("sessionId", "Edm.String", Checks.checkIsAscii(sessionId))
            .put("filter", "Edm.String", Checks.checkIsAscii(filter))
            .build();
        throw new UnsupportedOperationException("Actions that return a stream are not supported yet. If you want this raise an issue at the project home");
    }

    @Action(name = "getReportFilters")
    @JsonIgnore
    public FunctionRequestReturningStream getReportFilters(String name, List<String> select, String search, List<String> groupBy, List<String> orderBy, Integer skip, Integer top, String sessionId, String filter) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("name", "Edm.String", Checks.checkIsAscii(name))
            .put("select", "Collection(Edm.String)", Checks.checkIsAscii(select))
            .put("search", "Edm.String", Checks.checkIsAscii(search))
            .put("groupBy", "Collection(Edm.String)", Checks.checkIsAscii(groupBy))
            .put("orderBy", "Collection(Edm.String)", Checks.checkIsAscii(orderBy))
            .put("skip", "Edm.Int32", skip)
            .put("top", "Edm.Int32", top)
            .put("sessionId", "Edm.String", Checks.checkIsAscii(sessionId))
            .put("filter", "Edm.String", Checks.checkIsAscii(filter))
            .build();
        throw new UnsupportedOperationException("Actions that return a stream are not supported yet. If you want this raise an issue at the project home");
    }

    @Action(name = "getSettingNonComplianceReport")
    @JsonIgnore
    public FunctionRequestReturningStream getSettingNonComplianceReport(String name, List<String> select, String search, List<String> groupBy, List<String> orderBy, Integer skip, Integer top, String sessionId, String filter) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("name", "Edm.String", Checks.checkIsAscii(name))
            .put("select", "Collection(Edm.String)", Checks.checkIsAscii(select))
            .put("search", "Edm.String", Checks.checkIsAscii(search))
            .put("groupBy", "Collection(Edm.String)", Checks.checkIsAscii(groupBy))
            .put("orderBy", "Collection(Edm.String)", Checks.checkIsAscii(orderBy))
            .put("skip", "Edm.Int32", skip)
            .put("top", "Edm.Int32", top)
            .put("sessionId", "Edm.String", Checks.checkIsAscii(sessionId))
            .put("filter", "Edm.String", Checks.checkIsAscii(filter))
            .build();
        throw new UnsupportedOperationException("Actions that return a stream are not supported yet. If you want this raise an issue at the project home");
    }

    @Action(name = "getWindowsQualityUpdateAlertsPerPolicyPerDeviceReport")
    @JsonIgnore
    public FunctionRequestReturningStream getWindowsQualityUpdateAlertsPerPolicyPerDeviceReport(String name, List<String> select, String search, List<String> groupBy, List<String> orderBy, Integer skip, Integer top, String sessionId, String filter) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("name", "Edm.String", Checks.checkIsAscii(name))
            .put("select", "Collection(Edm.String)", Checks.checkIsAscii(select))
            .put("search", "Edm.String", Checks.checkIsAscii(search))
            .put("groupBy", "Collection(Edm.String)", Checks.checkIsAscii(groupBy))
            .put("orderBy", "Collection(Edm.String)", Checks.checkIsAscii(orderBy))
            .put("skip", "Edm.Int32", skip)
            .put("top", "Edm.Int32", top)
            .put("sessionId", "Edm.String", Checks.checkIsAscii(sessionId))
            .put("filter", "Edm.String", Checks.checkIsAscii(filter))
            .build();
        throw new UnsupportedOperationException("Actions that return a stream are not supported yet. If you want this raise an issue at the project home");
    }

    @Action(name = "getWindowsQualityUpdateAlertSummaryReport")
    @JsonIgnore
    public FunctionRequestReturningStream getWindowsQualityUpdateAlertSummaryReport(String name, List<String> select, String search, List<String> groupBy, List<String> orderBy, Integer skip, Integer top, String sessionId, String filter) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("name", "Edm.String", Checks.checkIsAscii(name))
            .put("select", "Collection(Edm.String)", Checks.checkIsAscii(select))
            .put("search", "Edm.String", Checks.checkIsAscii(search))
            .put("groupBy", "Collection(Edm.String)", Checks.checkIsAscii(groupBy))
            .put("orderBy", "Collection(Edm.String)", Checks.checkIsAscii(orderBy))
            .put("skip", "Edm.Int32", skip)
            .put("top", "Edm.Int32", top)
            .put("sessionId", "Edm.String", Checks.checkIsAscii(sessionId))
            .put("filter", "Edm.String", Checks.checkIsAscii(filter))
            .build();
        throw new UnsupportedOperationException("Actions that return a stream are not supported yet. If you want this raise an issue at the project home");
    }

    @Action(name = "getWindowsUpdateAlertsPerPolicyPerDeviceReport")
    @JsonIgnore
    public FunctionRequestReturningStream getWindowsUpdateAlertsPerPolicyPerDeviceReport(String name, List<String> select, String search, List<String> groupBy, List<String> orderBy, Integer skip, Integer top, String sessionId, String filter) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("name", "Edm.String", Checks.checkIsAscii(name))
            .put("select", "Collection(Edm.String)", Checks.checkIsAscii(select))
            .put("search", "Edm.String", Checks.checkIsAscii(search))
            .put("groupBy", "Collection(Edm.String)", Checks.checkIsAscii(groupBy))
            .put("orderBy", "Collection(Edm.String)", Checks.checkIsAscii(orderBy))
            .put("skip", "Edm.Int32", skip)
            .put("top", "Edm.Int32", top)
            .put("sessionId", "Edm.String", Checks.checkIsAscii(sessionId))
            .put("filter", "Edm.String", Checks.checkIsAscii(filter))
            .build();
        throw new UnsupportedOperationException("Actions that return a stream are not supported yet. If you want this raise an issue at the project home");
    }

    @Action(name = "getWindowsUpdateAlertSummaryReport")
    @JsonIgnore
    public FunctionRequestReturningStream getWindowsUpdateAlertSummaryReport(String name, List<String> select, String search, List<String> groupBy, List<String> orderBy, Integer skip, Integer top, String sessionId, String filter) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("name", "Edm.String", Checks.checkIsAscii(name))
            .put("select", "Collection(Edm.String)", Checks.checkIsAscii(select))
            .put("search", "Edm.String", Checks.checkIsAscii(search))
            .put("groupBy", "Collection(Edm.String)", Checks.checkIsAscii(groupBy))
            .put("orderBy", "Collection(Edm.String)", Checks.checkIsAscii(orderBy))
            .put("skip", "Edm.Int32", skip)
            .put("top", "Edm.Int32", top)
            .put("sessionId", "Edm.String", Checks.checkIsAscii(sessionId))
            .put("filter", "Edm.String", Checks.checkIsAscii(filter))
            .build();
        throw new UnsupportedOperationException("Actions that return a stream are not supported yet. If you want this raise an issue at the project home");
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DeviceManagementReports[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("cachedReportConfigurations=");
        b.append(this.cachedReportConfigurations);
        b.append(", ");
        b.append("exportJobs=");
        b.append(this.exportJobs);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
