package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.enums.ComplianceStatus;


/**
 * <i>“Entity that represents device state for an intent”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "deviceDisplayName", 
    "deviceId", 
    "lastReportedDateTime", 
    "state", 
    "userName", 
    "userPrincipalName"})
@JsonInclude(Include.NON_NULL)
public class DeviceManagementIntentDeviceState extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.deviceManagementIntentDeviceState";
    }

    @JsonProperty("deviceDisplayName")
    protected String deviceDisplayName;

    @JsonProperty("deviceId")
    protected String deviceId;

    @JsonProperty("lastReportedDateTime")
    protected OffsetDateTime lastReportedDateTime;

    @JsonProperty("state")
    protected ComplianceStatus state;

    @JsonProperty("userName")
    protected String userName;

    @JsonProperty("userPrincipalName")
    protected String userPrincipalName;

    protected DeviceManagementIntentDeviceState() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderDeviceManagementIntentDeviceState() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String deviceDisplayName;
        private String deviceId;
        private OffsetDateTime lastReportedDateTime;
        private ComplianceStatus state;
        private String userName;
        private String userPrincipalName;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“Device name that is being reported”</i>
         * 
         * @param deviceDisplayName
         *            value of {@code deviceDisplayName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceDisplayName(String deviceDisplayName) {
            this.deviceDisplayName = deviceDisplayName;
            this.changedFields = changedFields.add("deviceDisplayName");
            return this;
        }

        /**
         * <i>“Device id that is being reported”</i>
         * 
         * @param deviceId
         *            value of {@code deviceId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceId(String deviceId) {
            this.deviceId = deviceId;
            this.changedFields = changedFields.add("deviceId");
            return this;
        }

        /**
         * <i>“Last modified date time of an intent report”</i>
         * 
         * @param lastReportedDateTime
         *            value of {@code lastReportedDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder lastReportedDateTime(OffsetDateTime lastReportedDateTime) {
            this.lastReportedDateTime = lastReportedDateTime;
            this.changedFields = changedFields.add("lastReportedDateTime");
            return this;
        }

        /**
         * <i>“Device state for an intent”</i>
         * 
         * @param state
         *            value of {@code state} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder state(ComplianceStatus state) {
            this.state = state;
            this.changedFields = changedFields.add("state");
            return this;
        }

        /**
         * <i>“The user name that is being reported on a device”</i>
         * 
         * @param userName
         *            value of {@code userName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userName(String userName) {
            this.userName = userName;
            this.changedFields = changedFields.add("userName");
            return this;
        }

        /**
         * <i>“The user principal name that is being reported on a device”</i>
         * 
         * @param userPrincipalName
         *            value of {@code userPrincipalName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userPrincipalName(String userPrincipalName) {
            this.userPrincipalName = userPrincipalName;
            this.changedFields = changedFields.add("userPrincipalName");
            return this;
        }

        public DeviceManagementIntentDeviceState build() {
            DeviceManagementIntentDeviceState _x = new DeviceManagementIntentDeviceState();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.deviceManagementIntentDeviceState";
            _x.id = id;
            _x.deviceDisplayName = deviceDisplayName;
            _x.deviceId = deviceId;
            _x.lastReportedDateTime = lastReportedDateTime;
            _x.state = state;
            _x.userName = userName;
            _x.userPrincipalName = userPrincipalName;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“Device name that is being reported”</i>
     * 
     * @return property deviceDisplayName
     */
    @Property(name="deviceDisplayName")
    @JsonIgnore
    public Optional<String> getDeviceDisplayName() {
        return Optional.ofNullable(deviceDisplayName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code deviceDisplayName
     * } field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Device name that is being reported”</i>
     * 
     * @param deviceDisplayName
     *            new value of {@code deviceDisplayName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceDisplayName} field changed
     */
    public DeviceManagementIntentDeviceState withDeviceDisplayName(String deviceDisplayName) {
        DeviceManagementIntentDeviceState _x = _copy();
        _x.changedFields = changedFields.add("deviceDisplayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementIntentDeviceState");
        _x.deviceDisplayName = deviceDisplayName;
        return _x;
    }

    /**
     * <i>“Device id that is being reported”</i>
     * 
     * @return property deviceId
     */
    @Property(name="deviceId")
    @JsonIgnore
    public Optional<String> getDeviceId() {
        return Optional.ofNullable(deviceId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code deviceId} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Device id that is being reported”</i>
     * 
     * @param deviceId
     *            new value of {@code deviceId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceId} field changed
     */
    public DeviceManagementIntentDeviceState withDeviceId(String deviceId) {
        DeviceManagementIntentDeviceState _x = _copy();
        _x.changedFields = changedFields.add("deviceId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementIntentDeviceState");
        _x.deviceId = deviceId;
        return _x;
    }

    /**
     * <i>“Last modified date time of an intent report”</i>
     * 
     * @return property lastReportedDateTime
     */
    @Property(name="lastReportedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastReportedDateTime() {
        return Optional.ofNullable(lastReportedDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * lastReportedDateTime} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Last modified date time of an intent report”</i>
     * 
     * @param lastReportedDateTime
     *            new value of {@code lastReportedDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code lastReportedDateTime} field changed
     */
    public DeviceManagementIntentDeviceState withLastReportedDateTime(OffsetDateTime lastReportedDateTime) {
        DeviceManagementIntentDeviceState _x = _copy();
        _x.changedFields = changedFields.add("lastReportedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementIntentDeviceState");
        _x.lastReportedDateTime = lastReportedDateTime;
        return _x;
    }

    /**
     * <i>“Device state for an intent”</i>
     * 
     * @return property state
     */
    @Property(name="state")
    @JsonIgnore
    public Optional<ComplianceStatus> getState() {
        return Optional.ofNullable(state);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code state} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Device state for an intent”</i>
     * 
     * @param state
     *            new value of {@code state} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code state} field changed
     */
    public DeviceManagementIntentDeviceState withState(ComplianceStatus state) {
        DeviceManagementIntentDeviceState _x = _copy();
        _x.changedFields = changedFields.add("state");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementIntentDeviceState");
        _x.state = state;
        return _x;
    }

    /**
     * <i>“The user name that is being reported on a device”</i>
     * 
     * @return property userName
     */
    @Property(name="userName")
    @JsonIgnore
    public Optional<String> getUserName() {
        return Optional.ofNullable(userName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code userName} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The user name that is being reported on a device”</i>
     * 
     * @param userName
     *            new value of {@code userName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code userName} field changed
     */
    public DeviceManagementIntentDeviceState withUserName(String userName) {
        DeviceManagementIntentDeviceState _x = _copy();
        _x.changedFields = changedFields.add("userName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementIntentDeviceState");
        _x.userName = userName;
        return _x;
    }

    /**
     * <i>“The user principal name that is being reported on a device”</i>
     * 
     * @return property userPrincipalName
     */
    @Property(name="userPrincipalName")
    @JsonIgnore
    public Optional<String> getUserPrincipalName() {
        return Optional.ofNullable(userPrincipalName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code userPrincipalName
     * } field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The user principal name that is being reported on a device”</i>
     * 
     * @param userPrincipalName
     *            new value of {@code userPrincipalName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code userPrincipalName} field changed
     */
    public DeviceManagementIntentDeviceState withUserPrincipalName(String userPrincipalName) {
        DeviceManagementIntentDeviceState _x = _copy();
        _x.changedFields = changedFields.add("userPrincipalName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementIntentDeviceState");
        _x.userPrincipalName = userPrincipalName;
        return _x;
    }

    public DeviceManagementIntentDeviceState withUnmappedField(String name, Object value) {
        DeviceManagementIntentDeviceState _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DeviceManagementIntentDeviceState patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        DeviceManagementIntentDeviceState _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DeviceManagementIntentDeviceState put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        DeviceManagementIntentDeviceState _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private DeviceManagementIntentDeviceState _copy() {
        DeviceManagementIntentDeviceState _x = new DeviceManagementIntentDeviceState();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.deviceDisplayName = deviceDisplayName;
        _x.deviceId = deviceId;
        _x.lastReportedDateTime = lastReportedDateTime;
        _x.state = state;
        _x.userName = userName;
        _x.userPrincipalName = userPrincipalName;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DeviceManagementIntentDeviceState[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("deviceDisplayName=");
        b.append(this.deviceDisplayName);
        b.append(", ");
        b.append("deviceId=");
        b.append(this.deviceId);
        b.append(", ");
        b.append("lastReportedDateTime=");
        b.append(this.lastReportedDateTime);
        b.append(", ");
        b.append("state=");
        b.append(this.state);
        b.append(", ");
        b.append("userName=");
        b.append(this.userName);
        b.append(", ");
        b.append("userPrincipalName=");
        b.append(this.userPrincipalName);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
