package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import odata.msgraph.client.beta.complex.DeviceManagementConfigurationSettingInstance;
import odata.msgraph.client.beta.entity.collection.request.DeviceManagementConfigurationSettingDefinitionCollectionRequest;


/**
 * <i>“Setting instance within policy”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "settingInstance"})
@JsonInclude(Include.NON_NULL)
public class DeviceManagementConfigurationSetting extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.deviceManagementConfigurationSetting";
    }

    @JsonProperty("settingInstance")
    protected DeviceManagementConfigurationSettingInstance settingInstance;

    protected DeviceManagementConfigurationSetting() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderDeviceManagementConfigurationSetting() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private DeviceManagementConfigurationSettingInstance settingInstance;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“Setting Instance”</i>
         * 
         * @param settingInstance
         *            value of {@code settingInstance} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder settingInstance(DeviceManagementConfigurationSettingInstance settingInstance) {
            this.settingInstance = settingInstance;
            this.changedFields = changedFields.add("settingInstance");
            return this;
        }

        public DeviceManagementConfigurationSetting build() {
            DeviceManagementConfigurationSetting _x = new DeviceManagementConfigurationSetting();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.deviceManagementConfigurationSetting";
            _x.id = id;
            _x.settingInstance = settingInstance;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“Setting Instance”</i>
     * 
     * @return property settingInstance
     */
    @Property(name="settingInstance")
    @JsonIgnore
    public Optional<DeviceManagementConfigurationSettingInstance> getSettingInstance() {
        return Optional.ofNullable(settingInstance);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code settingInstance}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Setting Instance”</i>
     * 
     * @param settingInstance
     *            new value of {@code settingInstance} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code settingInstance} field changed
     */
    public DeviceManagementConfigurationSetting withSettingInstance(DeviceManagementConfigurationSettingInstance settingInstance) {
        DeviceManagementConfigurationSetting _x = _copy();
        _x.changedFields = changedFields.add("settingInstance");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementConfigurationSetting");
        _x.settingInstance = settingInstance;
        return _x;
    }

    public DeviceManagementConfigurationSetting withUnmappedField(String name, Object value) {
        DeviceManagementConfigurationSetting _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    /**
     * <i>“List of related Setting Definitions. This property is read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @return navigational property settingDefinitions
     */
    @NavigationProperty(name="settingDefinitions")
    @JsonIgnore
    public DeviceManagementConfigurationSettingDefinitionCollectionRequest getSettingDefinitions() {
        return new DeviceManagementConfigurationSettingDefinitionCollectionRequest(
                        contextPath.addSegment("settingDefinitions"), RequestHelper.getValue(unmappedFields, "settingDefinitions"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DeviceManagementConfigurationSetting patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        DeviceManagementConfigurationSetting _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DeviceManagementConfigurationSetting put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        DeviceManagementConfigurationSetting _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private DeviceManagementConfigurationSetting _copy() {
        DeviceManagementConfigurationSetting _x = new DeviceManagementConfigurationSetting();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.settingInstance = settingInstance;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DeviceManagementConfigurationSetting[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("settingInstance=");
        b.append(this.settingInstance);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
