package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.entity.collection.request.DeviceManagementConfigurationSettingTemplateCollectionRequest;
import odata.msgraph.client.beta.enums.DeviceManagementConfigurationPlatforms;
import odata.msgraph.client.beta.enums.DeviceManagementConfigurationTechnologies;
import odata.msgraph.client.beta.enums.DeviceManagementConfigurationTemplateFamily;
import odata.msgraph.client.beta.enums.DeviceManagementTemplateLifecycleState;


/**
 * <i>“Device Management Configuration Policy Template”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "allowUnmanagedSettings", 
    "baseId", 
    "description", 
    "displayName", 
    "displayVersion", 
    "lifecycleState", 
    "platforms", 
    "settingTemplateCount", 
    "technologies", 
    "templateFamily", 
    "version", 
    "settingTemplates"})
@JsonInclude(Include.NON_NULL)
public class DeviceManagementConfigurationPolicyTemplate extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.deviceManagementConfigurationPolicyTemplate";
    }

    @JsonProperty("allowUnmanagedSettings")
    protected Boolean allowUnmanagedSettings;

    @JsonProperty("baseId")
    protected String baseId;

    @JsonProperty("description")
    protected String description;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("displayVersion")
    protected String displayVersion;

    @JsonProperty("lifecycleState")
    protected DeviceManagementTemplateLifecycleState lifecycleState;

    @JsonProperty("platforms")
    protected DeviceManagementConfigurationPlatforms platforms;

    @JsonProperty("settingTemplateCount")
    protected Integer settingTemplateCount;

    @JsonProperty("technologies")
    protected DeviceManagementConfigurationTechnologies technologies;

    @JsonProperty("templateFamily")
    protected DeviceManagementConfigurationTemplateFamily templateFamily;

    @JsonProperty("version")
    protected Integer version;

    @JsonProperty("settingTemplates")
    protected List<DeviceManagementConfigurationSettingTemplate> settingTemplates;

    protected DeviceManagementConfigurationPolicyTemplate() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderDeviceManagementConfigurationPolicyTemplate() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private Boolean allowUnmanagedSettings;
        private String baseId;
        private String description;
        private String displayName;
        private String displayVersion;
        private DeviceManagementTemplateLifecycleState lifecycleState;
        private DeviceManagementConfigurationPlatforms platforms;
        private Integer settingTemplateCount;
        private DeviceManagementConfigurationTechnologies technologies;
        private DeviceManagementConfigurationTemplateFamily templateFamily;
        private Integer version;
        private List<DeviceManagementConfigurationSettingTemplate> settingTemplates;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“Allow unmanaged setting templates”</i>
         * 
         * @param allowUnmanagedSettings
         *            value of {@code allowUnmanagedSettings} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder allowUnmanagedSettings(Boolean allowUnmanagedSettings) {
            this.allowUnmanagedSettings = allowUnmanagedSettings;
            this.changedFields = changedFields.add("allowUnmanagedSettings");
            return this;
        }

        /**
         * <i>“Template base identifier”</i>
         * 
         * @param baseId
         *            value of {@code baseId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder baseId(String baseId) {
            this.baseId = baseId;
            this.changedFields = changedFields.add("baseId");
            return this;
        }

        /**
         * <i>“Template description”</i>
         * 
         * @param description
         *            value of {@code description} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        /**
         * <i>“Template display name”</i>
         * 
         * @param displayName
         *            value of {@code displayName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        /**
         * <i>“Description of template version”</i>
         * 
         * @param displayVersion
         *            value of {@code displayVersion} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder displayVersion(String displayVersion) {
            this.displayVersion = displayVersion;
            this.changedFields = changedFields.add("displayVersion");
            return this;
        }

        /**
         * <i>“Indicate current lifecycle state of template”</i>
         * 
         * @param lifecycleState
         *            value of {@code lifecycleState} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder lifecycleState(DeviceManagementTemplateLifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.changedFields = changedFields.add("lifecycleState");
            return this;
        }

        /**
         * <i>“Platforms for this template”</i>
         * 
         * @param platforms
         *            value of {@code platforms} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder platforms(DeviceManagementConfigurationPlatforms platforms) {
            this.platforms = platforms;
            this.changedFields = changedFields.add("platforms");
            return this;
        }

        /**
         * <i>“Number of setting templates. Valid values 0 to 2147483647. This property is read
         * -only.”</i>
         * <p>
         * <b>Org.OData.Core.V1.Computed</b>
         * <p>
         * true
         * <p>
         * <b>Org.OData.Core.V1.Permissions</b>
         * 
         * @param settingTemplateCount
         *            value of {@code settingTemplateCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder settingTemplateCount(Integer settingTemplateCount) {
            this.settingTemplateCount = settingTemplateCount;
            this.changedFields = changedFields.add("settingTemplateCount");
            return this;
        }

        /**
         * <i>“Technologies for this template”</i>
         * 
         * @param technologies
         *            value of {@code technologies} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder technologies(DeviceManagementConfigurationTechnologies technologies) {
            this.technologies = technologies;
            this.changedFields = changedFields.add("technologies");
            return this;
        }

        /**
         * <i>“TemplateFamily for this template”</i>
         * 
         * @param templateFamily
         *            value of {@code templateFamily} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder templateFamily(DeviceManagementConfigurationTemplateFamily templateFamily) {
            this.templateFamily = templateFamily;
            this.changedFields = changedFields.add("templateFamily");
            return this;
        }

        /**
         * <i>“Template version. Valid values 1 to 2147483647. This property is read-only.”</i>
         * <p>
         * <b>Org.OData.Core.V1.Computed</b>
         * <p>
         * true
         * <p>
         * <b>Org.OData.Core.V1.Permissions</b>
         * 
         * @param version
         *            value of {@code version} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder version(Integer version) {
            this.version = version;
            this.changedFields = changedFields.add("version");
            return this;
        }

        /**
         * <i>“Setting templates”</i>
         * 
         * @param settingTemplates
         *            value of {@code settingTemplates} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder settingTemplates(List<DeviceManagementConfigurationSettingTemplate> settingTemplates) {
            this.settingTemplates = settingTemplates;
            this.changedFields = changedFields.add("settingTemplates");
            return this;
        }

        /**
         * <i>“Setting templates”</i>
         * 
         * @param settingTemplates
         *            value of {@code settingTemplates} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder settingTemplates(DeviceManagementConfigurationSettingTemplate... settingTemplates) {
            return settingTemplates(Arrays.asList(settingTemplates));
        }

        public DeviceManagementConfigurationPolicyTemplate build() {
            DeviceManagementConfigurationPolicyTemplate _x = new DeviceManagementConfigurationPolicyTemplate();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.deviceManagementConfigurationPolicyTemplate";
            _x.id = id;
            _x.allowUnmanagedSettings = allowUnmanagedSettings;
            _x.baseId = baseId;
            _x.description = description;
            _x.displayName = displayName;
            _x.displayVersion = displayVersion;
            _x.lifecycleState = lifecycleState;
            _x.platforms = platforms;
            _x.settingTemplateCount = settingTemplateCount;
            _x.technologies = technologies;
            _x.templateFamily = templateFamily;
            _x.version = version;
            _x.settingTemplates = settingTemplates;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“Allow unmanaged setting templates”</i>
     * 
     * @return property allowUnmanagedSettings
     */
    @Property(name="allowUnmanagedSettings")
    @JsonIgnore
    public Optional<Boolean> getAllowUnmanagedSettings() {
        return Optional.ofNullable(allowUnmanagedSettings);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * allowUnmanagedSettings} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Allow unmanaged setting templates”</i>
     * 
     * @param allowUnmanagedSettings
     *            new value of {@code allowUnmanagedSettings} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code allowUnmanagedSettings} field changed
     */
    public DeviceManagementConfigurationPolicyTemplate withAllowUnmanagedSettings(Boolean allowUnmanagedSettings) {
        DeviceManagementConfigurationPolicyTemplate _x = _copy();
        _x.changedFields = changedFields.add("allowUnmanagedSettings");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementConfigurationPolicyTemplate");
        _x.allowUnmanagedSettings = allowUnmanagedSettings;
        return _x;
    }

    /**
     * <i>“Template base identifier”</i>
     * 
     * @return property baseId
     */
    @Property(name="baseId")
    @JsonIgnore
    public Optional<String> getBaseId() {
        return Optional.ofNullable(baseId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code baseId} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Template base identifier”</i>
     * 
     * @param baseId
     *            new value of {@code baseId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code baseId} field changed
     */
    public DeviceManagementConfigurationPolicyTemplate withBaseId(String baseId) {
        DeviceManagementConfigurationPolicyTemplate _x = _copy();
        _x.changedFields = changedFields.add("baseId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementConfigurationPolicyTemplate");
        _x.baseId = baseId;
        return _x;
    }

    /**
     * <i>“Template description”</i>
     * 
     * @return property description
     */
    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code description}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Template description”</i>
     * 
     * @param description
     *            new value of {@code description} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code description} field changed
     */
    public DeviceManagementConfigurationPolicyTemplate withDescription(String description) {
        DeviceManagementConfigurationPolicyTemplate _x = _copy();
        _x.changedFields = changedFields.add("description");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementConfigurationPolicyTemplate");
        _x.description = description;
        return _x;
    }

    /**
     * <i>“Template display name”</i>
     * 
     * @return property displayName
     */
    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code displayName}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Template display name”</i>
     * 
     * @param displayName
     *            new value of {@code displayName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code displayName} field changed
     */
    public DeviceManagementConfigurationPolicyTemplate withDisplayName(String displayName) {
        DeviceManagementConfigurationPolicyTemplate _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementConfigurationPolicyTemplate");
        _x.displayName = displayName;
        return _x;
    }

    /**
     * <i>“Description of template version”</i>
     * 
     * @return property displayVersion
     */
    @Property(name="displayVersion")
    @JsonIgnore
    public Optional<String> getDisplayVersion() {
        return Optional.ofNullable(displayVersion);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code displayVersion}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Description of template version”</i>
     * 
     * @param displayVersion
     *            new value of {@code displayVersion} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code displayVersion} field changed
     */
    public DeviceManagementConfigurationPolicyTemplate withDisplayVersion(String displayVersion) {
        DeviceManagementConfigurationPolicyTemplate _x = _copy();
        _x.changedFields = changedFields.add("displayVersion");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementConfigurationPolicyTemplate");
        _x.displayVersion = displayVersion;
        return _x;
    }

    /**
     * <i>“Indicate current lifecycle state of template”</i>
     * 
     * @return property lifecycleState
     */
    @Property(name="lifecycleState")
    @JsonIgnore
    public Optional<DeviceManagementTemplateLifecycleState> getLifecycleState() {
        return Optional.ofNullable(lifecycleState);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code lifecycleState}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Indicate current lifecycle state of template”</i>
     * 
     * @param lifecycleState
     *            new value of {@code lifecycleState} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code lifecycleState} field changed
     */
    public DeviceManagementConfigurationPolicyTemplate withLifecycleState(DeviceManagementTemplateLifecycleState lifecycleState) {
        DeviceManagementConfigurationPolicyTemplate _x = _copy();
        _x.changedFields = changedFields.add("lifecycleState");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementConfigurationPolicyTemplate");
        _x.lifecycleState = lifecycleState;
        return _x;
    }

    /**
     * <i>“Platforms for this template”</i>
     * 
     * @return property platforms
     */
    @Property(name="platforms")
    @JsonIgnore
    public Optional<DeviceManagementConfigurationPlatforms> getPlatforms() {
        return Optional.ofNullable(platforms);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code platforms} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Platforms for this template”</i>
     * 
     * @param platforms
     *            new value of {@code platforms} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code platforms} field changed
     */
    public DeviceManagementConfigurationPolicyTemplate withPlatforms(DeviceManagementConfigurationPlatforms platforms) {
        DeviceManagementConfigurationPolicyTemplate _x = _copy();
        _x.changedFields = changedFields.add("platforms");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementConfigurationPolicyTemplate");
        _x.platforms = platforms;
        return _x;
    }

    /**
     * <i>“Number of setting templates. Valid values 0 to 2147483647. This property is read
     * -only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @return property settingTemplateCount
     */
    @Property(name="settingTemplateCount")
    @JsonIgnore
    public Optional<Integer> getSettingTemplateCount() {
        return Optional.ofNullable(settingTemplateCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * settingTemplateCount} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Number of setting templates. Valid values 0 to 2147483647. This property is read
     * -only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @param settingTemplateCount
     *            new value of {@code settingTemplateCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code settingTemplateCount} field changed
     */
    public DeviceManagementConfigurationPolicyTemplate withSettingTemplateCount(Integer settingTemplateCount) {
        DeviceManagementConfigurationPolicyTemplate _x = _copy();
        _x.changedFields = changedFields.add("settingTemplateCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementConfigurationPolicyTemplate");
        _x.settingTemplateCount = settingTemplateCount;
        return _x;
    }

    /**
     * <i>“Technologies for this template”</i>
     * 
     * @return property technologies
     */
    @Property(name="technologies")
    @JsonIgnore
    public Optional<DeviceManagementConfigurationTechnologies> getTechnologies() {
        return Optional.ofNullable(technologies);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code technologies}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Technologies for this template”</i>
     * 
     * @param technologies
     *            new value of {@code technologies} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code technologies} field changed
     */
    public DeviceManagementConfigurationPolicyTemplate withTechnologies(DeviceManagementConfigurationTechnologies technologies) {
        DeviceManagementConfigurationPolicyTemplate _x = _copy();
        _x.changedFields = changedFields.add("technologies");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementConfigurationPolicyTemplate");
        _x.technologies = technologies;
        return _x;
    }

    /**
     * <i>“TemplateFamily for this template”</i>
     * 
     * @return property templateFamily
     */
    @Property(name="templateFamily")
    @JsonIgnore
    public Optional<DeviceManagementConfigurationTemplateFamily> getTemplateFamily() {
        return Optional.ofNullable(templateFamily);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code templateFamily}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“TemplateFamily for this template”</i>
     * 
     * @param templateFamily
     *            new value of {@code templateFamily} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code templateFamily} field changed
     */
    public DeviceManagementConfigurationPolicyTemplate withTemplateFamily(DeviceManagementConfigurationTemplateFamily templateFamily) {
        DeviceManagementConfigurationPolicyTemplate _x = _copy();
        _x.changedFields = changedFields.add("templateFamily");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementConfigurationPolicyTemplate");
        _x.templateFamily = templateFamily;
        return _x;
    }

    /**
     * <i>“Template version. Valid values 1 to 2147483647. This property is read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @return property version
     */
    @Property(name="version")
    @JsonIgnore
    public Optional<Integer> getVersion() {
        return Optional.ofNullable(version);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code version} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Template version. Valid values 1 to 2147483647. This property is read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @param version
     *            new value of {@code version} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code version} field changed
     */
    public DeviceManagementConfigurationPolicyTemplate withVersion(Integer version) {
        DeviceManagementConfigurationPolicyTemplate _x = _copy();
        _x.changedFields = changedFields.add("version");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementConfigurationPolicyTemplate");
        _x.version = version;
        return _x;
    }

    public DeviceManagementConfigurationPolicyTemplate withUnmappedField(String name, Object value) {
        DeviceManagementConfigurationPolicyTemplate _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    /**
     * <i>“Setting templates”</i>
     * 
     * @return navigational property settingTemplates
     */
    @NavigationProperty(name="settingTemplates")
    @JsonIgnore
    public DeviceManagementConfigurationSettingTemplateCollectionRequest getSettingTemplates() {
        return new DeviceManagementConfigurationSettingTemplateCollectionRequest(
                        contextPath.addSegment("settingTemplates"), Optional.ofNullable(settingTemplates));
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code settingTemplates}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Setting templates”</i>
     * 
     * @param settingTemplates
     *            new value of {@code settingTemplates} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code settingTemplates} field changed
     */
    public DeviceManagementConfigurationPolicyTemplate withSettingTemplates(List<DeviceManagementConfigurationSettingTemplate> settingTemplates) {
        DeviceManagementConfigurationPolicyTemplate _x = _copy();
        _x.changedFields = changedFields.add("settingTemplates");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementConfigurationPolicyTemplate");
        _x.settingTemplates = settingTemplates;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DeviceManagementConfigurationPolicyTemplate patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        DeviceManagementConfigurationPolicyTemplate _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DeviceManagementConfigurationPolicyTemplate put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        DeviceManagementConfigurationPolicyTemplate _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private DeviceManagementConfigurationPolicyTemplate _copy() {
        DeviceManagementConfigurationPolicyTemplate _x = new DeviceManagementConfigurationPolicyTemplate();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.allowUnmanagedSettings = allowUnmanagedSettings;
        _x.baseId = baseId;
        _x.description = description;
        _x.displayName = displayName;
        _x.displayVersion = displayVersion;
        _x.lifecycleState = lifecycleState;
        _x.platforms = platforms;
        _x.settingTemplateCount = settingTemplateCount;
        _x.technologies = technologies;
        _x.templateFamily = templateFamily;
        _x.version = version;
        _x.settingTemplates = settingTemplates;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DeviceManagementConfigurationPolicyTemplate[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("allowUnmanagedSettings=");
        b.append(this.allowUnmanagedSettings);
        b.append(", ");
        b.append("baseId=");
        b.append(this.baseId);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("displayVersion=");
        b.append(this.displayVersion);
        b.append(", ");
        b.append("lifecycleState=");
        b.append(this.lifecycleState);
        b.append(", ");
        b.append("platforms=");
        b.append(this.platforms);
        b.append(", ");
        b.append("settingTemplateCount=");
        b.append(this.settingTemplateCount);
        b.append(", ");
        b.append("technologies=");
        b.append(this.technologies);
        b.append(", ");
        b.append("templateFamily=");
        b.append(this.templateFamily);
        b.append(", ");
        b.append("version=");
        b.append(this.version);
        b.append(", ");
        b.append("settingTemplates=");
        b.append(this.settingTemplates);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
