package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.entity.collection.request.DeviceManagementComplianceScheduledActionForRuleCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DeviceManagementConfigurationPolicyAssignmentCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DeviceManagementConfigurationSettingCollectionRequest;
import odata.msgraph.client.beta.enums.DeviceManagementConfigurationPlatforms;
import odata.msgraph.client.beta.enums.DeviceManagementConfigurationTechnologies;


/**
 * <i>“Device Management Compliance Policy”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "createdDateTime", 
    "creationSource", 
    "description", 
    "isAssigned", 
    "lastModifiedDateTime", 
    "name", 
    "platforms", 
    "roleScopeTagIds", 
    "settingCount", 
    "technologies", 
    "assignments", 
    "scheduledActionsForRule", 
    "settings"})
@JsonInclude(Include.NON_NULL)
public class DeviceManagementCompliancePolicy extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.deviceManagementCompliancePolicy";
    }

    @JsonProperty("createdDateTime")
    protected OffsetDateTime createdDateTime;

    @JsonProperty("creationSource")
    protected String creationSource;

    @JsonProperty("description")
    protected String description;

    @JsonProperty("isAssigned")
    protected Boolean isAssigned;

    @JsonProperty("lastModifiedDateTime")
    protected OffsetDateTime lastModifiedDateTime;

    @JsonProperty("name")
    protected String name;

    @JsonProperty("platforms")
    protected DeviceManagementConfigurationPlatforms platforms;

    @JsonProperty("roleScopeTagIds")
    protected List<String> roleScopeTagIds;

    @JsonProperty("roleScopeTagIds@nextLink")
    protected String roleScopeTagIdsNextLink;

    @JsonProperty("settingCount")
    protected Integer settingCount;

    @JsonProperty("technologies")
    protected DeviceManagementConfigurationTechnologies technologies;

    @JsonProperty("assignments")
    protected List<DeviceManagementConfigurationPolicyAssignment> assignments;

    @JsonProperty("scheduledActionsForRule")
    protected List<DeviceManagementComplianceScheduledActionForRule> scheduledActionsForRule;

    @JsonProperty("settings")
    protected List<DeviceManagementConfigurationSetting> settings;

    protected DeviceManagementCompliancePolicy() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderDeviceManagementCompliancePolicy() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private OffsetDateTime createdDateTime;
        private String creationSource;
        private String description;
        private Boolean isAssigned;
        private OffsetDateTime lastModifiedDateTime;
        private String name;
        private DeviceManagementConfigurationPlatforms platforms;
        private List<String> roleScopeTagIds;
        private String roleScopeTagIdsNextLink;
        private Integer settingCount;
        private DeviceManagementConfigurationTechnologies technologies;
        private List<DeviceManagementConfigurationPolicyAssignment> assignments;
        private List<DeviceManagementComplianceScheduledActionForRule> scheduledActionsForRule;
        private List<DeviceManagementConfigurationSetting> settings;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“Policy creation date and time. This property is read-only.”</i>
         * <p>
         * <b>Org.OData.Core.V1.Computed</b>
         * <p>
         * true
         * <p>
         * <b>Org.OData.Core.V1.Permissions</b>
         * 
         * @param createdDateTime
         *            value of {@code createdDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        /**
         * <i>“Policy creation source”</i>
         * 
         * @param creationSource
         *            value of {@code creationSource} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder creationSource(String creationSource) {
            this.creationSource = creationSource;
            this.changedFields = changedFields.add("creationSource");
            return this;
        }

        /**
         * <i>“Policy description”</i>
         * 
         * @param description
         *            value of {@code description} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        /**
         * <i>“Policy assignment status. This property is read-only.”</i>
         * <p>
         * <b>Org.OData.Core.V1.Computed</b>
         * <p>
         * true
         * <p>
         * <b>Org.OData.Core.V1.Permissions</b>
         * 
         * @param isAssigned
         *            value of {@code isAssigned} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder isAssigned(Boolean isAssigned) {
            this.isAssigned = isAssigned;
            this.changedFields = changedFields.add("isAssigned");
            return this;
        }

        /**
         * <i>“Policy last modification date and time. This property is read-only.”</i>
         * <p>
         * <b>Org.OData.Core.V1.Computed</b>
         * <p>
         * true
         * <p>
         * <b>Org.OData.Core.V1.Permissions</b>
         * 
         * @param lastModifiedDateTime
         *            value of {@code lastModifiedDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        /**
         * <i>“Policy name”</i>
         * 
         * @param name
         *            value of {@code name} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        /**
         * <i>“Platforms for this policy”</i>
         * 
         * @param platforms
         *            value of {@code platforms} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder platforms(DeviceManagementConfigurationPlatforms platforms) {
            this.platforms = platforms;
            this.changedFields = changedFields.add("platforms");
            return this;
        }

        /**
         * <i>“List of Scope Tags for this Entity instance.”</i>
         * 
         * @param roleScopeTagIds
         *            value of {@code roleScopeTagIds} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder roleScopeTagIds(List<String> roleScopeTagIds) {
            this.roleScopeTagIds = roleScopeTagIds;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        /**
         * <i>“List of Scope Tags for this Entity instance.”</i>
         * 
         * @param roleScopeTagIds
         *            value of {@code roleScopeTagIds} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder roleScopeTagIds(String... roleScopeTagIds) {
            return roleScopeTagIds(Arrays.asList(roleScopeTagIds));
        }

        /**
         * <i>“List of Scope Tags for this Entity instance.”</i>
         * 
         * @param roleScopeTagIdsNextLink
         *            value of {@code roleScopeTagIds@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder roleScopeTagIdsNextLink(String roleScopeTagIdsNextLink) {
            this.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        /**
         * <i>“Number of settings. This property is read-only.”</i>
         * <p>
         * <b>Org.OData.Core.V1.Computed</b>
         * <p>
         * true
         * <p>
         * <b>Org.OData.Core.V1.Permissions</b>
         * 
         * @param settingCount
         *            value of {@code settingCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder settingCount(Integer settingCount) {
            this.settingCount = settingCount;
            this.changedFields = changedFields.add("settingCount");
            return this;
        }

        /**
         * <i>“Technologies for this policy”</i>
         * 
         * @param technologies
         *            value of {@code technologies} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder technologies(DeviceManagementConfigurationTechnologies technologies) {
            this.technologies = technologies;
            this.changedFields = changedFields.add("technologies");
            return this;
        }

        /**
         * <i>“Policy assignments”</i>
         * 
         * @param assignments
         *            value of {@code assignments} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder assignments(List<DeviceManagementConfigurationPolicyAssignment> assignments) {
            this.assignments = assignments;
            this.changedFields = changedFields.add("assignments");
            return this;
        }

        /**
         * <i>“Policy assignments”</i>
         * 
         * @param assignments
         *            value of {@code assignments} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder assignments(DeviceManagementConfigurationPolicyAssignment... assignments) {
            return assignments(Arrays.asList(assignments));
        }

        /**
         * <i>“The list of scheduled action for this rule”</i>
         * 
         * @param scheduledActionsForRule
         *            value of {@code scheduledActionsForRule} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder scheduledActionsForRule(List<DeviceManagementComplianceScheduledActionForRule> scheduledActionsForRule) {
            this.scheduledActionsForRule = scheduledActionsForRule;
            this.changedFields = changedFields.add("scheduledActionsForRule");
            return this;
        }

        /**
         * <i>“The list of scheduled action for this rule”</i>
         * 
         * @param scheduledActionsForRule
         *            value of {@code scheduledActionsForRule} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder scheduledActionsForRule(DeviceManagementComplianceScheduledActionForRule... scheduledActionsForRule) {
            return scheduledActionsForRule(Arrays.asList(scheduledActionsForRule));
        }

        /**
         * <i>“Policy settings”</i>
         * 
         * @param settings
         *            value of {@code settings} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder settings(List<DeviceManagementConfigurationSetting> settings) {
            this.settings = settings;
            this.changedFields = changedFields.add("settings");
            return this;
        }

        /**
         * <i>“Policy settings”</i>
         * 
         * @param settings
         *            value of {@code settings} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder settings(DeviceManagementConfigurationSetting... settings) {
            return settings(Arrays.asList(settings));
        }

        public DeviceManagementCompliancePolicy build() {
            DeviceManagementCompliancePolicy _x = new DeviceManagementCompliancePolicy();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.deviceManagementCompliancePolicy";
            _x.id = id;
            _x.createdDateTime = createdDateTime;
            _x.creationSource = creationSource;
            _x.description = description;
            _x.isAssigned = isAssigned;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.name = name;
            _x.platforms = platforms;
            _x.roleScopeTagIds = roleScopeTagIds;
            _x.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            _x.settingCount = settingCount;
            _x.technologies = technologies;
            _x.assignments = assignments;
            _x.scheduledActionsForRule = scheduledActionsForRule;
            _x.settings = settings;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“Policy creation date and time. This property is read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @return property createdDateTime
     */
    @Property(name="createdDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedDateTime() {
        return Optional.ofNullable(createdDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code createdDateTime}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Policy creation date and time. This property is read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @param createdDateTime
     *            new value of {@code createdDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code createdDateTime} field changed
     */
    public DeviceManagementCompliancePolicy withCreatedDateTime(OffsetDateTime createdDateTime) {
        DeviceManagementCompliancePolicy _x = _copy();
        _x.changedFields = changedFields.add("createdDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementCompliancePolicy");
        _x.createdDateTime = createdDateTime;
        return _x;
    }

    /**
     * <i>“Policy creation source”</i>
     * 
     * @return property creationSource
     */
    @Property(name="creationSource")
    @JsonIgnore
    public Optional<String> getCreationSource() {
        return Optional.ofNullable(creationSource);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code creationSource}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Policy creation source”</i>
     * 
     * @param creationSource
     *            new value of {@code creationSource} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code creationSource} field changed
     */
    public DeviceManagementCompliancePolicy withCreationSource(String creationSource) {
        DeviceManagementCompliancePolicy _x = _copy();
        _x.changedFields = changedFields.add("creationSource");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementCompliancePolicy");
        _x.creationSource = creationSource;
        return _x;
    }

    /**
     * <i>“Policy description”</i>
     * 
     * @return property description
     */
    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code description}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Policy description”</i>
     * 
     * @param description
     *            new value of {@code description} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code description} field changed
     */
    public DeviceManagementCompliancePolicy withDescription(String description) {
        DeviceManagementCompliancePolicy _x = _copy();
        _x.changedFields = changedFields.add("description");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementCompliancePolicy");
        _x.description = description;
        return _x;
    }

    /**
     * <i>“Policy assignment status. This property is read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @return property isAssigned
     */
    @Property(name="isAssigned")
    @JsonIgnore
    public Optional<Boolean> getIsAssigned() {
        return Optional.ofNullable(isAssigned);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code isAssigned} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Policy assignment status. This property is read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @param isAssigned
     *            new value of {@code isAssigned} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code isAssigned} field changed
     */
    public DeviceManagementCompliancePolicy withIsAssigned(Boolean isAssigned) {
        DeviceManagementCompliancePolicy _x = _copy();
        _x.changedFields = changedFields.add("isAssigned");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementCompliancePolicy");
        _x.isAssigned = isAssigned;
        return _x;
    }

    /**
     * <i>“Policy last modification date and time. This property is read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @return property lastModifiedDateTime
     */
    @Property(name="lastModifiedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastModifiedDateTime() {
        return Optional.ofNullable(lastModifiedDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * lastModifiedDateTime} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Policy last modification date and time. This property is read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @param lastModifiedDateTime
     *            new value of {@code lastModifiedDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code lastModifiedDateTime} field changed
     */
    public DeviceManagementCompliancePolicy withLastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
        DeviceManagementCompliancePolicy _x = _copy();
        _x.changedFields = changedFields.add("lastModifiedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementCompliancePolicy");
        _x.lastModifiedDateTime = lastModifiedDateTime;
        return _x;
    }

    /**
     * <i>“Policy name”</i>
     * 
     * @return property name
     */
    @Property(name="name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code name} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Policy name”</i>
     * 
     * @param name
     *            new value of {@code name} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code name} field changed
     */
    public DeviceManagementCompliancePolicy withName(String name) {
        DeviceManagementCompliancePolicy _x = _copy();
        _x.changedFields = changedFields.add("name");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementCompliancePolicy");
        _x.name = name;
        return _x;
    }

    /**
     * <i>“Platforms for this policy”</i>
     * 
     * @return property platforms
     */
    @Property(name="platforms")
    @JsonIgnore
    public Optional<DeviceManagementConfigurationPlatforms> getPlatforms() {
        return Optional.ofNullable(platforms);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code platforms} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Platforms for this policy”</i>
     * 
     * @param platforms
     *            new value of {@code platforms} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code platforms} field changed
     */
    public DeviceManagementCompliancePolicy withPlatforms(DeviceManagementConfigurationPlatforms platforms) {
        DeviceManagementCompliancePolicy _x = _copy();
        _x.changedFields = changedFields.add("platforms");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementCompliancePolicy");
        _x.platforms = platforms;
        return _x;
    }

    /**
     * <i>“List of Scope Tags for this Entity instance.”</i>
     * 
     * @return property roleScopeTagIds
     */
    @Property(name="roleScopeTagIds")
    @JsonIgnore
    public CollectionPage<String> getRoleScopeTagIds() {
        return new CollectionPage<String>(contextPath, String.class, this.roleScopeTagIds, Optional.ofNullable(roleScopeTagIdsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code roleScopeTagIds}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“List of Scope Tags for this Entity instance.”</i>
     * 
     * @param roleScopeTagIds
     *            new value of {@code roleScopeTagIds} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code roleScopeTagIds} field changed
     */
    public DeviceManagementCompliancePolicy withRoleScopeTagIds(List<String> roleScopeTagIds) {
        DeviceManagementCompliancePolicy _x = _copy();
        _x.changedFields = changedFields.add("roleScopeTagIds");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementCompliancePolicy");
        _x.roleScopeTagIds = roleScopeTagIds;
        return _x;
    }

    /**
     * <i>“List of Scope Tags for this Entity instance.”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property roleScopeTagIds
     */
    @Property(name="roleScopeTagIds")
    @JsonIgnore
    public CollectionPage<String> getRoleScopeTagIds(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.roleScopeTagIds, Optional.ofNullable(roleScopeTagIdsNextLink), Collections.emptyList(), options);
    }

    /**
     * <i>“Number of settings. This property is read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @return property settingCount
     */
    @Property(name="settingCount")
    @JsonIgnore
    public Optional<Integer> getSettingCount() {
        return Optional.ofNullable(settingCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code settingCount}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Number of settings. This property is read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @param settingCount
     *            new value of {@code settingCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code settingCount} field changed
     */
    public DeviceManagementCompliancePolicy withSettingCount(Integer settingCount) {
        DeviceManagementCompliancePolicy _x = _copy();
        _x.changedFields = changedFields.add("settingCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementCompliancePolicy");
        _x.settingCount = settingCount;
        return _x;
    }

    /**
     * <i>“Technologies for this policy”</i>
     * 
     * @return property technologies
     */
    @Property(name="technologies")
    @JsonIgnore
    public Optional<DeviceManagementConfigurationTechnologies> getTechnologies() {
        return Optional.ofNullable(technologies);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code technologies}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Technologies for this policy”</i>
     * 
     * @param technologies
     *            new value of {@code technologies} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code technologies} field changed
     */
    public DeviceManagementCompliancePolicy withTechnologies(DeviceManagementConfigurationTechnologies technologies) {
        DeviceManagementCompliancePolicy _x = _copy();
        _x.changedFields = changedFields.add("technologies");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementCompliancePolicy");
        _x.technologies = technologies;
        return _x;
    }

    public DeviceManagementCompliancePolicy withUnmappedField(String name, Object value) {
        DeviceManagementCompliancePolicy _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    /**
     * <i>“Policy assignments”</i>
     * 
     * @return navigational property assignments
     */
    @NavigationProperty(name="assignments")
    @JsonIgnore
    public DeviceManagementConfigurationPolicyAssignmentCollectionRequest getAssignments() {
        return new DeviceManagementConfigurationPolicyAssignmentCollectionRequest(
                        contextPath.addSegment("assignments"), Optional.ofNullable(assignments));
    }

    /**
     * <i>“The list of scheduled action for this rule”</i>
     * 
     * @return navigational property scheduledActionsForRule
     */
    @NavigationProperty(name="scheduledActionsForRule")
    @JsonIgnore
    public DeviceManagementComplianceScheduledActionForRuleCollectionRequest getScheduledActionsForRule() {
        return new DeviceManagementComplianceScheduledActionForRuleCollectionRequest(
                        contextPath.addSegment("scheduledActionsForRule"), Optional.ofNullable(scheduledActionsForRule));
    }

    /**
     * <i>“Policy settings”</i>
     * 
     * @return navigational property settings
     */
    @NavigationProperty(name="settings")
    @JsonIgnore
    public DeviceManagementConfigurationSettingCollectionRequest getSettings() {
        return new DeviceManagementConfigurationSettingCollectionRequest(
                        contextPath.addSegment("settings"), Optional.ofNullable(settings));
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code assignments}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Policy assignments”</i>
     * 
     * @param assignments
     *            new value of {@code assignments} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code assignments} field changed
     */
    public DeviceManagementCompliancePolicy withAssignments(List<DeviceManagementConfigurationPolicyAssignment> assignments) {
        DeviceManagementCompliancePolicy _x = _copy();
        _x.changedFields = changedFields.add("assignments");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementCompliancePolicy");
        _x.assignments = assignments;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * scheduledActionsForRule} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“The list of scheduled action for this rule”</i>
     * 
     * @param scheduledActionsForRule
     *            new value of {@code scheduledActionsForRule} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code scheduledActionsForRule} field changed
     */
    public DeviceManagementCompliancePolicy withScheduledActionsForRule(List<DeviceManagementComplianceScheduledActionForRule> scheduledActionsForRule) {
        DeviceManagementCompliancePolicy _x = _copy();
        _x.changedFields = changedFields.add("scheduledActionsForRule");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementCompliancePolicy");
        _x.scheduledActionsForRule = scheduledActionsForRule;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code settings} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Policy settings”</i>
     * 
     * @param settings
     *            new value of {@code settings} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code settings} field changed
     */
    public DeviceManagementCompliancePolicy withSettings(List<DeviceManagementConfigurationSetting> settings) {
        DeviceManagementCompliancePolicy _x = _copy();
        _x.changedFields = changedFields.add("settings");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementCompliancePolicy");
        _x.settings = settings;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DeviceManagementCompliancePolicy patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        DeviceManagementCompliancePolicy _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DeviceManagementCompliancePolicy put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        DeviceManagementCompliancePolicy _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private DeviceManagementCompliancePolicy _copy() {
        DeviceManagementCompliancePolicy _x = new DeviceManagementCompliancePolicy();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.createdDateTime = createdDateTime;
        _x.creationSource = creationSource;
        _x.description = description;
        _x.isAssigned = isAssigned;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.name = name;
        _x.platforms = platforms;
        _x.roleScopeTagIds = roleScopeTagIds;
        _x.settingCount = settingCount;
        _x.technologies = technologies;
        _x.assignments = assignments;
        _x.scheduledActionsForRule = scheduledActionsForRule;
        _x.settings = settings;
        return _x;
    }

    @Action(name = "assign")
    @JsonIgnore
    public CollectionPageNonEntityRequest<DeviceManagementConfigurationPolicyAssignment> assign(List<DeviceManagementConfigurationPolicyAssignment> assignments) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("assignments", "Collection(microsoft.graph.deviceManagementConfigurationPolicyAssignment)", assignments)
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.assign"), DeviceManagementConfigurationPolicyAssignment.class, _parameters);
    }

    @Action(name = "setScheduledActions")
    @JsonIgnore
    public CollectionPageNonEntityRequest<DeviceManagementComplianceScheduledActionForRule> setScheduledActions(List<DeviceManagementComplianceScheduledActionForRule> scheduledActions) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("scheduledActions", "Collection(microsoft.graph.deviceManagementComplianceScheduledActionForRule)", scheduledActions)
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.setScheduledActions"), DeviceManagementComplianceScheduledActionForRule.class, _parameters);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DeviceManagementCompliancePolicy[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("creationSource=");
        b.append(this.creationSource);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("isAssigned=");
        b.append(this.isAssigned);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("platforms=");
        b.append(this.platforms);
        b.append(", ");
        b.append("roleScopeTagIds=");
        b.append(this.roleScopeTagIds);
        b.append(", ");
        b.append("settingCount=");
        b.append(this.settingCount);
        b.append(", ");
        b.append("technologies=");
        b.append(this.technologies);
        b.append(", ");
        b.append("assignments=");
        b.append(this.assignments);
        b.append(", ");
        b.append("scheduledActionsForRule=");
        b.append(this.scheduledActionsForRule);
        b.append(", ");
        b.append("settings=");
        b.append(this.settings);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
