package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.enums.DeviceManagementComplianceActionType;


/**
 * <i>“Scheduled Action for Rule”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "actionType", 
    "gracePeriodHours", 
    "notificationMessageCCList", 
    "notificationTemplateId"})
@JsonInclude(Include.NON_NULL)
public class DeviceManagementComplianceActionItem extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.deviceManagementComplianceActionItem";
    }

    @JsonProperty("actionType")
    protected DeviceManagementComplianceActionType actionType;

    @JsonProperty("gracePeriodHours")
    protected Integer gracePeriodHours;

    @JsonProperty("notificationMessageCCList")
    protected List<String> notificationMessageCCList;

    @JsonProperty("notificationMessageCCList@nextLink")
    protected String notificationMessageCCListNextLink;

    @JsonProperty("notificationTemplateId")
    protected String notificationTemplateId;

    protected DeviceManagementComplianceActionItem() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderDeviceManagementComplianceActionItem() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private DeviceManagementComplianceActionType actionType;
        private Integer gracePeriodHours;
        private List<String> notificationMessageCCList;
        private String notificationMessageCCListNextLink;
        private String notificationTemplateId;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“What action to take”</i>
         * 
         * @param actionType
         *            value of {@code actionType} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder actionType(DeviceManagementComplianceActionType actionType) {
            this.actionType = actionType;
            this.changedFields = changedFields.add("actionType");
            return this;
        }

        /**
         * <i>“Number of hours to wait till the action will be enforced. Valid values 0 to 8760”</i>
         * 
         * @param gracePeriodHours
         *            value of {@code gracePeriodHours} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder gracePeriodHours(Integer gracePeriodHours) {
            this.gracePeriodHours = gracePeriodHours;
            this.changedFields = changedFields.add("gracePeriodHours");
            return this;
        }

        /**
         * <i>“A list of group IDs to speicify who to CC this notification message to. This
         * collection can contain a maximum of 100 elements.”</i>
         * 
         * @param notificationMessageCCList
         *            value of {@code notificationMessageCCList} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder notificationMessageCCList(List<String> notificationMessageCCList) {
            this.notificationMessageCCList = notificationMessageCCList;
            this.changedFields = changedFields.add("notificationMessageCCList");
            return this;
        }

        /**
         * <i>“A list of group IDs to speicify who to CC this notification message to. This
         * collection can contain a maximum of 100 elements.”</i>
         * 
         * @param notificationMessageCCList
         *            value of {@code notificationMessageCCList} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder notificationMessageCCList(String... notificationMessageCCList) {
            return notificationMessageCCList(Arrays.asList(notificationMessageCCList));
        }

        /**
         * <i>“A list of group IDs to speicify who to CC this notification message to. This
         * collection can contain a maximum of 100 elements.”</i>
         * 
         * @param notificationMessageCCListNextLink
         *            value of {@code notificationMessageCCList@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder notificationMessageCCListNextLink(String notificationMessageCCListNextLink) {
            this.notificationMessageCCListNextLink = notificationMessageCCListNextLink;
            this.changedFields = changedFields.add("notificationMessageCCList");
            return this;
        }

        /**
         * <i>“What notification Message template to use”</i>
         * 
         * @param notificationTemplateId
         *            value of {@code notificationTemplateId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder notificationTemplateId(String notificationTemplateId) {
            this.notificationTemplateId = notificationTemplateId;
            this.changedFields = changedFields.add("notificationTemplateId");
            return this;
        }

        public DeviceManagementComplianceActionItem build() {
            DeviceManagementComplianceActionItem _x = new DeviceManagementComplianceActionItem();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.deviceManagementComplianceActionItem";
            _x.id = id;
            _x.actionType = actionType;
            _x.gracePeriodHours = gracePeriodHours;
            _x.notificationMessageCCList = notificationMessageCCList;
            _x.notificationMessageCCListNextLink = notificationMessageCCListNextLink;
            _x.notificationTemplateId = notificationTemplateId;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“What action to take”</i>
     * 
     * @return property actionType
     */
    @Property(name="actionType")
    @JsonIgnore
    public Optional<DeviceManagementComplianceActionType> getActionType() {
        return Optional.ofNullable(actionType);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code actionType} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“What action to take”</i>
     * 
     * @param actionType
     *            new value of {@code actionType} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code actionType} field changed
     */
    public DeviceManagementComplianceActionItem withActionType(DeviceManagementComplianceActionType actionType) {
        DeviceManagementComplianceActionItem _x = _copy();
        _x.changedFields = changedFields.add("actionType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementComplianceActionItem");
        _x.actionType = actionType;
        return _x;
    }

    /**
     * <i>“Number of hours to wait till the action will be enforced. Valid values 0 to 8760”</i>
     * 
     * @return property gracePeriodHours
     */
    @Property(name="gracePeriodHours")
    @JsonIgnore
    public Optional<Integer> getGracePeriodHours() {
        return Optional.ofNullable(gracePeriodHours);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code gracePeriodHours}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Number of hours to wait till the action will be enforced. Valid values 0 to 8760”</i>
     * 
     * @param gracePeriodHours
     *            new value of {@code gracePeriodHours} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code gracePeriodHours} field changed
     */
    public DeviceManagementComplianceActionItem withGracePeriodHours(Integer gracePeriodHours) {
        DeviceManagementComplianceActionItem _x = _copy();
        _x.changedFields = changedFields.add("gracePeriodHours");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementComplianceActionItem");
        _x.gracePeriodHours = gracePeriodHours;
        return _x;
    }

    /**
     * <i>“A list of group IDs to speicify who to CC this notification message to. This
     * collection can contain a maximum of 100 elements.”</i>
     * 
     * @return property notificationMessageCCList
     */
    @Property(name="notificationMessageCCList")
    @JsonIgnore
    public CollectionPage<String> getNotificationMessageCCList() {
        return new CollectionPage<String>(contextPath, String.class, this.notificationMessageCCList, Optional.ofNullable(notificationMessageCCListNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * notificationMessageCCList} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“A list of group IDs to speicify who to CC this notification message to. This
     * collection can contain a maximum of 100 elements.”</i>
     * 
     * @param notificationMessageCCList
     *            new value of {@code notificationMessageCCList} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code notificationMessageCCList} field changed
     */
    public DeviceManagementComplianceActionItem withNotificationMessageCCList(List<String> notificationMessageCCList) {
        DeviceManagementComplianceActionItem _x = _copy();
        _x.changedFields = changedFields.add("notificationMessageCCList");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementComplianceActionItem");
        _x.notificationMessageCCList = notificationMessageCCList;
        return _x;
    }

    /**
     * <i>“A list of group IDs to speicify who to CC this notification message to. This
     * collection can contain a maximum of 100 elements.”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property notificationMessageCCList
     */
    @Property(name="notificationMessageCCList")
    @JsonIgnore
    public CollectionPage<String> getNotificationMessageCCList(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.notificationMessageCCList, Optional.ofNullable(notificationMessageCCListNextLink), Collections.emptyList(), options);
    }

    /**
     * <i>“What notification Message template to use”</i>
     * 
     * @return property notificationTemplateId
     */
    @Property(name="notificationTemplateId")
    @JsonIgnore
    public Optional<String> getNotificationTemplateId() {
        return Optional.ofNullable(notificationTemplateId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * notificationTemplateId} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“What notification Message template to use”</i>
     * 
     * @param notificationTemplateId
     *            new value of {@code notificationTemplateId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code notificationTemplateId} field changed
     */
    public DeviceManagementComplianceActionItem withNotificationTemplateId(String notificationTemplateId) {
        DeviceManagementComplianceActionItem _x = _copy();
        _x.changedFields = changedFields.add("notificationTemplateId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementComplianceActionItem");
        _x.notificationTemplateId = notificationTemplateId;
        return _x;
    }

    public DeviceManagementComplianceActionItem withUnmappedField(String name, Object value) {
        DeviceManagementComplianceActionItem _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DeviceManagementComplianceActionItem patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        DeviceManagementComplianceActionItem _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DeviceManagementComplianceActionItem put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        DeviceManagementComplianceActionItem _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private DeviceManagementComplianceActionItem _copy() {
        DeviceManagementComplianceActionItem _x = new DeviceManagementComplianceActionItem();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.actionType = actionType;
        _x.gracePeriodHours = gracePeriodHours;
        _x.notificationMessageCCList = notificationMessageCCList;
        _x.notificationTemplateId = notificationTemplateId;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DeviceManagementComplianceActionItem[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("actionType=");
        b.append(this.actionType);
        b.append(", ");
        b.append("gracePeriodHours=");
        b.append(this.gracePeriodHours);
        b.append(", ");
        b.append("notificationMessageCCList=");
        b.append(this.notificationMessageCCList);
        b.append(", ");
        b.append("notificationTemplateId=");
        b.append(this.notificationTemplateId);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
