package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.entity.collection.request.DeviceManagementAutopilotPolicyStatusDetailCollectionRequest;
import odata.msgraph.client.beta.enums.EnrollmentState;
import odata.msgraph.client.beta.enums.WindowsAutopilotDeploymentState;
import odata.msgraph.client.beta.enums.WindowsAutopilotEnrollmentType;


/**
 * <i>“Represents an Autopilot flow event.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "accountSetupDuration", 
    "accountSetupStatus", 
    "deploymentDuration", 
    "deploymentEndDateTime", 
    "deploymentStartDateTime", 
    "deploymentState", 
    "deploymentTotalDuration", 
    "deviceId", 
    "devicePreparationDuration", 
    "deviceRegisteredDateTime", 
    "deviceSerialNumber", 
    "deviceSetupDuration", 
    "deviceSetupStatus", 
    "enrollmentFailureDetails", 
    "enrollmentStartDateTime", 
    "enrollmentState", 
    "enrollmentType", 
    "eventDateTime", 
    "managedDeviceName", 
    "osVersion", 
    "targetedAppCount", 
    "targetedPolicyCount", 
    "userPrincipalName", 
    "windows10EnrollmentCompletionPageConfigurationDisplayName", 
    "windows10EnrollmentCompletionPageConfigurationId", 
    "windowsAutopilotDeploymentProfileDisplayName", 
    "policyStatusDetails"})
@JsonInclude(Include.NON_NULL)
public class DeviceManagementAutopilotEvent extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.deviceManagementAutopilotEvent";
    }

    @JsonProperty("accountSetupDuration")
    protected Duration accountSetupDuration;

    @JsonProperty("accountSetupStatus")
    protected WindowsAutopilotDeploymentState accountSetupStatus;

    @JsonProperty("deploymentDuration")
    protected Duration deploymentDuration;

    @JsonProperty("deploymentEndDateTime")
    protected OffsetDateTime deploymentEndDateTime;

    @JsonProperty("deploymentStartDateTime")
    protected OffsetDateTime deploymentStartDateTime;

    @JsonProperty("deploymentState")
    protected WindowsAutopilotDeploymentState deploymentState;

    @JsonProperty("deploymentTotalDuration")
    protected Duration deploymentTotalDuration;

    @JsonProperty("deviceId")
    protected String deviceId;

    @JsonProperty("devicePreparationDuration")
    protected Duration devicePreparationDuration;

    @JsonProperty("deviceRegisteredDateTime")
    protected OffsetDateTime deviceRegisteredDateTime;

    @JsonProperty("deviceSerialNumber")
    protected String deviceSerialNumber;

    @JsonProperty("deviceSetupDuration")
    protected Duration deviceSetupDuration;

    @JsonProperty("deviceSetupStatus")
    protected WindowsAutopilotDeploymentState deviceSetupStatus;

    @JsonProperty("enrollmentFailureDetails")
    protected String enrollmentFailureDetails;

    @JsonProperty("enrollmentStartDateTime")
    protected OffsetDateTime enrollmentStartDateTime;

    @JsonProperty("enrollmentState")
    protected EnrollmentState enrollmentState;

    @JsonProperty("enrollmentType")
    protected WindowsAutopilotEnrollmentType enrollmentType;

    @JsonProperty("eventDateTime")
    protected OffsetDateTime eventDateTime;

    @JsonProperty("managedDeviceName")
    protected String managedDeviceName;

    @JsonProperty("osVersion")
    protected String osVersion;

    @JsonProperty("targetedAppCount")
    protected Integer targetedAppCount;

    @JsonProperty("targetedPolicyCount")
    protected Integer targetedPolicyCount;

    @JsonProperty("userPrincipalName")
    protected String userPrincipalName;

    @JsonProperty("windows10EnrollmentCompletionPageConfigurationDisplayName")
    protected String windows10EnrollmentCompletionPageConfigurationDisplayName;

    @JsonProperty("windows10EnrollmentCompletionPageConfigurationId")
    protected String windows10EnrollmentCompletionPageConfigurationId;

    @JsonProperty("windowsAutopilotDeploymentProfileDisplayName")
    protected String windowsAutopilotDeploymentProfileDisplayName;

    @JsonProperty("policyStatusDetails")
    protected List<DeviceManagementAutopilotPolicyStatusDetail> policyStatusDetails;

    protected DeviceManagementAutopilotEvent() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderDeviceManagementAutopilotEvent() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private Duration accountSetupDuration;
        private WindowsAutopilotDeploymentState accountSetupStatus;
        private Duration deploymentDuration;
        private OffsetDateTime deploymentEndDateTime;
        private OffsetDateTime deploymentStartDateTime;
        private WindowsAutopilotDeploymentState deploymentState;
        private Duration deploymentTotalDuration;
        private String deviceId;
        private Duration devicePreparationDuration;
        private OffsetDateTime deviceRegisteredDateTime;
        private String deviceSerialNumber;
        private Duration deviceSetupDuration;
        private WindowsAutopilotDeploymentState deviceSetupStatus;
        private String enrollmentFailureDetails;
        private OffsetDateTime enrollmentStartDateTime;
        private EnrollmentState enrollmentState;
        private WindowsAutopilotEnrollmentType enrollmentType;
        private OffsetDateTime eventDateTime;
        private String managedDeviceName;
        private String osVersion;
        private Integer targetedAppCount;
        private Integer targetedPolicyCount;
        private String userPrincipalName;
        private String windows10EnrollmentCompletionPageConfigurationDisplayName;
        private String windows10EnrollmentCompletionPageConfigurationId;
        private String windowsAutopilotDeploymentProfileDisplayName;
        private List<DeviceManagementAutopilotPolicyStatusDetail> policyStatusDetails;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“Time spent in user ESP.”</i>
         * 
         * @param accountSetupDuration
         *            value of {@code accountSetupDuration} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder accountSetupDuration(Duration accountSetupDuration) {
            this.accountSetupDuration = accountSetupDuration;
            this.changedFields = changedFields.add("accountSetupDuration");
            return this;
        }

        /**
         * <i>“Deployment status for the enrollment status page account setup phase.”</i>
         * 
         * @param accountSetupStatus
         *            value of {@code accountSetupStatus} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder accountSetupStatus(WindowsAutopilotDeploymentState accountSetupStatus) {
            this.accountSetupStatus = accountSetupStatus;
            this.changedFields = changedFields.add("accountSetupStatus");
            return this;
        }

        /**
         * <i>“Autopilot deployment duration including enrollment.”</i>
         * 
         * @param deploymentDuration
         *            value of {@code deploymentDuration} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deploymentDuration(Duration deploymentDuration) {
            this.deploymentDuration = deploymentDuration;
            this.changedFields = changedFields.add("deploymentDuration");
            return this;
        }

        /**
         * <i>“Deployment end time.”</i>
         * 
         * @param deploymentEndDateTime
         *            value of {@code deploymentEndDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deploymentEndDateTime(OffsetDateTime deploymentEndDateTime) {
            this.deploymentEndDateTime = deploymentEndDateTime;
            this.changedFields = changedFields.add("deploymentEndDateTime");
            return this;
        }

        /**
         * <i>“Deployment start time.”</i>
         * 
         * @param deploymentStartDateTime
         *            value of {@code deploymentStartDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deploymentStartDateTime(OffsetDateTime deploymentStartDateTime) {
            this.deploymentStartDateTime = deploymentStartDateTime;
            this.changedFields = changedFields.add("deploymentStartDateTime");
            return this;
        }

        /**
         * <i>“Deployment state like Success, Failure, InProgress, SuccessWithTimeout.”</i>
         * 
         * @param deploymentState
         *            value of {@code deploymentState} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deploymentState(WindowsAutopilotDeploymentState deploymentState) {
            this.deploymentState = deploymentState;
            this.changedFields = changedFields.add("deploymentState");
            return this;
        }

        /**
         * <i>“Total deployment duration from enrollment to Desktop screen.”</i>
         * 
         * @param deploymentTotalDuration
         *            value of {@code deploymentTotalDuration} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deploymentTotalDuration(Duration deploymentTotalDuration) {
            this.deploymentTotalDuration = deploymentTotalDuration;
            this.changedFields = changedFields.add("deploymentTotalDuration");
            return this;
        }

        /**
         * <i>“Device id associated with the object”</i>
         * 
         * @param deviceId
         *            value of {@code deviceId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceId(String deviceId) {
            this.deviceId = deviceId;
            this.changedFields = changedFields.add("deviceId");
            return this;
        }

        /**
         * <i>“Time spent in device enrollment.”</i>
         * 
         * @param devicePreparationDuration
         *            value of {@code devicePreparationDuration} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder devicePreparationDuration(Duration devicePreparationDuration) {
            this.devicePreparationDuration = devicePreparationDuration;
            this.changedFields = changedFields.add("devicePreparationDuration");
            return this;
        }

        /**
         * <i>“Device registration date.”</i>
         * 
         * @param deviceRegisteredDateTime
         *            value of {@code deviceRegisteredDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceRegisteredDateTime(OffsetDateTime deviceRegisteredDateTime) {
            this.deviceRegisteredDateTime = deviceRegisteredDateTime;
            this.changedFields = changedFields.add("deviceRegisteredDateTime");
            return this;
        }

        /**
         * <i>“Device serial number.”</i>
         * 
         * @param deviceSerialNumber
         *            value of {@code deviceSerialNumber} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceSerialNumber(String deviceSerialNumber) {
            this.deviceSerialNumber = deviceSerialNumber;
            this.changedFields = changedFields.add("deviceSerialNumber");
            return this;
        }

        /**
         * <i>“Time spent in device ESP.”</i>
         * 
         * @param deviceSetupDuration
         *            value of {@code deviceSetupDuration} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceSetupDuration(Duration deviceSetupDuration) {
            this.deviceSetupDuration = deviceSetupDuration;
            this.changedFields = changedFields.add("deviceSetupDuration");
            return this;
        }

        /**
         * <i>“Deployment status for the enrollment status page device setup phase.”</i>
         * 
         * @param deviceSetupStatus
         *            value of {@code deviceSetupStatus} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceSetupStatus(WindowsAutopilotDeploymentState deviceSetupStatus) {
            this.deviceSetupStatus = deviceSetupStatus;
            this.changedFields = changedFields.add("deviceSetupStatus");
            return this;
        }

        /**
         * <i>“Enrollment failure details.”</i>
         * 
         * @param enrollmentFailureDetails
         *            value of {@code enrollmentFailureDetails} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder enrollmentFailureDetails(String enrollmentFailureDetails) {
            this.enrollmentFailureDetails = enrollmentFailureDetails;
            this.changedFields = changedFields.add("enrollmentFailureDetails");
            return this;
        }

        /**
         * <i>“Device enrollment start date.”</i>
         * 
         * @param enrollmentStartDateTime
         *            value of {@code enrollmentStartDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder enrollmentStartDateTime(OffsetDateTime enrollmentStartDateTime) {
            this.enrollmentStartDateTime = enrollmentStartDateTime;
            this.changedFields = changedFields.add("enrollmentStartDateTime");
            return this;
        }

        /**
         * <i>“Enrollment state like Enrolled, Failed.”</i>
         * 
         * @param enrollmentState
         *            value of {@code enrollmentState} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder enrollmentState(EnrollmentState enrollmentState) {
            this.enrollmentState = enrollmentState;
            this.changedFields = changedFields.add("enrollmentState");
            return this;
        }

        /**
         * <i>“Enrollment type.”</i>
         * 
         * @param enrollmentType
         *            value of {@code enrollmentType} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder enrollmentType(WindowsAutopilotEnrollmentType enrollmentType) {
            this.enrollmentType = enrollmentType;
            this.changedFields = changedFields.add("enrollmentType");
            return this;
        }

        /**
         * <i>“Time when the event occurred .”</i>
         * 
         * @param eventDateTime
         *            value of {@code eventDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder eventDateTime(OffsetDateTime eventDateTime) {
            this.eventDateTime = eventDateTime;
            this.changedFields = changedFields.add("eventDateTime");
            return this;
        }

        /**
         * <i>“Managed device name.”</i>
         * 
         * @param managedDeviceName
         *            value of {@code managedDeviceName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder managedDeviceName(String managedDeviceName) {
            this.managedDeviceName = managedDeviceName;
            this.changedFields = changedFields.add("managedDeviceName");
            return this;
        }

        /**
         * <i>“Device operating system version.”</i>
         * 
         * @param osVersion
         *            value of {@code osVersion} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder osVersion(String osVersion) {
            this.osVersion = osVersion;
            this.changedFields = changedFields.add("osVersion");
            return this;
        }

        /**
         * <i>“Count of applications targeted.”</i>
         * 
         * @param targetedAppCount
         *            value of {@code targetedAppCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder targetedAppCount(Integer targetedAppCount) {
            this.targetedAppCount = targetedAppCount;
            this.changedFields = changedFields.add("targetedAppCount");
            return this;
        }

        /**
         * <i>“Count of policies targeted.”</i>
         * 
         * @param targetedPolicyCount
         *            value of {@code targetedPolicyCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder targetedPolicyCount(Integer targetedPolicyCount) {
            this.targetedPolicyCount = targetedPolicyCount;
            this.changedFields = changedFields.add("targetedPolicyCount");
            return this;
        }

        /**
         * <i>“User principal name used to enroll the device.”</i>
         * 
         * @param userPrincipalName
         *            value of {@code userPrincipalName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userPrincipalName(String userPrincipalName) {
            this.userPrincipalName = userPrincipalName;
            this.changedFields = changedFields.add("userPrincipalName");
            return this;
        }

        /**
         * <i>“Enrollment Status Page profile name”</i>
         * 
         * @param windows10EnrollmentCompletionPageConfigurationDisplayName
         *            value of {@code windows10EnrollmentCompletionPageConfigurationDisplayName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder windows10EnrollmentCompletionPageConfigurationDisplayName(String windows10EnrollmentCompletionPageConfigurationDisplayName) {
            this.windows10EnrollmentCompletionPageConfigurationDisplayName = windows10EnrollmentCompletionPageConfigurationDisplayName;
            this.changedFields = changedFields.add("windows10EnrollmentCompletionPageConfigurationDisplayName");
            return this;
        }

        /**
         * <i>“Enrollment Status Page profile ID”</i>
         * 
         * @param windows10EnrollmentCompletionPageConfigurationId
         *            value of {@code windows10EnrollmentCompletionPageConfigurationId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder windows10EnrollmentCompletionPageConfigurationId(String windows10EnrollmentCompletionPageConfigurationId) {
            this.windows10EnrollmentCompletionPageConfigurationId = windows10EnrollmentCompletionPageConfigurationId;
            this.changedFields = changedFields.add("windows10EnrollmentCompletionPageConfigurationId");
            return this;
        }

        /**
         * <i>“Autopilot profile name.”</i>
         * 
         * @param windowsAutopilotDeploymentProfileDisplayName
         *            value of {@code windowsAutopilotDeploymentProfileDisplayName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder windowsAutopilotDeploymentProfileDisplayName(String windowsAutopilotDeploymentProfileDisplayName) {
            this.windowsAutopilotDeploymentProfileDisplayName = windowsAutopilotDeploymentProfileDisplayName;
            this.changedFields = changedFields.add("windowsAutopilotDeploymentProfileDisplayName");
            return this;
        }

        /**
         * <i>“Policy and application status details for this device.”</i>
         * 
         * @param policyStatusDetails
         *            value of {@code policyStatusDetails} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder policyStatusDetails(List<DeviceManagementAutopilotPolicyStatusDetail> policyStatusDetails) {
            this.policyStatusDetails = policyStatusDetails;
            this.changedFields = changedFields.add("policyStatusDetails");
            return this;
        }

        /**
         * <i>“Policy and application status details for this device.”</i>
         * 
         * @param policyStatusDetails
         *            value of {@code policyStatusDetails} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder policyStatusDetails(DeviceManagementAutopilotPolicyStatusDetail... policyStatusDetails) {
            return policyStatusDetails(Arrays.asList(policyStatusDetails));
        }

        public DeviceManagementAutopilotEvent build() {
            DeviceManagementAutopilotEvent _x = new DeviceManagementAutopilotEvent();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.deviceManagementAutopilotEvent";
            _x.id = id;
            _x.accountSetupDuration = accountSetupDuration;
            _x.accountSetupStatus = accountSetupStatus;
            _x.deploymentDuration = deploymentDuration;
            _x.deploymentEndDateTime = deploymentEndDateTime;
            _x.deploymentStartDateTime = deploymentStartDateTime;
            _x.deploymentState = deploymentState;
            _x.deploymentTotalDuration = deploymentTotalDuration;
            _x.deviceId = deviceId;
            _x.devicePreparationDuration = devicePreparationDuration;
            _x.deviceRegisteredDateTime = deviceRegisteredDateTime;
            _x.deviceSerialNumber = deviceSerialNumber;
            _x.deviceSetupDuration = deviceSetupDuration;
            _x.deviceSetupStatus = deviceSetupStatus;
            _x.enrollmentFailureDetails = enrollmentFailureDetails;
            _x.enrollmentStartDateTime = enrollmentStartDateTime;
            _x.enrollmentState = enrollmentState;
            _x.enrollmentType = enrollmentType;
            _x.eventDateTime = eventDateTime;
            _x.managedDeviceName = managedDeviceName;
            _x.osVersion = osVersion;
            _x.targetedAppCount = targetedAppCount;
            _x.targetedPolicyCount = targetedPolicyCount;
            _x.userPrincipalName = userPrincipalName;
            _x.windows10EnrollmentCompletionPageConfigurationDisplayName = windows10EnrollmentCompletionPageConfigurationDisplayName;
            _x.windows10EnrollmentCompletionPageConfigurationId = windows10EnrollmentCompletionPageConfigurationId;
            _x.windowsAutopilotDeploymentProfileDisplayName = windowsAutopilotDeploymentProfileDisplayName;
            _x.policyStatusDetails = policyStatusDetails;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“Time spent in user ESP.”</i>
     * 
     * @return property accountSetupDuration
     */
    @Property(name="accountSetupDuration")
    @JsonIgnore
    public Optional<Duration> getAccountSetupDuration() {
        return Optional.ofNullable(accountSetupDuration);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * accountSetupDuration} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Time spent in user ESP.”</i>
     * 
     * @param accountSetupDuration
     *            new value of {@code accountSetupDuration} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code accountSetupDuration} field changed
     */
    public DeviceManagementAutopilotEvent withAccountSetupDuration(Duration accountSetupDuration) {
        DeviceManagementAutopilotEvent _x = _copy();
        _x.changedFields = changedFields.add("accountSetupDuration");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementAutopilotEvent");
        _x.accountSetupDuration = accountSetupDuration;
        return _x;
    }

    /**
     * <i>“Deployment status for the enrollment status page account setup phase.”</i>
     * 
     * @return property accountSetupStatus
     */
    @Property(name="accountSetupStatus")
    @JsonIgnore
    public Optional<WindowsAutopilotDeploymentState> getAccountSetupStatus() {
        return Optional.ofNullable(accountSetupStatus);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * accountSetupStatus} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Deployment status for the enrollment status page account setup phase.”</i>
     * 
     * @param accountSetupStatus
     *            new value of {@code accountSetupStatus} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code accountSetupStatus} field changed
     */
    public DeviceManagementAutopilotEvent withAccountSetupStatus(WindowsAutopilotDeploymentState accountSetupStatus) {
        DeviceManagementAutopilotEvent _x = _copy();
        _x.changedFields = changedFields.add("accountSetupStatus");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementAutopilotEvent");
        _x.accountSetupStatus = accountSetupStatus;
        return _x;
    }

    /**
     * <i>“Autopilot deployment duration including enrollment.”</i>
     * 
     * @return property deploymentDuration
     */
    @Property(name="deploymentDuration")
    @JsonIgnore
    public Optional<Duration> getDeploymentDuration() {
        return Optional.ofNullable(deploymentDuration);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * deploymentDuration} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Autopilot deployment duration including enrollment.”</i>
     * 
     * @param deploymentDuration
     *            new value of {@code deploymentDuration} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deploymentDuration} field changed
     */
    public DeviceManagementAutopilotEvent withDeploymentDuration(Duration deploymentDuration) {
        DeviceManagementAutopilotEvent _x = _copy();
        _x.changedFields = changedFields.add("deploymentDuration");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementAutopilotEvent");
        _x.deploymentDuration = deploymentDuration;
        return _x;
    }

    /**
     * <i>“Deployment end time.”</i>
     * 
     * @return property deploymentEndDateTime
     */
    @Property(name="deploymentEndDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getDeploymentEndDateTime() {
        return Optional.ofNullable(deploymentEndDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * deploymentEndDateTime} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Deployment end time.”</i>
     * 
     * @param deploymentEndDateTime
     *            new value of {@code deploymentEndDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deploymentEndDateTime} field changed
     */
    public DeviceManagementAutopilotEvent withDeploymentEndDateTime(OffsetDateTime deploymentEndDateTime) {
        DeviceManagementAutopilotEvent _x = _copy();
        _x.changedFields = changedFields.add("deploymentEndDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementAutopilotEvent");
        _x.deploymentEndDateTime = deploymentEndDateTime;
        return _x;
    }

    /**
     * <i>“Deployment start time.”</i>
     * 
     * @return property deploymentStartDateTime
     */
    @Property(name="deploymentStartDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getDeploymentStartDateTime() {
        return Optional.ofNullable(deploymentStartDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * deploymentStartDateTime} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Deployment start time.”</i>
     * 
     * @param deploymentStartDateTime
     *            new value of {@code deploymentStartDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deploymentStartDateTime} field changed
     */
    public DeviceManagementAutopilotEvent withDeploymentStartDateTime(OffsetDateTime deploymentStartDateTime) {
        DeviceManagementAutopilotEvent _x = _copy();
        _x.changedFields = changedFields.add("deploymentStartDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementAutopilotEvent");
        _x.deploymentStartDateTime = deploymentStartDateTime;
        return _x;
    }

    /**
     * <i>“Deployment state like Success, Failure, InProgress, SuccessWithTimeout.”</i>
     * 
     * @return property deploymentState
     */
    @Property(name="deploymentState")
    @JsonIgnore
    public Optional<WindowsAutopilotDeploymentState> getDeploymentState() {
        return Optional.ofNullable(deploymentState);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code deploymentState}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Deployment state like Success, Failure, InProgress, SuccessWithTimeout.”</i>
     * 
     * @param deploymentState
     *            new value of {@code deploymentState} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deploymentState} field changed
     */
    public DeviceManagementAutopilotEvent withDeploymentState(WindowsAutopilotDeploymentState deploymentState) {
        DeviceManagementAutopilotEvent _x = _copy();
        _x.changedFields = changedFields.add("deploymentState");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementAutopilotEvent");
        _x.deploymentState = deploymentState;
        return _x;
    }

    /**
     * <i>“Total deployment duration from enrollment to Desktop screen.”</i>
     * 
     * @return property deploymentTotalDuration
     */
    @Property(name="deploymentTotalDuration")
    @JsonIgnore
    public Optional<Duration> getDeploymentTotalDuration() {
        return Optional.ofNullable(deploymentTotalDuration);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * deploymentTotalDuration} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Total deployment duration from enrollment to Desktop screen.”</i>
     * 
     * @param deploymentTotalDuration
     *            new value of {@code deploymentTotalDuration} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deploymentTotalDuration} field changed
     */
    public DeviceManagementAutopilotEvent withDeploymentTotalDuration(Duration deploymentTotalDuration) {
        DeviceManagementAutopilotEvent _x = _copy();
        _x.changedFields = changedFields.add("deploymentTotalDuration");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementAutopilotEvent");
        _x.deploymentTotalDuration = deploymentTotalDuration;
        return _x;
    }

    /**
     * <i>“Device id associated with the object”</i>
     * 
     * @return property deviceId
     */
    @Property(name="deviceId")
    @JsonIgnore
    public Optional<String> getDeviceId() {
        return Optional.ofNullable(deviceId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code deviceId} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Device id associated with the object”</i>
     * 
     * @param deviceId
     *            new value of {@code deviceId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceId} field changed
     */
    public DeviceManagementAutopilotEvent withDeviceId(String deviceId) {
        DeviceManagementAutopilotEvent _x = _copy();
        _x.changedFields = changedFields.add("deviceId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementAutopilotEvent");
        _x.deviceId = deviceId;
        return _x;
    }

    /**
     * <i>“Time spent in device enrollment.”</i>
     * 
     * @return property devicePreparationDuration
     */
    @Property(name="devicePreparationDuration")
    @JsonIgnore
    public Optional<Duration> getDevicePreparationDuration() {
        return Optional.ofNullable(devicePreparationDuration);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * devicePreparationDuration} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Time spent in device enrollment.”</i>
     * 
     * @param devicePreparationDuration
     *            new value of {@code devicePreparationDuration} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code devicePreparationDuration} field changed
     */
    public DeviceManagementAutopilotEvent withDevicePreparationDuration(Duration devicePreparationDuration) {
        DeviceManagementAutopilotEvent _x = _copy();
        _x.changedFields = changedFields.add("devicePreparationDuration");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementAutopilotEvent");
        _x.devicePreparationDuration = devicePreparationDuration;
        return _x;
    }

    /**
     * <i>“Device registration date.”</i>
     * 
     * @return property deviceRegisteredDateTime
     */
    @Property(name="deviceRegisteredDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getDeviceRegisteredDateTime() {
        return Optional.ofNullable(deviceRegisteredDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * deviceRegisteredDateTime} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Device registration date.”</i>
     * 
     * @param deviceRegisteredDateTime
     *            new value of {@code deviceRegisteredDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceRegisteredDateTime} field changed
     */
    public DeviceManagementAutopilotEvent withDeviceRegisteredDateTime(OffsetDateTime deviceRegisteredDateTime) {
        DeviceManagementAutopilotEvent _x = _copy();
        _x.changedFields = changedFields.add("deviceRegisteredDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementAutopilotEvent");
        _x.deviceRegisteredDateTime = deviceRegisteredDateTime;
        return _x;
    }

    /**
     * <i>“Device serial number.”</i>
     * 
     * @return property deviceSerialNumber
     */
    @Property(name="deviceSerialNumber")
    @JsonIgnore
    public Optional<String> getDeviceSerialNumber() {
        return Optional.ofNullable(deviceSerialNumber);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * deviceSerialNumber} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Device serial number.”</i>
     * 
     * @param deviceSerialNumber
     *            new value of {@code deviceSerialNumber} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceSerialNumber} field changed
     */
    public DeviceManagementAutopilotEvent withDeviceSerialNumber(String deviceSerialNumber) {
        DeviceManagementAutopilotEvent _x = _copy();
        _x.changedFields = changedFields.add("deviceSerialNumber");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementAutopilotEvent");
        _x.deviceSerialNumber = deviceSerialNumber;
        return _x;
    }

    /**
     * <i>“Time spent in device ESP.”</i>
     * 
     * @return property deviceSetupDuration
     */
    @Property(name="deviceSetupDuration")
    @JsonIgnore
    public Optional<Duration> getDeviceSetupDuration() {
        return Optional.ofNullable(deviceSetupDuration);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * deviceSetupDuration} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Time spent in device ESP.”</i>
     * 
     * @param deviceSetupDuration
     *            new value of {@code deviceSetupDuration} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceSetupDuration} field changed
     */
    public DeviceManagementAutopilotEvent withDeviceSetupDuration(Duration deviceSetupDuration) {
        DeviceManagementAutopilotEvent _x = _copy();
        _x.changedFields = changedFields.add("deviceSetupDuration");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementAutopilotEvent");
        _x.deviceSetupDuration = deviceSetupDuration;
        return _x;
    }

    /**
     * <i>“Deployment status for the enrollment status page device setup phase.”</i>
     * 
     * @return property deviceSetupStatus
     */
    @Property(name="deviceSetupStatus")
    @JsonIgnore
    public Optional<WindowsAutopilotDeploymentState> getDeviceSetupStatus() {
        return Optional.ofNullable(deviceSetupStatus);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code deviceSetupStatus
     * } field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Deployment status for the enrollment status page device setup phase.”</i>
     * 
     * @param deviceSetupStatus
     *            new value of {@code deviceSetupStatus} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceSetupStatus} field changed
     */
    public DeviceManagementAutopilotEvent withDeviceSetupStatus(WindowsAutopilotDeploymentState deviceSetupStatus) {
        DeviceManagementAutopilotEvent _x = _copy();
        _x.changedFields = changedFields.add("deviceSetupStatus");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementAutopilotEvent");
        _x.deviceSetupStatus = deviceSetupStatus;
        return _x;
    }

    /**
     * <i>“Enrollment failure details.”</i>
     * 
     * @return property enrollmentFailureDetails
     */
    @Property(name="enrollmentFailureDetails")
    @JsonIgnore
    public Optional<String> getEnrollmentFailureDetails() {
        return Optional.ofNullable(enrollmentFailureDetails);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * enrollmentFailureDetails} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Enrollment failure details.”</i>
     * 
     * @param enrollmentFailureDetails
     *            new value of {@code enrollmentFailureDetails} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code enrollmentFailureDetails} field changed
     */
    public DeviceManagementAutopilotEvent withEnrollmentFailureDetails(String enrollmentFailureDetails) {
        DeviceManagementAutopilotEvent _x = _copy();
        _x.changedFields = changedFields.add("enrollmentFailureDetails");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementAutopilotEvent");
        _x.enrollmentFailureDetails = enrollmentFailureDetails;
        return _x;
    }

    /**
     * <i>“Device enrollment start date.”</i>
     * 
     * @return property enrollmentStartDateTime
     */
    @Property(name="enrollmentStartDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getEnrollmentStartDateTime() {
        return Optional.ofNullable(enrollmentStartDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * enrollmentStartDateTime} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Device enrollment start date.”</i>
     * 
     * @param enrollmentStartDateTime
     *            new value of {@code enrollmentStartDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code enrollmentStartDateTime} field changed
     */
    public DeviceManagementAutopilotEvent withEnrollmentStartDateTime(OffsetDateTime enrollmentStartDateTime) {
        DeviceManagementAutopilotEvent _x = _copy();
        _x.changedFields = changedFields.add("enrollmentStartDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementAutopilotEvent");
        _x.enrollmentStartDateTime = enrollmentStartDateTime;
        return _x;
    }

    /**
     * <i>“Enrollment state like Enrolled, Failed.”</i>
     * 
     * @return property enrollmentState
     */
    @Property(name="enrollmentState")
    @JsonIgnore
    public Optional<EnrollmentState> getEnrollmentState() {
        return Optional.ofNullable(enrollmentState);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code enrollmentState}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Enrollment state like Enrolled, Failed.”</i>
     * 
     * @param enrollmentState
     *            new value of {@code enrollmentState} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code enrollmentState} field changed
     */
    public DeviceManagementAutopilotEvent withEnrollmentState(EnrollmentState enrollmentState) {
        DeviceManagementAutopilotEvent _x = _copy();
        _x.changedFields = changedFields.add("enrollmentState");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementAutopilotEvent");
        _x.enrollmentState = enrollmentState;
        return _x;
    }

    /**
     * <i>“Enrollment type.”</i>
     * 
     * @return property enrollmentType
     */
    @Property(name="enrollmentType")
    @JsonIgnore
    public Optional<WindowsAutopilotEnrollmentType> getEnrollmentType() {
        return Optional.ofNullable(enrollmentType);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code enrollmentType}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Enrollment type.”</i>
     * 
     * @param enrollmentType
     *            new value of {@code enrollmentType} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code enrollmentType} field changed
     */
    public DeviceManagementAutopilotEvent withEnrollmentType(WindowsAutopilotEnrollmentType enrollmentType) {
        DeviceManagementAutopilotEvent _x = _copy();
        _x.changedFields = changedFields.add("enrollmentType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementAutopilotEvent");
        _x.enrollmentType = enrollmentType;
        return _x;
    }

    /**
     * <i>“Time when the event occurred .”</i>
     * 
     * @return property eventDateTime
     */
    @Property(name="eventDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getEventDateTime() {
        return Optional.ofNullable(eventDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code eventDateTime}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Time when the event occurred .”</i>
     * 
     * @param eventDateTime
     *            new value of {@code eventDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code eventDateTime} field changed
     */
    public DeviceManagementAutopilotEvent withEventDateTime(OffsetDateTime eventDateTime) {
        DeviceManagementAutopilotEvent _x = _copy();
        _x.changedFields = changedFields.add("eventDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementAutopilotEvent");
        _x.eventDateTime = eventDateTime;
        return _x;
    }

    /**
     * <i>“Managed device name.”</i>
     * 
     * @return property managedDeviceName
     */
    @Property(name="managedDeviceName")
    @JsonIgnore
    public Optional<String> getManagedDeviceName() {
        return Optional.ofNullable(managedDeviceName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code managedDeviceName
     * } field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Managed device name.”</i>
     * 
     * @param managedDeviceName
     *            new value of {@code managedDeviceName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code managedDeviceName} field changed
     */
    public DeviceManagementAutopilotEvent withManagedDeviceName(String managedDeviceName) {
        DeviceManagementAutopilotEvent _x = _copy();
        _x.changedFields = changedFields.add("managedDeviceName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementAutopilotEvent");
        _x.managedDeviceName = managedDeviceName;
        return _x;
    }

    /**
     * <i>“Device operating system version.”</i>
     * 
     * @return property osVersion
     */
    @Property(name="osVersion")
    @JsonIgnore
    public Optional<String> getOsVersion() {
        return Optional.ofNullable(osVersion);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code osVersion} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Device operating system version.”</i>
     * 
     * @param osVersion
     *            new value of {@code osVersion} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code osVersion} field changed
     */
    public DeviceManagementAutopilotEvent withOsVersion(String osVersion) {
        DeviceManagementAutopilotEvent _x = _copy();
        _x.changedFields = changedFields.add("osVersion");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementAutopilotEvent");
        _x.osVersion = osVersion;
        return _x;
    }

    /**
     * <i>“Count of applications targeted.”</i>
     * 
     * @return property targetedAppCount
     */
    @Property(name="targetedAppCount")
    @JsonIgnore
    public Optional<Integer> getTargetedAppCount() {
        return Optional.ofNullable(targetedAppCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code targetedAppCount}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Count of applications targeted.”</i>
     * 
     * @param targetedAppCount
     *            new value of {@code targetedAppCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code targetedAppCount} field changed
     */
    public DeviceManagementAutopilotEvent withTargetedAppCount(Integer targetedAppCount) {
        DeviceManagementAutopilotEvent _x = _copy();
        _x.changedFields = changedFields.add("targetedAppCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementAutopilotEvent");
        _x.targetedAppCount = targetedAppCount;
        return _x;
    }

    /**
     * <i>“Count of policies targeted.”</i>
     * 
     * @return property targetedPolicyCount
     */
    @Property(name="targetedPolicyCount")
    @JsonIgnore
    public Optional<Integer> getTargetedPolicyCount() {
        return Optional.ofNullable(targetedPolicyCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * targetedPolicyCount} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Count of policies targeted.”</i>
     * 
     * @param targetedPolicyCount
     *            new value of {@code targetedPolicyCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code targetedPolicyCount} field changed
     */
    public DeviceManagementAutopilotEvent withTargetedPolicyCount(Integer targetedPolicyCount) {
        DeviceManagementAutopilotEvent _x = _copy();
        _x.changedFields = changedFields.add("targetedPolicyCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementAutopilotEvent");
        _x.targetedPolicyCount = targetedPolicyCount;
        return _x;
    }

    /**
     * <i>“User principal name used to enroll the device.”</i>
     * 
     * @return property userPrincipalName
     */
    @Property(name="userPrincipalName")
    @JsonIgnore
    public Optional<String> getUserPrincipalName() {
        return Optional.ofNullable(userPrincipalName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code userPrincipalName
     * } field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“User principal name used to enroll the device.”</i>
     * 
     * @param userPrincipalName
     *            new value of {@code userPrincipalName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code userPrincipalName} field changed
     */
    public DeviceManagementAutopilotEvent withUserPrincipalName(String userPrincipalName) {
        DeviceManagementAutopilotEvent _x = _copy();
        _x.changedFields = changedFields.add("userPrincipalName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementAutopilotEvent");
        _x.userPrincipalName = userPrincipalName;
        return _x;
    }

    /**
     * <i>“Enrollment Status Page profile name”</i>
     * 
     * @return property windows10EnrollmentCompletionPageConfigurationDisplayName
     */
    @Property(name="windows10EnrollmentCompletionPageConfigurationDisplayName")
    @JsonIgnore
    public Optional<String> getWindows10EnrollmentCompletionPageConfigurationDisplayName() {
        return Optional.ofNullable(windows10EnrollmentCompletionPageConfigurationDisplayName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * windows10EnrollmentCompletionPageConfigurationDisplayName} field changed. Field
     * description below. The field name is also added to an internal map of changed
     * fields in the returned object so that when {@code this.patch()} is called (if
     * available)on the returned object only the changed fields are submitted.
     * <p>
     * <i>“Enrollment Status Page profile name”</i>
     * 
     * @param windows10EnrollmentCompletionPageConfigurationDisplayName
     *            new value of {@code windows10EnrollmentCompletionPageConfigurationDisplayName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code windows10EnrollmentCompletionPageConfigurationDisplayName} field changed
     */
    public DeviceManagementAutopilotEvent withWindows10EnrollmentCompletionPageConfigurationDisplayName(String windows10EnrollmentCompletionPageConfigurationDisplayName) {
        DeviceManagementAutopilotEvent _x = _copy();
        _x.changedFields = changedFields.add("windows10EnrollmentCompletionPageConfigurationDisplayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementAutopilotEvent");
        _x.windows10EnrollmentCompletionPageConfigurationDisplayName = windows10EnrollmentCompletionPageConfigurationDisplayName;
        return _x;
    }

    /**
     * <i>“Enrollment Status Page profile ID”</i>
     * 
     * @return property windows10EnrollmentCompletionPageConfigurationId
     */
    @Property(name="windows10EnrollmentCompletionPageConfigurationId")
    @JsonIgnore
    public Optional<String> getWindows10EnrollmentCompletionPageConfigurationId() {
        return Optional.ofNullable(windows10EnrollmentCompletionPageConfigurationId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * windows10EnrollmentCompletionPageConfigurationId} field changed. Field
     * description below. The field name is also added to an internal map of changed
     * fields in the returned object so that when {@code this.patch()} is called (if
     * available)on the returned object only the changed fields are submitted.
     * <p>
     * <i>“Enrollment Status Page profile ID”</i>
     * 
     * @param windows10EnrollmentCompletionPageConfigurationId
     *            new value of {@code windows10EnrollmentCompletionPageConfigurationId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code windows10EnrollmentCompletionPageConfigurationId} field changed
     */
    public DeviceManagementAutopilotEvent withWindows10EnrollmentCompletionPageConfigurationId(String windows10EnrollmentCompletionPageConfigurationId) {
        DeviceManagementAutopilotEvent _x = _copy();
        _x.changedFields = changedFields.add("windows10EnrollmentCompletionPageConfigurationId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementAutopilotEvent");
        _x.windows10EnrollmentCompletionPageConfigurationId = windows10EnrollmentCompletionPageConfigurationId;
        return _x;
    }

    /**
     * <i>“Autopilot profile name.”</i>
     * 
     * @return property windowsAutopilotDeploymentProfileDisplayName
     */
    @Property(name="windowsAutopilotDeploymentProfileDisplayName")
    @JsonIgnore
    public Optional<String> getWindowsAutopilotDeploymentProfileDisplayName() {
        return Optional.ofNullable(windowsAutopilotDeploymentProfileDisplayName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * windowsAutopilotDeploymentProfileDisplayName} field changed. Field description
     * below. The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Autopilot profile name.”</i>
     * 
     * @param windowsAutopilotDeploymentProfileDisplayName
     *            new value of {@code windowsAutopilotDeploymentProfileDisplayName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code windowsAutopilotDeploymentProfileDisplayName} field changed
     */
    public DeviceManagementAutopilotEvent withWindowsAutopilotDeploymentProfileDisplayName(String windowsAutopilotDeploymentProfileDisplayName) {
        DeviceManagementAutopilotEvent _x = _copy();
        _x.changedFields = changedFields.add("windowsAutopilotDeploymentProfileDisplayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementAutopilotEvent");
        _x.windowsAutopilotDeploymentProfileDisplayName = windowsAutopilotDeploymentProfileDisplayName;
        return _x;
    }

    public DeviceManagementAutopilotEvent withUnmappedField(String name, Object value) {
        DeviceManagementAutopilotEvent _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    /**
     * <i>“Policy and application status details for this device.”</i>
     * 
     * @return navigational property policyStatusDetails
     */
    @NavigationProperty(name="policyStatusDetails")
    @JsonIgnore
    public DeviceManagementAutopilotPolicyStatusDetailCollectionRequest getPolicyStatusDetails() {
        return new DeviceManagementAutopilotPolicyStatusDetailCollectionRequest(
                        contextPath.addSegment("policyStatusDetails"), Optional.ofNullable(policyStatusDetails));
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * policyStatusDetails} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Policy and application status details for this device.”</i>
     * 
     * @param policyStatusDetails
     *            new value of {@code policyStatusDetails} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code policyStatusDetails} field changed
     */
    public DeviceManagementAutopilotEvent withPolicyStatusDetails(List<DeviceManagementAutopilotPolicyStatusDetail> policyStatusDetails) {
        DeviceManagementAutopilotEvent _x = _copy();
        _x.changedFields = changedFields.add("policyStatusDetails");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementAutopilotEvent");
        _x.policyStatusDetails = policyStatusDetails;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DeviceManagementAutopilotEvent patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        DeviceManagementAutopilotEvent _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DeviceManagementAutopilotEvent put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        DeviceManagementAutopilotEvent _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private DeviceManagementAutopilotEvent _copy() {
        DeviceManagementAutopilotEvent _x = new DeviceManagementAutopilotEvent();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.accountSetupDuration = accountSetupDuration;
        _x.accountSetupStatus = accountSetupStatus;
        _x.deploymentDuration = deploymentDuration;
        _x.deploymentEndDateTime = deploymentEndDateTime;
        _x.deploymentStartDateTime = deploymentStartDateTime;
        _x.deploymentState = deploymentState;
        _x.deploymentTotalDuration = deploymentTotalDuration;
        _x.deviceId = deviceId;
        _x.devicePreparationDuration = devicePreparationDuration;
        _x.deviceRegisteredDateTime = deviceRegisteredDateTime;
        _x.deviceSerialNumber = deviceSerialNumber;
        _x.deviceSetupDuration = deviceSetupDuration;
        _x.deviceSetupStatus = deviceSetupStatus;
        _x.enrollmentFailureDetails = enrollmentFailureDetails;
        _x.enrollmentStartDateTime = enrollmentStartDateTime;
        _x.enrollmentState = enrollmentState;
        _x.enrollmentType = enrollmentType;
        _x.eventDateTime = eventDateTime;
        _x.managedDeviceName = managedDeviceName;
        _x.osVersion = osVersion;
        _x.targetedAppCount = targetedAppCount;
        _x.targetedPolicyCount = targetedPolicyCount;
        _x.userPrincipalName = userPrincipalName;
        _x.windows10EnrollmentCompletionPageConfigurationDisplayName = windows10EnrollmentCompletionPageConfigurationDisplayName;
        _x.windows10EnrollmentCompletionPageConfigurationId = windows10EnrollmentCompletionPageConfigurationId;
        _x.windowsAutopilotDeploymentProfileDisplayName = windowsAutopilotDeploymentProfileDisplayName;
        _x.policyStatusDetails = policyStatusDetails;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DeviceManagementAutopilotEvent[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("accountSetupDuration=");
        b.append(this.accountSetupDuration);
        b.append(", ");
        b.append("accountSetupStatus=");
        b.append(this.accountSetupStatus);
        b.append(", ");
        b.append("deploymentDuration=");
        b.append(this.deploymentDuration);
        b.append(", ");
        b.append("deploymentEndDateTime=");
        b.append(this.deploymentEndDateTime);
        b.append(", ");
        b.append("deploymentStartDateTime=");
        b.append(this.deploymentStartDateTime);
        b.append(", ");
        b.append("deploymentState=");
        b.append(this.deploymentState);
        b.append(", ");
        b.append("deploymentTotalDuration=");
        b.append(this.deploymentTotalDuration);
        b.append(", ");
        b.append("deviceId=");
        b.append(this.deviceId);
        b.append(", ");
        b.append("devicePreparationDuration=");
        b.append(this.devicePreparationDuration);
        b.append(", ");
        b.append("deviceRegisteredDateTime=");
        b.append(this.deviceRegisteredDateTime);
        b.append(", ");
        b.append("deviceSerialNumber=");
        b.append(this.deviceSerialNumber);
        b.append(", ");
        b.append("deviceSetupDuration=");
        b.append(this.deviceSetupDuration);
        b.append(", ");
        b.append("deviceSetupStatus=");
        b.append(this.deviceSetupStatus);
        b.append(", ");
        b.append("enrollmentFailureDetails=");
        b.append(this.enrollmentFailureDetails);
        b.append(", ");
        b.append("enrollmentStartDateTime=");
        b.append(this.enrollmentStartDateTime);
        b.append(", ");
        b.append("enrollmentState=");
        b.append(this.enrollmentState);
        b.append(", ");
        b.append("enrollmentType=");
        b.append(this.enrollmentType);
        b.append(", ");
        b.append("eventDateTime=");
        b.append(this.eventDateTime);
        b.append(", ");
        b.append("managedDeviceName=");
        b.append(this.managedDeviceName);
        b.append(", ");
        b.append("osVersion=");
        b.append(this.osVersion);
        b.append(", ");
        b.append("targetedAppCount=");
        b.append(this.targetedAppCount);
        b.append(", ");
        b.append("targetedPolicyCount=");
        b.append(this.targetedPolicyCount);
        b.append(", ");
        b.append("userPrincipalName=");
        b.append(this.userPrincipalName);
        b.append(", ");
        b.append("windows10EnrollmentCompletionPageConfigurationDisplayName=");
        b.append(this.windows10EnrollmentCompletionPageConfigurationDisplayName);
        b.append(", ");
        b.append("windows10EnrollmentCompletionPageConfigurationId=");
        b.append(this.windows10EnrollmentCompletionPageConfigurationId);
        b.append(", ");
        b.append("windowsAutopilotDeploymentProfileDisplayName=");
        b.append(this.windowsAutopilotDeploymentProfileDisplayName);
        b.append(", ");
        b.append("policyStatusDetails=");
        b.append(this.policyStatusDetails);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
