package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.FunctionRequestReturningNonCollection;
import com.github.davidmoten.odata.client.FunctionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.FunctionRequestReturningStream;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.lang.UnsupportedOperationException;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;

import odata.msgraph.client.beta.complex.AdminConsent;
import odata.msgraph.client.beta.complex.AssignmentFilterEvaluateRequest;
import odata.msgraph.client.beta.complex.AssignmentFilterStatusDetails;
import odata.msgraph.client.beta.complex.ComanagedDevicesSummary;
import odata.msgraph.client.beta.complex.ComanagementEligibleDevicesSummary;
import odata.msgraph.client.beta.complex.DeviceAndAppManagementAssignedRoleDetails;
import odata.msgraph.client.beta.complex.DeviceManagementSettings;
import odata.msgraph.client.beta.complex.DeviceProtectionOverview;
import odata.msgraph.client.beta.complex.IntuneBrand;
import odata.msgraph.client.beta.complex.ManagedDeviceCleanupSettings;
import odata.msgraph.client.beta.complex.RolePermission;
import odata.msgraph.client.beta.complex.SuggestedEnrollmentLimit;
import odata.msgraph.client.beta.complex.UserExperienceAnalyticsSettings;
import odata.msgraph.client.beta.complex.UserExperienceAnalyticsWorkFromAnywhereDevicesSummary;
import odata.msgraph.client.beta.complex.WindowsMalwareOverview;
import odata.msgraph.client.beta.entity.collection.request.AndroidDeviceOwnerEnrollmentProfileCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.AndroidForWorkAppConfigurationSchemaCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.AndroidForWorkEnrollmentProfileCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.AndroidManagedStoreAppConfigurationSchemaCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.AppleUserInitiatedEnrollmentProfileCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.AuditEventCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.CartToClassAssociationCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.CertificateConnectorDetailsCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ChromeOSOnboardingSettingsCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.CloudPCConnectivityIssueCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ComanagementEligibleDeviceCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ComplianceManagementPartnerCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ConfigManagerCollectionCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DataSharingConsentCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DepOnboardingSettingCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DetectedAppCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DeviceAndAppManagementAssignmentFilterCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DeviceAndAppManagementRoleAssignmentCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DeviceCategoryCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DeviceCompliancePolicyCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DeviceCompliancePolicySettingStateSummaryCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DeviceComplianceScriptCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DeviceConfigurationCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DeviceConfigurationConflictSummaryCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DeviceCustomAttributeShellScriptCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DeviceEnrollmentConfigurationCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DeviceHealthScriptCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DeviceManagementAutopilotEventCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DeviceManagementCompliancePolicyCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DeviceManagementConfigurationCategoryCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DeviceManagementConfigurationPolicyCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DeviceManagementConfigurationPolicyTemplateCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DeviceManagementConfigurationSettingDefinitionCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DeviceManagementConfigurationSettingTemplateCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DeviceManagementDerivedCredentialSettingsCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DeviceManagementDomainJoinConnectorCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DeviceManagementExchangeConnectorCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DeviceManagementExchangeOnPremisesPolicyCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DeviceManagementIntentCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DeviceManagementPartnerCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DeviceManagementResourceAccessProfileBaseCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DeviceManagementReusablePolicySettingCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DeviceManagementScriptCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DeviceManagementSettingCategoryCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DeviceManagementSettingDefinitionCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DeviceManagementTemplateCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DeviceManagementTroubleshootingEventCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DeviceShellScriptCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.EmbeddedSIMActivationCodePoolCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.GroupPolicyCategoryCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.GroupPolicyConfigurationCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.GroupPolicyDefinitionCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.GroupPolicyDefinitionFileCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.GroupPolicyMigrationReportCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.GroupPolicyObjectFileCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.GroupPolicyUploadedDefinitionFileCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ImportedDeviceIdentityCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ImportedWindowsAutopilotDeviceIdentityCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.IntuneBrandingProfileCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.IosUpdateDeviceStatusCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.MacOSSoftwareUpdateAccountSummaryCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ManagedAllDeviceCertificateStateCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ManagedDeviceCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ManagedDeviceEncryptionStateCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ManagementConditionCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ManagementConditionStatementCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.MicrosoftTunnelConfigurationCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.MicrosoftTunnelHealthThresholdCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.MicrosoftTunnelServerLogCollectionResponseCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.MicrosoftTunnelSiteCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.MobileAppTroubleshootingEventCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.MobileThreatDefenseConnectorCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.NdesConnectorCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.NotificationMessageTemplateCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.OemWarrantyInformationOnboardingCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.RemoteActionAuditCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.RemoteAssistancePartnerCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ResourceOperationCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.RestrictedAppsViolationCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.RoleDefinitionCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.RoleScopeTagCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.TelecomExpenseManagementPartnerCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.TermsAndConditionsCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.UserExperienceAnalyticsAppHealthAppPerformanceByAppVersionCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.UserExperienceAnalyticsAppHealthAppPerformanceByAppVersionDetailsCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.UserExperienceAnalyticsAppHealthAppPerformanceByAppVersionDeviceIdCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.UserExperienceAnalyticsAppHealthAppPerformanceByOSVersionCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.UserExperienceAnalyticsAppHealthApplicationPerformanceCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.UserExperienceAnalyticsAppHealthDeviceModelPerformanceCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.UserExperienceAnalyticsAppHealthDevicePerformanceCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.UserExperienceAnalyticsAppHealthDevicePerformanceDetailsCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.UserExperienceAnalyticsAppHealthOSVersionPerformanceCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.UserExperienceAnalyticsBaselineCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.UserExperienceAnalyticsBatteryHealthAppImpactCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.UserExperienceAnalyticsBatteryHealthDeviceAppImpactCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.UserExperienceAnalyticsBatteryHealthDevicePerformanceCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.UserExperienceAnalyticsBatteryHealthDeviceRuntimeHistoryCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.UserExperienceAnalyticsBatteryHealthModelPerformanceCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.UserExperienceAnalyticsBatteryHealthOsPerformanceCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.UserExperienceAnalyticsCategoryCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.UserExperienceAnalyticsDevicePerformanceCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.UserExperienceAnalyticsDeviceScoresCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.UserExperienceAnalyticsDeviceStartupHistoryCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.UserExperienceAnalyticsDeviceStartupProcessCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.UserExperienceAnalyticsDeviceStartupProcessPerformanceCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.UserExperienceAnalyticsDeviceWithoutCloudIdentityCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.UserExperienceAnalyticsImpactingProcessCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.UserExperienceAnalyticsMetricHistoryCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.UserExperienceAnalyticsModelScoresCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.UserExperienceAnalyticsNotAutopilotReadyDeviceCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.UserExperienceAnalyticsRemoteConnectionCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.UserExperienceAnalyticsResourcePerformanceCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.UserExperienceAnalyticsScoreHistoryCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.UserExperienceAnalyticsWorkFromAnywhereMetricCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.UserExperienceAnalyticsWorkFromAnywhereModelPerformanceCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.UserPFXCertificateCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.WindowsAutopilotDeploymentProfileCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.WindowsAutopilotDeviceIdentityCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.WindowsDriverUpdateProfileCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.WindowsFeatureUpdateProfileCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.WindowsInformationProtectionAppLearningSummaryCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.WindowsInformationProtectionNetworkLearningSummaryCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.WindowsMalwareInformationCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.WindowsQualityUpdateProfileCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.WindowsUpdateCatalogItemCollectionRequest;
import odata.msgraph.client.beta.entity.request.AdvancedThreatProtectionOnboardingStateSummaryRequest;
import odata.msgraph.client.beta.entity.request.AndroidForWorkSettingsRequest;
import odata.msgraph.client.beta.entity.request.AndroidManagedStoreAccountEnterpriseSettingsRequest;
import odata.msgraph.client.beta.entity.request.ApplePushNotificationCertificateRequest;
import odata.msgraph.client.beta.entity.request.DeviceCompliancePolicyDeviceStateSummaryRequest;
import odata.msgraph.client.beta.entity.request.DeviceConfigurationDeviceStateSummaryRequest;
import odata.msgraph.client.beta.entity.request.DeviceConfigurationUserStateSummaryRequest;
import odata.msgraph.client.beta.entity.request.DeviceManagementExchangeOnPremisesPolicyRequest;
import odata.msgraph.client.beta.entity.request.DeviceManagementReportsRequest;
import odata.msgraph.client.beta.entity.request.ManagedDeviceOverviewRequest;
import odata.msgraph.client.beta.entity.request.OnPremisesConditionalAccessSettingsRequest;
import odata.msgraph.client.beta.entity.request.RemoteAssistanceSettingsRequest;
import odata.msgraph.client.beta.entity.request.SoftwareUpdateStatusSummaryRequest;
import odata.msgraph.client.beta.entity.request.UserExperienceAnalyticsBatteryHealthCapacityDetailsRequest;
import odata.msgraph.client.beta.entity.request.UserExperienceAnalyticsBatteryHealthRuntimeDetailsRequest;
import odata.msgraph.client.beta.entity.request.UserExperienceAnalyticsCategoryRequest;
import odata.msgraph.client.beta.entity.request.UserExperienceAnalyticsOverviewRequest;
import odata.msgraph.client.beta.entity.request.UserExperienceAnalyticsRegressionSummaryRequest;
import odata.msgraph.client.beta.entity.request.UserExperienceAnalyticsWorkFromAnywhereHardwareReadinessMetricRequest;
import odata.msgraph.client.beta.entity.request.VirtualEndpointRequest;
import odata.msgraph.client.beta.entity.request.WindowsAutopilotSettingsRequest;
import odata.msgraph.client.beta.enums.DeviceManagementSubscriptionState;
import odata.msgraph.client.beta.enums.DeviceManagementSubscriptions;


/**
 * <i>“Singleton entity that acts as a container for all device management
 * functionality.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "deviceComplianceReportSummarizationDateTime", 
    "intuneAccountId", 
    "lastReportAggregationDateTime", 
    "legacyPcManangementEnabled", 
    "maximumDepTokens", 
    "settings", 
    "unlicensedAdminstratorsEnabled", 
    "intuneBrand", 
    "accountMoveCompletionDateTime", 
    "adminConsent", 
    "deviceProtectionOverview", 
    "managedDeviceCleanupSettings", 
    "subscriptions", 
    "subscriptionState", 
    "userExperienceAnalyticsSettings", 
    "windowsMalwareOverview", 
    "androidDeviceOwnerEnrollmentProfiles", 
    "virtualEndpoint", 
    "androidForWorkAppConfigurationSchemas", 
    "androidForWorkEnrollmentProfiles", 
    "androidForWorkSettings", 
    "androidManagedStoreAccountEnterpriseSettings", 
    "androidManagedStoreAppConfigurationSchemas", 
    "auditEvents", 
    "assignmentFilters", 
    "chromeOSOnboardingSettings", 
    "termsAndConditions", 
    "advancedThreatProtectionOnboardingStateSummary", 
    "cartToClassAssociations", 
    "deviceCompliancePolicies", 
    "deviceCompliancePolicyDeviceStateSummary", 
    "deviceCompliancePolicySettingStateSummaries", 
    "deviceConfigurationConflictSummary", 
    "deviceConfigurationDeviceStateSummaries", 
    "deviceConfigurationRestrictedAppsViolations", 
    "deviceConfigurations", 
    "deviceConfigurationsAllManagedDeviceCertificateStates", 
    "deviceConfigurationUserStateSummaries", 
    "iosUpdateStatuses", 
    "macOSSoftwareUpdateAccountSummaries", 
    "managedDeviceEncryptionStates", 
    "ndesConnectors", 
    "complianceCategories", 
    "compliancePolicies", 
    "complianceSettings", 
    "configurationCategories", 
    "configurationPolicies", 
    "configurationPolicyTemplates", 
    "configurationSettings", 
    "reusablePolicySettings", 
    "reusableSettings", 
    "templateSettings", 
    "complianceManagementPartners", 
    "conditionalAccessSettings", 
    "deviceCategories", 
    "deviceEnrollmentConfigurations", 
    "deviceManagementPartners", 
    "exchangeConnectors", 
    "exchangeOnPremisesPolicies", 
    "exchangeOnPremisesPolicy", 
    "mobileThreatDefenseConnectors", 
    "categories", 
    "intents", 
    "settingDefinitions", 
    "templates", 
    "applePushNotificationCertificate", 
    "cloudPCConnectivityIssues", 
    "comanagedDevices", 
    "comanagementEligibleDevices", 
    "dataSharingConsents", 
    "detectedApps", 
    "deviceComplianceScripts", 
    "deviceCustomAttributeShellScripts", 
    "deviceHealthScripts", 
    "deviceManagementScripts", 
    "deviceShellScripts", 
    "managedDevices", 
    "mobileAppTroubleshootingEvents", 
    "oemWarrantyInformationOnboarding", 
    "remoteActionAudits", 
    "userExperienceAnalyticsAppHealthApplicationPerformance", 
    "userExperienceAnalyticsAppHealthApplicationPerformanceByAppVersion", 
    "userExperienceAnalyticsAppHealthApplicationPerformanceByAppVersionDetails", 
    "userExperienceAnalyticsAppHealthApplicationPerformanceByAppVersionDeviceId", 
    "userExperienceAnalyticsAppHealthApplicationPerformanceByOSVersion", 
    "userExperienceAnalyticsAppHealthDeviceModelPerformance", 
    "userExperienceAnalyticsAppHealthDevicePerformance", 
    "userExperienceAnalyticsAppHealthDevicePerformanceDetails", 
    "userExperienceAnalyticsAppHealthOSVersionPerformance", 
    "userExperienceAnalyticsAppHealthOverview", 
    "userExperienceAnalyticsBaselines", 
    "userExperienceAnalyticsBatteryHealthAppImpact", 
    "userExperienceAnalyticsBatteryHealthCapacityDetails", 
    "userExperienceAnalyticsBatteryHealthDeviceAppImpact", 
    "userExperienceAnalyticsBatteryHealthDevicePerformance", 
    "userExperienceAnalyticsBatteryHealthDeviceRuntimeHistory", 
    "userExperienceAnalyticsBatteryHealthModelPerformance", 
    "userExperienceAnalyticsBatteryHealthOsPerformance", 
    "userExperienceAnalyticsBatteryHealthRuntimeDetails", 
    "userExperienceAnalyticsCategories", 
    "userExperienceAnalyticsDeviceMetricHistory", 
    "userExperienceAnalyticsDevicePerformance", 
    "userExperienceAnalyticsDeviceScores", 
    "userExperienceAnalyticsDeviceStartupHistory", 
    "userExperienceAnalyticsDeviceStartupProcesses", 
    "userExperienceAnalyticsDeviceStartupProcessPerformance", 
    "userExperienceAnalyticsDevicesWithoutCloudIdentity", 
    "userExperienceAnalyticsImpactingProcess", 
    "userExperienceAnalyticsMetricHistory", 
    "userExperienceAnalyticsModelScores", 
    "userExperienceAnalyticsNotAutopilotReadyDevice", 
    "userExperienceAnalyticsOverview", 
    "userExperienceAnalyticsRegressionSummary", 
    "userExperienceAnalyticsRemoteConnection", 
    "userExperienceAnalyticsResourcePerformance", 
    "userExperienceAnalyticsScoreHistory", 
    "userExperienceAnalyticsWorkFromAnywhereHardwareReadinessMetric", 
    "userExperienceAnalyticsWorkFromAnywhereMetrics", 
    "userExperienceAnalyticsWorkFromAnywhereModelPerformance", 
    "windowsMalwareInformation", 
    "derivedCredentials", 
    "resourceAccessProfiles", 
    "appleUserInitiatedEnrollmentProfiles", 
    "depOnboardingSettings", 
    "importedDeviceIdentities", 
    "importedWindowsAutopilotDeviceIdentities", 
    "windowsAutopilotDeploymentProfiles", 
    "windowsAutopilotDeviceIdentities", 
    "windowsAutopilotSettings", 
    "managementConditions", 
    "managementConditionStatements", 
    "groupPolicyMigrationReports", 
    "groupPolicyObjectFiles", 
    "groupPolicyCategories", 
    "groupPolicyConfigurations", 
    "groupPolicyDefinitionFiles", 
    "groupPolicyDefinitions", 
    "groupPolicyUploadedDefinitionFiles", 
    "microsoftTunnelConfigurations", 
    "microsoftTunnelHealthThresholds", 
    "microsoftTunnelServerLogCollectionResponses", 
    "microsoftTunnelSites", 
    "notificationMessageTemplates", 
    "domainJoinConnectors", 
    "configManagerCollections", 
    "resourceOperations", 
    "roleAssignments", 
    "roleDefinitions", 
    "roleScopeTags", 
    "remoteAssistancePartners", 
    "remoteAssistanceSettings", 
    "reports", 
    "embeddedSIMActivationCodePools", 
    "telecomExpenseManagementPartners", 
    "autopilotEvents", 
    "troubleshootingEvents", 
    "windowsDriverUpdateProfiles", 
    "windowsFeatureUpdateProfiles", 
    "windowsQualityUpdateProfiles", 
    "windowsUpdateCatalogItems", 
    "intuneBrandingProfiles", 
    "windowsInformationProtectionAppLearningSummaries", 
    "windowsInformationProtectionNetworkLearningSummaries", 
    "certificateConnectorDetails", 
    "userPfxCertificates"})
@JsonInclude(Include.NON_NULL)
public class DeviceManagement extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.deviceManagement";
    }

    @JsonProperty("deviceComplianceReportSummarizationDateTime")
    protected OffsetDateTime deviceComplianceReportSummarizationDateTime;

    @JsonProperty("intuneAccountId")
    protected UUID intuneAccountId;

    @JsonProperty("lastReportAggregationDateTime")
    protected OffsetDateTime lastReportAggregationDateTime;

    @JsonProperty("legacyPcManangementEnabled")
    protected Boolean legacyPcManangementEnabled;

    @JsonProperty("maximumDepTokens")
    protected Integer maximumDepTokens;

    @JsonProperty("settings")
    protected DeviceManagementSettings settings;

    @JsonProperty("unlicensedAdminstratorsEnabled")
    protected Boolean unlicensedAdminstratorsEnabled;

    @JsonProperty("intuneBrand")
    protected IntuneBrand intuneBrand;

    @JsonProperty("accountMoveCompletionDateTime")
    protected OffsetDateTime accountMoveCompletionDateTime;

    @JsonProperty("adminConsent")
    protected AdminConsent adminConsent;

    @JsonProperty("deviceProtectionOverview")
    protected DeviceProtectionOverview deviceProtectionOverview;

    @JsonProperty("managedDeviceCleanupSettings")
    protected ManagedDeviceCleanupSettings managedDeviceCleanupSettings;

    @JsonProperty("subscriptions")
    protected DeviceManagementSubscriptions subscriptions;

    @JsonProperty("subscriptionState")
    protected DeviceManagementSubscriptionState subscriptionState;

    @JsonProperty("userExperienceAnalyticsSettings")
    protected UserExperienceAnalyticsSettings userExperienceAnalyticsSettings;

    @JsonProperty("windowsMalwareOverview")
    protected WindowsMalwareOverview windowsMalwareOverview;

    @JsonProperty("androidDeviceOwnerEnrollmentProfiles")
    protected List<AndroidDeviceOwnerEnrollmentProfile> androidDeviceOwnerEnrollmentProfiles;

    @JsonProperty("virtualEndpoint")
    protected VirtualEndpoint virtualEndpoint;

    @JsonProperty("androidForWorkAppConfigurationSchemas")
    protected List<AndroidForWorkAppConfigurationSchema> androidForWorkAppConfigurationSchemas;

    @JsonProperty("androidForWorkEnrollmentProfiles")
    protected List<AndroidForWorkEnrollmentProfile> androidForWorkEnrollmentProfiles;

    @JsonProperty("androidForWorkSettings")
    protected AndroidForWorkSettings androidForWorkSettings;

    @JsonProperty("androidManagedStoreAccountEnterpriseSettings")
    protected AndroidManagedStoreAccountEnterpriseSettings androidManagedStoreAccountEnterpriseSettings;

    @JsonProperty("androidManagedStoreAppConfigurationSchemas")
    protected List<AndroidManagedStoreAppConfigurationSchema> androidManagedStoreAppConfigurationSchemas;

    @JsonProperty("auditEvents")
    protected List<AuditEvent> auditEvents;

    @JsonProperty("assignmentFilters")
    protected List<DeviceAndAppManagementAssignmentFilter> assignmentFilters;

    @JsonProperty("chromeOSOnboardingSettings")
    protected List<ChromeOSOnboardingSettings> chromeOSOnboardingSettings;

    @JsonProperty("termsAndConditions")
    protected List<TermsAndConditions> termsAndConditions;

    @JsonProperty("advancedThreatProtectionOnboardingStateSummary")
    protected AdvancedThreatProtectionOnboardingStateSummary advancedThreatProtectionOnboardingStateSummary;

    @JsonProperty("cartToClassAssociations")
    protected List<CartToClassAssociation> cartToClassAssociations;

    @JsonProperty("deviceCompliancePolicies")
    protected List<DeviceCompliancePolicy> deviceCompliancePolicies;

    @JsonProperty("deviceCompliancePolicyDeviceStateSummary")
    protected DeviceCompliancePolicyDeviceStateSummary deviceCompliancePolicyDeviceStateSummary;

    @JsonProperty("deviceCompliancePolicySettingStateSummaries")
    protected List<DeviceCompliancePolicySettingStateSummary> deviceCompliancePolicySettingStateSummaries;

    @JsonProperty("deviceConfigurationConflictSummary")
    protected List<DeviceConfigurationConflictSummary> deviceConfigurationConflictSummary;

    @JsonProperty("deviceConfigurationDeviceStateSummaries")
    protected DeviceConfigurationDeviceStateSummary deviceConfigurationDeviceStateSummaries;

    @JsonProperty("deviceConfigurationRestrictedAppsViolations")
    protected List<RestrictedAppsViolation> deviceConfigurationRestrictedAppsViolations;

    @JsonProperty("deviceConfigurations")
    protected List<DeviceConfiguration> deviceConfigurations;

    @JsonProperty("deviceConfigurationsAllManagedDeviceCertificateStates")
    protected List<ManagedAllDeviceCertificateState> deviceConfigurationsAllManagedDeviceCertificateStates;

    @JsonProperty("deviceConfigurationUserStateSummaries")
    protected DeviceConfigurationUserStateSummary deviceConfigurationUserStateSummaries;

    @JsonProperty("iosUpdateStatuses")
    protected List<IosUpdateDeviceStatus> iosUpdateStatuses;

    @JsonProperty("macOSSoftwareUpdateAccountSummaries")
    protected List<MacOSSoftwareUpdateAccountSummary> macOSSoftwareUpdateAccountSummaries;

    @JsonProperty("managedDeviceEncryptionStates")
    protected List<ManagedDeviceEncryptionState> managedDeviceEncryptionStates;

    @JsonProperty("ndesConnectors")
    protected List<NdesConnector> ndesConnectors;

    @JsonProperty("complianceCategories")
    protected List<DeviceManagementConfigurationCategory> complianceCategories;

    @JsonProperty("compliancePolicies")
    protected List<DeviceManagementCompliancePolicy> compliancePolicies;

    @JsonProperty("complianceSettings")
    protected List<DeviceManagementConfigurationSettingDefinition> complianceSettings;

    @JsonProperty("configurationCategories")
    protected List<DeviceManagementConfigurationCategory> configurationCategories;

    @JsonProperty("configurationPolicies")
    protected List<DeviceManagementConfigurationPolicy> configurationPolicies;

    @JsonProperty("configurationPolicyTemplates")
    protected List<DeviceManagementConfigurationPolicyTemplate> configurationPolicyTemplates;

    @JsonProperty("configurationSettings")
    protected List<DeviceManagementConfigurationSettingDefinition> configurationSettings;

    @JsonProperty("reusablePolicySettings")
    protected List<DeviceManagementReusablePolicySetting> reusablePolicySettings;

    @JsonProperty("reusableSettings")
    protected List<DeviceManagementConfigurationSettingDefinition> reusableSettings;

    @JsonProperty("templateSettings")
    protected List<DeviceManagementConfigurationSettingTemplate> templateSettings;

    @JsonProperty("complianceManagementPartners")
    protected List<ComplianceManagementPartner> complianceManagementPartners;

    @JsonProperty("conditionalAccessSettings")
    protected OnPremisesConditionalAccessSettings conditionalAccessSettings;

    @JsonProperty("deviceCategories")
    protected List<DeviceCategory> deviceCategories;

    @JsonProperty("deviceEnrollmentConfigurations")
    protected List<DeviceEnrollmentConfiguration> deviceEnrollmentConfigurations;

    @JsonProperty("deviceManagementPartners")
    protected List<DeviceManagementPartner> deviceManagementPartners;

    @JsonProperty("exchangeConnectors")
    protected List<DeviceManagementExchangeConnector> exchangeConnectors;

    @JsonProperty("exchangeOnPremisesPolicies")
    protected List<DeviceManagementExchangeOnPremisesPolicy> exchangeOnPremisesPolicies;

    @JsonProperty("exchangeOnPremisesPolicy")
    protected DeviceManagementExchangeOnPremisesPolicy exchangeOnPremisesPolicy;

    @JsonProperty("mobileThreatDefenseConnectors")
    protected List<MobileThreatDefenseConnector> mobileThreatDefenseConnectors;

    @JsonProperty("categories")
    protected List<DeviceManagementSettingCategory> categories;

    @JsonProperty("intents")
    protected List<DeviceManagementIntent> intents;

    @JsonProperty("settingDefinitions")
    protected List<DeviceManagementSettingDefinition> settingDefinitions;

    @JsonProperty("templates")
    protected List<DeviceManagementTemplate> templates;

    @JsonProperty("applePushNotificationCertificate")
    protected ApplePushNotificationCertificate applePushNotificationCertificate;

    @JsonProperty("cloudPCConnectivityIssues")
    protected List<CloudPCConnectivityIssue> cloudPCConnectivityIssues;

    @JsonProperty("comanagedDevices")
    protected List<ManagedDevice> comanagedDevices;

    @JsonProperty("comanagementEligibleDevices")
    protected List<ComanagementEligibleDevice> comanagementEligibleDevices;

    @JsonProperty("dataSharingConsents")
    protected List<DataSharingConsent> dataSharingConsents;

    @JsonProperty("detectedApps")
    protected List<DetectedApp> detectedApps;

    @JsonProperty("deviceComplianceScripts")
    protected List<DeviceComplianceScript> deviceComplianceScripts;

    @JsonProperty("deviceCustomAttributeShellScripts")
    protected List<DeviceCustomAttributeShellScript> deviceCustomAttributeShellScripts;

    @JsonProperty("deviceHealthScripts")
    protected List<DeviceHealthScript> deviceHealthScripts;

    @JsonProperty("deviceManagementScripts")
    protected List<DeviceManagementScript> deviceManagementScripts;

    @JsonProperty("deviceShellScripts")
    protected List<DeviceShellScript> deviceShellScripts;

    @JsonProperty("managedDevices")
    protected List<ManagedDevice> managedDevices;

    @JsonProperty("mobileAppTroubleshootingEvents")
    protected List<MobileAppTroubleshootingEvent> mobileAppTroubleshootingEvents;

    @JsonProperty("oemWarrantyInformationOnboarding")
    protected List<OemWarrantyInformationOnboarding> oemWarrantyInformationOnboarding;

    @JsonProperty("remoteActionAudits")
    protected List<RemoteActionAudit> remoteActionAudits;

    @JsonProperty("userExperienceAnalyticsAppHealthApplicationPerformance")
    protected List<UserExperienceAnalyticsAppHealthApplicationPerformance> userExperienceAnalyticsAppHealthApplicationPerformance;

    @JsonProperty("userExperienceAnalyticsAppHealthApplicationPerformanceByAppVersion")
    protected List<UserExperienceAnalyticsAppHealthAppPerformanceByAppVersion> userExperienceAnalyticsAppHealthApplicationPerformanceByAppVersion;

    @JsonProperty("userExperienceAnalyticsAppHealthApplicationPerformanceByAppVersionDetails")
    protected List<UserExperienceAnalyticsAppHealthAppPerformanceByAppVersionDetails> userExperienceAnalyticsAppHealthApplicationPerformanceByAppVersionDetails;

    @JsonProperty("userExperienceAnalyticsAppHealthApplicationPerformanceByAppVersionDeviceId")
    protected List<UserExperienceAnalyticsAppHealthAppPerformanceByAppVersionDeviceId> userExperienceAnalyticsAppHealthApplicationPerformanceByAppVersionDeviceId;

    @JsonProperty("userExperienceAnalyticsAppHealthApplicationPerformanceByOSVersion")
    protected List<UserExperienceAnalyticsAppHealthAppPerformanceByOSVersion> userExperienceAnalyticsAppHealthApplicationPerformanceByOSVersion;

    @JsonProperty("userExperienceAnalyticsAppHealthDeviceModelPerformance")
    protected List<UserExperienceAnalyticsAppHealthDeviceModelPerformance> userExperienceAnalyticsAppHealthDeviceModelPerformance;

    @JsonProperty("userExperienceAnalyticsAppHealthDevicePerformance")
    protected List<UserExperienceAnalyticsAppHealthDevicePerformance> userExperienceAnalyticsAppHealthDevicePerformance;

    @JsonProperty("userExperienceAnalyticsAppHealthDevicePerformanceDetails")
    protected List<UserExperienceAnalyticsAppHealthDevicePerformanceDetails> userExperienceAnalyticsAppHealthDevicePerformanceDetails;

    @JsonProperty("userExperienceAnalyticsAppHealthOSVersionPerformance")
    protected List<UserExperienceAnalyticsAppHealthOSVersionPerformance> userExperienceAnalyticsAppHealthOSVersionPerformance;

    @JsonProperty("userExperienceAnalyticsAppHealthOverview")
    protected UserExperienceAnalyticsCategory userExperienceAnalyticsAppHealthOverview;

    @JsonProperty("userExperienceAnalyticsBaselines")
    protected List<UserExperienceAnalyticsBaseline> userExperienceAnalyticsBaselines;

    @JsonProperty("userExperienceAnalyticsBatteryHealthAppImpact")
    protected List<UserExperienceAnalyticsBatteryHealthAppImpact> userExperienceAnalyticsBatteryHealthAppImpact;

    @JsonProperty("userExperienceAnalyticsBatteryHealthCapacityDetails")
    protected UserExperienceAnalyticsBatteryHealthCapacityDetails userExperienceAnalyticsBatteryHealthCapacityDetails;

    @JsonProperty("userExperienceAnalyticsBatteryHealthDeviceAppImpact")
    protected List<UserExperienceAnalyticsBatteryHealthDeviceAppImpact> userExperienceAnalyticsBatteryHealthDeviceAppImpact;

    @JsonProperty("userExperienceAnalyticsBatteryHealthDevicePerformance")
    protected List<UserExperienceAnalyticsBatteryHealthDevicePerformance> userExperienceAnalyticsBatteryHealthDevicePerformance;

    @JsonProperty("userExperienceAnalyticsBatteryHealthDeviceRuntimeHistory")
    protected List<UserExperienceAnalyticsBatteryHealthDeviceRuntimeHistory> userExperienceAnalyticsBatteryHealthDeviceRuntimeHistory;

    @JsonProperty("userExperienceAnalyticsBatteryHealthModelPerformance")
    protected List<UserExperienceAnalyticsBatteryHealthModelPerformance> userExperienceAnalyticsBatteryHealthModelPerformance;

    @JsonProperty("userExperienceAnalyticsBatteryHealthOsPerformance")
    protected List<UserExperienceAnalyticsBatteryHealthOsPerformance> userExperienceAnalyticsBatteryHealthOsPerformance;

    @JsonProperty("userExperienceAnalyticsBatteryHealthRuntimeDetails")
    protected UserExperienceAnalyticsBatteryHealthRuntimeDetails userExperienceAnalyticsBatteryHealthRuntimeDetails;

    @JsonProperty("userExperienceAnalyticsCategories")
    protected List<UserExperienceAnalyticsCategory> userExperienceAnalyticsCategories;

    @JsonProperty("userExperienceAnalyticsDeviceMetricHistory")
    protected List<UserExperienceAnalyticsMetricHistory> userExperienceAnalyticsDeviceMetricHistory;

    @JsonProperty("userExperienceAnalyticsDevicePerformance")
    protected List<UserExperienceAnalyticsDevicePerformance> userExperienceAnalyticsDevicePerformance;

    @JsonProperty("userExperienceAnalyticsDeviceScores")
    protected List<UserExperienceAnalyticsDeviceScores> userExperienceAnalyticsDeviceScores;

    @JsonProperty("userExperienceAnalyticsDeviceStartupHistory")
    protected List<UserExperienceAnalyticsDeviceStartupHistory> userExperienceAnalyticsDeviceStartupHistory;

    @JsonProperty("userExperienceAnalyticsDeviceStartupProcesses")
    protected List<UserExperienceAnalyticsDeviceStartupProcess> userExperienceAnalyticsDeviceStartupProcesses;

    @JsonProperty("userExperienceAnalyticsDeviceStartupProcessPerformance")
    protected List<UserExperienceAnalyticsDeviceStartupProcessPerformance> userExperienceAnalyticsDeviceStartupProcessPerformance;

    @JsonProperty("userExperienceAnalyticsDevicesWithoutCloudIdentity")
    protected List<UserExperienceAnalyticsDeviceWithoutCloudIdentity> userExperienceAnalyticsDevicesWithoutCloudIdentity;

    @JsonProperty("userExperienceAnalyticsImpactingProcess")
    protected List<UserExperienceAnalyticsImpactingProcess> userExperienceAnalyticsImpactingProcess;

    @JsonProperty("userExperienceAnalyticsMetricHistory")
    protected List<UserExperienceAnalyticsMetricHistory> userExperienceAnalyticsMetricHistory;

    @JsonProperty("userExperienceAnalyticsModelScores")
    protected List<UserExperienceAnalyticsModelScores> userExperienceAnalyticsModelScores;

    @JsonProperty("userExperienceAnalyticsNotAutopilotReadyDevice")
    protected List<UserExperienceAnalyticsNotAutopilotReadyDevice> userExperienceAnalyticsNotAutopilotReadyDevice;

    @JsonProperty("userExperienceAnalyticsOverview")
    protected UserExperienceAnalyticsOverview userExperienceAnalyticsOverview;

    @JsonProperty("userExperienceAnalyticsRegressionSummary")
    protected UserExperienceAnalyticsRegressionSummary userExperienceAnalyticsRegressionSummary;

    @JsonProperty("userExperienceAnalyticsRemoteConnection")
    protected List<UserExperienceAnalyticsRemoteConnection> userExperienceAnalyticsRemoteConnection;

    @JsonProperty("userExperienceAnalyticsResourcePerformance")
    protected List<UserExperienceAnalyticsResourcePerformance> userExperienceAnalyticsResourcePerformance;

    @JsonProperty("userExperienceAnalyticsScoreHistory")
    protected List<UserExperienceAnalyticsScoreHistory> userExperienceAnalyticsScoreHistory;

    @JsonProperty("userExperienceAnalyticsWorkFromAnywhereHardwareReadinessMetric")
    protected UserExperienceAnalyticsWorkFromAnywhereHardwareReadinessMetric userExperienceAnalyticsWorkFromAnywhereHardwareReadinessMetric;

    @JsonProperty("userExperienceAnalyticsWorkFromAnywhereMetrics")
    protected List<UserExperienceAnalyticsWorkFromAnywhereMetric> userExperienceAnalyticsWorkFromAnywhereMetrics;

    @JsonProperty("userExperienceAnalyticsWorkFromAnywhereModelPerformance")
    protected List<UserExperienceAnalyticsWorkFromAnywhereModelPerformance> userExperienceAnalyticsWorkFromAnywhereModelPerformance;

    @JsonProperty("windowsMalwareInformation")
    protected List<WindowsMalwareInformation> windowsMalwareInformation;

    @JsonProperty("derivedCredentials")
    protected List<DeviceManagementDerivedCredentialSettings> derivedCredentials;

    @JsonProperty("resourceAccessProfiles")
    protected List<DeviceManagementResourceAccessProfileBase> resourceAccessProfiles;

    @JsonProperty("appleUserInitiatedEnrollmentProfiles")
    protected List<AppleUserInitiatedEnrollmentProfile> appleUserInitiatedEnrollmentProfiles;

    @JsonProperty("depOnboardingSettings")
    protected List<DepOnboardingSetting> depOnboardingSettings;

    @JsonProperty("importedDeviceIdentities")
    protected List<ImportedDeviceIdentity> importedDeviceIdentities;

    @JsonProperty("importedWindowsAutopilotDeviceIdentities")
    protected List<ImportedWindowsAutopilotDeviceIdentity> importedWindowsAutopilotDeviceIdentities;

    @JsonProperty("windowsAutopilotDeploymentProfiles")
    protected List<WindowsAutopilotDeploymentProfile> windowsAutopilotDeploymentProfiles;

    @JsonProperty("windowsAutopilotDeviceIdentities")
    protected List<WindowsAutopilotDeviceIdentity> windowsAutopilotDeviceIdentities;

    @JsonProperty("windowsAutopilotSettings")
    protected WindowsAutopilotSettings windowsAutopilotSettings;

    @JsonProperty("managementConditions")
    protected List<ManagementCondition> managementConditions;

    @JsonProperty("managementConditionStatements")
    protected List<ManagementConditionStatement> managementConditionStatements;

    @JsonProperty("groupPolicyMigrationReports")
    protected List<GroupPolicyMigrationReport> groupPolicyMigrationReports;

    @JsonProperty("groupPolicyObjectFiles")
    protected List<GroupPolicyObjectFile> groupPolicyObjectFiles;

    @JsonProperty("groupPolicyCategories")
    protected List<GroupPolicyCategory> groupPolicyCategories;

    @JsonProperty("groupPolicyConfigurations")
    protected List<GroupPolicyConfiguration> groupPolicyConfigurations;

    @JsonProperty("groupPolicyDefinitionFiles")
    protected List<GroupPolicyDefinitionFile> groupPolicyDefinitionFiles;

    @JsonProperty("groupPolicyDefinitions")
    protected List<GroupPolicyDefinition> groupPolicyDefinitions;

    @JsonProperty("groupPolicyUploadedDefinitionFiles")
    protected List<GroupPolicyUploadedDefinitionFile> groupPolicyUploadedDefinitionFiles;

    @JsonProperty("microsoftTunnelConfigurations")
    protected List<MicrosoftTunnelConfiguration> microsoftTunnelConfigurations;

    @JsonProperty("microsoftTunnelHealthThresholds")
    protected List<MicrosoftTunnelHealthThreshold> microsoftTunnelHealthThresholds;

    @JsonProperty("microsoftTunnelServerLogCollectionResponses")
    protected List<MicrosoftTunnelServerLogCollectionResponse> microsoftTunnelServerLogCollectionResponses;

    @JsonProperty("microsoftTunnelSites")
    protected List<MicrosoftTunnelSite> microsoftTunnelSites;

    @JsonProperty("notificationMessageTemplates")
    protected List<NotificationMessageTemplate> notificationMessageTemplates;

    @JsonProperty("domainJoinConnectors")
    protected List<DeviceManagementDomainJoinConnector> domainJoinConnectors;

    @JsonProperty("configManagerCollections")
    protected List<ConfigManagerCollection> configManagerCollections;

    @JsonProperty("resourceOperations")
    protected List<ResourceOperation> resourceOperations;

    @JsonProperty("roleAssignments")
    protected List<DeviceAndAppManagementRoleAssignment> roleAssignments;

    @JsonProperty("roleDefinitions")
    protected List<RoleDefinition> roleDefinitions;

    @JsonProperty("roleScopeTags")
    protected List<RoleScopeTag> roleScopeTags;

    @JsonProperty("remoteAssistancePartners")
    protected List<RemoteAssistancePartner> remoteAssistancePartners;

    @JsonProperty("remoteAssistanceSettings")
    protected RemoteAssistanceSettings remoteAssistanceSettings;

    @JsonProperty("reports")
    protected DeviceManagementReports reports;

    @JsonProperty("embeddedSIMActivationCodePools")
    protected List<EmbeddedSIMActivationCodePool> embeddedSIMActivationCodePools;

    @JsonProperty("telecomExpenseManagementPartners")
    protected List<TelecomExpenseManagementPartner> telecomExpenseManagementPartners;

    @JsonProperty("autopilotEvents")
    protected List<DeviceManagementAutopilotEvent> autopilotEvents;

    @JsonProperty("troubleshootingEvents")
    protected List<DeviceManagementTroubleshootingEvent> troubleshootingEvents;

    @JsonProperty("windowsDriverUpdateProfiles")
    protected List<WindowsDriverUpdateProfile> windowsDriverUpdateProfiles;

    @JsonProperty("windowsFeatureUpdateProfiles")
    protected List<WindowsFeatureUpdateProfile> windowsFeatureUpdateProfiles;

    @JsonProperty("windowsQualityUpdateProfiles")
    protected List<WindowsQualityUpdateProfile> windowsQualityUpdateProfiles;

    @JsonProperty("windowsUpdateCatalogItems")
    protected List<WindowsUpdateCatalogItem> windowsUpdateCatalogItems;

    @JsonProperty("intuneBrandingProfiles")
    protected List<IntuneBrandingProfile> intuneBrandingProfiles;

    @JsonProperty("windowsInformationProtectionAppLearningSummaries")
    protected List<WindowsInformationProtectionAppLearningSummary> windowsInformationProtectionAppLearningSummaries;

    @JsonProperty("windowsInformationProtectionNetworkLearningSummaries")
    protected List<WindowsInformationProtectionNetworkLearningSummary> windowsInformationProtectionNetworkLearningSummaries;

    @JsonProperty("certificateConnectorDetails")
    protected List<CertificateConnectorDetails> certificateConnectorDetails;

    @JsonProperty("userPfxCertificates")
    protected List<UserPFXCertificate> userPfxCertificates;

    protected DeviceManagement() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderDeviceManagement() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private OffsetDateTime deviceComplianceReportSummarizationDateTime;
        private UUID intuneAccountId;
        private OffsetDateTime lastReportAggregationDateTime;
        private Boolean legacyPcManangementEnabled;
        private Integer maximumDepTokens;
        private DeviceManagementSettings settings;
        private Boolean unlicensedAdminstratorsEnabled;
        private IntuneBrand intuneBrand;
        private OffsetDateTime accountMoveCompletionDateTime;
        private AdminConsent adminConsent;
        private DeviceProtectionOverview deviceProtectionOverview;
        private ManagedDeviceCleanupSettings managedDeviceCleanupSettings;
        private DeviceManagementSubscriptions subscriptions;
        private DeviceManagementSubscriptionState subscriptionState;
        private UserExperienceAnalyticsSettings userExperienceAnalyticsSettings;
        private WindowsMalwareOverview windowsMalwareOverview;
        private List<AndroidDeviceOwnerEnrollmentProfile> androidDeviceOwnerEnrollmentProfiles;
        private VirtualEndpoint virtualEndpoint;
        private List<AndroidForWorkAppConfigurationSchema> androidForWorkAppConfigurationSchemas;
        private List<AndroidForWorkEnrollmentProfile> androidForWorkEnrollmentProfiles;
        private AndroidForWorkSettings androidForWorkSettings;
        private AndroidManagedStoreAccountEnterpriseSettings androidManagedStoreAccountEnterpriseSettings;
        private List<AndroidManagedStoreAppConfigurationSchema> androidManagedStoreAppConfigurationSchemas;
        private List<AuditEvent> auditEvents;
        private List<DeviceAndAppManagementAssignmentFilter> assignmentFilters;
        private List<ChromeOSOnboardingSettings> chromeOSOnboardingSettings;
        private List<TermsAndConditions> termsAndConditions;
        private AdvancedThreatProtectionOnboardingStateSummary advancedThreatProtectionOnboardingStateSummary;
        private List<CartToClassAssociation> cartToClassAssociations;
        private List<DeviceCompliancePolicy> deviceCompliancePolicies;
        private DeviceCompliancePolicyDeviceStateSummary deviceCompliancePolicyDeviceStateSummary;
        private List<DeviceCompliancePolicySettingStateSummary> deviceCompliancePolicySettingStateSummaries;
        private List<DeviceConfigurationConflictSummary> deviceConfigurationConflictSummary;
        private DeviceConfigurationDeviceStateSummary deviceConfigurationDeviceStateSummaries;
        private List<RestrictedAppsViolation> deviceConfigurationRestrictedAppsViolations;
        private List<DeviceConfiguration> deviceConfigurations;
        private List<ManagedAllDeviceCertificateState> deviceConfigurationsAllManagedDeviceCertificateStates;
        private DeviceConfigurationUserStateSummary deviceConfigurationUserStateSummaries;
        private List<IosUpdateDeviceStatus> iosUpdateStatuses;
        private List<MacOSSoftwareUpdateAccountSummary> macOSSoftwareUpdateAccountSummaries;
        private List<ManagedDeviceEncryptionState> managedDeviceEncryptionStates;
        private List<NdesConnector> ndesConnectors;
        private List<DeviceManagementConfigurationCategory> complianceCategories;
        private List<DeviceManagementCompliancePolicy> compliancePolicies;
        private List<DeviceManagementConfigurationSettingDefinition> complianceSettings;
        private List<DeviceManagementConfigurationCategory> configurationCategories;
        private List<DeviceManagementConfigurationPolicy> configurationPolicies;
        private List<DeviceManagementConfigurationPolicyTemplate> configurationPolicyTemplates;
        private List<DeviceManagementConfigurationSettingDefinition> configurationSettings;
        private List<DeviceManagementReusablePolicySetting> reusablePolicySettings;
        private List<DeviceManagementConfigurationSettingDefinition> reusableSettings;
        private List<DeviceManagementConfigurationSettingTemplate> templateSettings;
        private List<ComplianceManagementPartner> complianceManagementPartners;
        private OnPremisesConditionalAccessSettings conditionalAccessSettings;
        private List<DeviceCategory> deviceCategories;
        private List<DeviceEnrollmentConfiguration> deviceEnrollmentConfigurations;
        private List<DeviceManagementPartner> deviceManagementPartners;
        private List<DeviceManagementExchangeConnector> exchangeConnectors;
        private List<DeviceManagementExchangeOnPremisesPolicy> exchangeOnPremisesPolicies;
        private DeviceManagementExchangeOnPremisesPolicy exchangeOnPremisesPolicy;
        private List<MobileThreatDefenseConnector> mobileThreatDefenseConnectors;
        private List<DeviceManagementSettingCategory> categories;
        private List<DeviceManagementIntent> intents;
        private List<DeviceManagementSettingDefinition> settingDefinitions;
        private List<DeviceManagementTemplate> templates;
        private ApplePushNotificationCertificate applePushNotificationCertificate;
        private List<CloudPCConnectivityIssue> cloudPCConnectivityIssues;
        private List<ManagedDevice> comanagedDevices;
        private List<ComanagementEligibleDevice> comanagementEligibleDevices;
        private List<DataSharingConsent> dataSharingConsents;
        private List<DetectedApp> detectedApps;
        private List<DeviceComplianceScript> deviceComplianceScripts;
        private List<DeviceCustomAttributeShellScript> deviceCustomAttributeShellScripts;
        private List<DeviceHealthScript> deviceHealthScripts;
        private List<DeviceManagementScript> deviceManagementScripts;
        private List<DeviceShellScript> deviceShellScripts;
        private List<ManagedDevice> managedDevices;
        private List<MobileAppTroubleshootingEvent> mobileAppTroubleshootingEvents;
        private List<OemWarrantyInformationOnboarding> oemWarrantyInformationOnboarding;
        private List<RemoteActionAudit> remoteActionAudits;
        private List<UserExperienceAnalyticsAppHealthApplicationPerformance> userExperienceAnalyticsAppHealthApplicationPerformance;
        private List<UserExperienceAnalyticsAppHealthAppPerformanceByAppVersion> userExperienceAnalyticsAppHealthApplicationPerformanceByAppVersion;
        private List<UserExperienceAnalyticsAppHealthAppPerformanceByAppVersionDetails> userExperienceAnalyticsAppHealthApplicationPerformanceByAppVersionDetails;
        private List<UserExperienceAnalyticsAppHealthAppPerformanceByAppVersionDeviceId> userExperienceAnalyticsAppHealthApplicationPerformanceByAppVersionDeviceId;
        private List<UserExperienceAnalyticsAppHealthAppPerformanceByOSVersion> userExperienceAnalyticsAppHealthApplicationPerformanceByOSVersion;
        private List<UserExperienceAnalyticsAppHealthDeviceModelPerformance> userExperienceAnalyticsAppHealthDeviceModelPerformance;
        private List<UserExperienceAnalyticsAppHealthDevicePerformance> userExperienceAnalyticsAppHealthDevicePerformance;
        private List<UserExperienceAnalyticsAppHealthDevicePerformanceDetails> userExperienceAnalyticsAppHealthDevicePerformanceDetails;
        private List<UserExperienceAnalyticsAppHealthOSVersionPerformance> userExperienceAnalyticsAppHealthOSVersionPerformance;
        private UserExperienceAnalyticsCategory userExperienceAnalyticsAppHealthOverview;
        private List<UserExperienceAnalyticsBaseline> userExperienceAnalyticsBaselines;
        private List<UserExperienceAnalyticsBatteryHealthAppImpact> userExperienceAnalyticsBatteryHealthAppImpact;
        private UserExperienceAnalyticsBatteryHealthCapacityDetails userExperienceAnalyticsBatteryHealthCapacityDetails;
        private List<UserExperienceAnalyticsBatteryHealthDeviceAppImpact> userExperienceAnalyticsBatteryHealthDeviceAppImpact;
        private List<UserExperienceAnalyticsBatteryHealthDevicePerformance> userExperienceAnalyticsBatteryHealthDevicePerformance;
        private List<UserExperienceAnalyticsBatteryHealthDeviceRuntimeHistory> userExperienceAnalyticsBatteryHealthDeviceRuntimeHistory;
        private List<UserExperienceAnalyticsBatteryHealthModelPerformance> userExperienceAnalyticsBatteryHealthModelPerformance;
        private List<UserExperienceAnalyticsBatteryHealthOsPerformance> userExperienceAnalyticsBatteryHealthOsPerformance;
        private UserExperienceAnalyticsBatteryHealthRuntimeDetails userExperienceAnalyticsBatteryHealthRuntimeDetails;
        private List<UserExperienceAnalyticsCategory> userExperienceAnalyticsCategories;
        private List<UserExperienceAnalyticsMetricHistory> userExperienceAnalyticsDeviceMetricHistory;
        private List<UserExperienceAnalyticsDevicePerformance> userExperienceAnalyticsDevicePerformance;
        private List<UserExperienceAnalyticsDeviceScores> userExperienceAnalyticsDeviceScores;
        private List<UserExperienceAnalyticsDeviceStartupHistory> userExperienceAnalyticsDeviceStartupHistory;
        private List<UserExperienceAnalyticsDeviceStartupProcess> userExperienceAnalyticsDeviceStartupProcesses;
        private List<UserExperienceAnalyticsDeviceStartupProcessPerformance> userExperienceAnalyticsDeviceStartupProcessPerformance;
        private List<UserExperienceAnalyticsDeviceWithoutCloudIdentity> userExperienceAnalyticsDevicesWithoutCloudIdentity;
        private List<UserExperienceAnalyticsImpactingProcess> userExperienceAnalyticsImpactingProcess;
        private List<UserExperienceAnalyticsMetricHistory> userExperienceAnalyticsMetricHistory;
        private List<UserExperienceAnalyticsModelScores> userExperienceAnalyticsModelScores;
        private List<UserExperienceAnalyticsNotAutopilotReadyDevice> userExperienceAnalyticsNotAutopilotReadyDevice;
        private UserExperienceAnalyticsOverview userExperienceAnalyticsOverview;
        private UserExperienceAnalyticsRegressionSummary userExperienceAnalyticsRegressionSummary;
        private List<UserExperienceAnalyticsRemoteConnection> userExperienceAnalyticsRemoteConnection;
        private List<UserExperienceAnalyticsResourcePerformance> userExperienceAnalyticsResourcePerformance;
        private List<UserExperienceAnalyticsScoreHistory> userExperienceAnalyticsScoreHistory;
        private UserExperienceAnalyticsWorkFromAnywhereHardwareReadinessMetric userExperienceAnalyticsWorkFromAnywhereHardwareReadinessMetric;
        private List<UserExperienceAnalyticsWorkFromAnywhereMetric> userExperienceAnalyticsWorkFromAnywhereMetrics;
        private List<UserExperienceAnalyticsWorkFromAnywhereModelPerformance> userExperienceAnalyticsWorkFromAnywhereModelPerformance;
        private List<WindowsMalwareInformation> windowsMalwareInformation;
        private List<DeviceManagementDerivedCredentialSettings> derivedCredentials;
        private List<DeviceManagementResourceAccessProfileBase> resourceAccessProfiles;
        private List<AppleUserInitiatedEnrollmentProfile> appleUserInitiatedEnrollmentProfiles;
        private List<DepOnboardingSetting> depOnboardingSettings;
        private List<ImportedDeviceIdentity> importedDeviceIdentities;
        private List<ImportedWindowsAutopilotDeviceIdentity> importedWindowsAutopilotDeviceIdentities;
        private List<WindowsAutopilotDeploymentProfile> windowsAutopilotDeploymentProfiles;
        private List<WindowsAutopilotDeviceIdentity> windowsAutopilotDeviceIdentities;
        private WindowsAutopilotSettings windowsAutopilotSettings;
        private List<ManagementCondition> managementConditions;
        private List<ManagementConditionStatement> managementConditionStatements;
        private List<GroupPolicyMigrationReport> groupPolicyMigrationReports;
        private List<GroupPolicyObjectFile> groupPolicyObjectFiles;
        private List<GroupPolicyCategory> groupPolicyCategories;
        private List<GroupPolicyConfiguration> groupPolicyConfigurations;
        private List<GroupPolicyDefinitionFile> groupPolicyDefinitionFiles;
        private List<GroupPolicyDefinition> groupPolicyDefinitions;
        private List<GroupPolicyUploadedDefinitionFile> groupPolicyUploadedDefinitionFiles;
        private List<MicrosoftTunnelConfiguration> microsoftTunnelConfigurations;
        private List<MicrosoftTunnelHealthThreshold> microsoftTunnelHealthThresholds;
        private List<MicrosoftTunnelServerLogCollectionResponse> microsoftTunnelServerLogCollectionResponses;
        private List<MicrosoftTunnelSite> microsoftTunnelSites;
        private List<NotificationMessageTemplate> notificationMessageTemplates;
        private List<DeviceManagementDomainJoinConnector> domainJoinConnectors;
        private List<ConfigManagerCollection> configManagerCollections;
        private List<ResourceOperation> resourceOperations;
        private List<DeviceAndAppManagementRoleAssignment> roleAssignments;
        private List<RoleDefinition> roleDefinitions;
        private List<RoleScopeTag> roleScopeTags;
        private List<RemoteAssistancePartner> remoteAssistancePartners;
        private RemoteAssistanceSettings remoteAssistanceSettings;
        private DeviceManagementReports reports;
        private List<EmbeddedSIMActivationCodePool> embeddedSIMActivationCodePools;
        private List<TelecomExpenseManagementPartner> telecomExpenseManagementPartners;
        private List<DeviceManagementAutopilotEvent> autopilotEvents;
        private List<DeviceManagementTroubleshootingEvent> troubleshootingEvents;
        private List<WindowsDriverUpdateProfile> windowsDriverUpdateProfiles;
        private List<WindowsFeatureUpdateProfile> windowsFeatureUpdateProfiles;
        private List<WindowsQualityUpdateProfile> windowsQualityUpdateProfiles;
        private List<WindowsUpdateCatalogItem> windowsUpdateCatalogItems;
        private List<IntuneBrandingProfile> intuneBrandingProfiles;
        private List<WindowsInformationProtectionAppLearningSummary> windowsInformationProtectionAppLearningSummaries;
        private List<WindowsInformationProtectionNetworkLearningSummary> windowsInformationProtectionNetworkLearningSummaries;
        private List<CertificateConnectorDetails> certificateConnectorDetails;
        private List<UserPFXCertificate> userPfxCertificates;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“The last requested time of device compliance reporting for this account. This
         * property is read-only.”</i>
         * <p>
         * <b>Org.OData.Core.V1.Computed</b>
         * <p>
         * true
         * <p>
         * <b>Org.OData.Core.V1.Permissions</b>
         * 
         * @param deviceComplianceReportSummarizationDateTime
         *            value of {@code deviceComplianceReportSummarizationDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceComplianceReportSummarizationDateTime(OffsetDateTime deviceComplianceReportSummarizationDateTime) {
            this.deviceComplianceReportSummarizationDateTime = deviceComplianceReportSummarizationDateTime;
            this.changedFields = changedFields.add("deviceComplianceReportSummarizationDateTime");
            return this;
        }

        /**
         * <i>“Intune Account Id for given tenant”</i>
         * 
         * @param intuneAccountId
         *            value of {@code intuneAccountId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder intuneAccountId(UUID intuneAccountId) {
            this.intuneAccountId = intuneAccountId;
            this.changedFields = changedFields.add("intuneAccountId");
            return this;
        }

        /**
         * <i>“The last modified time of reporting for this account. This property is read-only
         * .”</i>
         * <p>
         * <b>Org.OData.Core.V1.Computed</b>
         * <p>
         * true
         * <p>
         * <b>Org.OData.Core.V1.Permissions</b>
         * 
         * @param lastReportAggregationDateTime
         *            value of {@code lastReportAggregationDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder lastReportAggregationDateTime(OffsetDateTime lastReportAggregationDateTime) {
            this.lastReportAggregationDateTime = lastReportAggregationDateTime;
            this.changedFields = changedFields.add("lastReportAggregationDateTime");
            return this;
        }

        /**
         * <i>“The property to enable Non-MDM managed legacy PC management for this account.
         * This property is read-only.”</i>
         * <p>
         * <b>Org.OData.Core.V1.Computed</b>
         * <p>
         * true
         * <p>
         * <b>Org.OData.Core.V1.Permissions</b>
         * 
         * @param legacyPcManangementEnabled
         *            value of {@code legacyPcManangementEnabled} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder legacyPcManangementEnabled(Boolean legacyPcManangementEnabled) {
            this.legacyPcManangementEnabled = legacyPcManangementEnabled;
            this.changedFields = changedFields.add("legacyPcManangementEnabled");
            return this;
        }

        /**
         * <i>“Maximum number of dep tokens allowed per-tenant.”</i>
         * 
         * @param maximumDepTokens
         *            value of {@code maximumDepTokens} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder maximumDepTokens(Integer maximumDepTokens) {
            this.maximumDepTokens = maximumDepTokens;
            this.changedFields = changedFields.add("maximumDepTokens");
            return this;
        }

        /**
         * <i>“Account level settings.”</i>
         * 
         * @param settings
         *            value of {@code settings} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder settings(DeviceManagementSettings settings) {
            this.settings = settings;
            this.changedFields = changedFields.add("settings");
            return this;
        }

        /**
         * <i>“When enabled, users assigned as administrators via Role Assignment Memberships
         * do not require an assigned Intune license. Prior to this, only Intune licensed
         * users were granted permissions with an Intune role unless they were assigned a
         * role via Azure Active Directory. You are limited to 350 unlicensed direct
         * members for each AAD security group in a role assignment, but you can assign
         * multiple AAD security groups to a role if you need to support more than 350
         * unlicensed administrators. Licensed administrators are unaffected, do not have
         * to be direct members, nor does the 350 member limit apply. This property is read
         * -only.”</i>
         * <p>
         * <b>Org.OData.Core.V1.Computed</b>
         * <p>
         * true
         * <p>
         * <b>Org.OData.Core.V1.Permissions</b>
         * 
         * @param unlicensedAdminstratorsEnabled
         *            value of {@code unlicensedAdminstratorsEnabled} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder unlicensedAdminstratorsEnabled(Boolean unlicensedAdminstratorsEnabled) {
            this.unlicensedAdminstratorsEnabled = unlicensedAdminstratorsEnabled;
            this.changedFields = changedFields.add("unlicensedAdminstratorsEnabled");
            return this;
        }

        /**
         * <i>“intuneBrand contains data which is used in customizing the appearance of the
         * Company Portal applications as well as the end user web portal.”</i>
         * 
         * @param intuneBrand
         *            value of {@code intuneBrand} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder intuneBrand(IntuneBrand intuneBrand) {
            this.intuneBrand = intuneBrand;
            this.changedFields = changedFields.add("intuneBrand");
            return this;
        }

        /**
         * <i>“The date &amp; time when tenant data moved between scaleunits.”</i>
         * 
         * @param accountMoveCompletionDateTime
         *            value of {@code accountMoveCompletionDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder accountMoveCompletionDateTime(OffsetDateTime accountMoveCompletionDateTime) {
            this.accountMoveCompletionDateTime = accountMoveCompletionDateTime;
            this.changedFields = changedFields.add("accountMoveCompletionDateTime");
            return this;
        }

        /**
         * <i>“Admin consent information.”</i>
         * 
         * @param adminConsent
         *            value of {@code adminConsent} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder adminConsent(AdminConsent adminConsent) {
            this.adminConsent = adminConsent;
            this.changedFields = changedFields.add("adminConsent");
            return this;
        }

        /**
         * <i>“Device protection overview.”</i>
         * 
         * @param deviceProtectionOverview
         *            value of {@code deviceProtectionOverview} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceProtectionOverview(DeviceProtectionOverview deviceProtectionOverview) {
            this.deviceProtectionOverview = deviceProtectionOverview;
            this.changedFields = changedFields.add("deviceProtectionOverview");
            return this;
        }

        /**
         * <i>“Device cleanup rule”</i>
         * 
         * @param managedDeviceCleanupSettings
         *            value of {@code managedDeviceCleanupSettings} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder managedDeviceCleanupSettings(ManagedDeviceCleanupSettings managedDeviceCleanupSettings) {
            this.managedDeviceCleanupSettings = managedDeviceCleanupSettings;
            this.changedFields = changedFields.add("managedDeviceCleanupSettings");
            return this;
        }

        /**
         * <i>“Tenant's Subscription.”</i>
         * 
         * @param subscriptions
         *            value of {@code subscriptions} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder subscriptions(DeviceManagementSubscriptions subscriptions) {
            this.subscriptions = subscriptions;
            this.changedFields = changedFields.add("subscriptions");
            return this;
        }

        /**
         * <i>“Tenant mobile device management subscription state.”</i>
         * 
         * @param subscriptionState
         *            value of {@code subscriptionState} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder subscriptionState(DeviceManagementSubscriptionState subscriptionState) {
            this.subscriptionState = subscriptionState;
            this.changedFields = changedFields.add("subscriptionState");
            return this;
        }

        /**
         * <i>“User experience analytics device settings”</i>
         * 
         * @param userExperienceAnalyticsSettings
         *            value of {@code userExperienceAnalyticsSettings} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userExperienceAnalyticsSettings(UserExperienceAnalyticsSettings userExperienceAnalyticsSettings) {
            this.userExperienceAnalyticsSettings = userExperienceAnalyticsSettings;
            this.changedFields = changedFields.add("userExperienceAnalyticsSettings");
            return this;
        }

        /**
         * <i>“Malware overview for windows devices.”</i>
         * 
         * @param windowsMalwareOverview
         *            value of {@code windowsMalwareOverview} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder windowsMalwareOverview(WindowsMalwareOverview windowsMalwareOverview) {
            this.windowsMalwareOverview = windowsMalwareOverview;
            this.changedFields = changedFields.add("windowsMalwareOverview");
            return this;
        }

        /**
         * <i>“Android device owner enrollment profile entities.”</i>
         * 
         * @param androidDeviceOwnerEnrollmentProfiles
         *            value of {@code androidDeviceOwnerEnrollmentProfiles} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder androidDeviceOwnerEnrollmentProfiles(List<AndroidDeviceOwnerEnrollmentProfile> androidDeviceOwnerEnrollmentProfiles) {
            this.androidDeviceOwnerEnrollmentProfiles = androidDeviceOwnerEnrollmentProfiles;
            this.changedFields = changedFields.add("androidDeviceOwnerEnrollmentProfiles");
            return this;
        }

        /**
         * <i>“Android device owner enrollment profile entities.”</i>
         * 
         * @param androidDeviceOwnerEnrollmentProfiles
         *            value of {@code androidDeviceOwnerEnrollmentProfiles} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder androidDeviceOwnerEnrollmentProfiles(AndroidDeviceOwnerEnrollmentProfile... androidDeviceOwnerEnrollmentProfiles) {
            return androidDeviceOwnerEnrollmentProfiles(Arrays.asList(androidDeviceOwnerEnrollmentProfiles));
        }

        public Builder virtualEndpoint(VirtualEndpoint virtualEndpoint) {
            this.virtualEndpoint = virtualEndpoint;
            this.changedFields = changedFields.add("virtualEndpoint");
            return this;
        }

        /**
         * <i>“Android for Work app configuration schema entities.”</i>
         * 
         * @param androidForWorkAppConfigurationSchemas
         *            value of {@code androidForWorkAppConfigurationSchemas} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder androidForWorkAppConfigurationSchemas(List<AndroidForWorkAppConfigurationSchema> androidForWorkAppConfigurationSchemas) {
            this.androidForWorkAppConfigurationSchemas = androidForWorkAppConfigurationSchemas;
            this.changedFields = changedFields.add("androidForWorkAppConfigurationSchemas");
            return this;
        }

        /**
         * <i>“Android for Work app configuration schema entities.”</i>
         * 
         * @param androidForWorkAppConfigurationSchemas
         *            value of {@code androidForWorkAppConfigurationSchemas} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder androidForWorkAppConfigurationSchemas(AndroidForWorkAppConfigurationSchema... androidForWorkAppConfigurationSchemas) {
            return androidForWorkAppConfigurationSchemas(Arrays.asList(androidForWorkAppConfigurationSchemas));
        }

        /**
         * <i>“Android for Work enrollment profile entities.”</i>
         * 
         * @param androidForWorkEnrollmentProfiles
         *            value of {@code androidForWorkEnrollmentProfiles} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder androidForWorkEnrollmentProfiles(List<AndroidForWorkEnrollmentProfile> androidForWorkEnrollmentProfiles) {
            this.androidForWorkEnrollmentProfiles = androidForWorkEnrollmentProfiles;
            this.changedFields = changedFields.add("androidForWorkEnrollmentProfiles");
            return this;
        }

        /**
         * <i>“Android for Work enrollment profile entities.”</i>
         * 
         * @param androidForWorkEnrollmentProfiles
         *            value of {@code androidForWorkEnrollmentProfiles} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder androidForWorkEnrollmentProfiles(AndroidForWorkEnrollmentProfile... androidForWorkEnrollmentProfiles) {
            return androidForWorkEnrollmentProfiles(Arrays.asList(androidForWorkEnrollmentProfiles));
        }

        /**
         * <i>“The singleton Android for Work settings entity.”</i>
         * 
         * @param androidForWorkSettings
         *            value of {@code androidForWorkSettings} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder androidForWorkSettings(AndroidForWorkSettings androidForWorkSettings) {
            this.androidForWorkSettings = androidForWorkSettings;
            this.changedFields = changedFields.add("androidForWorkSettings");
            return this;
        }

        /**
         * <i>“The singleton Android managed store account enterprise settings entity.”</i>
         * 
         * @param androidManagedStoreAccountEnterpriseSettings
         *            value of {@code androidManagedStoreAccountEnterpriseSettings} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder androidManagedStoreAccountEnterpriseSettings(AndroidManagedStoreAccountEnterpriseSettings androidManagedStoreAccountEnterpriseSettings) {
            this.androidManagedStoreAccountEnterpriseSettings = androidManagedStoreAccountEnterpriseSettings;
            this.changedFields = changedFields.add("androidManagedStoreAccountEnterpriseSettings");
            return this;
        }

        /**
         * <i>“Android Enterprise app configuration schema entities.”</i>
         * 
         * @param androidManagedStoreAppConfigurationSchemas
         *            value of {@code androidManagedStoreAppConfigurationSchemas} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder androidManagedStoreAppConfigurationSchemas(List<AndroidManagedStoreAppConfigurationSchema> androidManagedStoreAppConfigurationSchemas) {
            this.androidManagedStoreAppConfigurationSchemas = androidManagedStoreAppConfigurationSchemas;
            this.changedFields = changedFields.add("androidManagedStoreAppConfigurationSchemas");
            return this;
        }

        /**
         * <i>“Android Enterprise app configuration schema entities.”</i>
         * 
         * @param androidManagedStoreAppConfigurationSchemas
         *            value of {@code androidManagedStoreAppConfigurationSchemas} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder androidManagedStoreAppConfigurationSchemas(AndroidManagedStoreAppConfigurationSchema... androidManagedStoreAppConfigurationSchemas) {
            return androidManagedStoreAppConfigurationSchemas(Arrays.asList(androidManagedStoreAppConfigurationSchemas));
        }

        /**
         * <i>“The Audit Events”</i>
         * 
         * @param auditEvents
         *            value of {@code auditEvents} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder auditEvents(List<AuditEvent> auditEvents) {
            this.auditEvents = auditEvents;
            this.changedFields = changedFields.add("auditEvents");
            return this;
        }

        /**
         * <i>“The Audit Events”</i>
         * 
         * @param auditEvents
         *            value of {@code auditEvents} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder auditEvents(AuditEvent... auditEvents) {
            return auditEvents(Arrays.asList(auditEvents));
        }

        /**
         * <i>“The list of assignment filters”</i>
         * 
         * @param assignmentFilters
         *            value of {@code assignmentFilters} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder assignmentFilters(List<DeviceAndAppManagementAssignmentFilter> assignmentFilters) {
            this.assignmentFilters = assignmentFilters;
            this.changedFields = changedFields.add("assignmentFilters");
            return this;
        }

        /**
         * <i>“The list of assignment filters”</i>
         * 
         * @param assignmentFilters
         *            value of {@code assignmentFilters} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder assignmentFilters(DeviceAndAppManagementAssignmentFilter... assignmentFilters) {
            return assignmentFilters(Arrays.asList(assignmentFilters));
        }

        /**
         * <i>“Collection of ChromeOSOnboardingSettings settings associated with account.”</i>
         * 
         * @param chromeOSOnboardingSettings
         *            value of {@code chromeOSOnboardingSettings} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder chromeOSOnboardingSettings(List<ChromeOSOnboardingSettings> chromeOSOnboardingSettings) {
            this.chromeOSOnboardingSettings = chromeOSOnboardingSettings;
            this.changedFields = changedFields.add("chromeOSOnboardingSettings");
            return this;
        }

        /**
         * <i>“Collection of ChromeOSOnboardingSettings settings associated with account.”</i>
         * 
         * @param chromeOSOnboardingSettings
         *            value of {@code chromeOSOnboardingSettings} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder chromeOSOnboardingSettings(ChromeOSOnboardingSettings... chromeOSOnboardingSettings) {
            return chromeOSOnboardingSettings(Arrays.asList(chromeOSOnboardingSettings));
        }

        /**
         * <i>“The terms and conditions associated with device management of the company.”</i>
         * 
         * @param termsAndConditions
         *            value of {@code termsAndConditions} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder termsAndConditions(List<TermsAndConditions> termsAndConditions) {
            this.termsAndConditions = termsAndConditions;
            this.changedFields = changedFields.add("termsAndConditions");
            return this;
        }

        /**
         * <i>“The terms and conditions associated with device management of the company.”</i>
         * 
         * @param termsAndConditions
         *            value of {@code termsAndConditions} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder termsAndConditions(TermsAndConditions... termsAndConditions) {
            return termsAndConditions(Arrays.asList(termsAndConditions));
        }

        /**
         * <i>“The summary state of ATP onboarding state for this account.”</i>
         * 
         * @param advancedThreatProtectionOnboardingStateSummary
         *            value of {@code advancedThreatProtectionOnboardingStateSummary} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder advancedThreatProtectionOnboardingStateSummary(AdvancedThreatProtectionOnboardingStateSummary advancedThreatProtectionOnboardingStateSummary) {
            this.advancedThreatProtectionOnboardingStateSummary = advancedThreatProtectionOnboardingStateSummary;
            this.changedFields = changedFields.add("advancedThreatProtectionOnboardingStateSummary");
            return this;
        }

        /**
         * <i>“The Cart To Class Associations.”</i>
         * 
         * @param cartToClassAssociations
         *            value of {@code cartToClassAssociations} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder cartToClassAssociations(List<CartToClassAssociation> cartToClassAssociations) {
            this.cartToClassAssociations = cartToClassAssociations;
            this.changedFields = changedFields.add("cartToClassAssociations");
            return this;
        }

        /**
         * <i>“The Cart To Class Associations.”</i>
         * 
         * @param cartToClassAssociations
         *            value of {@code cartToClassAssociations} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder cartToClassAssociations(CartToClassAssociation... cartToClassAssociations) {
            return cartToClassAssociations(Arrays.asList(cartToClassAssociations));
        }

        /**
         * <i>“The device compliance policies.”</i>
         * 
         * @param deviceCompliancePolicies
         *            value of {@code deviceCompliancePolicies} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceCompliancePolicies(List<DeviceCompliancePolicy> deviceCompliancePolicies) {
            this.deviceCompliancePolicies = deviceCompliancePolicies;
            this.changedFields = changedFields.add("deviceCompliancePolicies");
            return this;
        }

        /**
         * <i>“The device compliance policies.”</i>
         * 
         * @param deviceCompliancePolicies
         *            value of {@code deviceCompliancePolicies} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceCompliancePolicies(DeviceCompliancePolicy... deviceCompliancePolicies) {
            return deviceCompliancePolicies(Arrays.asList(deviceCompliancePolicies));
        }

        /**
         * <i>“The device compliance state summary for this account.”</i>
         * 
         * @param deviceCompliancePolicyDeviceStateSummary
         *            value of {@code deviceCompliancePolicyDeviceStateSummary} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceCompliancePolicyDeviceStateSummary(DeviceCompliancePolicyDeviceStateSummary deviceCompliancePolicyDeviceStateSummary) {
            this.deviceCompliancePolicyDeviceStateSummary = deviceCompliancePolicyDeviceStateSummary;
            this.changedFields = changedFields.add("deviceCompliancePolicyDeviceStateSummary");
            return this;
        }

        /**
         * <i>“The summary states of compliance policy settings for this account.”</i>
         * 
         * @param deviceCompliancePolicySettingStateSummaries
         *            value of {@code deviceCompliancePolicySettingStateSummaries} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceCompliancePolicySettingStateSummaries(List<DeviceCompliancePolicySettingStateSummary> deviceCompliancePolicySettingStateSummaries) {
            this.deviceCompliancePolicySettingStateSummaries = deviceCompliancePolicySettingStateSummaries;
            this.changedFields = changedFields.add("deviceCompliancePolicySettingStateSummaries");
            return this;
        }

        /**
         * <i>“The summary states of compliance policy settings for this account.”</i>
         * 
         * @param deviceCompliancePolicySettingStateSummaries
         *            value of {@code deviceCompliancePolicySettingStateSummaries} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceCompliancePolicySettingStateSummaries(DeviceCompliancePolicySettingStateSummary... deviceCompliancePolicySettingStateSummaries) {
            return deviceCompliancePolicySettingStateSummaries(Arrays.asList(deviceCompliancePolicySettingStateSummaries));
        }

        /**
         * <i>“Summary of policies in conflict state for this account.”</i>
         * 
         * @param deviceConfigurationConflictSummary
         *            value of {@code deviceConfigurationConflictSummary} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceConfigurationConflictSummary(List<DeviceConfigurationConflictSummary> deviceConfigurationConflictSummary) {
            this.deviceConfigurationConflictSummary = deviceConfigurationConflictSummary;
            this.changedFields = changedFields.add("deviceConfigurationConflictSummary");
            return this;
        }

        /**
         * <i>“Summary of policies in conflict state for this account.”</i>
         * 
         * @param deviceConfigurationConflictSummary
         *            value of {@code deviceConfigurationConflictSummary} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceConfigurationConflictSummary(DeviceConfigurationConflictSummary... deviceConfigurationConflictSummary) {
            return deviceConfigurationConflictSummary(Arrays.asList(deviceConfigurationConflictSummary));
        }

        /**
         * <i>“The device configuration device state summary for this account.”</i>
         * 
         * @param deviceConfigurationDeviceStateSummaries
         *            value of {@code deviceConfigurationDeviceStateSummaries} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceConfigurationDeviceStateSummaries(DeviceConfigurationDeviceStateSummary deviceConfigurationDeviceStateSummaries) {
            this.deviceConfigurationDeviceStateSummaries = deviceConfigurationDeviceStateSummaries;
            this.changedFields = changedFields.add("deviceConfigurationDeviceStateSummaries");
            return this;
        }

        /**
         * <i>“Restricted apps violations for this account.”</i>
         * 
         * @param deviceConfigurationRestrictedAppsViolations
         *            value of {@code deviceConfigurationRestrictedAppsViolations} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceConfigurationRestrictedAppsViolations(List<RestrictedAppsViolation> deviceConfigurationRestrictedAppsViolations) {
            this.deviceConfigurationRestrictedAppsViolations = deviceConfigurationRestrictedAppsViolations;
            this.changedFields = changedFields.add("deviceConfigurationRestrictedAppsViolations");
            return this;
        }

        /**
         * <i>“Restricted apps violations for this account.”</i>
         * 
         * @param deviceConfigurationRestrictedAppsViolations
         *            value of {@code deviceConfigurationRestrictedAppsViolations} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceConfigurationRestrictedAppsViolations(RestrictedAppsViolation... deviceConfigurationRestrictedAppsViolations) {
            return deviceConfigurationRestrictedAppsViolations(Arrays.asList(deviceConfigurationRestrictedAppsViolations));
        }

        /**
         * <i>“The device configurations.”</i>
         * 
         * @param deviceConfigurations
         *            value of {@code deviceConfigurations} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceConfigurations(List<DeviceConfiguration> deviceConfigurations) {
            this.deviceConfigurations = deviceConfigurations;
            this.changedFields = changedFields.add("deviceConfigurations");
            return this;
        }

        /**
         * <i>“The device configurations.”</i>
         * 
         * @param deviceConfigurations
         *            value of {@code deviceConfigurations} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceConfigurations(DeviceConfiguration... deviceConfigurations) {
            return deviceConfigurations(Arrays.asList(deviceConfigurations));
        }

        /**
         * <i>“Summary of all certificates for all devices.”</i>
         * 
         * @param deviceConfigurationsAllManagedDeviceCertificateStates
         *            value of {@code deviceConfigurationsAllManagedDeviceCertificateStates} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceConfigurationsAllManagedDeviceCertificateStates(List<ManagedAllDeviceCertificateState> deviceConfigurationsAllManagedDeviceCertificateStates) {
            this.deviceConfigurationsAllManagedDeviceCertificateStates = deviceConfigurationsAllManagedDeviceCertificateStates;
            this.changedFields = changedFields.add("deviceConfigurationsAllManagedDeviceCertificateStates");
            return this;
        }

        /**
         * <i>“Summary of all certificates for all devices.”</i>
         * 
         * @param deviceConfigurationsAllManagedDeviceCertificateStates
         *            value of {@code deviceConfigurationsAllManagedDeviceCertificateStates} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceConfigurationsAllManagedDeviceCertificateStates(ManagedAllDeviceCertificateState... deviceConfigurationsAllManagedDeviceCertificateStates) {
            return deviceConfigurationsAllManagedDeviceCertificateStates(Arrays.asList(deviceConfigurationsAllManagedDeviceCertificateStates));
        }

        /**
         * <i>“The device configuration user state summary for this account.”</i>
         * 
         * @param deviceConfigurationUserStateSummaries
         *            value of {@code deviceConfigurationUserStateSummaries} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceConfigurationUserStateSummaries(DeviceConfigurationUserStateSummary deviceConfigurationUserStateSummaries) {
            this.deviceConfigurationUserStateSummaries = deviceConfigurationUserStateSummaries;
            this.changedFields = changedFields.add("deviceConfigurationUserStateSummaries");
            return this;
        }

        /**
         * <i>“The IOS software update installation statuses for this account.”</i>
         * 
         * @param iosUpdateStatuses
         *            value of {@code iosUpdateStatuses} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder iosUpdateStatuses(List<IosUpdateDeviceStatus> iosUpdateStatuses) {
            this.iosUpdateStatuses = iosUpdateStatuses;
            this.changedFields = changedFields.add("iosUpdateStatuses");
            return this;
        }

        /**
         * <i>“The IOS software update installation statuses for this account.”</i>
         * 
         * @param iosUpdateStatuses
         *            value of {@code iosUpdateStatuses} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder iosUpdateStatuses(IosUpdateDeviceStatus... iosUpdateStatuses) {
            return iosUpdateStatuses(Arrays.asList(iosUpdateStatuses));
        }

        /**
         * <i>“The MacOS software update account summaries for this account.”</i>
         * 
         * @param macOSSoftwareUpdateAccountSummaries
         *            value of {@code macOSSoftwareUpdateAccountSummaries} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder macOSSoftwareUpdateAccountSummaries(List<MacOSSoftwareUpdateAccountSummary> macOSSoftwareUpdateAccountSummaries) {
            this.macOSSoftwareUpdateAccountSummaries = macOSSoftwareUpdateAccountSummaries;
            this.changedFields = changedFields.add("macOSSoftwareUpdateAccountSummaries");
            return this;
        }

        /**
         * <i>“The MacOS software update account summaries for this account.”</i>
         * 
         * @param macOSSoftwareUpdateAccountSummaries
         *            value of {@code macOSSoftwareUpdateAccountSummaries} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder macOSSoftwareUpdateAccountSummaries(MacOSSoftwareUpdateAccountSummary... macOSSoftwareUpdateAccountSummaries) {
            return macOSSoftwareUpdateAccountSummaries(Arrays.asList(macOSSoftwareUpdateAccountSummaries));
        }

        /**
         * <i>“Encryption report for devices in this account”</i>
         * 
         * @param managedDeviceEncryptionStates
         *            value of {@code managedDeviceEncryptionStates} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder managedDeviceEncryptionStates(List<ManagedDeviceEncryptionState> managedDeviceEncryptionStates) {
            this.managedDeviceEncryptionStates = managedDeviceEncryptionStates;
            this.changedFields = changedFields.add("managedDeviceEncryptionStates");
            return this;
        }

        /**
         * <i>“Encryption report for devices in this account”</i>
         * 
         * @param managedDeviceEncryptionStates
         *            value of {@code managedDeviceEncryptionStates} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder managedDeviceEncryptionStates(ManagedDeviceEncryptionState... managedDeviceEncryptionStates) {
            return managedDeviceEncryptionStates(Arrays.asList(managedDeviceEncryptionStates));
        }

        /**
         * <i>“The collection of Ndes connectors for this account.”</i>
         * 
         * @param ndesConnectors
         *            value of {@code ndesConnectors} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder ndesConnectors(List<NdesConnector> ndesConnectors) {
            this.ndesConnectors = ndesConnectors;
            this.changedFields = changedFields.add("ndesConnectors");
            return this;
        }

        /**
         * <i>“The collection of Ndes connectors for this account.”</i>
         * 
         * @param ndesConnectors
         *            value of {@code ndesConnectors} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder ndesConnectors(NdesConnector... ndesConnectors) {
            return ndesConnectors(Arrays.asList(ndesConnectors));
        }

        /**
         * <i>“List of all compliance categories”</i>
         * 
         * @param complianceCategories
         *            value of {@code complianceCategories} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder complianceCategories(List<DeviceManagementConfigurationCategory> complianceCategories) {
            this.complianceCategories = complianceCategories;
            this.changedFields = changedFields.add("complianceCategories");
            return this;
        }

        /**
         * <i>“List of all compliance categories”</i>
         * 
         * @param complianceCategories
         *            value of {@code complianceCategories} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder complianceCategories(DeviceManagementConfigurationCategory... complianceCategories) {
            return complianceCategories(Arrays.asList(complianceCategories));
        }

        /**
         * <i>“List of all compliance policies”</i>
         * 
         * @param compliancePolicies
         *            value of {@code compliancePolicies} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder compliancePolicies(List<DeviceManagementCompliancePolicy> compliancePolicies) {
            this.compliancePolicies = compliancePolicies;
            this.changedFields = changedFields.add("compliancePolicies");
            return this;
        }

        /**
         * <i>“List of all compliance policies”</i>
         * 
         * @param compliancePolicies
         *            value of {@code compliancePolicies} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder compliancePolicies(DeviceManagementCompliancePolicy... compliancePolicies) {
            return compliancePolicies(Arrays.asList(compliancePolicies));
        }

        /**
         * <i>“List of all ComplianceSettings”</i>
         * 
         * @param complianceSettings
         *            value of {@code complianceSettings} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder complianceSettings(List<DeviceManagementConfigurationSettingDefinition> complianceSettings) {
            this.complianceSettings = complianceSettings;
            this.changedFields = changedFields.add("complianceSettings");
            return this;
        }

        /**
         * <i>“List of all ComplianceSettings”</i>
         * 
         * @param complianceSettings
         *            value of {@code complianceSettings} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder complianceSettings(DeviceManagementConfigurationSettingDefinition... complianceSettings) {
            return complianceSettings(Arrays.asList(complianceSettings));
        }

        /**
         * <i>“List of all Configuration Categories”</i>
         * 
         * @param configurationCategories
         *            value of {@code configurationCategories} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder configurationCategories(List<DeviceManagementConfigurationCategory> configurationCategories) {
            this.configurationCategories = configurationCategories;
            this.changedFields = changedFields.add("configurationCategories");
            return this;
        }

        /**
         * <i>“List of all Configuration Categories”</i>
         * 
         * @param configurationCategories
         *            value of {@code configurationCategories} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder configurationCategories(DeviceManagementConfigurationCategory... configurationCategories) {
            return configurationCategories(Arrays.asList(configurationCategories));
        }

        /**
         * <i>“List of all Configuration policies”</i>
         * 
         * @param configurationPolicies
         *            value of {@code configurationPolicies} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder configurationPolicies(List<DeviceManagementConfigurationPolicy> configurationPolicies) {
            this.configurationPolicies = configurationPolicies;
            this.changedFields = changedFields.add("configurationPolicies");
            return this;
        }

        /**
         * <i>“List of all Configuration policies”</i>
         * 
         * @param configurationPolicies
         *            value of {@code configurationPolicies} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder configurationPolicies(DeviceManagementConfigurationPolicy... configurationPolicies) {
            return configurationPolicies(Arrays.asList(configurationPolicies));
        }

        /**
         * <i>“List of all templates”</i>
         * 
         * @param configurationPolicyTemplates
         *            value of {@code configurationPolicyTemplates} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder configurationPolicyTemplates(List<DeviceManagementConfigurationPolicyTemplate> configurationPolicyTemplates) {
            this.configurationPolicyTemplates = configurationPolicyTemplates;
            this.changedFields = changedFields.add("configurationPolicyTemplates");
            return this;
        }

        /**
         * <i>“List of all templates”</i>
         * 
         * @param configurationPolicyTemplates
         *            value of {@code configurationPolicyTemplates} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder configurationPolicyTemplates(DeviceManagementConfigurationPolicyTemplate... configurationPolicyTemplates) {
            return configurationPolicyTemplates(Arrays.asList(configurationPolicyTemplates));
        }

        /**
         * <i>“List of all ConfigurationSettings”</i>
         * 
         * @param configurationSettings
         *            value of {@code configurationSettings} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder configurationSettings(List<DeviceManagementConfigurationSettingDefinition> configurationSettings) {
            this.configurationSettings = configurationSettings;
            this.changedFields = changedFields.add("configurationSettings");
            return this;
        }

        /**
         * <i>“List of all ConfigurationSettings”</i>
         * 
         * @param configurationSettings
         *            value of {@code configurationSettings} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder configurationSettings(DeviceManagementConfigurationSettingDefinition... configurationSettings) {
            return configurationSettings(Arrays.asList(configurationSettings));
        }

        /**
         * <i>“List of all reusable settings that can be referred in a policy”</i>
         * 
         * @param reusablePolicySettings
         *            value of {@code reusablePolicySettings} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder reusablePolicySettings(List<DeviceManagementReusablePolicySetting> reusablePolicySettings) {
            this.reusablePolicySettings = reusablePolicySettings;
            this.changedFields = changedFields.add("reusablePolicySettings");
            return this;
        }

        /**
         * <i>“List of all reusable settings that can be referred in a policy”</i>
         * 
         * @param reusablePolicySettings
         *            value of {@code reusablePolicySettings} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder reusablePolicySettings(DeviceManagementReusablePolicySetting... reusablePolicySettings) {
            return reusablePolicySettings(Arrays.asList(reusablePolicySettings));
        }

        /**
         * <i>“List of all reusable settings”</i>
         * 
         * @param reusableSettings
         *            value of {@code reusableSettings} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder reusableSettings(List<DeviceManagementConfigurationSettingDefinition> reusableSettings) {
            this.reusableSettings = reusableSettings;
            this.changedFields = changedFields.add("reusableSettings");
            return this;
        }

        /**
         * <i>“List of all reusable settings”</i>
         * 
         * @param reusableSettings
         *            value of {@code reusableSettings} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder reusableSettings(DeviceManagementConfigurationSettingDefinition... reusableSettings) {
            return reusableSettings(Arrays.asList(reusableSettings));
        }

        /**
         * <i>“List of all TemplateSettings”</i>
         * 
         * @param templateSettings
         *            value of {@code templateSettings} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder templateSettings(List<DeviceManagementConfigurationSettingTemplate> templateSettings) {
            this.templateSettings = templateSettings;
            this.changedFields = changedFields.add("templateSettings");
            return this;
        }

        /**
         * <i>“List of all TemplateSettings”</i>
         * 
         * @param templateSettings
         *            value of {@code templateSettings} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder templateSettings(DeviceManagementConfigurationSettingTemplate... templateSettings) {
            return templateSettings(Arrays.asList(templateSettings));
        }

        /**
         * <i>“The list of Compliance Management Partners configured by the tenant.”</i>
         * 
         * @param complianceManagementPartners
         *            value of {@code complianceManagementPartners} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder complianceManagementPartners(List<ComplianceManagementPartner> complianceManagementPartners) {
            this.complianceManagementPartners = complianceManagementPartners;
            this.changedFields = changedFields.add("complianceManagementPartners");
            return this;
        }

        /**
         * <i>“The list of Compliance Management Partners configured by the tenant.”</i>
         * 
         * @param complianceManagementPartners
         *            value of {@code complianceManagementPartners} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder complianceManagementPartners(ComplianceManagementPartner... complianceManagementPartners) {
            return complianceManagementPartners(Arrays.asList(complianceManagementPartners));
        }

        /**
         * <i>“The Exchange on premises conditional access settings. On premises conditional
         * access will require devices to be both enrolled and compliant for mail access”</i>
         * 
         * @param conditionalAccessSettings
         *            value of {@code conditionalAccessSettings} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder conditionalAccessSettings(OnPremisesConditionalAccessSettings conditionalAccessSettings) {
            this.conditionalAccessSettings = conditionalAccessSettings;
            this.changedFields = changedFields.add("conditionalAccessSettings");
            return this;
        }

        /**
         * <i>“The list of device categories with the tenant.”</i>
         * 
         * @param deviceCategories
         *            value of {@code deviceCategories} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceCategories(List<DeviceCategory> deviceCategories) {
            this.deviceCategories = deviceCategories;
            this.changedFields = changedFields.add("deviceCategories");
            return this;
        }

        /**
         * <i>“The list of device categories with the tenant.”</i>
         * 
         * @param deviceCategories
         *            value of {@code deviceCategories} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceCategories(DeviceCategory... deviceCategories) {
            return deviceCategories(Arrays.asList(deviceCategories));
        }

        /**
         * <i>“The list of device enrollment configurations”</i>
         * 
         * @param deviceEnrollmentConfigurations
         *            value of {@code deviceEnrollmentConfigurations} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceEnrollmentConfigurations(List<DeviceEnrollmentConfiguration> deviceEnrollmentConfigurations) {
            this.deviceEnrollmentConfigurations = deviceEnrollmentConfigurations;
            this.changedFields = changedFields.add("deviceEnrollmentConfigurations");
            return this;
        }

        /**
         * <i>“The list of device enrollment configurations”</i>
         * 
         * @param deviceEnrollmentConfigurations
         *            value of {@code deviceEnrollmentConfigurations} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceEnrollmentConfigurations(DeviceEnrollmentConfiguration... deviceEnrollmentConfigurations) {
            return deviceEnrollmentConfigurations(Arrays.asList(deviceEnrollmentConfigurations));
        }

        /**
         * <i>“The list of Device Management Partners configured by the tenant.”</i>
         * 
         * @param deviceManagementPartners
         *            value of {@code deviceManagementPartners} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceManagementPartners(List<DeviceManagementPartner> deviceManagementPartners) {
            this.deviceManagementPartners = deviceManagementPartners;
            this.changedFields = changedFields.add("deviceManagementPartners");
            return this;
        }

        /**
         * <i>“The list of Device Management Partners configured by the tenant.”</i>
         * 
         * @param deviceManagementPartners
         *            value of {@code deviceManagementPartners} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceManagementPartners(DeviceManagementPartner... deviceManagementPartners) {
            return deviceManagementPartners(Arrays.asList(deviceManagementPartners));
        }

        /**
         * <i>“The list of Exchange Connectors configured by the tenant.”</i>
         * 
         * @param exchangeConnectors
         *            value of {@code exchangeConnectors} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder exchangeConnectors(List<DeviceManagementExchangeConnector> exchangeConnectors) {
            this.exchangeConnectors = exchangeConnectors;
            this.changedFields = changedFields.add("exchangeConnectors");
            return this;
        }

        /**
         * <i>“The list of Exchange Connectors configured by the tenant.”</i>
         * 
         * @param exchangeConnectors
         *            value of {@code exchangeConnectors} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder exchangeConnectors(DeviceManagementExchangeConnector... exchangeConnectors) {
            return exchangeConnectors(Arrays.asList(exchangeConnectors));
        }

        /**
         * <i>“The list of Exchange On Premisis policies configured by the tenant.”</i>
         * 
         * @param exchangeOnPremisesPolicies
         *            value of {@code exchangeOnPremisesPolicies} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder exchangeOnPremisesPolicies(List<DeviceManagementExchangeOnPremisesPolicy> exchangeOnPremisesPolicies) {
            this.exchangeOnPremisesPolicies = exchangeOnPremisesPolicies;
            this.changedFields = changedFields.add("exchangeOnPremisesPolicies");
            return this;
        }

        /**
         * <i>“The list of Exchange On Premisis policies configured by the tenant.”</i>
         * 
         * @param exchangeOnPremisesPolicies
         *            value of {@code exchangeOnPremisesPolicies} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder exchangeOnPremisesPolicies(DeviceManagementExchangeOnPremisesPolicy... exchangeOnPremisesPolicies) {
            return exchangeOnPremisesPolicies(Arrays.asList(exchangeOnPremisesPolicies));
        }

        /**
         * <i>“The policy which controls mobile device access to Exchange On Premises”</i>
         * 
         * @param exchangeOnPremisesPolicy
         *            value of {@code exchangeOnPremisesPolicy} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder exchangeOnPremisesPolicy(DeviceManagementExchangeOnPremisesPolicy exchangeOnPremisesPolicy) {
            this.exchangeOnPremisesPolicy = exchangeOnPremisesPolicy;
            this.changedFields = changedFields.add("exchangeOnPremisesPolicy");
            return this;
        }

        /**
         * <i>“The list of Mobile threat Defense connectors configured by the tenant.”</i>
         * 
         * @param mobileThreatDefenseConnectors
         *            value of {@code mobileThreatDefenseConnectors} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder mobileThreatDefenseConnectors(List<MobileThreatDefenseConnector> mobileThreatDefenseConnectors) {
            this.mobileThreatDefenseConnectors = mobileThreatDefenseConnectors;
            this.changedFields = changedFields.add("mobileThreatDefenseConnectors");
            return this;
        }

        /**
         * <i>“The list of Mobile threat Defense connectors configured by the tenant.”</i>
         * 
         * @param mobileThreatDefenseConnectors
         *            value of {@code mobileThreatDefenseConnectors} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder mobileThreatDefenseConnectors(MobileThreatDefenseConnector... mobileThreatDefenseConnectors) {
            return mobileThreatDefenseConnectors(Arrays.asList(mobileThreatDefenseConnectors));
        }

        /**
         * <i>“The available categories”</i>
         * 
         * @param categories
         *            value of {@code categories} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder categories(List<DeviceManagementSettingCategory> categories) {
            this.categories = categories;
            this.changedFields = changedFields.add("categories");
            return this;
        }

        /**
         * <i>“The available categories”</i>
         * 
         * @param categories
         *            value of {@code categories} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder categories(DeviceManagementSettingCategory... categories) {
            return categories(Arrays.asList(categories));
        }

        /**
         * <i>“The device management intents”</i>
         * 
         * @param intents
         *            value of {@code intents} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder intents(List<DeviceManagementIntent> intents) {
            this.intents = intents;
            this.changedFields = changedFields.add("intents");
            return this;
        }

        /**
         * <i>“The device management intents”</i>
         * 
         * @param intents
         *            value of {@code intents} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder intents(DeviceManagementIntent... intents) {
            return intents(Arrays.asList(intents));
        }

        /**
         * <i>“The device management intent setting definitions”</i>
         * 
         * @param settingDefinitions
         *            value of {@code settingDefinitions} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder settingDefinitions(List<DeviceManagementSettingDefinition> settingDefinitions) {
            this.settingDefinitions = settingDefinitions;
            this.changedFields = changedFields.add("settingDefinitions");
            return this;
        }

        /**
         * <i>“The device management intent setting definitions”</i>
         * 
         * @param settingDefinitions
         *            value of {@code settingDefinitions} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder settingDefinitions(DeviceManagementSettingDefinition... settingDefinitions) {
            return settingDefinitions(Arrays.asList(settingDefinitions));
        }

        /**
         * <i>“The available templates”</i>
         * 
         * @param templates
         *            value of {@code templates} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder templates(List<DeviceManagementTemplate> templates) {
            this.templates = templates;
            this.changedFields = changedFields.add("templates");
            return this;
        }

        /**
         * <i>“The available templates”</i>
         * 
         * @param templates
         *            value of {@code templates} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder templates(DeviceManagementTemplate... templates) {
            return templates(Arrays.asList(templates));
        }

        /**
         * <i>“Apple push notification certificate.”</i>
         * 
         * @param applePushNotificationCertificate
         *            value of {@code applePushNotificationCertificate} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder applePushNotificationCertificate(ApplePushNotificationCertificate applePushNotificationCertificate) {
            this.applePushNotificationCertificate = applePushNotificationCertificate;
            this.changedFields = changedFields.add("applePushNotificationCertificate");
            return this;
        }

        /**
         * <i>“The list of CloudPC Connectivity Issue.”</i>
         * 
         * @param cloudPCConnectivityIssues
         *            value of {@code cloudPCConnectivityIssues} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder cloudPCConnectivityIssues(List<CloudPCConnectivityIssue> cloudPCConnectivityIssues) {
            this.cloudPCConnectivityIssues = cloudPCConnectivityIssues;
            this.changedFields = changedFields.add("cloudPCConnectivityIssues");
            return this;
        }

        /**
         * <i>“The list of CloudPC Connectivity Issue.”</i>
         * 
         * @param cloudPCConnectivityIssues
         *            value of {@code cloudPCConnectivityIssues} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder cloudPCConnectivityIssues(CloudPCConnectivityIssue... cloudPCConnectivityIssues) {
            return cloudPCConnectivityIssues(Arrays.asList(cloudPCConnectivityIssues));
        }

        /**
         * <i>“The list of co-managed devices report”</i>
         * 
         * @param comanagedDevices
         *            value of {@code comanagedDevices} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder comanagedDevices(List<ManagedDevice> comanagedDevices) {
            this.comanagedDevices = comanagedDevices;
            this.changedFields = changedFields.add("comanagedDevices");
            return this;
        }

        /**
         * <i>“The list of co-managed devices report”</i>
         * 
         * @param comanagedDevices
         *            value of {@code comanagedDevices} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder comanagedDevices(ManagedDevice... comanagedDevices) {
            return comanagedDevices(Arrays.asList(comanagedDevices));
        }

        /**
         * <i>“The list of co-management eligible devices report”</i>
         * 
         * @param comanagementEligibleDevices
         *            value of {@code comanagementEligibleDevices} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder comanagementEligibleDevices(List<ComanagementEligibleDevice> comanagementEligibleDevices) {
            this.comanagementEligibleDevices = comanagementEligibleDevices;
            this.changedFields = changedFields.add("comanagementEligibleDevices");
            return this;
        }

        /**
         * <i>“The list of co-management eligible devices report”</i>
         * 
         * @param comanagementEligibleDevices
         *            value of {@code comanagementEligibleDevices} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder comanagementEligibleDevices(ComanagementEligibleDevice... comanagementEligibleDevices) {
            return comanagementEligibleDevices(Arrays.asList(comanagementEligibleDevices));
        }

        /**
         * <i>“Data sharing consents.”</i>
         * 
         * @param dataSharingConsents
         *            value of {@code dataSharingConsents} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder dataSharingConsents(List<DataSharingConsent> dataSharingConsents) {
            this.dataSharingConsents = dataSharingConsents;
            this.changedFields = changedFields.add("dataSharingConsents");
            return this;
        }

        /**
         * <i>“Data sharing consents.”</i>
         * 
         * @param dataSharingConsents
         *            value of {@code dataSharingConsents} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder dataSharingConsents(DataSharingConsent... dataSharingConsents) {
            return dataSharingConsents(Arrays.asList(dataSharingConsents));
        }

        /**
         * <i>“The list of detected apps associated with a device.”</i>
         * 
         * @param detectedApps
         *            value of {@code detectedApps} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder detectedApps(List<DetectedApp> detectedApps) {
            this.detectedApps = detectedApps;
            this.changedFields = changedFields.add("detectedApps");
            return this;
        }

        /**
         * <i>“The list of detected apps associated with a device.”</i>
         * 
         * @param detectedApps
         *            value of {@code detectedApps} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder detectedApps(DetectedApp... detectedApps) {
            return detectedApps(Arrays.asList(detectedApps));
        }

        /**
         * <i>“The list of device compliance scripts associated with the tenant.”</i>
         * 
         * @param deviceComplianceScripts
         *            value of {@code deviceComplianceScripts} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceComplianceScripts(List<DeviceComplianceScript> deviceComplianceScripts) {
            this.deviceComplianceScripts = deviceComplianceScripts;
            this.changedFields = changedFields.add("deviceComplianceScripts");
            return this;
        }

        /**
         * <i>“The list of device compliance scripts associated with the tenant.”</i>
         * 
         * @param deviceComplianceScripts
         *            value of {@code deviceComplianceScripts} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceComplianceScripts(DeviceComplianceScript... deviceComplianceScripts) {
            return deviceComplianceScripts(Arrays.asList(deviceComplianceScripts));
        }

        /**
         * <i>“The list of device custom attribute shell scripts associated with the tenant.”</i>
         * 
         * @param deviceCustomAttributeShellScripts
         *            value of {@code deviceCustomAttributeShellScripts} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceCustomAttributeShellScripts(List<DeviceCustomAttributeShellScript> deviceCustomAttributeShellScripts) {
            this.deviceCustomAttributeShellScripts = deviceCustomAttributeShellScripts;
            this.changedFields = changedFields.add("deviceCustomAttributeShellScripts");
            return this;
        }

        /**
         * <i>“The list of device custom attribute shell scripts associated with the tenant.”</i>
         * 
         * @param deviceCustomAttributeShellScripts
         *            value of {@code deviceCustomAttributeShellScripts} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceCustomAttributeShellScripts(DeviceCustomAttributeShellScript... deviceCustomAttributeShellScripts) {
            return deviceCustomAttributeShellScripts(Arrays.asList(deviceCustomAttributeShellScripts));
        }

        /**
         * <i>“The list of device health scripts associated with the tenant.”</i>
         * 
         * @param deviceHealthScripts
         *            value of {@code deviceHealthScripts} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceHealthScripts(List<DeviceHealthScript> deviceHealthScripts) {
            this.deviceHealthScripts = deviceHealthScripts;
            this.changedFields = changedFields.add("deviceHealthScripts");
            return this;
        }

        /**
         * <i>“The list of device health scripts associated with the tenant.”</i>
         * 
         * @param deviceHealthScripts
         *            value of {@code deviceHealthScripts} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceHealthScripts(DeviceHealthScript... deviceHealthScripts) {
            return deviceHealthScripts(Arrays.asList(deviceHealthScripts));
        }

        /**
         * <i>“The list of device management scripts associated with the tenant.”</i>
         * 
         * @param deviceManagementScripts
         *            value of {@code deviceManagementScripts} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceManagementScripts(List<DeviceManagementScript> deviceManagementScripts) {
            this.deviceManagementScripts = deviceManagementScripts;
            this.changedFields = changedFields.add("deviceManagementScripts");
            return this;
        }

        /**
         * <i>“The list of device management scripts associated with the tenant.”</i>
         * 
         * @param deviceManagementScripts
         *            value of {@code deviceManagementScripts} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceManagementScripts(DeviceManagementScript... deviceManagementScripts) {
            return deviceManagementScripts(Arrays.asList(deviceManagementScripts));
        }

        /**
         * <i>“The list of device shell scripts associated with the tenant.”</i>
         * 
         * @param deviceShellScripts
         *            value of {@code deviceShellScripts} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceShellScripts(List<DeviceShellScript> deviceShellScripts) {
            this.deviceShellScripts = deviceShellScripts;
            this.changedFields = changedFields.add("deviceShellScripts");
            return this;
        }

        /**
         * <i>“The list of device shell scripts associated with the tenant.”</i>
         * 
         * @param deviceShellScripts
         *            value of {@code deviceShellScripts} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceShellScripts(DeviceShellScript... deviceShellScripts) {
            return deviceShellScripts(Arrays.asList(deviceShellScripts));
        }

        /**
         * <i>“The list of managed devices.”</i>
         * 
         * @param managedDevices
         *            value of {@code managedDevices} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder managedDevices(List<ManagedDevice> managedDevices) {
            this.managedDevices = managedDevices;
            this.changedFields = changedFields.add("managedDevices");
            return this;
        }

        /**
         * <i>“The list of managed devices.”</i>
         * 
         * @param managedDevices
         *            value of {@code managedDevices} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder managedDevices(ManagedDevice... managedDevices) {
            return managedDevices(Arrays.asList(managedDevices));
        }

        /**
         * <i>“The collection property of MobileAppTroubleshootingEvent.”</i>
         * 
         * @param mobileAppTroubleshootingEvents
         *            value of {@code mobileAppTroubleshootingEvents} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder mobileAppTroubleshootingEvents(List<MobileAppTroubleshootingEvent> mobileAppTroubleshootingEvents) {
            this.mobileAppTroubleshootingEvents = mobileAppTroubleshootingEvents;
            this.changedFields = changedFields.add("mobileAppTroubleshootingEvents");
            return this;
        }

        /**
         * <i>“The collection property of MobileAppTroubleshootingEvent.”</i>
         * 
         * @param mobileAppTroubleshootingEvents
         *            value of {@code mobileAppTroubleshootingEvents} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder mobileAppTroubleshootingEvents(MobileAppTroubleshootingEvent... mobileAppTroubleshootingEvents) {
            return mobileAppTroubleshootingEvents(Arrays.asList(mobileAppTroubleshootingEvents));
        }

        /**
         * <i>“List of OEM Warranty Statuses”</i>
         * 
         * @param oemWarrantyInformationOnboarding
         *            value of {@code oemWarrantyInformationOnboarding} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder oemWarrantyInformationOnboarding(List<OemWarrantyInformationOnboarding> oemWarrantyInformationOnboarding) {
            this.oemWarrantyInformationOnboarding = oemWarrantyInformationOnboarding;
            this.changedFields = changedFields.add("oemWarrantyInformationOnboarding");
            return this;
        }

        /**
         * <i>“List of OEM Warranty Statuses”</i>
         * 
         * @param oemWarrantyInformationOnboarding
         *            value of {@code oemWarrantyInformationOnboarding} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder oemWarrantyInformationOnboarding(OemWarrantyInformationOnboarding... oemWarrantyInformationOnboarding) {
            return oemWarrantyInformationOnboarding(Arrays.asList(oemWarrantyInformationOnboarding));
        }

        /**
         * <i>“The list of device remote action audits with the tenant.”</i>
         * 
         * @param remoteActionAudits
         *            value of {@code remoteActionAudits} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder remoteActionAudits(List<RemoteActionAudit> remoteActionAudits) {
            this.remoteActionAudits = remoteActionAudits;
            this.changedFields = changedFields.add("remoteActionAudits");
            return this;
        }

        /**
         * <i>“The list of device remote action audits with the tenant.”</i>
         * 
         * @param remoteActionAudits
         *            value of {@code remoteActionAudits} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder remoteActionAudits(RemoteActionAudit... remoteActionAudits) {
            return remoteActionAudits(Arrays.asList(remoteActionAudits));
        }

        /**
         * <i>“User experience analytics appHealth Application Performance”</i>
         * 
         * @param userExperienceAnalyticsAppHealthApplicationPerformance
         *            value of {@code userExperienceAnalyticsAppHealthApplicationPerformance} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userExperienceAnalyticsAppHealthApplicationPerformance(List<UserExperienceAnalyticsAppHealthApplicationPerformance> userExperienceAnalyticsAppHealthApplicationPerformance) {
            this.userExperienceAnalyticsAppHealthApplicationPerformance = userExperienceAnalyticsAppHealthApplicationPerformance;
            this.changedFields = changedFields.add("userExperienceAnalyticsAppHealthApplicationPerformance");
            return this;
        }

        /**
         * <i>“User experience analytics appHealth Application Performance”</i>
         * 
         * @param userExperienceAnalyticsAppHealthApplicationPerformance
         *            value of {@code userExperienceAnalyticsAppHealthApplicationPerformance} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userExperienceAnalyticsAppHealthApplicationPerformance(UserExperienceAnalyticsAppHealthApplicationPerformance... userExperienceAnalyticsAppHealthApplicationPerformance) {
            return userExperienceAnalyticsAppHealthApplicationPerformance(Arrays.asList(userExperienceAnalyticsAppHealthApplicationPerformance));
        }

        /**
         * <i>“User experience analytics appHealth Application Performance by App Version”</i>
         * 
         * @param userExperienceAnalyticsAppHealthApplicationPerformanceByAppVersion
         *            value of {@code userExperienceAnalyticsAppHealthApplicationPerformanceByAppVersion} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userExperienceAnalyticsAppHealthApplicationPerformanceByAppVersion(List<UserExperienceAnalyticsAppHealthAppPerformanceByAppVersion> userExperienceAnalyticsAppHealthApplicationPerformanceByAppVersion) {
            this.userExperienceAnalyticsAppHealthApplicationPerformanceByAppVersion = userExperienceAnalyticsAppHealthApplicationPerformanceByAppVersion;
            this.changedFields = changedFields.add("userExperienceAnalyticsAppHealthApplicationPerformanceByAppVersion");
            return this;
        }

        /**
         * <i>“User experience analytics appHealth Application Performance by App Version”</i>
         * 
         * @param userExperienceAnalyticsAppHealthApplicationPerformanceByAppVersion
         *            value of {@code userExperienceAnalyticsAppHealthApplicationPerformanceByAppVersion} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userExperienceAnalyticsAppHealthApplicationPerformanceByAppVersion(UserExperienceAnalyticsAppHealthAppPerformanceByAppVersion... userExperienceAnalyticsAppHealthApplicationPerformanceByAppVersion) {
            return userExperienceAnalyticsAppHealthApplicationPerformanceByAppVersion(Arrays.asList(userExperienceAnalyticsAppHealthApplicationPerformanceByAppVersion));
        }

        /**
         * <i>“User experience analytics appHealth Application Performance by App Version
         * details”</i>
         * 
         * @param userExperienceAnalyticsAppHealthApplicationPerformanceByAppVersionDetails
         *            value of {@code userExperienceAnalyticsAppHealthApplicationPerformanceByAppVersionDetails} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userExperienceAnalyticsAppHealthApplicationPerformanceByAppVersionDetails(List<UserExperienceAnalyticsAppHealthAppPerformanceByAppVersionDetails> userExperienceAnalyticsAppHealthApplicationPerformanceByAppVersionDetails) {
            this.userExperienceAnalyticsAppHealthApplicationPerformanceByAppVersionDetails = userExperienceAnalyticsAppHealthApplicationPerformanceByAppVersionDetails;
            this.changedFields = changedFields.add("userExperienceAnalyticsAppHealthApplicationPerformanceByAppVersionDetails");
            return this;
        }

        /**
         * <i>“User experience analytics appHealth Application Performance by App Version
         * details”</i>
         * 
         * @param userExperienceAnalyticsAppHealthApplicationPerformanceByAppVersionDetails
         *            value of {@code userExperienceAnalyticsAppHealthApplicationPerformanceByAppVersionDetails} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userExperienceAnalyticsAppHealthApplicationPerformanceByAppVersionDetails(UserExperienceAnalyticsAppHealthAppPerformanceByAppVersionDetails... userExperienceAnalyticsAppHealthApplicationPerformanceByAppVersionDetails) {
            return userExperienceAnalyticsAppHealthApplicationPerformanceByAppVersionDetails(Arrays.asList(userExperienceAnalyticsAppHealthApplicationPerformanceByAppVersionDetails));
        }

        /**
         * <i>“User experience analytics appHealth Application Performance by App Version
         * Device Id”</i>
         * 
         * @param userExperienceAnalyticsAppHealthApplicationPerformanceByAppVersionDeviceId
         *            value of {@code userExperienceAnalyticsAppHealthApplicationPerformanceByAppVersionDeviceId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userExperienceAnalyticsAppHealthApplicationPerformanceByAppVersionDeviceId(List<UserExperienceAnalyticsAppHealthAppPerformanceByAppVersionDeviceId> userExperienceAnalyticsAppHealthApplicationPerformanceByAppVersionDeviceId) {
            this.userExperienceAnalyticsAppHealthApplicationPerformanceByAppVersionDeviceId = userExperienceAnalyticsAppHealthApplicationPerformanceByAppVersionDeviceId;
            this.changedFields = changedFields.add("userExperienceAnalyticsAppHealthApplicationPerformanceByAppVersionDeviceId");
            return this;
        }

        /**
         * <i>“User experience analytics appHealth Application Performance by App Version
         * Device Id”</i>
         * 
         * @param userExperienceAnalyticsAppHealthApplicationPerformanceByAppVersionDeviceId
         *            value of {@code userExperienceAnalyticsAppHealthApplicationPerformanceByAppVersionDeviceId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userExperienceAnalyticsAppHealthApplicationPerformanceByAppVersionDeviceId(UserExperienceAnalyticsAppHealthAppPerformanceByAppVersionDeviceId... userExperienceAnalyticsAppHealthApplicationPerformanceByAppVersionDeviceId) {
            return userExperienceAnalyticsAppHealthApplicationPerformanceByAppVersionDeviceId(Arrays.asList(userExperienceAnalyticsAppHealthApplicationPerformanceByAppVersionDeviceId));
        }

        /**
         * <i>“User experience analytics appHealth Application Performance by OS Version”</i>
         * 
         * @param userExperienceAnalyticsAppHealthApplicationPerformanceByOSVersion
         *            value of {@code userExperienceAnalyticsAppHealthApplicationPerformanceByOSVersion} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userExperienceAnalyticsAppHealthApplicationPerformanceByOSVersion(List<UserExperienceAnalyticsAppHealthAppPerformanceByOSVersion> userExperienceAnalyticsAppHealthApplicationPerformanceByOSVersion) {
            this.userExperienceAnalyticsAppHealthApplicationPerformanceByOSVersion = userExperienceAnalyticsAppHealthApplicationPerformanceByOSVersion;
            this.changedFields = changedFields.add("userExperienceAnalyticsAppHealthApplicationPerformanceByOSVersion");
            return this;
        }

        /**
         * <i>“User experience analytics appHealth Application Performance by OS Version”</i>
         * 
         * @param userExperienceAnalyticsAppHealthApplicationPerformanceByOSVersion
         *            value of {@code userExperienceAnalyticsAppHealthApplicationPerformanceByOSVersion} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userExperienceAnalyticsAppHealthApplicationPerformanceByOSVersion(UserExperienceAnalyticsAppHealthAppPerformanceByOSVersion... userExperienceAnalyticsAppHealthApplicationPerformanceByOSVersion) {
            return userExperienceAnalyticsAppHealthApplicationPerformanceByOSVersion(Arrays.asList(userExperienceAnalyticsAppHealthApplicationPerformanceByOSVersion));
        }

        /**
         * <i>“User experience analytics appHealth Model Performance”</i>
         * 
         * @param userExperienceAnalyticsAppHealthDeviceModelPerformance
         *            value of {@code userExperienceAnalyticsAppHealthDeviceModelPerformance} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userExperienceAnalyticsAppHealthDeviceModelPerformance(List<UserExperienceAnalyticsAppHealthDeviceModelPerformance> userExperienceAnalyticsAppHealthDeviceModelPerformance) {
            this.userExperienceAnalyticsAppHealthDeviceModelPerformance = userExperienceAnalyticsAppHealthDeviceModelPerformance;
            this.changedFields = changedFields.add("userExperienceAnalyticsAppHealthDeviceModelPerformance");
            return this;
        }

        /**
         * <i>“User experience analytics appHealth Model Performance”</i>
         * 
         * @param userExperienceAnalyticsAppHealthDeviceModelPerformance
         *            value of {@code userExperienceAnalyticsAppHealthDeviceModelPerformance} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userExperienceAnalyticsAppHealthDeviceModelPerformance(UserExperienceAnalyticsAppHealthDeviceModelPerformance... userExperienceAnalyticsAppHealthDeviceModelPerformance) {
            return userExperienceAnalyticsAppHealthDeviceModelPerformance(Arrays.asList(userExperienceAnalyticsAppHealthDeviceModelPerformance));
        }

        /**
         * <i>“User experience analytics appHealth Device Performance”</i>
         * 
         * @param userExperienceAnalyticsAppHealthDevicePerformance
         *            value of {@code userExperienceAnalyticsAppHealthDevicePerformance} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userExperienceAnalyticsAppHealthDevicePerformance(List<UserExperienceAnalyticsAppHealthDevicePerformance> userExperienceAnalyticsAppHealthDevicePerformance) {
            this.userExperienceAnalyticsAppHealthDevicePerformance = userExperienceAnalyticsAppHealthDevicePerformance;
            this.changedFields = changedFields.add("userExperienceAnalyticsAppHealthDevicePerformance");
            return this;
        }

        /**
         * <i>“User experience analytics appHealth Device Performance”</i>
         * 
         * @param userExperienceAnalyticsAppHealthDevicePerformance
         *            value of {@code userExperienceAnalyticsAppHealthDevicePerformance} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userExperienceAnalyticsAppHealthDevicePerformance(UserExperienceAnalyticsAppHealthDevicePerformance... userExperienceAnalyticsAppHealthDevicePerformance) {
            return userExperienceAnalyticsAppHealthDevicePerformance(Arrays.asList(userExperienceAnalyticsAppHealthDevicePerformance));
        }

        /**
         * <i>“User experience analytics device performance details”</i>
         * 
         * @param userExperienceAnalyticsAppHealthDevicePerformanceDetails
         *            value of {@code userExperienceAnalyticsAppHealthDevicePerformanceDetails} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userExperienceAnalyticsAppHealthDevicePerformanceDetails(List<UserExperienceAnalyticsAppHealthDevicePerformanceDetails> userExperienceAnalyticsAppHealthDevicePerformanceDetails) {
            this.userExperienceAnalyticsAppHealthDevicePerformanceDetails = userExperienceAnalyticsAppHealthDevicePerformanceDetails;
            this.changedFields = changedFields.add("userExperienceAnalyticsAppHealthDevicePerformanceDetails");
            return this;
        }

        /**
         * <i>“User experience analytics device performance details”</i>
         * 
         * @param userExperienceAnalyticsAppHealthDevicePerformanceDetails
         *            value of {@code userExperienceAnalyticsAppHealthDevicePerformanceDetails} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userExperienceAnalyticsAppHealthDevicePerformanceDetails(UserExperienceAnalyticsAppHealthDevicePerformanceDetails... userExperienceAnalyticsAppHealthDevicePerformanceDetails) {
            return userExperienceAnalyticsAppHealthDevicePerformanceDetails(Arrays.asList(userExperienceAnalyticsAppHealthDevicePerformanceDetails));
        }

        /**
         * <i>“User experience analytics appHealth OS version Performance”</i>
         * 
         * @param userExperienceAnalyticsAppHealthOSVersionPerformance
         *            value of {@code userExperienceAnalyticsAppHealthOSVersionPerformance} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userExperienceAnalyticsAppHealthOSVersionPerformance(List<UserExperienceAnalyticsAppHealthOSVersionPerformance> userExperienceAnalyticsAppHealthOSVersionPerformance) {
            this.userExperienceAnalyticsAppHealthOSVersionPerformance = userExperienceAnalyticsAppHealthOSVersionPerformance;
            this.changedFields = changedFields.add("userExperienceAnalyticsAppHealthOSVersionPerformance");
            return this;
        }

        /**
         * <i>“User experience analytics appHealth OS version Performance”</i>
         * 
         * @param userExperienceAnalyticsAppHealthOSVersionPerformance
         *            value of {@code userExperienceAnalyticsAppHealthOSVersionPerformance} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userExperienceAnalyticsAppHealthOSVersionPerformance(UserExperienceAnalyticsAppHealthOSVersionPerformance... userExperienceAnalyticsAppHealthOSVersionPerformance) {
            return userExperienceAnalyticsAppHealthOSVersionPerformance(Arrays.asList(userExperienceAnalyticsAppHealthOSVersionPerformance));
        }

        /**
         * <i>“User experience analytics appHealth overview”</i>
         * 
         * @param userExperienceAnalyticsAppHealthOverview
         *            value of {@code userExperienceAnalyticsAppHealthOverview} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userExperienceAnalyticsAppHealthOverview(UserExperienceAnalyticsCategory userExperienceAnalyticsAppHealthOverview) {
            this.userExperienceAnalyticsAppHealthOverview = userExperienceAnalyticsAppHealthOverview;
            this.changedFields = changedFields.add("userExperienceAnalyticsAppHealthOverview");
            return this;
        }

        /**
         * <i>“User experience analytics baselines”</i>
         * 
         * @param userExperienceAnalyticsBaselines
         *            value of {@code userExperienceAnalyticsBaselines} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userExperienceAnalyticsBaselines(List<UserExperienceAnalyticsBaseline> userExperienceAnalyticsBaselines) {
            this.userExperienceAnalyticsBaselines = userExperienceAnalyticsBaselines;
            this.changedFields = changedFields.add("userExperienceAnalyticsBaselines");
            return this;
        }

        /**
         * <i>“User experience analytics baselines”</i>
         * 
         * @param userExperienceAnalyticsBaselines
         *            value of {@code userExperienceAnalyticsBaselines} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userExperienceAnalyticsBaselines(UserExperienceAnalyticsBaseline... userExperienceAnalyticsBaselines) {
            return userExperienceAnalyticsBaselines(Arrays.asList(userExperienceAnalyticsBaselines));
        }

        /**
         * <i>“User Experience Analytics Battery Health App Impact”</i>
         * 
         * @param userExperienceAnalyticsBatteryHealthAppImpact
         *            value of {@code userExperienceAnalyticsBatteryHealthAppImpact} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userExperienceAnalyticsBatteryHealthAppImpact(List<UserExperienceAnalyticsBatteryHealthAppImpact> userExperienceAnalyticsBatteryHealthAppImpact) {
            this.userExperienceAnalyticsBatteryHealthAppImpact = userExperienceAnalyticsBatteryHealthAppImpact;
            this.changedFields = changedFields.add("userExperienceAnalyticsBatteryHealthAppImpact");
            return this;
        }

        /**
         * <i>“User Experience Analytics Battery Health App Impact”</i>
         * 
         * @param userExperienceAnalyticsBatteryHealthAppImpact
         *            value of {@code userExperienceAnalyticsBatteryHealthAppImpact} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userExperienceAnalyticsBatteryHealthAppImpact(UserExperienceAnalyticsBatteryHealthAppImpact... userExperienceAnalyticsBatteryHealthAppImpact) {
            return userExperienceAnalyticsBatteryHealthAppImpact(Arrays.asList(userExperienceAnalyticsBatteryHealthAppImpact));
        }

        /**
         * <i>“User Experience Analytics Battery Health Capacity Details”</i>
         * 
         * @param userExperienceAnalyticsBatteryHealthCapacityDetails
         *            value of {@code userExperienceAnalyticsBatteryHealthCapacityDetails} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userExperienceAnalyticsBatteryHealthCapacityDetails(UserExperienceAnalyticsBatteryHealthCapacityDetails userExperienceAnalyticsBatteryHealthCapacityDetails) {
            this.userExperienceAnalyticsBatteryHealthCapacityDetails = userExperienceAnalyticsBatteryHealthCapacityDetails;
            this.changedFields = changedFields.add("userExperienceAnalyticsBatteryHealthCapacityDetails");
            return this;
        }

        /**
         * <i>“User Experience Analytics Battery Health Device App Impact”</i>
         * 
         * @param userExperienceAnalyticsBatteryHealthDeviceAppImpact
         *            value of {@code userExperienceAnalyticsBatteryHealthDeviceAppImpact} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userExperienceAnalyticsBatteryHealthDeviceAppImpact(List<UserExperienceAnalyticsBatteryHealthDeviceAppImpact> userExperienceAnalyticsBatteryHealthDeviceAppImpact) {
            this.userExperienceAnalyticsBatteryHealthDeviceAppImpact = userExperienceAnalyticsBatteryHealthDeviceAppImpact;
            this.changedFields = changedFields.add("userExperienceAnalyticsBatteryHealthDeviceAppImpact");
            return this;
        }

        /**
         * <i>“User Experience Analytics Battery Health Device App Impact”</i>
         * 
         * @param userExperienceAnalyticsBatteryHealthDeviceAppImpact
         *            value of {@code userExperienceAnalyticsBatteryHealthDeviceAppImpact} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userExperienceAnalyticsBatteryHealthDeviceAppImpact(UserExperienceAnalyticsBatteryHealthDeviceAppImpact... userExperienceAnalyticsBatteryHealthDeviceAppImpact) {
            return userExperienceAnalyticsBatteryHealthDeviceAppImpact(Arrays.asList(userExperienceAnalyticsBatteryHealthDeviceAppImpact));
        }

        /**
         * <i>“User Experience Analytics Battery Health Device Performance”</i>
         * 
         * @param userExperienceAnalyticsBatteryHealthDevicePerformance
         *            value of {@code userExperienceAnalyticsBatteryHealthDevicePerformance} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userExperienceAnalyticsBatteryHealthDevicePerformance(List<UserExperienceAnalyticsBatteryHealthDevicePerformance> userExperienceAnalyticsBatteryHealthDevicePerformance) {
            this.userExperienceAnalyticsBatteryHealthDevicePerformance = userExperienceAnalyticsBatteryHealthDevicePerformance;
            this.changedFields = changedFields.add("userExperienceAnalyticsBatteryHealthDevicePerformance");
            return this;
        }

        /**
         * <i>“User Experience Analytics Battery Health Device Performance”</i>
         * 
         * @param userExperienceAnalyticsBatteryHealthDevicePerformance
         *            value of {@code userExperienceAnalyticsBatteryHealthDevicePerformance} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userExperienceAnalyticsBatteryHealthDevicePerformance(UserExperienceAnalyticsBatteryHealthDevicePerformance... userExperienceAnalyticsBatteryHealthDevicePerformance) {
            return userExperienceAnalyticsBatteryHealthDevicePerformance(Arrays.asList(userExperienceAnalyticsBatteryHealthDevicePerformance));
        }

        /**
         * <i>“User Experience Analytics Battery Health Device Runtime History”</i>
         * 
         * @param userExperienceAnalyticsBatteryHealthDeviceRuntimeHistory
         *            value of {@code userExperienceAnalyticsBatteryHealthDeviceRuntimeHistory} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userExperienceAnalyticsBatteryHealthDeviceRuntimeHistory(List<UserExperienceAnalyticsBatteryHealthDeviceRuntimeHistory> userExperienceAnalyticsBatteryHealthDeviceRuntimeHistory) {
            this.userExperienceAnalyticsBatteryHealthDeviceRuntimeHistory = userExperienceAnalyticsBatteryHealthDeviceRuntimeHistory;
            this.changedFields = changedFields.add("userExperienceAnalyticsBatteryHealthDeviceRuntimeHistory");
            return this;
        }

        /**
         * <i>“User Experience Analytics Battery Health Device Runtime History”</i>
         * 
         * @param userExperienceAnalyticsBatteryHealthDeviceRuntimeHistory
         *            value of {@code userExperienceAnalyticsBatteryHealthDeviceRuntimeHistory} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userExperienceAnalyticsBatteryHealthDeviceRuntimeHistory(UserExperienceAnalyticsBatteryHealthDeviceRuntimeHistory... userExperienceAnalyticsBatteryHealthDeviceRuntimeHistory) {
            return userExperienceAnalyticsBatteryHealthDeviceRuntimeHistory(Arrays.asList(userExperienceAnalyticsBatteryHealthDeviceRuntimeHistory));
        }

        /**
         * <i>“User Experience Analytics Battery Health Model Performance”</i>
         * 
         * @param userExperienceAnalyticsBatteryHealthModelPerformance
         *            value of {@code userExperienceAnalyticsBatteryHealthModelPerformance} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userExperienceAnalyticsBatteryHealthModelPerformance(List<UserExperienceAnalyticsBatteryHealthModelPerformance> userExperienceAnalyticsBatteryHealthModelPerformance) {
            this.userExperienceAnalyticsBatteryHealthModelPerformance = userExperienceAnalyticsBatteryHealthModelPerformance;
            this.changedFields = changedFields.add("userExperienceAnalyticsBatteryHealthModelPerformance");
            return this;
        }

        /**
         * <i>“User Experience Analytics Battery Health Model Performance”</i>
         * 
         * @param userExperienceAnalyticsBatteryHealthModelPerformance
         *            value of {@code userExperienceAnalyticsBatteryHealthModelPerformance} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userExperienceAnalyticsBatteryHealthModelPerformance(UserExperienceAnalyticsBatteryHealthModelPerformance... userExperienceAnalyticsBatteryHealthModelPerformance) {
            return userExperienceAnalyticsBatteryHealthModelPerformance(Arrays.asList(userExperienceAnalyticsBatteryHealthModelPerformance));
        }

        /**
         * <i>“User Experience Analytics Battery Health Os Performance”</i>
         * 
         * @param userExperienceAnalyticsBatteryHealthOsPerformance
         *            value of {@code userExperienceAnalyticsBatteryHealthOsPerformance} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userExperienceAnalyticsBatteryHealthOsPerformance(List<UserExperienceAnalyticsBatteryHealthOsPerformance> userExperienceAnalyticsBatteryHealthOsPerformance) {
            this.userExperienceAnalyticsBatteryHealthOsPerformance = userExperienceAnalyticsBatteryHealthOsPerformance;
            this.changedFields = changedFields.add("userExperienceAnalyticsBatteryHealthOsPerformance");
            return this;
        }

        /**
         * <i>“User Experience Analytics Battery Health Os Performance”</i>
         * 
         * @param userExperienceAnalyticsBatteryHealthOsPerformance
         *            value of {@code userExperienceAnalyticsBatteryHealthOsPerformance} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userExperienceAnalyticsBatteryHealthOsPerformance(UserExperienceAnalyticsBatteryHealthOsPerformance... userExperienceAnalyticsBatteryHealthOsPerformance) {
            return userExperienceAnalyticsBatteryHealthOsPerformance(Arrays.asList(userExperienceAnalyticsBatteryHealthOsPerformance));
        }

        /**
         * <i>“User Experience Analytics Battery Health Runtime Details”</i>
         * 
         * @param userExperienceAnalyticsBatteryHealthRuntimeDetails
         *            value of {@code userExperienceAnalyticsBatteryHealthRuntimeDetails} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userExperienceAnalyticsBatteryHealthRuntimeDetails(UserExperienceAnalyticsBatteryHealthRuntimeDetails userExperienceAnalyticsBatteryHealthRuntimeDetails) {
            this.userExperienceAnalyticsBatteryHealthRuntimeDetails = userExperienceAnalyticsBatteryHealthRuntimeDetails;
            this.changedFields = changedFields.add("userExperienceAnalyticsBatteryHealthRuntimeDetails");
            return this;
        }

        /**
         * <i>“User experience analytics categories”</i>
         * 
         * @param userExperienceAnalyticsCategories
         *            value of {@code userExperienceAnalyticsCategories} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userExperienceAnalyticsCategories(List<UserExperienceAnalyticsCategory> userExperienceAnalyticsCategories) {
            this.userExperienceAnalyticsCategories = userExperienceAnalyticsCategories;
            this.changedFields = changedFields.add("userExperienceAnalyticsCategories");
            return this;
        }

        /**
         * <i>“User experience analytics categories”</i>
         * 
         * @param userExperienceAnalyticsCategories
         *            value of {@code userExperienceAnalyticsCategories} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userExperienceAnalyticsCategories(UserExperienceAnalyticsCategory... userExperienceAnalyticsCategories) {
            return userExperienceAnalyticsCategories(Arrays.asList(userExperienceAnalyticsCategories));
        }

        /**
         * <i>“User experience analytics device metric history”</i>
         * 
         * @param userExperienceAnalyticsDeviceMetricHistory
         *            value of {@code userExperienceAnalyticsDeviceMetricHistory} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userExperienceAnalyticsDeviceMetricHistory(List<UserExperienceAnalyticsMetricHistory> userExperienceAnalyticsDeviceMetricHistory) {
            this.userExperienceAnalyticsDeviceMetricHistory = userExperienceAnalyticsDeviceMetricHistory;
            this.changedFields = changedFields.add("userExperienceAnalyticsDeviceMetricHistory");
            return this;
        }

        /**
         * <i>“User experience analytics device metric history”</i>
         * 
         * @param userExperienceAnalyticsDeviceMetricHistory
         *            value of {@code userExperienceAnalyticsDeviceMetricHistory} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userExperienceAnalyticsDeviceMetricHistory(UserExperienceAnalyticsMetricHistory... userExperienceAnalyticsDeviceMetricHistory) {
            return userExperienceAnalyticsDeviceMetricHistory(Arrays.asList(userExperienceAnalyticsDeviceMetricHistory));
        }

        /**
         * <i>“User experience analytics device performance”</i>
         * 
         * @param userExperienceAnalyticsDevicePerformance
         *            value of {@code userExperienceAnalyticsDevicePerformance} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userExperienceAnalyticsDevicePerformance(List<UserExperienceAnalyticsDevicePerformance> userExperienceAnalyticsDevicePerformance) {
            this.userExperienceAnalyticsDevicePerformance = userExperienceAnalyticsDevicePerformance;
            this.changedFields = changedFields.add("userExperienceAnalyticsDevicePerformance");
            return this;
        }

        /**
         * <i>“User experience analytics device performance”</i>
         * 
         * @param userExperienceAnalyticsDevicePerformance
         *            value of {@code userExperienceAnalyticsDevicePerformance} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userExperienceAnalyticsDevicePerformance(UserExperienceAnalyticsDevicePerformance... userExperienceAnalyticsDevicePerformance) {
            return userExperienceAnalyticsDevicePerformance(Arrays.asList(userExperienceAnalyticsDevicePerformance));
        }

        /**
         * <i>“User experience analytics device scores”</i>
         * 
         * @param userExperienceAnalyticsDeviceScores
         *            value of {@code userExperienceAnalyticsDeviceScores} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userExperienceAnalyticsDeviceScores(List<UserExperienceAnalyticsDeviceScores> userExperienceAnalyticsDeviceScores) {
            this.userExperienceAnalyticsDeviceScores = userExperienceAnalyticsDeviceScores;
            this.changedFields = changedFields.add("userExperienceAnalyticsDeviceScores");
            return this;
        }

        /**
         * <i>“User experience analytics device scores”</i>
         * 
         * @param userExperienceAnalyticsDeviceScores
         *            value of {@code userExperienceAnalyticsDeviceScores} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userExperienceAnalyticsDeviceScores(UserExperienceAnalyticsDeviceScores... userExperienceAnalyticsDeviceScores) {
            return userExperienceAnalyticsDeviceScores(Arrays.asList(userExperienceAnalyticsDeviceScores));
        }

        /**
         * <i>“User experience analytics device Startup History”</i>
         * 
         * @param userExperienceAnalyticsDeviceStartupHistory
         *            value of {@code userExperienceAnalyticsDeviceStartupHistory} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userExperienceAnalyticsDeviceStartupHistory(List<UserExperienceAnalyticsDeviceStartupHistory> userExperienceAnalyticsDeviceStartupHistory) {
            this.userExperienceAnalyticsDeviceStartupHistory = userExperienceAnalyticsDeviceStartupHistory;
            this.changedFields = changedFields.add("userExperienceAnalyticsDeviceStartupHistory");
            return this;
        }

        /**
         * <i>“User experience analytics device Startup History”</i>
         * 
         * @param userExperienceAnalyticsDeviceStartupHistory
         *            value of {@code userExperienceAnalyticsDeviceStartupHistory} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userExperienceAnalyticsDeviceStartupHistory(UserExperienceAnalyticsDeviceStartupHistory... userExperienceAnalyticsDeviceStartupHistory) {
            return userExperienceAnalyticsDeviceStartupHistory(Arrays.asList(userExperienceAnalyticsDeviceStartupHistory));
        }

        /**
         * <i>“User experience analytics device Startup Processes”</i>
         * 
         * @param userExperienceAnalyticsDeviceStartupProcesses
         *            value of {@code userExperienceAnalyticsDeviceStartupProcesses} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userExperienceAnalyticsDeviceStartupProcesses(List<UserExperienceAnalyticsDeviceStartupProcess> userExperienceAnalyticsDeviceStartupProcesses) {
            this.userExperienceAnalyticsDeviceStartupProcesses = userExperienceAnalyticsDeviceStartupProcesses;
            this.changedFields = changedFields.add("userExperienceAnalyticsDeviceStartupProcesses");
            return this;
        }

        /**
         * <i>“User experience analytics device Startup Processes”</i>
         * 
         * @param userExperienceAnalyticsDeviceStartupProcesses
         *            value of {@code userExperienceAnalyticsDeviceStartupProcesses} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userExperienceAnalyticsDeviceStartupProcesses(UserExperienceAnalyticsDeviceStartupProcess... userExperienceAnalyticsDeviceStartupProcesses) {
            return userExperienceAnalyticsDeviceStartupProcesses(Arrays.asList(userExperienceAnalyticsDeviceStartupProcesses));
        }

        /**
         * <i>“User experience analytics device Startup Process Performance”</i>
         * 
         * @param userExperienceAnalyticsDeviceStartupProcessPerformance
         *            value of {@code userExperienceAnalyticsDeviceStartupProcessPerformance} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userExperienceAnalyticsDeviceStartupProcessPerformance(List<UserExperienceAnalyticsDeviceStartupProcessPerformance> userExperienceAnalyticsDeviceStartupProcessPerformance) {
            this.userExperienceAnalyticsDeviceStartupProcessPerformance = userExperienceAnalyticsDeviceStartupProcessPerformance;
            this.changedFields = changedFields.add("userExperienceAnalyticsDeviceStartupProcessPerformance");
            return this;
        }

        /**
         * <i>“User experience analytics device Startup Process Performance”</i>
         * 
         * @param userExperienceAnalyticsDeviceStartupProcessPerformance
         *            value of {@code userExperienceAnalyticsDeviceStartupProcessPerformance} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userExperienceAnalyticsDeviceStartupProcessPerformance(UserExperienceAnalyticsDeviceStartupProcessPerformance... userExperienceAnalyticsDeviceStartupProcessPerformance) {
            return userExperienceAnalyticsDeviceStartupProcessPerformance(Arrays.asList(userExperienceAnalyticsDeviceStartupProcessPerformance));
        }

        /**
         * <i>“User experience analytics devices without cloud identity.”</i>
         * 
         * @param userExperienceAnalyticsDevicesWithoutCloudIdentity
         *            value of {@code userExperienceAnalyticsDevicesWithoutCloudIdentity} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userExperienceAnalyticsDevicesWithoutCloudIdentity(List<UserExperienceAnalyticsDeviceWithoutCloudIdentity> userExperienceAnalyticsDevicesWithoutCloudIdentity) {
            this.userExperienceAnalyticsDevicesWithoutCloudIdentity = userExperienceAnalyticsDevicesWithoutCloudIdentity;
            this.changedFields = changedFields.add("userExperienceAnalyticsDevicesWithoutCloudIdentity");
            return this;
        }

        /**
         * <i>“User experience analytics devices without cloud identity.”</i>
         * 
         * @param userExperienceAnalyticsDevicesWithoutCloudIdentity
         *            value of {@code userExperienceAnalyticsDevicesWithoutCloudIdentity} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userExperienceAnalyticsDevicesWithoutCloudIdentity(UserExperienceAnalyticsDeviceWithoutCloudIdentity... userExperienceAnalyticsDevicesWithoutCloudIdentity) {
            return userExperienceAnalyticsDevicesWithoutCloudIdentity(Arrays.asList(userExperienceAnalyticsDevicesWithoutCloudIdentity));
        }

        /**
         * <i>“User experience analytics impacting process”</i>
         * 
         * @param userExperienceAnalyticsImpactingProcess
         *            value of {@code userExperienceAnalyticsImpactingProcess} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userExperienceAnalyticsImpactingProcess(List<UserExperienceAnalyticsImpactingProcess> userExperienceAnalyticsImpactingProcess) {
            this.userExperienceAnalyticsImpactingProcess = userExperienceAnalyticsImpactingProcess;
            this.changedFields = changedFields.add("userExperienceAnalyticsImpactingProcess");
            return this;
        }

        /**
         * <i>“User experience analytics impacting process”</i>
         * 
         * @param userExperienceAnalyticsImpactingProcess
         *            value of {@code userExperienceAnalyticsImpactingProcess} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userExperienceAnalyticsImpactingProcess(UserExperienceAnalyticsImpactingProcess... userExperienceAnalyticsImpactingProcess) {
            return userExperienceAnalyticsImpactingProcess(Arrays.asList(userExperienceAnalyticsImpactingProcess));
        }

        /**
         * <i>“User experience analytics metric history”</i>
         * 
         * @param userExperienceAnalyticsMetricHistory
         *            value of {@code userExperienceAnalyticsMetricHistory} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userExperienceAnalyticsMetricHistory(List<UserExperienceAnalyticsMetricHistory> userExperienceAnalyticsMetricHistory) {
            this.userExperienceAnalyticsMetricHistory = userExperienceAnalyticsMetricHistory;
            this.changedFields = changedFields.add("userExperienceAnalyticsMetricHistory");
            return this;
        }

        /**
         * <i>“User experience analytics metric history”</i>
         * 
         * @param userExperienceAnalyticsMetricHistory
         *            value of {@code userExperienceAnalyticsMetricHistory} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userExperienceAnalyticsMetricHistory(UserExperienceAnalyticsMetricHistory... userExperienceAnalyticsMetricHistory) {
            return userExperienceAnalyticsMetricHistory(Arrays.asList(userExperienceAnalyticsMetricHistory));
        }

        /**
         * <i>“User experience analytics model scores”</i>
         * 
         * @param userExperienceAnalyticsModelScores
         *            value of {@code userExperienceAnalyticsModelScores} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userExperienceAnalyticsModelScores(List<UserExperienceAnalyticsModelScores> userExperienceAnalyticsModelScores) {
            this.userExperienceAnalyticsModelScores = userExperienceAnalyticsModelScores;
            this.changedFields = changedFields.add("userExperienceAnalyticsModelScores");
            return this;
        }

        /**
         * <i>“User experience analytics model scores”</i>
         * 
         * @param userExperienceAnalyticsModelScores
         *            value of {@code userExperienceAnalyticsModelScores} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userExperienceAnalyticsModelScores(UserExperienceAnalyticsModelScores... userExperienceAnalyticsModelScores) {
            return userExperienceAnalyticsModelScores(Arrays.asList(userExperienceAnalyticsModelScores));
        }

        /**
         * <i>“User experience analytics devices not Windows Autopilot ready.”</i>
         * 
         * @param userExperienceAnalyticsNotAutopilotReadyDevice
         *            value of {@code userExperienceAnalyticsNotAutopilotReadyDevice} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userExperienceAnalyticsNotAutopilotReadyDevice(List<UserExperienceAnalyticsNotAutopilotReadyDevice> userExperienceAnalyticsNotAutopilotReadyDevice) {
            this.userExperienceAnalyticsNotAutopilotReadyDevice = userExperienceAnalyticsNotAutopilotReadyDevice;
            this.changedFields = changedFields.add("userExperienceAnalyticsNotAutopilotReadyDevice");
            return this;
        }

        /**
         * <i>“User experience analytics devices not Windows Autopilot ready.”</i>
         * 
         * @param userExperienceAnalyticsNotAutopilotReadyDevice
         *            value of {@code userExperienceAnalyticsNotAutopilotReadyDevice} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userExperienceAnalyticsNotAutopilotReadyDevice(UserExperienceAnalyticsNotAutopilotReadyDevice... userExperienceAnalyticsNotAutopilotReadyDevice) {
            return userExperienceAnalyticsNotAutopilotReadyDevice(Arrays.asList(userExperienceAnalyticsNotAutopilotReadyDevice));
        }

        /**
         * <i>“User experience analytics overview”</i>
         * 
         * @param userExperienceAnalyticsOverview
         *            value of {@code userExperienceAnalyticsOverview} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userExperienceAnalyticsOverview(UserExperienceAnalyticsOverview userExperienceAnalyticsOverview) {
            this.userExperienceAnalyticsOverview = userExperienceAnalyticsOverview;
            this.changedFields = changedFields.add("userExperienceAnalyticsOverview");
            return this;
        }

        /**
         * <i>“User experience analytics regression summary”</i>
         * 
         * @param userExperienceAnalyticsRegressionSummary
         *            value of {@code userExperienceAnalyticsRegressionSummary} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userExperienceAnalyticsRegressionSummary(UserExperienceAnalyticsRegressionSummary userExperienceAnalyticsRegressionSummary) {
            this.userExperienceAnalyticsRegressionSummary = userExperienceAnalyticsRegressionSummary;
            this.changedFields = changedFields.add("userExperienceAnalyticsRegressionSummary");
            return this;
        }

        /**
         * <i>“User experience analytics remote connection”</i>
         * 
         * @param userExperienceAnalyticsRemoteConnection
         *            value of {@code userExperienceAnalyticsRemoteConnection} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userExperienceAnalyticsRemoteConnection(List<UserExperienceAnalyticsRemoteConnection> userExperienceAnalyticsRemoteConnection) {
            this.userExperienceAnalyticsRemoteConnection = userExperienceAnalyticsRemoteConnection;
            this.changedFields = changedFields.add("userExperienceAnalyticsRemoteConnection");
            return this;
        }

        /**
         * <i>“User experience analytics remote connection”</i>
         * 
         * @param userExperienceAnalyticsRemoteConnection
         *            value of {@code userExperienceAnalyticsRemoteConnection} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userExperienceAnalyticsRemoteConnection(UserExperienceAnalyticsRemoteConnection... userExperienceAnalyticsRemoteConnection) {
            return userExperienceAnalyticsRemoteConnection(Arrays.asList(userExperienceAnalyticsRemoteConnection));
        }

        /**
         * <i>“User experience analytics resource performance”</i>
         * 
         * @param userExperienceAnalyticsResourcePerformance
         *            value of {@code userExperienceAnalyticsResourcePerformance} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userExperienceAnalyticsResourcePerformance(List<UserExperienceAnalyticsResourcePerformance> userExperienceAnalyticsResourcePerformance) {
            this.userExperienceAnalyticsResourcePerformance = userExperienceAnalyticsResourcePerformance;
            this.changedFields = changedFields.add("userExperienceAnalyticsResourcePerformance");
            return this;
        }

        /**
         * <i>“User experience analytics resource performance”</i>
         * 
         * @param userExperienceAnalyticsResourcePerformance
         *            value of {@code userExperienceAnalyticsResourcePerformance} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userExperienceAnalyticsResourcePerformance(UserExperienceAnalyticsResourcePerformance... userExperienceAnalyticsResourcePerformance) {
            return userExperienceAnalyticsResourcePerformance(Arrays.asList(userExperienceAnalyticsResourcePerformance));
        }

        /**
         * <i>“User experience analytics device Startup Score History”</i>
         * 
         * @param userExperienceAnalyticsScoreHistory
         *            value of {@code userExperienceAnalyticsScoreHistory} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userExperienceAnalyticsScoreHistory(List<UserExperienceAnalyticsScoreHistory> userExperienceAnalyticsScoreHistory) {
            this.userExperienceAnalyticsScoreHistory = userExperienceAnalyticsScoreHistory;
            this.changedFields = changedFields.add("userExperienceAnalyticsScoreHistory");
            return this;
        }

        /**
         * <i>“User experience analytics device Startup Score History”</i>
         * 
         * @param userExperienceAnalyticsScoreHistory
         *            value of {@code userExperienceAnalyticsScoreHistory} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userExperienceAnalyticsScoreHistory(UserExperienceAnalyticsScoreHistory... userExperienceAnalyticsScoreHistory) {
            return userExperienceAnalyticsScoreHistory(Arrays.asList(userExperienceAnalyticsScoreHistory));
        }

        /**
         * <i>“User experience analytics work from anywhere hardware readiness metrics.”</i>
         * 
         * @param userExperienceAnalyticsWorkFromAnywhereHardwareReadinessMetric
         *            value of {@code userExperienceAnalyticsWorkFromAnywhereHardwareReadinessMetric} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userExperienceAnalyticsWorkFromAnywhereHardwareReadinessMetric(UserExperienceAnalyticsWorkFromAnywhereHardwareReadinessMetric userExperienceAnalyticsWorkFromAnywhereHardwareReadinessMetric) {
            this.userExperienceAnalyticsWorkFromAnywhereHardwareReadinessMetric = userExperienceAnalyticsWorkFromAnywhereHardwareReadinessMetric;
            this.changedFields = changedFields.add("userExperienceAnalyticsWorkFromAnywhereHardwareReadinessMetric");
            return this;
        }

        /**
         * <i>“User experience analytics work from anywhere metrics.”</i>
         * 
         * @param userExperienceAnalyticsWorkFromAnywhereMetrics
         *            value of {@code userExperienceAnalyticsWorkFromAnywhereMetrics} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userExperienceAnalyticsWorkFromAnywhereMetrics(List<UserExperienceAnalyticsWorkFromAnywhereMetric> userExperienceAnalyticsWorkFromAnywhereMetrics) {
            this.userExperienceAnalyticsWorkFromAnywhereMetrics = userExperienceAnalyticsWorkFromAnywhereMetrics;
            this.changedFields = changedFields.add("userExperienceAnalyticsWorkFromAnywhereMetrics");
            return this;
        }

        /**
         * <i>“User experience analytics work from anywhere metrics.”</i>
         * 
         * @param userExperienceAnalyticsWorkFromAnywhereMetrics
         *            value of {@code userExperienceAnalyticsWorkFromAnywhereMetrics} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userExperienceAnalyticsWorkFromAnywhereMetrics(UserExperienceAnalyticsWorkFromAnywhereMetric... userExperienceAnalyticsWorkFromAnywhereMetrics) {
            return userExperienceAnalyticsWorkFromAnywhereMetrics(Arrays.asList(userExperienceAnalyticsWorkFromAnywhereMetrics));
        }

        /**
         * <i>“The user experience analytics work from anywhere model performance”</i>
         * 
         * @param userExperienceAnalyticsWorkFromAnywhereModelPerformance
         *            value of {@code userExperienceAnalyticsWorkFromAnywhereModelPerformance} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userExperienceAnalyticsWorkFromAnywhereModelPerformance(List<UserExperienceAnalyticsWorkFromAnywhereModelPerformance> userExperienceAnalyticsWorkFromAnywhereModelPerformance) {
            this.userExperienceAnalyticsWorkFromAnywhereModelPerformance = userExperienceAnalyticsWorkFromAnywhereModelPerformance;
            this.changedFields = changedFields.add("userExperienceAnalyticsWorkFromAnywhereModelPerformance");
            return this;
        }

        /**
         * <i>“The user experience analytics work from anywhere model performance”</i>
         * 
         * @param userExperienceAnalyticsWorkFromAnywhereModelPerformance
         *            value of {@code userExperienceAnalyticsWorkFromAnywhereModelPerformance} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userExperienceAnalyticsWorkFromAnywhereModelPerformance(UserExperienceAnalyticsWorkFromAnywhereModelPerformance... userExperienceAnalyticsWorkFromAnywhereModelPerformance) {
            return userExperienceAnalyticsWorkFromAnywhereModelPerformance(Arrays.asList(userExperienceAnalyticsWorkFromAnywhereModelPerformance));
        }

        /**
         * <i>“The list of affected malware in the tenant.”</i>
         * 
         * @param windowsMalwareInformation
         *            value of {@code windowsMalwareInformation} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder windowsMalwareInformation(List<WindowsMalwareInformation> windowsMalwareInformation) {
            this.windowsMalwareInformation = windowsMalwareInformation;
            this.changedFields = changedFields.add("windowsMalwareInformation");
            return this;
        }

        /**
         * <i>“The list of affected malware in the tenant.”</i>
         * 
         * @param windowsMalwareInformation
         *            value of {@code windowsMalwareInformation} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder windowsMalwareInformation(WindowsMalwareInformation... windowsMalwareInformation) {
            return windowsMalwareInformation(Arrays.asList(windowsMalwareInformation));
        }

        /**
         * <i>“Collection of Derived credential settings associated with account.”</i>
         * 
         * @param derivedCredentials
         *            value of {@code derivedCredentials} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder derivedCredentials(List<DeviceManagementDerivedCredentialSettings> derivedCredentials) {
            this.derivedCredentials = derivedCredentials;
            this.changedFields = changedFields.add("derivedCredentials");
            return this;
        }

        /**
         * <i>“Collection of Derived credential settings associated with account.”</i>
         * 
         * @param derivedCredentials
         *            value of {@code derivedCredentials} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder derivedCredentials(DeviceManagementDerivedCredentialSettings... derivedCredentials) {
            return derivedCredentials(Arrays.asList(derivedCredentials));
        }

        /**
         * <i>“Collection of resource access settings associated with account.”</i>
         * 
         * @param resourceAccessProfiles
         *            value of {@code resourceAccessProfiles} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder resourceAccessProfiles(List<DeviceManagementResourceAccessProfileBase> resourceAccessProfiles) {
            this.resourceAccessProfiles = resourceAccessProfiles;
            this.changedFields = changedFields.add("resourceAccessProfiles");
            return this;
        }

        /**
         * <i>“Collection of resource access settings associated with account.”</i>
         * 
         * @param resourceAccessProfiles
         *            value of {@code resourceAccessProfiles} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder resourceAccessProfiles(DeviceManagementResourceAccessProfileBase... resourceAccessProfiles) {
            return resourceAccessProfiles(Arrays.asList(resourceAccessProfiles));
        }

        /**
         * <i>“Apple user initiated enrollment profiles”</i>
         * 
         * @param appleUserInitiatedEnrollmentProfiles
         *            value of {@code appleUserInitiatedEnrollmentProfiles} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder appleUserInitiatedEnrollmentProfiles(List<AppleUserInitiatedEnrollmentProfile> appleUserInitiatedEnrollmentProfiles) {
            this.appleUserInitiatedEnrollmentProfiles = appleUserInitiatedEnrollmentProfiles;
            this.changedFields = changedFields.add("appleUserInitiatedEnrollmentProfiles");
            return this;
        }

        /**
         * <i>“Apple user initiated enrollment profiles”</i>
         * 
         * @param appleUserInitiatedEnrollmentProfiles
         *            value of {@code appleUserInitiatedEnrollmentProfiles} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder appleUserInitiatedEnrollmentProfiles(AppleUserInitiatedEnrollmentProfile... appleUserInitiatedEnrollmentProfiles) {
            return appleUserInitiatedEnrollmentProfiles(Arrays.asList(appleUserInitiatedEnrollmentProfiles));
        }

        /**
         * <i>“This collections of multiple DEP tokens per-tenant.”</i>
         * 
         * @param depOnboardingSettings
         *            value of {@code depOnboardingSettings} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder depOnboardingSettings(List<DepOnboardingSetting> depOnboardingSettings) {
            this.depOnboardingSettings = depOnboardingSettings;
            this.changedFields = changedFields.add("depOnboardingSettings");
            return this;
        }

        /**
         * <i>“This collections of multiple DEP tokens per-tenant.”</i>
         * 
         * @param depOnboardingSettings
         *            value of {@code depOnboardingSettings} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder depOnboardingSettings(DepOnboardingSetting... depOnboardingSettings) {
            return depOnboardingSettings(Arrays.asList(depOnboardingSettings));
        }

        /**
         * <i>“The imported device identities.”</i>
         * 
         * @param importedDeviceIdentities
         *            value of {@code importedDeviceIdentities} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder importedDeviceIdentities(List<ImportedDeviceIdentity> importedDeviceIdentities) {
            this.importedDeviceIdentities = importedDeviceIdentities;
            this.changedFields = changedFields.add("importedDeviceIdentities");
            return this;
        }

        /**
         * <i>“The imported device identities.”</i>
         * 
         * @param importedDeviceIdentities
         *            value of {@code importedDeviceIdentities} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder importedDeviceIdentities(ImportedDeviceIdentity... importedDeviceIdentities) {
            return importedDeviceIdentities(Arrays.asList(importedDeviceIdentities));
        }

        /**
         * <i>“Collection of imported Windows autopilot devices.”</i>
         * 
         * @param importedWindowsAutopilotDeviceIdentities
         *            value of {@code importedWindowsAutopilotDeviceIdentities} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder importedWindowsAutopilotDeviceIdentities(List<ImportedWindowsAutopilotDeviceIdentity> importedWindowsAutopilotDeviceIdentities) {
            this.importedWindowsAutopilotDeviceIdentities = importedWindowsAutopilotDeviceIdentities;
            this.changedFields = changedFields.add("importedWindowsAutopilotDeviceIdentities");
            return this;
        }

        /**
         * <i>“Collection of imported Windows autopilot devices.”</i>
         * 
         * @param importedWindowsAutopilotDeviceIdentities
         *            value of {@code importedWindowsAutopilotDeviceIdentities} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder importedWindowsAutopilotDeviceIdentities(ImportedWindowsAutopilotDeviceIdentity... importedWindowsAutopilotDeviceIdentities) {
            return importedWindowsAutopilotDeviceIdentities(Arrays.asList(importedWindowsAutopilotDeviceIdentities));
        }

        /**
         * <i>“Windows auto pilot deployment profiles”</i>
         * 
         * @param windowsAutopilotDeploymentProfiles
         *            value of {@code windowsAutopilotDeploymentProfiles} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder windowsAutopilotDeploymentProfiles(List<WindowsAutopilotDeploymentProfile> windowsAutopilotDeploymentProfiles) {
            this.windowsAutopilotDeploymentProfiles = windowsAutopilotDeploymentProfiles;
            this.changedFields = changedFields.add("windowsAutopilotDeploymentProfiles");
            return this;
        }

        /**
         * <i>“Windows auto pilot deployment profiles”</i>
         * 
         * @param windowsAutopilotDeploymentProfiles
         *            value of {@code windowsAutopilotDeploymentProfiles} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder windowsAutopilotDeploymentProfiles(WindowsAutopilotDeploymentProfile... windowsAutopilotDeploymentProfiles) {
            return windowsAutopilotDeploymentProfiles(Arrays.asList(windowsAutopilotDeploymentProfiles));
        }

        /**
         * <i>“The Windows autopilot device identities contained collection.”</i>
         * 
         * @param windowsAutopilotDeviceIdentities
         *            value of {@code windowsAutopilotDeviceIdentities} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder windowsAutopilotDeviceIdentities(List<WindowsAutopilotDeviceIdentity> windowsAutopilotDeviceIdentities) {
            this.windowsAutopilotDeviceIdentities = windowsAutopilotDeviceIdentities;
            this.changedFields = changedFields.add("windowsAutopilotDeviceIdentities");
            return this;
        }

        /**
         * <i>“The Windows autopilot device identities contained collection.”</i>
         * 
         * @param windowsAutopilotDeviceIdentities
         *            value of {@code windowsAutopilotDeviceIdentities} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder windowsAutopilotDeviceIdentities(WindowsAutopilotDeviceIdentity... windowsAutopilotDeviceIdentities) {
            return windowsAutopilotDeviceIdentities(Arrays.asList(windowsAutopilotDeviceIdentities));
        }

        /**
         * <i>“The Windows autopilot account settings.”</i>
         * 
         * @param windowsAutopilotSettings
         *            value of {@code windowsAutopilotSettings} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder windowsAutopilotSettings(WindowsAutopilotSettings windowsAutopilotSettings) {
            this.windowsAutopilotSettings = windowsAutopilotSettings;
            this.changedFields = changedFields.add("windowsAutopilotSettings");
            return this;
        }

        /**
         * <i>“The management conditions associated with device management of the company.”</i>
         * 
         * @param managementConditions
         *            value of {@code managementConditions} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder managementConditions(List<ManagementCondition> managementConditions) {
            this.managementConditions = managementConditions;
            this.changedFields = changedFields.add("managementConditions");
            return this;
        }

        /**
         * <i>“The management conditions associated with device management of the company.”</i>
         * 
         * @param managementConditions
         *            value of {@code managementConditions} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder managementConditions(ManagementCondition... managementConditions) {
            return managementConditions(Arrays.asList(managementConditions));
        }

        /**
         * <i>“The management condition statements associated with device management of the
         * company.”</i>
         * 
         * @param managementConditionStatements
         *            value of {@code managementConditionStatements} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder managementConditionStatements(List<ManagementConditionStatement> managementConditionStatements) {
            this.managementConditionStatements = managementConditionStatements;
            this.changedFields = changedFields.add("managementConditionStatements");
            return this;
        }

        /**
         * <i>“The management condition statements associated with device management of the
         * company.”</i>
         * 
         * @param managementConditionStatements
         *            value of {@code managementConditionStatements} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder managementConditionStatements(ManagementConditionStatement... managementConditionStatements) {
            return managementConditionStatements(Arrays.asList(managementConditionStatements));
        }

        /**
         * <i>“A list of Group Policy migration reports.”</i>
         * 
         * @param groupPolicyMigrationReports
         *            value of {@code groupPolicyMigrationReports} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder groupPolicyMigrationReports(List<GroupPolicyMigrationReport> groupPolicyMigrationReports) {
            this.groupPolicyMigrationReports = groupPolicyMigrationReports;
            this.changedFields = changedFields.add("groupPolicyMigrationReports");
            return this;
        }

        /**
         * <i>“A list of Group Policy migration reports.”</i>
         * 
         * @param groupPolicyMigrationReports
         *            value of {@code groupPolicyMigrationReports} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder groupPolicyMigrationReports(GroupPolicyMigrationReport... groupPolicyMigrationReports) {
            return groupPolicyMigrationReports(Arrays.asList(groupPolicyMigrationReports));
        }

        /**
         * <i>“A list of Group Policy Object files uploaded.”</i>
         * 
         * @param groupPolicyObjectFiles
         *            value of {@code groupPolicyObjectFiles} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder groupPolicyObjectFiles(List<GroupPolicyObjectFile> groupPolicyObjectFiles) {
            this.groupPolicyObjectFiles = groupPolicyObjectFiles;
            this.changedFields = changedFields.add("groupPolicyObjectFiles");
            return this;
        }

        /**
         * <i>“A list of Group Policy Object files uploaded.”</i>
         * 
         * @param groupPolicyObjectFiles
         *            value of {@code groupPolicyObjectFiles} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder groupPolicyObjectFiles(GroupPolicyObjectFile... groupPolicyObjectFiles) {
            return groupPolicyObjectFiles(Arrays.asList(groupPolicyObjectFiles));
        }

        /**
         * <i>“The available group policy categories for this account.”</i>
         * 
         * @param groupPolicyCategories
         *            value of {@code groupPolicyCategories} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder groupPolicyCategories(List<GroupPolicyCategory> groupPolicyCategories) {
            this.groupPolicyCategories = groupPolicyCategories;
            this.changedFields = changedFields.add("groupPolicyCategories");
            return this;
        }

        /**
         * <i>“The available group policy categories for this account.”</i>
         * 
         * @param groupPolicyCategories
         *            value of {@code groupPolicyCategories} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder groupPolicyCategories(GroupPolicyCategory... groupPolicyCategories) {
            return groupPolicyCategories(Arrays.asList(groupPolicyCategories));
        }

        /**
         * <i>“The group policy configurations created by this account.”</i>
         * 
         * @param groupPolicyConfigurations
         *            value of {@code groupPolicyConfigurations} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder groupPolicyConfigurations(List<GroupPolicyConfiguration> groupPolicyConfigurations) {
            this.groupPolicyConfigurations = groupPolicyConfigurations;
            this.changedFields = changedFields.add("groupPolicyConfigurations");
            return this;
        }

        /**
         * <i>“The group policy configurations created by this account.”</i>
         * 
         * @param groupPolicyConfigurations
         *            value of {@code groupPolicyConfigurations} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder groupPolicyConfigurations(GroupPolicyConfiguration... groupPolicyConfigurations) {
            return groupPolicyConfigurations(Arrays.asList(groupPolicyConfigurations));
        }

        /**
         * <i>“The available group policy definition files for this account.”</i>
         * 
         * @param groupPolicyDefinitionFiles
         *            value of {@code groupPolicyDefinitionFiles} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder groupPolicyDefinitionFiles(List<GroupPolicyDefinitionFile> groupPolicyDefinitionFiles) {
            this.groupPolicyDefinitionFiles = groupPolicyDefinitionFiles;
            this.changedFields = changedFields.add("groupPolicyDefinitionFiles");
            return this;
        }

        /**
         * <i>“The available group policy definition files for this account.”</i>
         * 
         * @param groupPolicyDefinitionFiles
         *            value of {@code groupPolicyDefinitionFiles} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder groupPolicyDefinitionFiles(GroupPolicyDefinitionFile... groupPolicyDefinitionFiles) {
            return groupPolicyDefinitionFiles(Arrays.asList(groupPolicyDefinitionFiles));
        }

        /**
         * <i>“The available group policy definitions for this account.”</i>
         * 
         * @param groupPolicyDefinitions
         *            value of {@code groupPolicyDefinitions} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder groupPolicyDefinitions(List<GroupPolicyDefinition> groupPolicyDefinitions) {
            this.groupPolicyDefinitions = groupPolicyDefinitions;
            this.changedFields = changedFields.add("groupPolicyDefinitions");
            return this;
        }

        /**
         * <i>“The available group policy definitions for this account.”</i>
         * 
         * @param groupPolicyDefinitions
         *            value of {@code groupPolicyDefinitions} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder groupPolicyDefinitions(GroupPolicyDefinition... groupPolicyDefinitions) {
            return groupPolicyDefinitions(Arrays.asList(groupPolicyDefinitions));
        }

        /**
         * <i>“The available group policy uploaded definition files for this account.”</i>
         * 
         * @param groupPolicyUploadedDefinitionFiles
         *            value of {@code groupPolicyUploadedDefinitionFiles} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder groupPolicyUploadedDefinitionFiles(List<GroupPolicyUploadedDefinitionFile> groupPolicyUploadedDefinitionFiles) {
            this.groupPolicyUploadedDefinitionFiles = groupPolicyUploadedDefinitionFiles;
            this.changedFields = changedFields.add("groupPolicyUploadedDefinitionFiles");
            return this;
        }

        /**
         * <i>“The available group policy uploaded definition files for this account.”</i>
         * 
         * @param groupPolicyUploadedDefinitionFiles
         *            value of {@code groupPolicyUploadedDefinitionFiles} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder groupPolicyUploadedDefinitionFiles(GroupPolicyUploadedDefinitionFile... groupPolicyUploadedDefinitionFiles) {
            return groupPolicyUploadedDefinitionFiles(Arrays.asList(groupPolicyUploadedDefinitionFiles));
        }

        /**
         * <i>“Collection of MicrosoftTunnelConfiguration settings associated with account.”</i>
         * 
         * @param microsoftTunnelConfigurations
         *            value of {@code microsoftTunnelConfigurations} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder microsoftTunnelConfigurations(List<MicrosoftTunnelConfiguration> microsoftTunnelConfigurations) {
            this.microsoftTunnelConfigurations = microsoftTunnelConfigurations;
            this.changedFields = changedFields.add("microsoftTunnelConfigurations");
            return this;
        }

        /**
         * <i>“Collection of MicrosoftTunnelConfiguration settings associated with account.”</i>
         * 
         * @param microsoftTunnelConfigurations
         *            value of {@code microsoftTunnelConfigurations} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder microsoftTunnelConfigurations(MicrosoftTunnelConfiguration... microsoftTunnelConfigurations) {
            return microsoftTunnelConfigurations(Arrays.asList(microsoftTunnelConfigurations));
        }

        /**
         * <i>“Collection of MicrosoftTunnelHealthThreshold settings associated with account.”</i>
         * 
         * @param microsoftTunnelHealthThresholds
         *            value of {@code microsoftTunnelHealthThresholds} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder microsoftTunnelHealthThresholds(List<MicrosoftTunnelHealthThreshold> microsoftTunnelHealthThresholds) {
            this.microsoftTunnelHealthThresholds = microsoftTunnelHealthThresholds;
            this.changedFields = changedFields.add("microsoftTunnelHealthThresholds");
            return this;
        }

        /**
         * <i>“Collection of MicrosoftTunnelHealthThreshold settings associated with account.”</i>
         * 
         * @param microsoftTunnelHealthThresholds
         *            value of {@code microsoftTunnelHealthThresholds} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder microsoftTunnelHealthThresholds(MicrosoftTunnelHealthThreshold... microsoftTunnelHealthThresholds) {
            return microsoftTunnelHealthThresholds(Arrays.asList(microsoftTunnelHealthThresholds));
        }

        /**
         * <i>“Collection of MicrosoftTunnelServerLogCollectionResponse settings associated
         * with account.”</i>
         * 
         * @param microsoftTunnelServerLogCollectionResponses
         *            value of {@code microsoftTunnelServerLogCollectionResponses} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder microsoftTunnelServerLogCollectionResponses(List<MicrosoftTunnelServerLogCollectionResponse> microsoftTunnelServerLogCollectionResponses) {
            this.microsoftTunnelServerLogCollectionResponses = microsoftTunnelServerLogCollectionResponses;
            this.changedFields = changedFields.add("microsoftTunnelServerLogCollectionResponses");
            return this;
        }

        /**
         * <i>“Collection of MicrosoftTunnelServerLogCollectionResponse settings associated
         * with account.”</i>
         * 
         * @param microsoftTunnelServerLogCollectionResponses
         *            value of {@code microsoftTunnelServerLogCollectionResponses} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder microsoftTunnelServerLogCollectionResponses(MicrosoftTunnelServerLogCollectionResponse... microsoftTunnelServerLogCollectionResponses) {
            return microsoftTunnelServerLogCollectionResponses(Arrays.asList(microsoftTunnelServerLogCollectionResponses));
        }

        /**
         * <i>“Collection of MicrosoftTunnelSite settings associated with account.”</i>
         * 
         * @param microsoftTunnelSites
         *            value of {@code microsoftTunnelSites} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder microsoftTunnelSites(List<MicrosoftTunnelSite> microsoftTunnelSites) {
            this.microsoftTunnelSites = microsoftTunnelSites;
            this.changedFields = changedFields.add("microsoftTunnelSites");
            return this;
        }

        /**
         * <i>“Collection of MicrosoftTunnelSite settings associated with account.”</i>
         * 
         * @param microsoftTunnelSites
         *            value of {@code microsoftTunnelSites} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder microsoftTunnelSites(MicrosoftTunnelSite... microsoftTunnelSites) {
            return microsoftTunnelSites(Arrays.asList(microsoftTunnelSites));
        }

        /**
         * <i>“The Notification Message Templates.”</i>
         * 
         * @param notificationMessageTemplates
         *            value of {@code notificationMessageTemplates} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder notificationMessageTemplates(List<NotificationMessageTemplate> notificationMessageTemplates) {
            this.notificationMessageTemplates = notificationMessageTemplates;
            this.changedFields = changedFields.add("notificationMessageTemplates");
            return this;
        }

        /**
         * <i>“The Notification Message Templates.”</i>
         * 
         * @param notificationMessageTemplates
         *            value of {@code notificationMessageTemplates} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder notificationMessageTemplates(NotificationMessageTemplate... notificationMessageTemplates) {
            return notificationMessageTemplates(Arrays.asList(notificationMessageTemplates));
        }

        /**
         * <i>“A list of connector objects.”</i>
         * 
         * @param domainJoinConnectors
         *            value of {@code domainJoinConnectors} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder domainJoinConnectors(List<DeviceManagementDomainJoinConnector> domainJoinConnectors) {
            this.domainJoinConnectors = domainJoinConnectors;
            this.changedFields = changedFields.add("domainJoinConnectors");
            return this;
        }

        /**
         * <i>“A list of connector objects.”</i>
         * 
         * @param domainJoinConnectors
         *            value of {@code domainJoinConnectors} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder domainJoinConnectors(DeviceManagementDomainJoinConnector... domainJoinConnectors) {
            return domainJoinConnectors(Arrays.asList(domainJoinConnectors));
        }

        /**
         * <i>“A list of ConfigManagerCollection”</i>
         * 
         * @param configManagerCollections
         *            value of {@code configManagerCollections} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder configManagerCollections(List<ConfigManagerCollection> configManagerCollections) {
            this.configManagerCollections = configManagerCollections;
            this.changedFields = changedFields.add("configManagerCollections");
            return this;
        }

        /**
         * <i>“A list of ConfigManagerCollection”</i>
         * 
         * @param configManagerCollections
         *            value of {@code configManagerCollections} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder configManagerCollections(ConfigManagerCollection... configManagerCollections) {
            return configManagerCollections(Arrays.asList(configManagerCollections));
        }

        /**
         * <i>“The Resource Operations.”</i>
         * 
         * @param resourceOperations
         *            value of {@code resourceOperations} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder resourceOperations(List<ResourceOperation> resourceOperations) {
            this.resourceOperations = resourceOperations;
            this.changedFields = changedFields.add("resourceOperations");
            return this;
        }

        /**
         * <i>“The Resource Operations.”</i>
         * 
         * @param resourceOperations
         *            value of {@code resourceOperations} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder resourceOperations(ResourceOperation... resourceOperations) {
            return resourceOperations(Arrays.asList(resourceOperations));
        }

        /**
         * <i>“The Role Assignments.”</i>
         * 
         * @param roleAssignments
         *            value of {@code roleAssignments} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder roleAssignments(List<DeviceAndAppManagementRoleAssignment> roleAssignments) {
            this.roleAssignments = roleAssignments;
            this.changedFields = changedFields.add("roleAssignments");
            return this;
        }

        /**
         * <i>“The Role Assignments.”</i>
         * 
         * @param roleAssignments
         *            value of {@code roleAssignments} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder roleAssignments(DeviceAndAppManagementRoleAssignment... roleAssignments) {
            return roleAssignments(Arrays.asList(roleAssignments));
        }

        /**
         * <i>“The Role Definitions.”</i>
         * 
         * @param roleDefinitions
         *            value of {@code roleDefinitions} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder roleDefinitions(List<RoleDefinition> roleDefinitions) {
            this.roleDefinitions = roleDefinitions;
            this.changedFields = changedFields.add("roleDefinitions");
            return this;
        }

        /**
         * <i>“The Role Definitions.”</i>
         * 
         * @param roleDefinitions
         *            value of {@code roleDefinitions} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder roleDefinitions(RoleDefinition... roleDefinitions) {
            return roleDefinitions(Arrays.asList(roleDefinitions));
        }

        /**
         * <i>“The Role Scope Tags.”</i>
         * 
         * @param roleScopeTags
         *            value of {@code roleScopeTags} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder roleScopeTags(List<RoleScopeTag> roleScopeTags) {
            this.roleScopeTags = roleScopeTags;
            this.changedFields = changedFields.add("roleScopeTags");
            return this;
        }

        /**
         * <i>“The Role Scope Tags.”</i>
         * 
         * @param roleScopeTags
         *            value of {@code roleScopeTags} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder roleScopeTags(RoleScopeTag... roleScopeTags) {
            return roleScopeTags(Arrays.asList(roleScopeTags));
        }

        /**
         * <i>“The remote assist partners.”</i>
         * 
         * @param remoteAssistancePartners
         *            value of {@code remoteAssistancePartners} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder remoteAssistancePartners(List<RemoteAssistancePartner> remoteAssistancePartners) {
            this.remoteAssistancePartners = remoteAssistancePartners;
            this.changedFields = changedFields.add("remoteAssistancePartners");
            return this;
        }

        /**
         * <i>“The remote assist partners.”</i>
         * 
         * @param remoteAssistancePartners
         *            value of {@code remoteAssistancePartners} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder remoteAssistancePartners(RemoteAssistancePartner... remoteAssistancePartners) {
            return remoteAssistancePartners(Arrays.asList(remoteAssistancePartners));
        }

        /**
         * <i>“The remote assistance settings singleton”</i>
         * 
         * @param remoteAssistanceSettings
         *            value of {@code remoteAssistanceSettings} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder remoteAssistanceSettings(RemoteAssistanceSettings remoteAssistanceSettings) {
            this.remoteAssistanceSettings = remoteAssistanceSettings;
            this.changedFields = changedFields.add("remoteAssistanceSettings");
            return this;
        }

        /**
         * <i>“Reports singleton”</i>
         * 
         * @param reports
         *            value of {@code reports} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder reports(DeviceManagementReports reports) {
            this.reports = reports;
            this.changedFields = changedFields.add("reports");
            return this;
        }

        /**
         * <i>“The embedded SIM activation code pools created by this account.”</i>
         * 
         * @param embeddedSIMActivationCodePools
         *            value of {@code embeddedSIMActivationCodePools} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder embeddedSIMActivationCodePools(List<EmbeddedSIMActivationCodePool> embeddedSIMActivationCodePools) {
            this.embeddedSIMActivationCodePools = embeddedSIMActivationCodePools;
            this.changedFields = changedFields.add("embeddedSIMActivationCodePools");
            return this;
        }

        /**
         * <i>“The embedded SIM activation code pools created by this account.”</i>
         * 
         * @param embeddedSIMActivationCodePools
         *            value of {@code embeddedSIMActivationCodePools} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder embeddedSIMActivationCodePools(EmbeddedSIMActivationCodePool... embeddedSIMActivationCodePools) {
            return embeddedSIMActivationCodePools(Arrays.asList(embeddedSIMActivationCodePools));
        }

        /**
         * <i>“The telecom expense management partners.”</i>
         * 
         * @param telecomExpenseManagementPartners
         *            value of {@code telecomExpenseManagementPartners} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder telecomExpenseManagementPartners(List<TelecomExpenseManagementPartner> telecomExpenseManagementPartners) {
            this.telecomExpenseManagementPartners = telecomExpenseManagementPartners;
            this.changedFields = changedFields.add("telecomExpenseManagementPartners");
            return this;
        }

        /**
         * <i>“The telecom expense management partners.”</i>
         * 
         * @param telecomExpenseManagementPartners
         *            value of {@code telecomExpenseManagementPartners} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder telecomExpenseManagementPartners(TelecomExpenseManagementPartner... telecomExpenseManagementPartners) {
            return telecomExpenseManagementPartners(Arrays.asList(telecomExpenseManagementPartners));
        }

        /**
         * <i>“The list of autopilot events for the tenant.”</i>
         * 
         * @param autopilotEvents
         *            value of {@code autopilotEvents} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder autopilotEvents(List<DeviceManagementAutopilotEvent> autopilotEvents) {
            this.autopilotEvents = autopilotEvents;
            this.changedFields = changedFields.add("autopilotEvents");
            return this;
        }

        /**
         * <i>“The list of autopilot events for the tenant.”</i>
         * 
         * @param autopilotEvents
         *            value of {@code autopilotEvents} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder autopilotEvents(DeviceManagementAutopilotEvent... autopilotEvents) {
            return autopilotEvents(Arrays.asList(autopilotEvents));
        }

        /**
         * <i>“The list of troubleshooting events for the tenant.”</i>
         * 
         * @param troubleshootingEvents
         *            value of {@code troubleshootingEvents} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder troubleshootingEvents(List<DeviceManagementTroubleshootingEvent> troubleshootingEvents) {
            this.troubleshootingEvents = troubleshootingEvents;
            this.changedFields = changedFields.add("troubleshootingEvents");
            return this;
        }

        /**
         * <i>“The list of troubleshooting events for the tenant.”</i>
         * 
         * @param troubleshootingEvents
         *            value of {@code troubleshootingEvents} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder troubleshootingEvents(DeviceManagementTroubleshootingEvent... troubleshootingEvents) {
            return troubleshootingEvents(Arrays.asList(troubleshootingEvents));
        }

        /**
         * <i>“A collection of windows driver update profiles”</i>
         * 
         * @param windowsDriverUpdateProfiles
         *            value of {@code windowsDriverUpdateProfiles} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder windowsDriverUpdateProfiles(List<WindowsDriverUpdateProfile> windowsDriverUpdateProfiles) {
            this.windowsDriverUpdateProfiles = windowsDriverUpdateProfiles;
            this.changedFields = changedFields.add("windowsDriverUpdateProfiles");
            return this;
        }

        /**
         * <i>“A collection of windows driver update profiles”</i>
         * 
         * @param windowsDriverUpdateProfiles
         *            value of {@code windowsDriverUpdateProfiles} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder windowsDriverUpdateProfiles(WindowsDriverUpdateProfile... windowsDriverUpdateProfiles) {
            return windowsDriverUpdateProfiles(Arrays.asList(windowsDriverUpdateProfiles));
        }

        /**
         * <i>“A collection of windows feature update profiles”</i>
         * 
         * @param windowsFeatureUpdateProfiles
         *            value of {@code windowsFeatureUpdateProfiles} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder windowsFeatureUpdateProfiles(List<WindowsFeatureUpdateProfile> windowsFeatureUpdateProfiles) {
            this.windowsFeatureUpdateProfiles = windowsFeatureUpdateProfiles;
            this.changedFields = changedFields.add("windowsFeatureUpdateProfiles");
            return this;
        }

        /**
         * <i>“A collection of windows feature update profiles”</i>
         * 
         * @param windowsFeatureUpdateProfiles
         *            value of {@code windowsFeatureUpdateProfiles} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder windowsFeatureUpdateProfiles(WindowsFeatureUpdateProfile... windowsFeatureUpdateProfiles) {
            return windowsFeatureUpdateProfiles(Arrays.asList(windowsFeatureUpdateProfiles));
        }

        /**
         * <i>“A collection of windows quality update profiles”</i>
         * 
         * @param windowsQualityUpdateProfiles
         *            value of {@code windowsQualityUpdateProfiles} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder windowsQualityUpdateProfiles(List<WindowsQualityUpdateProfile> windowsQualityUpdateProfiles) {
            this.windowsQualityUpdateProfiles = windowsQualityUpdateProfiles;
            this.changedFields = changedFields.add("windowsQualityUpdateProfiles");
            return this;
        }

        /**
         * <i>“A collection of windows quality update profiles”</i>
         * 
         * @param windowsQualityUpdateProfiles
         *            value of {@code windowsQualityUpdateProfiles} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder windowsQualityUpdateProfiles(WindowsQualityUpdateProfile... windowsQualityUpdateProfiles) {
            return windowsQualityUpdateProfiles(Arrays.asList(windowsQualityUpdateProfiles));
        }

        /**
         * <i>“A collection of windows update catalog items (fetaure updates item , quality
         * updates item)”</i>
         * 
         * @param windowsUpdateCatalogItems
         *            value of {@code windowsUpdateCatalogItems} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder windowsUpdateCatalogItems(List<WindowsUpdateCatalogItem> windowsUpdateCatalogItems) {
            this.windowsUpdateCatalogItems = windowsUpdateCatalogItems;
            this.changedFields = changedFields.add("windowsUpdateCatalogItems");
            return this;
        }

        /**
         * <i>“A collection of windows update catalog items (fetaure updates item , quality
         * updates item)”</i>
         * 
         * @param windowsUpdateCatalogItems
         *            value of {@code windowsUpdateCatalogItems} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder windowsUpdateCatalogItems(WindowsUpdateCatalogItem... windowsUpdateCatalogItems) {
            return windowsUpdateCatalogItems(Arrays.asList(windowsUpdateCatalogItems));
        }

        /**
         * <i>“Intune branding profiles targeted to AAD groups”</i>
         * 
         * @param intuneBrandingProfiles
         *            value of {@code intuneBrandingProfiles} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder intuneBrandingProfiles(List<IntuneBrandingProfile> intuneBrandingProfiles) {
            this.intuneBrandingProfiles = intuneBrandingProfiles;
            this.changedFields = changedFields.add("intuneBrandingProfiles");
            return this;
        }

        /**
         * <i>“Intune branding profiles targeted to AAD groups”</i>
         * 
         * @param intuneBrandingProfiles
         *            value of {@code intuneBrandingProfiles} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder intuneBrandingProfiles(IntuneBrandingProfile... intuneBrandingProfiles) {
            return intuneBrandingProfiles(Arrays.asList(intuneBrandingProfiles));
        }

        /**
         * <i>“The windows information protection app learning summaries.”</i>
         * 
         * @param windowsInformationProtectionAppLearningSummaries
         *            value of {@code windowsInformationProtectionAppLearningSummaries} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder windowsInformationProtectionAppLearningSummaries(List<WindowsInformationProtectionAppLearningSummary> windowsInformationProtectionAppLearningSummaries) {
            this.windowsInformationProtectionAppLearningSummaries = windowsInformationProtectionAppLearningSummaries;
            this.changedFields = changedFields.add("windowsInformationProtectionAppLearningSummaries");
            return this;
        }

        /**
         * <i>“The windows information protection app learning summaries.”</i>
         * 
         * @param windowsInformationProtectionAppLearningSummaries
         *            value of {@code windowsInformationProtectionAppLearningSummaries} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder windowsInformationProtectionAppLearningSummaries(WindowsInformationProtectionAppLearningSummary... windowsInformationProtectionAppLearningSummaries) {
            return windowsInformationProtectionAppLearningSummaries(Arrays.asList(windowsInformationProtectionAppLearningSummaries));
        }

        /**
         * <i>“The windows information protection network learning summaries.”</i>
         * 
         * @param windowsInformationProtectionNetworkLearningSummaries
         *            value of {@code windowsInformationProtectionNetworkLearningSummaries} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder windowsInformationProtectionNetworkLearningSummaries(List<WindowsInformationProtectionNetworkLearningSummary> windowsInformationProtectionNetworkLearningSummaries) {
            this.windowsInformationProtectionNetworkLearningSummaries = windowsInformationProtectionNetworkLearningSummaries;
            this.changedFields = changedFields.add("windowsInformationProtectionNetworkLearningSummaries");
            return this;
        }

        /**
         * <i>“The windows information protection network learning summaries.”</i>
         * 
         * @param windowsInformationProtectionNetworkLearningSummaries
         *            value of {@code windowsInformationProtectionNetworkLearningSummaries} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder windowsInformationProtectionNetworkLearningSummaries(WindowsInformationProtectionNetworkLearningSummary... windowsInformationProtectionNetworkLearningSummaries) {
            return windowsInformationProtectionNetworkLearningSummaries(Arrays.asList(windowsInformationProtectionNetworkLearningSummaries));
        }

        /**
         * <i>“Collection of certificate connector details, each associated with a
         * corresponding Intune Certificate Connector.”</i>
         * 
         * @param certificateConnectorDetails
         *            value of {@code certificateConnectorDetails} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder certificateConnectorDetails(List<CertificateConnectorDetails> certificateConnectorDetails) {
            this.certificateConnectorDetails = certificateConnectorDetails;
            this.changedFields = changedFields.add("certificateConnectorDetails");
            return this;
        }

        /**
         * <i>“Collection of certificate connector details, each associated with a
         * corresponding Intune Certificate Connector.”</i>
         * 
         * @param certificateConnectorDetails
         *            value of {@code certificateConnectorDetails} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder certificateConnectorDetails(CertificateConnectorDetails... certificateConnectorDetails) {
            return certificateConnectorDetails(Arrays.asList(certificateConnectorDetails));
        }

        /**
         * <i>“Collection of PFX certificates associated with a user.”</i>
         * 
         * @param userPfxCertificates
         *            value of {@code userPfxCertificates} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userPfxCertificates(List<UserPFXCertificate> userPfxCertificates) {
            this.userPfxCertificates = userPfxCertificates;
            this.changedFields = changedFields.add("userPfxCertificates");
            return this;
        }

        /**
         * <i>“Collection of PFX certificates associated with a user.”</i>
         * 
         * @param userPfxCertificates
         *            value of {@code userPfxCertificates} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userPfxCertificates(UserPFXCertificate... userPfxCertificates) {
            return userPfxCertificates(Arrays.asList(userPfxCertificates));
        }

        public DeviceManagement build() {
            DeviceManagement _x = new DeviceManagement();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.deviceManagement";
            _x.id = id;
            _x.deviceComplianceReportSummarizationDateTime = deviceComplianceReportSummarizationDateTime;
            _x.intuneAccountId = intuneAccountId;
            _x.lastReportAggregationDateTime = lastReportAggregationDateTime;
            _x.legacyPcManangementEnabled = legacyPcManangementEnabled;
            _x.maximumDepTokens = maximumDepTokens;
            _x.settings = settings;
            _x.unlicensedAdminstratorsEnabled = unlicensedAdminstratorsEnabled;
            _x.intuneBrand = intuneBrand;
            _x.accountMoveCompletionDateTime = accountMoveCompletionDateTime;
            _x.adminConsent = adminConsent;
            _x.deviceProtectionOverview = deviceProtectionOverview;
            _x.managedDeviceCleanupSettings = managedDeviceCleanupSettings;
            _x.subscriptions = subscriptions;
            _x.subscriptionState = subscriptionState;
            _x.userExperienceAnalyticsSettings = userExperienceAnalyticsSettings;
            _x.windowsMalwareOverview = windowsMalwareOverview;
            _x.androidDeviceOwnerEnrollmentProfiles = androidDeviceOwnerEnrollmentProfiles;
            _x.virtualEndpoint = virtualEndpoint;
            _x.androidForWorkAppConfigurationSchemas = androidForWorkAppConfigurationSchemas;
            _x.androidForWorkEnrollmentProfiles = androidForWorkEnrollmentProfiles;
            _x.androidForWorkSettings = androidForWorkSettings;
            _x.androidManagedStoreAccountEnterpriseSettings = androidManagedStoreAccountEnterpriseSettings;
            _x.androidManagedStoreAppConfigurationSchemas = androidManagedStoreAppConfigurationSchemas;
            _x.auditEvents = auditEvents;
            _x.assignmentFilters = assignmentFilters;
            _x.chromeOSOnboardingSettings = chromeOSOnboardingSettings;
            _x.termsAndConditions = termsAndConditions;
            _x.advancedThreatProtectionOnboardingStateSummary = advancedThreatProtectionOnboardingStateSummary;
            _x.cartToClassAssociations = cartToClassAssociations;
            _x.deviceCompliancePolicies = deviceCompliancePolicies;
            _x.deviceCompliancePolicyDeviceStateSummary = deviceCompliancePolicyDeviceStateSummary;
            _x.deviceCompliancePolicySettingStateSummaries = deviceCompliancePolicySettingStateSummaries;
            _x.deviceConfigurationConflictSummary = deviceConfigurationConflictSummary;
            _x.deviceConfigurationDeviceStateSummaries = deviceConfigurationDeviceStateSummaries;
            _x.deviceConfigurationRestrictedAppsViolations = deviceConfigurationRestrictedAppsViolations;
            _x.deviceConfigurations = deviceConfigurations;
            _x.deviceConfigurationsAllManagedDeviceCertificateStates = deviceConfigurationsAllManagedDeviceCertificateStates;
            _x.deviceConfigurationUserStateSummaries = deviceConfigurationUserStateSummaries;
            _x.iosUpdateStatuses = iosUpdateStatuses;
            _x.macOSSoftwareUpdateAccountSummaries = macOSSoftwareUpdateAccountSummaries;
            _x.managedDeviceEncryptionStates = managedDeviceEncryptionStates;
            _x.ndesConnectors = ndesConnectors;
            _x.complianceCategories = complianceCategories;
            _x.compliancePolicies = compliancePolicies;
            _x.complianceSettings = complianceSettings;
            _x.configurationCategories = configurationCategories;
            _x.configurationPolicies = configurationPolicies;
            _x.configurationPolicyTemplates = configurationPolicyTemplates;
            _x.configurationSettings = configurationSettings;
            _x.reusablePolicySettings = reusablePolicySettings;
            _x.reusableSettings = reusableSettings;
            _x.templateSettings = templateSettings;
            _x.complianceManagementPartners = complianceManagementPartners;
            _x.conditionalAccessSettings = conditionalAccessSettings;
            _x.deviceCategories = deviceCategories;
            _x.deviceEnrollmentConfigurations = deviceEnrollmentConfigurations;
            _x.deviceManagementPartners = deviceManagementPartners;
            _x.exchangeConnectors = exchangeConnectors;
            _x.exchangeOnPremisesPolicies = exchangeOnPremisesPolicies;
            _x.exchangeOnPremisesPolicy = exchangeOnPremisesPolicy;
            _x.mobileThreatDefenseConnectors = mobileThreatDefenseConnectors;
            _x.categories = categories;
            _x.intents = intents;
            _x.settingDefinitions = settingDefinitions;
            _x.templates = templates;
            _x.applePushNotificationCertificate = applePushNotificationCertificate;
            _x.cloudPCConnectivityIssues = cloudPCConnectivityIssues;
            _x.comanagedDevices = comanagedDevices;
            _x.comanagementEligibleDevices = comanagementEligibleDevices;
            _x.dataSharingConsents = dataSharingConsents;
            _x.detectedApps = detectedApps;
            _x.deviceComplianceScripts = deviceComplianceScripts;
            _x.deviceCustomAttributeShellScripts = deviceCustomAttributeShellScripts;
            _x.deviceHealthScripts = deviceHealthScripts;
            _x.deviceManagementScripts = deviceManagementScripts;
            _x.deviceShellScripts = deviceShellScripts;
            _x.managedDevices = managedDevices;
            _x.mobileAppTroubleshootingEvents = mobileAppTroubleshootingEvents;
            _x.oemWarrantyInformationOnboarding = oemWarrantyInformationOnboarding;
            _x.remoteActionAudits = remoteActionAudits;
            _x.userExperienceAnalyticsAppHealthApplicationPerformance = userExperienceAnalyticsAppHealthApplicationPerformance;
            _x.userExperienceAnalyticsAppHealthApplicationPerformanceByAppVersion = userExperienceAnalyticsAppHealthApplicationPerformanceByAppVersion;
            _x.userExperienceAnalyticsAppHealthApplicationPerformanceByAppVersionDetails = userExperienceAnalyticsAppHealthApplicationPerformanceByAppVersionDetails;
            _x.userExperienceAnalyticsAppHealthApplicationPerformanceByAppVersionDeviceId = userExperienceAnalyticsAppHealthApplicationPerformanceByAppVersionDeviceId;
            _x.userExperienceAnalyticsAppHealthApplicationPerformanceByOSVersion = userExperienceAnalyticsAppHealthApplicationPerformanceByOSVersion;
            _x.userExperienceAnalyticsAppHealthDeviceModelPerformance = userExperienceAnalyticsAppHealthDeviceModelPerformance;
            _x.userExperienceAnalyticsAppHealthDevicePerformance = userExperienceAnalyticsAppHealthDevicePerformance;
            _x.userExperienceAnalyticsAppHealthDevicePerformanceDetails = userExperienceAnalyticsAppHealthDevicePerformanceDetails;
            _x.userExperienceAnalyticsAppHealthOSVersionPerformance = userExperienceAnalyticsAppHealthOSVersionPerformance;
            _x.userExperienceAnalyticsAppHealthOverview = userExperienceAnalyticsAppHealthOverview;
            _x.userExperienceAnalyticsBaselines = userExperienceAnalyticsBaselines;
            _x.userExperienceAnalyticsBatteryHealthAppImpact = userExperienceAnalyticsBatteryHealthAppImpact;
            _x.userExperienceAnalyticsBatteryHealthCapacityDetails = userExperienceAnalyticsBatteryHealthCapacityDetails;
            _x.userExperienceAnalyticsBatteryHealthDeviceAppImpact = userExperienceAnalyticsBatteryHealthDeviceAppImpact;
            _x.userExperienceAnalyticsBatteryHealthDevicePerformance = userExperienceAnalyticsBatteryHealthDevicePerformance;
            _x.userExperienceAnalyticsBatteryHealthDeviceRuntimeHistory = userExperienceAnalyticsBatteryHealthDeviceRuntimeHistory;
            _x.userExperienceAnalyticsBatteryHealthModelPerformance = userExperienceAnalyticsBatteryHealthModelPerformance;
            _x.userExperienceAnalyticsBatteryHealthOsPerformance = userExperienceAnalyticsBatteryHealthOsPerformance;
            _x.userExperienceAnalyticsBatteryHealthRuntimeDetails = userExperienceAnalyticsBatteryHealthRuntimeDetails;
            _x.userExperienceAnalyticsCategories = userExperienceAnalyticsCategories;
            _x.userExperienceAnalyticsDeviceMetricHistory = userExperienceAnalyticsDeviceMetricHistory;
            _x.userExperienceAnalyticsDevicePerformance = userExperienceAnalyticsDevicePerformance;
            _x.userExperienceAnalyticsDeviceScores = userExperienceAnalyticsDeviceScores;
            _x.userExperienceAnalyticsDeviceStartupHistory = userExperienceAnalyticsDeviceStartupHistory;
            _x.userExperienceAnalyticsDeviceStartupProcesses = userExperienceAnalyticsDeviceStartupProcesses;
            _x.userExperienceAnalyticsDeviceStartupProcessPerformance = userExperienceAnalyticsDeviceStartupProcessPerformance;
            _x.userExperienceAnalyticsDevicesWithoutCloudIdentity = userExperienceAnalyticsDevicesWithoutCloudIdentity;
            _x.userExperienceAnalyticsImpactingProcess = userExperienceAnalyticsImpactingProcess;
            _x.userExperienceAnalyticsMetricHistory = userExperienceAnalyticsMetricHistory;
            _x.userExperienceAnalyticsModelScores = userExperienceAnalyticsModelScores;
            _x.userExperienceAnalyticsNotAutopilotReadyDevice = userExperienceAnalyticsNotAutopilotReadyDevice;
            _x.userExperienceAnalyticsOverview = userExperienceAnalyticsOverview;
            _x.userExperienceAnalyticsRegressionSummary = userExperienceAnalyticsRegressionSummary;
            _x.userExperienceAnalyticsRemoteConnection = userExperienceAnalyticsRemoteConnection;
            _x.userExperienceAnalyticsResourcePerformance = userExperienceAnalyticsResourcePerformance;
            _x.userExperienceAnalyticsScoreHistory = userExperienceAnalyticsScoreHistory;
            _x.userExperienceAnalyticsWorkFromAnywhereHardwareReadinessMetric = userExperienceAnalyticsWorkFromAnywhereHardwareReadinessMetric;
            _x.userExperienceAnalyticsWorkFromAnywhereMetrics = userExperienceAnalyticsWorkFromAnywhereMetrics;
            _x.userExperienceAnalyticsWorkFromAnywhereModelPerformance = userExperienceAnalyticsWorkFromAnywhereModelPerformance;
            _x.windowsMalwareInformation = windowsMalwareInformation;
            _x.derivedCredentials = derivedCredentials;
            _x.resourceAccessProfiles = resourceAccessProfiles;
            _x.appleUserInitiatedEnrollmentProfiles = appleUserInitiatedEnrollmentProfiles;
            _x.depOnboardingSettings = depOnboardingSettings;
            _x.importedDeviceIdentities = importedDeviceIdentities;
            _x.importedWindowsAutopilotDeviceIdentities = importedWindowsAutopilotDeviceIdentities;
            _x.windowsAutopilotDeploymentProfiles = windowsAutopilotDeploymentProfiles;
            _x.windowsAutopilotDeviceIdentities = windowsAutopilotDeviceIdentities;
            _x.windowsAutopilotSettings = windowsAutopilotSettings;
            _x.managementConditions = managementConditions;
            _x.managementConditionStatements = managementConditionStatements;
            _x.groupPolicyMigrationReports = groupPolicyMigrationReports;
            _x.groupPolicyObjectFiles = groupPolicyObjectFiles;
            _x.groupPolicyCategories = groupPolicyCategories;
            _x.groupPolicyConfigurations = groupPolicyConfigurations;
            _x.groupPolicyDefinitionFiles = groupPolicyDefinitionFiles;
            _x.groupPolicyDefinitions = groupPolicyDefinitions;
            _x.groupPolicyUploadedDefinitionFiles = groupPolicyUploadedDefinitionFiles;
            _x.microsoftTunnelConfigurations = microsoftTunnelConfigurations;
            _x.microsoftTunnelHealthThresholds = microsoftTunnelHealthThresholds;
            _x.microsoftTunnelServerLogCollectionResponses = microsoftTunnelServerLogCollectionResponses;
            _x.microsoftTunnelSites = microsoftTunnelSites;
            _x.notificationMessageTemplates = notificationMessageTemplates;
            _x.domainJoinConnectors = domainJoinConnectors;
            _x.configManagerCollections = configManagerCollections;
            _x.resourceOperations = resourceOperations;
            _x.roleAssignments = roleAssignments;
            _x.roleDefinitions = roleDefinitions;
            _x.roleScopeTags = roleScopeTags;
            _x.remoteAssistancePartners = remoteAssistancePartners;
            _x.remoteAssistanceSettings = remoteAssistanceSettings;
            _x.reports = reports;
            _x.embeddedSIMActivationCodePools = embeddedSIMActivationCodePools;
            _x.telecomExpenseManagementPartners = telecomExpenseManagementPartners;
            _x.autopilotEvents = autopilotEvents;
            _x.troubleshootingEvents = troubleshootingEvents;
            _x.windowsDriverUpdateProfiles = windowsDriverUpdateProfiles;
            _x.windowsFeatureUpdateProfiles = windowsFeatureUpdateProfiles;
            _x.windowsQualityUpdateProfiles = windowsQualityUpdateProfiles;
            _x.windowsUpdateCatalogItems = windowsUpdateCatalogItems;
            _x.intuneBrandingProfiles = intuneBrandingProfiles;
            _x.windowsInformationProtectionAppLearningSummaries = windowsInformationProtectionAppLearningSummaries;
            _x.windowsInformationProtectionNetworkLearningSummaries = windowsInformationProtectionNetworkLearningSummaries;
            _x.certificateConnectorDetails = certificateConnectorDetails;
            _x.userPfxCertificates = userPfxCertificates;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“The last requested time of device compliance reporting for this account. This
     * property is read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @return property deviceComplianceReportSummarizationDateTime
     */
    @Property(name="deviceComplianceReportSummarizationDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getDeviceComplianceReportSummarizationDateTime() {
        return Optional.ofNullable(deviceComplianceReportSummarizationDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * deviceComplianceReportSummarizationDateTime} field changed. Field description
     * below. The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“The last requested time of device compliance reporting for this account. This
     * property is read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @param deviceComplianceReportSummarizationDateTime
     *            new value of {@code deviceComplianceReportSummarizationDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceComplianceReportSummarizationDateTime} field changed
     */
    public DeviceManagement withDeviceComplianceReportSummarizationDateTime(OffsetDateTime deviceComplianceReportSummarizationDateTime) {
        DeviceManagement _x = _copy();
        _x.changedFields = changedFields.add("deviceComplianceReportSummarizationDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagement");
        _x.deviceComplianceReportSummarizationDateTime = deviceComplianceReportSummarizationDateTime;
        return _x;
    }

    /**
     * <i>“Intune Account Id for given tenant”</i>
     * 
     * @return property intuneAccountId
     */
    @Property(name="intuneAccountId")
    @JsonIgnore
    public Optional<UUID> getIntuneAccountId() {
        return Optional.ofNullable(intuneAccountId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code intuneAccountId}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Intune Account Id for given tenant”</i>
     * 
     * @param intuneAccountId
     *            new value of {@code intuneAccountId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code intuneAccountId} field changed
     */
    public DeviceManagement withIntuneAccountId(UUID intuneAccountId) {
        DeviceManagement _x = _copy();
        _x.changedFields = changedFields.add("intuneAccountId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagement");
        _x.intuneAccountId = intuneAccountId;
        return _x;
    }

    /**
     * <i>“The last modified time of reporting for this account. This property is read-only
     * .”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @return property lastReportAggregationDateTime
     */
    @Property(name="lastReportAggregationDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastReportAggregationDateTime() {
        return Optional.ofNullable(lastReportAggregationDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * lastReportAggregationDateTime} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“The last modified time of reporting for this account. This property is read-only
     * .”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @param lastReportAggregationDateTime
     *            new value of {@code lastReportAggregationDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code lastReportAggregationDateTime} field changed
     */
    public DeviceManagement withLastReportAggregationDateTime(OffsetDateTime lastReportAggregationDateTime) {
        DeviceManagement _x = _copy();
        _x.changedFields = changedFields.add("lastReportAggregationDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagement");
        _x.lastReportAggregationDateTime = lastReportAggregationDateTime;
        return _x;
    }

    /**
     * <i>“The property to enable Non-MDM managed legacy PC management for this account.
     * This property is read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @return property legacyPcManangementEnabled
     */
    @Property(name="legacyPcManangementEnabled")
    @JsonIgnore
    public Optional<Boolean> getLegacyPcManangementEnabled() {
        return Optional.ofNullable(legacyPcManangementEnabled);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * legacyPcManangementEnabled} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“The property to enable Non-MDM managed legacy PC management for this account.
     * This property is read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @param legacyPcManangementEnabled
     *            new value of {@code legacyPcManangementEnabled} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code legacyPcManangementEnabled} field changed
     */
    public DeviceManagement withLegacyPcManangementEnabled(Boolean legacyPcManangementEnabled) {
        DeviceManagement _x = _copy();
        _x.changedFields = changedFields.add("legacyPcManangementEnabled");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagement");
        _x.legacyPcManangementEnabled = legacyPcManangementEnabled;
        return _x;
    }

    /**
     * <i>“Maximum number of dep tokens allowed per-tenant.”</i>
     * 
     * @return property maximumDepTokens
     */
    @Property(name="maximumDepTokens")
    @JsonIgnore
    public Optional<Integer> getMaximumDepTokens() {
        return Optional.ofNullable(maximumDepTokens);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code maximumDepTokens}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Maximum number of dep tokens allowed per-tenant.”</i>
     * 
     * @param maximumDepTokens
     *            new value of {@code maximumDepTokens} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code maximumDepTokens} field changed
     */
    public DeviceManagement withMaximumDepTokens(Integer maximumDepTokens) {
        DeviceManagement _x = _copy();
        _x.changedFields = changedFields.add("maximumDepTokens");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagement");
        _x.maximumDepTokens = maximumDepTokens;
        return _x;
    }

    /**
     * <i>“Account level settings.”</i>
     * 
     * @return property settings
     */
    @Property(name="settings")
    @JsonIgnore
    public Optional<DeviceManagementSettings> getSettings() {
        return Optional.ofNullable(settings);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code settings} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Account level settings.”</i>
     * 
     * @param settings
     *            new value of {@code settings} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code settings} field changed
     */
    public DeviceManagement withSettings(DeviceManagementSettings settings) {
        DeviceManagement _x = _copy();
        _x.changedFields = changedFields.add("settings");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagement");
        _x.settings = settings;
        return _x;
    }

    /**
     * <i>“When enabled, users assigned as administrators via Role Assignment Memberships
     * do not require an assigned Intune license. Prior to this, only Intune licensed
     * users were granted permissions with an Intune role unless they were assigned a
     * role via Azure Active Directory. You are limited to 350 unlicensed direct
     * members for each AAD security group in a role assignment, but you can assign
     * multiple AAD security groups to a role if you need to support more than 350
     * unlicensed administrators. Licensed administrators are unaffected, do not have
     * to be direct members, nor does the 350 member limit apply. This property is read
     * -only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @return property unlicensedAdminstratorsEnabled
     */
    @Property(name="unlicensedAdminstratorsEnabled")
    @JsonIgnore
    public Optional<Boolean> getUnlicensedAdminstratorsEnabled() {
        return Optional.ofNullable(unlicensedAdminstratorsEnabled);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * unlicensedAdminstratorsEnabled} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“When enabled, users assigned as administrators via Role Assignment Memberships
     * do not require an assigned Intune license. Prior to this, only Intune licensed
     * users were granted permissions with an Intune role unless they were assigned a
     * role via Azure Active Directory. You are limited to 350 unlicensed direct
     * members for each AAD security group in a role assignment, but you can assign
     * multiple AAD security groups to a role if you need to support more than 350
     * unlicensed administrators. Licensed administrators are unaffected, do not have
     * to be direct members, nor does the 350 member limit apply. This property is read
     * -only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @param unlicensedAdminstratorsEnabled
     *            new value of {@code unlicensedAdminstratorsEnabled} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code unlicensedAdminstratorsEnabled} field changed
     */
    public DeviceManagement withUnlicensedAdminstratorsEnabled(Boolean unlicensedAdminstratorsEnabled) {
        DeviceManagement _x = _copy();
        _x.changedFields = changedFields.add("unlicensedAdminstratorsEnabled");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagement");
        _x.unlicensedAdminstratorsEnabled = unlicensedAdminstratorsEnabled;
        return _x;
    }

    /**
     * <i>“intuneBrand contains data which is used in customizing the appearance of the
     * Company Portal applications as well as the end user web portal.”</i>
     * 
     * @return property intuneBrand
     */
    @Property(name="intuneBrand")
    @JsonIgnore
    public Optional<IntuneBrand> getIntuneBrand() {
        return Optional.ofNullable(intuneBrand);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code intuneBrand}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“intuneBrand contains data which is used in customizing the appearance of the
     * Company Portal applications as well as the end user web portal.”</i>
     * 
     * @param intuneBrand
     *            new value of {@code intuneBrand} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code intuneBrand} field changed
     */
    public DeviceManagement withIntuneBrand(IntuneBrand intuneBrand) {
        DeviceManagement _x = _copy();
        _x.changedFields = changedFields.add("intuneBrand");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagement");
        _x.intuneBrand = intuneBrand;
        return _x;
    }

    /**
     * <i>“The date &amp; time when tenant data moved between scaleunits.”</i>
     * 
     * @return property accountMoveCompletionDateTime
     */
    @Property(name="accountMoveCompletionDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getAccountMoveCompletionDateTime() {
        return Optional.ofNullable(accountMoveCompletionDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * accountMoveCompletionDateTime} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“The date &amp; time when tenant data moved between scaleunits.”</i>
     * 
     * @param accountMoveCompletionDateTime
     *            new value of {@code accountMoveCompletionDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code accountMoveCompletionDateTime} field changed
     */
    public DeviceManagement withAccountMoveCompletionDateTime(OffsetDateTime accountMoveCompletionDateTime) {
        DeviceManagement _x = _copy();
        _x.changedFields = changedFields.add("accountMoveCompletionDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagement");
        _x.accountMoveCompletionDateTime = accountMoveCompletionDateTime;
        return _x;
    }

    /**
     * <i>“Admin consent information.”</i>
     * 
     * @return property adminConsent
     */
    @Property(name="adminConsent")
    @JsonIgnore
    public Optional<AdminConsent> getAdminConsent() {
        return Optional.ofNullable(adminConsent);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code adminConsent}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Admin consent information.”</i>
     * 
     * @param adminConsent
     *            new value of {@code adminConsent} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code adminConsent} field changed
     */
    public DeviceManagement withAdminConsent(AdminConsent adminConsent) {
        DeviceManagement _x = _copy();
        _x.changedFields = changedFields.add("adminConsent");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagement");
        _x.adminConsent = adminConsent;
        return _x;
    }

    /**
     * <i>“Device protection overview.”</i>
     * 
     * @return property deviceProtectionOverview
     */
    @Property(name="deviceProtectionOverview")
    @JsonIgnore
    public Optional<DeviceProtectionOverview> getDeviceProtectionOverview() {
        return Optional.ofNullable(deviceProtectionOverview);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * deviceProtectionOverview} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Device protection overview.”</i>
     * 
     * @param deviceProtectionOverview
     *            new value of {@code deviceProtectionOverview} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceProtectionOverview} field changed
     */
    public DeviceManagement withDeviceProtectionOverview(DeviceProtectionOverview deviceProtectionOverview) {
        DeviceManagement _x = _copy();
        _x.changedFields = changedFields.add("deviceProtectionOverview");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagement");
        _x.deviceProtectionOverview = deviceProtectionOverview;
        return _x;
    }

    /**
     * <i>“Device cleanup rule”</i>
     * 
     * @return property managedDeviceCleanupSettings
     */
    @Property(name="managedDeviceCleanupSettings")
    @JsonIgnore
    public Optional<ManagedDeviceCleanupSettings> getManagedDeviceCleanupSettings() {
        return Optional.ofNullable(managedDeviceCleanupSettings);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * managedDeviceCleanupSettings} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Device cleanup rule”</i>
     * 
     * @param managedDeviceCleanupSettings
     *            new value of {@code managedDeviceCleanupSettings} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code managedDeviceCleanupSettings} field changed
     */
    public DeviceManagement withManagedDeviceCleanupSettings(ManagedDeviceCleanupSettings managedDeviceCleanupSettings) {
        DeviceManagement _x = _copy();
        _x.changedFields = changedFields.add("managedDeviceCleanupSettings");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagement");
        _x.managedDeviceCleanupSettings = managedDeviceCleanupSettings;
        return _x;
    }

    /**
     * <i>“Tenant's Subscription.”</i>
     * 
     * @return property subscriptions
     */
    @Property(name="subscriptions")
    @JsonIgnore
    public Optional<DeviceManagementSubscriptions> getSubscriptions() {
        return Optional.ofNullable(subscriptions);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code subscriptions}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Tenant's Subscription.”</i>
     * 
     * @param subscriptions
     *            new value of {@code subscriptions} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code subscriptions} field changed
     */
    public DeviceManagement withSubscriptions(DeviceManagementSubscriptions subscriptions) {
        DeviceManagement _x = _copy();
        _x.changedFields = changedFields.add("subscriptions");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagement");
        _x.subscriptions = subscriptions;
        return _x;
    }

    /**
     * <i>“Tenant mobile device management subscription state.”</i>
     * 
     * @return property subscriptionState
     */
    @Property(name="subscriptionState")
    @JsonIgnore
    public Optional<DeviceManagementSubscriptionState> getSubscriptionState() {
        return Optional.ofNullable(subscriptionState);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code subscriptionState
     * } field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Tenant mobile device management subscription state.”</i>
     * 
     * @param subscriptionState
     *            new value of {@code subscriptionState} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code subscriptionState} field changed
     */
    public DeviceManagement withSubscriptionState(DeviceManagementSubscriptionState subscriptionState) {
        DeviceManagement _x = _copy();
        _x.changedFields = changedFields.add("subscriptionState");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagement");
        _x.subscriptionState = subscriptionState;
        return _x;
    }

    /**
     * <i>“User experience analytics device settings”</i>
     * 
     * @return property userExperienceAnalyticsSettings
     */
    @Property(name="userExperienceAnalyticsSettings")
    @JsonIgnore
    public Optional<UserExperienceAnalyticsSettings> getUserExperienceAnalyticsSettings() {
        return Optional.ofNullable(userExperienceAnalyticsSettings);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * userExperienceAnalyticsSettings} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“User experience analytics device settings”</i>
     * 
     * @param userExperienceAnalyticsSettings
     *            new value of {@code userExperienceAnalyticsSettings} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code userExperienceAnalyticsSettings} field changed
     */
    public DeviceManagement withUserExperienceAnalyticsSettings(UserExperienceAnalyticsSettings userExperienceAnalyticsSettings) {
        DeviceManagement _x = _copy();
        _x.changedFields = changedFields.add("userExperienceAnalyticsSettings");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagement");
        _x.userExperienceAnalyticsSettings = userExperienceAnalyticsSettings;
        return _x;
    }

    /**
     * <i>“Malware overview for windows devices.”</i>
     * 
     * @return property windowsMalwareOverview
     */
    @Property(name="windowsMalwareOverview")
    @JsonIgnore
    public Optional<WindowsMalwareOverview> getWindowsMalwareOverview() {
        return Optional.ofNullable(windowsMalwareOverview);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * windowsMalwareOverview} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Malware overview for windows devices.”</i>
     * 
     * @param windowsMalwareOverview
     *            new value of {@code windowsMalwareOverview} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code windowsMalwareOverview} field changed
     */
    public DeviceManagement withWindowsMalwareOverview(WindowsMalwareOverview windowsMalwareOverview) {
        DeviceManagement _x = _copy();
        _x.changedFields = changedFields.add("windowsMalwareOverview");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagement");
        _x.windowsMalwareOverview = windowsMalwareOverview;
        return _x;
    }

    public DeviceManagement withUnmappedField(String name, Object value) {
        DeviceManagement _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    /**
     * <i>“Android device owner enrollment profile entities.”</i>
     * 
     * @return navigational property androidDeviceOwnerEnrollmentProfiles
     */
    @NavigationProperty(name="androidDeviceOwnerEnrollmentProfiles")
    @JsonIgnore
    public AndroidDeviceOwnerEnrollmentProfileCollectionRequest getAndroidDeviceOwnerEnrollmentProfiles() {
        return new AndroidDeviceOwnerEnrollmentProfileCollectionRequest(
                        contextPath.addSegment("androidDeviceOwnerEnrollmentProfiles"), Optional.ofNullable(androidDeviceOwnerEnrollmentProfiles));
    }

    @NavigationProperty(name="virtualEndpoint")
    @JsonIgnore
    public VirtualEndpointRequest getVirtualEndpoint() {
        return new VirtualEndpointRequest(contextPath.addSegment("virtualEndpoint"), Optional.ofNullable(virtualEndpoint));
    }

    /**
     * <i>“Android for Work app configuration schema entities.”</i>
     * 
     * @return navigational property androidForWorkAppConfigurationSchemas
     */
    @NavigationProperty(name="androidForWorkAppConfigurationSchemas")
    @JsonIgnore
    public AndroidForWorkAppConfigurationSchemaCollectionRequest getAndroidForWorkAppConfigurationSchemas() {
        return new AndroidForWorkAppConfigurationSchemaCollectionRequest(
                        contextPath.addSegment("androidForWorkAppConfigurationSchemas"), Optional.ofNullable(androidForWorkAppConfigurationSchemas));
    }

    /**
     * <i>“Android for Work enrollment profile entities.”</i>
     * 
     * @return navigational property androidForWorkEnrollmentProfiles
     */
    @NavigationProperty(name="androidForWorkEnrollmentProfiles")
    @JsonIgnore
    public AndroidForWorkEnrollmentProfileCollectionRequest getAndroidForWorkEnrollmentProfiles() {
        return new AndroidForWorkEnrollmentProfileCollectionRequest(
                        contextPath.addSegment("androidForWorkEnrollmentProfiles"), Optional.ofNullable(androidForWorkEnrollmentProfiles));
    }

    /**
     * <i>“The singleton Android for Work settings entity.”</i>
     * 
     * @return navigational property androidForWorkSettings
     */
    @NavigationProperty(name="androidForWorkSettings")
    @JsonIgnore
    public AndroidForWorkSettingsRequest getAndroidForWorkSettings() {
        return new AndroidForWorkSettingsRequest(contextPath.addSegment("androidForWorkSettings"), Optional.ofNullable(androidForWorkSettings));
    }

    /**
     * <i>“The singleton Android managed store account enterprise settings entity.”</i>
     * 
     * @return navigational property androidManagedStoreAccountEnterpriseSettings
     */
    @NavigationProperty(name="androidManagedStoreAccountEnterpriseSettings")
    @JsonIgnore
    public AndroidManagedStoreAccountEnterpriseSettingsRequest getAndroidManagedStoreAccountEnterpriseSettings() {
        return new AndroidManagedStoreAccountEnterpriseSettingsRequest(contextPath.addSegment("androidManagedStoreAccountEnterpriseSettings"), Optional.ofNullable(androidManagedStoreAccountEnterpriseSettings));
    }

    /**
     * <i>“Android Enterprise app configuration schema entities.”</i>
     * 
     * @return navigational property androidManagedStoreAppConfigurationSchemas
     */
    @NavigationProperty(name="androidManagedStoreAppConfigurationSchemas")
    @JsonIgnore
    public AndroidManagedStoreAppConfigurationSchemaCollectionRequest getAndroidManagedStoreAppConfigurationSchemas() {
        return new AndroidManagedStoreAppConfigurationSchemaCollectionRequest(
                        contextPath.addSegment("androidManagedStoreAppConfigurationSchemas"), Optional.ofNullable(androidManagedStoreAppConfigurationSchemas));
    }

    /**
     * <i>“The Audit Events”</i>
     * 
     * @return navigational property auditEvents
     */
    @NavigationProperty(name="auditEvents")
    @JsonIgnore
    public AuditEventCollectionRequest getAuditEvents() {
        return new AuditEventCollectionRequest(
                        contextPath.addSegment("auditEvents"), Optional.ofNullable(auditEvents));
    }

    /**
     * <i>“The list of assignment filters”</i>
     * 
     * @return navigational property assignmentFilters
     */
    @NavigationProperty(name="assignmentFilters")
    @JsonIgnore
    public DeviceAndAppManagementAssignmentFilterCollectionRequest getAssignmentFilters() {
        return new DeviceAndAppManagementAssignmentFilterCollectionRequest(
                        contextPath.addSegment("assignmentFilters"), Optional.ofNullable(assignmentFilters));
    }

    /**
     * <i>“Collection of ChromeOSOnboardingSettings settings associated with account.”</i>
     * 
     * @return navigational property chromeOSOnboardingSettings
     */
    @NavigationProperty(name="chromeOSOnboardingSettings")
    @JsonIgnore
    public ChromeOSOnboardingSettingsCollectionRequest getChromeOSOnboardingSettings() {
        return new ChromeOSOnboardingSettingsCollectionRequest(
                        contextPath.addSegment("chromeOSOnboardingSettings"), Optional.ofNullable(chromeOSOnboardingSettings));
    }

    /**
     * <i>“The terms and conditions associated with device management of the company.”</i>
     * 
     * @return navigational property termsAndConditions
     */
    @NavigationProperty(name="termsAndConditions")
    @JsonIgnore
    public TermsAndConditionsCollectionRequest getTermsAndConditions() {
        return new TermsAndConditionsCollectionRequest(
                        contextPath.addSegment("termsAndConditions"), Optional.ofNullable(termsAndConditions));
    }

    /**
     * <i>“The summary state of ATP onboarding state for this account.”</i>
     * 
     * @return navigational property advancedThreatProtectionOnboardingStateSummary
     */
    @NavigationProperty(name="advancedThreatProtectionOnboardingStateSummary")
    @JsonIgnore
    public AdvancedThreatProtectionOnboardingStateSummaryRequest getAdvancedThreatProtectionOnboardingStateSummary() {
        return new AdvancedThreatProtectionOnboardingStateSummaryRequest(contextPath.addSegment("advancedThreatProtectionOnboardingStateSummary"), Optional.ofNullable(advancedThreatProtectionOnboardingStateSummary));
    }

    /**
     * <i>“The Cart To Class Associations.”</i>
     * 
     * @return navigational property cartToClassAssociations
     */
    @NavigationProperty(name="cartToClassAssociations")
    @JsonIgnore
    public CartToClassAssociationCollectionRequest getCartToClassAssociations() {
        return new CartToClassAssociationCollectionRequest(
                        contextPath.addSegment("cartToClassAssociations"), Optional.ofNullable(cartToClassAssociations));
    }

    /**
     * <i>“The device compliance policies.”</i>
     * 
     * @return navigational property deviceCompliancePolicies
     */
    @NavigationProperty(name="deviceCompliancePolicies")
    @JsonIgnore
    public DeviceCompliancePolicyCollectionRequest getDeviceCompliancePolicies() {
        return new DeviceCompliancePolicyCollectionRequest(
                        contextPath.addSegment("deviceCompliancePolicies"), Optional.ofNullable(deviceCompliancePolicies));
    }

    /**
     * <i>“The device compliance state summary for this account.”</i>
     * 
     * @return navigational property deviceCompliancePolicyDeviceStateSummary
     */
    @NavigationProperty(name="deviceCompliancePolicyDeviceStateSummary")
    @JsonIgnore
    public DeviceCompliancePolicyDeviceStateSummaryRequest getDeviceCompliancePolicyDeviceStateSummary() {
        return new DeviceCompliancePolicyDeviceStateSummaryRequest(contextPath.addSegment("deviceCompliancePolicyDeviceStateSummary"), Optional.ofNullable(deviceCompliancePolicyDeviceStateSummary));
    }

    /**
     * <i>“The summary states of compliance policy settings for this account.”</i>
     * 
     * @return navigational property deviceCompliancePolicySettingStateSummaries
     */
    @NavigationProperty(name="deviceCompliancePolicySettingStateSummaries")
    @JsonIgnore
    public DeviceCompliancePolicySettingStateSummaryCollectionRequest getDeviceCompliancePolicySettingStateSummaries() {
        return new DeviceCompliancePolicySettingStateSummaryCollectionRequest(
                        contextPath.addSegment("deviceCompliancePolicySettingStateSummaries"), Optional.ofNullable(deviceCompliancePolicySettingStateSummaries));
    }

    /**
     * <i>“Summary of policies in conflict state for this account.”</i>
     * 
     * @return navigational property deviceConfigurationConflictSummary
     */
    @NavigationProperty(name="deviceConfigurationConflictSummary")
    @JsonIgnore
    public DeviceConfigurationConflictSummaryCollectionRequest getDeviceConfigurationConflictSummary() {
        return new DeviceConfigurationConflictSummaryCollectionRequest(
                        contextPath.addSegment("deviceConfigurationConflictSummary"), Optional.ofNullable(deviceConfigurationConflictSummary));
    }

    /**
     * <i>“The device configuration device state summary for this account.”</i>
     * 
     * @return navigational property deviceConfigurationDeviceStateSummaries
     */
    @NavigationProperty(name="deviceConfigurationDeviceStateSummaries")
    @JsonIgnore
    public DeviceConfigurationDeviceStateSummaryRequest getDeviceConfigurationDeviceStateSummaries() {
        return new DeviceConfigurationDeviceStateSummaryRequest(contextPath.addSegment("deviceConfigurationDeviceStateSummaries"), Optional.ofNullable(deviceConfigurationDeviceStateSummaries));
    }

    /**
     * <i>“Restricted apps violations for this account.”</i>
     * 
     * @return navigational property deviceConfigurationRestrictedAppsViolations
     */
    @NavigationProperty(name="deviceConfigurationRestrictedAppsViolations")
    @JsonIgnore
    public RestrictedAppsViolationCollectionRequest getDeviceConfigurationRestrictedAppsViolations() {
        return new RestrictedAppsViolationCollectionRequest(
                        contextPath.addSegment("deviceConfigurationRestrictedAppsViolations"), Optional.ofNullable(deviceConfigurationRestrictedAppsViolations));
    }

    /**
     * <i>“The device configurations.”</i>
     * 
     * @return navigational property deviceConfigurations
     */
    @NavigationProperty(name="deviceConfigurations")
    @JsonIgnore
    public DeviceConfigurationCollectionRequest getDeviceConfigurations() {
        return new DeviceConfigurationCollectionRequest(
                        contextPath.addSegment("deviceConfigurations"), Optional.ofNullable(deviceConfigurations));
    }

    /**
     * <i>“Summary of all certificates for all devices.”</i>
     * 
     * @return navigational property deviceConfigurationsAllManagedDeviceCertificateStates
     */
    @NavigationProperty(name="deviceConfigurationsAllManagedDeviceCertificateStates")
    @JsonIgnore
    public ManagedAllDeviceCertificateStateCollectionRequest getDeviceConfigurationsAllManagedDeviceCertificateStates() {
        return new ManagedAllDeviceCertificateStateCollectionRequest(
                        contextPath.addSegment("deviceConfigurationsAllManagedDeviceCertificateStates"), Optional.ofNullable(deviceConfigurationsAllManagedDeviceCertificateStates));
    }

    /**
     * <i>“The device configuration user state summary for this account.”</i>
     * 
     * @return navigational property deviceConfigurationUserStateSummaries
     */
    @NavigationProperty(name="deviceConfigurationUserStateSummaries")
    @JsonIgnore
    public DeviceConfigurationUserStateSummaryRequest getDeviceConfigurationUserStateSummaries() {
        return new DeviceConfigurationUserStateSummaryRequest(contextPath.addSegment("deviceConfigurationUserStateSummaries"), Optional.ofNullable(deviceConfigurationUserStateSummaries));
    }

    /**
     * <i>“The IOS software update installation statuses for this account.”</i>
     * 
     * @return navigational property iosUpdateStatuses
     */
    @NavigationProperty(name="iosUpdateStatuses")
    @JsonIgnore
    public IosUpdateDeviceStatusCollectionRequest getIosUpdateStatuses() {
        return new IosUpdateDeviceStatusCollectionRequest(
                        contextPath.addSegment("iosUpdateStatuses"), Optional.ofNullable(iosUpdateStatuses));
    }

    /**
     * <i>“The MacOS software update account summaries for this account.”</i>
     * 
     * @return navigational property macOSSoftwareUpdateAccountSummaries
     */
    @NavigationProperty(name="macOSSoftwareUpdateAccountSummaries")
    @JsonIgnore
    public MacOSSoftwareUpdateAccountSummaryCollectionRequest getMacOSSoftwareUpdateAccountSummaries() {
        return new MacOSSoftwareUpdateAccountSummaryCollectionRequest(
                        contextPath.addSegment("macOSSoftwareUpdateAccountSummaries"), Optional.ofNullable(macOSSoftwareUpdateAccountSummaries));
    }

    /**
     * <i>“Encryption report for devices in this account”</i>
     * 
     * @return navigational property managedDeviceEncryptionStates
     */
    @NavigationProperty(name="managedDeviceEncryptionStates")
    @JsonIgnore
    public ManagedDeviceEncryptionStateCollectionRequest getManagedDeviceEncryptionStates() {
        return new ManagedDeviceEncryptionStateCollectionRequest(
                        contextPath.addSegment("managedDeviceEncryptionStates"), Optional.ofNullable(managedDeviceEncryptionStates));
    }

    /**
     * <i>“The collection of Ndes connectors for this account.”</i>
     * 
     * @return navigational property ndesConnectors
     */
    @NavigationProperty(name="ndesConnectors")
    @JsonIgnore
    public NdesConnectorCollectionRequest getNdesConnectors() {
        return new NdesConnectorCollectionRequest(
                        contextPath.addSegment("ndesConnectors"), Optional.ofNullable(ndesConnectors));
    }

    /**
     * <i>“The software update status summary.”</i>
     * 
     * @return navigational property softwareUpdateStatusSummary
     */
    @NavigationProperty(name="softwareUpdateStatusSummary")
    @JsonIgnore
    public SoftwareUpdateStatusSummaryRequest getSoftwareUpdateStatusSummary() {
        return new SoftwareUpdateStatusSummaryRequest(contextPath.addSegment("softwareUpdateStatusSummary"), RequestHelper.getValue(unmappedFields, "softwareUpdateStatusSummary"));
    }

    /**
     * <i>“List of all compliance categories”</i>
     * 
     * @return navigational property complianceCategories
     */
    @NavigationProperty(name="complianceCategories")
    @JsonIgnore
    public DeviceManagementConfigurationCategoryCollectionRequest getComplianceCategories() {
        return new DeviceManagementConfigurationCategoryCollectionRequest(
                        contextPath.addSegment("complianceCategories"), Optional.ofNullable(complianceCategories));
    }

    /**
     * <i>“List of all compliance policies”</i>
     * 
     * @return navigational property compliancePolicies
     */
    @NavigationProperty(name="compliancePolicies")
    @JsonIgnore
    public DeviceManagementCompliancePolicyCollectionRequest getCompliancePolicies() {
        return new DeviceManagementCompliancePolicyCollectionRequest(
                        contextPath.addSegment("compliancePolicies"), Optional.ofNullable(compliancePolicies));
    }

    /**
     * <i>“List of all ComplianceSettings”</i>
     * 
     * @return navigational property complianceSettings
     */
    @NavigationProperty(name="complianceSettings")
    @JsonIgnore
    public DeviceManagementConfigurationSettingDefinitionCollectionRequest getComplianceSettings() {
        return new DeviceManagementConfigurationSettingDefinitionCollectionRequest(
                        contextPath.addSegment("complianceSettings"), Optional.ofNullable(complianceSettings));
    }

    /**
     * <i>“List of all Configuration Categories”</i>
     * 
     * @return navigational property configurationCategories
     */
    @NavigationProperty(name="configurationCategories")
    @JsonIgnore
    public DeviceManagementConfigurationCategoryCollectionRequest getConfigurationCategories() {
        return new DeviceManagementConfigurationCategoryCollectionRequest(
                        contextPath.addSegment("configurationCategories"), Optional.ofNullable(configurationCategories));
    }

    /**
     * <i>“List of all Configuration policies”</i>
     * 
     * @return navigational property configurationPolicies
     */
    @NavigationProperty(name="configurationPolicies")
    @JsonIgnore
    public DeviceManagementConfigurationPolicyCollectionRequest getConfigurationPolicies() {
        return new DeviceManagementConfigurationPolicyCollectionRequest(
                        contextPath.addSegment("configurationPolicies"), Optional.ofNullable(configurationPolicies));
    }

    /**
     * <i>“List of all templates”</i>
     * 
     * @return navigational property configurationPolicyTemplates
     */
    @NavigationProperty(name="configurationPolicyTemplates")
    @JsonIgnore
    public DeviceManagementConfigurationPolicyTemplateCollectionRequest getConfigurationPolicyTemplates() {
        return new DeviceManagementConfigurationPolicyTemplateCollectionRequest(
                        contextPath.addSegment("configurationPolicyTemplates"), Optional.ofNullable(configurationPolicyTemplates));
    }

    /**
     * <i>“List of all ConfigurationSettings”</i>
     * 
     * @return navigational property configurationSettings
     */
    @NavigationProperty(name="configurationSettings")
    @JsonIgnore
    public DeviceManagementConfigurationSettingDefinitionCollectionRequest getConfigurationSettings() {
        return new DeviceManagementConfigurationSettingDefinitionCollectionRequest(
                        contextPath.addSegment("configurationSettings"), Optional.ofNullable(configurationSettings));
    }

    /**
     * <i>“List of all reusable settings that can be referred in a policy”</i>
     * 
     * @return navigational property reusablePolicySettings
     */
    @NavigationProperty(name="reusablePolicySettings")
    @JsonIgnore
    public DeviceManagementReusablePolicySettingCollectionRequest getReusablePolicySettings() {
        return new DeviceManagementReusablePolicySettingCollectionRequest(
                        contextPath.addSegment("reusablePolicySettings"), Optional.ofNullable(reusablePolicySettings));
    }

    /**
     * <i>“List of all reusable settings”</i>
     * 
     * @return navigational property reusableSettings
     */
    @NavigationProperty(name="reusableSettings")
    @JsonIgnore
    public DeviceManagementConfigurationSettingDefinitionCollectionRequest getReusableSettings() {
        return new DeviceManagementConfigurationSettingDefinitionCollectionRequest(
                        contextPath.addSegment("reusableSettings"), Optional.ofNullable(reusableSettings));
    }

    /**
     * <i>“List of all TemplateSettings”</i>
     * 
     * @return navigational property templateSettings
     */
    @NavigationProperty(name="templateSettings")
    @JsonIgnore
    public DeviceManagementConfigurationSettingTemplateCollectionRequest getTemplateSettings() {
        return new DeviceManagementConfigurationSettingTemplateCollectionRequest(
                        contextPath.addSegment("templateSettings"), Optional.ofNullable(templateSettings));
    }

    /**
     * <i>“The list of Compliance Management Partners configured by the tenant.”</i>
     * 
     * @return navigational property complianceManagementPartners
     */
    @NavigationProperty(name="complianceManagementPartners")
    @JsonIgnore
    public ComplianceManagementPartnerCollectionRequest getComplianceManagementPartners() {
        return new ComplianceManagementPartnerCollectionRequest(
                        contextPath.addSegment("complianceManagementPartners"), Optional.ofNullable(complianceManagementPartners));
    }

    /**
     * <i>“The Exchange on premises conditional access settings. On premises conditional
     * access will require devices to be both enrolled and compliant for mail access”</i>
     * 
     * @return navigational property conditionalAccessSettings
     */
    @NavigationProperty(name="conditionalAccessSettings")
    @JsonIgnore
    public OnPremisesConditionalAccessSettingsRequest getConditionalAccessSettings() {
        return new OnPremisesConditionalAccessSettingsRequest(contextPath.addSegment("conditionalAccessSettings"), Optional.ofNullable(conditionalAccessSettings));
    }

    /**
     * <i>“The list of device categories with the tenant.”</i>
     * 
     * @return navigational property deviceCategories
     */
    @NavigationProperty(name="deviceCategories")
    @JsonIgnore
    public DeviceCategoryCollectionRequest getDeviceCategories() {
        return new DeviceCategoryCollectionRequest(
                        contextPath.addSegment("deviceCategories"), Optional.ofNullable(deviceCategories));
    }

    /**
     * <i>“The list of device enrollment configurations”</i>
     * 
     * @return navigational property deviceEnrollmentConfigurations
     */
    @NavigationProperty(name="deviceEnrollmentConfigurations")
    @JsonIgnore
    public DeviceEnrollmentConfigurationCollectionRequest getDeviceEnrollmentConfigurations() {
        return new DeviceEnrollmentConfigurationCollectionRequest(
                        contextPath.addSegment("deviceEnrollmentConfigurations"), Optional.ofNullable(deviceEnrollmentConfigurations));
    }

    /**
     * <i>“The list of Device Management Partners configured by the tenant.”</i>
     * 
     * @return navigational property deviceManagementPartners
     */
    @NavigationProperty(name="deviceManagementPartners")
    @JsonIgnore
    public DeviceManagementPartnerCollectionRequest getDeviceManagementPartners() {
        return new DeviceManagementPartnerCollectionRequest(
                        contextPath.addSegment("deviceManagementPartners"), Optional.ofNullable(deviceManagementPartners));
    }

    /**
     * <i>“The list of Exchange Connectors configured by the tenant.”</i>
     * 
     * @return navigational property exchangeConnectors
     */
    @NavigationProperty(name="exchangeConnectors")
    @JsonIgnore
    public DeviceManagementExchangeConnectorCollectionRequest getExchangeConnectors() {
        return new DeviceManagementExchangeConnectorCollectionRequest(
                        contextPath.addSegment("exchangeConnectors"), Optional.ofNullable(exchangeConnectors));
    }

    /**
     * <i>“The list of Exchange On Premisis policies configured by the tenant.”</i>
     * 
     * @return navigational property exchangeOnPremisesPolicies
     */
    @NavigationProperty(name="exchangeOnPremisesPolicies")
    @JsonIgnore
    public DeviceManagementExchangeOnPremisesPolicyCollectionRequest getExchangeOnPremisesPolicies() {
        return new DeviceManagementExchangeOnPremisesPolicyCollectionRequest(
                        contextPath.addSegment("exchangeOnPremisesPolicies"), Optional.ofNullable(exchangeOnPremisesPolicies));
    }

    /**
     * <i>“The policy which controls mobile device access to Exchange On Premises”</i>
     * 
     * @return navigational property exchangeOnPremisesPolicy
     */
    @NavigationProperty(name="exchangeOnPremisesPolicy")
    @JsonIgnore
    public DeviceManagementExchangeOnPremisesPolicyRequest getExchangeOnPremisesPolicy() {
        return new DeviceManagementExchangeOnPremisesPolicyRequest(contextPath.addSegment("exchangeOnPremisesPolicy"), Optional.ofNullable(exchangeOnPremisesPolicy));
    }

    /**
     * <i>“The list of Mobile threat Defense connectors configured by the tenant.”</i>
     * 
     * @return navigational property mobileThreatDefenseConnectors
     */
    @NavigationProperty(name="mobileThreatDefenseConnectors")
    @JsonIgnore
    public MobileThreatDefenseConnectorCollectionRequest getMobileThreatDefenseConnectors() {
        return new MobileThreatDefenseConnectorCollectionRequest(
                        contextPath.addSegment("mobileThreatDefenseConnectors"), Optional.ofNullable(mobileThreatDefenseConnectors));
    }

    /**
     * <i>“The available categories”</i>
     * 
     * @return navigational property categories
     */
    @NavigationProperty(name="categories")
    @JsonIgnore
    public DeviceManagementSettingCategoryCollectionRequest getCategories() {
        return new DeviceManagementSettingCategoryCollectionRequest(
                        contextPath.addSegment("categories"), Optional.ofNullable(categories));
    }

    /**
     * <i>“The device management intents”</i>
     * 
     * @return navigational property intents
     */
    @NavigationProperty(name="intents")
    @JsonIgnore
    public DeviceManagementIntentCollectionRequest getIntents() {
        return new DeviceManagementIntentCollectionRequest(
                        contextPath.addSegment("intents"), Optional.ofNullable(intents));
    }

    /**
     * <i>“The device management intent setting definitions”</i>
     * 
     * @return navigational property settingDefinitions
     */
    @NavigationProperty(name="settingDefinitions")
    @JsonIgnore
    public DeviceManagementSettingDefinitionCollectionRequest getSettingDefinitions() {
        return new DeviceManagementSettingDefinitionCollectionRequest(
                        contextPath.addSegment("settingDefinitions"), Optional.ofNullable(settingDefinitions));
    }

    /**
     * <i>“The available templates”</i>
     * 
     * @return navigational property templates
     */
    @NavigationProperty(name="templates")
    @JsonIgnore
    public DeviceManagementTemplateCollectionRequest getTemplates() {
        return new DeviceManagementTemplateCollectionRequest(
                        contextPath.addSegment("templates"), Optional.ofNullable(templates));
    }

    /**
     * <i>“Apple push notification certificate.”</i>
     * 
     * @return navigational property applePushNotificationCertificate
     */
    @NavigationProperty(name="applePushNotificationCertificate")
    @JsonIgnore
    public ApplePushNotificationCertificateRequest getApplePushNotificationCertificate() {
        return new ApplePushNotificationCertificateRequest(contextPath.addSegment("applePushNotificationCertificate"), Optional.ofNullable(applePushNotificationCertificate));
    }

    /**
     * <i>“The list of CloudPC Connectivity Issue.”</i>
     * 
     * @return navigational property cloudPCConnectivityIssues
     */
    @NavigationProperty(name="cloudPCConnectivityIssues")
    @JsonIgnore
    public CloudPCConnectivityIssueCollectionRequest getCloudPCConnectivityIssues() {
        return new CloudPCConnectivityIssueCollectionRequest(
                        contextPath.addSegment("cloudPCConnectivityIssues"), Optional.ofNullable(cloudPCConnectivityIssues));
    }

    /**
     * <i>“The list of co-managed devices report”</i>
     * 
     * @return navigational property comanagedDevices
     */
    @NavigationProperty(name="comanagedDevices")
    @JsonIgnore
    public ManagedDeviceCollectionRequest getComanagedDevices() {
        return new ManagedDeviceCollectionRequest(
                        contextPath.addSegment("comanagedDevices"), Optional.ofNullable(comanagedDevices));
    }

    /**
     * <i>“The list of co-management eligible devices report”</i>
     * 
     * @return navigational property comanagementEligibleDevices
     */
    @NavigationProperty(name="comanagementEligibleDevices")
    @JsonIgnore
    public ComanagementEligibleDeviceCollectionRequest getComanagementEligibleDevices() {
        return new ComanagementEligibleDeviceCollectionRequest(
                        contextPath.addSegment("comanagementEligibleDevices"), Optional.ofNullable(comanagementEligibleDevices));
    }

    /**
     * <i>“Data sharing consents.”</i>
     * 
     * @return navigational property dataSharingConsents
     */
    @NavigationProperty(name="dataSharingConsents")
    @JsonIgnore
    public DataSharingConsentCollectionRequest getDataSharingConsents() {
        return new DataSharingConsentCollectionRequest(
                        contextPath.addSegment("dataSharingConsents"), Optional.ofNullable(dataSharingConsents));
    }

    /**
     * <i>“The list of detected apps associated with a device.”</i>
     * 
     * @return navigational property detectedApps
     */
    @NavigationProperty(name="detectedApps")
    @JsonIgnore
    public DetectedAppCollectionRequest getDetectedApps() {
        return new DetectedAppCollectionRequest(
                        contextPath.addSegment("detectedApps"), Optional.ofNullable(detectedApps));
    }

    /**
     * <i>“The list of device compliance scripts associated with the tenant.”</i>
     * 
     * @return navigational property deviceComplianceScripts
     */
    @NavigationProperty(name="deviceComplianceScripts")
    @JsonIgnore
    public DeviceComplianceScriptCollectionRequest getDeviceComplianceScripts() {
        return new DeviceComplianceScriptCollectionRequest(
                        contextPath.addSegment("deviceComplianceScripts"), Optional.ofNullable(deviceComplianceScripts));
    }

    /**
     * <i>“The list of device custom attribute shell scripts associated with the tenant.”</i>
     * 
     * @return navigational property deviceCustomAttributeShellScripts
     */
    @NavigationProperty(name="deviceCustomAttributeShellScripts")
    @JsonIgnore
    public DeviceCustomAttributeShellScriptCollectionRequest getDeviceCustomAttributeShellScripts() {
        return new DeviceCustomAttributeShellScriptCollectionRequest(
                        contextPath.addSegment("deviceCustomAttributeShellScripts"), Optional.ofNullable(deviceCustomAttributeShellScripts));
    }

    /**
     * <i>“The list of device health scripts associated with the tenant.”</i>
     * 
     * @return navigational property deviceHealthScripts
     */
    @NavigationProperty(name="deviceHealthScripts")
    @JsonIgnore
    public DeviceHealthScriptCollectionRequest getDeviceHealthScripts() {
        return new DeviceHealthScriptCollectionRequest(
                        contextPath.addSegment("deviceHealthScripts"), Optional.ofNullable(deviceHealthScripts));
    }

    /**
     * <i>“The list of device management scripts associated with the tenant.”</i>
     * 
     * @return navigational property deviceManagementScripts
     */
    @NavigationProperty(name="deviceManagementScripts")
    @JsonIgnore
    public DeviceManagementScriptCollectionRequest getDeviceManagementScripts() {
        return new DeviceManagementScriptCollectionRequest(
                        contextPath.addSegment("deviceManagementScripts"), Optional.ofNullable(deviceManagementScripts));
    }

    /**
     * <i>“The list of device shell scripts associated with the tenant.”</i>
     * 
     * @return navigational property deviceShellScripts
     */
    @NavigationProperty(name="deviceShellScripts")
    @JsonIgnore
    public DeviceShellScriptCollectionRequest getDeviceShellScripts() {
        return new DeviceShellScriptCollectionRequest(
                        contextPath.addSegment("deviceShellScripts"), Optional.ofNullable(deviceShellScripts));
    }

    /**
     * <i>“Device overview”</i>
     * 
     * @return navigational property managedDeviceOverview
     */
    @NavigationProperty(name="managedDeviceOverview")
    @JsonIgnore
    public ManagedDeviceOverviewRequest getManagedDeviceOverview() {
        return new ManagedDeviceOverviewRequest(contextPath.addSegment("managedDeviceOverview"), RequestHelper.getValue(unmappedFields, "managedDeviceOverview"));
    }

    /**
     * <i>“The list of managed devices.”</i>
     * 
     * @return navigational property managedDevices
     */
    @NavigationProperty(name="managedDevices")
    @JsonIgnore
    public ManagedDeviceCollectionRequest getManagedDevices() {
        return new ManagedDeviceCollectionRequest(
                        contextPath.addSegment("managedDevices"), Optional.ofNullable(managedDevices));
    }

    /**
     * <i>“The collection property of MobileAppTroubleshootingEvent.”</i>
     * 
     * @return navigational property mobileAppTroubleshootingEvents
     */
    @NavigationProperty(name="mobileAppTroubleshootingEvents")
    @JsonIgnore
    public MobileAppTroubleshootingEventCollectionRequest getMobileAppTroubleshootingEvents() {
        return new MobileAppTroubleshootingEventCollectionRequest(
                        contextPath.addSegment("mobileAppTroubleshootingEvents"), Optional.ofNullable(mobileAppTroubleshootingEvents));
    }

    /**
     * <i>“List of OEM Warranty Statuses”</i>
     * 
     * @return navigational property oemWarrantyInformationOnboarding
     */
    @NavigationProperty(name="oemWarrantyInformationOnboarding")
    @JsonIgnore
    public OemWarrantyInformationOnboardingCollectionRequest getOemWarrantyInformationOnboarding() {
        return new OemWarrantyInformationOnboardingCollectionRequest(
                        contextPath.addSegment("oemWarrantyInformationOnboarding"), Optional.ofNullable(oemWarrantyInformationOnboarding));
    }

    /**
     * <i>“The list of device remote action audits with the tenant.”</i>
     * 
     * @return navigational property remoteActionAudits
     */
    @NavigationProperty(name="remoteActionAudits")
    @JsonIgnore
    public RemoteActionAuditCollectionRequest getRemoteActionAudits() {
        return new RemoteActionAuditCollectionRequest(
                        contextPath.addSegment("remoteActionAudits"), Optional.ofNullable(remoteActionAudits));
    }

    /**
     * <i>“User experience analytics appHealth Application Performance”</i>
     * 
     * @return navigational property userExperienceAnalyticsAppHealthApplicationPerformance
     */
    @NavigationProperty(name="userExperienceAnalyticsAppHealthApplicationPerformance")
    @JsonIgnore
    public UserExperienceAnalyticsAppHealthApplicationPerformanceCollectionRequest getUserExperienceAnalyticsAppHealthApplicationPerformance() {
        return new UserExperienceAnalyticsAppHealthApplicationPerformanceCollectionRequest(
                        contextPath.addSegment("userExperienceAnalyticsAppHealthApplicationPerformance"), Optional.ofNullable(userExperienceAnalyticsAppHealthApplicationPerformance));
    }

    /**
     * <i>“User experience analytics appHealth Application Performance by App Version”</i>
     * 
     * @return navigational property userExperienceAnalyticsAppHealthApplicationPerformanceByAppVersion
     */
    @NavigationProperty(name="userExperienceAnalyticsAppHealthApplicationPerformanceByAppVersion")
    @JsonIgnore
    public UserExperienceAnalyticsAppHealthAppPerformanceByAppVersionCollectionRequest getUserExperienceAnalyticsAppHealthApplicationPerformanceByAppVersion() {
        return new UserExperienceAnalyticsAppHealthAppPerformanceByAppVersionCollectionRequest(
                        contextPath.addSegment("userExperienceAnalyticsAppHealthApplicationPerformanceByAppVersion"), Optional.ofNullable(userExperienceAnalyticsAppHealthApplicationPerformanceByAppVersion));
    }

    /**
     * <i>“User experience analytics appHealth Application Performance by App Version
     * details”</i>
     * 
     * @return navigational property userExperienceAnalyticsAppHealthApplicationPerformanceByAppVersionDetails
     */
    @NavigationProperty(name="userExperienceAnalyticsAppHealthApplicationPerformanceByAppVersionDetails")
    @JsonIgnore
    public UserExperienceAnalyticsAppHealthAppPerformanceByAppVersionDetailsCollectionRequest getUserExperienceAnalyticsAppHealthApplicationPerformanceByAppVersionDetails() {
        return new UserExperienceAnalyticsAppHealthAppPerformanceByAppVersionDetailsCollectionRequest(
                        contextPath.addSegment("userExperienceAnalyticsAppHealthApplicationPerformanceByAppVersionDetails"), Optional.ofNullable(userExperienceAnalyticsAppHealthApplicationPerformanceByAppVersionDetails));
    }

    /**
     * <i>“User experience analytics appHealth Application Performance by App Version
     * Device Id”</i>
     * 
     * @return navigational property userExperienceAnalyticsAppHealthApplicationPerformanceByAppVersionDeviceId
     */
    @NavigationProperty(name="userExperienceAnalyticsAppHealthApplicationPerformanceByAppVersionDeviceId")
    @JsonIgnore
    public UserExperienceAnalyticsAppHealthAppPerformanceByAppVersionDeviceIdCollectionRequest getUserExperienceAnalyticsAppHealthApplicationPerformanceByAppVersionDeviceId() {
        return new UserExperienceAnalyticsAppHealthAppPerformanceByAppVersionDeviceIdCollectionRequest(
                        contextPath.addSegment("userExperienceAnalyticsAppHealthApplicationPerformanceByAppVersionDeviceId"), Optional.ofNullable(userExperienceAnalyticsAppHealthApplicationPerformanceByAppVersionDeviceId));
    }

    /**
     * <i>“User experience analytics appHealth Application Performance by OS Version”</i>
     * 
     * @return navigational property userExperienceAnalyticsAppHealthApplicationPerformanceByOSVersion
     */
    @NavigationProperty(name="userExperienceAnalyticsAppHealthApplicationPerformanceByOSVersion")
    @JsonIgnore
    public UserExperienceAnalyticsAppHealthAppPerformanceByOSVersionCollectionRequest getUserExperienceAnalyticsAppHealthApplicationPerformanceByOSVersion() {
        return new UserExperienceAnalyticsAppHealthAppPerformanceByOSVersionCollectionRequest(
                        contextPath.addSegment("userExperienceAnalyticsAppHealthApplicationPerformanceByOSVersion"), Optional.ofNullable(userExperienceAnalyticsAppHealthApplicationPerformanceByOSVersion));
    }

    /**
     * <i>“User experience analytics appHealth Model Performance”</i>
     * 
     * @return navigational property userExperienceAnalyticsAppHealthDeviceModelPerformance
     */
    @NavigationProperty(name="userExperienceAnalyticsAppHealthDeviceModelPerformance")
    @JsonIgnore
    public UserExperienceAnalyticsAppHealthDeviceModelPerformanceCollectionRequest getUserExperienceAnalyticsAppHealthDeviceModelPerformance() {
        return new UserExperienceAnalyticsAppHealthDeviceModelPerformanceCollectionRequest(
                        contextPath.addSegment("userExperienceAnalyticsAppHealthDeviceModelPerformance"), Optional.ofNullable(userExperienceAnalyticsAppHealthDeviceModelPerformance));
    }

    /**
     * <i>“User experience analytics appHealth Device Performance”</i>
     * 
     * @return navigational property userExperienceAnalyticsAppHealthDevicePerformance
     */
    @NavigationProperty(name="userExperienceAnalyticsAppHealthDevicePerformance")
    @JsonIgnore
    public UserExperienceAnalyticsAppHealthDevicePerformanceCollectionRequest getUserExperienceAnalyticsAppHealthDevicePerformance() {
        return new UserExperienceAnalyticsAppHealthDevicePerformanceCollectionRequest(
                        contextPath.addSegment("userExperienceAnalyticsAppHealthDevicePerformance"), Optional.ofNullable(userExperienceAnalyticsAppHealthDevicePerformance));
    }

    /**
     * <i>“User experience analytics device performance details”</i>
     * 
     * @return navigational property userExperienceAnalyticsAppHealthDevicePerformanceDetails
     */
    @NavigationProperty(name="userExperienceAnalyticsAppHealthDevicePerformanceDetails")
    @JsonIgnore
    public UserExperienceAnalyticsAppHealthDevicePerformanceDetailsCollectionRequest getUserExperienceAnalyticsAppHealthDevicePerformanceDetails() {
        return new UserExperienceAnalyticsAppHealthDevicePerformanceDetailsCollectionRequest(
                        contextPath.addSegment("userExperienceAnalyticsAppHealthDevicePerformanceDetails"), Optional.ofNullable(userExperienceAnalyticsAppHealthDevicePerformanceDetails));
    }

    /**
     * <i>“User experience analytics appHealth OS version Performance”</i>
     * 
     * @return navigational property userExperienceAnalyticsAppHealthOSVersionPerformance
     */
    @NavigationProperty(name="userExperienceAnalyticsAppHealthOSVersionPerformance")
    @JsonIgnore
    public UserExperienceAnalyticsAppHealthOSVersionPerformanceCollectionRequest getUserExperienceAnalyticsAppHealthOSVersionPerformance() {
        return new UserExperienceAnalyticsAppHealthOSVersionPerformanceCollectionRequest(
                        contextPath.addSegment("userExperienceAnalyticsAppHealthOSVersionPerformance"), Optional.ofNullable(userExperienceAnalyticsAppHealthOSVersionPerformance));
    }

    /**
     * <i>“User experience analytics appHealth overview”</i>
     * 
     * @return navigational property userExperienceAnalyticsAppHealthOverview
     */
    @NavigationProperty(name="userExperienceAnalyticsAppHealthOverview")
    @JsonIgnore
    public UserExperienceAnalyticsCategoryRequest getUserExperienceAnalyticsAppHealthOverview() {
        return new UserExperienceAnalyticsCategoryRequest(contextPath.addSegment("userExperienceAnalyticsAppHealthOverview"), Optional.ofNullable(userExperienceAnalyticsAppHealthOverview));
    }

    /**
     * <i>“User experience analytics baselines”</i>
     * 
     * @return navigational property userExperienceAnalyticsBaselines
     */
    @NavigationProperty(name="userExperienceAnalyticsBaselines")
    @JsonIgnore
    public UserExperienceAnalyticsBaselineCollectionRequest getUserExperienceAnalyticsBaselines() {
        return new UserExperienceAnalyticsBaselineCollectionRequest(
                        contextPath.addSegment("userExperienceAnalyticsBaselines"), Optional.ofNullable(userExperienceAnalyticsBaselines));
    }

    /**
     * <i>“User Experience Analytics Battery Health App Impact”</i>
     * 
     * @return navigational property userExperienceAnalyticsBatteryHealthAppImpact
     */
    @NavigationProperty(name="userExperienceAnalyticsBatteryHealthAppImpact")
    @JsonIgnore
    public UserExperienceAnalyticsBatteryHealthAppImpactCollectionRequest getUserExperienceAnalyticsBatteryHealthAppImpact() {
        return new UserExperienceAnalyticsBatteryHealthAppImpactCollectionRequest(
                        contextPath.addSegment("userExperienceAnalyticsBatteryHealthAppImpact"), Optional.ofNullable(userExperienceAnalyticsBatteryHealthAppImpact));
    }

    /**
     * <i>“User Experience Analytics Battery Health Capacity Details”</i>
     * 
     * @return navigational property userExperienceAnalyticsBatteryHealthCapacityDetails
     */
    @NavigationProperty(name="userExperienceAnalyticsBatteryHealthCapacityDetails")
    @JsonIgnore
    public UserExperienceAnalyticsBatteryHealthCapacityDetailsRequest getUserExperienceAnalyticsBatteryHealthCapacityDetails() {
        return new UserExperienceAnalyticsBatteryHealthCapacityDetailsRequest(contextPath.addSegment("userExperienceAnalyticsBatteryHealthCapacityDetails"), Optional.ofNullable(userExperienceAnalyticsBatteryHealthCapacityDetails));
    }

    /**
     * <i>“User Experience Analytics Battery Health Device App Impact”</i>
     * 
     * @return navigational property userExperienceAnalyticsBatteryHealthDeviceAppImpact
     */
    @NavigationProperty(name="userExperienceAnalyticsBatteryHealthDeviceAppImpact")
    @JsonIgnore
    public UserExperienceAnalyticsBatteryHealthDeviceAppImpactCollectionRequest getUserExperienceAnalyticsBatteryHealthDeviceAppImpact() {
        return new UserExperienceAnalyticsBatteryHealthDeviceAppImpactCollectionRequest(
                        contextPath.addSegment("userExperienceAnalyticsBatteryHealthDeviceAppImpact"), Optional.ofNullable(userExperienceAnalyticsBatteryHealthDeviceAppImpact));
    }

    /**
     * <i>“User Experience Analytics Battery Health Device Performance”</i>
     * 
     * @return navigational property userExperienceAnalyticsBatteryHealthDevicePerformance
     */
    @NavigationProperty(name="userExperienceAnalyticsBatteryHealthDevicePerformance")
    @JsonIgnore
    public UserExperienceAnalyticsBatteryHealthDevicePerformanceCollectionRequest getUserExperienceAnalyticsBatteryHealthDevicePerformance() {
        return new UserExperienceAnalyticsBatteryHealthDevicePerformanceCollectionRequest(
                        contextPath.addSegment("userExperienceAnalyticsBatteryHealthDevicePerformance"), Optional.ofNullable(userExperienceAnalyticsBatteryHealthDevicePerformance));
    }

    /**
     * <i>“User Experience Analytics Battery Health Device Runtime History”</i>
     * 
     * @return navigational property userExperienceAnalyticsBatteryHealthDeviceRuntimeHistory
     */
    @NavigationProperty(name="userExperienceAnalyticsBatteryHealthDeviceRuntimeHistory")
    @JsonIgnore
    public UserExperienceAnalyticsBatteryHealthDeviceRuntimeHistoryCollectionRequest getUserExperienceAnalyticsBatteryHealthDeviceRuntimeHistory() {
        return new UserExperienceAnalyticsBatteryHealthDeviceRuntimeHistoryCollectionRequest(
                        contextPath.addSegment("userExperienceAnalyticsBatteryHealthDeviceRuntimeHistory"), Optional.ofNullable(userExperienceAnalyticsBatteryHealthDeviceRuntimeHistory));
    }

    /**
     * <i>“User Experience Analytics Battery Health Model Performance”</i>
     * 
     * @return navigational property userExperienceAnalyticsBatteryHealthModelPerformance
     */
    @NavigationProperty(name="userExperienceAnalyticsBatteryHealthModelPerformance")
    @JsonIgnore
    public UserExperienceAnalyticsBatteryHealthModelPerformanceCollectionRequest getUserExperienceAnalyticsBatteryHealthModelPerformance() {
        return new UserExperienceAnalyticsBatteryHealthModelPerformanceCollectionRequest(
                        contextPath.addSegment("userExperienceAnalyticsBatteryHealthModelPerformance"), Optional.ofNullable(userExperienceAnalyticsBatteryHealthModelPerformance));
    }

    /**
     * <i>“User Experience Analytics Battery Health Os Performance”</i>
     * 
     * @return navigational property userExperienceAnalyticsBatteryHealthOsPerformance
     */
    @NavigationProperty(name="userExperienceAnalyticsBatteryHealthOsPerformance")
    @JsonIgnore
    public UserExperienceAnalyticsBatteryHealthOsPerformanceCollectionRequest getUserExperienceAnalyticsBatteryHealthOsPerformance() {
        return new UserExperienceAnalyticsBatteryHealthOsPerformanceCollectionRequest(
                        contextPath.addSegment("userExperienceAnalyticsBatteryHealthOsPerformance"), Optional.ofNullable(userExperienceAnalyticsBatteryHealthOsPerformance));
    }

    /**
     * <i>“User Experience Analytics Battery Health Runtime Details”</i>
     * 
     * @return navigational property userExperienceAnalyticsBatteryHealthRuntimeDetails
     */
    @NavigationProperty(name="userExperienceAnalyticsBatteryHealthRuntimeDetails")
    @JsonIgnore
    public UserExperienceAnalyticsBatteryHealthRuntimeDetailsRequest getUserExperienceAnalyticsBatteryHealthRuntimeDetails() {
        return new UserExperienceAnalyticsBatteryHealthRuntimeDetailsRequest(contextPath.addSegment("userExperienceAnalyticsBatteryHealthRuntimeDetails"), Optional.ofNullable(userExperienceAnalyticsBatteryHealthRuntimeDetails));
    }

    /**
     * <i>“User experience analytics categories”</i>
     * 
     * @return navigational property userExperienceAnalyticsCategories
     */
    @NavigationProperty(name="userExperienceAnalyticsCategories")
    @JsonIgnore
    public UserExperienceAnalyticsCategoryCollectionRequest getUserExperienceAnalyticsCategories() {
        return new UserExperienceAnalyticsCategoryCollectionRequest(
                        contextPath.addSegment("userExperienceAnalyticsCategories"), Optional.ofNullable(userExperienceAnalyticsCategories));
    }

    /**
     * <i>“User experience analytics device metric history”</i>
     * 
     * @return navigational property userExperienceAnalyticsDeviceMetricHistory
     */
    @NavigationProperty(name="userExperienceAnalyticsDeviceMetricHistory")
    @JsonIgnore
    public UserExperienceAnalyticsMetricHistoryCollectionRequest getUserExperienceAnalyticsDeviceMetricHistory() {
        return new UserExperienceAnalyticsMetricHistoryCollectionRequest(
                        contextPath.addSegment("userExperienceAnalyticsDeviceMetricHistory"), Optional.ofNullable(userExperienceAnalyticsDeviceMetricHistory));
    }

    /**
     * <i>“User experience analytics device performance”</i>
     * 
     * @return navigational property userExperienceAnalyticsDevicePerformance
     */
    @NavigationProperty(name="userExperienceAnalyticsDevicePerformance")
    @JsonIgnore
    public UserExperienceAnalyticsDevicePerformanceCollectionRequest getUserExperienceAnalyticsDevicePerformance() {
        return new UserExperienceAnalyticsDevicePerformanceCollectionRequest(
                        contextPath.addSegment("userExperienceAnalyticsDevicePerformance"), Optional.ofNullable(userExperienceAnalyticsDevicePerformance));
    }

    /**
     * <i>“User experience analytics device scores”</i>
     * 
     * @return navigational property userExperienceAnalyticsDeviceScores
     */
    @NavigationProperty(name="userExperienceAnalyticsDeviceScores")
    @JsonIgnore
    public UserExperienceAnalyticsDeviceScoresCollectionRequest getUserExperienceAnalyticsDeviceScores() {
        return new UserExperienceAnalyticsDeviceScoresCollectionRequest(
                        contextPath.addSegment("userExperienceAnalyticsDeviceScores"), Optional.ofNullable(userExperienceAnalyticsDeviceScores));
    }

    /**
     * <i>“User experience analytics device Startup History”</i>
     * 
     * @return navigational property userExperienceAnalyticsDeviceStartupHistory
     */
    @NavigationProperty(name="userExperienceAnalyticsDeviceStartupHistory")
    @JsonIgnore
    public UserExperienceAnalyticsDeviceStartupHistoryCollectionRequest getUserExperienceAnalyticsDeviceStartupHistory() {
        return new UserExperienceAnalyticsDeviceStartupHistoryCollectionRequest(
                        contextPath.addSegment("userExperienceAnalyticsDeviceStartupHistory"), Optional.ofNullable(userExperienceAnalyticsDeviceStartupHistory));
    }

    /**
     * <i>“User experience analytics device Startup Processes”</i>
     * 
     * @return navigational property userExperienceAnalyticsDeviceStartupProcesses
     */
    @NavigationProperty(name="userExperienceAnalyticsDeviceStartupProcesses")
    @JsonIgnore
    public UserExperienceAnalyticsDeviceStartupProcessCollectionRequest getUserExperienceAnalyticsDeviceStartupProcesses() {
        return new UserExperienceAnalyticsDeviceStartupProcessCollectionRequest(
                        contextPath.addSegment("userExperienceAnalyticsDeviceStartupProcesses"), Optional.ofNullable(userExperienceAnalyticsDeviceStartupProcesses));
    }

    /**
     * <i>“User experience analytics device Startup Process Performance”</i>
     * 
     * @return navigational property userExperienceAnalyticsDeviceStartupProcessPerformance
     */
    @NavigationProperty(name="userExperienceAnalyticsDeviceStartupProcessPerformance")
    @JsonIgnore
    public UserExperienceAnalyticsDeviceStartupProcessPerformanceCollectionRequest getUserExperienceAnalyticsDeviceStartupProcessPerformance() {
        return new UserExperienceAnalyticsDeviceStartupProcessPerformanceCollectionRequest(
                        contextPath.addSegment("userExperienceAnalyticsDeviceStartupProcessPerformance"), Optional.ofNullable(userExperienceAnalyticsDeviceStartupProcessPerformance));
    }

    /**
     * <i>“User experience analytics devices without cloud identity.”</i>
     * 
     * @return navigational property userExperienceAnalyticsDevicesWithoutCloudIdentity
     */
    @NavigationProperty(name="userExperienceAnalyticsDevicesWithoutCloudIdentity")
    @JsonIgnore
    public UserExperienceAnalyticsDeviceWithoutCloudIdentityCollectionRequest getUserExperienceAnalyticsDevicesWithoutCloudIdentity() {
        return new UserExperienceAnalyticsDeviceWithoutCloudIdentityCollectionRequest(
                        contextPath.addSegment("userExperienceAnalyticsDevicesWithoutCloudIdentity"), Optional.ofNullable(userExperienceAnalyticsDevicesWithoutCloudIdentity));
    }

    /**
     * <i>“User experience analytics impacting process”</i>
     * 
     * @return navigational property userExperienceAnalyticsImpactingProcess
     */
    @NavigationProperty(name="userExperienceAnalyticsImpactingProcess")
    @JsonIgnore
    public UserExperienceAnalyticsImpactingProcessCollectionRequest getUserExperienceAnalyticsImpactingProcess() {
        return new UserExperienceAnalyticsImpactingProcessCollectionRequest(
                        contextPath.addSegment("userExperienceAnalyticsImpactingProcess"), Optional.ofNullable(userExperienceAnalyticsImpactingProcess));
    }

    /**
     * <i>“User experience analytics metric history”</i>
     * 
     * @return navigational property userExperienceAnalyticsMetricHistory
     */
    @NavigationProperty(name="userExperienceAnalyticsMetricHistory")
    @JsonIgnore
    public UserExperienceAnalyticsMetricHistoryCollectionRequest getUserExperienceAnalyticsMetricHistory() {
        return new UserExperienceAnalyticsMetricHistoryCollectionRequest(
                        contextPath.addSegment("userExperienceAnalyticsMetricHistory"), Optional.ofNullable(userExperienceAnalyticsMetricHistory));
    }

    /**
     * <i>“User experience analytics model scores”</i>
     * 
     * @return navigational property userExperienceAnalyticsModelScores
     */
    @NavigationProperty(name="userExperienceAnalyticsModelScores")
    @JsonIgnore
    public UserExperienceAnalyticsModelScoresCollectionRequest getUserExperienceAnalyticsModelScores() {
        return new UserExperienceAnalyticsModelScoresCollectionRequest(
                        contextPath.addSegment("userExperienceAnalyticsModelScores"), Optional.ofNullable(userExperienceAnalyticsModelScores));
    }

    /**
     * <i>“User experience analytics devices not Windows Autopilot ready.”</i>
     * 
     * @return navigational property userExperienceAnalyticsNotAutopilotReadyDevice
     */
    @NavigationProperty(name="userExperienceAnalyticsNotAutopilotReadyDevice")
    @JsonIgnore
    public UserExperienceAnalyticsNotAutopilotReadyDeviceCollectionRequest getUserExperienceAnalyticsNotAutopilotReadyDevice() {
        return new UserExperienceAnalyticsNotAutopilotReadyDeviceCollectionRequest(
                        contextPath.addSegment("userExperienceAnalyticsNotAutopilotReadyDevice"), Optional.ofNullable(userExperienceAnalyticsNotAutopilotReadyDevice));
    }

    /**
     * <i>“User experience analytics overview”</i>
     * 
     * @return navigational property userExperienceAnalyticsOverview
     */
    @NavigationProperty(name="userExperienceAnalyticsOverview")
    @JsonIgnore
    public UserExperienceAnalyticsOverviewRequest getUserExperienceAnalyticsOverview() {
        return new UserExperienceAnalyticsOverviewRequest(contextPath.addSegment("userExperienceAnalyticsOverview"), Optional.ofNullable(userExperienceAnalyticsOverview));
    }

    /**
     * <i>“User experience analytics regression summary”</i>
     * 
     * @return navigational property userExperienceAnalyticsRegressionSummary
     */
    @NavigationProperty(name="userExperienceAnalyticsRegressionSummary")
    @JsonIgnore
    public UserExperienceAnalyticsRegressionSummaryRequest getUserExperienceAnalyticsRegressionSummary() {
        return new UserExperienceAnalyticsRegressionSummaryRequest(contextPath.addSegment("userExperienceAnalyticsRegressionSummary"), Optional.ofNullable(userExperienceAnalyticsRegressionSummary));
    }

    /**
     * <i>“User experience analytics remote connection”</i>
     * 
     * @return navigational property userExperienceAnalyticsRemoteConnection
     */
    @NavigationProperty(name="userExperienceAnalyticsRemoteConnection")
    @JsonIgnore
    public UserExperienceAnalyticsRemoteConnectionCollectionRequest getUserExperienceAnalyticsRemoteConnection() {
        return new UserExperienceAnalyticsRemoteConnectionCollectionRequest(
                        contextPath.addSegment("userExperienceAnalyticsRemoteConnection"), Optional.ofNullable(userExperienceAnalyticsRemoteConnection));
    }

    /**
     * <i>“User experience analytics resource performance”</i>
     * 
     * @return navigational property userExperienceAnalyticsResourcePerformance
     */
    @NavigationProperty(name="userExperienceAnalyticsResourcePerformance")
    @JsonIgnore
    public UserExperienceAnalyticsResourcePerformanceCollectionRequest getUserExperienceAnalyticsResourcePerformance() {
        return new UserExperienceAnalyticsResourcePerformanceCollectionRequest(
                        contextPath.addSegment("userExperienceAnalyticsResourcePerformance"), Optional.ofNullable(userExperienceAnalyticsResourcePerformance));
    }

    /**
     * <i>“User experience analytics device Startup Score History”</i>
     * 
     * @return navigational property userExperienceAnalyticsScoreHistory
     */
    @NavigationProperty(name="userExperienceAnalyticsScoreHistory")
    @JsonIgnore
    public UserExperienceAnalyticsScoreHistoryCollectionRequest getUserExperienceAnalyticsScoreHistory() {
        return new UserExperienceAnalyticsScoreHistoryCollectionRequest(
                        contextPath.addSegment("userExperienceAnalyticsScoreHistory"), Optional.ofNullable(userExperienceAnalyticsScoreHistory));
    }

    /**
     * <i>“User experience analytics work from anywhere hardware readiness metrics.”</i>
     * 
     * @return navigational property userExperienceAnalyticsWorkFromAnywhereHardwareReadinessMetric
     */
    @NavigationProperty(name="userExperienceAnalyticsWorkFromAnywhereHardwareReadinessMetric")
    @JsonIgnore
    public UserExperienceAnalyticsWorkFromAnywhereHardwareReadinessMetricRequest getUserExperienceAnalyticsWorkFromAnywhereHardwareReadinessMetric() {
        return new UserExperienceAnalyticsWorkFromAnywhereHardwareReadinessMetricRequest(contextPath.addSegment("userExperienceAnalyticsWorkFromAnywhereHardwareReadinessMetric"), Optional.ofNullable(userExperienceAnalyticsWorkFromAnywhereHardwareReadinessMetric));
    }

    /**
     * <i>“User experience analytics work from anywhere metrics.”</i>
     * 
     * @return navigational property userExperienceAnalyticsWorkFromAnywhereMetrics
     */
    @NavigationProperty(name="userExperienceAnalyticsWorkFromAnywhereMetrics")
    @JsonIgnore
    public UserExperienceAnalyticsWorkFromAnywhereMetricCollectionRequest getUserExperienceAnalyticsWorkFromAnywhereMetrics() {
        return new UserExperienceAnalyticsWorkFromAnywhereMetricCollectionRequest(
                        contextPath.addSegment("userExperienceAnalyticsWorkFromAnywhereMetrics"), Optional.ofNullable(userExperienceAnalyticsWorkFromAnywhereMetrics));
    }

    /**
     * <i>“The user experience analytics work from anywhere model performance”</i>
     * 
     * @return navigational property userExperienceAnalyticsWorkFromAnywhereModelPerformance
     */
    @NavigationProperty(name="userExperienceAnalyticsWorkFromAnywhereModelPerformance")
    @JsonIgnore
    public UserExperienceAnalyticsWorkFromAnywhereModelPerformanceCollectionRequest getUserExperienceAnalyticsWorkFromAnywhereModelPerformance() {
        return new UserExperienceAnalyticsWorkFromAnywhereModelPerformanceCollectionRequest(
                        contextPath.addSegment("userExperienceAnalyticsWorkFromAnywhereModelPerformance"), Optional.ofNullable(userExperienceAnalyticsWorkFromAnywhereModelPerformance));
    }

    /**
     * <i>“The list of affected malware in the tenant.”</i>
     * 
     * @return navigational property windowsMalwareInformation
     */
    @NavigationProperty(name="windowsMalwareInformation")
    @JsonIgnore
    public WindowsMalwareInformationCollectionRequest getWindowsMalwareInformation() {
        return new WindowsMalwareInformationCollectionRequest(
                        contextPath.addSegment("windowsMalwareInformation"), Optional.ofNullable(windowsMalwareInformation));
    }

    /**
     * <i>“Collection of Derived credential settings associated with account.”</i>
     * 
     * @return navigational property derivedCredentials
     */
    @NavigationProperty(name="derivedCredentials")
    @JsonIgnore
    public DeviceManagementDerivedCredentialSettingsCollectionRequest getDerivedCredentials() {
        return new DeviceManagementDerivedCredentialSettingsCollectionRequest(
                        contextPath.addSegment("derivedCredentials"), Optional.ofNullable(derivedCredentials));
    }

    /**
     * <i>“Collection of resource access settings associated with account.”</i>
     * 
     * @return navigational property resourceAccessProfiles
     */
    @NavigationProperty(name="resourceAccessProfiles")
    @JsonIgnore
    public DeviceManagementResourceAccessProfileBaseCollectionRequest getResourceAccessProfiles() {
        return new DeviceManagementResourceAccessProfileBaseCollectionRequest(
                        contextPath.addSegment("resourceAccessProfiles"), Optional.ofNullable(resourceAccessProfiles));
    }

    /**
     * <i>“Apple user initiated enrollment profiles”</i>
     * 
     * @return navigational property appleUserInitiatedEnrollmentProfiles
     */
    @NavigationProperty(name="appleUserInitiatedEnrollmentProfiles")
    @JsonIgnore
    public AppleUserInitiatedEnrollmentProfileCollectionRequest getAppleUserInitiatedEnrollmentProfiles() {
        return new AppleUserInitiatedEnrollmentProfileCollectionRequest(
                        contextPath.addSegment("appleUserInitiatedEnrollmentProfiles"), Optional.ofNullable(appleUserInitiatedEnrollmentProfiles));
    }

    /**
     * <i>“This collections of multiple DEP tokens per-tenant.”</i>
     * 
     * @return navigational property depOnboardingSettings
     */
    @NavigationProperty(name="depOnboardingSettings")
    @JsonIgnore
    public DepOnboardingSettingCollectionRequest getDepOnboardingSettings() {
        return new DepOnboardingSettingCollectionRequest(
                        contextPath.addSegment("depOnboardingSettings"), Optional.ofNullable(depOnboardingSettings));
    }

    /**
     * <i>“The imported device identities.”</i>
     * 
     * @return navigational property importedDeviceIdentities
     */
    @NavigationProperty(name="importedDeviceIdentities")
    @JsonIgnore
    public ImportedDeviceIdentityCollectionRequest getImportedDeviceIdentities() {
        return new ImportedDeviceIdentityCollectionRequest(
                        contextPath.addSegment("importedDeviceIdentities"), Optional.ofNullable(importedDeviceIdentities));
    }

    /**
     * <i>“Collection of imported Windows autopilot devices.”</i>
     * 
     * @return navigational property importedWindowsAutopilotDeviceIdentities
     */
    @NavigationProperty(name="importedWindowsAutopilotDeviceIdentities")
    @JsonIgnore
    public ImportedWindowsAutopilotDeviceIdentityCollectionRequest getImportedWindowsAutopilotDeviceIdentities() {
        return new ImportedWindowsAutopilotDeviceIdentityCollectionRequest(
                        contextPath.addSegment("importedWindowsAutopilotDeviceIdentities"), Optional.ofNullable(importedWindowsAutopilotDeviceIdentities));
    }

    /**
     * <i>“Windows auto pilot deployment profiles”</i>
     * 
     * @return navigational property windowsAutopilotDeploymentProfiles
     */
    @NavigationProperty(name="windowsAutopilotDeploymentProfiles")
    @JsonIgnore
    public WindowsAutopilotDeploymentProfileCollectionRequest getWindowsAutopilotDeploymentProfiles() {
        return new WindowsAutopilotDeploymentProfileCollectionRequest(
                        contextPath.addSegment("windowsAutopilotDeploymentProfiles"), Optional.ofNullable(windowsAutopilotDeploymentProfiles));
    }

    /**
     * <i>“The Windows autopilot device identities contained collection.”</i>
     * 
     * @return navigational property windowsAutopilotDeviceIdentities
     */
    @NavigationProperty(name="windowsAutopilotDeviceIdentities")
    @JsonIgnore
    public WindowsAutopilotDeviceIdentityCollectionRequest getWindowsAutopilotDeviceIdentities() {
        return new WindowsAutopilotDeviceIdentityCollectionRequest(
                        contextPath.addSegment("windowsAutopilotDeviceIdentities"), Optional.ofNullable(windowsAutopilotDeviceIdentities));
    }

    /**
     * <i>“The Windows autopilot account settings.”</i>
     * 
     * @return navigational property windowsAutopilotSettings
     */
    @NavigationProperty(name="windowsAutopilotSettings")
    @JsonIgnore
    public WindowsAutopilotSettingsRequest getWindowsAutopilotSettings() {
        return new WindowsAutopilotSettingsRequest(contextPath.addSegment("windowsAutopilotSettings"), Optional.ofNullable(windowsAutopilotSettings));
    }

    /**
     * <i>“The management conditions associated with device management of the company.”</i>
     * 
     * @return navigational property managementConditions
     */
    @NavigationProperty(name="managementConditions")
    @JsonIgnore
    public ManagementConditionCollectionRequest getManagementConditions() {
        return new ManagementConditionCollectionRequest(
                        contextPath.addSegment("managementConditions"), Optional.ofNullable(managementConditions));
    }

    /**
     * <i>“The management condition statements associated with device management of the
     * company.”</i>
     * 
     * @return navigational property managementConditionStatements
     */
    @NavigationProperty(name="managementConditionStatements")
    @JsonIgnore
    public ManagementConditionStatementCollectionRequest getManagementConditionStatements() {
        return new ManagementConditionStatementCollectionRequest(
                        contextPath.addSegment("managementConditionStatements"), Optional.ofNullable(managementConditionStatements));
    }

    /**
     * <i>“A list of Group Policy migration reports.”</i>
     * 
     * @return navigational property groupPolicyMigrationReports
     */
    @NavigationProperty(name="groupPolicyMigrationReports")
    @JsonIgnore
    public GroupPolicyMigrationReportCollectionRequest getGroupPolicyMigrationReports() {
        return new GroupPolicyMigrationReportCollectionRequest(
                        contextPath.addSegment("groupPolicyMigrationReports"), Optional.ofNullable(groupPolicyMigrationReports));
    }

    /**
     * <i>“A list of Group Policy Object files uploaded.”</i>
     * 
     * @return navigational property groupPolicyObjectFiles
     */
    @NavigationProperty(name="groupPolicyObjectFiles")
    @JsonIgnore
    public GroupPolicyObjectFileCollectionRequest getGroupPolicyObjectFiles() {
        return new GroupPolicyObjectFileCollectionRequest(
                        contextPath.addSegment("groupPolicyObjectFiles"), Optional.ofNullable(groupPolicyObjectFiles));
    }

    /**
     * <i>“The available group policy categories for this account.”</i>
     * 
     * @return navigational property groupPolicyCategories
     */
    @NavigationProperty(name="groupPolicyCategories")
    @JsonIgnore
    public GroupPolicyCategoryCollectionRequest getGroupPolicyCategories() {
        return new GroupPolicyCategoryCollectionRequest(
                        contextPath.addSegment("groupPolicyCategories"), Optional.ofNullable(groupPolicyCategories));
    }

    /**
     * <i>“The group policy configurations created by this account.”</i>
     * 
     * @return navigational property groupPolicyConfigurations
     */
    @NavigationProperty(name="groupPolicyConfigurations")
    @JsonIgnore
    public GroupPolicyConfigurationCollectionRequest getGroupPolicyConfigurations() {
        return new GroupPolicyConfigurationCollectionRequest(
                        contextPath.addSegment("groupPolicyConfigurations"), Optional.ofNullable(groupPolicyConfigurations));
    }

    /**
     * <i>“The available group policy definition files for this account.”</i>
     * 
     * @return navigational property groupPolicyDefinitionFiles
     */
    @NavigationProperty(name="groupPolicyDefinitionFiles")
    @JsonIgnore
    public GroupPolicyDefinitionFileCollectionRequest getGroupPolicyDefinitionFiles() {
        return new GroupPolicyDefinitionFileCollectionRequest(
                        contextPath.addSegment("groupPolicyDefinitionFiles"), Optional.ofNullable(groupPolicyDefinitionFiles));
    }

    /**
     * <i>“The available group policy definitions for this account.”</i>
     * 
     * @return navigational property groupPolicyDefinitions
     */
    @NavigationProperty(name="groupPolicyDefinitions")
    @JsonIgnore
    public GroupPolicyDefinitionCollectionRequest getGroupPolicyDefinitions() {
        return new GroupPolicyDefinitionCollectionRequest(
                        contextPath.addSegment("groupPolicyDefinitions"), Optional.ofNullable(groupPolicyDefinitions));
    }

    /**
     * <i>“The available group policy uploaded definition files for this account.”</i>
     * 
     * @return navigational property groupPolicyUploadedDefinitionFiles
     */
    @NavigationProperty(name="groupPolicyUploadedDefinitionFiles")
    @JsonIgnore
    public GroupPolicyUploadedDefinitionFileCollectionRequest getGroupPolicyUploadedDefinitionFiles() {
        return new GroupPolicyUploadedDefinitionFileCollectionRequest(
                        contextPath.addSegment("groupPolicyUploadedDefinitionFiles"), Optional.ofNullable(groupPolicyUploadedDefinitionFiles));
    }

    /**
     * <i>“Collection of MicrosoftTunnelConfiguration settings associated with account.”</i>
     * 
     * @return navigational property microsoftTunnelConfigurations
     */
    @NavigationProperty(name="microsoftTunnelConfigurations")
    @JsonIgnore
    public MicrosoftTunnelConfigurationCollectionRequest getMicrosoftTunnelConfigurations() {
        return new MicrosoftTunnelConfigurationCollectionRequest(
                        contextPath.addSegment("microsoftTunnelConfigurations"), Optional.ofNullable(microsoftTunnelConfigurations));
    }

    /**
     * <i>“Collection of MicrosoftTunnelHealthThreshold settings associated with account.”</i>
     * 
     * @return navigational property microsoftTunnelHealthThresholds
     */
    @NavigationProperty(name="microsoftTunnelHealthThresholds")
    @JsonIgnore
    public MicrosoftTunnelHealthThresholdCollectionRequest getMicrosoftTunnelHealthThresholds() {
        return new MicrosoftTunnelHealthThresholdCollectionRequest(
                        contextPath.addSegment("microsoftTunnelHealthThresholds"), Optional.ofNullable(microsoftTunnelHealthThresholds));
    }

    /**
     * <i>“Collection of MicrosoftTunnelServerLogCollectionResponse settings associated
     * with account.”</i>
     * 
     * @return navigational property microsoftTunnelServerLogCollectionResponses
     */
    @NavigationProperty(name="microsoftTunnelServerLogCollectionResponses")
    @JsonIgnore
    public MicrosoftTunnelServerLogCollectionResponseCollectionRequest getMicrosoftTunnelServerLogCollectionResponses() {
        return new MicrosoftTunnelServerLogCollectionResponseCollectionRequest(
                        contextPath.addSegment("microsoftTunnelServerLogCollectionResponses"), Optional.ofNullable(microsoftTunnelServerLogCollectionResponses));
    }

    /**
     * <i>“Collection of MicrosoftTunnelSite settings associated with account.”</i>
     * 
     * @return navigational property microsoftTunnelSites
     */
    @NavigationProperty(name="microsoftTunnelSites")
    @JsonIgnore
    public MicrosoftTunnelSiteCollectionRequest getMicrosoftTunnelSites() {
        return new MicrosoftTunnelSiteCollectionRequest(
                        contextPath.addSegment("microsoftTunnelSites"), Optional.ofNullable(microsoftTunnelSites));
    }

    /**
     * <i>“The Notification Message Templates.”</i>
     * 
     * @return navigational property notificationMessageTemplates
     */
    @NavigationProperty(name="notificationMessageTemplates")
    @JsonIgnore
    public NotificationMessageTemplateCollectionRequest getNotificationMessageTemplates() {
        return new NotificationMessageTemplateCollectionRequest(
                        contextPath.addSegment("notificationMessageTemplates"), Optional.ofNullable(notificationMessageTemplates));
    }

    /**
     * <i>“A list of connector objects.”</i>
     * 
     * @return navigational property domainJoinConnectors
     */
    @NavigationProperty(name="domainJoinConnectors")
    @JsonIgnore
    public DeviceManagementDomainJoinConnectorCollectionRequest getDomainJoinConnectors() {
        return new DeviceManagementDomainJoinConnectorCollectionRequest(
                        contextPath.addSegment("domainJoinConnectors"), Optional.ofNullable(domainJoinConnectors));
    }

    /**
     * <i>“A list of ConfigManagerCollection”</i>
     * 
     * @return navigational property configManagerCollections
     */
    @NavigationProperty(name="configManagerCollections")
    @JsonIgnore
    public ConfigManagerCollectionCollectionRequest getConfigManagerCollections() {
        return new ConfigManagerCollectionCollectionRequest(
                        contextPath.addSegment("configManagerCollections"), Optional.ofNullable(configManagerCollections));
    }

    /**
     * <i>“The Resource Operations.”</i>
     * 
     * @return navigational property resourceOperations
     */
    @NavigationProperty(name="resourceOperations")
    @JsonIgnore
    public ResourceOperationCollectionRequest getResourceOperations() {
        return new ResourceOperationCollectionRequest(
                        contextPath.addSegment("resourceOperations"), Optional.ofNullable(resourceOperations));
    }

    /**
     * <i>“The Role Assignments.”</i>
     * 
     * @return navigational property roleAssignments
     */
    @NavigationProperty(name="roleAssignments")
    @JsonIgnore
    public DeviceAndAppManagementRoleAssignmentCollectionRequest getRoleAssignments() {
        return new DeviceAndAppManagementRoleAssignmentCollectionRequest(
                        contextPath.addSegment("roleAssignments"), Optional.ofNullable(roleAssignments));
    }

    /**
     * <i>“The Role Definitions.”</i>
     * 
     * @return navigational property roleDefinitions
     */
    @NavigationProperty(name="roleDefinitions")
    @JsonIgnore
    public RoleDefinitionCollectionRequest getRoleDefinitions() {
        return new RoleDefinitionCollectionRequest(
                        contextPath.addSegment("roleDefinitions"), Optional.ofNullable(roleDefinitions));
    }

    /**
     * <i>“The Role Scope Tags.”</i>
     * 
     * @return navigational property roleScopeTags
     */
    @NavigationProperty(name="roleScopeTags")
    @JsonIgnore
    public RoleScopeTagCollectionRequest getRoleScopeTags() {
        return new RoleScopeTagCollectionRequest(
                        contextPath.addSegment("roleScopeTags"), Optional.ofNullable(roleScopeTags));
    }

    /**
     * <i>“The remote assist partners.”</i>
     * 
     * @return navigational property remoteAssistancePartners
     */
    @NavigationProperty(name="remoteAssistancePartners")
    @JsonIgnore
    public RemoteAssistancePartnerCollectionRequest getRemoteAssistancePartners() {
        return new RemoteAssistancePartnerCollectionRequest(
                        contextPath.addSegment("remoteAssistancePartners"), Optional.ofNullable(remoteAssistancePartners));
    }

    /**
     * <i>“The remote assistance settings singleton”</i>
     * 
     * @return navigational property remoteAssistanceSettings
     */
    @NavigationProperty(name="remoteAssistanceSettings")
    @JsonIgnore
    public RemoteAssistanceSettingsRequest getRemoteAssistanceSettings() {
        return new RemoteAssistanceSettingsRequest(contextPath.addSegment("remoteAssistanceSettings"), Optional.ofNullable(remoteAssistanceSettings));
    }

    /**
     * <i>“Reports singleton”</i>
     * 
     * @return navigational property reports
     */
    @NavigationProperty(name="reports")
    @JsonIgnore
    public DeviceManagementReportsRequest getReports() {
        return new DeviceManagementReportsRequest(contextPath.addSegment("reports"), Optional.ofNullable(reports));
    }

    /**
     * <i>“The embedded SIM activation code pools created by this account.”</i>
     * 
     * @return navigational property embeddedSIMActivationCodePools
     */
    @NavigationProperty(name="embeddedSIMActivationCodePools")
    @JsonIgnore
    public EmbeddedSIMActivationCodePoolCollectionRequest getEmbeddedSIMActivationCodePools() {
        return new EmbeddedSIMActivationCodePoolCollectionRequest(
                        contextPath.addSegment("embeddedSIMActivationCodePools"), Optional.ofNullable(embeddedSIMActivationCodePools));
    }

    /**
     * <i>“The telecom expense management partners.”</i>
     * 
     * @return navigational property telecomExpenseManagementPartners
     */
    @NavigationProperty(name="telecomExpenseManagementPartners")
    @JsonIgnore
    public TelecomExpenseManagementPartnerCollectionRequest getTelecomExpenseManagementPartners() {
        return new TelecomExpenseManagementPartnerCollectionRequest(
                        contextPath.addSegment("telecomExpenseManagementPartners"), Optional.ofNullable(telecomExpenseManagementPartners));
    }

    /**
     * <i>“The list of autopilot events for the tenant.”</i>
     * 
     * @return navigational property autopilotEvents
     */
    @NavigationProperty(name="autopilotEvents")
    @JsonIgnore
    public DeviceManagementAutopilotEventCollectionRequest getAutopilotEvents() {
        return new DeviceManagementAutopilotEventCollectionRequest(
                        contextPath.addSegment("autopilotEvents"), Optional.ofNullable(autopilotEvents));
    }

    /**
     * <i>“The list of troubleshooting events for the tenant.”</i>
     * 
     * @return navigational property troubleshootingEvents
     */
    @NavigationProperty(name="troubleshootingEvents")
    @JsonIgnore
    public DeviceManagementTroubleshootingEventCollectionRequest getTroubleshootingEvents() {
        return new DeviceManagementTroubleshootingEventCollectionRequest(
                        contextPath.addSegment("troubleshootingEvents"), Optional.ofNullable(troubleshootingEvents));
    }

    /**
     * <i>“A collection of windows driver update profiles”</i>
     * 
     * @return navigational property windowsDriverUpdateProfiles
     */
    @NavigationProperty(name="windowsDriverUpdateProfiles")
    @JsonIgnore
    public WindowsDriverUpdateProfileCollectionRequest getWindowsDriverUpdateProfiles() {
        return new WindowsDriverUpdateProfileCollectionRequest(
                        contextPath.addSegment("windowsDriverUpdateProfiles"), Optional.ofNullable(windowsDriverUpdateProfiles));
    }

    /**
     * <i>“A collection of windows feature update profiles”</i>
     * 
     * @return navigational property windowsFeatureUpdateProfiles
     */
    @NavigationProperty(name="windowsFeatureUpdateProfiles")
    @JsonIgnore
    public WindowsFeatureUpdateProfileCollectionRequest getWindowsFeatureUpdateProfiles() {
        return new WindowsFeatureUpdateProfileCollectionRequest(
                        contextPath.addSegment("windowsFeatureUpdateProfiles"), Optional.ofNullable(windowsFeatureUpdateProfiles));
    }

    /**
     * <i>“A collection of windows quality update profiles”</i>
     * 
     * @return navigational property windowsQualityUpdateProfiles
     */
    @NavigationProperty(name="windowsQualityUpdateProfiles")
    @JsonIgnore
    public WindowsQualityUpdateProfileCollectionRequest getWindowsQualityUpdateProfiles() {
        return new WindowsQualityUpdateProfileCollectionRequest(
                        contextPath.addSegment("windowsQualityUpdateProfiles"), Optional.ofNullable(windowsQualityUpdateProfiles));
    }

    /**
     * <i>“A collection of windows update catalog items (fetaure updates item , quality
     * updates item)”</i>
     * 
     * @return navigational property windowsUpdateCatalogItems
     */
    @NavigationProperty(name="windowsUpdateCatalogItems")
    @JsonIgnore
    public WindowsUpdateCatalogItemCollectionRequest getWindowsUpdateCatalogItems() {
        return new WindowsUpdateCatalogItemCollectionRequest(
                        contextPath.addSegment("windowsUpdateCatalogItems"), Optional.ofNullable(windowsUpdateCatalogItems));
    }

    /**
     * <i>“Intune branding profiles targeted to AAD groups”</i>
     * 
     * @return navigational property intuneBrandingProfiles
     */
    @NavigationProperty(name="intuneBrandingProfiles")
    @JsonIgnore
    public IntuneBrandingProfileCollectionRequest getIntuneBrandingProfiles() {
        return new IntuneBrandingProfileCollectionRequest(
                        contextPath.addSegment("intuneBrandingProfiles"), Optional.ofNullable(intuneBrandingProfiles));
    }

    /**
     * <i>“The windows information protection app learning summaries.”</i>
     * 
     * @return navigational property windowsInformationProtectionAppLearningSummaries
     */
    @NavigationProperty(name="windowsInformationProtectionAppLearningSummaries")
    @JsonIgnore
    public WindowsInformationProtectionAppLearningSummaryCollectionRequest getWindowsInformationProtectionAppLearningSummaries() {
        return new WindowsInformationProtectionAppLearningSummaryCollectionRequest(
                        contextPath.addSegment("windowsInformationProtectionAppLearningSummaries"), Optional.ofNullable(windowsInformationProtectionAppLearningSummaries));
    }

    /**
     * <i>“The windows information protection network learning summaries.”</i>
     * 
     * @return navigational property windowsInformationProtectionNetworkLearningSummaries
     */
    @NavigationProperty(name="windowsInformationProtectionNetworkLearningSummaries")
    @JsonIgnore
    public WindowsInformationProtectionNetworkLearningSummaryCollectionRequest getWindowsInformationProtectionNetworkLearningSummaries() {
        return new WindowsInformationProtectionNetworkLearningSummaryCollectionRequest(
                        contextPath.addSegment("windowsInformationProtectionNetworkLearningSummaries"), Optional.ofNullable(windowsInformationProtectionNetworkLearningSummaries));
    }

    /**
     * <i>“Collection of certificate connector details, each associated with a
     * corresponding Intune Certificate Connector.”</i>
     * 
     * @return navigational property certificateConnectorDetails
     */
    @NavigationProperty(name="certificateConnectorDetails")
    @JsonIgnore
    public CertificateConnectorDetailsCollectionRequest getCertificateConnectorDetails() {
        return new CertificateConnectorDetailsCollectionRequest(
                        contextPath.addSegment("certificateConnectorDetails"), Optional.ofNullable(certificateConnectorDetails));
    }

    /**
     * <i>“Collection of PFX certificates associated with a user.”</i>
     * 
     * @return navigational property userPfxCertificates
     */
    @NavigationProperty(name="userPfxCertificates")
    @JsonIgnore
    public UserPFXCertificateCollectionRequest getUserPfxCertificates() {
        return new UserPFXCertificateCollectionRequest(
                        contextPath.addSegment("userPfxCertificates"), Optional.ofNullable(userPfxCertificates));
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * androidDeviceOwnerEnrollmentProfiles} field changed. Field description below.
     * The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Android device owner enrollment profile entities.”</i>
     * 
     * @param androidDeviceOwnerEnrollmentProfiles
     *            new value of {@code androidDeviceOwnerEnrollmentProfiles} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code androidDeviceOwnerEnrollmentProfiles} field changed
     */
    public DeviceManagement withAndroidDeviceOwnerEnrollmentProfiles(List<AndroidDeviceOwnerEnrollmentProfile> androidDeviceOwnerEnrollmentProfiles) {
        DeviceManagement _x = _copy();
        _x.changedFields = changedFields.add("androidDeviceOwnerEnrollmentProfiles");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagement");
        _x.androidDeviceOwnerEnrollmentProfiles = androidDeviceOwnerEnrollmentProfiles;
        return _x;
    }

    public DeviceManagement withVirtualEndpoint(VirtualEndpoint virtualEndpoint) {
        DeviceManagement _x = _copy();
        _x.changedFields = changedFields.add("virtualEndpoint");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagement");
        _x.virtualEndpoint = virtualEndpoint;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * androidForWorkAppConfigurationSchemas} field changed. Field description below.
     * The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Android for Work app configuration schema entities.”</i>
     * 
     * @param androidForWorkAppConfigurationSchemas
     *            new value of {@code androidForWorkAppConfigurationSchemas} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code androidForWorkAppConfigurationSchemas} field changed
     */
    public DeviceManagement withAndroidForWorkAppConfigurationSchemas(List<AndroidForWorkAppConfigurationSchema> androidForWorkAppConfigurationSchemas) {
        DeviceManagement _x = _copy();
        _x.changedFields = changedFields.add("androidForWorkAppConfigurationSchemas");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagement");
        _x.androidForWorkAppConfigurationSchemas = androidForWorkAppConfigurationSchemas;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * androidForWorkEnrollmentProfiles} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Android for Work enrollment profile entities.”</i>
     * 
     * @param androidForWorkEnrollmentProfiles
     *            new value of {@code androidForWorkEnrollmentProfiles} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code androidForWorkEnrollmentProfiles} field changed
     */
    public DeviceManagement withAndroidForWorkEnrollmentProfiles(List<AndroidForWorkEnrollmentProfile> androidForWorkEnrollmentProfiles) {
        DeviceManagement _x = _copy();
        _x.changedFields = changedFields.add("androidForWorkEnrollmentProfiles");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagement");
        _x.androidForWorkEnrollmentProfiles = androidForWorkEnrollmentProfiles;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * androidForWorkSettings} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“The singleton Android for Work settings entity.”</i>
     * 
     * @param androidForWorkSettings
     *            new value of {@code androidForWorkSettings} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code androidForWorkSettings} field changed
     */
    public DeviceManagement withAndroidForWorkSettings(AndroidForWorkSettings androidForWorkSettings) {
        DeviceManagement _x = _copy();
        _x.changedFields = changedFields.add("androidForWorkSettings");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagement");
        _x.androidForWorkSettings = androidForWorkSettings;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * androidManagedStoreAccountEnterpriseSettings} field changed. Field description
     * below. The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“The singleton Android managed store account enterprise settings entity.”</i>
     * 
     * @param androidManagedStoreAccountEnterpriseSettings
     *            new value of {@code androidManagedStoreAccountEnterpriseSettings} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code androidManagedStoreAccountEnterpriseSettings} field changed
     */
    public DeviceManagement withAndroidManagedStoreAccountEnterpriseSettings(AndroidManagedStoreAccountEnterpriseSettings androidManagedStoreAccountEnterpriseSettings) {
        DeviceManagement _x = _copy();
        _x.changedFields = changedFields.add("androidManagedStoreAccountEnterpriseSettings");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagement");
        _x.androidManagedStoreAccountEnterpriseSettings = androidManagedStoreAccountEnterpriseSettings;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * androidManagedStoreAppConfigurationSchemas} field changed. Field description
     * below. The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Android Enterprise app configuration schema entities.”</i>
     * 
     * @param androidManagedStoreAppConfigurationSchemas
     *            new value of {@code androidManagedStoreAppConfigurationSchemas} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code androidManagedStoreAppConfigurationSchemas} field changed
     */
    public DeviceManagement withAndroidManagedStoreAppConfigurationSchemas(List<AndroidManagedStoreAppConfigurationSchema> androidManagedStoreAppConfigurationSchemas) {
        DeviceManagement _x = _copy();
        _x.changedFields = changedFields.add("androidManagedStoreAppConfigurationSchemas");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagement");
        _x.androidManagedStoreAppConfigurationSchemas = androidManagedStoreAppConfigurationSchemas;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code auditEvents}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The Audit Events”</i>
     * 
     * @param auditEvents
     *            new value of {@code auditEvents} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code auditEvents} field changed
     */
    public DeviceManagement withAuditEvents(List<AuditEvent> auditEvents) {
        DeviceManagement _x = _copy();
        _x.changedFields = changedFields.add("auditEvents");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagement");
        _x.auditEvents = auditEvents;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code assignmentFilters
     * } field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The list of assignment filters”</i>
     * 
     * @param assignmentFilters
     *            new value of {@code assignmentFilters} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code assignmentFilters} field changed
     */
    public DeviceManagement withAssignmentFilters(List<DeviceAndAppManagementAssignmentFilter> assignmentFilters) {
        DeviceManagement _x = _copy();
        _x.changedFields = changedFields.add("assignmentFilters");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagement");
        _x.assignmentFilters = assignmentFilters;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * chromeOSOnboardingSettings} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Collection of ChromeOSOnboardingSettings settings associated with account.”</i>
     * 
     * @param chromeOSOnboardingSettings
     *            new value of {@code chromeOSOnboardingSettings} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code chromeOSOnboardingSettings} field changed
     */
    public DeviceManagement withChromeOSOnboardingSettings(List<ChromeOSOnboardingSettings> chromeOSOnboardingSettings) {
        DeviceManagement _x = _copy();
        _x.changedFields = changedFields.add("chromeOSOnboardingSettings");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagement");
        _x.chromeOSOnboardingSettings = chromeOSOnboardingSettings;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * termsAndConditions} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The terms and conditions associated with device management of the company.”</i>
     * 
     * @param termsAndConditions
     *            new value of {@code termsAndConditions} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code termsAndConditions} field changed
     */
    public DeviceManagement withTermsAndConditions(List<TermsAndConditions> termsAndConditions) {
        DeviceManagement _x = _copy();
        _x.changedFields = changedFields.add("termsAndConditions");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagement");
        _x.termsAndConditions = termsAndConditions;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * advancedThreatProtectionOnboardingStateSummary} field changed. Field description
     * below. The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“The summary state of ATP onboarding state for this account.”</i>
     * 
     * @param advancedThreatProtectionOnboardingStateSummary
     *            new value of {@code advancedThreatProtectionOnboardingStateSummary} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code advancedThreatProtectionOnboardingStateSummary} field changed
     */
    public DeviceManagement withAdvancedThreatProtectionOnboardingStateSummary(AdvancedThreatProtectionOnboardingStateSummary advancedThreatProtectionOnboardingStateSummary) {
        DeviceManagement _x = _copy();
        _x.changedFields = changedFields.add("advancedThreatProtectionOnboardingStateSummary");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagement");
        _x.advancedThreatProtectionOnboardingStateSummary = advancedThreatProtectionOnboardingStateSummary;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * cartToClassAssociations} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“The Cart To Class Associations.”</i>
     * 
     * @param cartToClassAssociations
     *            new value of {@code cartToClassAssociations} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code cartToClassAssociations} field changed
     */
    public DeviceManagement withCartToClassAssociations(List<CartToClassAssociation> cartToClassAssociations) {
        DeviceManagement _x = _copy();
        _x.changedFields = changedFields.add("cartToClassAssociations");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagement");
        _x.cartToClassAssociations = cartToClassAssociations;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * deviceCompliancePolicies} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“The device compliance policies.”</i>
     * 
     * @param deviceCompliancePolicies
     *            new value of {@code deviceCompliancePolicies} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceCompliancePolicies} field changed
     */
    public DeviceManagement withDeviceCompliancePolicies(List<DeviceCompliancePolicy> deviceCompliancePolicies) {
        DeviceManagement _x = _copy();
        _x.changedFields = changedFields.add("deviceCompliancePolicies");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagement");
        _x.deviceCompliancePolicies = deviceCompliancePolicies;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * deviceCompliancePolicyDeviceStateSummary} field changed. Field description below
     * . The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“The device compliance state summary for this account.”</i>
     * 
     * @param deviceCompliancePolicyDeviceStateSummary
     *            new value of {@code deviceCompliancePolicyDeviceStateSummary} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceCompliancePolicyDeviceStateSummary} field changed
     */
    public DeviceManagement withDeviceCompliancePolicyDeviceStateSummary(DeviceCompliancePolicyDeviceStateSummary deviceCompliancePolicyDeviceStateSummary) {
        DeviceManagement _x = _copy();
        _x.changedFields = changedFields.add("deviceCompliancePolicyDeviceStateSummary");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagement");
        _x.deviceCompliancePolicyDeviceStateSummary = deviceCompliancePolicyDeviceStateSummary;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * deviceCompliancePolicySettingStateSummaries} field changed. Field description
     * below. The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“The summary states of compliance policy settings for this account.”</i>
     * 
     * @param deviceCompliancePolicySettingStateSummaries
     *            new value of {@code deviceCompliancePolicySettingStateSummaries} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceCompliancePolicySettingStateSummaries} field changed
     */
    public DeviceManagement withDeviceCompliancePolicySettingStateSummaries(List<DeviceCompliancePolicySettingStateSummary> deviceCompliancePolicySettingStateSummaries) {
        DeviceManagement _x = _copy();
        _x.changedFields = changedFields.add("deviceCompliancePolicySettingStateSummaries");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagement");
        _x.deviceCompliancePolicySettingStateSummaries = deviceCompliancePolicySettingStateSummaries;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * deviceConfigurationConflictSummary} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Summary of policies in conflict state for this account.”</i>
     * 
     * @param deviceConfigurationConflictSummary
     *            new value of {@code deviceConfigurationConflictSummary} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceConfigurationConflictSummary} field changed
     */
    public DeviceManagement withDeviceConfigurationConflictSummary(List<DeviceConfigurationConflictSummary> deviceConfigurationConflictSummary) {
        DeviceManagement _x = _copy();
        _x.changedFields = changedFields.add("deviceConfigurationConflictSummary");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagement");
        _x.deviceConfigurationConflictSummary = deviceConfigurationConflictSummary;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * deviceConfigurationDeviceStateSummaries} field changed. Field description below.
     * The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“The device configuration device state summary for this account.”</i>
     * 
     * @param deviceConfigurationDeviceStateSummaries
     *            new value of {@code deviceConfigurationDeviceStateSummaries} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceConfigurationDeviceStateSummaries} field changed
     */
    public DeviceManagement withDeviceConfigurationDeviceStateSummaries(DeviceConfigurationDeviceStateSummary deviceConfigurationDeviceStateSummaries) {
        DeviceManagement _x = _copy();
        _x.changedFields = changedFields.add("deviceConfigurationDeviceStateSummaries");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagement");
        _x.deviceConfigurationDeviceStateSummaries = deviceConfigurationDeviceStateSummaries;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * deviceConfigurationRestrictedAppsViolations} field changed. Field description
     * below. The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Restricted apps violations for this account.”</i>
     * 
     * @param deviceConfigurationRestrictedAppsViolations
     *            new value of {@code deviceConfigurationRestrictedAppsViolations} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceConfigurationRestrictedAppsViolations} field changed
     */
    public DeviceManagement withDeviceConfigurationRestrictedAppsViolations(List<RestrictedAppsViolation> deviceConfigurationRestrictedAppsViolations) {
        DeviceManagement _x = _copy();
        _x.changedFields = changedFields.add("deviceConfigurationRestrictedAppsViolations");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagement");
        _x.deviceConfigurationRestrictedAppsViolations = deviceConfigurationRestrictedAppsViolations;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * deviceConfigurations} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The device configurations.”</i>
     * 
     * @param deviceConfigurations
     *            new value of {@code deviceConfigurations} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceConfigurations} field changed
     */
    public DeviceManagement withDeviceConfigurations(List<DeviceConfiguration> deviceConfigurations) {
        DeviceManagement _x = _copy();
        _x.changedFields = changedFields.add("deviceConfigurations");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagement");
        _x.deviceConfigurations = deviceConfigurations;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * deviceConfigurationsAllManagedDeviceCertificateStates} field changed. Field
     * description below. The field name is also added to an internal map of changed
     * fields in the returned object so that when {@code this.patch()} is called (if
     * available)on the returned object only the changed fields are submitted.
     * <p>
     * <i>“Summary of all certificates for all devices.”</i>
     * 
     * @param deviceConfigurationsAllManagedDeviceCertificateStates
     *            new value of {@code deviceConfigurationsAllManagedDeviceCertificateStates} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceConfigurationsAllManagedDeviceCertificateStates} field changed
     */
    public DeviceManagement withDeviceConfigurationsAllManagedDeviceCertificateStates(List<ManagedAllDeviceCertificateState> deviceConfigurationsAllManagedDeviceCertificateStates) {
        DeviceManagement _x = _copy();
        _x.changedFields = changedFields.add("deviceConfigurationsAllManagedDeviceCertificateStates");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagement");
        _x.deviceConfigurationsAllManagedDeviceCertificateStates = deviceConfigurationsAllManagedDeviceCertificateStates;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * deviceConfigurationUserStateSummaries} field changed. Field description below.
     * The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“The device configuration user state summary for this account.”</i>
     * 
     * @param deviceConfigurationUserStateSummaries
     *            new value of {@code deviceConfigurationUserStateSummaries} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceConfigurationUserStateSummaries} field changed
     */
    public DeviceManagement withDeviceConfigurationUserStateSummaries(DeviceConfigurationUserStateSummary deviceConfigurationUserStateSummaries) {
        DeviceManagement _x = _copy();
        _x.changedFields = changedFields.add("deviceConfigurationUserStateSummaries");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagement");
        _x.deviceConfigurationUserStateSummaries = deviceConfigurationUserStateSummaries;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code iosUpdateStatuses
     * } field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The IOS software update installation statuses for this account.”</i>
     * 
     * @param iosUpdateStatuses
     *            new value of {@code iosUpdateStatuses} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code iosUpdateStatuses} field changed
     */
    public DeviceManagement withIosUpdateStatuses(List<IosUpdateDeviceStatus> iosUpdateStatuses) {
        DeviceManagement _x = _copy();
        _x.changedFields = changedFields.add("iosUpdateStatuses");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagement");
        _x.iosUpdateStatuses = iosUpdateStatuses;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * macOSSoftwareUpdateAccountSummaries} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“The MacOS software update account summaries for this account.”</i>
     * 
     * @param macOSSoftwareUpdateAccountSummaries
     *            new value of {@code macOSSoftwareUpdateAccountSummaries} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code macOSSoftwareUpdateAccountSummaries} field changed
     */
    public DeviceManagement withMacOSSoftwareUpdateAccountSummaries(List<MacOSSoftwareUpdateAccountSummary> macOSSoftwareUpdateAccountSummaries) {
        DeviceManagement _x = _copy();
        _x.changedFields = changedFields.add("macOSSoftwareUpdateAccountSummaries");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagement");
        _x.macOSSoftwareUpdateAccountSummaries = macOSSoftwareUpdateAccountSummaries;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * managedDeviceEncryptionStates} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Encryption report for devices in this account”</i>
     * 
     * @param managedDeviceEncryptionStates
     *            new value of {@code managedDeviceEncryptionStates} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code managedDeviceEncryptionStates} field changed
     */
    public DeviceManagement withManagedDeviceEncryptionStates(List<ManagedDeviceEncryptionState> managedDeviceEncryptionStates) {
        DeviceManagement _x = _copy();
        _x.changedFields = changedFields.add("managedDeviceEncryptionStates");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagement");
        _x.managedDeviceEncryptionStates = managedDeviceEncryptionStates;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code ndesConnectors}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The collection of Ndes connectors for this account.”</i>
     * 
     * @param ndesConnectors
     *            new value of {@code ndesConnectors} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code ndesConnectors} field changed
     */
    public DeviceManagement withNdesConnectors(List<NdesConnector> ndesConnectors) {
        DeviceManagement _x = _copy();
        _x.changedFields = changedFields.add("ndesConnectors");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagement");
        _x.ndesConnectors = ndesConnectors;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * complianceCategories} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“List of all compliance categories”</i>
     * 
     * @param complianceCategories
     *            new value of {@code complianceCategories} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code complianceCategories} field changed
     */
    public DeviceManagement withComplianceCategories(List<DeviceManagementConfigurationCategory> complianceCategories) {
        DeviceManagement _x = _copy();
        _x.changedFields = changedFields.add("complianceCategories");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagement");
        _x.complianceCategories = complianceCategories;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * compliancePolicies} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“List of all compliance policies”</i>
     * 
     * @param compliancePolicies
     *            new value of {@code compliancePolicies} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code compliancePolicies} field changed
     */
    public DeviceManagement withCompliancePolicies(List<DeviceManagementCompliancePolicy> compliancePolicies) {
        DeviceManagement _x = _copy();
        _x.changedFields = changedFields.add("compliancePolicies");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagement");
        _x.compliancePolicies = compliancePolicies;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * complianceSettings} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“List of all ComplianceSettings”</i>
     * 
     * @param complianceSettings
     *            new value of {@code complianceSettings} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code complianceSettings} field changed
     */
    public DeviceManagement withComplianceSettings(List<DeviceManagementConfigurationSettingDefinition> complianceSettings) {
        DeviceManagement _x = _copy();
        _x.changedFields = changedFields.add("complianceSettings");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagement");
        _x.complianceSettings = complianceSettings;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * configurationCategories} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“List of all Configuration Categories”</i>
     * 
     * @param configurationCategories
     *            new value of {@code configurationCategories} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code configurationCategories} field changed
     */
    public DeviceManagement withConfigurationCategories(List<DeviceManagementConfigurationCategory> configurationCategories) {
        DeviceManagement _x = _copy();
        _x.changedFields = changedFields.add("configurationCategories");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagement");
        _x.configurationCategories = configurationCategories;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * configurationPolicies} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“List of all Configuration policies”</i>
     * 
     * @param configurationPolicies
     *            new value of {@code configurationPolicies} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code configurationPolicies} field changed
     */
    public DeviceManagement withConfigurationPolicies(List<DeviceManagementConfigurationPolicy> configurationPolicies) {
        DeviceManagement _x = _copy();
        _x.changedFields = changedFields.add("configurationPolicies");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagement");
        _x.configurationPolicies = configurationPolicies;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * configurationPolicyTemplates} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“List of all templates”</i>
     * 
     * @param configurationPolicyTemplates
     *            new value of {@code configurationPolicyTemplates} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code configurationPolicyTemplates} field changed
     */
    public DeviceManagement withConfigurationPolicyTemplates(List<DeviceManagementConfigurationPolicyTemplate> configurationPolicyTemplates) {
        DeviceManagement _x = _copy();
        _x.changedFields = changedFields.add("configurationPolicyTemplates");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagement");
        _x.configurationPolicyTemplates = configurationPolicyTemplates;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * configurationSettings} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“List of all ConfigurationSettings”</i>
     * 
     * @param configurationSettings
     *            new value of {@code configurationSettings} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code configurationSettings} field changed
     */
    public DeviceManagement withConfigurationSettings(List<DeviceManagementConfigurationSettingDefinition> configurationSettings) {
        DeviceManagement _x = _copy();
        _x.changedFields = changedFields.add("configurationSettings");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagement");
        _x.configurationSettings = configurationSettings;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * reusablePolicySettings} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“List of all reusable settings that can be referred in a policy”</i>
     * 
     * @param reusablePolicySettings
     *            new value of {@code reusablePolicySettings} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code reusablePolicySettings} field changed
     */
    public DeviceManagement withReusablePolicySettings(List<DeviceManagementReusablePolicySetting> reusablePolicySettings) {
        DeviceManagement _x = _copy();
        _x.changedFields = changedFields.add("reusablePolicySettings");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagement");
        _x.reusablePolicySettings = reusablePolicySettings;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code reusableSettings}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“List of all reusable settings”</i>
     * 
     * @param reusableSettings
     *            new value of {@code reusableSettings} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code reusableSettings} field changed
     */
    public DeviceManagement withReusableSettings(List<DeviceManagementConfigurationSettingDefinition> reusableSettings) {
        DeviceManagement _x = _copy();
        _x.changedFields = changedFields.add("reusableSettings");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagement");
        _x.reusableSettings = reusableSettings;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code templateSettings}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“List of all TemplateSettings”</i>
     * 
     * @param templateSettings
     *            new value of {@code templateSettings} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code templateSettings} field changed
     */
    public DeviceManagement withTemplateSettings(List<DeviceManagementConfigurationSettingTemplate> templateSettings) {
        DeviceManagement _x = _copy();
        _x.changedFields = changedFields.add("templateSettings");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagement");
        _x.templateSettings = templateSettings;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * complianceManagementPartners} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“The list of Compliance Management Partners configured by the tenant.”</i>
     * 
     * @param complianceManagementPartners
     *            new value of {@code complianceManagementPartners} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code complianceManagementPartners} field changed
     */
    public DeviceManagement withComplianceManagementPartners(List<ComplianceManagementPartner> complianceManagementPartners) {
        DeviceManagement _x = _copy();
        _x.changedFields = changedFields.add("complianceManagementPartners");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagement");
        _x.complianceManagementPartners = complianceManagementPartners;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * conditionalAccessSettings} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“The Exchange on premises conditional access settings. On premises conditional
     * access will require devices to be both enrolled and compliant for mail access”</i>
     * 
     * @param conditionalAccessSettings
     *            new value of {@code conditionalAccessSettings} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code conditionalAccessSettings} field changed
     */
    public DeviceManagement withConditionalAccessSettings(OnPremisesConditionalAccessSettings conditionalAccessSettings) {
        DeviceManagement _x = _copy();
        _x.changedFields = changedFields.add("conditionalAccessSettings");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagement");
        _x.conditionalAccessSettings = conditionalAccessSettings;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code deviceCategories}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The list of device categories with the tenant.”</i>
     * 
     * @param deviceCategories
     *            new value of {@code deviceCategories} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceCategories} field changed
     */
    public DeviceManagement withDeviceCategories(List<DeviceCategory> deviceCategories) {
        DeviceManagement _x = _copy();
        _x.changedFields = changedFields.add("deviceCategories");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagement");
        _x.deviceCategories = deviceCategories;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * deviceEnrollmentConfigurations} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“The list of device enrollment configurations”</i>
     * 
     * @param deviceEnrollmentConfigurations
     *            new value of {@code deviceEnrollmentConfigurations} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceEnrollmentConfigurations} field changed
     */
    public DeviceManagement withDeviceEnrollmentConfigurations(List<DeviceEnrollmentConfiguration> deviceEnrollmentConfigurations) {
        DeviceManagement _x = _copy();
        _x.changedFields = changedFields.add("deviceEnrollmentConfigurations");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagement");
        _x.deviceEnrollmentConfigurations = deviceEnrollmentConfigurations;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * deviceManagementPartners} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“The list of Device Management Partners configured by the tenant.”</i>
     * 
     * @param deviceManagementPartners
     *            new value of {@code deviceManagementPartners} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceManagementPartners} field changed
     */
    public DeviceManagement withDeviceManagementPartners(List<DeviceManagementPartner> deviceManagementPartners) {
        DeviceManagement _x = _copy();
        _x.changedFields = changedFields.add("deviceManagementPartners");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagement");
        _x.deviceManagementPartners = deviceManagementPartners;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * exchangeConnectors} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The list of Exchange Connectors configured by the tenant.”</i>
     * 
     * @param exchangeConnectors
     *            new value of {@code exchangeConnectors} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code exchangeConnectors} field changed
     */
    public DeviceManagement withExchangeConnectors(List<DeviceManagementExchangeConnector> exchangeConnectors) {
        DeviceManagement _x = _copy();
        _x.changedFields = changedFields.add("exchangeConnectors");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagement");
        _x.exchangeConnectors = exchangeConnectors;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * exchangeOnPremisesPolicies} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“The list of Exchange On Premisis policies configured by the tenant.”</i>
     * 
     * @param exchangeOnPremisesPolicies
     *            new value of {@code exchangeOnPremisesPolicies} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code exchangeOnPremisesPolicies} field changed
     */
    public DeviceManagement withExchangeOnPremisesPolicies(List<DeviceManagementExchangeOnPremisesPolicy> exchangeOnPremisesPolicies) {
        DeviceManagement _x = _copy();
        _x.changedFields = changedFields.add("exchangeOnPremisesPolicies");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagement");
        _x.exchangeOnPremisesPolicies = exchangeOnPremisesPolicies;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * exchangeOnPremisesPolicy} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“The policy which controls mobile device access to Exchange On Premises”</i>
     * 
     * @param exchangeOnPremisesPolicy
     *            new value of {@code exchangeOnPremisesPolicy} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code exchangeOnPremisesPolicy} field changed
     */
    public DeviceManagement withExchangeOnPremisesPolicy(DeviceManagementExchangeOnPremisesPolicy exchangeOnPremisesPolicy) {
        DeviceManagement _x = _copy();
        _x.changedFields = changedFields.add("exchangeOnPremisesPolicy");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagement");
        _x.exchangeOnPremisesPolicy = exchangeOnPremisesPolicy;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * mobileThreatDefenseConnectors} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“The list of Mobile threat Defense connectors configured by the tenant.”</i>
     * 
     * @param mobileThreatDefenseConnectors
     *            new value of {@code mobileThreatDefenseConnectors} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code mobileThreatDefenseConnectors} field changed
     */
    public DeviceManagement withMobileThreatDefenseConnectors(List<MobileThreatDefenseConnector> mobileThreatDefenseConnectors) {
        DeviceManagement _x = _copy();
        _x.changedFields = changedFields.add("mobileThreatDefenseConnectors");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagement");
        _x.mobileThreatDefenseConnectors = mobileThreatDefenseConnectors;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code categories} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The available categories”</i>
     * 
     * @param categories
     *            new value of {@code categories} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code categories} field changed
     */
    public DeviceManagement withCategories(List<DeviceManagementSettingCategory> categories) {
        DeviceManagement _x = _copy();
        _x.changedFields = changedFields.add("categories");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagement");
        _x.categories = categories;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code intents} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The device management intents”</i>
     * 
     * @param intents
     *            new value of {@code intents} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code intents} field changed
     */
    public DeviceManagement withIntents(List<DeviceManagementIntent> intents) {
        DeviceManagement _x = _copy();
        _x.changedFields = changedFields.add("intents");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagement");
        _x.intents = intents;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * settingDefinitions} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The device management intent setting definitions”</i>
     * 
     * @param settingDefinitions
     *            new value of {@code settingDefinitions} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code settingDefinitions} field changed
     */
    public DeviceManagement withSettingDefinitions(List<DeviceManagementSettingDefinition> settingDefinitions) {
        DeviceManagement _x = _copy();
        _x.changedFields = changedFields.add("settingDefinitions");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagement");
        _x.settingDefinitions = settingDefinitions;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code templates} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The available templates”</i>
     * 
     * @param templates
     *            new value of {@code templates} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code templates} field changed
     */
    public DeviceManagement withTemplates(List<DeviceManagementTemplate> templates) {
        DeviceManagement _x = _copy();
        _x.changedFields = changedFields.add("templates");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagement");
        _x.templates = templates;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * applePushNotificationCertificate} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Apple push notification certificate.”</i>
     * 
     * @param applePushNotificationCertificate
     *            new value of {@code applePushNotificationCertificate} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code applePushNotificationCertificate} field changed
     */
    public DeviceManagement withApplePushNotificationCertificate(ApplePushNotificationCertificate applePushNotificationCertificate) {
        DeviceManagement _x = _copy();
        _x.changedFields = changedFields.add("applePushNotificationCertificate");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagement");
        _x.applePushNotificationCertificate = applePushNotificationCertificate;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * cloudPCConnectivityIssues} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“The list of CloudPC Connectivity Issue.”</i>
     * 
     * @param cloudPCConnectivityIssues
     *            new value of {@code cloudPCConnectivityIssues} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code cloudPCConnectivityIssues} field changed
     */
    public DeviceManagement withCloudPCConnectivityIssues(List<CloudPCConnectivityIssue> cloudPCConnectivityIssues) {
        DeviceManagement _x = _copy();
        _x.changedFields = changedFields.add("cloudPCConnectivityIssues");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagement");
        _x.cloudPCConnectivityIssues = cloudPCConnectivityIssues;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code comanagedDevices}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The list of co-managed devices report”</i>
     * 
     * @param comanagedDevices
     *            new value of {@code comanagedDevices} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code comanagedDevices} field changed
     */
    public DeviceManagement withComanagedDevices(List<ManagedDevice> comanagedDevices) {
        DeviceManagement _x = _copy();
        _x.changedFields = changedFields.add("comanagedDevices");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagement");
        _x.comanagedDevices = comanagedDevices;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * comanagementEligibleDevices} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“The list of co-management eligible devices report”</i>
     * 
     * @param comanagementEligibleDevices
     *            new value of {@code comanagementEligibleDevices} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code comanagementEligibleDevices} field changed
     */
    public DeviceManagement withComanagementEligibleDevices(List<ComanagementEligibleDevice> comanagementEligibleDevices) {
        DeviceManagement _x = _copy();
        _x.changedFields = changedFields.add("comanagementEligibleDevices");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagement");
        _x.comanagementEligibleDevices = comanagementEligibleDevices;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * dataSharingConsents} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Data sharing consents.”</i>
     * 
     * @param dataSharingConsents
     *            new value of {@code dataSharingConsents} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code dataSharingConsents} field changed
     */
    public DeviceManagement withDataSharingConsents(List<DataSharingConsent> dataSharingConsents) {
        DeviceManagement _x = _copy();
        _x.changedFields = changedFields.add("dataSharingConsents");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagement");
        _x.dataSharingConsents = dataSharingConsents;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code detectedApps}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The list of detected apps associated with a device.”</i>
     * 
     * @param detectedApps
     *            new value of {@code detectedApps} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code detectedApps} field changed
     */
    public DeviceManagement withDetectedApps(List<DetectedApp> detectedApps) {
        DeviceManagement _x = _copy();
        _x.changedFields = changedFields.add("detectedApps");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagement");
        _x.detectedApps = detectedApps;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * deviceComplianceScripts} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“The list of device compliance scripts associated with the tenant.”</i>
     * 
     * @param deviceComplianceScripts
     *            new value of {@code deviceComplianceScripts} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceComplianceScripts} field changed
     */
    public DeviceManagement withDeviceComplianceScripts(List<DeviceComplianceScript> deviceComplianceScripts) {
        DeviceManagement _x = _copy();
        _x.changedFields = changedFields.add("deviceComplianceScripts");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagement");
        _x.deviceComplianceScripts = deviceComplianceScripts;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * deviceCustomAttributeShellScripts} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“The list of device custom attribute shell scripts associated with the tenant.”</i>
     * 
     * @param deviceCustomAttributeShellScripts
     *            new value of {@code deviceCustomAttributeShellScripts} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceCustomAttributeShellScripts} field changed
     */
    public DeviceManagement withDeviceCustomAttributeShellScripts(List<DeviceCustomAttributeShellScript> deviceCustomAttributeShellScripts) {
        DeviceManagement _x = _copy();
        _x.changedFields = changedFields.add("deviceCustomAttributeShellScripts");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagement");
        _x.deviceCustomAttributeShellScripts = deviceCustomAttributeShellScripts;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * deviceHealthScripts} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The list of device health scripts associated with the tenant.”</i>
     * 
     * @param deviceHealthScripts
     *            new value of {@code deviceHealthScripts} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceHealthScripts} field changed
     */
    public DeviceManagement withDeviceHealthScripts(List<DeviceHealthScript> deviceHealthScripts) {
        DeviceManagement _x = _copy();
        _x.changedFields = changedFields.add("deviceHealthScripts");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagement");
        _x.deviceHealthScripts = deviceHealthScripts;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * deviceManagementScripts} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“The list of device management scripts associated with the tenant.”</i>
     * 
     * @param deviceManagementScripts
     *            new value of {@code deviceManagementScripts} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceManagementScripts} field changed
     */
    public DeviceManagement withDeviceManagementScripts(List<DeviceManagementScript> deviceManagementScripts) {
        DeviceManagement _x = _copy();
        _x.changedFields = changedFields.add("deviceManagementScripts");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagement");
        _x.deviceManagementScripts = deviceManagementScripts;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * deviceShellScripts} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The list of device shell scripts associated with the tenant.”</i>
     * 
     * @param deviceShellScripts
     *            new value of {@code deviceShellScripts} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceShellScripts} field changed
     */
    public DeviceManagement withDeviceShellScripts(List<DeviceShellScript> deviceShellScripts) {
        DeviceManagement _x = _copy();
        _x.changedFields = changedFields.add("deviceShellScripts");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagement");
        _x.deviceShellScripts = deviceShellScripts;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code managedDevices}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The list of managed devices.”</i>
     * 
     * @param managedDevices
     *            new value of {@code managedDevices} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code managedDevices} field changed
     */
    public DeviceManagement withManagedDevices(List<ManagedDevice> managedDevices) {
        DeviceManagement _x = _copy();
        _x.changedFields = changedFields.add("managedDevices");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagement");
        _x.managedDevices = managedDevices;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * mobileAppTroubleshootingEvents} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“The collection property of MobileAppTroubleshootingEvent.”</i>
     * 
     * @param mobileAppTroubleshootingEvents
     *            new value of {@code mobileAppTroubleshootingEvents} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code mobileAppTroubleshootingEvents} field changed
     */
    public DeviceManagement withMobileAppTroubleshootingEvents(List<MobileAppTroubleshootingEvent> mobileAppTroubleshootingEvents) {
        DeviceManagement _x = _copy();
        _x.changedFields = changedFields.add("mobileAppTroubleshootingEvents");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagement");
        _x.mobileAppTroubleshootingEvents = mobileAppTroubleshootingEvents;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * oemWarrantyInformationOnboarding} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“List of OEM Warranty Statuses”</i>
     * 
     * @param oemWarrantyInformationOnboarding
     *            new value of {@code oemWarrantyInformationOnboarding} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code oemWarrantyInformationOnboarding} field changed
     */
    public DeviceManagement withOemWarrantyInformationOnboarding(List<OemWarrantyInformationOnboarding> oemWarrantyInformationOnboarding) {
        DeviceManagement _x = _copy();
        _x.changedFields = changedFields.add("oemWarrantyInformationOnboarding");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagement");
        _x.oemWarrantyInformationOnboarding = oemWarrantyInformationOnboarding;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * remoteActionAudits} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The list of device remote action audits with the tenant.”</i>
     * 
     * @param remoteActionAudits
     *            new value of {@code remoteActionAudits} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code remoteActionAudits} field changed
     */
    public DeviceManagement withRemoteActionAudits(List<RemoteActionAudit> remoteActionAudits) {
        DeviceManagement _x = _copy();
        _x.changedFields = changedFields.add("remoteActionAudits");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagement");
        _x.remoteActionAudits = remoteActionAudits;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * userExperienceAnalyticsAppHealthApplicationPerformance} field changed. Field
     * description below. The field name is also added to an internal map of changed
     * fields in the returned object so that when {@code this.patch()} is called (if
     * available)on the returned object only the changed fields are submitted.
     * <p>
     * <i>“User experience analytics appHealth Application Performance”</i>
     * 
     * @param userExperienceAnalyticsAppHealthApplicationPerformance
     *            new value of {@code userExperienceAnalyticsAppHealthApplicationPerformance} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code userExperienceAnalyticsAppHealthApplicationPerformance} field changed
     */
    public DeviceManagement withUserExperienceAnalyticsAppHealthApplicationPerformance(List<UserExperienceAnalyticsAppHealthApplicationPerformance> userExperienceAnalyticsAppHealthApplicationPerformance) {
        DeviceManagement _x = _copy();
        _x.changedFields = changedFields.add("userExperienceAnalyticsAppHealthApplicationPerformance");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagement");
        _x.userExperienceAnalyticsAppHealthApplicationPerformance = userExperienceAnalyticsAppHealthApplicationPerformance;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * userExperienceAnalyticsAppHealthApplicationPerformanceByAppVersion} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“User experience analytics appHealth Application Performance by App Version”</i>
     * 
     * @param userExperienceAnalyticsAppHealthApplicationPerformanceByAppVersion
     *            new value of {@code userExperienceAnalyticsAppHealthApplicationPerformanceByAppVersion} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code userExperienceAnalyticsAppHealthApplicationPerformanceByAppVersion} field changed
     */
    public DeviceManagement withUserExperienceAnalyticsAppHealthApplicationPerformanceByAppVersion(List<UserExperienceAnalyticsAppHealthAppPerformanceByAppVersion> userExperienceAnalyticsAppHealthApplicationPerformanceByAppVersion) {
        DeviceManagement _x = _copy();
        _x.changedFields = changedFields.add("userExperienceAnalyticsAppHealthApplicationPerformanceByAppVersion");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagement");
        _x.userExperienceAnalyticsAppHealthApplicationPerformanceByAppVersion = userExperienceAnalyticsAppHealthApplicationPerformanceByAppVersion;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * userExperienceAnalyticsAppHealthApplicationPerformanceByAppVersionDetails} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“User experience analytics appHealth Application Performance by App Version
     * details”</i>
     * 
     * @param userExperienceAnalyticsAppHealthApplicationPerformanceByAppVersionDetails
     *            new value of {@code userExperienceAnalyticsAppHealthApplicationPerformanceByAppVersionDetails} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code userExperienceAnalyticsAppHealthApplicationPerformanceByAppVersionDetails} field changed
     */
    public DeviceManagement withUserExperienceAnalyticsAppHealthApplicationPerformanceByAppVersionDetails(List<UserExperienceAnalyticsAppHealthAppPerformanceByAppVersionDetails> userExperienceAnalyticsAppHealthApplicationPerformanceByAppVersionDetails) {
        DeviceManagement _x = _copy();
        _x.changedFields = changedFields.add("userExperienceAnalyticsAppHealthApplicationPerformanceByAppVersionDetails");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagement");
        _x.userExperienceAnalyticsAppHealthApplicationPerformanceByAppVersionDetails = userExperienceAnalyticsAppHealthApplicationPerformanceByAppVersionDetails;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * userExperienceAnalyticsAppHealthApplicationPerformanceByAppVersionDeviceId}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“User experience analytics appHealth Application Performance by App Version
     * Device Id”</i>
     * 
     * @param userExperienceAnalyticsAppHealthApplicationPerformanceByAppVersionDeviceId
     *            new value of {@code userExperienceAnalyticsAppHealthApplicationPerformanceByAppVersionDeviceId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code userExperienceAnalyticsAppHealthApplicationPerformanceByAppVersionDeviceId} field changed
     */
    public DeviceManagement withUserExperienceAnalyticsAppHealthApplicationPerformanceByAppVersionDeviceId(List<UserExperienceAnalyticsAppHealthAppPerformanceByAppVersionDeviceId> userExperienceAnalyticsAppHealthApplicationPerformanceByAppVersionDeviceId) {
        DeviceManagement _x = _copy();
        _x.changedFields = changedFields.add("userExperienceAnalyticsAppHealthApplicationPerformanceByAppVersionDeviceId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagement");
        _x.userExperienceAnalyticsAppHealthApplicationPerformanceByAppVersionDeviceId = userExperienceAnalyticsAppHealthApplicationPerformanceByAppVersionDeviceId;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * userExperienceAnalyticsAppHealthApplicationPerformanceByOSVersion} field changed
     * . Field description below. The field name is also added to an internal map of
     * changed fields in the returned object so that when {@code this.patch()} is
     * called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“User experience analytics appHealth Application Performance by OS Version”</i>
     * 
     * @param userExperienceAnalyticsAppHealthApplicationPerformanceByOSVersion
     *            new value of {@code userExperienceAnalyticsAppHealthApplicationPerformanceByOSVersion} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code userExperienceAnalyticsAppHealthApplicationPerformanceByOSVersion} field changed
     */
    public DeviceManagement withUserExperienceAnalyticsAppHealthApplicationPerformanceByOSVersion(List<UserExperienceAnalyticsAppHealthAppPerformanceByOSVersion> userExperienceAnalyticsAppHealthApplicationPerformanceByOSVersion) {
        DeviceManagement _x = _copy();
        _x.changedFields = changedFields.add("userExperienceAnalyticsAppHealthApplicationPerformanceByOSVersion");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagement");
        _x.userExperienceAnalyticsAppHealthApplicationPerformanceByOSVersion = userExperienceAnalyticsAppHealthApplicationPerformanceByOSVersion;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * userExperienceAnalyticsAppHealthDeviceModelPerformance} field changed. Field
     * description below. The field name is also added to an internal map of changed
     * fields in the returned object so that when {@code this.patch()} is called (if
     * available)on the returned object only the changed fields are submitted.
     * <p>
     * <i>“User experience analytics appHealth Model Performance”</i>
     * 
     * @param userExperienceAnalyticsAppHealthDeviceModelPerformance
     *            new value of {@code userExperienceAnalyticsAppHealthDeviceModelPerformance} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code userExperienceAnalyticsAppHealthDeviceModelPerformance} field changed
     */
    public DeviceManagement withUserExperienceAnalyticsAppHealthDeviceModelPerformance(List<UserExperienceAnalyticsAppHealthDeviceModelPerformance> userExperienceAnalyticsAppHealthDeviceModelPerformance) {
        DeviceManagement _x = _copy();
        _x.changedFields = changedFields.add("userExperienceAnalyticsAppHealthDeviceModelPerformance");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagement");
        _x.userExperienceAnalyticsAppHealthDeviceModelPerformance = userExperienceAnalyticsAppHealthDeviceModelPerformance;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * userExperienceAnalyticsAppHealthDevicePerformance} field changed. Field
     * description below. The field name is also added to an internal map of changed
     * fields in the returned object so that when {@code this.patch()} is called (if
     * available)on the returned object only the changed fields are submitted.
     * <p>
     * <i>“User experience analytics appHealth Device Performance”</i>
     * 
     * @param userExperienceAnalyticsAppHealthDevicePerformance
     *            new value of {@code userExperienceAnalyticsAppHealthDevicePerformance} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code userExperienceAnalyticsAppHealthDevicePerformance} field changed
     */
    public DeviceManagement withUserExperienceAnalyticsAppHealthDevicePerformance(List<UserExperienceAnalyticsAppHealthDevicePerformance> userExperienceAnalyticsAppHealthDevicePerformance) {
        DeviceManagement _x = _copy();
        _x.changedFields = changedFields.add("userExperienceAnalyticsAppHealthDevicePerformance");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagement");
        _x.userExperienceAnalyticsAppHealthDevicePerformance = userExperienceAnalyticsAppHealthDevicePerformance;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * userExperienceAnalyticsAppHealthDevicePerformanceDetails} field changed. Field
     * description below. The field name is also added to an internal map of changed
     * fields in the returned object so that when {@code this.patch()} is called (if
     * available)on the returned object only the changed fields are submitted.
     * <p>
     * <i>“User experience analytics device performance details”</i>
     * 
     * @param userExperienceAnalyticsAppHealthDevicePerformanceDetails
     *            new value of {@code userExperienceAnalyticsAppHealthDevicePerformanceDetails} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code userExperienceAnalyticsAppHealthDevicePerformanceDetails} field changed
     */
    public DeviceManagement withUserExperienceAnalyticsAppHealthDevicePerformanceDetails(List<UserExperienceAnalyticsAppHealthDevicePerformanceDetails> userExperienceAnalyticsAppHealthDevicePerformanceDetails) {
        DeviceManagement _x = _copy();
        _x.changedFields = changedFields.add("userExperienceAnalyticsAppHealthDevicePerformanceDetails");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagement");
        _x.userExperienceAnalyticsAppHealthDevicePerformanceDetails = userExperienceAnalyticsAppHealthDevicePerformanceDetails;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * userExperienceAnalyticsAppHealthOSVersionPerformance} field changed. Field
     * description below. The field name is also added to an internal map of changed
     * fields in the returned object so that when {@code this.patch()} is called (if
     * available)on the returned object only the changed fields are submitted.
     * <p>
     * <i>“User experience analytics appHealth OS version Performance”</i>
     * 
     * @param userExperienceAnalyticsAppHealthOSVersionPerformance
     *            new value of {@code userExperienceAnalyticsAppHealthOSVersionPerformance} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code userExperienceAnalyticsAppHealthOSVersionPerformance} field changed
     */
    public DeviceManagement withUserExperienceAnalyticsAppHealthOSVersionPerformance(List<UserExperienceAnalyticsAppHealthOSVersionPerformance> userExperienceAnalyticsAppHealthOSVersionPerformance) {
        DeviceManagement _x = _copy();
        _x.changedFields = changedFields.add("userExperienceAnalyticsAppHealthOSVersionPerformance");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagement");
        _x.userExperienceAnalyticsAppHealthOSVersionPerformance = userExperienceAnalyticsAppHealthOSVersionPerformance;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * userExperienceAnalyticsAppHealthOverview} field changed. Field description below
     * . The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“User experience analytics appHealth overview”</i>
     * 
     * @param userExperienceAnalyticsAppHealthOverview
     *            new value of {@code userExperienceAnalyticsAppHealthOverview} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code userExperienceAnalyticsAppHealthOverview} field changed
     */
    public DeviceManagement withUserExperienceAnalyticsAppHealthOverview(UserExperienceAnalyticsCategory userExperienceAnalyticsAppHealthOverview) {
        DeviceManagement _x = _copy();
        _x.changedFields = changedFields.add("userExperienceAnalyticsAppHealthOverview");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagement");
        _x.userExperienceAnalyticsAppHealthOverview = userExperienceAnalyticsAppHealthOverview;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * userExperienceAnalyticsBaselines} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“User experience analytics baselines”</i>
     * 
     * @param userExperienceAnalyticsBaselines
     *            new value of {@code userExperienceAnalyticsBaselines} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code userExperienceAnalyticsBaselines} field changed
     */
    public DeviceManagement withUserExperienceAnalyticsBaselines(List<UserExperienceAnalyticsBaseline> userExperienceAnalyticsBaselines) {
        DeviceManagement _x = _copy();
        _x.changedFields = changedFields.add("userExperienceAnalyticsBaselines");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagement");
        _x.userExperienceAnalyticsBaselines = userExperienceAnalyticsBaselines;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * userExperienceAnalyticsBatteryHealthAppImpact} field changed. Field description
     * below. The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“User Experience Analytics Battery Health App Impact”</i>
     * 
     * @param userExperienceAnalyticsBatteryHealthAppImpact
     *            new value of {@code userExperienceAnalyticsBatteryHealthAppImpact} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code userExperienceAnalyticsBatteryHealthAppImpact} field changed
     */
    public DeviceManagement withUserExperienceAnalyticsBatteryHealthAppImpact(List<UserExperienceAnalyticsBatteryHealthAppImpact> userExperienceAnalyticsBatteryHealthAppImpact) {
        DeviceManagement _x = _copy();
        _x.changedFields = changedFields.add("userExperienceAnalyticsBatteryHealthAppImpact");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagement");
        _x.userExperienceAnalyticsBatteryHealthAppImpact = userExperienceAnalyticsBatteryHealthAppImpact;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * userExperienceAnalyticsBatteryHealthCapacityDetails} field changed. Field
     * description below. The field name is also added to an internal map of changed
     * fields in the returned object so that when {@code this.patch()} is called (if
     * available)on the returned object only the changed fields are submitted.
     * <p>
     * <i>“User Experience Analytics Battery Health Capacity Details”</i>
     * 
     * @param userExperienceAnalyticsBatteryHealthCapacityDetails
     *            new value of {@code userExperienceAnalyticsBatteryHealthCapacityDetails} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code userExperienceAnalyticsBatteryHealthCapacityDetails} field changed
     */
    public DeviceManagement withUserExperienceAnalyticsBatteryHealthCapacityDetails(UserExperienceAnalyticsBatteryHealthCapacityDetails userExperienceAnalyticsBatteryHealthCapacityDetails) {
        DeviceManagement _x = _copy();
        _x.changedFields = changedFields.add("userExperienceAnalyticsBatteryHealthCapacityDetails");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagement");
        _x.userExperienceAnalyticsBatteryHealthCapacityDetails = userExperienceAnalyticsBatteryHealthCapacityDetails;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * userExperienceAnalyticsBatteryHealthDeviceAppImpact} field changed. Field
     * description below. The field name is also added to an internal map of changed
     * fields in the returned object so that when {@code this.patch()} is called (if
     * available)on the returned object only the changed fields are submitted.
     * <p>
     * <i>“User Experience Analytics Battery Health Device App Impact”</i>
     * 
     * @param userExperienceAnalyticsBatteryHealthDeviceAppImpact
     *            new value of {@code userExperienceAnalyticsBatteryHealthDeviceAppImpact} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code userExperienceAnalyticsBatteryHealthDeviceAppImpact} field changed
     */
    public DeviceManagement withUserExperienceAnalyticsBatteryHealthDeviceAppImpact(List<UserExperienceAnalyticsBatteryHealthDeviceAppImpact> userExperienceAnalyticsBatteryHealthDeviceAppImpact) {
        DeviceManagement _x = _copy();
        _x.changedFields = changedFields.add("userExperienceAnalyticsBatteryHealthDeviceAppImpact");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagement");
        _x.userExperienceAnalyticsBatteryHealthDeviceAppImpact = userExperienceAnalyticsBatteryHealthDeviceAppImpact;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * userExperienceAnalyticsBatteryHealthDevicePerformance} field changed. Field
     * description below. The field name is also added to an internal map of changed
     * fields in the returned object so that when {@code this.patch()} is called (if
     * available)on the returned object only the changed fields are submitted.
     * <p>
     * <i>“User Experience Analytics Battery Health Device Performance”</i>
     * 
     * @param userExperienceAnalyticsBatteryHealthDevicePerformance
     *            new value of {@code userExperienceAnalyticsBatteryHealthDevicePerformance} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code userExperienceAnalyticsBatteryHealthDevicePerformance} field changed
     */
    public DeviceManagement withUserExperienceAnalyticsBatteryHealthDevicePerformance(List<UserExperienceAnalyticsBatteryHealthDevicePerformance> userExperienceAnalyticsBatteryHealthDevicePerformance) {
        DeviceManagement _x = _copy();
        _x.changedFields = changedFields.add("userExperienceAnalyticsBatteryHealthDevicePerformance");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagement");
        _x.userExperienceAnalyticsBatteryHealthDevicePerformance = userExperienceAnalyticsBatteryHealthDevicePerformance;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * userExperienceAnalyticsBatteryHealthDeviceRuntimeHistory} field changed. Field
     * description below. The field name is also added to an internal map of changed
     * fields in the returned object so that when {@code this.patch()} is called (if
     * available)on the returned object only the changed fields are submitted.
     * <p>
     * <i>“User Experience Analytics Battery Health Device Runtime History”</i>
     * 
     * @param userExperienceAnalyticsBatteryHealthDeviceRuntimeHistory
     *            new value of {@code userExperienceAnalyticsBatteryHealthDeviceRuntimeHistory} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code userExperienceAnalyticsBatteryHealthDeviceRuntimeHistory} field changed
     */
    public DeviceManagement withUserExperienceAnalyticsBatteryHealthDeviceRuntimeHistory(List<UserExperienceAnalyticsBatteryHealthDeviceRuntimeHistory> userExperienceAnalyticsBatteryHealthDeviceRuntimeHistory) {
        DeviceManagement _x = _copy();
        _x.changedFields = changedFields.add("userExperienceAnalyticsBatteryHealthDeviceRuntimeHistory");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagement");
        _x.userExperienceAnalyticsBatteryHealthDeviceRuntimeHistory = userExperienceAnalyticsBatteryHealthDeviceRuntimeHistory;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * userExperienceAnalyticsBatteryHealthModelPerformance} field changed. Field
     * description below. The field name is also added to an internal map of changed
     * fields in the returned object so that when {@code this.patch()} is called (if
     * available)on the returned object only the changed fields are submitted.
     * <p>
     * <i>“User Experience Analytics Battery Health Model Performance”</i>
     * 
     * @param userExperienceAnalyticsBatteryHealthModelPerformance
     *            new value of {@code userExperienceAnalyticsBatteryHealthModelPerformance} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code userExperienceAnalyticsBatteryHealthModelPerformance} field changed
     */
    public DeviceManagement withUserExperienceAnalyticsBatteryHealthModelPerformance(List<UserExperienceAnalyticsBatteryHealthModelPerformance> userExperienceAnalyticsBatteryHealthModelPerformance) {
        DeviceManagement _x = _copy();
        _x.changedFields = changedFields.add("userExperienceAnalyticsBatteryHealthModelPerformance");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagement");
        _x.userExperienceAnalyticsBatteryHealthModelPerformance = userExperienceAnalyticsBatteryHealthModelPerformance;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * userExperienceAnalyticsBatteryHealthOsPerformance} field changed. Field
     * description below. The field name is also added to an internal map of changed
     * fields in the returned object so that when {@code this.patch()} is called (if
     * available)on the returned object only the changed fields are submitted.
     * <p>
     * <i>“User Experience Analytics Battery Health Os Performance”</i>
     * 
     * @param userExperienceAnalyticsBatteryHealthOsPerformance
     *            new value of {@code userExperienceAnalyticsBatteryHealthOsPerformance} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code userExperienceAnalyticsBatteryHealthOsPerformance} field changed
     */
    public DeviceManagement withUserExperienceAnalyticsBatteryHealthOsPerformance(List<UserExperienceAnalyticsBatteryHealthOsPerformance> userExperienceAnalyticsBatteryHealthOsPerformance) {
        DeviceManagement _x = _copy();
        _x.changedFields = changedFields.add("userExperienceAnalyticsBatteryHealthOsPerformance");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagement");
        _x.userExperienceAnalyticsBatteryHealthOsPerformance = userExperienceAnalyticsBatteryHealthOsPerformance;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * userExperienceAnalyticsBatteryHealthRuntimeDetails} field changed. Field
     * description below. The field name is also added to an internal map of changed
     * fields in the returned object so that when {@code this.patch()} is called (if
     * available)on the returned object only the changed fields are submitted.
     * <p>
     * <i>“User Experience Analytics Battery Health Runtime Details”</i>
     * 
     * @param userExperienceAnalyticsBatteryHealthRuntimeDetails
     *            new value of {@code userExperienceAnalyticsBatteryHealthRuntimeDetails} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code userExperienceAnalyticsBatteryHealthRuntimeDetails} field changed
     */
    public DeviceManagement withUserExperienceAnalyticsBatteryHealthRuntimeDetails(UserExperienceAnalyticsBatteryHealthRuntimeDetails userExperienceAnalyticsBatteryHealthRuntimeDetails) {
        DeviceManagement _x = _copy();
        _x.changedFields = changedFields.add("userExperienceAnalyticsBatteryHealthRuntimeDetails");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagement");
        _x.userExperienceAnalyticsBatteryHealthRuntimeDetails = userExperienceAnalyticsBatteryHealthRuntimeDetails;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * userExperienceAnalyticsCategories} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“User experience analytics categories”</i>
     * 
     * @param userExperienceAnalyticsCategories
     *            new value of {@code userExperienceAnalyticsCategories} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code userExperienceAnalyticsCategories} field changed
     */
    public DeviceManagement withUserExperienceAnalyticsCategories(List<UserExperienceAnalyticsCategory> userExperienceAnalyticsCategories) {
        DeviceManagement _x = _copy();
        _x.changedFields = changedFields.add("userExperienceAnalyticsCategories");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagement");
        _x.userExperienceAnalyticsCategories = userExperienceAnalyticsCategories;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * userExperienceAnalyticsDeviceMetricHistory} field changed. Field description
     * below. The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“User experience analytics device metric history”</i>
     * 
     * @param userExperienceAnalyticsDeviceMetricHistory
     *            new value of {@code userExperienceAnalyticsDeviceMetricHistory} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code userExperienceAnalyticsDeviceMetricHistory} field changed
     */
    public DeviceManagement withUserExperienceAnalyticsDeviceMetricHistory(List<UserExperienceAnalyticsMetricHistory> userExperienceAnalyticsDeviceMetricHistory) {
        DeviceManagement _x = _copy();
        _x.changedFields = changedFields.add("userExperienceAnalyticsDeviceMetricHistory");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagement");
        _x.userExperienceAnalyticsDeviceMetricHistory = userExperienceAnalyticsDeviceMetricHistory;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * userExperienceAnalyticsDevicePerformance} field changed. Field description below
     * . The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“User experience analytics device performance”</i>
     * 
     * @param userExperienceAnalyticsDevicePerformance
     *            new value of {@code userExperienceAnalyticsDevicePerformance} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code userExperienceAnalyticsDevicePerformance} field changed
     */
    public DeviceManagement withUserExperienceAnalyticsDevicePerformance(List<UserExperienceAnalyticsDevicePerformance> userExperienceAnalyticsDevicePerformance) {
        DeviceManagement _x = _copy();
        _x.changedFields = changedFields.add("userExperienceAnalyticsDevicePerformance");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagement");
        _x.userExperienceAnalyticsDevicePerformance = userExperienceAnalyticsDevicePerformance;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * userExperienceAnalyticsDeviceScores} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“User experience analytics device scores”</i>
     * 
     * @param userExperienceAnalyticsDeviceScores
     *            new value of {@code userExperienceAnalyticsDeviceScores} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code userExperienceAnalyticsDeviceScores} field changed
     */
    public DeviceManagement withUserExperienceAnalyticsDeviceScores(List<UserExperienceAnalyticsDeviceScores> userExperienceAnalyticsDeviceScores) {
        DeviceManagement _x = _copy();
        _x.changedFields = changedFields.add("userExperienceAnalyticsDeviceScores");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagement");
        _x.userExperienceAnalyticsDeviceScores = userExperienceAnalyticsDeviceScores;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * userExperienceAnalyticsDeviceStartupHistory} field changed. Field description
     * below. The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“User experience analytics device Startup History”</i>
     * 
     * @param userExperienceAnalyticsDeviceStartupHistory
     *            new value of {@code userExperienceAnalyticsDeviceStartupHistory} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code userExperienceAnalyticsDeviceStartupHistory} field changed
     */
    public DeviceManagement withUserExperienceAnalyticsDeviceStartupHistory(List<UserExperienceAnalyticsDeviceStartupHistory> userExperienceAnalyticsDeviceStartupHistory) {
        DeviceManagement _x = _copy();
        _x.changedFields = changedFields.add("userExperienceAnalyticsDeviceStartupHistory");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagement");
        _x.userExperienceAnalyticsDeviceStartupHistory = userExperienceAnalyticsDeviceStartupHistory;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * userExperienceAnalyticsDeviceStartupProcesses} field changed. Field description
     * below. The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“User experience analytics device Startup Processes”</i>
     * 
     * @param userExperienceAnalyticsDeviceStartupProcesses
     *            new value of {@code userExperienceAnalyticsDeviceStartupProcesses} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code userExperienceAnalyticsDeviceStartupProcesses} field changed
     */
    public DeviceManagement withUserExperienceAnalyticsDeviceStartupProcesses(List<UserExperienceAnalyticsDeviceStartupProcess> userExperienceAnalyticsDeviceStartupProcesses) {
        DeviceManagement _x = _copy();
        _x.changedFields = changedFields.add("userExperienceAnalyticsDeviceStartupProcesses");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagement");
        _x.userExperienceAnalyticsDeviceStartupProcesses = userExperienceAnalyticsDeviceStartupProcesses;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * userExperienceAnalyticsDeviceStartupProcessPerformance} field changed. Field
     * description below. The field name is also added to an internal map of changed
     * fields in the returned object so that when {@code this.patch()} is called (if
     * available)on the returned object only the changed fields are submitted.
     * <p>
     * <i>“User experience analytics device Startup Process Performance”</i>
     * 
     * @param userExperienceAnalyticsDeviceStartupProcessPerformance
     *            new value of {@code userExperienceAnalyticsDeviceStartupProcessPerformance} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code userExperienceAnalyticsDeviceStartupProcessPerformance} field changed
     */
    public DeviceManagement withUserExperienceAnalyticsDeviceStartupProcessPerformance(List<UserExperienceAnalyticsDeviceStartupProcessPerformance> userExperienceAnalyticsDeviceStartupProcessPerformance) {
        DeviceManagement _x = _copy();
        _x.changedFields = changedFields.add("userExperienceAnalyticsDeviceStartupProcessPerformance");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagement");
        _x.userExperienceAnalyticsDeviceStartupProcessPerformance = userExperienceAnalyticsDeviceStartupProcessPerformance;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * userExperienceAnalyticsDevicesWithoutCloudIdentity} field changed. Field
     * description below. The field name is also added to an internal map of changed
     * fields in the returned object so that when {@code this.patch()} is called (if
     * available)on the returned object only the changed fields are submitted.
     * <p>
     * <i>“User experience analytics devices without cloud identity.”</i>
     * 
     * @param userExperienceAnalyticsDevicesWithoutCloudIdentity
     *            new value of {@code userExperienceAnalyticsDevicesWithoutCloudIdentity} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code userExperienceAnalyticsDevicesWithoutCloudIdentity} field changed
     */
    public DeviceManagement withUserExperienceAnalyticsDevicesWithoutCloudIdentity(List<UserExperienceAnalyticsDeviceWithoutCloudIdentity> userExperienceAnalyticsDevicesWithoutCloudIdentity) {
        DeviceManagement _x = _copy();
        _x.changedFields = changedFields.add("userExperienceAnalyticsDevicesWithoutCloudIdentity");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagement");
        _x.userExperienceAnalyticsDevicesWithoutCloudIdentity = userExperienceAnalyticsDevicesWithoutCloudIdentity;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * userExperienceAnalyticsImpactingProcess} field changed. Field description below.
     * The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“User experience analytics impacting process”</i>
     * 
     * @param userExperienceAnalyticsImpactingProcess
     *            new value of {@code userExperienceAnalyticsImpactingProcess} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code userExperienceAnalyticsImpactingProcess} field changed
     */
    public DeviceManagement withUserExperienceAnalyticsImpactingProcess(List<UserExperienceAnalyticsImpactingProcess> userExperienceAnalyticsImpactingProcess) {
        DeviceManagement _x = _copy();
        _x.changedFields = changedFields.add("userExperienceAnalyticsImpactingProcess");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagement");
        _x.userExperienceAnalyticsImpactingProcess = userExperienceAnalyticsImpactingProcess;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * userExperienceAnalyticsMetricHistory} field changed. Field description below.
     * The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“User experience analytics metric history”</i>
     * 
     * @param userExperienceAnalyticsMetricHistory
     *            new value of {@code userExperienceAnalyticsMetricHistory} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code userExperienceAnalyticsMetricHistory} field changed
     */
    public DeviceManagement withUserExperienceAnalyticsMetricHistory(List<UserExperienceAnalyticsMetricHistory> userExperienceAnalyticsMetricHistory) {
        DeviceManagement _x = _copy();
        _x.changedFields = changedFields.add("userExperienceAnalyticsMetricHistory");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagement");
        _x.userExperienceAnalyticsMetricHistory = userExperienceAnalyticsMetricHistory;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * userExperienceAnalyticsModelScores} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“User experience analytics model scores”</i>
     * 
     * @param userExperienceAnalyticsModelScores
     *            new value of {@code userExperienceAnalyticsModelScores} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code userExperienceAnalyticsModelScores} field changed
     */
    public DeviceManagement withUserExperienceAnalyticsModelScores(List<UserExperienceAnalyticsModelScores> userExperienceAnalyticsModelScores) {
        DeviceManagement _x = _copy();
        _x.changedFields = changedFields.add("userExperienceAnalyticsModelScores");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagement");
        _x.userExperienceAnalyticsModelScores = userExperienceAnalyticsModelScores;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * userExperienceAnalyticsNotAutopilotReadyDevice} field changed. Field description
     * below. The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“User experience analytics devices not Windows Autopilot ready.”</i>
     * 
     * @param userExperienceAnalyticsNotAutopilotReadyDevice
     *            new value of {@code userExperienceAnalyticsNotAutopilotReadyDevice} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code userExperienceAnalyticsNotAutopilotReadyDevice} field changed
     */
    public DeviceManagement withUserExperienceAnalyticsNotAutopilotReadyDevice(List<UserExperienceAnalyticsNotAutopilotReadyDevice> userExperienceAnalyticsNotAutopilotReadyDevice) {
        DeviceManagement _x = _copy();
        _x.changedFields = changedFields.add("userExperienceAnalyticsNotAutopilotReadyDevice");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagement");
        _x.userExperienceAnalyticsNotAutopilotReadyDevice = userExperienceAnalyticsNotAutopilotReadyDevice;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * userExperienceAnalyticsOverview} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“User experience analytics overview”</i>
     * 
     * @param userExperienceAnalyticsOverview
     *            new value of {@code userExperienceAnalyticsOverview} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code userExperienceAnalyticsOverview} field changed
     */
    public DeviceManagement withUserExperienceAnalyticsOverview(UserExperienceAnalyticsOverview userExperienceAnalyticsOverview) {
        DeviceManagement _x = _copy();
        _x.changedFields = changedFields.add("userExperienceAnalyticsOverview");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagement");
        _x.userExperienceAnalyticsOverview = userExperienceAnalyticsOverview;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * userExperienceAnalyticsRegressionSummary} field changed. Field description below
     * . The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“User experience analytics regression summary”</i>
     * 
     * @param userExperienceAnalyticsRegressionSummary
     *            new value of {@code userExperienceAnalyticsRegressionSummary} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code userExperienceAnalyticsRegressionSummary} field changed
     */
    public DeviceManagement withUserExperienceAnalyticsRegressionSummary(UserExperienceAnalyticsRegressionSummary userExperienceAnalyticsRegressionSummary) {
        DeviceManagement _x = _copy();
        _x.changedFields = changedFields.add("userExperienceAnalyticsRegressionSummary");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagement");
        _x.userExperienceAnalyticsRegressionSummary = userExperienceAnalyticsRegressionSummary;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * userExperienceAnalyticsRemoteConnection} field changed. Field description below.
     * The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“User experience analytics remote connection”</i>
     * 
     * @param userExperienceAnalyticsRemoteConnection
     *            new value of {@code userExperienceAnalyticsRemoteConnection} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code userExperienceAnalyticsRemoteConnection} field changed
     */
    public DeviceManagement withUserExperienceAnalyticsRemoteConnection(List<UserExperienceAnalyticsRemoteConnection> userExperienceAnalyticsRemoteConnection) {
        DeviceManagement _x = _copy();
        _x.changedFields = changedFields.add("userExperienceAnalyticsRemoteConnection");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagement");
        _x.userExperienceAnalyticsRemoteConnection = userExperienceAnalyticsRemoteConnection;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * userExperienceAnalyticsResourcePerformance} field changed. Field description
     * below. The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“User experience analytics resource performance”</i>
     * 
     * @param userExperienceAnalyticsResourcePerformance
     *            new value of {@code userExperienceAnalyticsResourcePerformance} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code userExperienceAnalyticsResourcePerformance} field changed
     */
    public DeviceManagement withUserExperienceAnalyticsResourcePerformance(List<UserExperienceAnalyticsResourcePerformance> userExperienceAnalyticsResourcePerformance) {
        DeviceManagement _x = _copy();
        _x.changedFields = changedFields.add("userExperienceAnalyticsResourcePerformance");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagement");
        _x.userExperienceAnalyticsResourcePerformance = userExperienceAnalyticsResourcePerformance;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * userExperienceAnalyticsScoreHistory} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“User experience analytics device Startup Score History”</i>
     * 
     * @param userExperienceAnalyticsScoreHistory
     *            new value of {@code userExperienceAnalyticsScoreHistory} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code userExperienceAnalyticsScoreHistory} field changed
     */
    public DeviceManagement withUserExperienceAnalyticsScoreHistory(List<UserExperienceAnalyticsScoreHistory> userExperienceAnalyticsScoreHistory) {
        DeviceManagement _x = _copy();
        _x.changedFields = changedFields.add("userExperienceAnalyticsScoreHistory");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagement");
        _x.userExperienceAnalyticsScoreHistory = userExperienceAnalyticsScoreHistory;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * userExperienceAnalyticsWorkFromAnywhereHardwareReadinessMetric} field changed.
     * Field description below. The field name is also added to an internal map of
     * changed fields in the returned object so that when {@code this.patch()} is
     * called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“User experience analytics work from anywhere hardware readiness metrics.”</i>
     * 
     * @param userExperienceAnalyticsWorkFromAnywhereHardwareReadinessMetric
     *            new value of {@code userExperienceAnalyticsWorkFromAnywhereHardwareReadinessMetric} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code userExperienceAnalyticsWorkFromAnywhereHardwareReadinessMetric} field changed
     */
    public DeviceManagement withUserExperienceAnalyticsWorkFromAnywhereHardwareReadinessMetric(UserExperienceAnalyticsWorkFromAnywhereHardwareReadinessMetric userExperienceAnalyticsWorkFromAnywhereHardwareReadinessMetric) {
        DeviceManagement _x = _copy();
        _x.changedFields = changedFields.add("userExperienceAnalyticsWorkFromAnywhereHardwareReadinessMetric");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagement");
        _x.userExperienceAnalyticsWorkFromAnywhereHardwareReadinessMetric = userExperienceAnalyticsWorkFromAnywhereHardwareReadinessMetric;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * userExperienceAnalyticsWorkFromAnywhereMetrics} field changed. Field description
     * below. The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“User experience analytics work from anywhere metrics.”</i>
     * 
     * @param userExperienceAnalyticsWorkFromAnywhereMetrics
     *            new value of {@code userExperienceAnalyticsWorkFromAnywhereMetrics} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code userExperienceAnalyticsWorkFromAnywhereMetrics} field changed
     */
    public DeviceManagement withUserExperienceAnalyticsWorkFromAnywhereMetrics(List<UserExperienceAnalyticsWorkFromAnywhereMetric> userExperienceAnalyticsWorkFromAnywhereMetrics) {
        DeviceManagement _x = _copy();
        _x.changedFields = changedFields.add("userExperienceAnalyticsWorkFromAnywhereMetrics");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagement");
        _x.userExperienceAnalyticsWorkFromAnywhereMetrics = userExperienceAnalyticsWorkFromAnywhereMetrics;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * userExperienceAnalyticsWorkFromAnywhereModelPerformance} field changed. Field
     * description below. The field name is also added to an internal map of changed
     * fields in the returned object so that when {@code this.patch()} is called (if
     * available)on the returned object only the changed fields are submitted.
     * <p>
     * <i>“The user experience analytics work from anywhere model performance”</i>
     * 
     * @param userExperienceAnalyticsWorkFromAnywhereModelPerformance
     *            new value of {@code userExperienceAnalyticsWorkFromAnywhereModelPerformance} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code userExperienceAnalyticsWorkFromAnywhereModelPerformance} field changed
     */
    public DeviceManagement withUserExperienceAnalyticsWorkFromAnywhereModelPerformance(List<UserExperienceAnalyticsWorkFromAnywhereModelPerformance> userExperienceAnalyticsWorkFromAnywhereModelPerformance) {
        DeviceManagement _x = _copy();
        _x.changedFields = changedFields.add("userExperienceAnalyticsWorkFromAnywhereModelPerformance");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagement");
        _x.userExperienceAnalyticsWorkFromAnywhereModelPerformance = userExperienceAnalyticsWorkFromAnywhereModelPerformance;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * windowsMalwareInformation} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“The list of affected malware in the tenant.”</i>
     * 
     * @param windowsMalwareInformation
     *            new value of {@code windowsMalwareInformation} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code windowsMalwareInformation} field changed
     */
    public DeviceManagement withWindowsMalwareInformation(List<WindowsMalwareInformation> windowsMalwareInformation) {
        DeviceManagement _x = _copy();
        _x.changedFields = changedFields.add("windowsMalwareInformation");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagement");
        _x.windowsMalwareInformation = windowsMalwareInformation;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * derivedCredentials} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Collection of Derived credential settings associated with account.”</i>
     * 
     * @param derivedCredentials
     *            new value of {@code derivedCredentials} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code derivedCredentials} field changed
     */
    public DeviceManagement withDerivedCredentials(List<DeviceManagementDerivedCredentialSettings> derivedCredentials) {
        DeviceManagement _x = _copy();
        _x.changedFields = changedFields.add("derivedCredentials");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagement");
        _x.derivedCredentials = derivedCredentials;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * resourceAccessProfiles} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Collection of resource access settings associated with account.”</i>
     * 
     * @param resourceAccessProfiles
     *            new value of {@code resourceAccessProfiles} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code resourceAccessProfiles} field changed
     */
    public DeviceManagement withResourceAccessProfiles(List<DeviceManagementResourceAccessProfileBase> resourceAccessProfiles) {
        DeviceManagement _x = _copy();
        _x.changedFields = changedFields.add("resourceAccessProfiles");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagement");
        _x.resourceAccessProfiles = resourceAccessProfiles;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * appleUserInitiatedEnrollmentProfiles} field changed. Field description below.
     * The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Apple user initiated enrollment profiles”</i>
     * 
     * @param appleUserInitiatedEnrollmentProfiles
     *            new value of {@code appleUserInitiatedEnrollmentProfiles} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code appleUserInitiatedEnrollmentProfiles} field changed
     */
    public DeviceManagement withAppleUserInitiatedEnrollmentProfiles(List<AppleUserInitiatedEnrollmentProfile> appleUserInitiatedEnrollmentProfiles) {
        DeviceManagement _x = _copy();
        _x.changedFields = changedFields.add("appleUserInitiatedEnrollmentProfiles");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagement");
        _x.appleUserInitiatedEnrollmentProfiles = appleUserInitiatedEnrollmentProfiles;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * depOnboardingSettings} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“This collections of multiple DEP tokens per-tenant.”</i>
     * 
     * @param depOnboardingSettings
     *            new value of {@code depOnboardingSettings} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code depOnboardingSettings} field changed
     */
    public DeviceManagement withDepOnboardingSettings(List<DepOnboardingSetting> depOnboardingSettings) {
        DeviceManagement _x = _copy();
        _x.changedFields = changedFields.add("depOnboardingSettings");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagement");
        _x.depOnboardingSettings = depOnboardingSettings;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * importedDeviceIdentities} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“The imported device identities.”</i>
     * 
     * @param importedDeviceIdentities
     *            new value of {@code importedDeviceIdentities} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code importedDeviceIdentities} field changed
     */
    public DeviceManagement withImportedDeviceIdentities(List<ImportedDeviceIdentity> importedDeviceIdentities) {
        DeviceManagement _x = _copy();
        _x.changedFields = changedFields.add("importedDeviceIdentities");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagement");
        _x.importedDeviceIdentities = importedDeviceIdentities;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * importedWindowsAutopilotDeviceIdentities} field changed. Field description below
     * . The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Collection of imported Windows autopilot devices.”</i>
     * 
     * @param importedWindowsAutopilotDeviceIdentities
     *            new value of {@code importedWindowsAutopilotDeviceIdentities} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code importedWindowsAutopilotDeviceIdentities} field changed
     */
    public DeviceManagement withImportedWindowsAutopilotDeviceIdentities(List<ImportedWindowsAutopilotDeviceIdentity> importedWindowsAutopilotDeviceIdentities) {
        DeviceManagement _x = _copy();
        _x.changedFields = changedFields.add("importedWindowsAutopilotDeviceIdentities");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagement");
        _x.importedWindowsAutopilotDeviceIdentities = importedWindowsAutopilotDeviceIdentities;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * windowsAutopilotDeploymentProfiles} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Windows auto pilot deployment profiles”</i>
     * 
     * @param windowsAutopilotDeploymentProfiles
     *            new value of {@code windowsAutopilotDeploymentProfiles} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code windowsAutopilotDeploymentProfiles} field changed
     */
    public DeviceManagement withWindowsAutopilotDeploymentProfiles(List<WindowsAutopilotDeploymentProfile> windowsAutopilotDeploymentProfiles) {
        DeviceManagement _x = _copy();
        _x.changedFields = changedFields.add("windowsAutopilotDeploymentProfiles");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagement");
        _x.windowsAutopilotDeploymentProfiles = windowsAutopilotDeploymentProfiles;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * windowsAutopilotDeviceIdentities} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“The Windows autopilot device identities contained collection.”</i>
     * 
     * @param windowsAutopilotDeviceIdentities
     *            new value of {@code windowsAutopilotDeviceIdentities} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code windowsAutopilotDeviceIdentities} field changed
     */
    public DeviceManagement withWindowsAutopilotDeviceIdentities(List<WindowsAutopilotDeviceIdentity> windowsAutopilotDeviceIdentities) {
        DeviceManagement _x = _copy();
        _x.changedFields = changedFields.add("windowsAutopilotDeviceIdentities");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagement");
        _x.windowsAutopilotDeviceIdentities = windowsAutopilotDeviceIdentities;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * windowsAutopilotSettings} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“The Windows autopilot account settings.”</i>
     * 
     * @param windowsAutopilotSettings
     *            new value of {@code windowsAutopilotSettings} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code windowsAutopilotSettings} field changed
     */
    public DeviceManagement withWindowsAutopilotSettings(WindowsAutopilotSettings windowsAutopilotSettings) {
        DeviceManagement _x = _copy();
        _x.changedFields = changedFields.add("windowsAutopilotSettings");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagement");
        _x.windowsAutopilotSettings = windowsAutopilotSettings;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * managementConditions} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The management conditions associated with device management of the company.”</i>
     * 
     * @param managementConditions
     *            new value of {@code managementConditions} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code managementConditions} field changed
     */
    public DeviceManagement withManagementConditions(List<ManagementCondition> managementConditions) {
        DeviceManagement _x = _copy();
        _x.changedFields = changedFields.add("managementConditions");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagement");
        _x.managementConditions = managementConditions;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * managementConditionStatements} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“The management condition statements associated with device management of the
     * company.”</i>
     * 
     * @param managementConditionStatements
     *            new value of {@code managementConditionStatements} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code managementConditionStatements} field changed
     */
    public DeviceManagement withManagementConditionStatements(List<ManagementConditionStatement> managementConditionStatements) {
        DeviceManagement _x = _copy();
        _x.changedFields = changedFields.add("managementConditionStatements");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagement");
        _x.managementConditionStatements = managementConditionStatements;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * groupPolicyMigrationReports} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“A list of Group Policy migration reports.”</i>
     * 
     * @param groupPolicyMigrationReports
     *            new value of {@code groupPolicyMigrationReports} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code groupPolicyMigrationReports} field changed
     */
    public DeviceManagement withGroupPolicyMigrationReports(List<GroupPolicyMigrationReport> groupPolicyMigrationReports) {
        DeviceManagement _x = _copy();
        _x.changedFields = changedFields.add("groupPolicyMigrationReports");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagement");
        _x.groupPolicyMigrationReports = groupPolicyMigrationReports;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * groupPolicyObjectFiles} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“A list of Group Policy Object files uploaded.”</i>
     * 
     * @param groupPolicyObjectFiles
     *            new value of {@code groupPolicyObjectFiles} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code groupPolicyObjectFiles} field changed
     */
    public DeviceManagement withGroupPolicyObjectFiles(List<GroupPolicyObjectFile> groupPolicyObjectFiles) {
        DeviceManagement _x = _copy();
        _x.changedFields = changedFields.add("groupPolicyObjectFiles");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagement");
        _x.groupPolicyObjectFiles = groupPolicyObjectFiles;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * groupPolicyCategories} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The available group policy categories for this account.”</i>
     * 
     * @param groupPolicyCategories
     *            new value of {@code groupPolicyCategories} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code groupPolicyCategories} field changed
     */
    public DeviceManagement withGroupPolicyCategories(List<GroupPolicyCategory> groupPolicyCategories) {
        DeviceManagement _x = _copy();
        _x.changedFields = changedFields.add("groupPolicyCategories");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagement");
        _x.groupPolicyCategories = groupPolicyCategories;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * groupPolicyConfigurations} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“The group policy configurations created by this account.”</i>
     * 
     * @param groupPolicyConfigurations
     *            new value of {@code groupPolicyConfigurations} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code groupPolicyConfigurations} field changed
     */
    public DeviceManagement withGroupPolicyConfigurations(List<GroupPolicyConfiguration> groupPolicyConfigurations) {
        DeviceManagement _x = _copy();
        _x.changedFields = changedFields.add("groupPolicyConfigurations");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagement");
        _x.groupPolicyConfigurations = groupPolicyConfigurations;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * groupPolicyDefinitionFiles} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“The available group policy definition files for this account.”</i>
     * 
     * @param groupPolicyDefinitionFiles
     *            new value of {@code groupPolicyDefinitionFiles} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code groupPolicyDefinitionFiles} field changed
     */
    public DeviceManagement withGroupPolicyDefinitionFiles(List<GroupPolicyDefinitionFile> groupPolicyDefinitionFiles) {
        DeviceManagement _x = _copy();
        _x.changedFields = changedFields.add("groupPolicyDefinitionFiles");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagement");
        _x.groupPolicyDefinitionFiles = groupPolicyDefinitionFiles;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * groupPolicyDefinitions} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“The available group policy definitions for this account.”</i>
     * 
     * @param groupPolicyDefinitions
     *            new value of {@code groupPolicyDefinitions} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code groupPolicyDefinitions} field changed
     */
    public DeviceManagement withGroupPolicyDefinitions(List<GroupPolicyDefinition> groupPolicyDefinitions) {
        DeviceManagement _x = _copy();
        _x.changedFields = changedFields.add("groupPolicyDefinitions");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagement");
        _x.groupPolicyDefinitions = groupPolicyDefinitions;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * groupPolicyUploadedDefinitionFiles} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“The available group policy uploaded definition files for this account.”</i>
     * 
     * @param groupPolicyUploadedDefinitionFiles
     *            new value of {@code groupPolicyUploadedDefinitionFiles} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code groupPolicyUploadedDefinitionFiles} field changed
     */
    public DeviceManagement withGroupPolicyUploadedDefinitionFiles(List<GroupPolicyUploadedDefinitionFile> groupPolicyUploadedDefinitionFiles) {
        DeviceManagement _x = _copy();
        _x.changedFields = changedFields.add("groupPolicyUploadedDefinitionFiles");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagement");
        _x.groupPolicyUploadedDefinitionFiles = groupPolicyUploadedDefinitionFiles;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * microsoftTunnelConfigurations} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Collection of MicrosoftTunnelConfiguration settings associated with account.”</i>
     * 
     * @param microsoftTunnelConfigurations
     *            new value of {@code microsoftTunnelConfigurations} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code microsoftTunnelConfigurations} field changed
     */
    public DeviceManagement withMicrosoftTunnelConfigurations(List<MicrosoftTunnelConfiguration> microsoftTunnelConfigurations) {
        DeviceManagement _x = _copy();
        _x.changedFields = changedFields.add("microsoftTunnelConfigurations");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagement");
        _x.microsoftTunnelConfigurations = microsoftTunnelConfigurations;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * microsoftTunnelHealthThresholds} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Collection of MicrosoftTunnelHealthThreshold settings associated with account.”</i>
     * 
     * @param microsoftTunnelHealthThresholds
     *            new value of {@code microsoftTunnelHealthThresholds} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code microsoftTunnelHealthThresholds} field changed
     */
    public DeviceManagement withMicrosoftTunnelHealthThresholds(List<MicrosoftTunnelHealthThreshold> microsoftTunnelHealthThresholds) {
        DeviceManagement _x = _copy();
        _x.changedFields = changedFields.add("microsoftTunnelHealthThresholds");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagement");
        _x.microsoftTunnelHealthThresholds = microsoftTunnelHealthThresholds;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * microsoftTunnelServerLogCollectionResponses} field changed. Field description
     * below. The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Collection of MicrosoftTunnelServerLogCollectionResponse settings associated
     * with account.”</i>
     * 
     * @param microsoftTunnelServerLogCollectionResponses
     *            new value of {@code microsoftTunnelServerLogCollectionResponses} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code microsoftTunnelServerLogCollectionResponses} field changed
     */
    public DeviceManagement withMicrosoftTunnelServerLogCollectionResponses(List<MicrosoftTunnelServerLogCollectionResponse> microsoftTunnelServerLogCollectionResponses) {
        DeviceManagement _x = _copy();
        _x.changedFields = changedFields.add("microsoftTunnelServerLogCollectionResponses");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagement");
        _x.microsoftTunnelServerLogCollectionResponses = microsoftTunnelServerLogCollectionResponses;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * microsoftTunnelSites} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Collection of MicrosoftTunnelSite settings associated with account.”</i>
     * 
     * @param microsoftTunnelSites
     *            new value of {@code microsoftTunnelSites} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code microsoftTunnelSites} field changed
     */
    public DeviceManagement withMicrosoftTunnelSites(List<MicrosoftTunnelSite> microsoftTunnelSites) {
        DeviceManagement _x = _copy();
        _x.changedFields = changedFields.add("microsoftTunnelSites");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagement");
        _x.microsoftTunnelSites = microsoftTunnelSites;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * notificationMessageTemplates} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“The Notification Message Templates.”</i>
     * 
     * @param notificationMessageTemplates
     *            new value of {@code notificationMessageTemplates} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code notificationMessageTemplates} field changed
     */
    public DeviceManagement withNotificationMessageTemplates(List<NotificationMessageTemplate> notificationMessageTemplates) {
        DeviceManagement _x = _copy();
        _x.changedFields = changedFields.add("notificationMessageTemplates");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagement");
        _x.notificationMessageTemplates = notificationMessageTemplates;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * domainJoinConnectors} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“A list of connector objects.”</i>
     * 
     * @param domainJoinConnectors
     *            new value of {@code domainJoinConnectors} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code domainJoinConnectors} field changed
     */
    public DeviceManagement withDomainJoinConnectors(List<DeviceManagementDomainJoinConnector> domainJoinConnectors) {
        DeviceManagement _x = _copy();
        _x.changedFields = changedFields.add("domainJoinConnectors");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagement");
        _x.domainJoinConnectors = domainJoinConnectors;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * configManagerCollections} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“A list of ConfigManagerCollection”</i>
     * 
     * @param configManagerCollections
     *            new value of {@code configManagerCollections} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code configManagerCollections} field changed
     */
    public DeviceManagement withConfigManagerCollections(List<ConfigManagerCollection> configManagerCollections) {
        DeviceManagement _x = _copy();
        _x.changedFields = changedFields.add("configManagerCollections");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagement");
        _x.configManagerCollections = configManagerCollections;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * resourceOperations} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The Resource Operations.”</i>
     * 
     * @param resourceOperations
     *            new value of {@code resourceOperations} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code resourceOperations} field changed
     */
    public DeviceManagement withResourceOperations(List<ResourceOperation> resourceOperations) {
        DeviceManagement _x = _copy();
        _x.changedFields = changedFields.add("resourceOperations");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagement");
        _x.resourceOperations = resourceOperations;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code roleAssignments}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The Role Assignments.”</i>
     * 
     * @param roleAssignments
     *            new value of {@code roleAssignments} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code roleAssignments} field changed
     */
    public DeviceManagement withRoleAssignments(List<DeviceAndAppManagementRoleAssignment> roleAssignments) {
        DeviceManagement _x = _copy();
        _x.changedFields = changedFields.add("roleAssignments");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagement");
        _x.roleAssignments = roleAssignments;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code roleDefinitions}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The Role Definitions.”</i>
     * 
     * @param roleDefinitions
     *            new value of {@code roleDefinitions} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code roleDefinitions} field changed
     */
    public DeviceManagement withRoleDefinitions(List<RoleDefinition> roleDefinitions) {
        DeviceManagement _x = _copy();
        _x.changedFields = changedFields.add("roleDefinitions");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagement");
        _x.roleDefinitions = roleDefinitions;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code roleScopeTags}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The Role Scope Tags.”</i>
     * 
     * @param roleScopeTags
     *            new value of {@code roleScopeTags} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code roleScopeTags} field changed
     */
    public DeviceManagement withRoleScopeTags(List<RoleScopeTag> roleScopeTags) {
        DeviceManagement _x = _copy();
        _x.changedFields = changedFields.add("roleScopeTags");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagement");
        _x.roleScopeTags = roleScopeTags;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * remoteAssistancePartners} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“The remote assist partners.”</i>
     * 
     * @param remoteAssistancePartners
     *            new value of {@code remoteAssistancePartners} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code remoteAssistancePartners} field changed
     */
    public DeviceManagement withRemoteAssistancePartners(List<RemoteAssistancePartner> remoteAssistancePartners) {
        DeviceManagement _x = _copy();
        _x.changedFields = changedFields.add("remoteAssistancePartners");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagement");
        _x.remoteAssistancePartners = remoteAssistancePartners;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * remoteAssistanceSettings} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“The remote assistance settings singleton”</i>
     * 
     * @param remoteAssistanceSettings
     *            new value of {@code remoteAssistanceSettings} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code remoteAssistanceSettings} field changed
     */
    public DeviceManagement withRemoteAssistanceSettings(RemoteAssistanceSettings remoteAssistanceSettings) {
        DeviceManagement _x = _copy();
        _x.changedFields = changedFields.add("remoteAssistanceSettings");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagement");
        _x.remoteAssistanceSettings = remoteAssistanceSettings;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code reports} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Reports singleton”</i>
     * 
     * @param reports
     *            new value of {@code reports} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code reports} field changed
     */
    public DeviceManagement withReports(DeviceManagementReports reports) {
        DeviceManagement _x = _copy();
        _x.changedFields = changedFields.add("reports");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagement");
        _x.reports = reports;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * embeddedSIMActivationCodePools} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“The embedded SIM activation code pools created by this account.”</i>
     * 
     * @param embeddedSIMActivationCodePools
     *            new value of {@code embeddedSIMActivationCodePools} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code embeddedSIMActivationCodePools} field changed
     */
    public DeviceManagement withEmbeddedSIMActivationCodePools(List<EmbeddedSIMActivationCodePool> embeddedSIMActivationCodePools) {
        DeviceManagement _x = _copy();
        _x.changedFields = changedFields.add("embeddedSIMActivationCodePools");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagement");
        _x.embeddedSIMActivationCodePools = embeddedSIMActivationCodePools;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * telecomExpenseManagementPartners} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“The telecom expense management partners.”</i>
     * 
     * @param telecomExpenseManagementPartners
     *            new value of {@code telecomExpenseManagementPartners} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code telecomExpenseManagementPartners} field changed
     */
    public DeviceManagement withTelecomExpenseManagementPartners(List<TelecomExpenseManagementPartner> telecomExpenseManagementPartners) {
        DeviceManagement _x = _copy();
        _x.changedFields = changedFields.add("telecomExpenseManagementPartners");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagement");
        _x.telecomExpenseManagementPartners = telecomExpenseManagementPartners;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code autopilotEvents}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The list of autopilot events for the tenant.”</i>
     * 
     * @param autopilotEvents
     *            new value of {@code autopilotEvents} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code autopilotEvents} field changed
     */
    public DeviceManagement withAutopilotEvents(List<DeviceManagementAutopilotEvent> autopilotEvents) {
        DeviceManagement _x = _copy();
        _x.changedFields = changedFields.add("autopilotEvents");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagement");
        _x.autopilotEvents = autopilotEvents;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * troubleshootingEvents} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The list of troubleshooting events for the tenant.”</i>
     * 
     * @param troubleshootingEvents
     *            new value of {@code troubleshootingEvents} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code troubleshootingEvents} field changed
     */
    public DeviceManagement withTroubleshootingEvents(List<DeviceManagementTroubleshootingEvent> troubleshootingEvents) {
        DeviceManagement _x = _copy();
        _x.changedFields = changedFields.add("troubleshootingEvents");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagement");
        _x.troubleshootingEvents = troubleshootingEvents;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * windowsDriverUpdateProfiles} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“A collection of windows driver update profiles”</i>
     * 
     * @param windowsDriverUpdateProfiles
     *            new value of {@code windowsDriverUpdateProfiles} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code windowsDriverUpdateProfiles} field changed
     */
    public DeviceManagement withWindowsDriverUpdateProfiles(List<WindowsDriverUpdateProfile> windowsDriverUpdateProfiles) {
        DeviceManagement _x = _copy();
        _x.changedFields = changedFields.add("windowsDriverUpdateProfiles");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagement");
        _x.windowsDriverUpdateProfiles = windowsDriverUpdateProfiles;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * windowsFeatureUpdateProfiles} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“A collection of windows feature update profiles”</i>
     * 
     * @param windowsFeatureUpdateProfiles
     *            new value of {@code windowsFeatureUpdateProfiles} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code windowsFeatureUpdateProfiles} field changed
     */
    public DeviceManagement withWindowsFeatureUpdateProfiles(List<WindowsFeatureUpdateProfile> windowsFeatureUpdateProfiles) {
        DeviceManagement _x = _copy();
        _x.changedFields = changedFields.add("windowsFeatureUpdateProfiles");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagement");
        _x.windowsFeatureUpdateProfiles = windowsFeatureUpdateProfiles;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * windowsQualityUpdateProfiles} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“A collection of windows quality update profiles”</i>
     * 
     * @param windowsQualityUpdateProfiles
     *            new value of {@code windowsQualityUpdateProfiles} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code windowsQualityUpdateProfiles} field changed
     */
    public DeviceManagement withWindowsQualityUpdateProfiles(List<WindowsQualityUpdateProfile> windowsQualityUpdateProfiles) {
        DeviceManagement _x = _copy();
        _x.changedFields = changedFields.add("windowsQualityUpdateProfiles");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagement");
        _x.windowsQualityUpdateProfiles = windowsQualityUpdateProfiles;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * windowsUpdateCatalogItems} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“A collection of windows update catalog items (fetaure updates item , quality
     * updates item)”</i>
     * 
     * @param windowsUpdateCatalogItems
     *            new value of {@code windowsUpdateCatalogItems} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code windowsUpdateCatalogItems} field changed
     */
    public DeviceManagement withWindowsUpdateCatalogItems(List<WindowsUpdateCatalogItem> windowsUpdateCatalogItems) {
        DeviceManagement _x = _copy();
        _x.changedFields = changedFields.add("windowsUpdateCatalogItems");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagement");
        _x.windowsUpdateCatalogItems = windowsUpdateCatalogItems;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * intuneBrandingProfiles} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Intune branding profiles targeted to AAD groups”</i>
     * 
     * @param intuneBrandingProfiles
     *            new value of {@code intuneBrandingProfiles} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code intuneBrandingProfiles} field changed
     */
    public DeviceManagement withIntuneBrandingProfiles(List<IntuneBrandingProfile> intuneBrandingProfiles) {
        DeviceManagement _x = _copy();
        _x.changedFields = changedFields.add("intuneBrandingProfiles");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagement");
        _x.intuneBrandingProfiles = intuneBrandingProfiles;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * windowsInformationProtectionAppLearningSummaries} field changed. Field
     * description below. The field name is also added to an internal map of changed
     * fields in the returned object so that when {@code this.patch()} is called (if
     * available)on the returned object only the changed fields are submitted.
     * <p>
     * <i>“The windows information protection app learning summaries.”</i>
     * 
     * @param windowsInformationProtectionAppLearningSummaries
     *            new value of {@code windowsInformationProtectionAppLearningSummaries} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code windowsInformationProtectionAppLearningSummaries} field changed
     */
    public DeviceManagement withWindowsInformationProtectionAppLearningSummaries(List<WindowsInformationProtectionAppLearningSummary> windowsInformationProtectionAppLearningSummaries) {
        DeviceManagement _x = _copy();
        _x.changedFields = changedFields.add("windowsInformationProtectionAppLearningSummaries");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagement");
        _x.windowsInformationProtectionAppLearningSummaries = windowsInformationProtectionAppLearningSummaries;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * windowsInformationProtectionNetworkLearningSummaries} field changed. Field
     * description below. The field name is also added to an internal map of changed
     * fields in the returned object so that when {@code this.patch()} is called (if
     * available)on the returned object only the changed fields are submitted.
     * <p>
     * <i>“The windows information protection network learning summaries.”</i>
     * 
     * @param windowsInformationProtectionNetworkLearningSummaries
     *            new value of {@code windowsInformationProtectionNetworkLearningSummaries} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code windowsInformationProtectionNetworkLearningSummaries} field changed
     */
    public DeviceManagement withWindowsInformationProtectionNetworkLearningSummaries(List<WindowsInformationProtectionNetworkLearningSummary> windowsInformationProtectionNetworkLearningSummaries) {
        DeviceManagement _x = _copy();
        _x.changedFields = changedFields.add("windowsInformationProtectionNetworkLearningSummaries");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagement");
        _x.windowsInformationProtectionNetworkLearningSummaries = windowsInformationProtectionNetworkLearningSummaries;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * certificateConnectorDetails} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Collection of certificate connector details, each associated with a
     * corresponding Intune Certificate Connector.”</i>
     * 
     * @param certificateConnectorDetails
     *            new value of {@code certificateConnectorDetails} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code certificateConnectorDetails} field changed
     */
    public DeviceManagement withCertificateConnectorDetails(List<CertificateConnectorDetails> certificateConnectorDetails) {
        DeviceManagement _x = _copy();
        _x.changedFields = changedFields.add("certificateConnectorDetails");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagement");
        _x.certificateConnectorDetails = certificateConnectorDetails;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * userPfxCertificates} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Collection of PFX certificates associated with a user.”</i>
     * 
     * @param userPfxCertificates
     *            new value of {@code userPfxCertificates} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code userPfxCertificates} field changed
     */
    public DeviceManagement withUserPfxCertificates(List<UserPFXCertificate> userPfxCertificates) {
        DeviceManagement _x = _copy();
        _x.changedFields = changedFields.add("userPfxCertificates");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagement");
        _x.userPfxCertificates = userPfxCertificates;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DeviceManagement patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        DeviceManagement _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DeviceManagement put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        DeviceManagement _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private DeviceManagement _copy() {
        DeviceManagement _x = new DeviceManagement();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.deviceComplianceReportSummarizationDateTime = deviceComplianceReportSummarizationDateTime;
        _x.intuneAccountId = intuneAccountId;
        _x.lastReportAggregationDateTime = lastReportAggregationDateTime;
        _x.legacyPcManangementEnabled = legacyPcManangementEnabled;
        _x.maximumDepTokens = maximumDepTokens;
        _x.settings = settings;
        _x.unlicensedAdminstratorsEnabled = unlicensedAdminstratorsEnabled;
        _x.intuneBrand = intuneBrand;
        _x.accountMoveCompletionDateTime = accountMoveCompletionDateTime;
        _x.adminConsent = adminConsent;
        _x.deviceProtectionOverview = deviceProtectionOverview;
        _x.managedDeviceCleanupSettings = managedDeviceCleanupSettings;
        _x.subscriptions = subscriptions;
        _x.subscriptionState = subscriptionState;
        _x.userExperienceAnalyticsSettings = userExperienceAnalyticsSettings;
        _x.windowsMalwareOverview = windowsMalwareOverview;
        _x.androidDeviceOwnerEnrollmentProfiles = androidDeviceOwnerEnrollmentProfiles;
        _x.virtualEndpoint = virtualEndpoint;
        _x.androidForWorkAppConfigurationSchemas = androidForWorkAppConfigurationSchemas;
        _x.androidForWorkEnrollmentProfiles = androidForWorkEnrollmentProfiles;
        _x.androidForWorkSettings = androidForWorkSettings;
        _x.androidManagedStoreAccountEnterpriseSettings = androidManagedStoreAccountEnterpriseSettings;
        _x.androidManagedStoreAppConfigurationSchemas = androidManagedStoreAppConfigurationSchemas;
        _x.auditEvents = auditEvents;
        _x.assignmentFilters = assignmentFilters;
        _x.chromeOSOnboardingSettings = chromeOSOnboardingSettings;
        _x.termsAndConditions = termsAndConditions;
        _x.advancedThreatProtectionOnboardingStateSummary = advancedThreatProtectionOnboardingStateSummary;
        _x.cartToClassAssociations = cartToClassAssociations;
        _x.deviceCompliancePolicies = deviceCompliancePolicies;
        _x.deviceCompliancePolicyDeviceStateSummary = deviceCompliancePolicyDeviceStateSummary;
        _x.deviceCompliancePolicySettingStateSummaries = deviceCompliancePolicySettingStateSummaries;
        _x.deviceConfigurationConflictSummary = deviceConfigurationConflictSummary;
        _x.deviceConfigurationDeviceStateSummaries = deviceConfigurationDeviceStateSummaries;
        _x.deviceConfigurationRestrictedAppsViolations = deviceConfigurationRestrictedAppsViolations;
        _x.deviceConfigurations = deviceConfigurations;
        _x.deviceConfigurationsAllManagedDeviceCertificateStates = deviceConfigurationsAllManagedDeviceCertificateStates;
        _x.deviceConfigurationUserStateSummaries = deviceConfigurationUserStateSummaries;
        _x.iosUpdateStatuses = iosUpdateStatuses;
        _x.macOSSoftwareUpdateAccountSummaries = macOSSoftwareUpdateAccountSummaries;
        _x.managedDeviceEncryptionStates = managedDeviceEncryptionStates;
        _x.ndesConnectors = ndesConnectors;
        _x.complianceCategories = complianceCategories;
        _x.compliancePolicies = compliancePolicies;
        _x.complianceSettings = complianceSettings;
        _x.configurationCategories = configurationCategories;
        _x.configurationPolicies = configurationPolicies;
        _x.configurationPolicyTemplates = configurationPolicyTemplates;
        _x.configurationSettings = configurationSettings;
        _x.reusablePolicySettings = reusablePolicySettings;
        _x.reusableSettings = reusableSettings;
        _x.templateSettings = templateSettings;
        _x.complianceManagementPartners = complianceManagementPartners;
        _x.conditionalAccessSettings = conditionalAccessSettings;
        _x.deviceCategories = deviceCategories;
        _x.deviceEnrollmentConfigurations = deviceEnrollmentConfigurations;
        _x.deviceManagementPartners = deviceManagementPartners;
        _x.exchangeConnectors = exchangeConnectors;
        _x.exchangeOnPremisesPolicies = exchangeOnPremisesPolicies;
        _x.exchangeOnPremisesPolicy = exchangeOnPremisesPolicy;
        _x.mobileThreatDefenseConnectors = mobileThreatDefenseConnectors;
        _x.categories = categories;
        _x.intents = intents;
        _x.settingDefinitions = settingDefinitions;
        _x.templates = templates;
        _x.applePushNotificationCertificate = applePushNotificationCertificate;
        _x.cloudPCConnectivityIssues = cloudPCConnectivityIssues;
        _x.comanagedDevices = comanagedDevices;
        _x.comanagementEligibleDevices = comanagementEligibleDevices;
        _x.dataSharingConsents = dataSharingConsents;
        _x.detectedApps = detectedApps;
        _x.deviceComplianceScripts = deviceComplianceScripts;
        _x.deviceCustomAttributeShellScripts = deviceCustomAttributeShellScripts;
        _x.deviceHealthScripts = deviceHealthScripts;
        _x.deviceManagementScripts = deviceManagementScripts;
        _x.deviceShellScripts = deviceShellScripts;
        _x.managedDevices = managedDevices;
        _x.mobileAppTroubleshootingEvents = mobileAppTroubleshootingEvents;
        _x.oemWarrantyInformationOnboarding = oemWarrantyInformationOnboarding;
        _x.remoteActionAudits = remoteActionAudits;
        _x.userExperienceAnalyticsAppHealthApplicationPerformance = userExperienceAnalyticsAppHealthApplicationPerformance;
        _x.userExperienceAnalyticsAppHealthApplicationPerformanceByAppVersion = userExperienceAnalyticsAppHealthApplicationPerformanceByAppVersion;
        _x.userExperienceAnalyticsAppHealthApplicationPerformanceByAppVersionDetails = userExperienceAnalyticsAppHealthApplicationPerformanceByAppVersionDetails;
        _x.userExperienceAnalyticsAppHealthApplicationPerformanceByAppVersionDeviceId = userExperienceAnalyticsAppHealthApplicationPerformanceByAppVersionDeviceId;
        _x.userExperienceAnalyticsAppHealthApplicationPerformanceByOSVersion = userExperienceAnalyticsAppHealthApplicationPerformanceByOSVersion;
        _x.userExperienceAnalyticsAppHealthDeviceModelPerformance = userExperienceAnalyticsAppHealthDeviceModelPerformance;
        _x.userExperienceAnalyticsAppHealthDevicePerformance = userExperienceAnalyticsAppHealthDevicePerformance;
        _x.userExperienceAnalyticsAppHealthDevicePerformanceDetails = userExperienceAnalyticsAppHealthDevicePerformanceDetails;
        _x.userExperienceAnalyticsAppHealthOSVersionPerformance = userExperienceAnalyticsAppHealthOSVersionPerformance;
        _x.userExperienceAnalyticsAppHealthOverview = userExperienceAnalyticsAppHealthOverview;
        _x.userExperienceAnalyticsBaselines = userExperienceAnalyticsBaselines;
        _x.userExperienceAnalyticsBatteryHealthAppImpact = userExperienceAnalyticsBatteryHealthAppImpact;
        _x.userExperienceAnalyticsBatteryHealthCapacityDetails = userExperienceAnalyticsBatteryHealthCapacityDetails;
        _x.userExperienceAnalyticsBatteryHealthDeviceAppImpact = userExperienceAnalyticsBatteryHealthDeviceAppImpact;
        _x.userExperienceAnalyticsBatteryHealthDevicePerformance = userExperienceAnalyticsBatteryHealthDevicePerformance;
        _x.userExperienceAnalyticsBatteryHealthDeviceRuntimeHistory = userExperienceAnalyticsBatteryHealthDeviceRuntimeHistory;
        _x.userExperienceAnalyticsBatteryHealthModelPerformance = userExperienceAnalyticsBatteryHealthModelPerformance;
        _x.userExperienceAnalyticsBatteryHealthOsPerformance = userExperienceAnalyticsBatteryHealthOsPerformance;
        _x.userExperienceAnalyticsBatteryHealthRuntimeDetails = userExperienceAnalyticsBatteryHealthRuntimeDetails;
        _x.userExperienceAnalyticsCategories = userExperienceAnalyticsCategories;
        _x.userExperienceAnalyticsDeviceMetricHistory = userExperienceAnalyticsDeviceMetricHistory;
        _x.userExperienceAnalyticsDevicePerformance = userExperienceAnalyticsDevicePerformance;
        _x.userExperienceAnalyticsDeviceScores = userExperienceAnalyticsDeviceScores;
        _x.userExperienceAnalyticsDeviceStartupHistory = userExperienceAnalyticsDeviceStartupHistory;
        _x.userExperienceAnalyticsDeviceStartupProcesses = userExperienceAnalyticsDeviceStartupProcesses;
        _x.userExperienceAnalyticsDeviceStartupProcessPerformance = userExperienceAnalyticsDeviceStartupProcessPerformance;
        _x.userExperienceAnalyticsDevicesWithoutCloudIdentity = userExperienceAnalyticsDevicesWithoutCloudIdentity;
        _x.userExperienceAnalyticsImpactingProcess = userExperienceAnalyticsImpactingProcess;
        _x.userExperienceAnalyticsMetricHistory = userExperienceAnalyticsMetricHistory;
        _x.userExperienceAnalyticsModelScores = userExperienceAnalyticsModelScores;
        _x.userExperienceAnalyticsNotAutopilotReadyDevice = userExperienceAnalyticsNotAutopilotReadyDevice;
        _x.userExperienceAnalyticsOverview = userExperienceAnalyticsOverview;
        _x.userExperienceAnalyticsRegressionSummary = userExperienceAnalyticsRegressionSummary;
        _x.userExperienceAnalyticsRemoteConnection = userExperienceAnalyticsRemoteConnection;
        _x.userExperienceAnalyticsResourcePerformance = userExperienceAnalyticsResourcePerformance;
        _x.userExperienceAnalyticsScoreHistory = userExperienceAnalyticsScoreHistory;
        _x.userExperienceAnalyticsWorkFromAnywhereHardwareReadinessMetric = userExperienceAnalyticsWorkFromAnywhereHardwareReadinessMetric;
        _x.userExperienceAnalyticsWorkFromAnywhereMetrics = userExperienceAnalyticsWorkFromAnywhereMetrics;
        _x.userExperienceAnalyticsWorkFromAnywhereModelPerformance = userExperienceAnalyticsWorkFromAnywhereModelPerformance;
        _x.windowsMalwareInformation = windowsMalwareInformation;
        _x.derivedCredentials = derivedCredentials;
        _x.resourceAccessProfiles = resourceAccessProfiles;
        _x.appleUserInitiatedEnrollmentProfiles = appleUserInitiatedEnrollmentProfiles;
        _x.depOnboardingSettings = depOnboardingSettings;
        _x.importedDeviceIdentities = importedDeviceIdentities;
        _x.importedWindowsAutopilotDeviceIdentities = importedWindowsAutopilotDeviceIdentities;
        _x.windowsAutopilotDeploymentProfiles = windowsAutopilotDeploymentProfiles;
        _x.windowsAutopilotDeviceIdentities = windowsAutopilotDeviceIdentities;
        _x.windowsAutopilotSettings = windowsAutopilotSettings;
        _x.managementConditions = managementConditions;
        _x.managementConditionStatements = managementConditionStatements;
        _x.groupPolicyMigrationReports = groupPolicyMigrationReports;
        _x.groupPolicyObjectFiles = groupPolicyObjectFiles;
        _x.groupPolicyCategories = groupPolicyCategories;
        _x.groupPolicyConfigurations = groupPolicyConfigurations;
        _x.groupPolicyDefinitionFiles = groupPolicyDefinitionFiles;
        _x.groupPolicyDefinitions = groupPolicyDefinitions;
        _x.groupPolicyUploadedDefinitionFiles = groupPolicyUploadedDefinitionFiles;
        _x.microsoftTunnelConfigurations = microsoftTunnelConfigurations;
        _x.microsoftTunnelHealthThresholds = microsoftTunnelHealthThresholds;
        _x.microsoftTunnelServerLogCollectionResponses = microsoftTunnelServerLogCollectionResponses;
        _x.microsoftTunnelSites = microsoftTunnelSites;
        _x.notificationMessageTemplates = notificationMessageTemplates;
        _x.domainJoinConnectors = domainJoinConnectors;
        _x.configManagerCollections = configManagerCollections;
        _x.resourceOperations = resourceOperations;
        _x.roleAssignments = roleAssignments;
        _x.roleDefinitions = roleDefinitions;
        _x.roleScopeTags = roleScopeTags;
        _x.remoteAssistancePartners = remoteAssistancePartners;
        _x.remoteAssistanceSettings = remoteAssistanceSettings;
        _x.reports = reports;
        _x.embeddedSIMActivationCodePools = embeddedSIMActivationCodePools;
        _x.telecomExpenseManagementPartners = telecomExpenseManagementPartners;
        _x.autopilotEvents = autopilotEvents;
        _x.troubleshootingEvents = troubleshootingEvents;
        _x.windowsDriverUpdateProfiles = windowsDriverUpdateProfiles;
        _x.windowsFeatureUpdateProfiles = windowsFeatureUpdateProfiles;
        _x.windowsQualityUpdateProfiles = windowsQualityUpdateProfiles;
        _x.windowsUpdateCatalogItems = windowsUpdateCatalogItems;
        _x.intuneBrandingProfiles = intuneBrandingProfiles;
        _x.windowsInformationProtectionAppLearningSummaries = windowsInformationProtectionAppLearningSummaries;
        _x.windowsInformationProtectionNetworkLearningSummaries = windowsInformationProtectionNetworkLearningSummaries;
        _x.certificateConnectorDetails = certificateConnectorDetails;
        _x.userPfxCertificates = userPfxCertificates;
        return _x;
    }

    @Action(name = "sendCustomNotificationToCompanyPortal")
    @JsonIgnore
    public ActionRequestNoReturn sendCustomNotificationToCompanyPortal(String notificationTitle, String notificationBody, List<String> groupsToNotify) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("notificationTitle", "Edm.String", Checks.checkIsAscii(notificationTitle))
            .put("notificationBody", "Edm.String", Checks.checkIsAscii(notificationBody))
            .put("groupsToNotify", "Collection(Edm.String)", Checks.checkIsAscii(groupsToNotify))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.sendCustomNotificationToCompanyPortal"), _parameters);
    }

    @Action(name = "evaluateAssignmentFilter")
    @JsonIgnore
    public FunctionRequestReturningStream evaluateAssignmentFilter(AssignmentFilterEvaluateRequest data) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("data", "microsoft.graph.assignmentFilterEvaluateRequest", data)
            .build();
        throw new UnsupportedOperationException("Actions that return a stream are not supported yet. If you want this raise an issue at the project home");
    }

    @Action(name = "getAssignmentFiltersStatusDetails")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<AssignmentFilterStatusDetails> getAssignmentFiltersStatusDetails(String managedDeviceId, String payloadId, String userId, List<String> assignmentFilterIds, Integer top, Integer skip) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("managedDeviceId", "Edm.String", Checks.checkIsAscii(managedDeviceId))
            .put("payloadId", "Edm.String", Checks.checkIsAscii(payloadId))
            .put("userId", "Edm.String", Checks.checkIsAscii(userId))
            .put("assignmentFilterIds", "Collection(Edm.String)", Checks.checkIsAscii(assignmentFilterIds))
            .put("top", "Edm.Int32", top)
            .put("skip", "Edm.Int32", skip)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<AssignmentFilterStatusDetails>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getAssignmentFiltersStatusDetails"), AssignmentFilterStatusDetails.class, _parameters);
    }

    @Action(name = "enableAndroidDeviceAdministratorEnrollment")
    @JsonIgnore
    public ActionRequestNoReturn enableAndroidDeviceAdministratorEnrollment() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.enableAndroidDeviceAdministratorEnrollment"), _parameters);
    }

    @Action(name = "enableLegacyPcManagement")
    @JsonIgnore
    public ActionRequestNoReturn enableLegacyPcManagement() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.enableLegacyPcManagement"), _parameters);
    }

    @Action(name = "enableUnlicensedAdminstrators")
    @JsonIgnore
    public ActionRequestNoReturn enableUnlicensedAdminstrators() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.enableUnlicensedAdminstrators"), _parameters);
    }

    @Function(name = "getEffectivePermissions")
    @JsonIgnore
    public CollectionPageNonEntityRequest<String> getEffectivePermissions() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getEffectivePermissions"), String.class, _parameters);
    }

    @Function(name = "getEffectivePermissions")
    @JsonIgnore
    public CollectionPageNonEntityRequest<RolePermission> getEffectivePermissions_Function(String scope) {
        Preconditions.checkNotNull(scope, "scope cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("scope", "Edm.String", Checks.checkIsAscii(scope))
            .build();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getEffectivePermissions"), RolePermission.class, _parameters);
    }

    @Function(name = "verifyWindowsEnrollmentAutoDiscovery")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<Boolean> verifyWindowsEnrollmentAutoDiscovery(String domainName) {
        Preconditions.checkNotNull(domainName, "domainName cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("domainName", "Edm.String", Checks.checkIsAscii(domainName))
            .build();
        return new FunctionRequestReturningNonCollection<Boolean>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.verifyWindowsEnrollmentAutoDiscovery"), Boolean.class, _parameters);
    }

    @Function(name = "getComanagedDevicesSummary")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<ComanagedDevicesSummary> getComanagedDevicesSummary() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollectionUnwrapped<ComanagedDevicesSummary>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getComanagedDevicesSummary"), ComanagedDevicesSummary.class, _parameters);
    }

    @Function(name = "getComanagementEligibleDevicesSummary")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<ComanagementEligibleDevicesSummary> getComanagementEligibleDevicesSummary() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollectionUnwrapped<ComanagementEligibleDevicesSummary>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getComanagementEligibleDevicesSummary"), ComanagementEligibleDevicesSummary.class, _parameters);
    }

    @Function(name = "userExperienceAnalyticsSummarizeWorkFromAnywhereDevices")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<UserExperienceAnalyticsWorkFromAnywhereDevicesSummary> userExperienceAnalyticsSummarizeWorkFromAnywhereDevices() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollectionUnwrapped<UserExperienceAnalyticsWorkFromAnywhereDevicesSummary>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.userExperienceAnalyticsSummarizeWorkFromAnywhereDevices"), UserExperienceAnalyticsWorkFromAnywhereDevicesSummary.class, _parameters);
    }

    @Function(name = "getSuggestedEnrollmentLimit")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<SuggestedEnrollmentLimit> getSuggestedEnrollmentLimit(String enrollmentType) {
        Preconditions.checkNotNull(enrollmentType, "enrollmentType cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("enrollmentType", "Edm.String", Checks.checkIsAscii(enrollmentType))
            .build();
        return new FunctionRequestReturningNonCollectionUnwrapped<SuggestedEnrollmentLimit>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getSuggestedEnrollmentLimit"), SuggestedEnrollmentLimit.class, _parameters);
    }

    @Function(name = "getAssignedRoleDetails")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<DeviceAndAppManagementAssignedRoleDetails> getAssignedRoleDetails() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollectionUnwrapped<DeviceAndAppManagementAssignedRoleDetails>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getAssignedRoleDetails"), DeviceAndAppManagementAssignedRoleDetails.class, _parameters);
    }

    @Function(name = "getRoleScopeTagsByIds")
    @JsonIgnore
    public CollectionPageNonEntityRequest<RoleScopeTag> getRoleScopeTagsByIds(List<String> ids) {
        Preconditions.checkNotNull(ids, "ids cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("ids", "Collection(Edm.String)", Checks.checkIsAscii(ids))
            .build();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getRoleScopeTagsByIds"), RoleScopeTag.class, _parameters);
    }

    @Function(name = "getRoleScopeTagsByResource")
    @JsonIgnore
    public CollectionPageNonEntityRequest<RoleScopeTag> getRoleScopeTagsByResource(String resource) {
        Preconditions.checkNotNull(resource, "resource cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("resource", "Edm.String", Checks.checkIsAscii(resource))
            .build();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getRoleScopeTagsByResource"), RoleScopeTag.class, _parameters);
    }

    @Function(name = "scopedForResource")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<Boolean> scopedForResource(String resource) {
        Preconditions.checkNotNull(resource, "resource cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("resource", "Edm.String", Checks.checkIsAscii(resource))
            .build();
        return new FunctionRequestReturningNonCollection<Boolean>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.scopedForResource"), Boolean.class, _parameters);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DeviceManagement[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("deviceComplianceReportSummarizationDateTime=");
        b.append(this.deviceComplianceReportSummarizationDateTime);
        b.append(", ");
        b.append("intuneAccountId=");
        b.append(this.intuneAccountId);
        b.append(", ");
        b.append("lastReportAggregationDateTime=");
        b.append(this.lastReportAggregationDateTime);
        b.append(", ");
        b.append("legacyPcManangementEnabled=");
        b.append(this.legacyPcManangementEnabled);
        b.append(", ");
        b.append("maximumDepTokens=");
        b.append(this.maximumDepTokens);
        b.append(", ");
        b.append("settings=");
        b.append(this.settings);
        b.append(", ");
        b.append("unlicensedAdminstratorsEnabled=");
        b.append(this.unlicensedAdminstratorsEnabled);
        b.append(", ");
        b.append("intuneBrand=");
        b.append(this.intuneBrand);
        b.append(", ");
        b.append("accountMoveCompletionDateTime=");
        b.append(this.accountMoveCompletionDateTime);
        b.append(", ");
        b.append("adminConsent=");
        b.append(this.adminConsent);
        b.append(", ");
        b.append("deviceProtectionOverview=");
        b.append(this.deviceProtectionOverview);
        b.append(", ");
        b.append("managedDeviceCleanupSettings=");
        b.append(this.managedDeviceCleanupSettings);
        b.append(", ");
        b.append("subscriptions=");
        b.append(this.subscriptions);
        b.append(", ");
        b.append("subscriptionState=");
        b.append(this.subscriptionState);
        b.append(", ");
        b.append("userExperienceAnalyticsSettings=");
        b.append(this.userExperienceAnalyticsSettings);
        b.append(", ");
        b.append("windowsMalwareOverview=");
        b.append(this.windowsMalwareOverview);
        b.append(", ");
        b.append("androidDeviceOwnerEnrollmentProfiles=");
        b.append(this.androidDeviceOwnerEnrollmentProfiles);
        b.append(", ");
        b.append("virtualEndpoint=");
        b.append(this.virtualEndpoint);
        b.append(", ");
        b.append("androidForWorkAppConfigurationSchemas=");
        b.append(this.androidForWorkAppConfigurationSchemas);
        b.append(", ");
        b.append("androidForWorkEnrollmentProfiles=");
        b.append(this.androidForWorkEnrollmentProfiles);
        b.append(", ");
        b.append("androidForWorkSettings=");
        b.append(this.androidForWorkSettings);
        b.append(", ");
        b.append("androidManagedStoreAccountEnterpriseSettings=");
        b.append(this.androidManagedStoreAccountEnterpriseSettings);
        b.append(", ");
        b.append("androidManagedStoreAppConfigurationSchemas=");
        b.append(this.androidManagedStoreAppConfigurationSchemas);
        b.append(", ");
        b.append("auditEvents=");
        b.append(this.auditEvents);
        b.append(", ");
        b.append("assignmentFilters=");
        b.append(this.assignmentFilters);
        b.append(", ");
        b.append("chromeOSOnboardingSettings=");
        b.append(this.chromeOSOnboardingSettings);
        b.append(", ");
        b.append("termsAndConditions=");
        b.append(this.termsAndConditions);
        b.append(", ");
        b.append("advancedThreatProtectionOnboardingStateSummary=");
        b.append(this.advancedThreatProtectionOnboardingStateSummary);
        b.append(", ");
        b.append("cartToClassAssociations=");
        b.append(this.cartToClassAssociations);
        b.append(", ");
        b.append("deviceCompliancePolicies=");
        b.append(this.deviceCompliancePolicies);
        b.append(", ");
        b.append("deviceCompliancePolicyDeviceStateSummary=");
        b.append(this.deviceCompliancePolicyDeviceStateSummary);
        b.append(", ");
        b.append("deviceCompliancePolicySettingStateSummaries=");
        b.append(this.deviceCompliancePolicySettingStateSummaries);
        b.append(", ");
        b.append("deviceConfigurationConflictSummary=");
        b.append(this.deviceConfigurationConflictSummary);
        b.append(", ");
        b.append("deviceConfigurationDeviceStateSummaries=");
        b.append(this.deviceConfigurationDeviceStateSummaries);
        b.append(", ");
        b.append("deviceConfigurationRestrictedAppsViolations=");
        b.append(this.deviceConfigurationRestrictedAppsViolations);
        b.append(", ");
        b.append("deviceConfigurations=");
        b.append(this.deviceConfigurations);
        b.append(", ");
        b.append("deviceConfigurationsAllManagedDeviceCertificateStates=");
        b.append(this.deviceConfigurationsAllManagedDeviceCertificateStates);
        b.append(", ");
        b.append("deviceConfigurationUserStateSummaries=");
        b.append(this.deviceConfigurationUserStateSummaries);
        b.append(", ");
        b.append("iosUpdateStatuses=");
        b.append(this.iosUpdateStatuses);
        b.append(", ");
        b.append("macOSSoftwareUpdateAccountSummaries=");
        b.append(this.macOSSoftwareUpdateAccountSummaries);
        b.append(", ");
        b.append("managedDeviceEncryptionStates=");
        b.append(this.managedDeviceEncryptionStates);
        b.append(", ");
        b.append("ndesConnectors=");
        b.append(this.ndesConnectors);
        b.append(", ");
        b.append("complianceCategories=");
        b.append(this.complianceCategories);
        b.append(", ");
        b.append("compliancePolicies=");
        b.append(this.compliancePolicies);
        b.append(", ");
        b.append("complianceSettings=");
        b.append(this.complianceSettings);
        b.append(", ");
        b.append("configurationCategories=");
        b.append(this.configurationCategories);
        b.append(", ");
        b.append("configurationPolicies=");
        b.append(this.configurationPolicies);
        b.append(", ");
        b.append("configurationPolicyTemplates=");
        b.append(this.configurationPolicyTemplates);
        b.append(", ");
        b.append("configurationSettings=");
        b.append(this.configurationSettings);
        b.append(", ");
        b.append("reusablePolicySettings=");
        b.append(this.reusablePolicySettings);
        b.append(", ");
        b.append("reusableSettings=");
        b.append(this.reusableSettings);
        b.append(", ");
        b.append("templateSettings=");
        b.append(this.templateSettings);
        b.append(", ");
        b.append("complianceManagementPartners=");
        b.append(this.complianceManagementPartners);
        b.append(", ");
        b.append("conditionalAccessSettings=");
        b.append(this.conditionalAccessSettings);
        b.append(", ");
        b.append("deviceCategories=");
        b.append(this.deviceCategories);
        b.append(", ");
        b.append("deviceEnrollmentConfigurations=");
        b.append(this.deviceEnrollmentConfigurations);
        b.append(", ");
        b.append("deviceManagementPartners=");
        b.append(this.deviceManagementPartners);
        b.append(", ");
        b.append("exchangeConnectors=");
        b.append(this.exchangeConnectors);
        b.append(", ");
        b.append("exchangeOnPremisesPolicies=");
        b.append(this.exchangeOnPremisesPolicies);
        b.append(", ");
        b.append("exchangeOnPremisesPolicy=");
        b.append(this.exchangeOnPremisesPolicy);
        b.append(", ");
        b.append("mobileThreatDefenseConnectors=");
        b.append(this.mobileThreatDefenseConnectors);
        b.append(", ");
        b.append("categories=");
        b.append(this.categories);
        b.append(", ");
        b.append("intents=");
        b.append(this.intents);
        b.append(", ");
        b.append("settingDefinitions=");
        b.append(this.settingDefinitions);
        b.append(", ");
        b.append("templates=");
        b.append(this.templates);
        b.append(", ");
        b.append("applePushNotificationCertificate=");
        b.append(this.applePushNotificationCertificate);
        b.append(", ");
        b.append("cloudPCConnectivityIssues=");
        b.append(this.cloudPCConnectivityIssues);
        b.append(", ");
        b.append("comanagedDevices=");
        b.append(this.comanagedDevices);
        b.append(", ");
        b.append("comanagementEligibleDevices=");
        b.append(this.comanagementEligibleDevices);
        b.append(", ");
        b.append("dataSharingConsents=");
        b.append(this.dataSharingConsents);
        b.append(", ");
        b.append("detectedApps=");
        b.append(this.detectedApps);
        b.append(", ");
        b.append("deviceComplianceScripts=");
        b.append(this.deviceComplianceScripts);
        b.append(", ");
        b.append("deviceCustomAttributeShellScripts=");
        b.append(this.deviceCustomAttributeShellScripts);
        b.append(", ");
        b.append("deviceHealthScripts=");
        b.append(this.deviceHealthScripts);
        b.append(", ");
        b.append("deviceManagementScripts=");
        b.append(this.deviceManagementScripts);
        b.append(", ");
        b.append("deviceShellScripts=");
        b.append(this.deviceShellScripts);
        b.append(", ");
        b.append("managedDevices=");
        b.append(this.managedDevices);
        b.append(", ");
        b.append("mobileAppTroubleshootingEvents=");
        b.append(this.mobileAppTroubleshootingEvents);
        b.append(", ");
        b.append("oemWarrantyInformationOnboarding=");
        b.append(this.oemWarrantyInformationOnboarding);
        b.append(", ");
        b.append("remoteActionAudits=");
        b.append(this.remoteActionAudits);
        b.append(", ");
        b.append("userExperienceAnalyticsAppHealthApplicationPerformance=");
        b.append(this.userExperienceAnalyticsAppHealthApplicationPerformance);
        b.append(", ");
        b.append("userExperienceAnalyticsAppHealthApplicationPerformanceByAppVersion=");
        b.append(this.userExperienceAnalyticsAppHealthApplicationPerformanceByAppVersion);
        b.append(", ");
        b.append("userExperienceAnalyticsAppHealthApplicationPerformanceByAppVersionDetails=");
        b.append(this.userExperienceAnalyticsAppHealthApplicationPerformanceByAppVersionDetails);
        b.append(", ");
        b.append("userExperienceAnalyticsAppHealthApplicationPerformanceByAppVersionDeviceId=");
        b.append(this.userExperienceAnalyticsAppHealthApplicationPerformanceByAppVersionDeviceId);
        b.append(", ");
        b.append("userExperienceAnalyticsAppHealthApplicationPerformanceByOSVersion=");
        b.append(this.userExperienceAnalyticsAppHealthApplicationPerformanceByOSVersion);
        b.append(", ");
        b.append("userExperienceAnalyticsAppHealthDeviceModelPerformance=");
        b.append(this.userExperienceAnalyticsAppHealthDeviceModelPerformance);
        b.append(", ");
        b.append("userExperienceAnalyticsAppHealthDevicePerformance=");
        b.append(this.userExperienceAnalyticsAppHealthDevicePerformance);
        b.append(", ");
        b.append("userExperienceAnalyticsAppHealthDevicePerformanceDetails=");
        b.append(this.userExperienceAnalyticsAppHealthDevicePerformanceDetails);
        b.append(", ");
        b.append("userExperienceAnalyticsAppHealthOSVersionPerformance=");
        b.append(this.userExperienceAnalyticsAppHealthOSVersionPerformance);
        b.append(", ");
        b.append("userExperienceAnalyticsAppHealthOverview=");
        b.append(this.userExperienceAnalyticsAppHealthOverview);
        b.append(", ");
        b.append("userExperienceAnalyticsBaselines=");
        b.append(this.userExperienceAnalyticsBaselines);
        b.append(", ");
        b.append("userExperienceAnalyticsBatteryHealthAppImpact=");
        b.append(this.userExperienceAnalyticsBatteryHealthAppImpact);
        b.append(", ");
        b.append("userExperienceAnalyticsBatteryHealthCapacityDetails=");
        b.append(this.userExperienceAnalyticsBatteryHealthCapacityDetails);
        b.append(", ");
        b.append("userExperienceAnalyticsBatteryHealthDeviceAppImpact=");
        b.append(this.userExperienceAnalyticsBatteryHealthDeviceAppImpact);
        b.append(", ");
        b.append("userExperienceAnalyticsBatteryHealthDevicePerformance=");
        b.append(this.userExperienceAnalyticsBatteryHealthDevicePerformance);
        b.append(", ");
        b.append("userExperienceAnalyticsBatteryHealthDeviceRuntimeHistory=");
        b.append(this.userExperienceAnalyticsBatteryHealthDeviceRuntimeHistory);
        b.append(", ");
        b.append("userExperienceAnalyticsBatteryHealthModelPerformance=");
        b.append(this.userExperienceAnalyticsBatteryHealthModelPerformance);
        b.append(", ");
        b.append("userExperienceAnalyticsBatteryHealthOsPerformance=");
        b.append(this.userExperienceAnalyticsBatteryHealthOsPerformance);
        b.append(", ");
        b.append("userExperienceAnalyticsBatteryHealthRuntimeDetails=");
        b.append(this.userExperienceAnalyticsBatteryHealthRuntimeDetails);
        b.append(", ");
        b.append("userExperienceAnalyticsCategories=");
        b.append(this.userExperienceAnalyticsCategories);
        b.append(", ");
        b.append("userExperienceAnalyticsDeviceMetricHistory=");
        b.append(this.userExperienceAnalyticsDeviceMetricHistory);
        b.append(", ");
        b.append("userExperienceAnalyticsDevicePerformance=");
        b.append(this.userExperienceAnalyticsDevicePerformance);
        b.append(", ");
        b.append("userExperienceAnalyticsDeviceScores=");
        b.append(this.userExperienceAnalyticsDeviceScores);
        b.append(", ");
        b.append("userExperienceAnalyticsDeviceStartupHistory=");
        b.append(this.userExperienceAnalyticsDeviceStartupHistory);
        b.append(", ");
        b.append("userExperienceAnalyticsDeviceStartupProcesses=");
        b.append(this.userExperienceAnalyticsDeviceStartupProcesses);
        b.append(", ");
        b.append("userExperienceAnalyticsDeviceStartupProcessPerformance=");
        b.append(this.userExperienceAnalyticsDeviceStartupProcessPerformance);
        b.append(", ");
        b.append("userExperienceAnalyticsDevicesWithoutCloudIdentity=");
        b.append(this.userExperienceAnalyticsDevicesWithoutCloudIdentity);
        b.append(", ");
        b.append("userExperienceAnalyticsImpactingProcess=");
        b.append(this.userExperienceAnalyticsImpactingProcess);
        b.append(", ");
        b.append("userExperienceAnalyticsMetricHistory=");
        b.append(this.userExperienceAnalyticsMetricHistory);
        b.append(", ");
        b.append("userExperienceAnalyticsModelScores=");
        b.append(this.userExperienceAnalyticsModelScores);
        b.append(", ");
        b.append("userExperienceAnalyticsNotAutopilotReadyDevice=");
        b.append(this.userExperienceAnalyticsNotAutopilotReadyDevice);
        b.append(", ");
        b.append("userExperienceAnalyticsOverview=");
        b.append(this.userExperienceAnalyticsOverview);
        b.append(", ");
        b.append("userExperienceAnalyticsRegressionSummary=");
        b.append(this.userExperienceAnalyticsRegressionSummary);
        b.append(", ");
        b.append("userExperienceAnalyticsRemoteConnection=");
        b.append(this.userExperienceAnalyticsRemoteConnection);
        b.append(", ");
        b.append("userExperienceAnalyticsResourcePerformance=");
        b.append(this.userExperienceAnalyticsResourcePerformance);
        b.append(", ");
        b.append("userExperienceAnalyticsScoreHistory=");
        b.append(this.userExperienceAnalyticsScoreHistory);
        b.append(", ");
        b.append("userExperienceAnalyticsWorkFromAnywhereHardwareReadinessMetric=");
        b.append(this.userExperienceAnalyticsWorkFromAnywhereHardwareReadinessMetric);
        b.append(", ");
        b.append("userExperienceAnalyticsWorkFromAnywhereMetrics=");
        b.append(this.userExperienceAnalyticsWorkFromAnywhereMetrics);
        b.append(", ");
        b.append("userExperienceAnalyticsWorkFromAnywhereModelPerformance=");
        b.append(this.userExperienceAnalyticsWorkFromAnywhereModelPerformance);
        b.append(", ");
        b.append("windowsMalwareInformation=");
        b.append(this.windowsMalwareInformation);
        b.append(", ");
        b.append("derivedCredentials=");
        b.append(this.derivedCredentials);
        b.append(", ");
        b.append("resourceAccessProfiles=");
        b.append(this.resourceAccessProfiles);
        b.append(", ");
        b.append("appleUserInitiatedEnrollmentProfiles=");
        b.append(this.appleUserInitiatedEnrollmentProfiles);
        b.append(", ");
        b.append("depOnboardingSettings=");
        b.append(this.depOnboardingSettings);
        b.append(", ");
        b.append("importedDeviceIdentities=");
        b.append(this.importedDeviceIdentities);
        b.append(", ");
        b.append("importedWindowsAutopilotDeviceIdentities=");
        b.append(this.importedWindowsAutopilotDeviceIdentities);
        b.append(", ");
        b.append("windowsAutopilotDeploymentProfiles=");
        b.append(this.windowsAutopilotDeploymentProfiles);
        b.append(", ");
        b.append("windowsAutopilotDeviceIdentities=");
        b.append(this.windowsAutopilotDeviceIdentities);
        b.append(", ");
        b.append("windowsAutopilotSettings=");
        b.append(this.windowsAutopilotSettings);
        b.append(", ");
        b.append("managementConditions=");
        b.append(this.managementConditions);
        b.append(", ");
        b.append("managementConditionStatements=");
        b.append(this.managementConditionStatements);
        b.append(", ");
        b.append("groupPolicyMigrationReports=");
        b.append(this.groupPolicyMigrationReports);
        b.append(", ");
        b.append("groupPolicyObjectFiles=");
        b.append(this.groupPolicyObjectFiles);
        b.append(", ");
        b.append("groupPolicyCategories=");
        b.append(this.groupPolicyCategories);
        b.append(", ");
        b.append("groupPolicyConfigurations=");
        b.append(this.groupPolicyConfigurations);
        b.append(", ");
        b.append("groupPolicyDefinitionFiles=");
        b.append(this.groupPolicyDefinitionFiles);
        b.append(", ");
        b.append("groupPolicyDefinitions=");
        b.append(this.groupPolicyDefinitions);
        b.append(", ");
        b.append("groupPolicyUploadedDefinitionFiles=");
        b.append(this.groupPolicyUploadedDefinitionFiles);
        b.append(", ");
        b.append("microsoftTunnelConfigurations=");
        b.append(this.microsoftTunnelConfigurations);
        b.append(", ");
        b.append("microsoftTunnelHealthThresholds=");
        b.append(this.microsoftTunnelHealthThresholds);
        b.append(", ");
        b.append("microsoftTunnelServerLogCollectionResponses=");
        b.append(this.microsoftTunnelServerLogCollectionResponses);
        b.append(", ");
        b.append("microsoftTunnelSites=");
        b.append(this.microsoftTunnelSites);
        b.append(", ");
        b.append("notificationMessageTemplates=");
        b.append(this.notificationMessageTemplates);
        b.append(", ");
        b.append("domainJoinConnectors=");
        b.append(this.domainJoinConnectors);
        b.append(", ");
        b.append("configManagerCollections=");
        b.append(this.configManagerCollections);
        b.append(", ");
        b.append("resourceOperations=");
        b.append(this.resourceOperations);
        b.append(", ");
        b.append("roleAssignments=");
        b.append(this.roleAssignments);
        b.append(", ");
        b.append("roleDefinitions=");
        b.append(this.roleDefinitions);
        b.append(", ");
        b.append("roleScopeTags=");
        b.append(this.roleScopeTags);
        b.append(", ");
        b.append("remoteAssistancePartners=");
        b.append(this.remoteAssistancePartners);
        b.append(", ");
        b.append("remoteAssistanceSettings=");
        b.append(this.remoteAssistanceSettings);
        b.append(", ");
        b.append("reports=");
        b.append(this.reports);
        b.append(", ");
        b.append("embeddedSIMActivationCodePools=");
        b.append(this.embeddedSIMActivationCodePools);
        b.append(", ");
        b.append("telecomExpenseManagementPartners=");
        b.append(this.telecomExpenseManagementPartners);
        b.append(", ");
        b.append("autopilotEvents=");
        b.append(this.autopilotEvents);
        b.append(", ");
        b.append("troubleshootingEvents=");
        b.append(this.troubleshootingEvents);
        b.append(", ");
        b.append("windowsDriverUpdateProfiles=");
        b.append(this.windowsDriverUpdateProfiles);
        b.append(", ");
        b.append("windowsFeatureUpdateProfiles=");
        b.append(this.windowsFeatureUpdateProfiles);
        b.append(", ");
        b.append("windowsQualityUpdateProfiles=");
        b.append(this.windowsQualityUpdateProfiles);
        b.append(", ");
        b.append("windowsUpdateCatalogItems=");
        b.append(this.windowsUpdateCatalogItems);
        b.append(", ");
        b.append("intuneBrandingProfiles=");
        b.append(this.intuneBrandingProfiles);
        b.append(", ");
        b.append("windowsInformationProtectionAppLearningSummaries=");
        b.append(this.windowsInformationProtectionAppLearningSummaries);
        b.append(", ");
        b.append("windowsInformationProtectionNetworkLearningSummaries=");
        b.append(this.windowsInformationProtectionNetworkLearningSummaries);
        b.append(", ");
        b.append("certificateConnectorDetails=");
        b.append(this.certificateConnectorDetails);
        b.append(", ");
        b.append("userPfxCertificates=");
        b.append(this.userPfxCertificates);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
