package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollection;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Double;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;


/**
 * <i>“Windows Log Collection request entity.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "errorCode", 
    "expirationDateTimeUTC", 
    "initiatedByUserPrincipalName", 
    "managedDeviceId", 
    "receivedDateTimeUTC", 
    "requestedDateTimeUTC", 
    "size", 
    "status"})
@JsonInclude(Include.NON_NULL)
public class DeviceLogCollectionResponse extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.deviceLogCollectionResponse";
    }

    @JsonProperty("errorCode")
    protected Long errorCode;

    @JsonProperty("expirationDateTimeUTC")
    protected OffsetDateTime expirationDateTimeUTC;

    @JsonProperty("initiatedByUserPrincipalName")
    protected String initiatedByUserPrincipalName;

    @JsonProperty("managedDeviceId")
    protected UUID managedDeviceId;

    @JsonProperty("receivedDateTimeUTC")
    protected OffsetDateTime receivedDateTimeUTC;

    @JsonProperty("requestedDateTimeUTC")
    protected OffsetDateTime requestedDateTimeUTC;

    @JsonProperty("size")
    protected Double size;

    @JsonProperty("status")
    protected String status;

    protected DeviceLogCollectionResponse() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderDeviceLogCollectionResponse() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private Long errorCode;
        private OffsetDateTime expirationDateTimeUTC;
        private String initiatedByUserPrincipalName;
        private UUID managedDeviceId;
        private OffsetDateTime receivedDateTimeUTC;
        private OffsetDateTime requestedDateTimeUTC;
        private Double size;
        private String status;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“The error code, if any. Valid values -9.22337203685478E+18 to 9.22337203685478E+
         * 18”</i>
         * 
         * @param errorCode
         *            value of {@code errorCode} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder errorCode(Long errorCode) {
            this.errorCode = errorCode;
            this.changedFields = changedFields.add("errorCode");
            return this;
        }

        /**
         * <i>“The DateTime of the expiration of the logs”</i>
         * 
         * @param expirationDateTimeUTC
         *            value of {@code expirationDateTimeUTC} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder expirationDateTimeUTC(OffsetDateTime expirationDateTimeUTC) {
            this.expirationDateTimeUTC = expirationDateTimeUTC;
            this.changedFields = changedFields.add("expirationDateTimeUTC");
            return this;
        }

        /**
         * <i>“The UPN for who initiated the request”</i>
         * 
         * @param initiatedByUserPrincipalName
         *            value of {@code initiatedByUserPrincipalName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder initiatedByUserPrincipalName(String initiatedByUserPrincipalName) {
            this.initiatedByUserPrincipalName = initiatedByUserPrincipalName;
            this.changedFields = changedFields.add("initiatedByUserPrincipalName");
            return this;
        }

        /**
         * <i>“The device Id”</i>
         * 
         * @param managedDeviceId
         *            value of {@code managedDeviceId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder managedDeviceId(UUID managedDeviceId) {
            this.managedDeviceId = managedDeviceId;
            this.changedFields = changedFields.add("managedDeviceId");
            return this;
        }

        /**
         * <i>“The DateTime the request was received”</i>
         * 
         * @param receivedDateTimeUTC
         *            value of {@code receivedDateTimeUTC} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder receivedDateTimeUTC(OffsetDateTime receivedDateTimeUTC) {
            this.receivedDateTimeUTC = receivedDateTimeUTC;
            this.changedFields = changedFields.add("receivedDateTimeUTC");
            return this;
        }

        /**
         * <i>“The DateTime of the request”</i>
         * 
         * @param requestedDateTimeUTC
         *            value of {@code requestedDateTimeUTC} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder requestedDateTimeUTC(OffsetDateTime requestedDateTimeUTC) {
            this.requestedDateTimeUTC = requestedDateTimeUTC;
            this.changedFields = changedFields.add("requestedDateTimeUTC");
            return this;
        }

        /**
         * <i>“The size of the logs. Valid values -1.79769313486232E+308 to 1.79769313486232E+
         * 308”</i>
         * 
         * @param size
         *            value of {@code size} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder size(Double size) {
            this.size = size;
            this.changedFields = changedFields.add("size");
            return this;
        }

        /**
         * <i>“The status of the log collection request”</i>
         * 
         * @param status
         *            value of {@code status} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder status(String status) {
            this.status = status;
            this.changedFields = changedFields.add("status");
            return this;
        }

        public DeviceLogCollectionResponse build() {
            DeviceLogCollectionResponse _x = new DeviceLogCollectionResponse();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.deviceLogCollectionResponse";
            _x.id = id;
            _x.errorCode = errorCode;
            _x.expirationDateTimeUTC = expirationDateTimeUTC;
            _x.initiatedByUserPrincipalName = initiatedByUserPrincipalName;
            _x.managedDeviceId = managedDeviceId;
            _x.receivedDateTimeUTC = receivedDateTimeUTC;
            _x.requestedDateTimeUTC = requestedDateTimeUTC;
            _x.size = size;
            _x.status = status;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“The error code, if any. Valid values -9.22337203685478E+18 to 9.22337203685478E+
     * 18”</i>
     * 
     * @return property errorCode
     */
    @Property(name="errorCode")
    @JsonIgnore
    public Optional<Long> getErrorCode() {
        return Optional.ofNullable(errorCode);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code errorCode} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The error code, if any. Valid values -9.22337203685478E+18 to 9.22337203685478E+
     * 18”</i>
     * 
     * @param errorCode
     *            new value of {@code errorCode} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code errorCode} field changed
     */
    public DeviceLogCollectionResponse withErrorCode(Long errorCode) {
        DeviceLogCollectionResponse _x = _copy();
        _x.changedFields = changedFields.add("errorCode");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceLogCollectionResponse");
        _x.errorCode = errorCode;
        return _x;
    }

    /**
     * <i>“The DateTime of the expiration of the logs”</i>
     * 
     * @return property expirationDateTimeUTC
     */
    @Property(name="expirationDateTimeUTC")
    @JsonIgnore
    public Optional<OffsetDateTime> getExpirationDateTimeUTC() {
        return Optional.ofNullable(expirationDateTimeUTC);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * expirationDateTimeUTC} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The DateTime of the expiration of the logs”</i>
     * 
     * @param expirationDateTimeUTC
     *            new value of {@code expirationDateTimeUTC} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code expirationDateTimeUTC} field changed
     */
    public DeviceLogCollectionResponse withExpirationDateTimeUTC(OffsetDateTime expirationDateTimeUTC) {
        DeviceLogCollectionResponse _x = _copy();
        _x.changedFields = changedFields.add("expirationDateTimeUTC");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceLogCollectionResponse");
        _x.expirationDateTimeUTC = expirationDateTimeUTC;
        return _x;
    }

    /**
     * <i>“The UPN for who initiated the request”</i>
     * 
     * @return property initiatedByUserPrincipalName
     */
    @Property(name="initiatedByUserPrincipalName")
    @JsonIgnore
    public Optional<String> getInitiatedByUserPrincipalName() {
        return Optional.ofNullable(initiatedByUserPrincipalName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * initiatedByUserPrincipalName} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“The UPN for who initiated the request”</i>
     * 
     * @param initiatedByUserPrincipalName
     *            new value of {@code initiatedByUserPrincipalName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code initiatedByUserPrincipalName} field changed
     */
    public DeviceLogCollectionResponse withInitiatedByUserPrincipalName(String initiatedByUserPrincipalName) {
        DeviceLogCollectionResponse _x = _copy();
        _x.changedFields = changedFields.add("initiatedByUserPrincipalName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceLogCollectionResponse");
        _x.initiatedByUserPrincipalName = initiatedByUserPrincipalName;
        return _x;
    }

    /**
     * <i>“The device Id”</i>
     * 
     * @return property managedDeviceId
     */
    @Property(name="managedDeviceId")
    @JsonIgnore
    public Optional<UUID> getManagedDeviceId() {
        return Optional.ofNullable(managedDeviceId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code managedDeviceId}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The device Id”</i>
     * 
     * @param managedDeviceId
     *            new value of {@code managedDeviceId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code managedDeviceId} field changed
     */
    public DeviceLogCollectionResponse withManagedDeviceId(UUID managedDeviceId) {
        DeviceLogCollectionResponse _x = _copy();
        _x.changedFields = changedFields.add("managedDeviceId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceLogCollectionResponse");
        _x.managedDeviceId = managedDeviceId;
        return _x;
    }

    /**
     * <i>“The DateTime the request was received”</i>
     * 
     * @return property receivedDateTimeUTC
     */
    @Property(name="receivedDateTimeUTC")
    @JsonIgnore
    public Optional<OffsetDateTime> getReceivedDateTimeUTC() {
        return Optional.ofNullable(receivedDateTimeUTC);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * receivedDateTimeUTC} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The DateTime the request was received”</i>
     * 
     * @param receivedDateTimeUTC
     *            new value of {@code receivedDateTimeUTC} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code receivedDateTimeUTC} field changed
     */
    public DeviceLogCollectionResponse withReceivedDateTimeUTC(OffsetDateTime receivedDateTimeUTC) {
        DeviceLogCollectionResponse _x = _copy();
        _x.changedFields = changedFields.add("receivedDateTimeUTC");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceLogCollectionResponse");
        _x.receivedDateTimeUTC = receivedDateTimeUTC;
        return _x;
    }

    /**
     * <i>“The DateTime of the request”</i>
     * 
     * @return property requestedDateTimeUTC
     */
    @Property(name="requestedDateTimeUTC")
    @JsonIgnore
    public Optional<OffsetDateTime> getRequestedDateTimeUTC() {
        return Optional.ofNullable(requestedDateTimeUTC);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * requestedDateTimeUTC} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The DateTime of the request”</i>
     * 
     * @param requestedDateTimeUTC
     *            new value of {@code requestedDateTimeUTC} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code requestedDateTimeUTC} field changed
     */
    public DeviceLogCollectionResponse withRequestedDateTimeUTC(OffsetDateTime requestedDateTimeUTC) {
        DeviceLogCollectionResponse _x = _copy();
        _x.changedFields = changedFields.add("requestedDateTimeUTC");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceLogCollectionResponse");
        _x.requestedDateTimeUTC = requestedDateTimeUTC;
        return _x;
    }

    /**
     * <i>“The size of the logs. Valid values -1.79769313486232E+308 to 1.79769313486232E+
     * 308”</i>
     * 
     * @return property size
     */
    @Property(name="size")
    @JsonIgnore
    public Optional<Double> getSize() {
        return Optional.ofNullable(size);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code size} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The size of the logs. Valid values -1.79769313486232E+308 to 1.79769313486232E+
     * 308”</i>
     * 
     * @param size
     *            new value of {@code size} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code size} field changed
     */
    public DeviceLogCollectionResponse withSize(Double size) {
        DeviceLogCollectionResponse _x = _copy();
        _x.changedFields = changedFields.add("size");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceLogCollectionResponse");
        _x.size = size;
        return _x;
    }

    /**
     * <i>“The status of the log collection request”</i>
     * 
     * @return property status
     */
    @Property(name="status")
    @JsonIgnore
    public Optional<String> getStatus() {
        return Optional.ofNullable(status);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code status} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The status of the log collection request”</i>
     * 
     * @param status
     *            new value of {@code status} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code status} field changed
     */
    public DeviceLogCollectionResponse withStatus(String status) {
        DeviceLogCollectionResponse _x = _copy();
        _x.changedFields = changedFields.add("status");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceLogCollectionResponse");
        _x.status = status;
        return _x;
    }

    public DeviceLogCollectionResponse withUnmappedField(String name, Object value) {
        DeviceLogCollectionResponse _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DeviceLogCollectionResponse patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        DeviceLogCollectionResponse _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DeviceLogCollectionResponse put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        DeviceLogCollectionResponse _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private DeviceLogCollectionResponse _copy() {
        DeviceLogCollectionResponse _x = new DeviceLogCollectionResponse();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.errorCode = errorCode;
        _x.expirationDateTimeUTC = expirationDateTimeUTC;
        _x.initiatedByUserPrincipalName = initiatedByUserPrincipalName;
        _x.managedDeviceId = managedDeviceId;
        _x.receivedDateTimeUTC = receivedDateTimeUTC;
        _x.requestedDateTimeUTC = requestedDateTimeUTC;
        _x.size = size;
        _x.status = status;
        return _x;
    }

    @Action(name = "createDownloadUrl")
    @JsonIgnore
    public ActionRequestReturningNonCollection<String> createDownloadUrl() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestReturningNonCollection<String>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.createDownloadUrl"), String.class, _parameters);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DeviceLogCollectionResponse[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("errorCode=");
        b.append(this.errorCode);
        b.append(", ");
        b.append("expirationDateTimeUTC=");
        b.append(this.expirationDateTimeUTC);
        b.append(", ");
        b.append("initiatedByUserPrincipalName=");
        b.append(this.initiatedByUserPrincipalName);
        b.append(", ");
        b.append("managedDeviceId=");
        b.append(this.managedDeviceId);
        b.append(", ");
        b.append("receivedDateTimeUTC=");
        b.append(this.receivedDateTimeUTC);
        b.append(", ");
        b.append("requestedDateTimeUTC=");
        b.append(this.requestedDateTimeUTC);
        b.append(", ");
        b.append("size=");
        b.append(this.size);
        b.append(", ");
        b.append("status=");
        b.append(this.status);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
