package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.enums.InstallState;


/**
 * <i>“Contains properties for the installation state for a device.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "deviceId", 
    "deviceName", 
    "errorCode", 
    "installState", 
    "lastSyncDateTime", 
    "osDescription", 
    "osVersion", 
    "userName"})
@JsonInclude(Include.NON_NULL)
public class DeviceInstallState extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.deviceInstallState";
    }

    @JsonProperty("deviceId")
    protected String deviceId;

    @JsonProperty("deviceName")
    protected String deviceName;

    @JsonProperty("errorCode")
    protected String errorCode;

    @JsonProperty("installState")
    protected InstallState installState;

    @JsonProperty("lastSyncDateTime")
    protected OffsetDateTime lastSyncDateTime;

    @JsonProperty("osDescription")
    protected String osDescription;

    @JsonProperty("osVersion")
    protected String osVersion;

    @JsonProperty("userName")
    protected String userName;

    protected DeviceInstallState() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderDeviceInstallState() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String deviceId;
        private String deviceName;
        private String errorCode;
        private InstallState installState;
        private OffsetDateTime lastSyncDateTime;
        private String osDescription;
        private String osVersion;
        private String userName;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“Device Id.”</i>
         * 
         * @param deviceId
         *            value of {@code deviceId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceId(String deviceId) {
            this.deviceId = deviceId;
            this.changedFields = changedFields.add("deviceId");
            return this;
        }

        /**
         * <i>“Device name.”</i>
         * 
         * @param deviceName
         *            value of {@code deviceName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceName(String deviceName) {
            this.deviceName = deviceName;
            this.changedFields = changedFields.add("deviceName");
            return this;
        }

        /**
         * <i>“The error code for install failures.”</i>
         * 
         * @param errorCode
         *            value of {@code errorCode} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder errorCode(String errorCode) {
            this.errorCode = errorCode;
            this.changedFields = changedFields.add("errorCode");
            return this;
        }

        /**
         * <i>“The install state of the eBook.”</i>
         * 
         * @param installState
         *            value of {@code installState} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder installState(InstallState installState) {
            this.installState = installState;
            this.changedFields = changedFields.add("installState");
            return this;
        }

        /**
         * <i>“Last sync date and time.”</i>
         * 
         * @param lastSyncDateTime
         *            value of {@code lastSyncDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder lastSyncDateTime(OffsetDateTime lastSyncDateTime) {
            this.lastSyncDateTime = lastSyncDateTime;
            this.changedFields = changedFields.add("lastSyncDateTime");
            return this;
        }

        /**
         * <i>“OS Description.”</i>
         * 
         * @param osDescription
         *            value of {@code osDescription} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder osDescription(String osDescription) {
            this.osDescription = osDescription;
            this.changedFields = changedFields.add("osDescription");
            return this;
        }

        /**
         * <i>“OS Version.”</i>
         * 
         * @param osVersion
         *            value of {@code osVersion} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder osVersion(String osVersion) {
            this.osVersion = osVersion;
            this.changedFields = changedFields.add("osVersion");
            return this;
        }

        /**
         * <i>“Device User Name.”</i>
         * 
         * @param userName
         *            value of {@code userName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userName(String userName) {
            this.userName = userName;
            this.changedFields = changedFields.add("userName");
            return this;
        }

        public DeviceInstallState build() {
            DeviceInstallState _x = new DeviceInstallState();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.deviceInstallState";
            _x.id = id;
            _x.deviceId = deviceId;
            _x.deviceName = deviceName;
            _x.errorCode = errorCode;
            _x.installState = installState;
            _x.lastSyncDateTime = lastSyncDateTime;
            _x.osDescription = osDescription;
            _x.osVersion = osVersion;
            _x.userName = userName;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“Device Id.”</i>
     * 
     * @return property deviceId
     */
    @Property(name="deviceId")
    @JsonIgnore
    public Optional<String> getDeviceId() {
        return Optional.ofNullable(deviceId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code deviceId} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Device Id.”</i>
     * 
     * @param deviceId
     *            new value of {@code deviceId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceId} field changed
     */
    public DeviceInstallState withDeviceId(String deviceId) {
        DeviceInstallState _x = _copy();
        _x.changedFields = changedFields.add("deviceId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceInstallState");
        _x.deviceId = deviceId;
        return _x;
    }

    /**
     * <i>“Device name.”</i>
     * 
     * @return property deviceName
     */
    @Property(name="deviceName")
    @JsonIgnore
    public Optional<String> getDeviceName() {
        return Optional.ofNullable(deviceName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code deviceName} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Device name.”</i>
     * 
     * @param deviceName
     *            new value of {@code deviceName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceName} field changed
     */
    public DeviceInstallState withDeviceName(String deviceName) {
        DeviceInstallState _x = _copy();
        _x.changedFields = changedFields.add("deviceName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceInstallState");
        _x.deviceName = deviceName;
        return _x;
    }

    /**
     * <i>“The error code for install failures.”</i>
     * 
     * @return property errorCode
     */
    @Property(name="errorCode")
    @JsonIgnore
    public Optional<String> getErrorCode() {
        return Optional.ofNullable(errorCode);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code errorCode} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The error code for install failures.”</i>
     * 
     * @param errorCode
     *            new value of {@code errorCode} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code errorCode} field changed
     */
    public DeviceInstallState withErrorCode(String errorCode) {
        DeviceInstallState _x = _copy();
        _x.changedFields = changedFields.add("errorCode");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceInstallState");
        _x.errorCode = errorCode;
        return _x;
    }

    /**
     * <i>“The install state of the eBook.”</i>
     * 
     * @return property installState
     */
    @Property(name="installState")
    @JsonIgnore
    public Optional<InstallState> getInstallState() {
        return Optional.ofNullable(installState);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code installState}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The install state of the eBook.”</i>
     * 
     * @param installState
     *            new value of {@code installState} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code installState} field changed
     */
    public DeviceInstallState withInstallState(InstallState installState) {
        DeviceInstallState _x = _copy();
        _x.changedFields = changedFields.add("installState");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceInstallState");
        _x.installState = installState;
        return _x;
    }

    /**
     * <i>“Last sync date and time.”</i>
     * 
     * @return property lastSyncDateTime
     */
    @Property(name="lastSyncDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastSyncDateTime() {
        return Optional.ofNullable(lastSyncDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code lastSyncDateTime}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Last sync date and time.”</i>
     * 
     * @param lastSyncDateTime
     *            new value of {@code lastSyncDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code lastSyncDateTime} field changed
     */
    public DeviceInstallState withLastSyncDateTime(OffsetDateTime lastSyncDateTime) {
        DeviceInstallState _x = _copy();
        _x.changedFields = changedFields.add("lastSyncDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceInstallState");
        _x.lastSyncDateTime = lastSyncDateTime;
        return _x;
    }

    /**
     * <i>“OS Description.”</i>
     * 
     * @return property osDescription
     */
    @Property(name="osDescription")
    @JsonIgnore
    public Optional<String> getOsDescription() {
        return Optional.ofNullable(osDescription);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code osDescription}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“OS Description.”</i>
     * 
     * @param osDescription
     *            new value of {@code osDescription} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code osDescription} field changed
     */
    public DeviceInstallState withOsDescription(String osDescription) {
        DeviceInstallState _x = _copy();
        _x.changedFields = changedFields.add("osDescription");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceInstallState");
        _x.osDescription = osDescription;
        return _x;
    }

    /**
     * <i>“OS Version.”</i>
     * 
     * @return property osVersion
     */
    @Property(name="osVersion")
    @JsonIgnore
    public Optional<String> getOsVersion() {
        return Optional.ofNullable(osVersion);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code osVersion} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“OS Version.”</i>
     * 
     * @param osVersion
     *            new value of {@code osVersion} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code osVersion} field changed
     */
    public DeviceInstallState withOsVersion(String osVersion) {
        DeviceInstallState _x = _copy();
        _x.changedFields = changedFields.add("osVersion");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceInstallState");
        _x.osVersion = osVersion;
        return _x;
    }

    /**
     * <i>“Device User Name.”</i>
     * 
     * @return property userName
     */
    @Property(name="userName")
    @JsonIgnore
    public Optional<String> getUserName() {
        return Optional.ofNullable(userName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code userName} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Device User Name.”</i>
     * 
     * @param userName
     *            new value of {@code userName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code userName} field changed
     */
    public DeviceInstallState withUserName(String userName) {
        DeviceInstallState _x = _copy();
        _x.changedFields = changedFields.add("userName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceInstallState");
        _x.userName = userName;
        return _x;
    }

    public DeviceInstallState withUnmappedField(String name, Object value) {
        DeviceInstallState _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DeviceInstallState patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        DeviceInstallState _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DeviceInstallState put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        DeviceInstallState _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private DeviceInstallState _copy() {
        DeviceInstallState _x = new DeviceInstallState();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.deviceId = deviceId;
        _x.deviceName = deviceName;
        _x.errorCode = errorCode;
        _x.installState = installState;
        _x.lastSyncDateTime = lastSyncDateTime;
        _x.osDescription = osDescription;
        _x.osVersion = osVersion;
        _x.userName = userName;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DeviceInstallState[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("deviceId=");
        b.append(this.deviceId);
        b.append(", ");
        b.append("deviceName=");
        b.append(this.deviceName);
        b.append(", ");
        b.append("errorCode=");
        b.append(this.errorCode);
        b.append(", ");
        b.append("installState=");
        b.append(this.installState);
        b.append(", ");
        b.append("lastSyncDateTime=");
        b.append(this.lastSyncDateTime);
        b.append(", ");
        b.append("osDescription=");
        b.append(this.osDescription);
        b.append(", ");
        b.append("osVersion=");
        b.append(this.osVersion);
        b.append(", ");
        b.append("userName=");
        b.append(this.userName);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
