package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.enums.ComplianceStatus;

@JsonPropertyOrder({
    "@odata.type", 
    "devicesCount", 
    "lastReportedDateTime", 
    "status", 
    "userDisplayName", 
    "userPrincipalName"})
@JsonInclude(Include.NON_NULL)
public class DeviceConfigurationUserStatus extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.deviceConfigurationUserStatus";
    }

    @JsonProperty("devicesCount")
    protected Integer devicesCount;

    @JsonProperty("lastReportedDateTime")
    protected OffsetDateTime lastReportedDateTime;

    @JsonProperty("status")
    protected ComplianceStatus status;

    @JsonProperty("userDisplayName")
    protected String userDisplayName;

    @JsonProperty("userPrincipalName")
    protected String userPrincipalName;

    protected DeviceConfigurationUserStatus() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderDeviceConfigurationUserStatus() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private Integer devicesCount;
        private OffsetDateTime lastReportedDateTime;
        private ComplianceStatus status;
        private String userDisplayName;
        private String userPrincipalName;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“Devices count for that user.”</i>
         * 
         * @param devicesCount
         *            value of {@code devicesCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder devicesCount(Integer devicesCount) {
            this.devicesCount = devicesCount;
            this.changedFields = changedFields.add("devicesCount");
            return this;
        }

        /**
         * <i>“Last modified date time of the policy report.”</i>
         * 
         * @param lastReportedDateTime
         *            value of {@code lastReportedDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder lastReportedDateTime(OffsetDateTime lastReportedDateTime) {
            this.lastReportedDateTime = lastReportedDateTime;
            this.changedFields = changedFields.add("lastReportedDateTime");
            return this;
        }

        /**
         * <i>“Compliance status of the policy report.”</i>
         * 
         * @param status
         *            value of {@code status} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder status(ComplianceStatus status) {
            this.status = status;
            this.changedFields = changedFields.add("status");
            return this;
        }

        /**
         * <i>“User name of the DevicePolicyStatus.”</i>
         * 
         * @param userDisplayName
         *            value of {@code userDisplayName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userDisplayName(String userDisplayName) {
            this.userDisplayName = userDisplayName;
            this.changedFields = changedFields.add("userDisplayName");
            return this;
        }

        /**
         * <i>“UserPrincipalName.”</i>
         * 
         * @param userPrincipalName
         *            value of {@code userPrincipalName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userPrincipalName(String userPrincipalName) {
            this.userPrincipalName = userPrincipalName;
            this.changedFields = changedFields.add("userPrincipalName");
            return this;
        }

        public DeviceConfigurationUserStatus build() {
            DeviceConfigurationUserStatus _x = new DeviceConfigurationUserStatus();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.deviceConfigurationUserStatus";
            _x.id = id;
            _x.devicesCount = devicesCount;
            _x.lastReportedDateTime = lastReportedDateTime;
            _x.status = status;
            _x.userDisplayName = userDisplayName;
            _x.userPrincipalName = userPrincipalName;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“Devices count for that user.”</i>
     * 
     * @return property devicesCount
     */
    @Property(name="devicesCount")
    @JsonIgnore
    public Optional<Integer> getDevicesCount() {
        return Optional.ofNullable(devicesCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code devicesCount}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Devices count for that user.”</i>
     * 
     * @param devicesCount
     *            new value of {@code devicesCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code devicesCount} field changed
     */
    public DeviceConfigurationUserStatus withDevicesCount(Integer devicesCount) {
        DeviceConfigurationUserStatus _x = _copy();
        _x.changedFields = changedFields.add("devicesCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceConfigurationUserStatus");
        _x.devicesCount = devicesCount;
        return _x;
    }

    /**
     * <i>“Last modified date time of the policy report.”</i>
     * 
     * @return property lastReportedDateTime
     */
    @Property(name="lastReportedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastReportedDateTime() {
        return Optional.ofNullable(lastReportedDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * lastReportedDateTime} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Last modified date time of the policy report.”</i>
     * 
     * @param lastReportedDateTime
     *            new value of {@code lastReportedDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code lastReportedDateTime} field changed
     */
    public DeviceConfigurationUserStatus withLastReportedDateTime(OffsetDateTime lastReportedDateTime) {
        DeviceConfigurationUserStatus _x = _copy();
        _x.changedFields = changedFields.add("lastReportedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceConfigurationUserStatus");
        _x.lastReportedDateTime = lastReportedDateTime;
        return _x;
    }

    /**
     * <i>“Compliance status of the policy report.”</i>
     * 
     * @return property status
     */
    @Property(name="status")
    @JsonIgnore
    public Optional<ComplianceStatus> getStatus() {
        return Optional.ofNullable(status);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code status} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Compliance status of the policy report.”</i>
     * 
     * @param status
     *            new value of {@code status} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code status} field changed
     */
    public DeviceConfigurationUserStatus withStatus(ComplianceStatus status) {
        DeviceConfigurationUserStatus _x = _copy();
        _x.changedFields = changedFields.add("status");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceConfigurationUserStatus");
        _x.status = status;
        return _x;
    }

    /**
     * <i>“User name of the DevicePolicyStatus.”</i>
     * 
     * @return property userDisplayName
     */
    @Property(name="userDisplayName")
    @JsonIgnore
    public Optional<String> getUserDisplayName() {
        return Optional.ofNullable(userDisplayName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code userDisplayName}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“User name of the DevicePolicyStatus.”</i>
     * 
     * @param userDisplayName
     *            new value of {@code userDisplayName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code userDisplayName} field changed
     */
    public DeviceConfigurationUserStatus withUserDisplayName(String userDisplayName) {
        DeviceConfigurationUserStatus _x = _copy();
        _x.changedFields = changedFields.add("userDisplayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceConfigurationUserStatus");
        _x.userDisplayName = userDisplayName;
        return _x;
    }

    /**
     * <i>“UserPrincipalName.”</i>
     * 
     * @return property userPrincipalName
     */
    @Property(name="userPrincipalName")
    @JsonIgnore
    public Optional<String> getUserPrincipalName() {
        return Optional.ofNullable(userPrincipalName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code userPrincipalName
     * } field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“UserPrincipalName.”</i>
     * 
     * @param userPrincipalName
     *            new value of {@code userPrincipalName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code userPrincipalName} field changed
     */
    public DeviceConfigurationUserStatus withUserPrincipalName(String userPrincipalName) {
        DeviceConfigurationUserStatus _x = _copy();
        _x.changedFields = changedFields.add("userPrincipalName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceConfigurationUserStatus");
        _x.userPrincipalName = userPrincipalName;
        return _x;
    }

    public DeviceConfigurationUserStatus withUnmappedField(String name, Object value) {
        DeviceConfigurationUserStatus _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DeviceConfigurationUserStatus patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        DeviceConfigurationUserStatus _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DeviceConfigurationUserStatus put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        DeviceConfigurationUserStatus _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private DeviceConfigurationUserStatus _copy() {
        DeviceConfigurationUserStatus _x = new DeviceConfigurationUserStatus();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.devicesCount = devicesCount;
        _x.lastReportedDateTime = lastReportedDateTime;
        _x.status = status;
        _x.userDisplayName = userDisplayName;
        _x.userPrincipalName = userPrincipalName;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DeviceConfigurationUserStatus[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("devicesCount=");
        b.append(this.devicesCount);
        b.append(", ");
        b.append("lastReportedDateTime=");
        b.append(this.lastReportedDateTime);
        b.append(", ");
        b.append("status=");
        b.append(this.status);
        b.append(", ");
        b.append("userDisplayName=");
        b.append(this.userDisplayName);
        b.append(", ");
        b.append("userPrincipalName=");
        b.append(this.userPrincipalName);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
