package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "compliantUserCount", 
    "conflictUserCount", 
    "errorUserCount", 
    "nonCompliantUserCount", 
    "notApplicableUserCount", 
    "remediatedUserCount", 
    "unknownUserCount"})
@JsonInclude(Include.NON_NULL)
public class DeviceConfigurationUserStateSummary extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.deviceConfigurationUserStateSummary";
    }

    @JsonProperty("compliantUserCount")
    protected Integer compliantUserCount;

    @JsonProperty("conflictUserCount")
    protected Integer conflictUserCount;

    @JsonProperty("errorUserCount")
    protected Integer errorUserCount;

    @JsonProperty("nonCompliantUserCount")
    protected Integer nonCompliantUserCount;

    @JsonProperty("notApplicableUserCount")
    protected Integer notApplicableUserCount;

    @JsonProperty("remediatedUserCount")
    protected Integer remediatedUserCount;

    @JsonProperty("unknownUserCount")
    protected Integer unknownUserCount;

    protected DeviceConfigurationUserStateSummary() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderDeviceConfigurationUserStateSummary() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private Integer compliantUserCount;
        private Integer conflictUserCount;
        private Integer errorUserCount;
        private Integer nonCompliantUserCount;
        private Integer notApplicableUserCount;
        private Integer remediatedUserCount;
        private Integer unknownUserCount;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“Number of compliant users”</i>
         * 
         * @param compliantUserCount
         *            value of {@code compliantUserCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder compliantUserCount(Integer compliantUserCount) {
            this.compliantUserCount = compliantUserCount;
            this.changedFields = changedFields.add("compliantUserCount");
            return this;
        }

        /**
         * <i>“Number of conflict users”</i>
         * 
         * @param conflictUserCount
         *            value of {@code conflictUserCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder conflictUserCount(Integer conflictUserCount) {
            this.conflictUserCount = conflictUserCount;
            this.changedFields = changedFields.add("conflictUserCount");
            return this;
        }

        /**
         * <i>“Number of error users”</i>
         * 
         * @param errorUserCount
         *            value of {@code errorUserCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder errorUserCount(Integer errorUserCount) {
            this.errorUserCount = errorUserCount;
            this.changedFields = changedFields.add("errorUserCount");
            return this;
        }

        /**
         * <i>“Number of NonCompliant users”</i>
         * 
         * @param nonCompliantUserCount
         *            value of {@code nonCompliantUserCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder nonCompliantUserCount(Integer nonCompliantUserCount) {
            this.nonCompliantUserCount = nonCompliantUserCount;
            this.changedFields = changedFields.add("nonCompliantUserCount");
            return this;
        }

        /**
         * <i>“Number of not applicable users”</i>
         * 
         * @param notApplicableUserCount
         *            value of {@code notApplicableUserCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder notApplicableUserCount(Integer notApplicableUserCount) {
            this.notApplicableUserCount = notApplicableUserCount;
            this.changedFields = changedFields.add("notApplicableUserCount");
            return this;
        }

        /**
         * <i>“Number of remediated users”</i>
         * 
         * @param remediatedUserCount
         *            value of {@code remediatedUserCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder remediatedUserCount(Integer remediatedUserCount) {
            this.remediatedUserCount = remediatedUserCount;
            this.changedFields = changedFields.add("remediatedUserCount");
            return this;
        }

        /**
         * <i>“Number of unknown users”</i>
         * 
         * @param unknownUserCount
         *            value of {@code unknownUserCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder unknownUserCount(Integer unknownUserCount) {
            this.unknownUserCount = unknownUserCount;
            this.changedFields = changedFields.add("unknownUserCount");
            return this;
        }

        public DeviceConfigurationUserStateSummary build() {
            DeviceConfigurationUserStateSummary _x = new DeviceConfigurationUserStateSummary();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.deviceConfigurationUserStateSummary";
            _x.id = id;
            _x.compliantUserCount = compliantUserCount;
            _x.conflictUserCount = conflictUserCount;
            _x.errorUserCount = errorUserCount;
            _x.nonCompliantUserCount = nonCompliantUserCount;
            _x.notApplicableUserCount = notApplicableUserCount;
            _x.remediatedUserCount = remediatedUserCount;
            _x.unknownUserCount = unknownUserCount;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“Number of compliant users”</i>
     * 
     * @return property compliantUserCount
     */
    @Property(name="compliantUserCount")
    @JsonIgnore
    public Optional<Integer> getCompliantUserCount() {
        return Optional.ofNullable(compliantUserCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * compliantUserCount} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Number of compliant users”</i>
     * 
     * @param compliantUserCount
     *            new value of {@code compliantUserCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code compliantUserCount} field changed
     */
    public DeviceConfigurationUserStateSummary withCompliantUserCount(Integer compliantUserCount) {
        DeviceConfigurationUserStateSummary _x = _copy();
        _x.changedFields = changedFields.add("compliantUserCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceConfigurationUserStateSummary");
        _x.compliantUserCount = compliantUserCount;
        return _x;
    }

    /**
     * <i>“Number of conflict users”</i>
     * 
     * @return property conflictUserCount
     */
    @Property(name="conflictUserCount")
    @JsonIgnore
    public Optional<Integer> getConflictUserCount() {
        return Optional.ofNullable(conflictUserCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code conflictUserCount
     * } field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Number of conflict users”</i>
     * 
     * @param conflictUserCount
     *            new value of {@code conflictUserCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code conflictUserCount} field changed
     */
    public DeviceConfigurationUserStateSummary withConflictUserCount(Integer conflictUserCount) {
        DeviceConfigurationUserStateSummary _x = _copy();
        _x.changedFields = changedFields.add("conflictUserCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceConfigurationUserStateSummary");
        _x.conflictUserCount = conflictUserCount;
        return _x;
    }

    /**
     * <i>“Number of error users”</i>
     * 
     * @return property errorUserCount
     */
    @Property(name="errorUserCount")
    @JsonIgnore
    public Optional<Integer> getErrorUserCount() {
        return Optional.ofNullable(errorUserCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code errorUserCount}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Number of error users”</i>
     * 
     * @param errorUserCount
     *            new value of {@code errorUserCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code errorUserCount} field changed
     */
    public DeviceConfigurationUserStateSummary withErrorUserCount(Integer errorUserCount) {
        DeviceConfigurationUserStateSummary _x = _copy();
        _x.changedFields = changedFields.add("errorUserCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceConfigurationUserStateSummary");
        _x.errorUserCount = errorUserCount;
        return _x;
    }

    /**
     * <i>“Number of NonCompliant users”</i>
     * 
     * @return property nonCompliantUserCount
     */
    @Property(name="nonCompliantUserCount")
    @JsonIgnore
    public Optional<Integer> getNonCompliantUserCount() {
        return Optional.ofNullable(nonCompliantUserCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * nonCompliantUserCount} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Number of NonCompliant users”</i>
     * 
     * @param nonCompliantUserCount
     *            new value of {@code nonCompliantUserCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code nonCompliantUserCount} field changed
     */
    public DeviceConfigurationUserStateSummary withNonCompliantUserCount(Integer nonCompliantUserCount) {
        DeviceConfigurationUserStateSummary _x = _copy();
        _x.changedFields = changedFields.add("nonCompliantUserCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceConfigurationUserStateSummary");
        _x.nonCompliantUserCount = nonCompliantUserCount;
        return _x;
    }

    /**
     * <i>“Number of not applicable users”</i>
     * 
     * @return property notApplicableUserCount
     */
    @Property(name="notApplicableUserCount")
    @JsonIgnore
    public Optional<Integer> getNotApplicableUserCount() {
        return Optional.ofNullable(notApplicableUserCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * notApplicableUserCount} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Number of not applicable users”</i>
     * 
     * @param notApplicableUserCount
     *            new value of {@code notApplicableUserCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code notApplicableUserCount} field changed
     */
    public DeviceConfigurationUserStateSummary withNotApplicableUserCount(Integer notApplicableUserCount) {
        DeviceConfigurationUserStateSummary _x = _copy();
        _x.changedFields = changedFields.add("notApplicableUserCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceConfigurationUserStateSummary");
        _x.notApplicableUserCount = notApplicableUserCount;
        return _x;
    }

    /**
     * <i>“Number of remediated users”</i>
     * 
     * @return property remediatedUserCount
     */
    @Property(name="remediatedUserCount")
    @JsonIgnore
    public Optional<Integer> getRemediatedUserCount() {
        return Optional.ofNullable(remediatedUserCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * remediatedUserCount} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Number of remediated users”</i>
     * 
     * @param remediatedUserCount
     *            new value of {@code remediatedUserCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code remediatedUserCount} field changed
     */
    public DeviceConfigurationUserStateSummary withRemediatedUserCount(Integer remediatedUserCount) {
        DeviceConfigurationUserStateSummary _x = _copy();
        _x.changedFields = changedFields.add("remediatedUserCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceConfigurationUserStateSummary");
        _x.remediatedUserCount = remediatedUserCount;
        return _x;
    }

    /**
     * <i>“Number of unknown users”</i>
     * 
     * @return property unknownUserCount
     */
    @Property(name="unknownUserCount")
    @JsonIgnore
    public Optional<Integer> getUnknownUserCount() {
        return Optional.ofNullable(unknownUserCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code unknownUserCount}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Number of unknown users”</i>
     * 
     * @param unknownUserCount
     *            new value of {@code unknownUserCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code unknownUserCount} field changed
     */
    public DeviceConfigurationUserStateSummary withUnknownUserCount(Integer unknownUserCount) {
        DeviceConfigurationUserStateSummary _x = _copy();
        _x.changedFields = changedFields.add("unknownUserCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceConfigurationUserStateSummary");
        _x.unknownUserCount = unknownUserCount;
        return _x;
    }

    public DeviceConfigurationUserStateSummary withUnmappedField(String name, Object value) {
        DeviceConfigurationUserStateSummary _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DeviceConfigurationUserStateSummary patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        DeviceConfigurationUserStateSummary _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DeviceConfigurationUserStateSummary put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        DeviceConfigurationUserStateSummary _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private DeviceConfigurationUserStateSummary _copy() {
        DeviceConfigurationUserStateSummary _x = new DeviceConfigurationUserStateSummary();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.compliantUserCount = compliantUserCount;
        _x.conflictUserCount = conflictUserCount;
        _x.errorUserCount = errorUserCount;
        _x.nonCompliantUserCount = nonCompliantUserCount;
        _x.notApplicableUserCount = notApplicableUserCount;
        _x.remediatedUserCount = remediatedUserCount;
        _x.unknownUserCount = unknownUserCount;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DeviceConfigurationUserStateSummary[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("compliantUserCount=");
        b.append(this.compliantUserCount);
        b.append(", ");
        b.append("conflictUserCount=");
        b.append(this.conflictUserCount);
        b.append(", ");
        b.append("errorUserCount=");
        b.append(this.errorUserCount);
        b.append(", ");
        b.append("nonCompliantUserCount=");
        b.append(this.nonCompliantUserCount);
        b.append(", ");
        b.append("notApplicableUserCount=");
        b.append(this.notApplicableUserCount);
        b.append(", ");
        b.append("remediatedUserCount=");
        b.append(this.remediatedUserCount);
        b.append(", ");
        b.append("unknownUserCount=");
        b.append(this.unknownUserCount);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
