package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.entity.collection.request.DeviceComplianceActionItemCollectionRequest;


/**
 * <i>“Scheduled Action for Rule”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "ruleName", 
    "scheduledActionConfigurations"})
@JsonInclude(Include.NON_NULL)
public class DeviceComplianceScheduledActionForRule extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.deviceComplianceScheduledActionForRule";
    }

    @JsonProperty("ruleName")
    protected String ruleName;

    @JsonProperty("scheduledActionConfigurations")
    protected List<DeviceComplianceActionItem> scheduledActionConfigurations;

    protected DeviceComplianceScheduledActionForRule() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderDeviceComplianceScheduledActionForRule() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String ruleName;
        private List<DeviceComplianceActionItem> scheduledActionConfigurations;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“Name of the rule which this scheduled action applies to. Currently scheduled
         * actions are created per policy instead of per rule, thus RuleName is always set
         * to default value PasswordRequired.”</i>
         * 
         * @param ruleName
         *            value of {@code ruleName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder ruleName(String ruleName) {
            this.ruleName = ruleName;
            this.changedFields = changedFields.add("ruleName");
            return this;
        }

        /**
         * <i>“The list of scheduled action configurations for this compliance policy.
         * Compliance policy must have one and only one block scheduled action.”</i>
         * 
         * @param scheduledActionConfigurations
         *            value of {@code scheduledActionConfigurations} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder scheduledActionConfigurations(List<DeviceComplianceActionItem> scheduledActionConfigurations) {
            this.scheduledActionConfigurations = scheduledActionConfigurations;
            this.changedFields = changedFields.add("scheduledActionConfigurations");
            return this;
        }

        /**
         * <i>“The list of scheduled action configurations for this compliance policy.
         * Compliance policy must have one and only one block scheduled action.”</i>
         * 
         * @param scheduledActionConfigurations
         *            value of {@code scheduledActionConfigurations} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder scheduledActionConfigurations(DeviceComplianceActionItem... scheduledActionConfigurations) {
            return scheduledActionConfigurations(Arrays.asList(scheduledActionConfigurations));
        }

        public DeviceComplianceScheduledActionForRule build() {
            DeviceComplianceScheduledActionForRule _x = new DeviceComplianceScheduledActionForRule();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.deviceComplianceScheduledActionForRule";
            _x.id = id;
            _x.ruleName = ruleName;
            _x.scheduledActionConfigurations = scheduledActionConfigurations;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“Name of the rule which this scheduled action applies to. Currently scheduled
     * actions are created per policy instead of per rule, thus RuleName is always set
     * to default value PasswordRequired.”</i>
     * 
     * @return property ruleName
     */
    @Property(name="ruleName")
    @JsonIgnore
    public Optional<String> getRuleName() {
        return Optional.ofNullable(ruleName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code ruleName} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Name of the rule which this scheduled action applies to. Currently scheduled
     * actions are created per policy instead of per rule, thus RuleName is always set
     * to default value PasswordRequired.”</i>
     * 
     * @param ruleName
     *            new value of {@code ruleName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code ruleName} field changed
     */
    public DeviceComplianceScheduledActionForRule withRuleName(String ruleName) {
        DeviceComplianceScheduledActionForRule _x = _copy();
        _x.changedFields = changedFields.add("ruleName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceComplianceScheduledActionForRule");
        _x.ruleName = ruleName;
        return _x;
    }

    public DeviceComplianceScheduledActionForRule withUnmappedField(String name, Object value) {
        DeviceComplianceScheduledActionForRule _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    /**
     * <i>“The list of scheduled action configurations for this compliance policy.
     * Compliance policy must have one and only one block scheduled action.”</i>
     * 
     * @return navigational property scheduledActionConfigurations
     */
    @NavigationProperty(name="scheduledActionConfigurations")
    @JsonIgnore
    public DeviceComplianceActionItemCollectionRequest getScheduledActionConfigurations() {
        return new DeviceComplianceActionItemCollectionRequest(
                        contextPath.addSegment("scheduledActionConfigurations"), Optional.ofNullable(scheduledActionConfigurations));
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * scheduledActionConfigurations} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“The list of scheduled action configurations for this compliance policy.
     * Compliance policy must have one and only one block scheduled action.”</i>
     * 
     * @param scheduledActionConfigurations
     *            new value of {@code scheduledActionConfigurations} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code scheduledActionConfigurations} field changed
     */
    public DeviceComplianceScheduledActionForRule withScheduledActionConfigurations(List<DeviceComplianceActionItem> scheduledActionConfigurations) {
        DeviceComplianceScheduledActionForRule _x = _copy();
        _x.changedFields = changedFields.add("scheduledActionConfigurations");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceComplianceScheduledActionForRule");
        _x.scheduledActionConfigurations = scheduledActionConfigurations;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DeviceComplianceScheduledActionForRule patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        DeviceComplianceScheduledActionForRule _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DeviceComplianceScheduledActionForRule put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        DeviceComplianceScheduledActionForRule _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private DeviceComplianceScheduledActionForRule _copy() {
        DeviceComplianceScheduledActionForRule _x = new DeviceComplianceScheduledActionForRule();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.ruleName = ruleName;
        _x.scheduledActionConfigurations = scheduledActionConfigurations;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DeviceComplianceScheduledActionForRule[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("ruleName=");
        b.append(this.ruleName);
        b.append(", ");
        b.append("scheduledActionConfigurations=");
        b.append(this.scheduledActionConfigurations);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
