package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "compliantDeviceCount", 
    "configManagerCount", 
    "conflictDeviceCount", 
    "errorDeviceCount", 
    "inGracePeriodCount", 
    "nonCompliantDeviceCount", 
    "notApplicableDeviceCount", 
    "remediatedDeviceCount", 
    "unknownDeviceCount"})
@JsonInclude(Include.NON_NULL)
public class DeviceCompliancePolicyDeviceStateSummary extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.deviceCompliancePolicyDeviceStateSummary";
    }

    @JsonProperty("compliantDeviceCount")
    protected Integer compliantDeviceCount;

    @JsonProperty("configManagerCount")
    protected Integer configManagerCount;

    @JsonProperty("conflictDeviceCount")
    protected Integer conflictDeviceCount;

    @JsonProperty("errorDeviceCount")
    protected Integer errorDeviceCount;

    @JsonProperty("inGracePeriodCount")
    protected Integer inGracePeriodCount;

    @JsonProperty("nonCompliantDeviceCount")
    protected Integer nonCompliantDeviceCount;

    @JsonProperty("notApplicableDeviceCount")
    protected Integer notApplicableDeviceCount;

    @JsonProperty("remediatedDeviceCount")
    protected Integer remediatedDeviceCount;

    @JsonProperty("unknownDeviceCount")
    protected Integer unknownDeviceCount;

    protected DeviceCompliancePolicyDeviceStateSummary() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderDeviceCompliancePolicyDeviceStateSummary() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private Integer compliantDeviceCount;
        private Integer configManagerCount;
        private Integer conflictDeviceCount;
        private Integer errorDeviceCount;
        private Integer inGracePeriodCount;
        private Integer nonCompliantDeviceCount;
        private Integer notApplicableDeviceCount;
        private Integer remediatedDeviceCount;
        private Integer unknownDeviceCount;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“Number of compliant devices”</i>
         * 
         * @param compliantDeviceCount
         *            value of {@code compliantDeviceCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder compliantDeviceCount(Integer compliantDeviceCount) {
            this.compliantDeviceCount = compliantDeviceCount;
            this.changedFields = changedFields.add("compliantDeviceCount");
            return this;
        }

        /**
         * <i>“Number of devices that have compliance managed by System Center Configuration
         * Manager”</i>
         * 
         * @param configManagerCount
         *            value of {@code configManagerCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder configManagerCount(Integer configManagerCount) {
            this.configManagerCount = configManagerCount;
            this.changedFields = changedFields.add("configManagerCount");
            return this;
        }

        /**
         * <i>“Number of conflict devices”</i>
         * 
         * @param conflictDeviceCount
         *            value of {@code conflictDeviceCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder conflictDeviceCount(Integer conflictDeviceCount) {
            this.conflictDeviceCount = conflictDeviceCount;
            this.changedFields = changedFields.add("conflictDeviceCount");
            return this;
        }

        /**
         * <i>“Number of error devices”</i>
         * 
         * @param errorDeviceCount
         *            value of {@code errorDeviceCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder errorDeviceCount(Integer errorDeviceCount) {
            this.errorDeviceCount = errorDeviceCount;
            this.changedFields = changedFields.add("errorDeviceCount");
            return this;
        }

        /**
         * <i>“Number of devices that are in grace period”</i>
         * 
         * @param inGracePeriodCount
         *            value of {@code inGracePeriodCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder inGracePeriodCount(Integer inGracePeriodCount) {
            this.inGracePeriodCount = inGracePeriodCount;
            this.changedFields = changedFields.add("inGracePeriodCount");
            return this;
        }

        /**
         * <i>“Number of NonCompliant devices”</i>
         * 
         * @param nonCompliantDeviceCount
         *            value of {@code nonCompliantDeviceCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder nonCompliantDeviceCount(Integer nonCompliantDeviceCount) {
            this.nonCompliantDeviceCount = nonCompliantDeviceCount;
            this.changedFields = changedFields.add("nonCompliantDeviceCount");
            return this;
        }

        /**
         * <i>“Number of not applicable devices”</i>
         * 
         * @param notApplicableDeviceCount
         *            value of {@code notApplicableDeviceCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder notApplicableDeviceCount(Integer notApplicableDeviceCount) {
            this.notApplicableDeviceCount = notApplicableDeviceCount;
            this.changedFields = changedFields.add("notApplicableDeviceCount");
            return this;
        }

        /**
         * <i>“Number of remediated devices”</i>
         * 
         * @param remediatedDeviceCount
         *            value of {@code remediatedDeviceCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder remediatedDeviceCount(Integer remediatedDeviceCount) {
            this.remediatedDeviceCount = remediatedDeviceCount;
            this.changedFields = changedFields.add("remediatedDeviceCount");
            return this;
        }

        /**
         * <i>“Number of unknown devices”</i>
         * 
         * @param unknownDeviceCount
         *            value of {@code unknownDeviceCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder unknownDeviceCount(Integer unknownDeviceCount) {
            this.unknownDeviceCount = unknownDeviceCount;
            this.changedFields = changedFields.add("unknownDeviceCount");
            return this;
        }

        public DeviceCompliancePolicyDeviceStateSummary build() {
            DeviceCompliancePolicyDeviceStateSummary _x = new DeviceCompliancePolicyDeviceStateSummary();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.deviceCompliancePolicyDeviceStateSummary";
            _x.id = id;
            _x.compliantDeviceCount = compliantDeviceCount;
            _x.configManagerCount = configManagerCount;
            _x.conflictDeviceCount = conflictDeviceCount;
            _x.errorDeviceCount = errorDeviceCount;
            _x.inGracePeriodCount = inGracePeriodCount;
            _x.nonCompliantDeviceCount = nonCompliantDeviceCount;
            _x.notApplicableDeviceCount = notApplicableDeviceCount;
            _x.remediatedDeviceCount = remediatedDeviceCount;
            _x.unknownDeviceCount = unknownDeviceCount;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“Number of compliant devices”</i>
     * 
     * @return property compliantDeviceCount
     */
    @Property(name="compliantDeviceCount")
    @JsonIgnore
    public Optional<Integer> getCompliantDeviceCount() {
        return Optional.ofNullable(compliantDeviceCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * compliantDeviceCount} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Number of compliant devices”</i>
     * 
     * @param compliantDeviceCount
     *            new value of {@code compliantDeviceCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code compliantDeviceCount} field changed
     */
    public DeviceCompliancePolicyDeviceStateSummary withCompliantDeviceCount(Integer compliantDeviceCount) {
        DeviceCompliancePolicyDeviceStateSummary _x = _copy();
        _x.changedFields = changedFields.add("compliantDeviceCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceCompliancePolicyDeviceStateSummary");
        _x.compliantDeviceCount = compliantDeviceCount;
        return _x;
    }

    /**
     * <i>“Number of devices that have compliance managed by System Center Configuration
     * Manager”</i>
     * 
     * @return property configManagerCount
     */
    @Property(name="configManagerCount")
    @JsonIgnore
    public Optional<Integer> getConfigManagerCount() {
        return Optional.ofNullable(configManagerCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * configManagerCount} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Number of devices that have compliance managed by System Center Configuration
     * Manager”</i>
     * 
     * @param configManagerCount
     *            new value of {@code configManagerCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code configManagerCount} field changed
     */
    public DeviceCompliancePolicyDeviceStateSummary withConfigManagerCount(Integer configManagerCount) {
        DeviceCompliancePolicyDeviceStateSummary _x = _copy();
        _x.changedFields = changedFields.add("configManagerCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceCompliancePolicyDeviceStateSummary");
        _x.configManagerCount = configManagerCount;
        return _x;
    }

    /**
     * <i>“Number of conflict devices”</i>
     * 
     * @return property conflictDeviceCount
     */
    @Property(name="conflictDeviceCount")
    @JsonIgnore
    public Optional<Integer> getConflictDeviceCount() {
        return Optional.ofNullable(conflictDeviceCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * conflictDeviceCount} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Number of conflict devices”</i>
     * 
     * @param conflictDeviceCount
     *            new value of {@code conflictDeviceCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code conflictDeviceCount} field changed
     */
    public DeviceCompliancePolicyDeviceStateSummary withConflictDeviceCount(Integer conflictDeviceCount) {
        DeviceCompliancePolicyDeviceStateSummary _x = _copy();
        _x.changedFields = changedFields.add("conflictDeviceCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceCompliancePolicyDeviceStateSummary");
        _x.conflictDeviceCount = conflictDeviceCount;
        return _x;
    }

    /**
     * <i>“Number of error devices”</i>
     * 
     * @return property errorDeviceCount
     */
    @Property(name="errorDeviceCount")
    @JsonIgnore
    public Optional<Integer> getErrorDeviceCount() {
        return Optional.ofNullable(errorDeviceCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code errorDeviceCount}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Number of error devices”</i>
     * 
     * @param errorDeviceCount
     *            new value of {@code errorDeviceCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code errorDeviceCount} field changed
     */
    public DeviceCompliancePolicyDeviceStateSummary withErrorDeviceCount(Integer errorDeviceCount) {
        DeviceCompliancePolicyDeviceStateSummary _x = _copy();
        _x.changedFields = changedFields.add("errorDeviceCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceCompliancePolicyDeviceStateSummary");
        _x.errorDeviceCount = errorDeviceCount;
        return _x;
    }

    /**
     * <i>“Number of devices that are in grace period”</i>
     * 
     * @return property inGracePeriodCount
     */
    @Property(name="inGracePeriodCount")
    @JsonIgnore
    public Optional<Integer> getInGracePeriodCount() {
        return Optional.ofNullable(inGracePeriodCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * inGracePeriodCount} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Number of devices that are in grace period”</i>
     * 
     * @param inGracePeriodCount
     *            new value of {@code inGracePeriodCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code inGracePeriodCount} field changed
     */
    public DeviceCompliancePolicyDeviceStateSummary withInGracePeriodCount(Integer inGracePeriodCount) {
        DeviceCompliancePolicyDeviceStateSummary _x = _copy();
        _x.changedFields = changedFields.add("inGracePeriodCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceCompliancePolicyDeviceStateSummary");
        _x.inGracePeriodCount = inGracePeriodCount;
        return _x;
    }

    /**
     * <i>“Number of NonCompliant devices”</i>
     * 
     * @return property nonCompliantDeviceCount
     */
    @Property(name="nonCompliantDeviceCount")
    @JsonIgnore
    public Optional<Integer> getNonCompliantDeviceCount() {
        return Optional.ofNullable(nonCompliantDeviceCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * nonCompliantDeviceCount} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Number of NonCompliant devices”</i>
     * 
     * @param nonCompliantDeviceCount
     *            new value of {@code nonCompliantDeviceCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code nonCompliantDeviceCount} field changed
     */
    public DeviceCompliancePolicyDeviceStateSummary withNonCompliantDeviceCount(Integer nonCompliantDeviceCount) {
        DeviceCompliancePolicyDeviceStateSummary _x = _copy();
        _x.changedFields = changedFields.add("nonCompliantDeviceCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceCompliancePolicyDeviceStateSummary");
        _x.nonCompliantDeviceCount = nonCompliantDeviceCount;
        return _x;
    }

    /**
     * <i>“Number of not applicable devices”</i>
     * 
     * @return property notApplicableDeviceCount
     */
    @Property(name="notApplicableDeviceCount")
    @JsonIgnore
    public Optional<Integer> getNotApplicableDeviceCount() {
        return Optional.ofNullable(notApplicableDeviceCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * notApplicableDeviceCount} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Number of not applicable devices”</i>
     * 
     * @param notApplicableDeviceCount
     *            new value of {@code notApplicableDeviceCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code notApplicableDeviceCount} field changed
     */
    public DeviceCompliancePolicyDeviceStateSummary withNotApplicableDeviceCount(Integer notApplicableDeviceCount) {
        DeviceCompliancePolicyDeviceStateSummary _x = _copy();
        _x.changedFields = changedFields.add("notApplicableDeviceCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceCompliancePolicyDeviceStateSummary");
        _x.notApplicableDeviceCount = notApplicableDeviceCount;
        return _x;
    }

    /**
     * <i>“Number of remediated devices”</i>
     * 
     * @return property remediatedDeviceCount
     */
    @Property(name="remediatedDeviceCount")
    @JsonIgnore
    public Optional<Integer> getRemediatedDeviceCount() {
        return Optional.ofNullable(remediatedDeviceCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * remediatedDeviceCount} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Number of remediated devices”</i>
     * 
     * @param remediatedDeviceCount
     *            new value of {@code remediatedDeviceCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code remediatedDeviceCount} field changed
     */
    public DeviceCompliancePolicyDeviceStateSummary withRemediatedDeviceCount(Integer remediatedDeviceCount) {
        DeviceCompliancePolicyDeviceStateSummary _x = _copy();
        _x.changedFields = changedFields.add("remediatedDeviceCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceCompliancePolicyDeviceStateSummary");
        _x.remediatedDeviceCount = remediatedDeviceCount;
        return _x;
    }

    /**
     * <i>“Number of unknown devices”</i>
     * 
     * @return property unknownDeviceCount
     */
    @Property(name="unknownDeviceCount")
    @JsonIgnore
    public Optional<Integer> getUnknownDeviceCount() {
        return Optional.ofNullable(unknownDeviceCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * unknownDeviceCount} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Number of unknown devices”</i>
     * 
     * @param unknownDeviceCount
     *            new value of {@code unknownDeviceCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code unknownDeviceCount} field changed
     */
    public DeviceCompliancePolicyDeviceStateSummary withUnknownDeviceCount(Integer unknownDeviceCount) {
        DeviceCompliancePolicyDeviceStateSummary _x = _copy();
        _x.changedFields = changedFields.add("unknownDeviceCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceCompliancePolicyDeviceStateSummary");
        _x.unknownDeviceCount = unknownDeviceCount;
        return _x;
    }

    public DeviceCompliancePolicyDeviceStateSummary withUnmappedField(String name, Object value) {
        DeviceCompliancePolicyDeviceStateSummary _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DeviceCompliancePolicyDeviceStateSummary patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        DeviceCompliancePolicyDeviceStateSummary _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DeviceCompliancePolicyDeviceStateSummary put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        DeviceCompliancePolicyDeviceStateSummary _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private DeviceCompliancePolicyDeviceStateSummary _copy() {
        DeviceCompliancePolicyDeviceStateSummary _x = new DeviceCompliancePolicyDeviceStateSummary();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.compliantDeviceCount = compliantDeviceCount;
        _x.configManagerCount = configManagerCount;
        _x.conflictDeviceCount = conflictDeviceCount;
        _x.errorDeviceCount = errorDeviceCount;
        _x.inGracePeriodCount = inGracePeriodCount;
        _x.nonCompliantDeviceCount = nonCompliantDeviceCount;
        _x.notApplicableDeviceCount = notApplicableDeviceCount;
        _x.remediatedDeviceCount = remediatedDeviceCount;
        _x.unknownDeviceCount = unknownDeviceCount;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DeviceCompliancePolicyDeviceStateSummary[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("compliantDeviceCount=");
        b.append(this.compliantDeviceCount);
        b.append(", ");
        b.append("configManagerCount=");
        b.append(this.configManagerCount);
        b.append(", ");
        b.append("conflictDeviceCount=");
        b.append(this.conflictDeviceCount);
        b.append(", ");
        b.append("errorDeviceCount=");
        b.append(this.errorDeviceCount);
        b.append(", ");
        b.append("inGracePeriodCount=");
        b.append(this.inGracePeriodCount);
        b.append(", ");
        b.append("nonCompliantDeviceCount=");
        b.append(this.nonCompliantDeviceCount);
        b.append(", ");
        b.append("notApplicableDeviceCount=");
        b.append(this.notApplicableDeviceCount);
        b.append(", ");
        b.append("remediatedDeviceCount=");
        b.append(this.remediatedDeviceCount);
        b.append(", ");
        b.append("unknownDeviceCount=");
        b.append(this.unknownDeviceCount);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
